import{s as He,n as ze,o as Ye}from"../chunks/scheduler.1f027d5a.js";import{S as Fe,i as Ee,e as i,s as a,c as p,h as Se,a as o,d as l,b as n,f as Qe,g as M,j as r,k as de,l as Le,m as s,n as J,t as w,o as m,p as T}from"../chunks/index.5cb6ce42.js";import{C as De}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Ke,C as d}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as mt,E as Pe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Oe(ye){let y,yt,Tt,ut,h,ct,U,ht,f,Ut,b,ue='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',ft,I,ce="Suggestions are a wonderful way to make things easier and faster for your annotation team. These preselected options will make the labeling process more efficient, as they will only need to correct the suggestions. In this example, we will demonstrate how to implement a zero-shot approach using SetFit to get some initial suggestions for a dataset in Argilla that combines two text classification tasks that include a <code>LabelQuestion</code> and a <code>MultiLabelQuestion</code>.",bt,g,he='<a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a> is a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects. Using Argilla, everyone can build robust language models through faster data curation using both human and machine feedback.',It,j,Ue="Feedback is a crucial part of the data curation process, and Argilla also provides a way to manage and visualize it so that the curated data can be later used to improve a language model. In this tutorial, we will show a real example of how to make our annotators’ job easier by providing them with suggestions. To achieve this, you will learn how to train zero-shot sentiment and topic classifiers using SetFit and then use them to suggest labels for the dataset.",gt,C,fe="In this tutorial, we will follow these steps:",jt,$,be="<li>Create a dataset in Argilla.</li> <li>Train the zero-shot classifiers using SetFit.</li> <li>Get suggestions for the dataset using the trained classifiers.</li> <li>Visualize the suggestions in Argilla.</li>",Ct,Z,Ie="Let’s get started!",$t,B,Zt,W,ge='For this tutorial, you will need to have an Argilla server running. If you have already deployed Argilla, you can skip this step. Otherwise, you can quickly deploy Argilla in HF Spaces or locally following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">this guide</a>. Once you do, complete the following steps:',Bt,k,je="<li>Install the Argilla client and the required third-party libraries using <code>pip</code>:</li>",Wt,G,kt,u,Ce="<li>Make the necessary imports:</li>",Gt,R,Rt,c,$e="<li>If you are running Argilla using the Docker quickstart image or Hugging Face Spaces, you need to init the Argilla client with the <code>API_URL</code> and <code>API_KEY</code>:</li>",vt,v,Xt,X,Vt,V,Ze='In this example, we will load the <a href="https://huggingface.co/datasets/banking77" rel="nofollow">banking77</a> dataset, a popular open-source dataset that has customer requests in the banking domain.',Nt,N,_t,_,Be='Argilla works with the <code>Dataset</code> class, which easily enables you to create a dataset and manage the data and feedback. The <code>Dataset</code> has first to be configured. In the <code>Settings</code>, we can specify the <em>guidelines</em>, <em>fields</em> where the data to be annotated will be added and the <em>questions</em> for the annotators. However, more features can be added. For more information, check the <a href="https://docs.argilla.io/latest/how_to_guides/dataset/" rel="nofollow">Argilla how-to guides</a>.',xt,x,We="For our use case, we need a text field and two different questions. We will use the original labels of this dataset to make a multi-label classification of the topics mentioned in the request, and we will also set up a label question to classify the sentiment of the request as either “positive”, “neutral” or “negative”.",qt,q,At,A,Qt,Q,ke='Now, we will use the data we loaded from HF and the labels and questions we configured for our dataset to train a zero-shot text classification model for each of the questions in our dataset. As mentioned in previous sections, we will use the <a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit</a> framework for few-shot fine-tuning of Sentence Transformers in both classifiers. In addition, the model we will use is <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">all-MiniLM-L6-v2</a>, a sentence embedding model fine-tuned on a 1B sentence pairs dataset using a contrastive objective.',Ht,H,zt,z,Yt,Y,Ft,F,Et,E,Ge="Once the training step is over, we can make predictions over our data.",St,S,Lt,L,Dt,D,Kt,K,Pt,P,Re="With the data and the predictions we have produced, we can now build records (each of the data items that will be annotated by the annotator team) that include the suggestions from our models. In the case of the <code>LabelQuestion</code> we will use the label that received the highest probability score and for the <code>MultiLabelQuestion</code> we will include all labels with a score above a certain threshold. In this case, we decided to go for <code>2/len(labels)</code>, but you can experiment with your data and decide to go for a more restrictive or more lenient threshold.",Ot,O,ve="<p>Note that more lenient thresholds (closer or equal to <code>1/len(labels)</code>) will suggest more labels, and restrictive thresholds (between 2 and 3) will select fewer (or no) labels.</p>",te,tt,ee,et,le,lt,Xe="Once we are happy with the result, we can log the records to the dataset that we configured above. You can now access the dataset in Argilla and visualize the suggestions.",se,st,ae,at,Ve="This is how the UI will look like with the suggestions from our models:",ne,nt,Ne='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/snapshot_setfit_suggestions.png" alt="Feedback Task dataset with suggestions made using SetFit"/>',ie,it,_e='Optionally, you can also save and load your Argilla dataset into the Hugging Face Hub. Refer to the <a href="https://docs.argilla.io/latest/how_to_guides/import_export/#hugging-face-hub" rel="nofollow">Argilla documentation</a> for more information on how to do this.',oe,ot,pe,pt,Me,Mt,xe="In this tutorial, we have covered how to add suggestions to an Argilla dataset using a zero-shot approach with the SetFit library. This will help with the efficiency of the labelling process by lowering the number of decisions and edits that the annotation team must make.",re,rt,qe="Check out these links for more resources:",Je,Jt,Ae='<li><a href="https://docs.argilla.io/latest/" rel="nofollow">Argilla documentation</a></li> <li><a href="https://github.com/huggingface/setfit" rel="nofollow">SetFit repo on GitHub</a></li> <li><a href="https://huggingface.co/docs/setfit/index" rel="nofollow">SetFit documentation</a></li>',we,wt,me,dt,Te;return h=new Ke({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/labelling_feedback_setfit.ipynb"}]}}),U=new De({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new mt({props:{title:"Suggestions for Data Annotation with SetFit in Zero-shot Text Classification",local:"suggestions-for-data-annotation-with-setfit-in-zero-shot-text-classification",headingTag:"h1"}}),B=new mt({props:{title:"Setup",local:"setup",headingTag:"h2"}}),G=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBhcmdpbGxhJTBBIXBpcCUyMGluc3RhbGwlMjBzZXRmaXQlM0QlM0QxLjAuMyUyMHRyYW5zZm9ybWVycyUzRCUzRDQuNDAuMiUyMGh1Z2dpbmdmYWNlX2h1YiUzRCUzRDAuMjMuNQ==",highlighted:`!pip install argilla
!pip install setfit==<span class="hljs-number">1.0</span><span class="hljs-number">.3</span> transformers==<span class="hljs-number">4.40</span><span class="hljs-number">.2</span> huggingface_hub==<span class="hljs-number">0.23</span><span class="hljs-number">.5</span>`,wrap:!1}}),R=new d({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEElMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwc2V0Zml0JTIwaW1wb3J0JTIwU2V0Rml0TW9kZWwlMkMlMjBUcmFpbmVyJTJDJTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, get_templated_dataset`,wrap:!1}}),v=new d({props:{code:"JTIzJTIwUmVwbGFjZSUyMGFwaV91cmwlMjB3aXRoJTIweW91ciUyMHVybCUyMGlmJTIwdXNpbmclMjBEb2NrZXIlMEElMjMlMjBSZXBsYWNlJTIwYXBpX2tleSUyMGlmJTIweW91JTIwY29uZmlndXJlZCUyMGElMjBjdXN0b20lMjBBUEklMjBrZXklMEElMjMlMjBVbmNvbW1lbnQlMjB0aGUlMjBsYXN0JTIwbGluZSUyMGFuZCUyMHNldCUyMHlvdXIlMjBIRl9UT0tFTiUyMGlmJTIweW91ciUyMHNwYWNlJTIwaXMlMjBwcml2YXRlJTBBY2xpZW50JTIwJTNEJTIwcmcuQXJnaWxsYSglMEElMjAlMjAlMjAlMjBhcGlfdXJsJTNEJTIyaHR0cHMlM0ElMkYlMkYlNUJ5b3VyLW93bmVyLW5hbWUlNUQtJTVCeW91cl9zcGFjZV9uYW1lJTVELmhmLnNwYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiU1QnlvdXItYXBpLWtleSU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGhlYWRlcnMlM0QlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhGX1RPS0VOJTdEJTIyJTdEJTBBKQ==",highlighted:`<span class="hljs-comment"># Replace api_url with your url if using Docker</span>
<span class="hljs-comment"># Replace api_key if you configured a custom API key</span>
<span class="hljs-comment"># Uncomment the last line and set your HF_TOKEN if your space is private</span>
client = rg.Argilla(
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your_space_name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    <span class="hljs-comment"># headers={&quot;Authorization&quot;: f&quot;Bearer {HF_TOKEN}&quot;}</span>
)`,wrap:!1}}),X=new mt({props:{title:"Configure the dataset",local:"configure-the-dataset",headingTag:"h2"}}),N=new d({props:{code:"ZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZiYW5raW5nNzclMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIp",highlighted:'data = load_dataset(<span class="hljs-string">&quot;PolyAI/banking77&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)',wrap:!1}}),q=new d({props:{code:"c2V0dGluZ3MlMjAlM0QlMjByZy5TZXR0aW5ncyglMEElMjAlMjAlMjAlMjBmaWVsZHMlM0QlNUJyZy5UZXh0RmllbGQobmFtZSUzRCUyMnRleHQlMjIpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmcuTXVsdGlMYWJlbFF1ZXN0aW9uKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ0b3BpY3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCUyMlNlbGVjdCUyMHRoZSUyMHRvcGljKHMpJTIwb2YlMjB0aGUlMjByZXF1ZXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEZGF0YS5pbmZvLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aXNpYmxlX2xhYmVscyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJnLkxhYmVsUXVlc3Rpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMnNlbnRpbWVudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyV2hhdCUyMGlzJTIwdGhlJTIwc2VudGltZW50JTIwb2YlMjB0aGUlMjBtZXNzYWdlJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZXV0cmFsJTIyJTJDJTIwJTIybmVnYXRpdmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKSUwQWRhdGFzZXQlMjAlM0QlMjByZy5EYXRhc2V0KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJzZXRmaXRfdHV0b3JpYWxfZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNldHRpbmdzJTNEc2V0dGluZ3MlMkMlMEEpJTBBZGF0YXNldC5jcmVhdGUoKQ==",highlighted:`settings = rg.Settings(
    fields=[rg.TextField(name=<span class="hljs-string">&quot;text&quot;</span>)],
    questions=[
        rg.MultiLabelQuestion(
            name=<span class="hljs-string">&quot;topics&quot;</span>,
            title=<span class="hljs-string">&quot;Select the topic(s) of the request&quot;</span>,
            labels=data.info.features[<span class="hljs-string">&quot;label&quot;</span>].names,
            visible_labels=<span class="hljs-number">10</span>,
        ),
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;sentiment&quot;</span>,
            title=<span class="hljs-string">&quot;What is the sentiment of the message?&quot;</span>,
            labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;neutral&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>],
        ),
    ],
)
dataset = rg.Dataset(
    name=<span class="hljs-string">&quot;setfit_tutorial_dataset&quot;</span>,
    settings=settings,
)
dataset.create()`,wrap:!1}}),A=new mt({props:{title:"Train the models",local:"train-the-models",headingTag:"h2"}}),H=new d({props:{code:"ZGVmJTIwdHJhaW5fbW9kZWwocXVlc3Rpb25fbmFtZSUyQyUyMHRlbXBsYXRlJTJDJTIwbXVsdGlfbGFiZWwlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTIwJTNEJTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RkYXRhc2V0LnF1ZXN0aW9ucyU1QnF1ZXN0aW9uX25hbWUlNUQubGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FtcGxlX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0R0ZW1wbGF0ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG11bHRpX2xhYmVsJTNEbXVsdGlfbGFiZWwlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVHJhaW4lMjBhJTIwbW9kZWwlMjB1c2luZyUyMHRoZSUyMHRyYWluaW5nJTIwZGF0YXNldCUyMHdlJTIwanVzdCUyMGJ1aWx0JTBBJTIwJTIwJTIwJTIwaWYlMjBtdWx0aV9sYWJlbCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwU2V0Rml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmFsbC1NaW5pTE0tTDYtdjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtdWx0aV90YXJnZXRfc3RyYXRlZ3klM0QlMjJvbmUtdnMtcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiklMEElMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lcihtb2RlbCUzRG1vZGVsJTJDJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQpJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbigpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWw=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_model</span>(<span class="hljs-params">question_name, template, multi_label=<span class="hljs-literal">False</span></span>):
    train_dataset = get_templated_dataset(
        candidate_labels=dataset.questions[question_name].labels,
        sample_size=<span class="hljs-number">8</span>,
        template=template,
        multi_label=multi_label,
    )

    <span class="hljs-comment"># Train a model using the training dataset we just built</span>
    <span class="hljs-keyword">if</span> multi_label:
        model = SetFitModel.from_pretrained(
            <span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>,
            multi_target_strategy=<span class="hljs-string">&quot;one-vs-rest&quot;</span>,
        )
    <span class="hljs-keyword">else</span>:
        model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>)

    trainer = Trainer(model=model, train_dataset=train_dataset)
    trainer.train()

    <span class="hljs-keyword">return</span> model`,wrap:!1}}),z=new d({props:{code:"dG9waWNfbW9kZWwlMjAlM0QlMjB0cmFpbl9tb2RlbCglMEElMjAlMjAlMjAlMjBxdWVzdGlvbl9uYW1lJTNEJTIydG9waWNzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0QlMjJUaGUlMjBjdXN0b21lciUyMHJlcXVlc3QlMjBpcyUyMGFib3V0JTIwJTdCJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwbXVsdGlfbGFiZWwlM0RUcnVlJTJDJTBBKSUwQSUyMyUyMHRvcGljX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjMlMjAlMjAlMjAlMjAlMjAlMjIlMkZwYXRoLXRvLXlvdXItbW9kZWxzLWZvbGRlciUyRnRvcGljX21vZGVsJTIyJTBBJTIzJTIwKQ==",highlighted:`topic_model = train_model(
    question_name=<span class="hljs-string">&quot;topics&quot;</span>,
    template=<span class="hljs-string">&quot;The customer request is about {}&quot;</span>,
    multi_label=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># topic_model.save_pretrained(</span>
<span class="hljs-comment">#     &quot;/path-to-your-models-folder/topic_model&quot;</span>
<span class="hljs-comment"># )</span>`,wrap:!1}}),Y=new d({props:{code:"c2VudGltZW50X21vZGVsJTIwJTNEJTIwdHJhaW5fbW9kZWwoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25fbmFtZSUzRCUyMnNlbnRpbWVudCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRlbXBsYXRlJTNEJTIyVGhpcyUyMG1lc3NhZ2UlMjBpcyUyMCU3QiU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX2xhYmVsJTNERmFsc2UlMEEpJTBBJTIzJTIwdG9waWNfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMyUyMCUyMCUyMCUyMCUyMCUyMiUyRnBhdGgtdG8teW91ci1tb2RlbHMtZm9sZGVyJTJGc2VudGltZW50X21vZGVsJTIyJTBBJTIzJTIwKQ==",highlighted:`sentiment_model = train_model(
    question_name=<span class="hljs-string">&quot;sentiment&quot;</span>,
    template=<span class="hljs-string">&quot;This message is {}&quot;</span>,
    multi_label=<span class="hljs-literal">False</span>
)
<span class="hljs-comment"># topic_model.save_pretrained(</span>
<span class="hljs-comment">#     &quot;/path-to-your-models-folder/sentiment_model&quot;</span>
<span class="hljs-comment"># )</span>`,wrap:!1}}),F=new mt({props:{title:"Make predictions",local:"make-predictions",headingTag:"h2"}}),S=new d({props:{code:"ZGVmJTIwZ2V0X3ByZWRpY3Rpb25zKHRleHRzJTJDJTIwbW9kZWwlMkMlMjBxdWVzdGlvbl9uYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHByb2JhcyUyMCUzRCUyMG1vZGVsLnByZWRpY3RfcHJvYmEodGV4dHMlMkMlMjBhc19udW1weSUzRFRydWUpJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwZGF0YXNldC5xdWVzdGlvbnMlNUJxdWVzdGlvbl9uYW1lJTVELmxhYmVscyUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByb2JhcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTVCJTdCJTIybGFiZWwlMjIlM0ElMjBsYWJlbCUyQyUyMCUyMnNjb3JlJTIyJTNBJTIwc2NvcmUlN0QlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwcHJlZCklNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_predictions</span>(<span class="hljs-params">texts, model, question_name</span>):
    probas = model.predict_proba(texts, as_numpy=<span class="hljs-literal">True</span>)
    labels = dataset.questions[question_name].labels
    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> probas:
        <span class="hljs-keyword">yield</span> [{<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score} <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, pred)]`,wrap:!1}}),L=new d({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEubWFwKCUwQSUyMCUyMCUyMCUyMGxhbWJkYSUyMGJhdGNoJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9waWNzJTIyJTNBJTIwbGlzdChnZXRfcHJlZGljdGlvbnMoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwdG9waWNfbW9kZWwlMkMlMjAlMjJ0b3BpY3MlMjIpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNlbnRpbWVudCUyMiUzQSUyMGxpc3QoZ2V0X3ByZWRpY3Rpb25zKGJhdGNoJTVCJTIydGV4dCUyMiU1RCUyQyUyMHNlbnRpbWVudF9tb2RlbCUyQyUyMCUyMnNlbnRpbWVudCUyMikpJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEEp",highlighted:`data = data.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> batch: {
        <span class="hljs-string">&quot;topics&quot;</span>: <span class="hljs-built_in">list</span>(get_predictions(batch[<span class="hljs-string">&quot;text&quot;</span>], topic_model, <span class="hljs-string">&quot;topics&quot;</span>)),
        <span class="hljs-string">&quot;sentiment&quot;</span>: <span class="hljs-built_in">list</span>(get_predictions(batch[<span class="hljs-string">&quot;text&quot;</span>], sentiment_model, <span class="hljs-string">&quot;sentiment&quot;</span>)),
    },
    batched=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),D=new d({props:{code:"ZGF0YS50b19wYW5kYXMoKS5oZWFkKCk=",highlighted:"data.to_pandas().head()",wrap:!1}}),K=new mt({props:{title:"Log the records to Argilla",local:"log-the-records-to-argilla",headingTag:"h2"}}),tt=new d({props:{code:"ZGVmJTIwYWRkX3N1Z2dlc3Rpb25zKHJlY29yZCklM0ElMEElMjAlMjAlMjAlMjBzdWdnZXN0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMGxhYmVsJTIwd2l0aCUyMG1heCUyMHNjb3JlJTIwZm9yJTIwc2VudGltZW50JTIwcXVlc3Rpb24lMEElMjAlMjAlMjAlMjBzZW50aW1lbnQlMjAlM0QlMjBtYXgocmVjb3JkJTVCJTIyc2VudGltZW50JTIyJTVEJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIlMjJzY29yZSUyMiU1RCklNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHN1Z2dlc3Rpb25zLmFwcGVuZChyZy5TdWdnZXN0aW9uKHF1ZXN0aW9uX25hbWUlM0QlMjJzZW50aW1lbnQlMjIlMkMlMjB2YWx1ZSUzRHNlbnRpbWVudCkpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2V0JTIwYWxsJTIwbGFiZWxzJTIwYWJvdmUlMjBhJTIwdGhyZXNob2xkJTIwZm9yJTIwdG9waWNzJTIwcXVlc3Rpb25zJTBBJTIwJTIwJTIwJTIwdGhyZXNob2xkJTIwJTNEJTIwMiUyMCUyRiUyMGxlbihkYXRhc2V0LnF1ZXN0aW9ucyU1QiUyMnRvcGljcyUyMiU1RC5sYWJlbHMpJTBBJTIwJTIwJTIwJTIwdG9waWNzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWwlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjByZWNvcmQlNUIlMjJ0b3BpY3MlMjIlNUQlMjBpZiUyMGxhYmVsJTVCJTIyc2NvcmUlMjIlNUQlMjAlM0UlM0QlMjB0aHJlc2hvbGQlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjBpZiUyMHRvcGljcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1Z2dlc3Rpb25zLmFwcGVuZChyZy5TdWdnZXN0aW9uKHF1ZXN0aW9uX25hbWUlM0QlMjJ0b3BpY3MlMjIlMkMlMjB2YWx1ZSUzRHRvcGljcykpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VnZ2VzdGlvbnM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_suggestions</span>(<span class="hljs-params">record</span>):
    suggestions = []

    <span class="hljs-comment"># Get label with max score for sentiment question</span>
    sentiment = <span class="hljs-built_in">max</span>(record[<span class="hljs-string">&quot;sentiment&quot;</span>], key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;score&quot;</span>])[<span class="hljs-string">&quot;label&quot;</span>]
    suggestions.append(rg.Suggestion(question_name=<span class="hljs-string">&quot;sentiment&quot;</span>, value=sentiment))

    <span class="hljs-comment"># Get all labels above a threshold for topics questions</span>
    threshold = <span class="hljs-number">2</span> / <span class="hljs-built_in">len</span>(dataset.questions[<span class="hljs-string">&quot;topics&quot;</span>].labels)
    topics = [
        label[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> record[<span class="hljs-string">&quot;topics&quot;</span>] <span class="hljs-keyword">if</span> label[<span class="hljs-string">&quot;score&quot;</span>] &gt;= threshold
    ]
    <span class="hljs-keyword">if</span> topics:
        suggestions.append(rg.Suggestion(question_name=<span class="hljs-string">&quot;topics&quot;</span>, value=topics))
    
    <span class="hljs-keyword">return</span> suggestions`,wrap:!1}}),et=new d({props:{code:"cmVjb3JkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHJnLlJlY29yZChmaWVsZHMlM0QlN0IlMjJ0ZXh0JTIyJTNBJTIwcmVjb3JkJTVCJTIydGV4dCUyMiU1RCU3RCUyQyUyMHN1Z2dlc3Rpb25zJTNEYWRkX3N1Z2dlc3Rpb25zKHJlY29yZCkpJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVjb3JkJTIwaW4lMjBkYXRhJTBBJTVE",highlighted:`records = [
    rg.Record(fields={<span class="hljs-string">&quot;text&quot;</span>: record[<span class="hljs-string">&quot;text&quot;</span>]}, suggestions=add_suggestions(record))
    <span class="hljs-keyword">for</span> record <span class="hljs-keyword">in</span> data
]`,wrap:!1}}),st=new d({props:{code:"ZGF0YXNldC5yZWNvcmRzLmxvZyhyZWNvcmRzKQ==",highlighted:"dataset.records.log(records)",wrap:!1}}),ot=new d({props:{code:"JTIzJTIwRXhwb3J0JTIwdG8lMjBIdWdnaW5nRmFjZSUyMEh1YiUwQWRhdGFzZXQudG9faHViKHJlcG9faWQlM0QlMjJhcmdpbGxhJTJGbXlfc2V0Zml0X2RhdGFzZXQlMjIpJTBBJTBBJTIzJTIwSW1wb3J0JTIwZnJvbSUyMEh1Z2dpbmdGYWNlJTIwSHViJTBBZGF0YXNldCUyMCUzRCUyMHJnLkRhdGFzZXQuZnJvbV9odWIocmVwb19pZCUzRCUyMmFyZ2lsbGElMkZteV9zZXRmaXRfZGF0YXNldCUyMik=",highlighted:`<span class="hljs-comment"># Export to HuggingFace Hub</span>
dataset.to_hub(repo_id=<span class="hljs-string">&quot;argilla/my_setfit_dataset&quot;</span>)

<span class="hljs-comment"># Import from HuggingFace Hub</span>
dataset = rg.Dataset.from_hub(repo_id=<span class="hljs-string">&quot;argilla/my_setfit_dataset&quot;</span>)`,wrap:!1}}),pt=new mt({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),wt=new Pe({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/labelling_feedback_setfit.md"}}),{c(){y=i("meta"),yt=a(),Tt=i("p"),ut=a(),p(h.$$.fragment),ct=a(),p(U.$$.fragment),ht=a(),p(f.$$.fragment),Ut=a(),b=i("p"),b.innerHTML=ue,ft=a(),I=i("p"),I.innerHTML=ce,bt=a(),g=i("p"),g.innerHTML=he,It=a(),j=i("p"),j.textContent=Ue,gt=a(),C=i("p"),C.textContent=fe,jt=a(),$=i("ul"),$.innerHTML=be,Ct=a(),Z=i("p"),Z.textContent=Ie,$t=a(),p(B.$$.fragment),Zt=a(),W=i("p"),W.innerHTML=ge,Bt=a(),k=i("ol"),k.innerHTML=je,Wt=a(),p(G.$$.fragment),kt=a(),u=i("ol"),u.innerHTML=Ce,Gt=a(),p(R.$$.fragment),Rt=a(),c=i("ol"),c.innerHTML=$e,vt=a(),p(v.$$.fragment),Xt=a(),p(X.$$.fragment),Vt=a(),V=i("p"),V.innerHTML=Ze,Nt=a(),p(N.$$.fragment),_t=a(),_=i("p"),_.innerHTML=Be,xt=a(),x=i("p"),x.textContent=We,qt=a(),p(q.$$.fragment),At=a(),p(A.$$.fragment),Qt=a(),Q=i("p"),Q.innerHTML=ke,Ht=a(),p(H.$$.fragment),zt=a(),p(z.$$.fragment),Yt=a(),p(Y.$$.fragment),Ft=a(),p(F.$$.fragment),Et=a(),E=i("p"),E.textContent=Ge,St=a(),p(S.$$.fragment),Lt=a(),p(L.$$.fragment),Dt=a(),p(D.$$.fragment),Kt=a(),p(K.$$.fragment),Pt=a(),P=i("p"),P.innerHTML=Re,Ot=a(),O=i("blockquote"),O.innerHTML=ve,te=a(),p(tt.$$.fragment),ee=a(),p(et.$$.fragment),le=a(),lt=i("p"),lt.textContent=Xe,se=a(),p(st.$$.fragment),ae=a(),at=i("p"),at.textContent=Ve,ne=a(),nt=i("p"),nt.innerHTML=Ne,ie=a(),it=i("p"),it.innerHTML=_e,oe=a(),p(ot.$$.fragment),pe=a(),p(pt.$$.fragment),Me=a(),Mt=i("p"),Mt.textContent=xe,re=a(),rt=i("p"),rt.textContent=qe,Je=a(),Jt=i("ul"),Jt.innerHTML=Ae,we=a(),p(wt.$$.fragment),me=a(),dt=i("p"),this.h()},l(t){const e=Se("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(l),yt=n(t),Tt=o(t,"P",{}),Qe(Tt).forEach(l),ut=n(t),M(h.$$.fragment,t),ct=n(t),M(U.$$.fragment,t),ht=n(t),M(f.$$.fragment,t),Ut=n(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-gisfdz"&&(b.innerHTML=ue),ft=n(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1dz42to"&&(I.innerHTML=ce),bt=n(t),g=o(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-g9tqb5"&&(g.innerHTML=he),It=n(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-z3rep6"&&(j.textContent=Ue),gt=n(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-r5bgoa"&&(C.textContent=fe),jt=n(t),$=o(t,"UL",{"data-svelte-h":!0}),r($)!=="svelte-16uywrv"&&($.innerHTML=be),Ct=n(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-4b3xjd"&&(Z.textContent=Ie),$t=n(t),M(B.$$.fragment,t),Zt=n(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ti64gg"&&(W.innerHTML=ge),Bt=n(t),k=o(t,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-1qu2uq8"&&(k.innerHTML=je),Wt=n(t),M(G.$$.fragment,t),kt=n(t),u=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(u)!=="svelte-1y23822"&&(u.innerHTML=Ce),Gt=n(t),M(R.$$.fragment,t),Rt=n(t),c=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(c)!=="svelte-baz57d"&&(c.innerHTML=$e),vt=n(t),M(v.$$.fragment,t),Xt=n(t),M(X.$$.fragment,t),Vt=n(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vlotaw"&&(V.innerHTML=Ze),Nt=n(t),M(N.$$.fragment,t),_t=n(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-15wrcuz"&&(_.innerHTML=Be),xt=n(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1crpkkg"&&(x.textContent=We),qt=n(t),M(q.$$.fragment,t),At=n(t),M(A.$$.fragment,t),Qt=n(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-kekmap"&&(Q.innerHTML=ke),Ht=n(t),M(H.$$.fragment,t),zt=n(t),M(z.$$.fragment,t),Yt=n(t),M(Y.$$.fragment,t),Ft=n(t),M(F.$$.fragment,t),Et=n(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-16dkxgg"&&(E.textContent=Ge),St=n(t),M(S.$$.fragment,t),Lt=n(t),M(L.$$.fragment,t),Dt=n(t),M(D.$$.fragment,t),Kt=n(t),M(K.$$.fragment,t),Pt=n(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-drzh9e"&&(P.innerHTML=Re),Ot=n(t),O=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(O)!=="svelte-5ledw"&&(O.innerHTML=ve),te=n(t),M(tt.$$.fragment,t),ee=n(t),M(et.$$.fragment,t),le=n(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1auljf2"&&(lt.textContent=Xe),se=n(t),M(st.$$.fragment,t),ae=n(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-st0f7l"&&(at.textContent=Ve),ne=n(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-v1akw9"&&(nt.innerHTML=Ne),ie=n(t),it=o(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-18ajnmf"&&(it.innerHTML=_e),oe=n(t),M(ot.$$.fragment,t),pe=n(t),M(pt.$$.fragment,t),Me=n(t),Mt=o(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-18majim"&&(Mt.textContent=xe),re=n(t),rt=o(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1xmeilv"&&(rt.textContent=qe),Je=n(t),Jt=o(t,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-yirl8t"&&(Jt.innerHTML=Ae),we=n(t),M(wt.$$.fragment,t),me=n(t),dt=o(t,"P",{}),Qe(dt).forEach(l),this.h()},h(){de(y,"name","hf:doc:metadata"),de(y,"content",tl),de(u,"start","2"),de(c,"start","3")},m(t,e){Le(document.head,y),s(t,yt,e),s(t,Tt,e),s(t,ut,e),J(h,t,e),s(t,ct,e),J(U,t,e),s(t,ht,e),J(f,t,e),s(t,Ut,e),s(t,b,e),s(t,ft,e),s(t,I,e),s(t,bt,e),s(t,g,e),s(t,It,e),s(t,j,e),s(t,gt,e),s(t,C,e),s(t,jt,e),s(t,$,e),s(t,Ct,e),s(t,Z,e),s(t,$t,e),J(B,t,e),s(t,Zt,e),s(t,W,e),s(t,Bt,e),s(t,k,e),s(t,Wt,e),J(G,t,e),s(t,kt,e),s(t,u,e),s(t,Gt,e),J(R,t,e),s(t,Rt,e),s(t,c,e),s(t,vt,e),J(v,t,e),s(t,Xt,e),J(X,t,e),s(t,Vt,e),s(t,V,e),s(t,Nt,e),J(N,t,e),s(t,_t,e),s(t,_,e),s(t,xt,e),s(t,x,e),s(t,qt,e),J(q,t,e),s(t,At,e),J(A,t,e),s(t,Qt,e),s(t,Q,e),s(t,Ht,e),J(H,t,e),s(t,zt,e),J(z,t,e),s(t,Yt,e),J(Y,t,e),s(t,Ft,e),J(F,t,e),s(t,Et,e),s(t,E,e),s(t,St,e),J(S,t,e),s(t,Lt,e),J(L,t,e),s(t,Dt,e),J(D,t,e),s(t,Kt,e),J(K,t,e),s(t,Pt,e),s(t,P,e),s(t,Ot,e),s(t,O,e),s(t,te,e),J(tt,t,e),s(t,ee,e),J(et,t,e),s(t,le,e),s(t,lt,e),s(t,se,e),J(st,t,e),s(t,ae,e),s(t,at,e),s(t,ne,e),s(t,nt,e),s(t,ie,e),s(t,it,e),s(t,oe,e),J(ot,t,e),s(t,pe,e),J(pt,t,e),s(t,Me,e),s(t,Mt,e),s(t,re,e),s(t,rt,e),s(t,Je,e),s(t,Jt,e),s(t,we,e),J(wt,t,e),s(t,me,e),s(t,dt,e),Te=!0},p:ze,i(t){Te||(w(h.$$.fragment,t),w(U.$$.fragment,t),w(f.$$.fragment,t),w(B.$$.fragment,t),w(G.$$.fragment,t),w(R.$$.fragment,t),w(v.$$.fragment,t),w(X.$$.fragment,t),w(N.$$.fragment,t),w(q.$$.fragment,t),w(A.$$.fragment,t),w(H.$$.fragment,t),w(z.$$.fragment,t),w(Y.$$.fragment,t),w(F.$$.fragment,t),w(S.$$.fragment,t),w(L.$$.fragment,t),w(D.$$.fragment,t),w(K.$$.fragment,t),w(tt.$$.fragment,t),w(et.$$.fragment,t),w(st.$$.fragment,t),w(ot.$$.fragment,t),w(pt.$$.fragment,t),w(wt.$$.fragment,t),Te=!0)},o(t){m(h.$$.fragment,t),m(U.$$.fragment,t),m(f.$$.fragment,t),m(B.$$.fragment,t),m(G.$$.fragment,t),m(R.$$.fragment,t),m(v.$$.fragment,t),m(X.$$.fragment,t),m(N.$$.fragment,t),m(q.$$.fragment,t),m(A.$$.fragment,t),m(H.$$.fragment,t),m(z.$$.fragment,t),m(Y.$$.fragment,t),m(F.$$.fragment,t),m(S.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(st.$$.fragment,t),m(ot.$$.fragment,t),m(pt.$$.fragment,t),m(wt.$$.fragment,t),Te=!1},d(t){t&&(l(yt),l(Tt),l(ut),l(ct),l(ht),l(Ut),l(b),l(ft),l(I),l(bt),l(g),l(It),l(j),l(gt),l(C),l(jt),l($),l(Ct),l(Z),l($t),l(Zt),l(W),l(Bt),l(k),l(Wt),l(kt),l(u),l(Gt),l(Rt),l(c),l(vt),l(Xt),l(Vt),l(V),l(Nt),l(_t),l(_),l(xt),l(x),l(qt),l(At),l(Qt),l(Q),l(Ht),l(zt),l(Yt),l(Ft),l(Et),l(E),l(St),l(Lt),l(Dt),l(Kt),l(Pt),l(P),l(Ot),l(O),l(te),l(ee),l(le),l(lt),l(se),l(ae),l(at),l(ne),l(nt),l(ie),l(it),l(oe),l(pe),l(Me),l(Mt),l(re),l(rt),l(Je),l(Jt),l(we),l(me),l(dt)),l(y),T(h,t),T(U,t),T(f,t),T(B,t),T(G,t),T(R,t),T(v,t),T(X,t),T(N,t),T(q,t),T(A,t),T(H,t),T(z,t),T(Y,t),T(F,t),T(S,t),T(L,t),T(D,t),T(K,t),T(tt,t),T(et,t),T(st,t),T(ot,t),T(pt,t),T(wt,t)}}}const tl='{"title":"Suggestions for Data Annotation with SetFit in Zero-shot Text Classification","local":"suggestions-for-data-annotation-with-setfit-in-zero-shot-text-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Configure the dataset","local":"configure-the-dataset","sections":[],"depth":2},{"title":"Train the models","local":"train-the-models","sections":[],"depth":2},{"title":"Make predictions","local":"make-predictions","sections":[],"depth":2},{"title":"Log the records to Argilla","local":"log-the-records-to-argilla","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function el(ye){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Fe{constructor(y){super(),Ee(this,y,el,Oe,He,{})}}export{ol as component};
