import{s as _l,n as Nl,o as $l}from"../chunks/scheduler.1f027d5a.js";import{S as ql,i as kl,e as i,s as a,c as M,h as Rl,a as o,d as l,b as n,f as Xl,g as r,j as p,k as Wl,l as Ql,m as s,n as u,t as y,o as c,p as J}from"../chunks/index.5cb6ce42.js";import{C as El}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Hl,C as m}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as ve,E as Yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function zl(zt){let w,Ze,xe,Ve,h,Xe,d,We,U,_e,j,Ft='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Ne,T,At="Evaluation of Large language models (LLMs) is often a difficult endeavour: given their broad capabilities, the tasks given to them often should be judged on requirements that would be very broad, and loosely-defined. For instance, an assistant’s answer to a question can be:",$e,b,Lt="<li>not grounded in context</li> <li>repetitive, repetitive, repetitive</li> <li>grammatically incorrects</li> <li>Excessively lengthy and characterized by an overabundance of words, leading to a situation where the discourse or written content becomes overly detailed and protracted</li> <li>incoherent</li> <li>…</li>",qe,I,St="The list of criteria goes on and on. And even if we had a limited list, each of these would be hard to measure: “devising a rule-based program to assess the outputs is extremely challenging. Traditional evaluation metrics based on the similarity between outputs and reference answers (e.g., ROUGE, BLEU) are also ineffective for these questions.”",ke,f,Pt=`✅ A powerful solution to assess outputs in a human way, without requiring costly human time, is LLM-as-a-judge.
This method was introduced in <a href="https://huggingface.co/papers/2306.05685" rel="nofollow">Judging LLM-as-a-Judge with MT-Bench and Chatbot Arena</a> - which I encourage you to read.`,Re,g,Dt="💡 The idea is simple: ask an LLM to do the grading for you. 🤖✓",Qe,C,Kt="But we’ll see that it will not work well out-of-the-box: you need to set it up carefully for good results.",Ee,B,He,v,Ye,x,ze,G,Fe,Z,Ot="Let’s say you want to give an LLM a specific task, like answering open-ended questions.",Ae,V,el="The difficulty is that, as we discussed above, measuring the answer’s quality is difficult, for instance an exact string match will flag too many correct but differently worded answers as false.",Le,X,tl="You could get human labellers to judge the outputs, but this is very time-consuming for them, and if you want to update the model or the questions, you have to do it all over again.",Se,W,ll="✅ In this case you can setup a LLM-as-a-judge.",Pe,_,sl="<strong>But to use a LLM-as-a-judge, you will first need to evaluate how reliably it rates your model outputs.</strong>",De,N,al=`➡️ So the first step will be… To create a human evaluation dataset. But you can get human annotations for a few examples only - something like 30 should be enough to get a good idea of the performance.
And you will be able to re-use this dataset everytime you want to test your LLM-as-a-judge.`,Ke,$,nl='In our case, we will use <a href="https://huggingface.co/datasets/McGill-NLP/feedbackQA" rel="nofollow"><code>feedbackQA</code></a>, which contains 2 human evaluations and scores for each question/answer couple: using a sample of 30 examples will be representative of what your small evaluation dataset could be.',Oe,q,et,k,il='It’s always a good idea to compute a baseline for performance: here it can be for instance the agreement between the two human raters, as measured by the <a href="https://en.wikipedia.org/wiki/Pearson_correlation_coefficient" rel="nofollow">Pearson correlation</a> of the scores they give.',tt,R,lt,Q,ol=`Correlation between 2 human raters:
0.563
`,st,E,pl="This correlation between 2 human raters is not that good. If your human ratings are really bad, it probably means the rating criteria are not clear enough.",at,H,Ml="This means that our “ground truth” contains noise: hence we cannot expect any algorithmic evaluation to come that close to it.",nt,Y,rl="However, we could reduce this noise:",it,z,ul="<li>by taking the average score as our ground truth instead of any single score, we should even out some of the irregularities.</li> <li>by only selecting the samples where the human reviewers are in agreement.</li>",ot,F,yl="Here, we will choose the last option and <strong>only keep examples where the 2 human reviewers are in agreement</strong>.",pt,A,Mt,L,rt,S,cl="We build our LLM judge with a basic prompt, containing these elements:",ut,P,Jl="<li>task description</li> <li>scale description: <code>minimum</code>, <code>maximum</code>, value types (<code>float</code> here)</li> <li>explanation of the output format</li> <li>a beginning of an answer, to take the LLM by the hand as far as we can</li>",yt,D,ct,K,Jt,O,mt,ee,wt,te,ml=`Correlation between LLM-as-a-judge and the human raters:
0.567
`,ht,le,wl="This is not bad, given that the Pearson correlation between 2 random, independent variables would be 0!",dt,se,hl="But we easily can do better. 🔝",Ut,ae,jt,ne,dl=`As shown by <a href="https://twitter.com/aparnadhinak/status/1748368364395721128" rel="nofollow">Aparna Dhinakaran</a>, LLMs suck at evaluating outputs in continuous ranges.
<a href="https://www.databricks.com/blog/LLM-auto-eval-best-practices-RAG" rel="nofollow">This article</a> gives us a few best practices to build a better prompt:`,Tt,ie,Ul="<li>⏳ <strong>Leave more time for thought</strong> by adding an <code>Evaluation</code> field before the final answer.</li> <li>🔢 <strong>Use a small integer scale</strong> like 1-4 or 1-5 instead of a large float scale as we had previously.</li> <li>👩‍🏫 <strong>Provide an indicative scale for guidance</strong>.</li> <li>We even add a carrot to motivate the LLM!</li>",bt,oe,It,pe,ft,Me,gt,re,jl=`Correlation between LLM-as-a-judge and the human raters:
0.843
`,Ct,ue,Tl="The correlation was <strong>improved by nearly 30%</strong> with only a few tweaks to the prompt (of which  a few percentage points are due to my shameless tip to the LLM, which I hereby declare not legally binding).",Bt,ye,bl="Quite impressive! 👏",vt,ce,Il="Let’s display a few errors of our LLM judge to analyse them:",xt,Je,Gt,me,fl="The disagreements are minor: overall, we seem to have reached a good level of performance for our system!",Zt,we,Vt,he,gl="🎯 <strong>You will never reach 100%:</strong> Let’s first note that our human ground truth certainly has some noise, so agreement/correlation will never go up to 100% even with a perfect LLM judge.",Xt,de,Cl="🧭 <strong>Provide a reference:</strong> If you had access to a reference answer for each question, you should definitely give this to the Judge LLM in its prompt to get better results!",Wt,Ue,Bl="▶️ <strong>Provide few-shot examples:</strong> adding some few-shot examples of questions and ground truth evaluations in the prompt can improve the results. <em>(I tried it here, it did not improve results in this case so I skipped it, but it could work for your dataset!)</em>",_t,je,vl="➕ <strong>Additive scale:</strong> When the judgement can be split into atomic criteria, using an additive scale can further improve results: see below 👇",Nt,Te,$t,be,xl="<strong>Implement with structured generation:</strong>",qt,Ie,Gl='Using <strong>structured generation</strong>, you can configure the LLM judge to directly provide its output as a JSON with fields <code>Evaluation</code> and <code>Total rating</code>, which makes parsing easier : see our <a href="structured_generation">structured generation</a> cookbook to learn more!',kt,fe,Rt,ge,Zl="That’s all for today, congrats for following along! 🥳",Qt,Ce,Vl="I’ll have to leave you, some weirdos are banging on my door, claiming they have come on behalf of Mixtral to collect H100s. 🤔",Et,Be,Ht,Ge,Yt;return h=new Hl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/llm_judge.ipynb"}]}}),d=new El({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new ve({props:{title:"Using LLM-as-a-judge 🧑‍⚖️ for an automated and versatile evaluation",local:"using-llm-as-a-judge--for-an-automated-and-versatile-evaluation",headingTag:"h1"}}),B=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWIlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHRxZG0lMjAtcQ==",highlighted:"!pip install huggingface_hub datasets pandas tqdm -q",wrap:!1}}),v=new m({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTJDJTIwbm90ZWJvb2tfbG9naW4lMEElMEF0cWRtLnBhbmRhcygpJTIwJTIwJTIzJTIwbG9hZCUyMHRxZG0ncyUyMHBhbmRhcyUyMHN1cHBvcnQlMEFwZC5zZXRfb3B0aW9uKCUyMmRpc3BsYXkubWF4X2NvbHdpZHRoJTIyJTJDJTIwTm9uZSklMEElMEFub3RlYm9va19sb2dpbigp",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, notebook_login

tqdm.pandas()  <span class="hljs-comment"># load tqdm&#x27;s pandas support</span>
pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

notebook_login()`,wrap:!1}}),x=new m({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTBBJTBBbGxtX2NsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNEMTIwJTJDJTBBKSUwQSUwQSUyMyUyMFRlc3QlMjB5b3VyJTIwTExNJTIwY2xpZW50JTBBbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTNEJTIySG93JTIwYXJlJTIweW91JTIwdG9kYXklM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(
    model=repo_id,
    timeout=<span class="hljs-number">120</span>,
)

<span class="hljs-comment"># Test your LLM client</span>
llm_client.text_generation(prompt=<span class="hljs-string">&quot;How are you today?&quot;</span>, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),G=new ve({props:{title:"1. Prepare the creation and evaluation of our LLM judge",local:"1-prepare-the-creation-and-evaluation-of-our-llm-judge",headingTag:"h2"}}),q=new m({props:{code:"cmF0aW5ncyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJNY0dpbGwtTkxQJTJGZmVlZGJhY2tRQSUyMiklNUIlMjJ0cmFpbiUyMiU1RCUwQXJhdGluZ3MlMjAlM0QlMjBwZC5EYXRhRnJhbWUocmF0aW5ncyklMEElMEFyYXRpbmdzJTVCJTIycmV2aWV3XzElMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJyYXRpbmclMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJleHBsYW5hdGlvbl8xJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMmZlZWRiYWNrJTIyJTVELmFwcGx5KGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyZXhwbGFuYXRpb24lMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJyZXZpZXdfMiUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJmZWVkYmFjayUyMiU1RC5hcHBseShsYW1iZGElMjB4JTNBJTIweCU1QiUyMnJhdGluZyUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyU1QiUyMmV4cGxhbmF0aW9uXzIlMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJleHBsYW5hdGlvbiUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyUyMCUzRCUyMHJhdGluZ3MuZHJvcChjb2x1bW5zJTNEJTVCJTIyZmVlZGJhY2slMjIlNUQpJTBBJTBBJTIzJTIwTWFwJTIwc2NvcmVzJTIwdG8lMjBudW1lcmljJTIwdmFsdWVzJTBBY29udmVyc2lvbl9kaWN0JTIwJTNEJTIwJTdCJTIyRXhjZWxsZW50JTIyJTNBJTIwNCUyQyUyMCUyMkFjY2VwdGFibGUlMjIlM0ElMjAzJTJDJTIwJTIyQ291bGQlMjBiZSUyMEltcHJvdmVkJTIyJTNBJTIwMiUyQyUyMCUyMkJhZCUyMiUzQSUyMDElN0QlMEFyYXRpbmdzJTVCJTIyc2NvcmVfMSUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJyZXZpZXdfMSUyMiU1RC5tYXAoY29udmVyc2lvbl9kaWN0KSUwQXJhdGluZ3MlNUIlMjJzY29yZV8yJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMnJldmlld18yJTIyJTVELm1hcChjb252ZXJzaW9uX2RpY3Qp",highlighted:`ratings = load_dataset(<span class="hljs-string">&quot;McGill-NLP/feedbackQA&quot;</span>)[<span class="hljs-string">&quot;train&quot;</span>]
ratings = pd.DataFrame(ratings)

ratings[<span class="hljs-string">&quot;review_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;explanation_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;review_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">1</span>])
ratings[<span class="hljs-string">&quot;explanation_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">1</span>])
ratings = ratings.drop(columns=[<span class="hljs-string">&quot;feedback&quot;</span>])

<span class="hljs-comment"># Map scores to numeric values</span>
conversion_dict = {<span class="hljs-string">&quot;Excellent&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;Acceptable&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;Could be Improved&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;Bad&quot;</span>: <span class="hljs-number">1</span>}
ratings[<span class="hljs-string">&quot;score_1&quot;</span>] = ratings[<span class="hljs-string">&quot;review_1&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)
ratings[<span class="hljs-string">&quot;score_2&quot;</span>] = ratings[<span class="hljs-string">&quot;review_2&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)`,wrap:!1}}),R=new m({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwMiUyMGh1bWFuJTIwcmF0ZXJzJTNBJTIyKSUwQXByaW50KGYlMjIlN0JyYXRpbmdzJTVCJ3Njb3JlXzEnJTVELmNvcnIocmF0aW5ncyU1QidzY29yZV8yJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between 2 human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{ratings[<span class="hljs-string">&#x27;score_1&#x27;</span>].corr(ratings[<span class="hljs-string">&#x27;score_2&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),A=new m({props:{code:"JTIzJTIwU2FtcGxlJTIwZXhhbXBsZXMlMEFyYXRpbmdzX3doZXJlX3JhdGVyc19hZ3JlZSUyMCUzRCUyMHJhdGluZ3MubG9jJTVCcmF0aW5ncyU1QiUyMnNjb3JlXzElMjIlNUQlMjAlM0QlM0QlMjByYXRpbmdzJTVCJTIyc2NvcmVfMiUyMiU1RCU1RCUwQWV4YW1wbGVzJTIwJTNEJTIwcmF0aW5nc193aGVyZV9yYXRlcnNfYWdyZWUuZ3JvdXBieSglMjJzY29yZV8xJTIyKS5zYW1wbGUoNyUyQyUyMHJhbmRvbV9zdGF0ZSUzRDEyMTQpJTBBZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCUyMCUzRCUyMGV4YW1wbGVzJTVCJTIyc2NvcmVfMSUyMiU1RCUwQSUwQSUyMyUyMFZpc3VhbGl6ZSUyMDElMjBzYW1wbGUlMjBmb3IlMjBlYWNoJTIwc2NvcmUlMEFkaXNwbGF5KGV4YW1wbGVzLmdyb3VwYnkoJTIyaHVtYW5fc2NvcmUlMjIpLmZpcnN0KCkp",highlighted:`<span class="hljs-comment"># Sample examples</span>
ratings_where_raters_agree = ratings.loc[ratings[<span class="hljs-string">&quot;score_1&quot;</span>] == ratings[<span class="hljs-string">&quot;score_2&quot;</span>]]
examples = ratings_where_raters_agree.groupby(<span class="hljs-string">&quot;score_1&quot;</span>).sample(<span class="hljs-number">7</span>, random_state=<span class="hljs-number">1214</span>)
examples[<span class="hljs-string">&quot;human_score&quot;</span>] = examples[<span class="hljs-string">&quot;score_1&quot;</span>]

<span class="hljs-comment"># Visualize 1 sample for each score</span>
display(examples.groupby(<span class="hljs-string">&quot;human_score&quot;</span>).first())`,wrap:!1}}),L=new ve({props:{title:"2. Create our LLM judge",local:"2-create-our-llm-judge",headingTag:"h2"}}),D=new m({props:{code:"SlVER0VfUFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBWW91JTIwd2lsbCUyMGJlJTIwZ2l2ZW4lMjBhJTIwdXNlcl9xdWVzdGlvbiUyMGFuZCUyMHN5c3RlbV9hbnN3ZXIlMjBjb3VwbGUuJTBBWW91ciUyMHRhc2slMjBpcyUyMHRvJTIwcHJvdmlkZSUyMGElMjAndG90YWwlMjByYXRpbmcnJTIwc2NvcmluZyUyMGhvdyUyMHdlbGwlMjB0aGUlMjBzeXN0ZW1fYW5zd2VyJTIwYW5zd2VycyUyMHRoZSUyMHVzZXIlMjBjb25jZXJucyUyMGV4cHJlc3NlZCUyMGluJTIwdGhlJTIwdXNlcl9xdWVzdGlvbi4lMEFHaXZlJTIweW91ciUyMGFuc3dlciUyMGFzJTIwYSUyMGZsb2F0JTIwb24lMjBhJTIwc2NhbGUlMjBvZiUyMDAlMjB0byUyMDEwJTJDJTIwd2hlcmUlMjAwJTIwbWVhbnMlMjB0aGF0JTIwdGhlJTIwc3lzdGVtX2Fuc3dlciUyMGlzJTIwbm90JTIwaGVscGZ1bCUyMGF0JTIwYWxsJTJDJTIwYW5kJTIwMTAlMjBtZWFucyUyMHRoYXQlMjB0aGUlMjBhbnN3ZXIlMjBjb21wbGV0ZWx5JTIwYW5kJTIwaGVscGZ1bGx5JTIwYWRkcmVzc2VzJTIwdGhlJTIwcXVlc3Rpb24uJTBBJTBBUHJvdmlkZSUyMHlvdXIlMjBmZWVkYmFjayUyMGFzJTIwZm9sbG93cyUzQSUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAoeW91ciUyMHJhdGluZyUyQyUyMGFzJTIwYSUyMGZsb2F0JTIwYmV0d2VlbiUyMDAlMjBhbmQlMjAxMCklMEElMEFOb3clMjBoZXJlJTIwYXJlJTIwdGhlJTIwcXVlc3Rpb24lMjBhbmQlMjBhbnN3ZXIuJTBBJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUwQUFuc3dlciUzQSUyMCU3QmFuc3dlciU3RCUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAlMjIlMjIlMjI=",highlighted:`JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer as a float on a scale of 0 to 10, where 0 means that the system_answer is not helpful at all, and 10 means that the answer completely and helpfully addresses the question.

Provide your feedback as follows:

Feedback:::
Total rating: (your rating, as a float between 0 and 10)

Now here are the question and answer.

Question: {question}
Answer: {answer}

Feedback:::
Total rating: &quot;&quot;&quot;</span>`,wrap:!1}}),K=new m({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2UlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGF4aXMlM0QxJTJDJTBBKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">1000</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)`,wrap:!1}}),O=new m({props:{code:"ZGVmJTIwZXh0cmFjdF9qdWRnZV9zY29yZShhbnN3ZXIlM0ElMjBzdHIlMkMlMjBzcGxpdF9zdHIlM0ElMjBzdHIlMjAlM0QlMjAlMjJUb3RhbCUyMHJhdGluZyUzQSUyMiklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzcGxpdF9zdHIlMjBpbiUyMGFuc3dlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhdGluZyUyMCUzRCUyMGFuc3dlci5zcGxpdChzcGxpdF9zdHIpJTVCMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYXRpbmclMjAlM0QlMjBhbnN3ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaWdpdF9ncm91cHMlMjAlM0QlMjAlNUJlbC5zdHJpcCgpJTIwZm9yJTIwZWwlMjBpbiUyMHJlLmZpbmRhbGwociUyMiU1Q2QlMkIoJTNGJTNBJTVDLiU1Q2QlMkIpJTNGJTIyJTJDJTIwcmF0aW5nKSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZsb2F0KGRpZ2l0X2dyb3VwcyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTBBJTBBJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2Vfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZSUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKSUwQSUyMyUyMFJlc2NhbGUlMjB0aGUlMjBzY29yZSUyMGdpdmVuJTIwYnklMjB0aGUlMjBMTE0lMjBvbiUyMHRoZSUyMHNhbWUlMjBzY2FsZSUyMGFzJTIwdGhlJTIwaHVtYW4lMjBzY29yZSUwQWV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX3Njb3JlJTIyJTVEJTIwJTNEJTIwKGV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX3Njb3JlJTIyJTVEJTIwJTJGJTIwMTApJTIwJTJCJTIwMQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_judge_score</span>(<span class="hljs-params">answer: <span class="hljs-built_in">str</span>, split_str: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;Total rating:&quot;</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">if</span> split_str <span class="hljs-keyword">in</span> answer:
            rating = answer.split(split_str)[<span class="hljs-number">1</span>]
        <span class="hljs-keyword">else</span>:
            rating = answer
        digit_groups = [el.strip() <span class="hljs-keyword">for</span> el <span class="hljs-keyword">in</span> re.findall(<span class="hljs-string">r&quot;\\d+(?:\\.\\d+)?&quot;</span>, rating)]
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">float</span>(digit_groups[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(e)
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge&quot;</span>].apply(extract_judge_score)
<span class="hljs-comment"># Rescale the score given by the LLM on the same scale as the human score</span>
examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = (examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] / <span class="hljs-number">10</span>) + <span class="hljs-number">1</span>`,wrap:!1}}),ee=new m({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludCglMEElMjAlMjAlMjAlMjBmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ae=new ve({props:{title:"3. Improve the LLM judge",local:"3-improve-the-llm-judge",headingTag:"h2"}}),oe=new m({props:{code:"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",highlighted:`IMPROVED_JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer on a scale of 1 to 4, where 1 means that the system_answer is not helpful at all, and 4 means that the system_answer completely and helpfully addresses the user_question.

Here is the scale you should use to build your answer:
1: The system_answer is terrible: completely irrelevant to the question asked, or very partial
2: The system_answer is mostly not helpful: misses some key aspects of the question
3: The system_answer is mostly helpful: provides support, but still could be improved
4: The system_answer is excellent: relevant, direct, detailed, and addresses all the concerns raised in the question

Provide your feedback as follows:

Feedback:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 4)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here are the question and answer.

Question: {question}
Answer: {answer}

Provide your feedback. If you give a correct rating, I&#x27;ll give you 100 H100 GPUs to start your AI company.
Feedback:::
Evaluation: &quot;&quot;&quot;</span>`,wrap:!1}}),pe=new m({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWQlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESU1QUk9WRURfSlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwYXhpcyUzRDElMkMlMEEpJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiU1RC5hcHBseSglMEElMjAlMjAlMjAlMjBleHRyYWN0X2p1ZGdlX3Njb3JlJTBBKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=IMPROVED_JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">500</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)
examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>].apply(
    extract_judge_score
)`,wrap:!1}}),Me=new m({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludCglMEElMjAlMjAlMjAlMjBmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_improved_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Je=new m({props:{code:"ZXJyb3JzJTIwJTNEJTIwcGQuY29uY2F0KCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzLmxvYyU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJTIyJTVEJTIwJTNFJTIwZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RC5oZWFkKDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZXMubG9jJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0MlMjBleGFtcGxlcyU1QiUyMmh1bWFuX3Njb3JlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVELmhlYWQoMiklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGlzcGxheSglMEElMjAlMjAlMjAlMjBlcnJvcnMlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFuc3dlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1bWFuX3Njb3JlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXhwbGFuYXRpb25fMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZF9zY29yZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`errors = pd.concat(
    [
        examples.loc[
            examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &gt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]
        ].head(<span class="hljs-number">1</span>),
        examples.loc[
            examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &lt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]
        ].head(<span class="hljs-number">2</span>),
    ]
)

display(
    errors[
        [
            <span class="hljs-string">&quot;question&quot;</span>,
            <span class="hljs-string">&quot;answer&quot;</span>,
            <span class="hljs-string">&quot;human_score&quot;</span>,
            <span class="hljs-string">&quot;explanation_1&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved&quot;</span>,
        ]
    ]
)`,wrap:!1}}),we=new ve({props:{title:"4. How do we take our LLM judge even further?",local:"4-how-do-we-take-our-llm-judge-even-further",headingTag:"h2"}}),Te=new m({props:{code:"",highlighted:`ADDITIVE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
(...)
- Award 1 point if the answer is related to the question.
- Give 1 additional point if the answer is clear and precise.
- Provide 1 further point if the answer is true.
- One final point should be awarded if the answer provides additional resources to support the user.
...
&quot;&quot;&quot;</span>`,wrap:!1}}),fe=new ve({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Be=new Yl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/llm_judge.md"}}),{c(){w=i("meta"),Ze=a(),xe=i("p"),Ve=a(),M(h.$$.fragment),Xe=a(),M(d.$$.fragment),We=a(),M(U.$$.fragment),_e=a(),j=i("p"),j.innerHTML=Ft,Ne=a(),T=i("p"),T.textContent=At,$e=a(),b=i("ul"),b.innerHTML=Lt,qe=a(),I=i("p"),I.textContent=St,ke=a(),f=i("p"),f.innerHTML=Pt,Re=a(),g=i("p"),g.textContent=Dt,Qe=a(),C=i("p"),C.textContent=Kt,Ee=a(),M(B.$$.fragment),He=a(),M(v.$$.fragment),Ye=a(),M(x.$$.fragment),ze=a(),M(G.$$.fragment),Fe=a(),Z=i("p"),Z.textContent=Ot,Ae=a(),V=i("p"),V.textContent=el,Le=a(),X=i("p"),X.textContent=tl,Se=a(),W=i("p"),W.textContent=ll,Pe=a(),_=i("p"),_.innerHTML=sl,De=a(),N=i("p"),N.textContent=al,Ke=a(),$=i("p"),$.innerHTML=nl,Oe=a(),M(q.$$.fragment),et=a(),k=i("p"),k.innerHTML=il,tt=a(),M(R.$$.fragment),lt=a(),Q=i("pre"),Q.textContent=ol,st=a(),E=i("p"),E.textContent=pl,at=a(),H=i("p"),H.textContent=Ml,nt=a(),Y=i("p"),Y.textContent=rl,it=a(),z=i("ul"),z.innerHTML=ul,ot=a(),F=i("p"),F.innerHTML=yl,pt=a(),M(A.$$.fragment),Mt=a(),M(L.$$.fragment),rt=a(),S=i("p"),S.textContent=cl,ut=a(),P=i("ul"),P.innerHTML=Jl,yt=a(),M(D.$$.fragment),ct=a(),M(K.$$.fragment),Jt=a(),M(O.$$.fragment),mt=a(),M(ee.$$.fragment),wt=a(),te=i("pre"),te.textContent=ml,ht=a(),le=i("p"),le.textContent=wl,dt=a(),se=i("p"),se.textContent=hl,Ut=a(),M(ae.$$.fragment),jt=a(),ne=i("p"),ne.innerHTML=dl,Tt=a(),ie=i("ul"),ie.innerHTML=Ul,bt=a(),M(oe.$$.fragment),It=a(),M(pe.$$.fragment),ft=a(),M(Me.$$.fragment),gt=a(),re=i("pre"),re.textContent=jl,Ct=a(),ue=i("p"),ue.innerHTML=Tl,Bt=a(),ye=i("p"),ye.textContent=bl,vt=a(),ce=i("p"),ce.textContent=Il,xt=a(),M(Je.$$.fragment),Gt=a(),me=i("p"),me.textContent=fl,Zt=a(),M(we.$$.fragment),Vt=a(),he=i("p"),he.innerHTML=gl,Xt=a(),de=i("p"),de.innerHTML=Cl,Wt=a(),Ue=i("p"),Ue.innerHTML=Bl,_t=a(),je=i("p"),je.innerHTML=vl,Nt=a(),M(Te.$$.fragment),$t=a(),be=i("p"),be.innerHTML=xl,qt=a(),Ie=i("p"),Ie.innerHTML=Gl,kt=a(),M(fe.$$.fragment),Rt=a(),ge=i("p"),ge.textContent=Zl,Qt=a(),Ce=i("p"),Ce.textContent=Vl,Et=a(),M(Be.$$.fragment),Ht=a(),Ge=i("p"),this.h()},l(e){const t=Rl("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ze=n(e),xe=o(e,"P",{}),Xl(xe).forEach(l),Ve=n(e),r(h.$$.fragment,e),Xe=n(e),r(d.$$.fragment,e),We=n(e),r(U.$$.fragment,e),_e=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xlqnsv"&&(j.innerHTML=Ft),Ne=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1c6d8zi"&&(T.textContent=At),$e=n(e),b=o(e,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-19yvpia"&&(b.innerHTML=Lt),qe=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-qkxhb3"&&(I.textContent=St),ke=n(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-mjdvkr"&&(f.innerHTML=Pt),Re=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1hxfecb"&&(g.textContent=Dt),Qe=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-2ceznc"&&(C.textContent=Kt),Ee=n(e),r(B.$$.fragment,e),He=n(e),r(v.$$.fragment,e),Ye=n(e),r(x.$$.fragment,e),ze=n(e),r(G.$$.fragment,e),Fe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1pp2yf4"&&(Z.textContent=Ot),Ae=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-m5cish"&&(V.textContent=el),Le=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1s4xcl0"&&(X.textContent=tl),Se=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-ocyvof"&&(W.textContent=ll),Pe=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-ozh80s"&&(_.innerHTML=sl),De=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-2p2co4"&&(N.textContent=al),Ke=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1e0wy16"&&($.innerHTML=nl),Oe=n(e),r(q.$$.fragment,e),et=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1jhfeb5"&&(k.innerHTML=il),tt=n(e),r(R.$$.fragment,e),lt=n(e),Q=o(e,"PRE",{"data-svelte-h":!0}),p(Q)!=="svelte-es8io4"&&(Q.textContent=ol),st=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ls0opf"&&(E.textContent=pl),at=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1d3x6kj"&&(H.textContent=Ml),nt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-12akos5"&&(Y.textContent=rl),it=n(e),z=o(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1esv9k9"&&(z.innerHTML=ul),ot=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1eueglv"&&(F.innerHTML=yl),pt=n(e),r(A.$$.fragment,e),Mt=n(e),r(L.$$.fragment,e),rt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1qmq503"&&(S.textContent=cl),ut=n(e),P=o(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-109y9bk"&&(P.innerHTML=Jl),yt=n(e),r(D.$$.fragment,e),ct=n(e),r(K.$$.fragment,e),Jt=n(e),r(O.$$.fragment,e),mt=n(e),r(ee.$$.fragment,e),wt=n(e),te=o(e,"PRE",{"data-svelte-h":!0}),p(te)!=="svelte-6p10wk"&&(te.textContent=ml),ht=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1l0eo7m"&&(le.textContent=wl),dt=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-zl50r1"&&(se.textContent=hl),Ut=n(e),r(ae.$$.fragment,e),jt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-2kv0js"&&(ne.innerHTML=dl),Tt=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),p(ie)!=="svelte-1byvfqn"&&(ie.innerHTML=Ul),bt=n(e),r(oe.$$.fragment,e),It=n(e),r(pe.$$.fragment,e),ft=n(e),r(Me.$$.fragment,e),gt=n(e),re=o(e,"PRE",{"data-svelte-h":!0}),p(re)!=="svelte-1v7ry63"&&(re.textContent=jl),Ct=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1qt65cx"&&(ue.innerHTML=Tl),Bt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1uz9k2"&&(ye.textContent=bl),vt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-2se93w"&&(ce.textContent=Il),xt=n(e),r(Je.$$.fragment,e),Gt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1qclzp5"&&(me.textContent=fl),Zt=n(e),r(we.$$.fragment,e),Vt=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1o2xjbx"&&(he.innerHTML=gl),Xt=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-3qbx0g"&&(de.innerHTML=Cl),Wt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-ys5vz8"&&(Ue.innerHTML=Bl),_t=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-nftl58"&&(je.innerHTML=vl),Nt=n(e),r(Te.$$.fragment,e),$t=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-pp7myb"&&(be.innerHTML=xl),qt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-xhrhi7"&&(Ie.innerHTML=Gl),kt=n(e),r(fe.$$.fragment,e),Rt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1bt3y9y"&&(ge.textContent=Zl),Qt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-7adf3t"&&(Ce.textContent=Vl),Et=n(e),r(Be.$$.fragment,e),Ht=n(e),Ge=o(e,"P",{}),Xl(Ge).forEach(l),this.h()},h(){Wl(w,"name","hf:doc:metadata"),Wl(w,"content",Fl)},m(e,t){Ql(document.head,w),s(e,Ze,t),s(e,xe,t),s(e,Ve,t),u(h,e,t),s(e,Xe,t),u(d,e,t),s(e,We,t),u(U,e,t),s(e,_e,t),s(e,j,t),s(e,Ne,t),s(e,T,t),s(e,$e,t),s(e,b,t),s(e,qe,t),s(e,I,t),s(e,ke,t),s(e,f,t),s(e,Re,t),s(e,g,t),s(e,Qe,t),s(e,C,t),s(e,Ee,t),u(B,e,t),s(e,He,t),u(v,e,t),s(e,Ye,t),u(x,e,t),s(e,ze,t),u(G,e,t),s(e,Fe,t),s(e,Z,t),s(e,Ae,t),s(e,V,t),s(e,Le,t),s(e,X,t),s(e,Se,t),s(e,W,t),s(e,Pe,t),s(e,_,t),s(e,De,t),s(e,N,t),s(e,Ke,t),s(e,$,t),s(e,Oe,t),u(q,e,t),s(e,et,t),s(e,k,t),s(e,tt,t),u(R,e,t),s(e,lt,t),s(e,Q,t),s(e,st,t),s(e,E,t),s(e,at,t),s(e,H,t),s(e,nt,t),s(e,Y,t),s(e,it,t),s(e,z,t),s(e,ot,t),s(e,F,t),s(e,pt,t),u(A,e,t),s(e,Mt,t),u(L,e,t),s(e,rt,t),s(e,S,t),s(e,ut,t),s(e,P,t),s(e,yt,t),u(D,e,t),s(e,ct,t),u(K,e,t),s(e,Jt,t),u(O,e,t),s(e,mt,t),u(ee,e,t),s(e,wt,t),s(e,te,t),s(e,ht,t),s(e,le,t),s(e,dt,t),s(e,se,t),s(e,Ut,t),u(ae,e,t),s(e,jt,t),s(e,ne,t),s(e,Tt,t),s(e,ie,t),s(e,bt,t),u(oe,e,t),s(e,It,t),u(pe,e,t),s(e,ft,t),u(Me,e,t),s(e,gt,t),s(e,re,t),s(e,Ct,t),s(e,ue,t),s(e,Bt,t),s(e,ye,t),s(e,vt,t),s(e,ce,t),s(e,xt,t),u(Je,e,t),s(e,Gt,t),s(e,me,t),s(e,Zt,t),u(we,e,t),s(e,Vt,t),s(e,he,t),s(e,Xt,t),s(e,de,t),s(e,Wt,t),s(e,Ue,t),s(e,_t,t),s(e,je,t),s(e,Nt,t),u(Te,e,t),s(e,$t,t),s(e,be,t),s(e,qt,t),s(e,Ie,t),s(e,kt,t),u(fe,e,t),s(e,Rt,t),s(e,ge,t),s(e,Qt,t),s(e,Ce,t),s(e,Et,t),u(Be,e,t),s(e,Ht,t),s(e,Ge,t),Yt=!0},p:Nl,i(e){Yt||(y(h.$$.fragment,e),y(d.$$.fragment,e),y(U.$$.fragment,e),y(B.$$.fragment,e),y(v.$$.fragment,e),y(x.$$.fragment,e),y(G.$$.fragment,e),y(q.$$.fragment,e),y(R.$$.fragment,e),y(A.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(Je.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(fe.$$.fragment,e),y(Be.$$.fragment,e),Yt=!0)},o(e){c(h.$$.fragment,e),c(d.$$.fragment,e),c(U.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(G.$$.fragment,e),c(q.$$.fragment,e),c(R.$$.fragment,e),c(A.$$.fragment,e),c(L.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(fe.$$.fragment,e),c(Be.$$.fragment,e),Yt=!1},d(e){e&&(l(Ze),l(xe),l(Ve),l(Xe),l(We),l(_e),l(j),l(Ne),l(T),l($e),l(b),l(qe),l(I),l(ke),l(f),l(Re),l(g),l(Qe),l(C),l(Ee),l(He),l(Ye),l(ze),l(Fe),l(Z),l(Ae),l(V),l(Le),l(X),l(Se),l(W),l(Pe),l(_),l(De),l(N),l(Ke),l($),l(Oe),l(et),l(k),l(tt),l(lt),l(Q),l(st),l(E),l(at),l(H),l(nt),l(Y),l(it),l(z),l(ot),l(F),l(pt),l(Mt),l(rt),l(S),l(ut),l(P),l(yt),l(ct),l(Jt),l(mt),l(wt),l(te),l(ht),l(le),l(dt),l(se),l(Ut),l(jt),l(ne),l(Tt),l(ie),l(bt),l(It),l(ft),l(gt),l(re),l(Ct),l(ue),l(Bt),l(ye),l(vt),l(ce),l(xt),l(Gt),l(me),l(Zt),l(Vt),l(he),l(Xt),l(de),l(Wt),l(Ue),l(_t),l(je),l(Nt),l($t),l(be),l(qt),l(Ie),l(kt),l(Rt),l(ge),l(Qt),l(Ce),l(Et),l(Ht),l(Ge)),l(w),J(h,e),J(d,e),J(U,e),J(B,e),J(v,e),J(x,e),J(G,e),J(q,e),J(R,e),J(A,e),J(L,e),J(D,e),J(K,e),J(O,e),J(ee,e),J(ae,e),J(oe,e),J(pe,e),J(Me,e),J(Je,e),J(we,e),J(Te,e),J(fe,e),J(Be,e)}}}const Fl='{"title":"Using LLM-as-a-judge 🧑‍⚖️ for an automated and versatile evaluation","local":"using-llm-as-a-judge--for-an-automated-and-versatile-evaluation","sections":[{"title":"1. Prepare the creation and evaluation of our LLM judge","local":"1-prepare-the-creation-and-evaluation-of-our-llm-judge","sections":[],"depth":2},{"title":"2. Create our LLM judge","local":"2-create-our-llm-judge","sections":[],"depth":2},{"title":"3. Improve the LLM judge","local":"3-improve-the-llm-judge","sections":[],"depth":2},{"title":"4. How do we take our LLM judge even further?","local":"4-how-do-we-take-our-llm-judge-even-further","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Al(zt){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends ql{constructor(w){super(),kl(this,w,Al,zl,_l,{})}}export{Ol as component};
