import{s as ds,n as hs,o as Js}from"../chunks/scheduler.1f027d5a.js";import{S as ws,i as Ts,e as i,s as n,c as r,h as js,a as o,d as t,b as a,f as us,g as p,j as y,k as ys,l as bs,m as l,n as c,t as M,o as m,p as u}from"../chunks/index.5cb6ce42.js";import{C as Us}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Is,C as te}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as d,E as gs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function fs(Ye){let h,ae,le,ie,J,oe,w,re,T,pe,j,Fe='<em>Authored by: <a href="https://huggingface.co/AlanPonnachan" rel="nofollow">Alan Ponnachan</a></em>',ce,b,Le="This notebook demonstrates an end-to-end example of using HuatuoGPT-o1 for medical question answering with Retrieval-Augmented Generation (RAG) and reasoning. We’ll leverage the HuatuoGPT-o1 model, a medical Large Language Model (LLM) designed for advanced medical reasoning, to provide detailed and well-structured answers to medical queries.",Me,U,me,I,Pe="HuatuoGPT-o1 is a medical LLM that excels at identifying mistakes, exploring alternative strategies, and refining its answers. It utilizes verifiable medical problems and a specialized medical verifier to enhance its reasoning capabilities. This notebook showcases how to use HuatuoGPT-o1 in a RAG setting, where we retrieve relevant information from a medical knowledge base and then use the model to generate a reasoned response.",ue,g,ye,f,De="<strong>Important:</strong> Before running the code, ensure you are using a GPU runtime for faster performance. Go to <strong>“Runtime” -&gt; “Change runtime type”</strong> and select <strong>“GPU”</strong> under “Hardware accelerator.”",de,B,Ke="Let’s start by installing the necessary libraries.",he,C,Je,k,Oe=`\x1B[2K     \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m44.4/44.4 kB\x1B[0m \x1B[31m3.8 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m9.7/9.7 MB\x1B[0m \x1B[31m102.1 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m480.6/480.6 kB\x1B[0m \x1B[31m37.5 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m13.5/13.5 MB\x1B[0m \x1B[31m96.9 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m116.3/116.3 kB\x1B[0m \x1B[31m10.1 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m179.3/179.3 kB\x1B[0m \x1B[31m17.1 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m143.5/143.5 kB\x1B[0m \x1B[31m13.9 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[2K   \x1B[90m━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\x1B[0m \x1B[32m194.8/194.8 kB\x1B[0m \x1B[31m17.5 MB/s\x1B[0m eta \x1B[36m0:00:00\x1B[0m
\x1B[?25h\x1B[31mERROR: pip's dependency resolver does not currently take into account all the packages that are installed. This behaviour is the source of the following dependency conflicts.
gcsfs 2024.10.0 requires fsspec==2024.10.0, but you have fsspec 2024.9.0 which is incompatible.\x1B[0m\x1B[31m
\x1B[0m
`,we,Z,Te,v,es="We’ll use the <strong>“ChatDoctor-HealthCareMagic-100k”</strong> dataset from the Hugging Face Datasets library. This dataset contains 100,000 real-world patient-doctor interactions, providing a rich knowledge base for our RAG system.",je,G,be,V,Ue,A,ss="We need to initialize two models:",Ie,R,ts="<li><strong>HuatuoGPT-o1</strong>: The medical LLM for generating responses.</li> <li><strong>Sentence Transformer</strong>: An embedding model for creating vector representations of text, which we’ll use for retrieval.</li>",ge,x,fe,X,Be,E,ls="We’ll create a knowledge base by generating embeddings for the combined question-answer pairs from the dataset.",Ce,N,ke,z,ns=`Generating embeddings for the knowledge base...
`,Ze,$,ve,W,as="This function retrieves the <code>k</code> most relevant contexts to a given query using cosine similarity.",Ge,H,Ve,Q,Ae,q,is="This function generates a detailed response using the retrieved contexts.",Re,S,xe,_,Xe,Y,os="Let’s define a function to process a query end-to-end and then use it with an example.",Ee,F,Ne,L,rs=`Query: I've been experiencing persistent headaches and dizziness for the past week. What could be the cause?

Relevant Contexts:

Reference 1 (Similarity: 0.687):
Q: Dizziness, sometimes severe, nausea, sometimes severe. Very close to throwing up at times, but not actually doing it. Headache. No pain anywhere, and it comes and goes a couple times in a day. I v had this about a week. I am well hydrated. I v been diagnosed with vertigo years ago, but it went away years ago, and this is nothing like that was. I feel okay between episodes, but tired. I have been laying down and sleeping when it happens, and seem ok when I get back up. It s been hit and miss, meaning not everyday. I haven t changed my diet or products
A: Hello! Thank you for asking on Chat Doctor! I carefully read your question and would explain that your symptoms could be related to an inner ear disorder or an inflammatory disorder, causing the headache. Coming to this point, I would recommend consulting with an ENT specialist for a careful physical exam and labyrinthine tests to exclude possible inner ear disorder. Further, tests to be done are

Reference 2 (Similarity: 0.673):
Q: I have been having dizzy spells , bad headache I collapsed on the train the other day and went to hospital but hey couldnt find anything in my blood or brain scan the headache has been coming and going for about one month but te dizziness only started three days ago
A: Hello! Welcome and thank you for asking on Chat Doctor ! Your symptoms could be related to low blood pressure or orthostatic hypotension. An inner ear disorder can not be excluded too, considering the dizzy spells. For this reason, I would recommend first consulting with an ENT specialist for a physical check up and labyrinthine tests. Other tests to consider would be a Head Up Tilt test for orthostatic hypotension, especially if your blood pressure values Chat Doctor.  Hope you will find this answer helpful! Best wishes,

Reference 3 (Similarity: 0.672):
Q: over the past two weeks or so I have had an experience of what I believe is vertigo. The first time I was mowing my lawn on a riding tractor and made a turn in the yard and felt like I was swaying back and forth. It lasted just a few minutes and thankfully I had a good grip on the stearing wheel. The second time was today, I was sitting at my desk at work and all of a sudden it seemed as though my desk was wobbiling back and forth. It wasn t the desk it was me. The first time it happened I do not recall having a headache but today I have had just a slight headache most of the day. Any suggestions?
A: Hi, There can be many causes of vertigo. One of the most common causes is diseases associated with ear like labyrinthine (infection of the ear), vestibular neuritis (inflammation of the nerves) or BPPV (benign positional vertigo). It can also be related to diseases of brain (infection or swelling) or heart disorders (arrhythmia-rhythm disturbances) or cervical spondylosis (neck posture related issues). Besides this, there are simpler causes like anemia (low hemoglobin), hypoglycemia (low sugar), prolonged fasting, excessive heat, stress, anxiety or lack of proper sleep. Hence, I feel, first, focus on lifestyle modifications. Have a good balanced diet with lots of fruits and vegetables and less of tea and coffee. Maintain proper posture while working and sleeping, take good sleep for 7-8 hours, do some meditation or go out for a walk. If still the symptoms persist then do go for some investigations like-complete blood count, sugar levels, electrolytes, ECG, X-ray cervical spine and MRI brain. This will help us to make a proper diagnosis. Take care. Hope I have answered your question. Let me know if I can assist you further.

Generated Response:

assistant
## Thinking

Alright, let's think about this. So, we're dealing with someone who's been having these bouts of dizziness and headaches for about a week now. That sounds pretty uncomfortable. Dizziness and headaches can come from a bunch of different things, right? Like, maybe it's something to do with the inner ear, or maybe it's a bit more systemic, like a problem with blood pressure or even something neurological.

Okay, let's break it down. Inner ear problems, like vertigo, are pretty common culprits here. They can definitely cause dizziness and sometimes headaches, although they usually don't last forever. But since this person says their symptoms are hitting and missing, it might not be exactly the same as their old vertigo.

Now, let's consider the possibility of something like orthostatic hypotension. That's where your blood pressure drops when you stand up, and it can make you dizzy. But the thing is, if this were orthostatic hypotension, we'd expect the dizziness to happen every time they stand up, which isn't quite the case here. Plus, the headaches are a bit of a wildcard.

Hmm, what else could it be? Maybe anemia or hypoglycemia. Those can cause dizziness and headaches too. But again, without any major changes in diet or lifestyle, it's hard to say if that's really it.

Let's see, what else should we think about? Oh, right, the person mentions they've had their blood checked and a brain scan, but nothing showed up. That rules out a lot of serious stuff like infections or brain issues, which is good news. But it also means we have to keep looking at other possibilities.

Given all this, it seems like the best course of action is to consult an ENT specialist. They can do some tests specific to inner ear disorders, which might shed some light on what's going on. And if those tests don't reveal anything, maybe we should look into things like lifestyle changes, especially around diet and hydration.

So, in summary, it looks like we need to keep an eye on things. The dizziness and headaches could be due to an inner ear issue or something systemic. Consulting a specialist and making some lifestyle adjustments might help figure out what's causing these symptoms.

## Final Response

The symptoms of dizziness, headaches, and occasional nausea you are experiencing could be related to several underlying conditions. Based on the information provided, it appears that an inner ear disorder, such as benign paroxysmal positional vertigo (BPPV) or vestibular neuritis, is a plausible explanation. These conditions can cause episodes of dizziness and sometimes headaches, although they typically resolve on their own or improve with treatment.

Another consideration is orthostatic hypotension, which involves a drop in blood pressure upon standing, potentially causing dizziness. However, given that your symptoms do not consistently occur with changes in position, this is less likely.

Systemic factors, such as anemia or hypoglycemia, could also contribute to dizziness and headaches. Since these conditions can be influenced by dietary and lifestyle factors, maintaining a balanced diet, staying hydrated, and ensuring adequate rest may help alleviate symptoms.

To better understand the nature of your symptoms, it would be advisable to consult with an ENT specialist for a thorough examination and possibly labyrinthine tests to assess any inner ear issues. Additionally, considering a Head-Up Tilt test for orthostatic hypotension and evaluating other systemic factors through appropriate blood tests and scans could provide further insights. 

In summary, while the exact cause remains unclear, exploring options like an ENT consultation and adjusting lifestyle factors may aid in managing your symptoms.
`,ze,P,$e,D,ps="This notebook demonstrates a practical application of HuatuoGPT-o1 for medical question answering using RAG and reasoning. By combining retrieval from a relevant knowledge base with the advanced reasoning capabilities of HuatuoGPT-o1, we can build a system that provides detailed and well-structured answers to complex medical queries.",We,K,cs="You can further enhance this system by:",He,O,Ms="<li>Experimenting with different values of <code>k</code> (number of retrieved contexts).</li> <li>Fine-tuning HuatuoGPT-o1 on a specific medical domain.</li> <li>Evaluating the system’s performance using medical benchmarks.</li> <li>Adding a user interface for easier interaction.</li> <li>Improving upon existing code by handling edge cases.</li>",Qe,ee,ms="Feel free to adapt and expand upon this example to create even more powerful and helpful medical AI applications!",qe,se,Se,ne,_e;return J=new Is({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/medical_rag_and_reasoning.ipynb"}]}}),w=new Us({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new d({props:{title:"HuatuoGPT-o1 Medical RAG and Reasoning",local:"huatuogpt-o1-medical-rag-and-reasoning",headingTag:"h1"}}),U=new d({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),g=new d({props:{title:"Notebook Setup",local:"notebook-setup",headingTag:"h2"}}),C=new te({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBkYXRhc2V0cyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMHNjaWtpdC1sZWFybiUyMC0tdXBncmFkZSUyMC1x",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!pip install transformers datasets sentence-transformers scikit-learn --upgrade -q',wrap:!1}}),Z=new d({props:{title:"Load the Dataset",local:"load-the-dataset",headingTag:"h2"}}),G=new te({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJsYXZpdGElMkZDaGF0RG9jdG9yLUhlYWx0aENhcmVNYWdpYy0xMDBrJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;lavita/ChatDoctor-HealthCareMagic-100k&quot;</span>)`,wrap:!1}}),V=new d({props:{title:"Step 3: Initialize the Models",local:"step-3-initialize-the-models",headingTag:"h2"}}),x=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBJbml0aWFsaXplJTIwSHVhdHVvR1BULW8xJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkZyZWVkb21JbnRlbGxpZ2VuY2UlMkZIdWF0dW9HUFQtbzEtN0IlMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMEElMjMlMjBJbml0aWFsaXplJTIwU2VudGVuY2UlMjBUcmFuc2Zvcm1lciUwQWVtYmVkX21vZGVsJTIwJTNEJTIwU2VudGVuY2VUcmFuc2Zvcm1lciglMjJhbGwtTWluaUxNLUw2LXYyJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># Initialize HuatuoGPT-o1</span>
model_name = <span class="hljs-string">&quot;FreedomIntelligence/HuatuoGPT-o1-7B&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)
tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-comment"># Initialize Sentence Transformer</span>
embed_model = SentenceTransformer(<span class="hljs-string">&quot;all-MiniLM-L6-v2&quot;</span>)`,wrap:!1}}),X=new d({props:{title:"Prepare the Knowledge Base",local:"prepare-the-knowledge-base",headingTag:"h2"}}),N=new te({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQSUyMyUyMENvbnZlcnQlMjBkYXRhc2V0JTIwdG8lMjBEYXRhRnJhbWUlMEFkZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBJTIzJTIwQ29tYmluZSUyMHF1ZXN0aW9uJTIwYW5kJTIwYW5zd2VyJTIwZm9yJTIwY29udGV4dCUwQWRmJTVCJTIyY29tYmluZWQlMjIlNUQlMjAlM0QlMjBkZiU1QiUyMmlucHV0JTIyJTVEJTIwJTJCJTIwJTIyJTIwJTIyJTIwJTJCJTIwZGYlNUIlMjJvdXRwdXQlMjIlNUQlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGVtYmVkZGluZ3MlMEFwcmludCglMjJHZW5lcmF0aW5nJTIwZW1iZWRkaW5ncyUyMGZvciUyMHRoZSUyMGtub3dsZWRnZSUyMGJhc2UuLi4lMjIpJTBBZW1iZWRkaW5ncyUyMCUzRCUyMGVtYmVkX21vZGVsLmVuY29kZSglMEElMjAlMjAlMjAlMjBkZiU1QiUyMmNvbWJpbmVkJTIyJTVELnRvbGlzdCgpJTJDJTIwc2hvd19wcm9ncmVzc19iYXIlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDEyOCUwQSklMEFwcmludCglMjJFbWJlZGRpbmdzJTIwZ2VuZXJhdGVkISUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert dataset to DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.DataFrame(dataset[<span class="hljs-string">&quot;train&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Combine question and answer for context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df[<span class="hljs-string">&quot;combined&quot;</span>] = df[<span class="hljs-string">&quot;input&quot;</span>] + <span class="hljs-string">&quot; &quot;</span> + df[<span class="hljs-string">&quot;output&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Generating embeddings for the knowledge base...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = embed_model.encode(
<span class="hljs-meta">... </span>    df[<span class="hljs-string">&quot;combined&quot;</span>].tolist(), show_progress_bar=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">128</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Embeddings generated!&quot;</span>)`,wrap:!1}}),$=new d({props:{title:"Implement Retrieval",local:"implement-retrieval",headingTag:"h2"}}),H=new te({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sklearn.metrics.pairwise <span class="hljs-keyword">import</span> cosine_similarity

<span class="hljs-keyword">def</span> <span class="hljs-title function_">retrieve_relevant_contexts</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, k: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span></span>) -&gt; <span class="hljs-built_in">list</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Retrieves the k most relevant contexts to a given query.

    Args:
        query (str): The user&#x27;s medical query.
        k (int): The number of relevant contexts to retrieve.

    Returns:
        list: A list of dictionaries, each containing a relevant context.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Generate query embedding</span>
    query_embedding = embed_model.encode([query])[<span class="hljs-number">0</span>]

    <span class="hljs-comment"># Calculate similarities</span>
    similarities = cosine_similarity([query_embedding], embeddings)[<span class="hljs-number">0</span>]

    <span class="hljs-comment"># Get top k similar contexts</span>
    top_k_indices = np.argsort(similarities)[-k:][::-<span class="hljs-number">1</span>]

    contexts = []
    <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> top_k_indices:
        contexts.append(
            {
                <span class="hljs-string">&quot;question&quot;</span>: df.iloc[idx][<span class="hljs-string">&quot;input&quot;</span>],
                <span class="hljs-string">&quot;answer&quot;</span>: df.iloc[idx][<span class="hljs-string">&quot;output&quot;</span>],
                <span class="hljs-string">&quot;similarity&quot;</span>: similarities[idx],
            }
        )

    <span class="hljs-keyword">return</span> contexts`,wrap:!1}}),Q=new d({props:{title:"Implement Response Generation",local:"implement-response-generation",headingTag:"h2"}}),S=new te({props:{code:"ZGVmJTIwZ2VuZXJhdGVfc3RydWN0dXJlZF9yZXNwb25zZShxdWVyeSUzQSUyMHN0ciUyQyUyMGNvbnRleHRzJTNBJTIwbGlzdCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwR2VuZXJhdGVzJTIwYSUyMGRldGFpbGVkJTIwcmVzcG9uc2UlMjB1c2luZyUyMHRoZSUyMHJldHJpZXZlZCUyMGNvbnRleHRzLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUyMChzdHIpJTNBJTIwVGhlJTIwdXNlcidzJTIwbWVkaWNhbCUyMHF1ZXJ5LiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRleHRzJTIwKGxpc3QpJTNBJTIwQSUyMGxpc3QlMjBvZiUyMHJlbGV2YW50JTIwY29udGV4dHMuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0ciUzQSUyMFRoZSUyMGdlbmVyYXRlZCUyMHJlc3BvbnNlLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMyUyMFByZXBhcmUlMjBwcm9tcHQlMjB3aXRoJTIwcmV0cmlldmVkJTIwY29udGV4dHMlMEElMjAlMjAlMjAlMjBjb250ZXh0X3Byb21wdCUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyUmVmZXJlbmNlJTIwJTdCaSUyQjElN0QlM0ElMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTVDblF1ZXN0aW9uJTNBJTIwJTdCY3R4JTVCJ3F1ZXN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlNUNuQW5zd2VyJTNBJTIwJTdCY3R4JTVCJ2Fuc3dlciclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTJDJTIwY3R4JTIwaW4lMjBlbnVtZXJhdGUoY29udGV4dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGYlMjIlMjIlMjJCYXNlZCUyMG9uJTIwdGhlJTIwZm9sbG93aW5nJTIwcmVmZXJlbmNlcyUyMGFuZCUyMHlvdXIlMjBtZWRpY2FsJTIwa25vd2xlZGdlJTJDJTIwcHJvdmlkZSUyMGElMjBkZXRhaWxlZCUyMHJlc3BvbnNlJTNBJTBBJTBBUmVmZXJlbmNlcyUzQSUwQSU3QmNvbnRleHRfcHJvbXB0JTdEJTBBJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVyeSU3RCUwQSUwQUJ5JTIwY29uc2lkZXJpbmclM0ElMEExLiUyMFRoZSUyMGtleSUyMG1lZGljYWwlMjBjb25jZXB0cyUyMGluJTIwdGhlJTIwcXVlc3Rpb24uJTBBMi4lMjBIb3clMjB0aGUlMjByZWZlcmVuY2UlMjBjYXNlcyUyMHJlbGF0ZSUyMHRvJTIwdGhpcyUyMHF1ZXN0aW9uLiUwQTMuJTIwV2hhdCUyMG1lZGljYWwlMjBwcmluY2lwbGVzJTIwc2hvdWxkJTIwYmUlMjBhcHBsaWVkLiUwQTQuJTIwQW55JTIwcG90ZW50aWFsJTIwY29tcGxpY2F0aW9ucyUyMG9yJTIwY29uc2lkZXJhdGlvbnMuJTBBJTBBR2l2ZSUyMHRoZSUyMGZpbmFsJTIwcmVzcG9uc2UlM0ElMEElMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMHJlc3BvbnNlJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQlN0QlNUQlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fYmVhbXMlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwdGhlJTIwZmluYWwlMjByZXNwb25zZSUyMHBvcnRpb24lMEElMjAlMjAlMjAlMjBmaW5hbF9yZXNwb25zZSUyMCUzRCUyMHJlc3BvbnNlLnNwbGl0KCUyMkdpdmUlMjB0aGUlMjBmaW5hbCUyMHJlc3BvbnNlJTNBJTVDbiUyMiklNUItMSU1RCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGZpbmFsX3Jlc3BvbnNl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_structured_response</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, contexts: <span class="hljs-built_in">list</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Generates a detailed response using the retrieved contexts.

    Args:
        query (str): The user&#x27;s medical query.
        contexts (list): A list of relevant contexts.

    Returns:
        str: The generated response.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Prepare prompt with retrieved contexts</span>
    context_prompt = <span class="hljs-string">&quot;\\n&quot;</span>.join(
        [
            <span class="hljs-string">f&quot;Reference <span class="hljs-subst">{i+<span class="hljs-number">1</span>}</span>:&quot;</span>
            <span class="hljs-string">f&quot;\\nQuestion: <span class="hljs-subst">{ctx[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>&quot;</span>
            <span class="hljs-string">f&quot;\\nAnswer: <span class="hljs-subst">{ctx[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
            <span class="hljs-keyword">for</span> i, ctx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(contexts)
        ]
    )

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Based on the following references and your medical knowledge, provide a detailed response:

References:
<span class="hljs-subst">{context_prompt}</span>

Question: <span class="hljs-subst">{query}</span>

By considering:
1. The key medical concepts in the question.
2. How the reference cases relate to this question.
3. What medical principles should be applied.
4. Any potential complications or considerations.

Give the final response:
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Generate response</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    inputs = tokenizer(
        tokenizer.apply_chat_template(
            messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>
        ),
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    ).to(model.device)

    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">1024</span>,
        temperature=<span class="hljs-number">0.7</span>,
        num_beams=<span class="hljs-number">1</span>,
        do_sample=<span class="hljs-literal">True</span>,
    )

    response = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># Extract the final response portion</span>
    final_response = response.split(<span class="hljs-string">&quot;Give the final response:\\n&quot;</span>)[-<span class="hljs-number">1</span>]

    <span class="hljs-keyword">return</span> final_response`,wrap:!1}}),_=new d({props:{title:"Putting It All Together",local:"putting-it-all-together",headingTag:"h2"}}),F=new te({props:{code:"ZGVmJTIwcHJvY2Vzc19xdWVyeShxdWVyeSUzQSUyMHN0ciUyQyUyMGslM0ElMjBpbnQlMjAlM0QlMjAzKSUyMC0lM0UlMjB0dXBsZSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFByb2Nlc3NlcyUyMGElMjBtZWRpY2FsJTIwcXVlcnklMjBlbmQtdG8tZW5kLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUyMChzdHIpJTNBJTIwVGhlJTIwdXNlcidzJTIwbWVkaWNhbCUyMHF1ZXJ5LiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGslMjAoaW50KSUzQSUyMFRoZSUyMG51bWJlciUyMG9mJTIwcmVsZXZhbnQlMjBjb250ZXh0cyUyMHRvJTIwcmV0cmlldmUuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR1cGxlJTNBJTIwVGhlJTIwZ2VuZXJhdGVkJTIwcmVzcG9uc2UlMjBhbmQlMjB0aGUlMjByZXRyaWV2ZWQlMjBjb250ZXh0cy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjb250ZXh0cyUyMCUzRCUyMHJldHJpZXZlX3JlbGV2YW50X2NvbnRleHRzKHF1ZXJ5JTJDJTIwayklMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGdlbmVyYXRlX3N0cnVjdHVyZWRfcmVzcG9uc2UocXVlcnklMkMlMjBjb250ZXh0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZSUyQyUyMGNvbnRleHRzJTBBJTBBJTIzJTIwRXhhbXBsZSUyMHF1ZXJ5JTBBcXVlcnklMjAlM0QlMjAlMjJJJ3ZlJTIwYmVlbiUyMGV4cGVyaWVuY2luZyUyMHBlcnNpc3RlbnQlMjBoZWFkYWNoZXMlMjBhbmQlMjBkaXp6aW5lc3MlMjBmb3IlMjB0aGUlMjBwYXN0JTIwd2Vlay4lMjBXaGF0JTIwY291bGQlMjBiZSUyMHRoZSUyMGNhdXNlJTNGJTIyJTBBJTBBJTIzJTIwUHJvY2VzcyUyMHF1ZXJ5JTBBcmVzcG9uc2UlMkMlMjBjb250ZXh0cyUyMCUzRCUyMHByb2Nlc3NfcXVlcnkocXVlcnkpJTBBJTBBJTIzJTIwUHJpbnQlMjByZXN1bHRzJTBBcHJpbnQoJTIyJTVDblF1ZXJ5JTNBJTIyJTJDJTIwcXVlcnkpJTBBcHJpbnQoJTIyJTVDblJlbGV2YW50JTIwQ29udGV4dHMlM0ElMjIpJTBBZm9yJTIwaSUyQyUyMGN0eCUyMGluJTIwZW51bWVyYXRlKGNvbnRleHRzJTJDJTIwMSklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTVDblJlZmVyZW5jZSUyMCU3QmklN0QlMjAoU2ltaWxhcml0eSUzQSUyMCU3QmN0eCU1QidzaW1pbGFyaXR5JyU1RCUzQS4zZiU3RCklM0ElMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlElM0ElMjAlN0JjdHglNUIncXVlc3Rpb24nJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBJTNBJTIwJTdCY3R4JTVCJ2Fuc3dlciclNUQlN0QlMjIpJTBBJTBBcHJpbnQoJTIyJTVDbkdlbmVyYXRlZCUyMFJlc3BvbnNlJTNBJTIyKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">process_query</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, k: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span></span>) -&gt; <span class="hljs-built_in">tuple</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Processes a medical query end-to-end.

<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        query (str): The user&#x27;s medical query.
<span class="hljs-meta">... </span>        k (int): The number of relevant contexts to retrieve.

<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        tuple: The generated response and the retrieved contexts.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    contexts = retrieve_relevant_contexts(query, k)
<span class="hljs-meta">... </span>    response = generate_structured_response(query, contexts)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> response, contexts

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example query</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;I&#x27;ve been experiencing persistent headaches and dizziness for the past week. What could be the cause?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Process query</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response, contexts = process_query(query)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nQuery:&quot;</span>, query)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nRelevant Contexts:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, ctx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(contexts, <span class="hljs-number">1</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nReference <span class="hljs-subst">{i}</span> (Similarity: <span class="hljs-subst">{ctx[<span class="hljs-string">&#x27;similarity&#x27;</span>]:<span class="hljs-number">.3</span>f}</span>):&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Q: <span class="hljs-subst">{ctx[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;A: <span class="hljs-subst">{ctx[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nGenerated Response:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)`,wrap:!1}}),P=new d({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),se=new gs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/medical_rag_and_reasoning.md"}}),{c(){h=i("meta"),ae=n(),le=i("p"),ie=n(),r(J.$$.fragment),oe=n(),r(w.$$.fragment),re=n(),r(T.$$.fragment),pe=n(),j=i("p"),j.innerHTML=Fe,ce=n(),b=i("p"),b.textContent=Le,Me=n(),r(U.$$.fragment),me=n(),I=i("p"),I.textContent=Pe,ue=n(),r(g.$$.fragment),ye=n(),f=i("p"),f.innerHTML=De,de=n(),B=i("p"),B.textContent=Ke,he=n(),r(C.$$.fragment),Je=n(),k=i("pre"),k.textContent=Oe,we=n(),r(Z.$$.fragment),Te=n(),v=i("p"),v.innerHTML=es,je=n(),r(G.$$.fragment),be=n(),r(V.$$.fragment),Ue=n(),A=i("p"),A.textContent=ss,Ie=n(),R=i("ol"),R.innerHTML=ts,ge=n(),r(x.$$.fragment),fe=n(),r(X.$$.fragment),Be=n(),E=i("p"),E.textContent=ls,Ce=n(),r(N.$$.fragment),ke=n(),z=i("pre"),z.textContent=ns,Ze=n(),r($.$$.fragment),ve=n(),W=i("p"),W.innerHTML=as,Ge=n(),r(H.$$.fragment),Ve=n(),r(Q.$$.fragment),Ae=n(),q=i("p"),q.textContent=is,Re=n(),r(S.$$.fragment),xe=n(),r(_.$$.fragment),Xe=n(),Y=i("p"),Y.textContent=os,Ee=n(),r(F.$$.fragment),Ne=n(),L=i("pre"),L.textContent=rs,ze=n(),r(P.$$.fragment),$e=n(),D=i("p"),D.textContent=ps,We=n(),K=i("p"),K.textContent=cs,He=n(),O=i("ul"),O.innerHTML=Ms,Qe=n(),ee=i("p"),ee.textContent=ms,qe=n(),r(se.$$.fragment),Se=n(),ne=i("p"),this.h()},l(e){const s=js("svelte-u9bgzb",document.head);h=o(s,"META",{name:!0,content:!0}),s.forEach(t),ae=a(e),le=o(e,"P",{}),us(le).forEach(t),ie=a(e),p(J.$$.fragment,e),oe=a(e),p(w.$$.fragment,e),re=a(e),p(T.$$.fragment,e),pe=a(e),j=o(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-c06g5p"&&(j.innerHTML=Fe),ce=a(e),b=o(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-j9aasz"&&(b.textContent=Le),Me=a(e),p(U.$$.fragment,e),me=a(e),I=o(e,"P",{"data-svelte-h":!0}),y(I)!=="svelte-119kv3n"&&(I.textContent=Pe),ue=a(e),p(g.$$.fragment,e),ye=a(e),f=o(e,"P",{"data-svelte-h":!0}),y(f)!=="svelte-12pyfc3"&&(f.innerHTML=De),de=a(e),B=o(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-45cp8q"&&(B.textContent=Ke),he=a(e),p(C.$$.fragment,e),Je=a(e),k=o(e,"PRE",{"data-svelte-h":!0}),y(k)!=="svelte-basfa0"&&(k.textContent=Oe),we=a(e),p(Z.$$.fragment,e),Te=a(e),v=o(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1ti8tz6"&&(v.innerHTML=es),je=a(e),p(G.$$.fragment,e),be=a(e),p(V.$$.fragment,e),Ue=a(e),A=o(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-104j7az"&&(A.textContent=ss),Ie=a(e),R=o(e,"OL",{"data-svelte-h":!0}),y(R)!=="svelte-9yw32o"&&(R.innerHTML=ts),ge=a(e),p(x.$$.fragment,e),fe=a(e),p(X.$$.fragment,e),Be=a(e),E=o(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-7f64xe"&&(E.textContent=ls),Ce=a(e),p(N.$$.fragment,e),ke=a(e),z=o(e,"PRE",{"data-svelte-h":!0}),y(z)!=="svelte-1wdi9gd"&&(z.textContent=ns),Ze=a(e),p($.$$.fragment,e),ve=a(e),W=o(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-i7jwdv"&&(W.innerHTML=as),Ge=a(e),p(H.$$.fragment,e),Ve=a(e),p(Q.$$.fragment,e),Ae=a(e),q=o(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-5y0n3h"&&(q.textContent=is),Re=a(e),p(S.$$.fragment,e),xe=a(e),p(_.$$.fragment,e),Xe=a(e),Y=o(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-3j3j7m"&&(Y.textContent=os),Ee=a(e),p(F.$$.fragment,e),Ne=a(e),L=o(e,"PRE",{"data-svelte-h":!0}),y(L)!=="svelte-8zhoxs"&&(L.textContent=rs),ze=a(e),p(P.$$.fragment,e),$e=a(e),D=o(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-16zwpez"&&(D.textContent=ps),We=a(e),K=o(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-zyvk3h"&&(K.textContent=cs),He=a(e),O=o(e,"UL",{"data-svelte-h":!0}),y(O)!=="svelte-pze9ms"&&(O.innerHTML=Ms),Qe=a(e),ee=o(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-cxhq56"&&(ee.textContent=ms),qe=a(e),p(se.$$.fragment,e),Se=a(e),ne=o(e,"P",{}),us(ne).forEach(t),this.h()},h(){ys(h,"name","hf:doc:metadata"),ys(h,"content",Bs)},m(e,s){bs(document.head,h),l(e,ae,s),l(e,le,s),l(e,ie,s),c(J,e,s),l(e,oe,s),c(w,e,s),l(e,re,s),c(T,e,s),l(e,pe,s),l(e,j,s),l(e,ce,s),l(e,b,s),l(e,Me,s),c(U,e,s),l(e,me,s),l(e,I,s),l(e,ue,s),c(g,e,s),l(e,ye,s),l(e,f,s),l(e,de,s),l(e,B,s),l(e,he,s),c(C,e,s),l(e,Je,s),l(e,k,s),l(e,we,s),c(Z,e,s),l(e,Te,s),l(e,v,s),l(e,je,s),c(G,e,s),l(e,be,s),c(V,e,s),l(e,Ue,s),l(e,A,s),l(e,Ie,s),l(e,R,s),l(e,ge,s),c(x,e,s),l(e,fe,s),c(X,e,s),l(e,Be,s),l(e,E,s),l(e,Ce,s),c(N,e,s),l(e,ke,s),l(e,z,s),l(e,Ze,s),c($,e,s),l(e,ve,s),l(e,W,s),l(e,Ge,s),c(H,e,s),l(e,Ve,s),c(Q,e,s),l(e,Ae,s),l(e,q,s),l(e,Re,s),c(S,e,s),l(e,xe,s),c(_,e,s),l(e,Xe,s),l(e,Y,s),l(e,Ee,s),c(F,e,s),l(e,Ne,s),l(e,L,s),l(e,ze,s),c(P,e,s),l(e,$e,s),l(e,D,s),l(e,We,s),l(e,K,s),l(e,He,s),l(e,O,s),l(e,Qe,s),l(e,ee,s),l(e,qe,s),c(se,e,s),l(e,Se,s),l(e,ne,s),_e=!0},p:hs,i(e){_e||(M(J.$$.fragment,e),M(w.$$.fragment,e),M(T.$$.fragment,e),M(U.$$.fragment,e),M(g.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(X.$$.fragment,e),M(N.$$.fragment,e),M($.$$.fragment,e),M(H.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(_.$$.fragment,e),M(F.$$.fragment,e),M(P.$$.fragment,e),M(se.$$.fragment,e),_e=!0)},o(e){m(J.$$.fragment,e),m(w.$$.fragment,e),m(T.$$.fragment,e),m(U.$$.fragment,e),m(g.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(x.$$.fragment,e),m(X.$$.fragment,e),m(N.$$.fragment,e),m($.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(_.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(se.$$.fragment,e),_e=!1},d(e){e&&(t(ae),t(le),t(ie),t(oe),t(re),t(pe),t(j),t(ce),t(b),t(Me),t(me),t(I),t(ue),t(ye),t(f),t(de),t(B),t(he),t(Je),t(k),t(we),t(Te),t(v),t(je),t(be),t(Ue),t(A),t(Ie),t(R),t(ge),t(fe),t(Be),t(E),t(Ce),t(ke),t(z),t(Ze),t(ve),t(W),t(Ge),t(Ve),t(Ae),t(q),t(Re),t(xe),t(Xe),t(Y),t(Ee),t(Ne),t(L),t(ze),t($e),t(D),t(We),t(K),t(He),t(O),t(Qe),t(ee),t(qe),t(Se),t(ne)),t(h),u(J,e),u(w,e),u(T,e),u(U,e),u(g,e),u(C,e),u(Z,e),u(G,e),u(V,e),u(x,e),u(X,e),u(N,e),u($,e),u(H,e),u(Q,e),u(S,e),u(_,e),u(F,e),u(P,e),u(se,e)}}}const Bs='{"title":"HuatuoGPT-o1 Medical RAG and Reasoning","local":"huatuogpt-o1-medical-rag-and-reasoning","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Notebook Setup","local":"notebook-setup","sections":[],"depth":2},{"title":"Load the Dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Step 3: Initialize the Models","local":"step-3-initialize-the-models","sections":[],"depth":2},{"title":"Prepare the Knowledge Base","local":"prepare-the-knowledge-base","sections":[],"depth":2},{"title":"Implement Retrieval","local":"implement-retrieval","sections":[],"depth":2},{"title":"Implement Response Generation","local":"implement-response-generation","sections":[],"depth":2},{"title":"Putting It All Together","local":"putting-it-all-together","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Cs(Ye){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends ws{constructor(h){super(),Ts(this,h,Cs,fs,ds,{})}}export{As as component};
