import{s as Pt,n as Ot,o as ln}from"../chunks/scheduler.1f027d5a.js";import{S as sn,i as en,e as o,s as n,c as p,h as tn,a as M,d as e,b as a,f as Dt,g as y,j as i,k as Kt,l as nn,m as t,n as r,t as w,o as J,p as m}from"../chunks/index.5cb6ce42.js";import{C as an}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as on,C as T}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as u,E as Mn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function pn(Fe){let d,as,ts,os,U,Ms,c,is,j,ps,h,Ye='<em>Authored by: <a href="https://huggingface.co/jinnovation" rel="nofollow">Jonathan Jin</a></em>',ys,I,rs,C,Le="This notebook explores solutions for streamlining the deployment of models from a model registry. For teams that want to productionize many models over time, investments at this “transition point” in the AI/ML project lifecycle can meaningfully drive down time-to-production. This can be important for a younger, smaller team that may not have the benefit of existing infrastructure to form a “golden path” for serving online models in production.",ws,f,Js,b,De="Optimizing this stage of the model lifecycle is particularly important due to the production-facing aspect of the end result. At this stage, your model becomes, in effect, a microservice. This means that you now need to contend with all elements of service ownership, which can include:",ms,g,Ke="<li>Standardizing and enforcing API backwards-compatibility;</li> <li>Logging, metrics, and general observability concerns;</li> <li>Etc.</li>",Ts,v,Pe="Needing to repeat the same general-purpose setup each time you want to deploy a new model will result in development costs adding up significantly over time for you and your team. On the flip side, given the “long tail” of production-model ownership (assuming a productionized model is not likely to be decommissioned anytime soon), streamlining investments here can pay healthy dividends over time.",us,Z,Oe="Given all of the above, we motivate our exploration here with the following user story:",ds,A,lt='<p>I would like to deploy a model from a model registry (such as <a href="https://mlflow.org/" rel="nofollow">MLflow</a>) using <strong>only the name of the model</strong>. The less boilerplate and scaffolding that I need to replicate each time I want to deploy a new model, the better. I would like the ability to dynamically select between different versions of the model without needing to set up a whole new deployment to accommodate those new versions.</p>',Us,B,cs,_,st="For our exploration here, we’ll use the following minimal stack:",js,G,et="<li>MLflow for model registry;</li> <li>Ray Serve for model serving.</li>",hs,W,tt="For demonstrative purposes, we’ll exclusively use off-the-shelf open-source models from Hugging Face Hub.",Is,R,nt="We will <strong>not</strong> use GPUs for inference because inference performance is orthogonal to our focus here today. Needless to say, in “real life,” you will likely not be able to get away with serving your model with CPU compute.",Cs,k,at="Let’s install our dependencies now.",fs,V,bs,x,gs,E,ot="First, let’s define the model that we’ll use for our exploration today. For simplicity’s sake, we’ll use a simple text translation model, where the source and destination languages are configurable at registration time. In effect, this means that different “versions” of the model can be registered to translate different languages, but the underlying model architecture and weights can stay the same.",vs,X,Zs,q,Mt="(You might be wondering why we even bothered making the input label configurable. This will be useful to us later.)",As,Q,it='Now that our model is defined, let’s register an actual version of it. This particular version will use Google’s <a href="https://huggingface.co/google-t5/t5-base" rel="nofollow">T5 Base</a> model and be configured to translate from <strong>English</strong> to <strong>German</strong>.',Bs,$,_s,N,pt="Let’s keep track of this exact version. This will be useful later.",Gs,S,Ws,H,yt="The registered model metadata contains some useful information for us. Most notably, the registered model version is associated with a strict <strong>signature</strong> that denotes the expected shape of its input and output. This will be useful to us later.",Rs,z,ks,F,rt=`inputs: 
  ['prompt': string (required)]
outputs: 
  ['translation_text': string (required)]
params: 
  None
`,Vs,Y,xs,L,wt='Now that our model is registered in MLflow, let’s set up our serving scaffolding using <a href="https://docs.ray.io/en/latest/serve/index.html" rel="nofollow">Ray Serve</a>. For now, we’ll limit our “deployment” to the following behavior:',Es,D,Jt="<li>Source the seleted model and version from MLflow;</li> <li>Receive inference requests and return inference responses via a simple REST API.</li>",Xs,K,qs,P,mt="You might have notice that hard-coding <code>&quot;prompt&quot;</code> as the input label here introduces hidden coupling between the registered model’s signature and the deployment implementation. We’ll come back to this later.",Qs,O,Tt="Now, let’s run the deployment and play around with it.",$s,ll,Ns,sl,Ss,el,ut=`[&#123;'translation_text': 'Das Wetter ist heute nett.'}]
`,Hs,tl,dt="This works fine, but you might have noticed that the REST API does not line up with the model signature. Namely, it uses the label <code>&quot;input_string&quot;</code> while the served model version itself uses the input label <code>&quot;prompt&quot;</code>. Similarly, the model can accept multiple inputs values, but the API only accepts one.",zs,nl,Ut='If this feels <a href="https://en.wikipedia.org/wiki/Code_smell" rel="nofollow">smelly</a> to you, keep reading; we’ll come back to this.',Fs,al,Ys,ol,ct="Now we’ve got a basic endpoint set up for our model. Great! However, notice that this deployment is strictly tethered to a single version of this model — specifically, version <code>1</code> of the registered <code>translation_model</code>.",Ls,Ml,jt='Imagine, now, that your team would like to come back and refine this model — maybe retrain it on new data, or configure it to translate to a new language, e.g. French instead of German. Both would result in a new version of the <code>translation_model</code> getting registered. However, with our current deployment implementation, we’d need to set up a whole new endpoint for <code>translation_model/2</code>, require our users to remember which address and port corresponds to which version of the model, and so on. In other words: very cumbersome, very error-prone, very <a href="https://leaddev.com/velocity/what-toil-and-why-it-damaging-your-engineering-org" rel="nofollow">toilsome</a>.',Ds,il,ht="Conversely, imagine a scenario where we could reuse the exact same endpoint — same signature, same address and port, same query conventions, etc. — to serve both versions of this model. Our user can simply specify which version of the model they’d like to use, and we can treat one of them as the “default” in cases where the user didn’t explicitly request one.",Ks,pl,It='This is one area where Ray Serve shines with a feature it calls <a href="https://docs.ray.io/en/latest/serve/model-multiplexing.html" rel="nofollow">model multiplexing</a>. In effect, this allows you to load up multiple “versions” of your model, dynamically hot-swapping them as needed, as well as unloading the versions that don’t get used after some time. Very space-efficient, in other words.',Ps,yl,Ct="Let’s try registering another version of the model — this time, one that translates from English to French. We’ll register this under the version <code>&quot;2&quot;</code>; the model server will retrieve the model version that way.",Os,rl,ft="But first, let’s extend the model server with multiplexing support.",le,wl,se,Jl,ee,ml,bt="Now let’s actually register the new model version.",te,Tl,ne,ul,gt="Now that that’s registered, we can query for it via the model server like so…",ae,dl,oe,Ul,vt=`[&#123;'translation_text': "Le temps est beau aujourd'hui"}]
`,Me,cl,Zt='Note how we were able to immediately access the model version <strong>without redeploying the model server</strong>. Ray Serve’s multiplexing capabilities allow it to dynamically fetch the model weights in a just-in-time fashion; if I never requested version 2, it never gets loaded. This helps conserve compute resources for the models that <strong>do</strong> get queried. What’s even more useful is that, if the number of models loaded up exceeds the configured maximum (<code>max_num_models_per_replica</code>), the <a href="https://docs.ray.io/en/latest/serve/model-multiplexing.html#why-model-multiplexing" rel="nofollow">least-recently used model version will get evicted</a>.',ie,jl,At="Given that we set <code>max_num_models_per_replica=2</code> above, the “default” English-to-German version of the model should still be loaded up and readily available to serve requests without any cold-start time. Let’s confirm that now:",pe,hl,ye,Il,Bt=`[&#123;'translation_text': 'Das Wetter ist heute nett.'}]
`,re,Cl,we,fl,_t="This is all well and good. However, notice that the following friction point still exists: when defining the server, we need to define a whole new signature for the API itself. At best, this is just some code duplication of the model signature itself (which is registered in MLflow). At worst, this can result in inconsistent APIs across all models that your team or organization owns, which can cause confusion and frustration in your downstream dependencies.",Je,bl,Gt="In this particular case, it means that <code>MultiplexedModelDeployment</code> is secretly actually <strong>tightly coupled</strong> to the use-case for <code>translation_model</code>. What if we wanted to deploy another set of models that don’t have to do with language translation? The defined <code>/serve</code> API, which returns a JSON object that looks like <code>{&quot;translated_text&quot;: &quot;foo&quot;}</code>, would no longer make sense.",me,gl,Wt="To address this issue, <strong>what if the API signature for <code>MultiplexedModelDeployment</code> could automatically mirror the signature of the underlying models it’s serving</strong>?",Te,vl,Rt="Thankfully, with MLflow Model Registry metadata and some Python dynamic-class-creation shenanigans, this is entirely possible.",ue,Zl,kt="Let’s set things up so that the model server signature is inferred from the registered model itself. Since different versions of an MLflow can have different signatures, we’ll use the “default version” to “pin” the signature; any attempt to multiplex an incompatible-signature model version we will have throw an error.",de,Al,Vt="Since Ray Serve binds the request and response signatures at class-definition time, we will use a Python metaclass to set this as a function of the specified model name and default model version.",Ue,Bl,ce,_l,je,Gl,he,Wl,xt=`[&#123;'translation_text': "Le temps est beau aujourd'hui"}]
`,Ie,Rl,Ce,kl,Et=`[&#123;'translation_text': "Le temps est beau aujourd'hui"}]
`,fe,Vl,Xt="Let’s now confirm that the signature-check provision we put in place actually works. For this, let’s register this same model with a <strong>slightly</strong> different signature. This should be enough to trigger the failsafe.",be,xl,qt="(Remember when we made the input label configurable at the start of this exercise? This is where that finally comes into play. 😎)",ge,El,ve,Xl,Ze,ql,Qt="(The technically “correct” thing to do here would be to implement a response container that allows for an “error message” to be defined as part of the actual response, rather than “abusing” the <code>translation_text</code> field like we do here. For demonstration purposes, however, this’ll do.)",Ae,Ql,$t="To fully close things out, let’s try registering an entirely different model — with an entirely different signature — and deploying that via <code>deployment_from_model_name()</code>. This will help us confirm that the entire signature is defined from the loaded model.",Be,$l,_e,Nl,Ge,Sl,We,Hl,Nt=`inputs: 
  ['question': string (required)]
outputs: 
  ['score': double (required), 'start': long (required), 'end': long (required), 'answer': string (required)]
params: 
  None
`,Re,zl,ke,Fl,Ve,Yl,St=`[&#123;'score': 3.255764386267401e-05, 'start': 30, 'end': 38, 'answer': 'Germany.'}]
`,xe,Ll,Ee,Dl,Ht="In this notebook, we’ve leveraged MLflow’s built-in support for tracking model signatures to heavily streamline the process of deploying an HTTP server to serve that model in online fashion. We’ve taken Ray Serve’s powerful-but-fiddly primitives to empower ourselves to, in one line, deploy a model server with:",Xe,Kl,zt="<li>Version multiplexing;</li> <li>Automatic REST API signature setup;</li> <li>Safeguards to prevent use of model versions with incompatible signatures.</li>",qe,Pl,Ft='In doing so, we’ve demonstrated Ray Serve’s value and potential as a toolkit upon which you and your team can <a href="https://docs.ray.io/en/latest/serve/index.html#how-does-serve-compare-to" rel="nofollow">“build your own ML platform”</a>.',Qe,Ol,Yt="We’ve also demonstrated ways to reduce the integration overhead and toil associated with using multiple tools in combination with each other. Seamless integration is a powerful argument in favor of self-contained all-encompassing platforms such as AWS Sagemaker or GCP Vertex AI. We’ve demonstrated that, with a little clever engineering and principled eye towards the friction points that users — in this case, MLEs — care about, we can reap similar benefits without tethering ourselves and our team to expensive vendor contracts.",$e,ls,Ne,ss,Lt='<li>The generated API signature is <strong>very similar</strong> to the model signature, but there’s still some mismatch. Can you identify where it is? Try fixing it. Hint: What happens when you try passing in multiple questions to the question-answerer endpoint we set up?</li> <li>MLflow model signatures allow for <a href="https://mlflow.org/docs/latest/model/signatures.html#required-vs-optional-input-fields" rel="nofollow">optional inputs</a>. Our current implementation does not account for this. How might we extend the implementation here to support optional inputs?</li> <li>Similarly, MLflow model signatures allow for non-input <a href="https://mlflow.org/docs/latest/model/signatures.html#model-signatures-with-inference-params" rel="nofollow">“inference parameters”</a>, which our current implementation also does not support. How might we extend our implementation here to support inference parameters?</li> <li>We use the name <code>DynamicallyDefinedDeployment</code> every single time we generate a new deployment, regardless of what model name and version we pass in. Is this a problem? If so, what kind of issues do you foresee this approach creating? Try tweaking <code>deployment_from_model_name()</code> to handle those issues.</li>',Se,es,He,ns,ze;return U=new on({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/mlflow_ray_serve.ipynb"}]}}),c=new an({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new u({props:{title:"Signature-Aware Model Serving from MLflow with Ray Serve",local:"signature-aware-model-serving-from-mlflow-with-ray-serve",headingTag:"h1"}}),I=new u({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),f=new u({props:{title:"Motivation",local:"motivation",headingTag:"h2"}}),B=new u({props:{title:"Components",local:"components",headingTag:"h2"}}),V=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMjAlMjJtbGZsb3ctc2tpbm55JTIyJTIwJTIycmF5JTVCc2VydmUlNUQlMjIlMjAlMjJ0b3JjaCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;transformers&quot;</span> <span class="hljs-string">&quot;mlflow-skinny&quot;</span> <span class="hljs-string">&quot;ray[serve]&quot;</span> <span class="hljs-string">&quot;torch&quot;</span>',wrap:!1}}),x=new u({props:{title:"Register the Model",local:"register-the-model",headingTag:"h2"}}),X=new T({props:{code:"aW1wb3J0JTIwbWxmbG93JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3MlMjBNeVRyYW5zbGF0aW9uTW9kZWwobWxmbG93LnB5ZnVuYy5QeXRob25Nb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBsb2FkX2NvbnRleHQoc2VsZiUyQyUyMGNvbnRleHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sYW5nX2Zyb20lMjAlM0QlMjBjb250ZXh0Lm1vZGVsX2NvbmZpZy5nZXQoJTIybGFuZ19mcm9tJTIyJTJDJTIwJTIyZW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sYW5nX3RvJTIwJTNEJTIwY29udGV4dC5tb2RlbF9jb25maWcuZ2V0KCUyMmxhbmdfdG8lMjIlMkMlMjAlMjJkZSUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmlucHV0X2xhYmVsJTNBJTIwc3RyJTIwJTNEJTIwY29udGV4dC5tb2RlbF9jb25maWcuZ2V0KCUyMmlucHV0X2xhYmVsJTIyJTJDJTIwJTIycHJvbXB0JTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfcmVmJTNBJTIwc3RyJTIwJTNEJTIwY29udGV4dC5tb2RlbF9jb25maWcuZ2V0KCUyMmhmaHViX25hbWUlMjIlMkMlMjAlMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIydHJhbnNsYXRpb25fJTdCc2VsZi5sYW5nX2Zyb20lN0RfdG9fJTdCc2VsZi5sYW5nX3RvJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9yZWYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlZGljdChzZWxmJTJDJTIwY29udGV4dCUyQyUyMG1vZGVsX2lucHV0JTJDJTIwcGFyYW1zJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBtb2RlbF9pbnB1dCU1QnNlbGYuaW5wdXRfbGFiZWwlNUQudG9saXN0KCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnBpcGVsaW5lKHByb21wdCk=",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyTranslationModel</span>(mlflow.pyfunc.PythonModel):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_context</span>(<span class="hljs-params">self, context</span>):
        self.lang_from = context.model_config.get(<span class="hljs-string">&quot;lang_from&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>)
        self.lang_to = context.model_config.get(<span class="hljs-string">&quot;lang_to&quot;</span>, <span class="hljs-string">&quot;de&quot;</span>)

        self.input_label: <span class="hljs-built_in">str</span> = context.model_config.get(<span class="hljs-string">&quot;input_label&quot;</span>, <span class="hljs-string">&quot;prompt&quot;</span>)

        self.model_ref: <span class="hljs-built_in">str</span> = context.model_config.get(<span class="hljs-string">&quot;hfhub_name&quot;</span>, <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

        self.pipeline = pipeline(
            <span class="hljs-string">f&quot;translation_<span class="hljs-subst">{self.lang_from}</span>_to_<span class="hljs-subst">{self.lang_to}</span>&quot;</span>,
            self.model_ref,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">self, context, model_input, params=<span class="hljs-literal">None</span></span>):
        prompt = model_input[self.input_label].tolist()

        <span class="hljs-keyword">return</span> self.pipeline(prompt)`,wrap:!1}}),$=new T({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbmZvJTIwJTNEJTIwbWxmbG93LnB5ZnVuYy5sb2dfbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWdpc3RlcmVkX21vZGVsX25hbWUlM0QlMjJ0cmFuc2xhdGlvbl9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dGhvbl9tb2RlbCUzRE15VHJhbnNsYXRpb25Nb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwX3JlcXVpcmVtZW50cyUzRCU1QiUyMnRyYW5zZm9ybWVycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2V4YW1wbGUlM0RwZC5EYXRhRnJhbWUoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTIySGVsbG8lMjBteSUyMG5hbWUlMjBpcyUyMEpvbmF0aGFuLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9jb25maWclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZmh1Yl9uYW1lJTIyJTNBJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxhbmdfZnJvbSUyMiUzQSUyMCUyMmVuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGFuZ190byUyMiUzQSUyMCUyMmRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    model_info = mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;translation_model&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;translation_model&quot;</span>,
        python_model=MyTranslationModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame({
            <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;Hello my name is Jonathan.&quot;</span>],
        }),
        model_config={
            <span class="hljs-string">&quot;hfhub_name&quot;</span>: <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>,
            <span class="hljs-string">&quot;lang_from&quot;</span>: <span class="hljs-string">&quot;en&quot;</span>,
            <span class="hljs-string">&quot;lang_to&quot;</span>: <span class="hljs-string">&quot;de&quot;</span>,
        },
    )`,wrap:!1}}),S=new T({props:{code:"ZW5fdG9fZGVfdmVyc2lvbiUzQSUyMHN0ciUyMCUzRCUyMHN0cihtb2RlbF9pbmZvLnJlZ2lzdGVyZWRfbW9kZWxfdmVyc2lvbik=",highlighted:'en_to_de_version: <span class="hljs-built_in">str</span> = <span class="hljs-built_in">str</span>(model_info.registered_model_version)',wrap:!1}}),z=new T({props:{code:"cHJpbnQobW9kZWxfaW5mby5zaWduYXR1cmUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model_info.signature)',wrap:!1}}),Y=new u({props:{title:"Serve the Model",local:"serve-the-model",headingTag:"h2"}}),K=new T({props:{code:"aW1wb3J0JTIwbWxmbG93JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWZyb20lMjByYXklMjBpbXBvcnQlMjBzZXJ2ZSUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwRmFzdEFQSSUwQSUwQWFwcCUyMCUzRCUyMEZhc3RBUEkoKSUwQSUwQSU0MHNlcnZlLmRlcGxveW1lbnQlMEElNDBzZXJ2ZS5pbmdyZXNzKGFwcCklMEFjbGFzcyUyME1vZGVsRGVwbG95bWVudCUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtb2RlbF9uYW1lJTNBJTIwc3RyJTIwJTNEJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMjBkZWZhdWx0X3ZlcnNpb24lM0ElMjBzdHIlMjAlM0QlMjAlMjIxJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRlZmF1bHRfdmVyc2lvbiUyMCUzRCUyMGRlZmF1bHRfdmVyc2lvbiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBtbGZsb3cucHlmdW5jLmxvYWRfbW9kZWwoZiUyMm1vZGVscyUzQSUyRiU3QnNlbGYubW9kZWxfbmFtZSU3RCUyRiU3QnNlbGYuZGVmYXVsdF92ZXJzaW9uJTdEJTIyKSUwQSUwQSUwQSUyMCUyMCUyMCUyMCU0MGFwcC5wb3N0KCUyMiUyRnNlcnZlJTIyKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc2VydmUoc2VsZiUyQyUyMGlucHV0X3N0cmluZyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLm1vZGVsLnByZWRpY3QocGQuRGF0YUZyYW1lKCU3QiUyMnByb21wdCUyMiUzQSUyMCU1QmlucHV0X3N0cmluZyU1RCU3RCkpJTBBJTBBZGVwbG95bWVudCUyMCUzRCUyME1vZGVsRGVwbG95bWVudC5iaW5kKGRlZmF1bHRfdmVyc2lvbiUzRGVuX3RvX2RlX3ZlcnNpb24p",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()

<span class="hljs-meta">@serve.deployment</span>
<span class="hljs-meta">@serve.ingress(<span class="hljs-params">app</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ModelDeployment</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;translation_model&quot;</span>, default_version: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;1&quot;</span></span>):
        self.model_name = model_name
        self.default_version = default_version

        self.model = mlflow.pyfunc.load_model(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{self.model_name}</span>/<span class="hljs-subst">{self.default_version}</span>&quot;</span>)


<span class="hljs-meta">    @app.post(<span class="hljs-params"><span class="hljs-string">&quot;/serve&quot;</span></span>)</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">serve</span>(<span class="hljs-params">self, input_string: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">return</span> self.model.predict(pd.DataFrame({<span class="hljs-string">&quot;prompt&quot;</span>: [input_string]}))

deployment = ModelDeployment.bind(default_version=en_to_de_version)`,wrap:!1}}),ll=new T({props:{code:"c2VydmUucnVuKGRlcGxveW1lbnQlMkMlMjBibG9ja2luZyUzREZhbHNlKQ==",highlighted:'serve.run(deployment, blocking=<span class="hljs-literal">False</span>)',wrap:!1}}),sl=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwMDAlMkZzZXJ2ZSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhcmFtcyUzRCU3QiUyMmlucHV0X3N0cmluZyUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlLmpzb24oKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    params={<span class="hljs-string">&quot;input_string&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.json())`,wrap:!1}}),al=new u({props:{title:"Multiple Versions, One Endpoint",local:"multiple-versions-one-endpoint",headingTag:"h2"}}),wl=new T({props:{code:"ZnJvbSUyMHJheSUyMGltcG9ydCUyMHNlcnZlJTBBZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBYXBwJTIwJTNEJTIwRmFzdEFQSSgpJTBBJTBBJTQwc2VydmUuZGVwbG95bWVudCUwQSU0MHNlcnZlLmluZ3Jlc3MoYXBwKSUwQWNsYXNzJTIwTXVsdGlwbGV4ZWRNb2RlbERlcGxveW1lbnQlM0ElMEElMEElMjAlMjAlMjAlMjAlNDBzZXJ2ZS5tdWx0aXBsZXhlZChtYXhfbnVtX21vZGVsc19wZXJfcmVwbGljYSUzRDIpJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBnZXRfbW9kZWwoc2VsZiUyQyUyMHZlcnNpb24lM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWxmbG93LnB5ZnVuYy5sb2FkX21vZGVsKGYlMjJtb2RlbHMlM0ElMkYlN0JzZWxmLm1vZGVsX25hbWUlN0QlMkYlN0J2ZXJzaW9uJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNBJTIwc3RyJTIwJTNEJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X3ZlcnNpb24lM0ElMjBzdHIlMjAlM0QlMjBlbl90b19kZV92ZXJzaW9uJTJDJTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRlZmF1bHRfdmVyc2lvbiUyMCUzRCUyMGRlZmF1bHRfdmVyc2lvbiUwQSUwQSUyMCUyMCUyMCUyMCU0MGFwcC5wb3N0KCUyMiUyRnNlcnZlJTIyKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc2VydmUoc2VsZiUyQyUyMGlucHV0X3N0cmluZyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGF3YWl0JTIwc2VsZi5nZXRfbW9kZWwoc2VydmUuZ2V0X211bHRpcGxleGVkX21vZGVsX2lkKCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwucHJlZGljdChwZC5EYXRhRnJhbWUoJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCaW5wdXRfc3RyaW5nJTVEJTdEKSk=",highlighted:`<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()

<span class="hljs-meta">@serve.deployment</span>
<span class="hljs-meta">@serve.ingress(<span class="hljs-params">app</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiplexedModelDeployment</span>:

<span class="hljs-meta">    @serve.multiplexed(<span class="hljs-params">max_num_models_per_replica=<span class="hljs-number">2</span></span>)</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_model</span>(<span class="hljs-params">self, version: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">return</span> mlflow.pyfunc.load_model(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{self.model_name}</span>/<span class="hljs-subst">{version}</span>&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        model_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;translation_model&quot;</span>,
        default_version: <span class="hljs-built_in">str</span> = en_to_de_version,
    </span>):
        self.model_name = model_name
        self.default_version = default_version

<span class="hljs-meta">    @app.post(<span class="hljs-params"><span class="hljs-string">&quot;/serve&quot;</span></span>)</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">serve</span>(<span class="hljs-params">self, input_string: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-keyword">await</span> self.get_model(serve.get_multiplexed_model_id())
        <span class="hljs-keyword">return</span> model.predict(pd.DataFrame({<span class="hljs-string">&quot;prompt&quot;</span>: [input_string]}))`,wrap:!1}}),Jl=new T({props:{code:"bXVsdGlwbGV4ZWRfZGVwbG95bWVudCUyMCUzRCUyME11bHRpcGxleGVkTW9kZWxEZXBsb3ltZW50LmJpbmQobW9kZWxfbmFtZSUzRCUyMnRyYW5zbGF0aW9uX21vZGVsJTIyKSUwQXNlcnZlLnJ1bihtdWx0aXBsZXhlZF9kZXBsb3ltZW50JTJDJTIwYmxvY2tpbmclM0RGYWxzZSk=",highlighted:`multiplexed_deployment = MultiplexedModelDeployment.bind(model_name=<span class="hljs-string">&quot;translation_model&quot;</span>)
serve.run(multiplexed_deployment, blocking=<span class="hljs-literal">False</span>)`,wrap:!1}}),Tl=new T({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbmZvJTIwJTNEJTIwbWxmbG93LnB5ZnVuYy5sb2dfbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNsYXRpb25fbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWdpc3RlcmVkX21vZGVsX25hbWUlM0QlMjJ0cmFuc2xhdGlvbl9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dGhvbl9tb2RlbCUzRE15VHJhbnNsYXRpb25Nb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwX3JlcXVpcmVtZW50cyUzRCU1QiUyMnRyYW5zZm9ybWVycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2V4YW1wbGUlM0RwZC5EYXRhRnJhbWUoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMjBteSUyMG5hbWUlMjBpcyUyMEpvbi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGZodWJfbmFtZSUyMiUzQSUyMCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2Zyb20lMjIlM0ElMjAlMjJlbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxhbmdfdG8lMjIlM0ElMjAlMjJmciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFlbl90b19mcl92ZXJzaW9uJTNBJTIwc3RyJTIwJTNEJTIwc3RyKG1vZGVsX2luZm8ucmVnaXN0ZXJlZF9tb2RlbF92ZXJzaW9uKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    model_info = mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;translation_model&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;translation_model&quot;</span>,
        python_model=MyTranslationModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame({
            <span class="hljs-string">&quot;prompt&quot;</span>: [
                <span class="hljs-string">&quot;Hello my name is Jon.&quot;</span>,
            ],
        }),
        model_config={
            <span class="hljs-string">&quot;hfhub_name&quot;</span>: <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>,
            <span class="hljs-string">&quot;lang_from&quot;</span>: <span class="hljs-string">&quot;en&quot;</span>,
            <span class="hljs-string">&quot;lang_to&quot;</span>: <span class="hljs-string">&quot;fr&quot;</span>,
        },
    )

en_to_fr_version: <span class="hljs-built_in">str</span> = <span class="hljs-built_in">str</span>(model_info.registered_model_version)`,wrap:!1}}),dl=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwMDAlMkZzZXJ2ZSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhcmFtcyUzRCU3QiUyMmlucHV0X3N0cmluZyUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMnNlcnZlX211bHRpcGxleGVkX21vZGVsX2lkJTIyJTNBJTIwZW5fdG9fZnJfdmVyc2lvbiU3RCUyQyUwQSklMEElMEFwcmludChyZXNwb25zZS5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    params={<span class="hljs-string">&quot;input_string&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>    headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: en_to_fr_version},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.json())`,wrap:!1}}),hl=new T({props:{code:"cHJpbnQoJTBBJTIwJTIwJTIwJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW1zJTNEJTdCJTIyaW5wdXRfc3RyaW5nJTIyJTNBJTIwJTIyVGhlJTIwd2VhdGhlciUyMGlzJTIwbG92ZWx5JTIwdG9kYXklMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWFkZXJzJTNEJTdCJTIyc2VydmVfbXVsdGlwbGV4ZWRfbW9kZWxfaWQlMjIlM0ElMjBlbl90b19kZV92ZXJzaW9uJTdEJTJDJTBBJTIwJTIwJTIwJTIwKS5qc29uKCklMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    requests.post(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>        params={<span class="hljs-string">&quot;input_string&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>        headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: en_to_de_version},
<span class="hljs-meta">... </span>    ).json()
<span class="hljs-meta">... </span>)`,wrap:!1}}),Cl=new u({props:{title:"Auto-Signature",local:"auto-signature",headingTag:"h2"}}),Bl=new T({props:{code:"aW1wb3J0JTIwbWxmbG93JTBBaW1wb3J0JTIwcHlkYW50aWMlMEElMEFkZWYlMjBzY2hlbWFfdG9fcHlkYW50aWMoc2NoZW1hJTNBJTIwbWxmbG93LnR5cGVzLnNjaGVtYS5TY2hlbWElMkMlMjAqJTJDJTIwbmFtZSUzQSUyMHN0ciklMjAtJTNFJTIwcHlkYW50aWMuQmFzZU1vZGVsJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHlkYW50aWMuY3JlYXRlX21vZGVsKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKiU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGslM0ElMjAodi50eXBlLnRvX3B5dGhvbigpJTJDJTIwcHlkYW50aWMuRmllbGQocmVxdWlyZWQlM0RUcnVlKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwc2NoZW1hLmlucHV0X2RpY3QoKS5pdGVtcygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQWRlZiUyMGdldF9yZXFfcmVzcF9zaWduYXR1cmVzKG1vZGVsX3NpZ25hdHVyZSUzQSUyMG1sZmxvdy5tb2RlbHMuTW9kZWxTaWduYXR1cmUpJTIwLSUzRSUyMHR1cGxlJTVCcHlkYW50aWMuQmFzZU1vZGVsJTJDJTIwcHlkYW50aWMuQmFzZU1vZGVsJTVEJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNBJTIwbWxmbG93LnR5cGVzLnNjaGVtYS5TY2hlbWElMjAlM0QlMjBtb2RlbF9zaWduYXR1cmUuaW5wdXRzJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzQSUyMG1sZmxvdy50eXBlcy5zY2hlbWEuU2NoZW1hJTIwJTNEJTIwbW9kZWxfc2lnbmF0dXJlLm91dHB1dHMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAoc2NoZW1hX3RvX3B5ZGFudGljKGlucHV0cyUyQyUyMG5hbWUlM0QlMjJJbnB1dE1vZGVsJTIyKSUyQyUyMHNjaGVtYV90b19weWRhbnRpYyhvdXRwdXRzJTJDJTIwbmFtZSUzRCUyMk91dHB1dE1vZGVsJTIyKSk=",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">import</span> pydantic

<span class="hljs-keyword">def</span> <span class="hljs-title function_">schema_to_pydantic</span>(<span class="hljs-params">schema: mlflow.types.schema.Schema, *, name: <span class="hljs-built_in">str</span></span>) -&gt; pydantic.BaseModel:
    <span class="hljs-keyword">return</span> pydantic.create_model(
        name,
        **{
            k: (v.<span class="hljs-built_in">type</span>.to_python(), pydantic.Field(required=<span class="hljs-literal">True</span>))
            <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> schema.input_dict().items()
        }
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_req_resp_signatures</span>(<span class="hljs-params">model_signature: mlflow.models.ModelSignature</span>) -&gt; <span class="hljs-built_in">tuple</span>[pydantic.BaseModel, pydantic.BaseModel]:
    inputs: mlflow.types.schema.Schema = model_signature.inputs
    outputs: mlflow.types.schema.Schema = model_signature.outputs

    <span class="hljs-keyword">return</span> (schema_to_pydantic(inputs, name=<span class="hljs-string">&quot;InputModel&quot;</span>), schema_to_pydantic(outputs, name=<span class="hljs-string">&quot;OutputModel&quot;</span>))`,wrap:!1}}),_l=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> mlflow

<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI, Response, status
<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">deployment_from_model_name</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span>, default_version: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;1&quot;</span></span>):
    app = FastAPI()
    model_info = mlflow.models.get_model_info(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{default_version}</span>&quot;</span>)
    input_datamodel, output_datamodel = get_req_resp_signatures(model_info.signature)

<span class="hljs-meta">    @serve.deployment</span>
<span class="hljs-meta">    @serve.ingress(<span class="hljs-params">app</span>)</span>
    <span class="hljs-keyword">class</span> <span class="hljs-title class_">DynamicallyDefinedDeployment</span>:

        MODEL_NAME: <span class="hljs-built_in">str</span> = model_name
        DEFAULT_VERSION: <span class="hljs-built_in">str</span> = default_version

<span class="hljs-meta">        @serve.multiplexed(<span class="hljs-params">max_num_models_per_replica=<span class="hljs-number">2</span></span>)</span>
        <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_model</span>(<span class="hljs-params">self, model_version: <span class="hljs-built_in">str</span></span>):
            model = mlflow.pyfunc.load_model(<span class="hljs-string">f&quot;models:/<span class="hljs-subst">{self.MODEL_NAME}</span>/<span class="hljs-subst">{model_version}</span>&quot;</span>)

            <span class="hljs-keyword">if</span> model.metadata.get_model_info().signature != model_info.signature:
                <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Requested version <span class="hljs-subst">{model_version}</span> has signature incompatible with that of default version <span class="hljs-subst">{self.DEFAULT_VERSION}</span>&quot;</span>)
            <span class="hljs-keyword">return</span> model

        <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Extend this to support batching (lists of inputs and outputs)</span>
<span class="hljs-meta">        @app.post(<span class="hljs-params"><span class="hljs-string">&quot;/serve&quot;</span>, response_model=<span class="hljs-type">List</span>[output_datamodel]</span>)</span>
        <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">serve</span>(<span class="hljs-params">self, model_input: input_datamodel, response: Response</span>):
            model_id = serve.get_multiplexed_model_id()
            <span class="hljs-keyword">if</span> model_id == <span class="hljs-string">&quot;&quot;</span>:
                model_id = self.DEFAULT_VERSION

            <span class="hljs-keyword">try</span>:
                model = <span class="hljs-keyword">await</span> self.get_model(model_id)
            <span class="hljs-keyword">except</span> ValueError:
                response.status_code = status.HTTP_409_CONFLICT
                <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;translation_text&quot;</span>: <span class="hljs-string">&quot;FAILED&quot;</span>}]

            <span class="hljs-keyword">return</span> model.predict(model_input.<span class="hljs-built_in">dict</span>())

    <span class="hljs-keyword">return</span> DynamicallyDefinedDeployment

deployment = deployment_from_model_name(<span class="hljs-string">&quot;translation_model&quot;</span>, default_version=en_to_fr_version)

serve.run(deployment.bind(), blocking=<span class="hljs-literal">False</span>)`,wrap:!1}}),Gl=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBKSUwQSUwQWFzc2VydCUyMHJlc3Aub2slMEFhc3NlcnQlMjByZXNwLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTBBJTBBcHJpbnQocmVzcC5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>resp = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    json={<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.ok
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.status_code == <span class="hljs-number">200</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(resp.json())`,wrap:!1}}),Rl=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMnNlcnZlX211bHRpcGxleGVkX21vZGVsX2lkJTIyJTNBJTIwc3RyKGVuX3RvX2ZyX3ZlcnNpb24pJTdEJTJDJTBBKSUwQSUwQWFzc2VydCUyMHJlc3Aub2slMEFhc3NlcnQlMjByZXNwLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTBBJTBBcHJpbnQocmVzcC5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>resp = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    json={<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>    headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: <span class="hljs-built_in">str</span>(en_to_fr_version)},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.ok
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> resp.status_code == <span class="hljs-number">200</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(resp.json())`,wrap:!1}}),El=new T({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBpbmNvbXBhdGlibGVfdmVyc2lvbiUyMCUzRCUyMHN0cihtbGZsb3cucHlmdW5jLmxvZ19tb2RlbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc2xhdGlvbl9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlZ2lzdGVyZWRfbW9kZWxfbmFtZSUzRCUyMnRyYW5zbGF0aW9uX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uX21vZGVsJTNETXlUcmFuc2xhdGlvbk1vZGVsKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBfcmVxdWlyZW1lbnRzJTNEJTVCJTIydHJhbnNmb3JtZXJzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfZXhhbXBsZSUzRHBkLkRhdGFGcmFtZSglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0X3RvX3RyYW5zbGF0ZSUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTIwbXklMjBuYW1lJTIwaXMlMjBKb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0X2xhYmVsJTIyJTNBJTIwJTIydGV4dF90b190cmFuc2xhdGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZmh1Yl9uYW1lJTIyJTNBJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxhbmdfZnJvbSUyMiUzQSUyMCUyMmVuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGFuZ190byUyMiUzQSUyMCUyMmRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwKS5yZWdpc3RlcmVkX21vZGVsX3ZlcnNpb24p",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    incompatible_version = <span class="hljs-built_in">str</span>(mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;translation_model&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;translation_model&quot;</span>,
        python_model=MyTranslationModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame({
            <span class="hljs-string">&quot;text_to_translate&quot;</span>: [
                <span class="hljs-string">&quot;Hello my name is Jon.&quot;</span>,
            ],
        }),
        model_config={
            <span class="hljs-string">&quot;input_label&quot;</span>: <span class="hljs-string">&quot;text_to_translate&quot;</span>,
            <span class="hljs-string">&quot;hfhub_name&quot;</span>: <span class="hljs-string">&quot;google-t5/t5-base&quot;</span>,
            <span class="hljs-string">&quot;lang_from&quot;</span>: <span class="hljs-string">&quot;en&quot;</span>,
            <span class="hljs-string">&quot;lang_to&quot;</span>: <span class="hljs-string">&quot;de&quot;</span>,
        },
    ).registered_model_version)`,wrap:!1}}),Xl=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGxvdmVseSUyMHRvZGF5JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMnNlcnZlX211bHRpcGxleGVkX21vZGVsX2lkJTIyJTNBJTIwaW5jb21wYXRpYmxlX3ZlcnNpb24lN0QlMkMlMEEpJTBBYXNzZXJ0JTIwbm90JTIwcmVzcC5vayUwQXJlc3Auc3RhdHVzX2NvZGUlMjAlM0QlM0QlMjA0MDklMEElMEFhc3NlcnQlMjByZXNwLmpzb24oKSU1QjAlNUQlNUIlMjJ0cmFuc2xhdGlvbl90ZXh0JTIyJTVEJTIwJTNEJTNEJTIwJTIyRkFJTEVEJTIy",highlighted:`<span class="hljs-keyword">import</span> requests

resp = requests.post(
    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
    json={<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
    headers={<span class="hljs-string">&quot;serve_multiplexed_model_id&quot;</span>: incompatible_version},
)
<span class="hljs-keyword">assert</span> <span class="hljs-keyword">not</span> resp.ok
resp.status_code == <span class="hljs-number">409</span>

<span class="hljs-keyword">assert</span> resp.json()[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;translation_text&quot;</span>] == <span class="hljs-string">&quot;FAILED&quot;</span>`,wrap:!1}}),$l=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> mlflow
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-keyword">class</span> <span class="hljs-title class_">QuestionAnswererModel</span>(mlflow.pyfunc.PythonModel):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_context</span>(<span class="hljs-params">self, context</span>):

        self.model_context = context.model_config.get(
            <span class="hljs-string">&quot;model_context&quot;</span>,
            <span class="hljs-string">&quot;My name is Hans and I live in Germany.&quot;</span>,
        )
        self.model_name = context.model_config.get(
            <span class="hljs-string">&quot;model_name&quot;</span>,
            <span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>,
        )

        self.tokenizer_name = context.model_config.get(
            <span class="hljs-string">&quot;tokenizer_name&quot;</span>,
            <span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>,
        )

        self.pipeline = pipeline(
            <span class="hljs-string">&quot;question-answering&quot;</span>,
            model=self.model_name,
            tokenizer=self.tokenizer_name,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">self, context, model_input, params=<span class="hljs-literal">None</span></span>):
        resp = self.pipeline(
            question=model_input[<span class="hljs-string">&quot;question&quot;</span>].tolist(),
            context=self.model_context,
        )

        <span class="hljs-keyword">return</span> [resp] <span class="hljs-keyword">if</span> <span class="hljs-built_in">type</span>(resp) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">list</span> <span class="hljs-keyword">else</span> resp`,wrap:!1}}),Nl=new T({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXdpdGglMjBtbGZsb3cuc3RhcnRfcnVuKCklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbmZvJTIwJTNEJTIwbWxmbG93LnB5ZnVuYy5sb2dfbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlc3Rpb25fYW5zd2VyZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWdpc3RlcmVkX21vZGVsX25hbWUlM0QlMjJxdWVzdGlvbl9hbnN3ZXJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dGhvbl9tb2RlbCUzRFF1ZXN0aW9uQW5zd2VyZXJNb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwX3JlcXVpcmVtZW50cyUzRCU1QiUyMnRyYW5zZm9ybWVycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2V4YW1wbGUlM0RwZC5EYXRhRnJhbWUoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlc3Rpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGVyZSUyMGRvJTIweW91JTIwbGl2ZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHlvdXIlMjBuYW1lJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVsX2NvbnRleHQlMjIlM0ElMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEhhbnMlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-keyword">with</span> mlflow.start_run():
    model_info = mlflow.pyfunc.log_model(
        <span class="hljs-string">&quot;question_answerer&quot;</span>,
        registered_model_name=<span class="hljs-string">&quot;question_answerer&quot;</span>,
        python_model=QuestionAnswererModel(),
        pip_requirements=[<span class="hljs-string">&quot;transformers&quot;</span>],
        input_example=pd.DataFrame({
            <span class="hljs-string">&quot;question&quot;</span>: [
                <span class="hljs-string">&quot;Where do you live?&quot;</span>,
                <span class="hljs-string">&quot;What is your name?&quot;</span>,
            ],
        }),
        model_config={
            <span class="hljs-string">&quot;model_context&quot;</span>: <span class="hljs-string">&quot;My name is Hans and I live in Germany.&quot;</span>,
        },
    )`,wrap:!1}}),Sl=new T({props:{code:"cHJpbnQobW9kZWxfaW5mby5zaWduYXR1cmUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model_info.signature)',wrap:!1}}),zl=new T({props:{code:"ZnJvbSUyMHJheSUyMGltcG9ydCUyMHNlcnZlJTBBJTBBc2VydmUucnVuKCUwQSUyMCUyMCUyMCUyMGRlcGxveW1lbnRfZnJvbV9tb2RlbF9uYW1lKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXN0aW9uX2Fuc3dlcmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmYXVsdF92ZXJzaW9uJTNEc3RyKG1vZGVsX2luZm8ucmVnaXN0ZXJlZF9tb2RlbF92ZXJzaW9uKSUyQyUwQSUyMCUyMCUyMCUyMCkuYmluZCgpJTJDJTBBJTIwJTIwJTIwJTIwYmxvY2tpbmclM0RGYWxzZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> ray <span class="hljs-keyword">import</span> serve

serve.run(
    deployment_from_model_name(
        <span class="hljs-string">&quot;question_answerer&quot;</span>,
        default_version=<span class="hljs-built_in">str</span>(model_info.registered_model_version),
    ).bind(),
    blocking=<span class="hljs-literal">False</span>
)`,wrap:!1}}),Fl=new T({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNlcnZlJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRCU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyVGhlJTIwd2VhdGhlciUyMGlzJTIwbG92ZWx5JTIwdG9kYXklMjIlN0QlMkMlMEEpJTBBcHJpbnQocmVzcC5qc29uKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>resp = requests.post(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://127.0.0.1:8000/serve/&quot;</span>,
<span class="hljs-meta">... </span>    json={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;The weather is lovely today&quot;</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(resp.json())`,wrap:!1}}),Ll=new u({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),ls=new u({props:{title:"Exercises",local:"exercises",headingTag:"h2"}}),es=new Mn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/mlflow_ray_serve.md"}}),{c(){d=o("meta"),as=n(),ts=o("p"),os=n(),p(U.$$.fragment),Ms=n(),p(c.$$.fragment),is=n(),p(j.$$.fragment),ps=n(),h=o("p"),h.innerHTML=Ye,ys=n(),p(I.$$.fragment),rs=n(),C=o("p"),C.textContent=Le,ws=n(),p(f.$$.fragment),Js=n(),b=o("p"),b.textContent=De,ms=n(),g=o("ul"),g.innerHTML=Ke,Ts=n(),v=o("p"),v.textContent=Pe,us=n(),Z=o("p"),Z.textContent=Oe,ds=n(),A=o("blockquote"),A.innerHTML=lt,Us=n(),p(B.$$.fragment),cs=n(),_=o("p"),_.textContent=st,js=n(),G=o("ul"),G.innerHTML=et,hs=n(),W=o("p"),W.textContent=tt,Is=n(),R=o("p"),R.innerHTML=nt,Cs=n(),k=o("p"),k.textContent=at,fs=n(),p(V.$$.fragment),bs=n(),p(x.$$.fragment),gs=n(),E=o("p"),E.textContent=ot,vs=n(),p(X.$$.fragment),Zs=n(),q=o("p"),q.textContent=Mt,As=n(),Q=o("p"),Q.innerHTML=it,Bs=n(),p($.$$.fragment),_s=n(),N=o("p"),N.textContent=pt,Gs=n(),p(S.$$.fragment),Ws=n(),H=o("p"),H.innerHTML=yt,Rs=n(),p(z.$$.fragment),ks=n(),F=o("pre"),F.textContent=rt,Vs=n(),p(Y.$$.fragment),xs=n(),L=o("p"),L.innerHTML=wt,Es=n(),D=o("ul"),D.innerHTML=Jt,Xs=n(),p(K.$$.fragment),qs=n(),P=o("p"),P.innerHTML=mt,Qs=n(),O=o("p"),O.textContent=Tt,$s=n(),p(ll.$$.fragment),Ns=n(),p(sl.$$.fragment),Ss=n(),el=o("pre"),el.textContent=ut,Hs=n(),tl=o("p"),tl.innerHTML=dt,zs=n(),nl=o("p"),nl.innerHTML=Ut,Fs=n(),p(al.$$.fragment),Ys=n(),ol=o("p"),ol.innerHTML=ct,Ls=n(),Ml=o("p"),Ml.innerHTML=jt,Ds=n(),il=o("p"),il.textContent=ht,Ks=n(),pl=o("p"),pl.innerHTML=It,Ps=n(),yl=o("p"),yl.innerHTML=Ct,Os=n(),rl=o("p"),rl.textContent=ft,le=n(),p(wl.$$.fragment),se=n(),p(Jl.$$.fragment),ee=n(),ml=o("p"),ml.textContent=bt,te=n(),p(Tl.$$.fragment),ne=n(),ul=o("p"),ul.textContent=gt,ae=n(),p(dl.$$.fragment),oe=n(),Ul=o("pre"),Ul.textContent=vt,Me=n(),cl=o("p"),cl.innerHTML=Zt,ie=n(),jl=o("p"),jl.innerHTML=At,pe=n(),p(hl.$$.fragment),ye=n(),Il=o("pre"),Il.textContent=Bt,re=n(),p(Cl.$$.fragment),we=n(),fl=o("p"),fl.textContent=_t,Je=n(),bl=o("p"),bl.innerHTML=Gt,me=n(),gl=o("p"),gl.innerHTML=Wt,Te=n(),vl=o("p"),vl.textContent=Rt,ue=n(),Zl=o("p"),Zl.textContent=kt,de=n(),Al=o("p"),Al.textContent=Vt,Ue=n(),p(Bl.$$.fragment),ce=n(),p(_l.$$.fragment),je=n(),p(Gl.$$.fragment),he=n(),Wl=o("pre"),Wl.textContent=xt,Ie=n(),p(Rl.$$.fragment),Ce=n(),kl=o("pre"),kl.textContent=Et,fe=n(),Vl=o("p"),Vl.innerHTML=Xt,be=n(),xl=o("p"),xl.textContent=qt,ge=n(),p(El.$$.fragment),ve=n(),p(Xl.$$.fragment),Ze=n(),ql=o("p"),ql.innerHTML=Qt,Ae=n(),Ql=o("p"),Ql.innerHTML=$t,Be=n(),p($l.$$.fragment),_e=n(),p(Nl.$$.fragment),Ge=n(),p(Sl.$$.fragment),We=n(),Hl=o("pre"),Hl.textContent=Nt,Re=n(),p(zl.$$.fragment),ke=n(),p(Fl.$$.fragment),Ve=n(),Yl=o("pre"),Yl.textContent=St,xe=n(),p(Ll.$$.fragment),Ee=n(),Dl=o("p"),Dl.textContent=Ht,Xe=n(),Kl=o("ul"),Kl.innerHTML=zt,qe=n(),Pl=o("p"),Pl.innerHTML=Ft,Qe=n(),Ol=o("p"),Ol.textContent=Yt,$e=n(),p(ls.$$.fragment),Ne=n(),ss=o("ul"),ss.innerHTML=Lt,Se=n(),p(es.$$.fragment),He=n(),ns=o("p"),this.h()},l(l){const s=tn("svelte-u9bgzb",document.head);d=M(s,"META",{name:!0,content:!0}),s.forEach(e),as=a(l),ts=M(l,"P",{}),Dt(ts).forEach(e),os=a(l),y(U.$$.fragment,l),Ms=a(l),y(c.$$.fragment,l),is=a(l),y(j.$$.fragment,l),ps=a(l),h=M(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-15wt2km"&&(h.innerHTML=Ye),ys=a(l),y(I.$$.fragment,l),rs=a(l),C=M(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1lijov1"&&(C.textContent=Le),ws=a(l),y(f.$$.fragment,l),Js=a(l),b=M(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1696eie"&&(b.textContent=De),ms=a(l),g=M(l,"UL",{"data-svelte-h":!0}),i(g)!=="svelte-alquk9"&&(g.innerHTML=Ke),Ts=a(l),v=M(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-nuungn"&&(v.textContent=Pe),us=a(l),Z=M(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ixpdif"&&(Z.textContent=Oe),ds=a(l),A=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(A)!=="svelte-1nhcdmi"&&(A.innerHTML=lt),Us=a(l),y(B.$$.fragment,l),cs=a(l),_=M(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-n7k5lz"&&(_.textContent=st),js=a(l),G=M(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-wvnude"&&(G.innerHTML=et),hs=a(l),W=M(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-ax5rm3"&&(W.textContent=tt),Is=a(l),R=M(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-9gfume"&&(R.innerHTML=nt),Cs=a(l),k=M(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1hnxkgd"&&(k.textContent=at),fs=a(l),y(V.$$.fragment,l),bs=a(l),y(x.$$.fragment,l),gs=a(l),E=M(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1dqc8q9"&&(E.textContent=ot),vs=a(l),y(X.$$.fragment,l),Zs=a(l),q=M(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1960jap"&&(q.textContent=Mt),As=a(l),Q=M(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ncm2gu"&&(Q.innerHTML=it),Bs=a(l),y($.$$.fragment,l),_s=a(l),N=M(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-83645o"&&(N.textContent=pt),Gs=a(l),y(S.$$.fragment,l),Ws=a(l),H=M(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-a1ir6"&&(H.innerHTML=yt),Rs=a(l),y(z.$$.fragment,l),ks=a(l),F=M(l,"PRE",{"data-svelte-h":!0}),i(F)!=="svelte-10zklww"&&(F.textContent=rt),Vs=a(l),y(Y.$$.fragment,l),xs=a(l),L=M(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-uflyhq"&&(L.innerHTML=wt),Es=a(l),D=M(l,"UL",{"data-svelte-h":!0}),i(D)!=="svelte-11hhfc9"&&(D.innerHTML=Jt),Xs=a(l),y(K.$$.fragment,l),qs=a(l),P=M(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-6jerq0"&&(P.innerHTML=mt),Qs=a(l),O=M(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-cjqdtn"&&(O.textContent=Tt),$s=a(l),y(ll.$$.fragment,l),Ns=a(l),y(sl.$$.fragment,l),Ss=a(l),el=M(l,"PRE",{"data-svelte-h":!0}),i(el)!=="svelte-e2muls"&&(el.textContent=ut),Hs=a(l),tl=M(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1q4b85e"&&(tl.innerHTML=dt),zs=a(l),nl=M(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1f3zasy"&&(nl.innerHTML=Ut),Fs=a(l),y(al.$$.fragment,l),Ys=a(l),ol=M(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1mro102"&&(ol.innerHTML=ct),Ls=a(l),Ml=M(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1934t55"&&(Ml.innerHTML=jt),Ds=a(l),il=M(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1dfp1gw"&&(il.textContent=ht),Ks=a(l),pl=M(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-16nv6bl"&&(pl.innerHTML=It),Ps=a(l),yl=M(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1brh20n"&&(yl.innerHTML=Ct),Os=a(l),rl=M(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1w05arq"&&(rl.textContent=ft),le=a(l),y(wl.$$.fragment,l),se=a(l),y(Jl.$$.fragment,l),ee=a(l),ml=M(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-gnpi09"&&(ml.textContent=bt),te=a(l),y(Tl.$$.fragment,l),ne=a(l),ul=M(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-94uta8"&&(ul.textContent=gt),ae=a(l),y(dl.$$.fragment,l),oe=a(l),Ul=M(l,"PRE",{"data-svelte-h":!0}),i(Ul)!=="svelte-s3g3o9"&&(Ul.textContent=vt),Me=a(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-8h7gxy"&&(cl.innerHTML=Zt),ie=a(l),jl=M(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-1i62yy7"&&(jl.innerHTML=At),pe=a(l),y(hl.$$.fragment,l),ye=a(l),Il=M(l,"PRE",{"data-svelte-h":!0}),i(Il)!=="svelte-e2muls"&&(Il.textContent=Bt),re=a(l),y(Cl.$$.fragment,l),we=a(l),fl=M(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1o4zzgm"&&(fl.textContent=_t),Je=a(l),bl=M(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-swa1v3"&&(bl.innerHTML=Gt),me=a(l),gl=M(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1a5u6kx"&&(gl.innerHTML=Wt),Te=a(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-1vumo5l"&&(vl.textContent=Rt),ue=a(l),Zl=M(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1xhx9bf"&&(Zl.textContent=kt),de=a(l),Al=M(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-12c4mta"&&(Al.textContent=Vt),Ue=a(l),y(Bl.$$.fragment,l),ce=a(l),y(_l.$$.fragment,l),je=a(l),y(Gl.$$.fragment,l),he=a(l),Wl=M(l,"PRE",{"data-svelte-h":!0}),i(Wl)!=="svelte-s3g3o9"&&(Wl.textContent=xt),Ie=a(l),y(Rl.$$.fragment,l),Ce=a(l),kl=M(l,"PRE",{"data-svelte-h":!0}),i(kl)!=="svelte-s3g3o9"&&(kl.textContent=Et),fe=a(l),Vl=M(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-kwrm3f"&&(Vl.innerHTML=Xt),be=a(l),xl=M(l,"P",{"data-svelte-h":!0}),i(xl)!=="svelte-s43neq"&&(xl.textContent=qt),ge=a(l),y(El.$$.fragment,l),ve=a(l),y(Xl.$$.fragment,l),Ze=a(l),ql=M(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-1a9wpz3"&&(ql.innerHTML=Qt),Ae=a(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-uhpahh"&&(Ql.innerHTML=$t),Be=a(l),y($l.$$.fragment,l),_e=a(l),y(Nl.$$.fragment,l),Ge=a(l),y(Sl.$$.fragment,l),We=a(l),Hl=M(l,"PRE",{"data-svelte-h":!0}),i(Hl)!=="svelte-hmoafl"&&(Hl.textContent=Nt),Re=a(l),y(zl.$$.fragment,l),ke=a(l),y(Fl.$$.fragment,l),Ve=a(l),Yl=M(l,"PRE",{"data-svelte-h":!0}),i(Yl)!=="svelte-uqrhuo"&&(Yl.textContent=St),xe=a(l),y(Ll.$$.fragment,l),Ee=a(l),Dl=M(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-1smtqgx"&&(Dl.textContent=Ht),Xe=a(l),Kl=M(l,"UL",{"data-svelte-h":!0}),i(Kl)!=="svelte-ltetir"&&(Kl.innerHTML=zt),qe=a(l),Pl=M(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-1bodq55"&&(Pl.innerHTML=Ft),Qe=a(l),Ol=M(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-vdmzas"&&(Ol.textContent=Yt),$e=a(l),y(ls.$$.fragment,l),Ne=a(l),ss=M(l,"UL",{"data-svelte-h":!0}),i(ss)!=="svelte-mffr65"&&(ss.innerHTML=Lt),Se=a(l),y(es.$$.fragment,l),He=a(l),ns=M(l,"P",{}),Dt(ns).forEach(e),this.h()},h(){Kt(d,"name","hf:doc:metadata"),Kt(d,"content",yn)},m(l,s){nn(document.head,d),t(l,as,s),t(l,ts,s),t(l,os,s),r(U,l,s),t(l,Ms,s),r(c,l,s),t(l,is,s),r(j,l,s),t(l,ps,s),t(l,h,s),t(l,ys,s),r(I,l,s),t(l,rs,s),t(l,C,s),t(l,ws,s),r(f,l,s),t(l,Js,s),t(l,b,s),t(l,ms,s),t(l,g,s),t(l,Ts,s),t(l,v,s),t(l,us,s),t(l,Z,s),t(l,ds,s),t(l,A,s),t(l,Us,s),r(B,l,s),t(l,cs,s),t(l,_,s),t(l,js,s),t(l,G,s),t(l,hs,s),t(l,W,s),t(l,Is,s),t(l,R,s),t(l,Cs,s),t(l,k,s),t(l,fs,s),r(V,l,s),t(l,bs,s),r(x,l,s),t(l,gs,s),t(l,E,s),t(l,vs,s),r(X,l,s),t(l,Zs,s),t(l,q,s),t(l,As,s),t(l,Q,s),t(l,Bs,s),r($,l,s),t(l,_s,s),t(l,N,s),t(l,Gs,s),r(S,l,s),t(l,Ws,s),t(l,H,s),t(l,Rs,s),r(z,l,s),t(l,ks,s),t(l,F,s),t(l,Vs,s),r(Y,l,s),t(l,xs,s),t(l,L,s),t(l,Es,s),t(l,D,s),t(l,Xs,s),r(K,l,s),t(l,qs,s),t(l,P,s),t(l,Qs,s),t(l,O,s),t(l,$s,s),r(ll,l,s),t(l,Ns,s),r(sl,l,s),t(l,Ss,s),t(l,el,s),t(l,Hs,s),t(l,tl,s),t(l,zs,s),t(l,nl,s),t(l,Fs,s),r(al,l,s),t(l,Ys,s),t(l,ol,s),t(l,Ls,s),t(l,Ml,s),t(l,Ds,s),t(l,il,s),t(l,Ks,s),t(l,pl,s),t(l,Ps,s),t(l,yl,s),t(l,Os,s),t(l,rl,s),t(l,le,s),r(wl,l,s),t(l,se,s),r(Jl,l,s),t(l,ee,s),t(l,ml,s),t(l,te,s),r(Tl,l,s),t(l,ne,s),t(l,ul,s),t(l,ae,s),r(dl,l,s),t(l,oe,s),t(l,Ul,s),t(l,Me,s),t(l,cl,s),t(l,ie,s),t(l,jl,s),t(l,pe,s),r(hl,l,s),t(l,ye,s),t(l,Il,s),t(l,re,s),r(Cl,l,s),t(l,we,s),t(l,fl,s),t(l,Je,s),t(l,bl,s),t(l,me,s),t(l,gl,s),t(l,Te,s),t(l,vl,s),t(l,ue,s),t(l,Zl,s),t(l,de,s),t(l,Al,s),t(l,Ue,s),r(Bl,l,s),t(l,ce,s),r(_l,l,s),t(l,je,s),r(Gl,l,s),t(l,he,s),t(l,Wl,s),t(l,Ie,s),r(Rl,l,s),t(l,Ce,s),t(l,kl,s),t(l,fe,s),t(l,Vl,s),t(l,be,s),t(l,xl,s),t(l,ge,s),r(El,l,s),t(l,ve,s),r(Xl,l,s),t(l,Ze,s),t(l,ql,s),t(l,Ae,s),t(l,Ql,s),t(l,Be,s),r($l,l,s),t(l,_e,s),r(Nl,l,s),t(l,Ge,s),r(Sl,l,s),t(l,We,s),t(l,Hl,s),t(l,Re,s),r(zl,l,s),t(l,ke,s),r(Fl,l,s),t(l,Ve,s),t(l,Yl,s),t(l,xe,s),r(Ll,l,s),t(l,Ee,s),t(l,Dl,s),t(l,Xe,s),t(l,Kl,s),t(l,qe,s),t(l,Pl,s),t(l,Qe,s),t(l,Ol,s),t(l,$e,s),r(ls,l,s),t(l,Ne,s),t(l,ss,s),t(l,Se,s),r(es,l,s),t(l,He,s),t(l,ns,s),ze=!0},p:Ot,i(l){ze||(w(U.$$.fragment,l),w(c.$$.fragment,l),w(j.$$.fragment,l),w(I.$$.fragment,l),w(f.$$.fragment,l),w(B.$$.fragment,l),w(V.$$.fragment,l),w(x.$$.fragment,l),w(X.$$.fragment,l),w($.$$.fragment,l),w(S.$$.fragment,l),w(z.$$.fragment,l),w(Y.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(sl.$$.fragment,l),w(al.$$.fragment,l),w(wl.$$.fragment,l),w(Jl.$$.fragment,l),w(Tl.$$.fragment,l),w(dl.$$.fragment,l),w(hl.$$.fragment,l),w(Cl.$$.fragment,l),w(Bl.$$.fragment,l),w(_l.$$.fragment,l),w(Gl.$$.fragment,l),w(Rl.$$.fragment,l),w(El.$$.fragment,l),w(Xl.$$.fragment,l),w($l.$$.fragment,l),w(Nl.$$.fragment,l),w(Sl.$$.fragment,l),w(zl.$$.fragment,l),w(Fl.$$.fragment,l),w(Ll.$$.fragment,l),w(ls.$$.fragment,l),w(es.$$.fragment,l),ze=!0)},o(l){J(U.$$.fragment,l),J(c.$$.fragment,l),J(j.$$.fragment,l),J(I.$$.fragment,l),J(f.$$.fragment,l),J(B.$$.fragment,l),J(V.$$.fragment,l),J(x.$$.fragment,l),J(X.$$.fragment,l),J($.$$.fragment,l),J(S.$$.fragment,l),J(z.$$.fragment,l),J(Y.$$.fragment,l),J(K.$$.fragment,l),J(ll.$$.fragment,l),J(sl.$$.fragment,l),J(al.$$.fragment,l),J(wl.$$.fragment,l),J(Jl.$$.fragment,l),J(Tl.$$.fragment,l),J(dl.$$.fragment,l),J(hl.$$.fragment,l),J(Cl.$$.fragment,l),J(Bl.$$.fragment,l),J(_l.$$.fragment,l),J(Gl.$$.fragment,l),J(Rl.$$.fragment,l),J(El.$$.fragment,l),J(Xl.$$.fragment,l),J($l.$$.fragment,l),J(Nl.$$.fragment,l),J(Sl.$$.fragment,l),J(zl.$$.fragment,l),J(Fl.$$.fragment,l),J(Ll.$$.fragment,l),J(ls.$$.fragment,l),J(es.$$.fragment,l),ze=!1},d(l){l&&(e(as),e(ts),e(os),e(Ms),e(is),e(ps),e(h),e(ys),e(rs),e(C),e(ws),e(Js),e(b),e(ms),e(g),e(Ts),e(v),e(us),e(Z),e(ds),e(A),e(Us),e(cs),e(_),e(js),e(G),e(hs),e(W),e(Is),e(R),e(Cs),e(k),e(fs),e(bs),e(gs),e(E),e(vs),e(Zs),e(q),e(As),e(Q),e(Bs),e(_s),e(N),e(Gs),e(Ws),e(H),e(Rs),e(ks),e(F),e(Vs),e(xs),e(L),e(Es),e(D),e(Xs),e(qs),e(P),e(Qs),e(O),e($s),e(Ns),e(Ss),e(el),e(Hs),e(tl),e(zs),e(nl),e(Fs),e(Ys),e(ol),e(Ls),e(Ml),e(Ds),e(il),e(Ks),e(pl),e(Ps),e(yl),e(Os),e(rl),e(le),e(se),e(ee),e(ml),e(te),e(ne),e(ul),e(ae),e(oe),e(Ul),e(Me),e(cl),e(ie),e(jl),e(pe),e(ye),e(Il),e(re),e(we),e(fl),e(Je),e(bl),e(me),e(gl),e(Te),e(vl),e(ue),e(Zl),e(de),e(Al),e(Ue),e(ce),e(je),e(he),e(Wl),e(Ie),e(Ce),e(kl),e(fe),e(Vl),e(be),e(xl),e(ge),e(ve),e(Ze),e(ql),e(Ae),e(Ql),e(Be),e(_e),e(Ge),e(We),e(Hl),e(Re),e(ke),e(Ve),e(Yl),e(xe),e(Ee),e(Dl),e(Xe),e(Kl),e(qe),e(Pl),e(Qe),e(Ol),e($e),e(Ne),e(ss),e(Se),e(He),e(ns)),e(d),m(U,l),m(c,l),m(j,l),m(I,l),m(f,l),m(B,l),m(V,l),m(x,l),m(X,l),m($,l),m(S,l),m(z,l),m(Y,l),m(K,l),m(ll,l),m(sl,l),m(al,l),m(wl,l),m(Jl,l),m(Tl,l),m(dl,l),m(hl,l),m(Cl,l),m(Bl,l),m(_l,l),m(Gl,l),m(Rl,l),m(El,l),m(Xl,l),m($l,l),m(Nl,l),m(Sl,l),m(zl,l),m(Fl,l),m(Ll,l),m(ls,l),m(es,l)}}}const yn='{"title":"Signature-Aware Model Serving from MLflow with Ray Serve","local":"signature-aware-model-serving-from-mlflow-with-ray-serve","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Motivation","local":"motivation","sections":[],"depth":2},{"title":"Components","local":"components","sections":[],"depth":2},{"title":"Register the Model","local":"register-the-model","sections":[],"depth":2},{"title":"Serve the Model","local":"serve-the-model","sections":[],"depth":2},{"title":"Multiple Versions, One Endpoint","local":"multiple-versions-one-endpoint","sections":[],"depth":2},{"title":"Auto-Signature","local":"auto-signature","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Exercises","local":"exercises","sections":[],"depth":2}],"depth":1}';function rn(Fe){return ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends sn{constructor(d){super(),en(this,d,rn,pn,Pt,{})}}export{dn as component};
