import{s as Bt,n as kt,o as $t}from"../chunks/scheduler.1f027d5a.js";import{S as At,i as Zt,e as M,s,c as o,h as _t,a as i,d as l,b as a,f as gt,g as y,j as w,k as vt,l as St,m as n,n as J,t as T,o as U,p}from"../chunks/index.5cb6ce42.js";import{C as Gt}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Wt,C as r}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as Oe,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Lt(Ke){let C,ie,ae,we,I,oe,m,ye,c,Je,u,et='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Te,d,tt='<p>This tutorial is advanced. You should have notions from <a href="agents">this other cookbook</a> first!</p>',Ue,h,lt="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",pe,j,nt="It will be a simple hierarchy, using a <code>ManagedAgent</code> object to wrap the managed web search agent:",re,b,Ce,f,st="Let’s set up this system.",Ie,g,at="Run the line below to install the required dependencies:",me,v,ce,B,Mt="Let’s login in order to call the HF Inference API:",ue,k,de,$,it='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> using <code>HfApiEngine</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',he,A,wt='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',je,Z,be,_,fe,S,ot='For web browsing, we can already use our pre-existing <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/agents/search.py" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> tool to provide a Google search equivalent.',ge,G,yt=`But then we will also need to be able to peak into the page found by the <code>DuckDuckGoSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,ve,W,Jt="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",Be,Q,ke,L,Tt="Ok, now let’s initialize and test our tool!",$e,R,Ae,x,Ut=`Hugging Face - Wikipedia

[Jump to content](#bodyContent)

Main menu

Main menu
move to sidebar
hide

Navigation

* [Main page](/wiki/Main_Page "Visit the main page [z]")
* [Contents](/wiki/Wikipedia:Contents "Guides to browsing Wikipedia")
* [Current events](/wiki/Portal:Current_events "Articles related to current events")
* [Random article](/wiki/Special:Random "Visit a randomly selected article [x]")
* [About Wikipedia](/wiki/Wikipedia:About "Learn about Wikipedia and how it works")
* [Contac
`,Ze,V,_e,H,pt="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Se,X,rt="Which configuration to choose for this agent?",Ge,E,Ct="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ReactJsonAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_iterations</code> to 10.</li>",We,N,Qe,Y,It="We then wrap this agent into a <code>ManagedAgent</code> that will make it callable by its manager agent.",Le,F,Re,q,mt="Finally we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",xe,z,ct="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>ReactCodeAgent</code> will be the best choice.",Ve,P,ut="Also, we want to ask a question that involves the current year: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;datetime&quot;]</code>",He,D,Xe,O,dt="That’s all! Now let’s run our system! We select a question that requires some calculation and",Ee,K,Ne,ee,ht="Our agents managed to efficiently collaborate towards solving the task! ✅",Ye,te,jt="💡 You can easily extend this to more agents: one does the code execution, one the web search, one handles file loadings…",Fe,le,bt="🤔💭 One could even think of doing more complex, tree-like hierarchies, with one CEO agent handling multiple middle managers, each with several reports.",qe,ne,ft="We could even add more intermediate layers of management, each with multiple daily meetings, lots of agile stuff with scrum masters, and each new component adds enough friction to ensure the tasks never get done… Ehm wait, no, let’s stick with our simple structure.",ze,se,Pe,Me,De;return I=new Wt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.ipynb"}]}}),m=new Gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),c=new Oe({props:{title:"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖",local:"have-several-agents-collaborate-in-a-multi-agent-hierarchy-",headingTag:"h1"}}),b=new r({props:{code:"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",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  Code interpreter   +--------------------------------+
       tool          |<span class="hljs-string">         Managed agent          </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> Web Search agent </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  Web Search tool     </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             Visit webpage tool </span>|
                     +--------------------------------+`,wrap:!1}}),v=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install markdownify duckduckgo-search smolagents --upgrade -q",wrap:!1}}),k=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Z=new r({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>',wrap:!1}}),_=new Oe({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h3"}}),Q=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify <span class="hljs-keyword">as</span> md
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = md(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),R=new r({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),V=new Oe({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),N=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwTWFuYWdlZEFnZW50JTJDJTBBJTIwJTIwJTIwJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCklMEElMEF3ZWJfYWdlbnQlMjAlM0QlMjBUb29sQ2FsbGluZ0FnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2l0ZXJhdGlvbnMlM0QxMCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    InferenceClientModel,
    ManagedAgent,
    DuckDuckGoSearchTool
)

model = InferenceClientModel(model_id)

web_agent = ToolCallingAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    model=model,
    max_iterations=<span class="hljs-number">10</span>,
)`,wrap:!1}}),F=new r({props:{code:"bWFuYWdlZF93ZWJfYWdlbnQlMjAlM0QlMjBNYW5hZ2VkQWdlbnQoJTBBJTIwJTIwJTIwJTIwYWdlbnQlM0R3ZWJfYWdlbnQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),D=new r({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1Qm1hbmFnZWRfd2ViX2FnZW50JTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJ0aW1lJTIyJTJDJTIwJTIyZGF0ZXRpbWUlMjIlNUQlMkMlMEEp",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[managed_web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;datetime&quot;</span>],
)`,wrap:!1}}),K=new r({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIySG93JTIwbWFueSUyMHllYXJzJTIwYWdvJTIwd2FzJTIwU3RyaXBlJTIwZm91bmRlZCUzRiUyMik=",highlighted:'manager_agent.run(<span class="hljs-string">&quot;How many years ago was Stripe founded?&quot;</span>)',wrap:!1}}),se=new Qt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.md"}}),{c(){C=M("meta"),ie=s(),ae=M("p"),we=s(),o(I.$$.fragment),oe=s(),o(m.$$.fragment),ye=s(),o(c.$$.fragment),Je=s(),u=M("p"),u.innerHTML=et,Te=s(),d=M("blockquote"),d.innerHTML=tt,Ue=s(),h=M("p"),h.innerHTML=lt,pe=s(),j=M("p"),j.innerHTML=nt,re=s(),o(b.$$.fragment),Ce=s(),f=M("p"),f.textContent=st,Ie=s(),g=M("p"),g.textContent=at,me=s(),o(v.$$.fragment),ce=s(),B=M("p"),B.textContent=Mt,ue=s(),o(k.$$.fragment),de=s(),$=M("p"),$.innerHTML=it,he=s(),A=M("p"),A.innerHTML=wt,je=s(),o(Z.$$.fragment),be=s(),o(_.$$.fragment),fe=s(),S=M("p"),S.innerHTML=ot,ge=s(),G=M("p"),G.innerHTML=yt,ve=s(),W=M("p"),W.innerHTML=Jt,Be=s(),o(Q.$$.fragment),ke=s(),L=M("p"),L.textContent=Tt,$e=s(),o(R.$$.fragment),Ae=s(),x=M("pre"),x.textContent=Ut,Ze=s(),o(V.$$.fragment),_e=s(),H=M("p"),H.innerHTML=pt,Se=s(),X=M("p"),X.textContent=rt,Ge=s(),E=M("ul"),E.innerHTML=Ct,We=s(),o(N.$$.fragment),Qe=s(),Y=M("p"),Y.innerHTML=It,Le=s(),o(F.$$.fragment),Re=s(),q=M("p"),q.innerHTML=mt,xe=s(),z=M("p"),z.innerHTML=ct,Ve=s(),P=M("p"),P.innerHTML=ut,He=s(),o(D.$$.fragment),Xe=s(),O=M("p"),O.textContent=dt,Ee=s(),o(K.$$.fragment),Ne=s(),ee=M("p"),ee.textContent=ht,Ye=s(),te=M("p"),te.textContent=jt,Fe=s(),le=M("p"),le.textContent=bt,qe=s(),ne=M("p"),ne.textContent=ft,ze=s(),o(se.$$.fragment),Pe=s(),Me=M("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);C=i(t,"META",{name:!0,content:!0}),t.forEach(l),ie=a(e),ae=i(e,"P",{}),gt(ae).forEach(l),we=a(e),y(I.$$.fragment,e),oe=a(e),y(m.$$.fragment,e),ye=a(e),y(c.$$.fragment,e),Je=a(e),u=i(e,"P",{"data-svelte-h":!0}),w(u)!=="svelte-1xlqnsv"&&(u.innerHTML=et),Te=a(e),d=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),w(d)!=="svelte-uy67xy"&&(d.innerHTML=tt),Ue=a(e),h=i(e,"P",{"data-svelte-h":!0}),w(h)!=="svelte-45abwn"&&(h.innerHTML=lt),pe=a(e),j=i(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-1se9mth"&&(j.innerHTML=nt),re=a(e),y(b.$$.fragment,e),Ce=a(e),f=i(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-1occiln"&&(f.textContent=st),Ie=a(e),g=i(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-ofrdjq"&&(g.textContent=at),me=a(e),y(v.$$.fragment,e),ce=a(e),B=i(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-64fox6"&&(B.textContent=Mt),ue=a(e),y(k.$$.fragment,e),de=a(e),$=i(e,"P",{"data-svelte-h":!0}),w($)!=="svelte-prbpzw"&&($.innerHTML=it),he=a(e),A=i(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1faawbb"&&(A.innerHTML=wt),je=a(e),y(Z.$$.fragment,e),be=a(e),y(_.$$.fragment,e),fe=a(e),S=i(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-1ya2chk"&&(S.innerHTML=ot),ge=a(e),G=i(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-n7spa8"&&(G.innerHTML=yt),ve=a(e),W=i(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1ms2uj2"&&(W.innerHTML=Jt),Be=a(e),y(Q.$$.fragment,e),ke=a(e),L=i(e,"P",{"data-svelte-h":!0}),w(L)!=="svelte-hbvg5t"&&(L.textContent=Tt),$e=a(e),y(R.$$.fragment,e),Ae=a(e),x=i(e,"PRE",{"data-svelte-h":!0}),w(x)!=="svelte-28re01"&&(x.textContent=Ut),Ze=a(e),y(V.$$.fragment,e),_e=a(e),H=i(e,"P",{"data-svelte-h":!0}),w(H)!=="svelte-5768lo"&&(H.innerHTML=pt),Se=a(e),X=i(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-noa5rw"&&(X.textContent=rt),Ge=a(e),E=i(e,"UL",{"data-svelte-h":!0}),w(E)!=="svelte-4uouvt"&&(E.innerHTML=Ct),We=a(e),y(N.$$.fragment,e),Qe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-1by3x3d"&&(Y.innerHTML=It),Le=a(e),y(F.$$.fragment,e),Re=a(e),q=i(e,"P",{"data-svelte-h":!0}),w(q)!=="svelte-12kldg5"&&(q.innerHTML=mt),xe=a(e),z=i(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-julrcm"&&(z.innerHTML=ct),Ve=a(e),P=i(e,"P",{"data-svelte-h":!0}),w(P)!=="svelte-hvhtn0"&&(P.innerHTML=ut),He=a(e),y(D.$$.fragment,e),Xe=a(e),O=i(e,"P",{"data-svelte-h":!0}),w(O)!=="svelte-1gu46sl"&&(O.textContent=dt),Ee=a(e),y(K.$$.fragment,e),Ne=a(e),ee=i(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-ollz3q"&&(ee.textContent=ht),Ye=a(e),te=i(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-1v517hq"&&(te.textContent=jt),Fe=a(e),le=i(e,"P",{"data-svelte-h":!0}),w(le)!=="svelte-58qi1z"&&(le.textContent=bt),qe=a(e),ne=i(e,"P",{"data-svelte-h":!0}),w(ne)!=="svelte-9myor3"&&(ne.textContent=ft),ze=a(e),y(se.$$.fragment,e),Pe=a(e),Me=i(e,"P",{}),gt(Me).forEach(l),this.h()},h(){vt(C,"name","hf:doc:metadata"),vt(C,"content",Rt)},m(e,t){St(document.head,C),n(e,ie,t),n(e,ae,t),n(e,we,t),J(I,e,t),n(e,oe,t),J(m,e,t),n(e,ye,t),J(c,e,t),n(e,Je,t),n(e,u,t),n(e,Te,t),n(e,d,t),n(e,Ue,t),n(e,h,t),n(e,pe,t),n(e,j,t),n(e,re,t),J(b,e,t),n(e,Ce,t),n(e,f,t),n(e,Ie,t),n(e,g,t),n(e,me,t),J(v,e,t),n(e,ce,t),n(e,B,t),n(e,ue,t),J(k,e,t),n(e,de,t),n(e,$,t),n(e,he,t),n(e,A,t),n(e,je,t),J(Z,e,t),n(e,be,t),J(_,e,t),n(e,fe,t),n(e,S,t),n(e,ge,t),n(e,G,t),n(e,ve,t),n(e,W,t),n(e,Be,t),J(Q,e,t),n(e,ke,t),n(e,L,t),n(e,$e,t),J(R,e,t),n(e,Ae,t),n(e,x,t),n(e,Ze,t),J(V,e,t),n(e,_e,t),n(e,H,t),n(e,Se,t),n(e,X,t),n(e,Ge,t),n(e,E,t),n(e,We,t),J(N,e,t),n(e,Qe,t),n(e,Y,t),n(e,Le,t),J(F,e,t),n(e,Re,t),n(e,q,t),n(e,xe,t),n(e,z,t),n(e,Ve,t),n(e,P,t),n(e,He,t),J(D,e,t),n(e,Xe,t),n(e,O,t),n(e,Ee,t),J(K,e,t),n(e,Ne,t),n(e,ee,t),n(e,Ye,t),n(e,te,t),n(e,Fe,t),n(e,le,t),n(e,qe,t),n(e,ne,t),n(e,ze,t),J(se,e,t),n(e,Pe,t),n(e,Me,t),De=!0},p:kt,i(e){De||(T(I.$$.fragment,e),T(m.$$.fragment,e),T(c.$$.fragment,e),T(b.$$.fragment,e),T(v.$$.fragment,e),T(k.$$.fragment,e),T(Z.$$.fragment,e),T(_.$$.fragment,e),T(Q.$$.fragment,e),T(R.$$.fragment,e),T(V.$$.fragment,e),T(N.$$.fragment,e),T(F.$$.fragment,e),T(D.$$.fragment,e),T(K.$$.fragment,e),T(se.$$.fragment,e),De=!0)},o(e){U(I.$$.fragment,e),U(m.$$.fragment,e),U(c.$$.fragment,e),U(b.$$.fragment,e),U(v.$$.fragment,e),U(k.$$.fragment,e),U(Z.$$.fragment,e),U(_.$$.fragment,e),U(Q.$$.fragment,e),U(R.$$.fragment,e),U(V.$$.fragment,e),U(N.$$.fragment,e),U(F.$$.fragment,e),U(D.$$.fragment,e),U(K.$$.fragment,e),U(se.$$.fragment,e),De=!1},d(e){e&&(l(ie),l(ae),l(we),l(oe),l(ye),l(Je),l(u),l(Te),l(d),l(Ue),l(h),l(pe),l(j),l(re),l(Ce),l(f),l(Ie),l(g),l(me),l(ce),l(B),l(ue),l(de),l($),l(he),l(A),l(je),l(be),l(fe),l(S),l(ge),l(G),l(ve),l(W),l(Be),l(ke),l(L),l($e),l(Ae),l(x),l(Ze),l(_e),l(H),l(Se),l(X),l(Ge),l(E),l(We),l(Qe),l(Y),l(Le),l(Re),l(q),l(xe),l(z),l(Ve),l(P),l(He),l(Xe),l(O),l(Ee),l(Ne),l(ee),l(Ye),l(te),l(Fe),l(le),l(qe),l(ne),l(ze),l(Pe),l(Me)),l(C),p(I,e),p(m,e),p(c,e),p(b,e),p(v,e),p(k,e),p(Z,e),p(_,e),p(Q,e),p(R,e),p(V,e),p(N,e),p(F,e),p(D,e),p(K,e),p(se,e)}}}const Rt='{"title":"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖","local":"have-several-agents-collaborate-in-a-multi-agent-hierarchy-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":3},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function xt(Ke){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends At{constructor(C){super(),Zt(this,C,xt,Lt,Bt,{})}}export{Yt as component};
