import{s as ut,n as Ut,o as jt}from"../chunks/scheduler.1f027d5a.js";import{S as Jt,i as wt,e as M,s as n,c as p,h as mt,a as i,d as s,b as a,f as rt,g as y,j as o,k as ct,l as Tt,m as e,n as r,t as c,o as u,p as U}from"../chunks/index.5cb6ce42.js";import{C as ht}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as bt,C as J}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as xl,E as dt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function It(_l){let j,sl,ll,el,w,nl,m,al,T,Ml,h,Gl='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',il,b,Xl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",ol,d,Yl="What’s the advantage over a standard text-to-SQL pipeline?",pl,I,Fl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",yl,C,Ll="👉 Instead, <strong>an agent system is able to critically inspect outputs and decide if the query needs to be changed or not</strong>, thus giving it a huge performance boost.",rl,g,zl="Let’s build this agent! 💪",cl,f,ul,B,Ul,Q,jl,q,Dl="Let’s check that our system works with a basic query:",Jl,A,wl,Z,Kl=`(1, 'Alan Payne', 12.06, 1.2)
(2, 'Alex Mason', 23.86, 0.24)
(3, 'Woodrow Wilson', 53.43, 5.43)
(4, 'Margaret James', 21.11, 1.0)
`,ml,W,Tl,S,Pl="Now let’s make our SQL table retrievable by a tool.",hl,E,Ol='Our <code>sql_engine</code> tool needs the following: (read <a href="https://huggingface.co/docs/transformers/en/agents#create-a-new-tool" rel="nofollow">the documentation</a> for more detail)',bl,R,lt="<li>A docstring with an <code>Args:</code> part. This docstring will be parsed to become the tool’s <code>description</code> attribute, which will be used as the instruction manual for the LLM powering the agent, so it’s important to provide it!</li> <li>Type hints for inputs and output.</li>",dl,v,Il,k,tt="Now let us create an agent that leverages this tool.",Cl,$,st="We use the <code>CodeAgent</code>, which is <code>transformers.agents</code>’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",gl,N,et='The <code>llm_engine</code> is the LLM that powers the agent system. <code>InferenceClientModel</code> allows you to call LLMs using Hugging Face’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API: check out <a href="agent_change_llm">this other cookbook</a> to learn how to adapt it.',fl,V,Bl,H,Ql,x,ql,_,nt="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Al,G,at="So let’s make a second table recording the names of waiters for each <code>receipt_id</code>!",Zl,X,Wl,Y,Mt="We need to update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",Sl,F,El,L,it=`Allows you to perform SQL queries on the table. Beware that this tool's output is a string representation of the execution output.
It can use the following tables:

Table 'receipts':
Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT

Table 'waiters':
Columns:
  - receipt_id: INTEGER
  - waiter_name: VARCHAR(16)
`,Rl,z,ot='Since this request is a bit harder than the previous one, we’ll switch the llm engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a>!',vl,D,kl,K,pt="It directly works! The setup was surprisingly simple, wasn’t it?",$l,P,yt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",Nl,O,Vl,tl,Hl;return w=new bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.ipynb"}]}}),m=new ht({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new xl({props:{title:"Agent for text-to-SQL with automatic error correction",local:"agent-for-text-to-sql-with-automatic-error-correction",headingTag:"h1"}}),f=new xl({props:{title:"Setup SQL tables",local:"setup-sql-tables",headingTag:"h2"}}),B=new J({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBJTIzJTIwY3JlYXRlJTIwY2l0eSUyMFNRTCUyMHRhYmxlJTBBdGFibGVfbmFtZSUyMCUzRCUyMCUyMnJlY2VpcHRzJTIyJTBBcmVjZWlwdHMlMjAlM0QlMjBUYWJsZSglMEElMjAlMjAlMjAlMjB0YWJsZV9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGFfb2JqJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnJlY2VpcHRfaWQlMjIlMkMlMjBJbnRlZ2VyJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJjdXN0b21lcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycHJpY2UlMjIlMkMlMjBGbG9hdCklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIydGlwJTIyJTJDJTIwRmxvYXQpJTJDJTBBKSUwQW1ldGFkYXRhX29iai5jcmVhdGVfYWxsKGVuZ2luZSk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)`,wrap:!1}}),Q=new J({props:{code:"cm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjBzdG10JTIwJTNEJTIwaW5zZXJ0KHJlY2VpcHRzKS52YWx1ZXMoKipyb3cpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5iZWdpbigpJTIwYXMlMjBjb25uZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3Vyc29yJTIwJTNEJTIwY29ubmVjdGlvbi5leGVjdXRlKHN0bXQp",highlighted:`rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),A=new J({props:{code:"d2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KCUyMiUyMiUyMlNFTEVDVCUyMColMjBmcm9tJTIwcmVjZWlwdHMlMjIlMjIlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJvdyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
<span class="hljs-meta">... </span>    rows = con.execute(text(<span class="hljs-string">&quot;&quot;&quot;SELECT * from receipts&quot;&quot;&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(row)`,wrap:!1}}),W=new xl({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h2"}}),v=new J({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),V=new J({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>),
)`,wrap:!1}}),H=new J({props:{code:"YWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)',wrap:!1}}),x=new xl({props:{title:"Increasing difficulty: Table joins",local:"increasing-difficulty-table-joins",headingTag:"h2"}}),X=new J({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),F=new J({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
<span class="hljs-meta">... </span>It can use the following tables:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
<span class="hljs-meta">... </span>    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

<span class="hljs-meta">... </span>    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

<span class="hljs-meta">... </span>    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join(
<span class="hljs-meta">... </span>        [<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),D=new J({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBJTBBYWdlbnQucnVuKCUyMldoaWNoJTIwd2FpdGVyJTIwZ290JTIwbW9yZSUyMHRvdGFsJTIwbW9uZXklMjBmcm9tJTIwdGlwcyUzRiUyMik=",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),O=new dt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.md"}}),{c(){j=M("meta"),sl=n(),ll=M("p"),el=n(),p(w.$$.fragment),nl=n(),p(m.$$.fragment),al=n(),p(T.$$.fragment),Ml=n(),h=M("p"),h.innerHTML=Gl,il=n(),b=M("p"),b.innerHTML=Xl,ol=n(),d=M("p"),d.textContent=Yl,pl=n(),I=M("p"),I.textContent=Fl,yl=n(),C=M("p"),C.innerHTML=Ll,rl=n(),g=M("p"),g.textContent=zl,cl=n(),p(f.$$.fragment),ul=n(),p(B.$$.fragment),Ul=n(),p(Q.$$.fragment),jl=n(),q=M("p"),q.textContent=Dl,Jl=n(),p(A.$$.fragment),wl=n(),Z=M("pre"),Z.textContent=Kl,ml=n(),p(W.$$.fragment),Tl=n(),S=M("p"),S.textContent=Pl,hl=n(),E=M("p"),E.innerHTML=Ol,bl=n(),R=M("ul"),R.innerHTML=lt,dl=n(),p(v.$$.fragment),Il=n(),k=M("p"),k.textContent=tt,Cl=n(),$=M("p"),$.innerHTML=st,gl=n(),N=M("p"),N.innerHTML=et,fl=n(),p(V.$$.fragment),Bl=n(),p(H.$$.fragment),Ql=n(),p(x.$$.fragment),ql=n(),_=M("p"),_.textContent=nt,Al=n(),G=M("p"),G.innerHTML=at,Zl=n(),p(X.$$.fragment),Wl=n(),Y=M("p"),Y.innerHTML=Mt,Sl=n(),p(F.$$.fragment),El=n(),L=M("pre"),L.textContent=it,Rl=n(),z=M("p"),z.innerHTML=ot,vl=n(),p(D.$$.fragment),kl=n(),K=M("p"),K.textContent=pt,$l=n(),P=M("p"),P.textContent=yt,Nl=n(),p(O.$$.fragment),Vl=n(),tl=M("p"),this.h()},l(l){const t=mt("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(s),sl=a(l),ll=i(l,"P",{}),rt(ll).forEach(s),el=a(l),y(w.$$.fragment,l),nl=a(l),y(m.$$.fragment,l),al=a(l),y(T.$$.fragment,l),Ml=a(l),h=i(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1xlqnsv"&&(h.innerHTML=Gl),il=a(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1rrh2b0"&&(b.innerHTML=Xl),ol=a(l),d=i(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-3ojw25"&&(d.textContent=Yl),pl=a(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1hw7g6s"&&(I.textContent=Fl),yl=a(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-q251yb"&&(C.innerHTML=Ll),rl=a(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1tzrwc8"&&(g.textContent=zl),cl=a(l),y(f.$$.fragment,l),ul=a(l),y(B.$$.fragment,l),Ul=a(l),y(Q.$$.fragment,l),jl=a(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-ec23hm"&&(q.textContent=Dl),Jl=a(l),y(A.$$.fragment,l),wl=a(l),Z=i(l,"PRE",{"data-svelte-h":!0}),o(Z)!=="svelte-jbb28p"&&(Z.textContent=Kl),ml=a(l),y(W.$$.fragment,l),Tl=a(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-fdu5cw"&&(S.textContent=Pl),hl=a(l),E=i(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-34z7zb"&&(E.innerHTML=Ol),bl=a(l),R=i(l,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1oybir2"&&(R.innerHTML=lt),dl=a(l),y(v.$$.fragment,l),Il=a(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1t4r7cu"&&(k.textContent=tt),Cl=a(l),$=i(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-8c37e5"&&($.innerHTML=st),gl=a(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ba2bns"&&(N.innerHTML=et),fl=a(l),y(V.$$.fragment,l),Bl=a(l),y(H.$$.fragment,l),Ql=a(l),y(x.$$.fragment,l),ql=a(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-nr3fl7"&&(_.textContent=nt),Al=a(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-6lwjm6"&&(G.innerHTML=at),Zl=a(l),y(X.$$.fragment,l),Wl=a(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-frhx8p"&&(Y.innerHTML=Mt),Sl=a(l),y(F.$$.fragment,l),El=a(l),L=i(l,"PRE",{"data-svelte-h":!0}),o(L)!=="svelte-d75mf2"&&(L.textContent=it),Rl=a(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1rg01xj"&&(z.innerHTML=ot),vl=a(l),y(D.$$.fragment,l),kl=a(l),K=i(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1umn140"&&(K.textContent=pt),$l=a(l),P=i(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-bt1f1w"&&(P.textContent=yt),Nl=a(l),y(O.$$.fragment,l),Vl=a(l),tl=i(l,"P",{}),rt(tl).forEach(s),this.h()},h(){ct(j,"name","hf:doc:metadata"),ct(j,"content",Ct)},m(l,t){Tt(document.head,j),e(l,sl,t),e(l,ll,t),e(l,el,t),r(w,l,t),e(l,nl,t),r(m,l,t),e(l,al,t),r(T,l,t),e(l,Ml,t),e(l,h,t),e(l,il,t),e(l,b,t),e(l,ol,t),e(l,d,t),e(l,pl,t),e(l,I,t),e(l,yl,t),e(l,C,t),e(l,rl,t),e(l,g,t),e(l,cl,t),r(f,l,t),e(l,ul,t),r(B,l,t),e(l,Ul,t),r(Q,l,t),e(l,jl,t),e(l,q,t),e(l,Jl,t),r(A,l,t),e(l,wl,t),e(l,Z,t),e(l,ml,t),r(W,l,t),e(l,Tl,t),e(l,S,t),e(l,hl,t),e(l,E,t),e(l,bl,t),e(l,R,t),e(l,dl,t),r(v,l,t),e(l,Il,t),e(l,k,t),e(l,Cl,t),e(l,$,t),e(l,gl,t),e(l,N,t),e(l,fl,t),r(V,l,t),e(l,Bl,t),r(H,l,t),e(l,Ql,t),r(x,l,t),e(l,ql,t),e(l,_,t),e(l,Al,t),e(l,G,t),e(l,Zl,t),r(X,l,t),e(l,Wl,t),e(l,Y,t),e(l,Sl,t),r(F,l,t),e(l,El,t),e(l,L,t),e(l,Rl,t),e(l,z,t),e(l,vl,t),r(D,l,t),e(l,kl,t),e(l,K,t),e(l,$l,t),e(l,P,t),e(l,Nl,t),r(O,l,t),e(l,Vl,t),e(l,tl,t),Hl=!0},p:Ut,i(l){Hl||(c(w.$$.fragment,l),c(m.$$.fragment,l),c(T.$$.fragment,l),c(f.$$.fragment,l),c(B.$$.fragment,l),c(Q.$$.fragment,l),c(A.$$.fragment,l),c(W.$$.fragment,l),c(v.$$.fragment,l),c(V.$$.fragment,l),c(H.$$.fragment,l),c(x.$$.fragment,l),c(X.$$.fragment,l),c(F.$$.fragment,l),c(D.$$.fragment,l),c(O.$$.fragment,l),Hl=!0)},o(l){u(w.$$.fragment,l),u(m.$$.fragment,l),u(T.$$.fragment,l),u(f.$$.fragment,l),u(B.$$.fragment,l),u(Q.$$.fragment,l),u(A.$$.fragment,l),u(W.$$.fragment,l),u(v.$$.fragment,l),u(V.$$.fragment,l),u(H.$$.fragment,l),u(x.$$.fragment,l),u(X.$$.fragment,l),u(F.$$.fragment,l),u(D.$$.fragment,l),u(O.$$.fragment,l),Hl=!1},d(l){l&&(s(sl),s(ll),s(el),s(nl),s(al),s(Ml),s(h),s(il),s(b),s(ol),s(d),s(pl),s(I),s(yl),s(C),s(rl),s(g),s(cl),s(ul),s(Ul),s(jl),s(q),s(Jl),s(wl),s(Z),s(ml),s(Tl),s(S),s(hl),s(E),s(bl),s(R),s(dl),s(Il),s(k),s(Cl),s($),s(gl),s(N),s(fl),s(Bl),s(Ql),s(ql),s(_),s(Al),s(G),s(Zl),s(Wl),s(Y),s(Sl),s(El),s(L),s(Rl),s(z),s(vl),s(kl),s(K),s($l),s(P),s(Nl),s(Vl),s(tl)),s(j),U(w,l),U(m,l),U(T,l),U(f,l),U(B,l),U(Q,l),U(A,l),U(W,l),U(v,l),U(V,l),U(H,l),U(x,l),U(X,l),U(F,l),U(D,l),U(O,l)}}}const Ct='{"title":"Agent for text-to-SQL with automatic error correction","local":"agent-for-text-to-sql-with-automatic-error-correction","sections":[{"title":"Setup SQL tables","local":"setup-sql-tables","sections":[],"depth":2},{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":2},{"title":"Increasing difficulty: Table joins","local":"increasing-difficulty-table-joins","sections":[],"depth":2}],"depth":1}';function gt(_l){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends Jt{constructor(j){super(),wt(this,j,gt,It,ut,{})}}export{Zt as component};
