import{s as sa,n as ia,o as oa}from"../chunks/scheduler.1f027d5a.js";import{S as pa,i as ma,e as i,s as a,c as m,h as ra,a as o,d as l,b as s,f as na,g as r,j as p,k as aa,l as Ma,m as n,n as M,t as d,o as u,p as y}from"../chunks/index.5cb6ce42.js";import{C as da}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as ua,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as f,E as ya}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function ha(nn){let c,re,pe,Me,w,de,b,ue,j,ye,g,an='<em>Authored by: <a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',he,T,sn="In this notebook we are introducing how to apply prompt tuning with the PEFT library to a pre-trained model.",fe,U,on='For a complete list of models compatible with PEFT refer to their <a href="https://huggingface.co/docs/peft/main/en/index#supported-methods" rel="nofollow">documentation</a>.',ce,J,pn="A short sample of models available to be trained with PEFT includes Bloom, Llama, GPT-J, GPT-2, BERT, and more. Hugging Face is working hard to add more models to the library.",we,$,be,C,mn="It’s an Additive Fine-Tuning technique for models. This means that we WILL NOT MODIFY ANY WEIGHTS OF THE ORIGINAL MODEL. You might be wondering, how are we going to perform Fine-Tuning then? Well, we will train additional layers that are added to the model. That’s why it’s called an Additive technique.",je,_,rn="Considering it’s an Additive technique and its name is Prompt-Tuning, it seems clear that the layers we’re going to add and train are related to the prompt.",ge,Z,Mn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/Martra_Figure_5_Prompt_Tuning.jpg" alt="Prompt_Tuning_Diagram"/>',Te,v,dn="We are creating a type of superprompt by enabling a model to enhance a portion of the prompt with its acquired knowledge. However, that particular section of the prompt cannot be translated into natural language. <strong>It’s as if we’ve mastered expressing ourselves in embeddings and generating highly effective prompts.</strong>",Ue,G,un="In each training cycle, the only weights that can be modified to minimize the loss function are those integrated into the prompt.",Je,W,yn="The primary consequence of this technique is that the number of parameters to train is genuinely small. However, we encounter a second, perhaps more significant consequence, namely that, <strong>since we do not modify the weights of the pretrained model, it does not alter its behavior or forget any information it has previously learned.</strong>",$e,X,hn="The training is faster and more cost-effective. Moreover, we can train various models, and during inference time, we only need to load one foundational model along with the new smaller trained models because the weights of the original model have not been altered",Ce,k,_e,R,fn="We are going to train two different models using two datasets, each with just one pre-trained model from the Bloom family. One model will be trained with a dataset of prompts, while the other will use a dataset of inspirational sentences. We will compare the results for the same question from both models before and after training.",Ze,B,cn="Additionally, we’ll explore how to load both models with only one copy of the foundational model in memory.",ve,V,Ge,I,wn="This library contains the Hugging Face implementation of various Fine-Tuning techniques, including Prompt Tuning",We,x,Xe,A,ke,F,bn="From the transformers library, we import the necessary classes to instantiate the model and the tokenizer.",Re,H,Be,Y,Ve,z,jn="Bloom is one of the smallest and smartest models available for training with the PEFT Library using Prompt Tuning. You can choose any model from the Bloom Family, and I encourage you to try at least two of them to observe the differences.",Ie,N,gn="I’m opting for the smallest one to minimize training time and avoid memory issues in Colab.",xe,Q,Ae,E,Fe,S,He,P,Tn="If you want to achieve more varied and original generations, uncomment the parameters: temperature, top_p, and do_sample, in <em>model.generate</em> below",Ye,L,Un="With the default configuration, the model’s responses remain consistent across calls.",ze,q,Ne,D,Jn="As we want to have two different trained models, I will create two distinct prompts.",Qe,K,$n="The first model will be trained with a dataset containing prompts, and the second one with a dataset of motivational sentences.",Ee,O,Cn="The first model will receive the prompt “I want you to act as a motivational coach.” and the second model will receive “There are two nice things that should matter to you:”",Se,tt,_n="But first, I’m going to collect some results from the model without Fine-Tuning.",Pe,et,Le,lt,Zn=`["I want you to act as a motivational coach.  Don't be afraid of being challenged."]
`,qe,nt,De,at,vn=`['There are two nice things that should matter to you: the price and quality of your product.']
`,Ke,st,Gn="Both answers are more or less correct. Any of the Bloom models is pre-trained and can generate sentences accurately and sensibly. Let’s see if, after training, the responses are either equal or more accurately generated.",Oe,it,tl,ot,Wn="The Datasets useds are:",el,pt,Xn='<li><a href="https://huggingface.co/datasets/fka/awesome-chatgpt-prompts" rel="nofollow">https://huggingface.co/datasets/fka/awesome-chatgpt-prompts</a></li> <li><a href="https://huggingface.co/datasets/Abirate/english_quotes" rel="nofollow">https://huggingface.co/datasets/Abirate/english_quotes</a></li>',ll,mt,nl,rt,al,Mt,sl,dt,il,ut,kn=`&#123;'act': ['Linux Terminal'], 'prompt': ['I want you to act as a linux terminal. I will type commands and you will reply with what the terminal should show. I want you to only reply with the terminal output inside one unique code block, and nothing else. do not write explanations. do not type commands unless I instruct you to do so. when i need to tell you something in english, i will do so by putting text inside curly brackets &#123;like this}. my first command is pwd'], 'input_ids': [[44, 4026, 1152, 427, 1769, 661, 267, 104105, 28434, 17, 473, 2152, 4105, 49123, 530, 1152, 2152, 57502, 1002, 3595, 368, 28434, 3403, 6460, 17, 473, 4026, 1152, 427, 3804, 57502, 1002, 368, 28434, 10014, 14652, 2592, 19826, 4400, 10973, 15, 530, 16915, 4384, 17, 727, 1130, 11602, 184637, 17, 727, 1130, 4105, 49123, 35262, 473, 32247, 1152, 427, 727, 1427, 17, 3262, 707, 3423, 427, 13485, 1152, 7747, 361, 170205, 15, 707, 2152, 727, 1427, 1331, 55385, 5484, 14652, 6291, 999, 117805, 731, 29726, 1119, 96, 17, 2670, 3968, 9361, 632, 269, 42512]], 'attention_mask': [[1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]]}
`,ol,yt,pl,ht,ml,ft,rl,ct,Ml,wt,Rn=`API docs:
<a href="https://huggingface.co/docs/peft/main/en/package_reference/tuners#peft.PromptTuningConfig" rel="nofollow">https://huggingface.co/docs/peft/main/en/package_reference/tuners#peft.PromptTuningConfig</a>`,dl,bt,Bn="We can use the same configuration for both models to be trained.",ul,jt,yl,gt,hl,Tt,Vn="We will create two identical prompt tuning models using the same pre-trained model and the same config.",fl,Ut,cl,Jt,In=`trainable params: 4,096 || all params: 559,218,688 || trainable%: 0.0007324504863471229
None
`,wl,$t,bl,Ct,xn=`trainable params: 4,096 || all params: 559,218,688 || trainable%: 0.0007324504863471229
None
`,jl,_t,An="<strong>That’s amazing: did you see the reduction in trainable parameters? We are going to train a 0.001% of the paramaters available.</strong>",gl,Zt,Fn="Now we are going to create the training arguments, and we will use the same configuration in both trainings.",Tl,vt,Ul,Gt,Jl,Wt,Hn="We need to indicate the directory containing the model when creating the TrainingArguments.",$l,Xt,Cl,kt,_l,Rt,Yn="We will create the trainer Object, one for each model to train.",Zl,Bt,vl,Vt,Gl,It,Wl,xt,zn="In less than 10 minutes (CPU time in a M1 Pro) we trained 2 different models, with two different missions with a same foundational model as a base.",Xl,At,kl,Ft,Nn="We are going to save the models. These models are ready to be used, as long as we have the pre-trained model from which they were created in memory.",Rl,Ht,Bl,Yt,Vl,zt,Qn="You can load the model from the path that you have saved to before, and ask the model to generate text based on our input before!",Il,Nt,xl,Qt,Al,Et,En=`['I want you to act as a motivational coach.  You will be helping students learn how they can improve their performance in the classroom and at school.']
`,Fl,St,Sn="If we compare both answers something changed.",Hl,Pt,Pn="<li><strong><em>Pretrained Model:</em></strong> <em>I want you to act as a motivational coach.  Don’t be afraid of being challenged.</em></li> <li><strong><em>Fine-Tuned Model:</em></strong> <em>I want you to act as a motivational coach.  You can use this method if you’re feeling anxious about your.</em></li>",Yl,Lt,Ln="We have to keep in mind that we have only trained the model for a few minutes, but they have been enough to obtain a response closer to what we were looking for.",zl,qt,Nl,Dt,Ql,Kt,qn=`['There are two nice things that should matter to you: the weather and your health.']
`,El,Ot,Dn="With the second model we have a similar result.",Sl,te,Kn="<li><strong>Pretrained Model:</strong> <em>There are two nice things that should matter to you: the price and quality of your product.</em></li> <li><strong>Fine-Tuned Model:</strong> <em>There are two nice things that should matter to you: the weather and your health.</em></li>",Pl,ee,Ll,le,On="Prompt Tuning is an amazing technique that can save us hours of training and a significant amount of money. In the notebook, we have trained two models in just a few minutes, and we can have both models in memory, providing service to different clients.",ql,ne,ta="If you want to try different combinations and models, the notebook is ready to use another model from the Bloom family.",Dl,ae,ea="You can change the number of epochs to train, the number of virtual tokens, and the model in the third cell. However, there are many configurations to change. If you’re looking for a good exercise, you can replace the random initialization of the virtual tokens with a fixed value.",Kl,se,la="<em>The responses of the Fine-Tuned models may vary every time we train them. I’ve pasted the results of one of my trainings, but the actual results may differ.</em>",Ol,ie,tn,oe,en,me,ln;return w=new ua({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/prompt_tuning_peft.ipynb"}]}}),b=new da({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new f({props:{title:"Prompt Tuning With PEFT.",local:"prompt-tuning-with-peft",headingTag:"h1"}}),$=new f({props:{title:"Brief introduction to Prompt Tuning.",local:"brief-introduction-to-prompt-tuning",headingTag:"h2"}}),k=new f({props:{title:"What are we going to do in the notebook?",local:"what-are-we-going-to-do-in-the-notebook",headingTag:"h2"}}),V=new f({props:{title:"Loading the PEFT Library",local:"loading-the-peft-library",headingTag:"h2"}}),x=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlM0QlM0QwLjguMg==",highlighted:'!pip install -q peft==<span class="hljs-number">0.8</span><span class="hljs-number">.2</span>',wrap:!1}}),A=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNC41",highlighted:'!pip install -q datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.5</span>',wrap:!1}}),H=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplcg==",highlighted:'<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer',wrap:!1}}),Y=new f({props:{title:"Loading the model and the tokenizers.",local:"loading-the-model-and-the-tokenizers",headingTag:"h3"}}),Q=new h({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiUwQSUyM21vZGVsX25hbWUlM0QlMjJiaWdzY2llbmNlJTJGYmxvb20tMWIxJTIyJTBBTlVNX1ZJUlRVQUxfVE9LRU5TJTIwJTNEJTIwNCUwQU5VTV9FUE9DSFMlMjAlM0QlMjA2",highlighted:`model_name = <span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>
<span class="hljs-comment">#model_name=&quot;bigscience/bloom-1b1&quot;</span>
NUM_VIRTUAL_TOKENS = <span class="hljs-number">4</span>
NUM_EPOCHS = <span class="hljs-number">6</span>`,wrap:!1}}),E=new h({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFmb3VuZGF0aW9uYWxfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUwQSk=",highlighted:`tokenizer = AutoTokenizer.from_pretrained(model_name)
foundational_model = AutoModelForCausalLM.from_pretrained(
    model_name,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),S=new f({props:{title:"Inference with the pre trained bloom model",local:"inference-with-the-pre-trained-bloom-model",headingTag:"h2"}}),q=new h({props:{code:"JTIzdGhpcyUyMGZ1bmN0aW9uJTIwcmV0dXJucyUyMHRoZSUyMG91dHB1dHMlMjBmcm9tJTIwdGhlJTIwbW9kZWwlMjByZWNlaXZlZCUyQyUyMGFuZCUyMGlucHV0cy4lMEFkZWYlMjBnZXRfb3V0cHV0cyhtb2RlbCUyQyUyMGlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0RtYXhfbmV3X3Rva2VucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyM3RlbXBlcmF0dXJlJTNEMC4yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzdG9wX3AlM0QwLjk1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzRDEuNSUyQyUyMCUyM0F2b2lkJTIwcmVwZXRpdGlvbi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlYXJseV9zdG9wcGluZyUzRFRydWUlMkMlMjAlMjNUaGUlMjBtb2RlbCUyMGNhbiUyMHN0b3AlMjBiZWZvcmUlMjByZWFjaCUyMHRoZSUyMG1heF9sZW5ndGglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHM=",highlighted:`<span class="hljs-comment">#this function returns the outputs from the model received, and inputs.</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_outputs</span>(<span class="hljs-params">model, inputs, max_new_tokens=<span class="hljs-number">100</span></span>):
    outputs = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        <span class="hljs-comment">#temperature=0.2,</span>
        <span class="hljs-comment">#top_p=0.95,</span>
        <span class="hljs-comment">#do_sample=True,</span>
        repetition_penalty=<span class="hljs-number">1.5</span>, <span class="hljs-comment">#Avoid repetition.</span>
        early_stopping=<span class="hljs-literal">True</span>, <span class="hljs-comment">#The model can stop before reach the max_length</span>
        eos_token_id=tokenizer.eos_token_id
    )
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),et=new h({props:{code:"aW5wdXRfcHJvbXB0JTIwJTNEJTIwdG9rZW5pemVyKCUyMkklMjB3YW50JTIweW91JTIwdG8lMjBhY3QlMjBhcyUyMGElMjBtb3RpdmF0aW9uYWwlMjBjb2FjaC4lMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWZvdW5kYXRpb25hbF9vdXRwdXRzX3Byb21wdCUyMCUzRCUyMGdldF9vdXRwdXRzKGZvdW5kYXRpb25hbF9tb2RlbCUyQyUyMGlucHV0X3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShmb3VuZGF0aW9uYWxfb3V0cHV0c19wcm9tcHQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = tokenizer(<span class="hljs-string">&quot;I want you to act as a motivational coach. &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>foundational_outputs_prompt = get_outputs(foundational_model, input_prompt, max_new_tokens=<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(foundational_outputs_prompt, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),nt=new h({props:{code:"aW5wdXRfc2VudGVuY2VzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZXJlJTIwYXJlJTIwdHdvJTIwbmljZSUyMHRoaW5ncyUyMHRoYXQlMjBzaG91bGQlMjBtYXR0ZXIlMjB0byUyMHlvdSUzQSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZm91bmRhdGlvbmFsX291dHB1dHNfc2VudGVuY2UlMjAlM0QlMjBnZXRfb3V0cHV0cyhmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBpbnB1dF9zZW50ZW5jZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwKSUwQSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZm91bmRhdGlvbmFsX291dHB1dHNfc2VudGVuY2UlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>input_sentences = tokenizer(<span class="hljs-string">&quot;There are two nice things that should matter to you:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>foundational_outputs_sentence = get_outputs(foundational_model, input_sentences, max_new_tokens=<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(foundational_outputs_sentence, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),it=new f({props:{title:"Preparing the Datasets",local:"preparing-the-datasets",headingTag:"h2"}}),mt=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMjNvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment">#os.environ[&quot;TOKENIZERS_PARALLELISM&quot;] = &quot;false&quot;</span>`,wrap:!1}}),rt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldF9wcm9tcHQlMjAlM0QlMjAlMjJma2ElMkZhd2Vzb21lLWNoYXRncHQtcHJvbXB0cyUyMiUwQSUwQSUyM0NyZWF0ZSUyMHRoZSUyMERhdGFzZXQlMjB0byUyMGNyZWF0ZSUyMHByb21wdHMuJTBBZGF0YV9wcm9tcHQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9wcm9tcHQpJTBBZGF0YV9wcm9tcHQlMjAlM0QlMjBkYXRhX3Byb21wdC5tYXAobGFtYmRhJTIwc2FtcGxlcyUzQSUyMHRva2VuaXplcihzYW1wbGVzJTVCJTIycHJvbXB0JTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRyYWluX3NhbXBsZV9wcm9tcHQlMjAlM0QlMjBkYXRhX3Byb21wdCU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSg1MCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset_prompt = <span class="hljs-string">&quot;fka/awesome-chatgpt-prompts&quot;</span>

<span class="hljs-comment">#Create the Dataset to create prompts.</span>
data_prompt = load_dataset(dataset_prompt)
data_prompt = data_prompt.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> samples: tokenizer(samples[<span class="hljs-string">&quot;prompt&quot;</span>]), batched=<span class="hljs-literal">True</span>)
train_sample_prompt = data_prompt[<span class="hljs-string">&quot;train&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>))`,wrap:!1}}),Mt=new h({props:{code:"ZGlzcGxheSh0cmFpbl9zYW1wbGVfcHJvbXB0KQ==",highlighted:"display(train_sample_prompt)",wrap:!1}}),dt=new h({props:{code:"cHJpbnQodHJhaW5fc2FtcGxlX3Byb21wdCU1QiUzQTElNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_sample_prompt[:<span class="hljs-number">1</span>])',wrap:!1}}),yt=new h({props:{code:"ZGF0YXNldF9zZW50ZW5jZXMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyQWJpcmF0ZSUyRmVuZ2xpc2hfcXVvdGVzJTIyKSUwQSUwQWRhdGFfc2VudGVuY2VzJTIwJTNEJTIwZGF0YXNldF9zZW50ZW5jZXMubWFwKGxhbWJkYSUyMHNhbXBsZXMlM0ElMjB0b2tlbml6ZXIoc2FtcGxlcyU1QiUyMnF1b3RlJTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRyYWluX3NhbXBsZV9zZW50ZW5jZXMlMjAlM0QlMjBkYXRhX3NlbnRlbmNlcyU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSgyNSkpJTBBdHJhaW5fc2FtcGxlX3NlbnRlbmNlcyUyMCUzRCUyMHRyYWluX3NhbXBsZV9zZW50ZW5jZXMucmVtb3ZlX2NvbHVtbnMoJTVCJ2F1dGhvciclMkMlMjAndGFncyclNUQp",highlighted:`dataset_sentences = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>)

data_sentences = dataset_sentences.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> samples: tokenizer(samples[<span class="hljs-string">&quot;quote&quot;</span>]), batched=<span class="hljs-literal">True</span>)
train_sample_sentences = data_sentences[<span class="hljs-string">&quot;train&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">25</span>))
train_sample_sentences = train_sample_sentences.remove_columns([<span class="hljs-string">&#x27;author&#x27;</span>, <span class="hljs-string">&#x27;tags&#x27;</span>])`,wrap:!1}}),ht=new h({props:{code:"ZGlzcGxheSh0cmFpbl9zYW1wbGVfc2VudGVuY2VzKQ==",highlighted:"display(train_sample_sentences)",wrap:!1}}),ft=new f({props:{title:"Fine-Tuning.",local:"fine-tuning",headingTag:"h2"}}),ct=new f({props:{title:"PEFT configurations",local:"peft-configurations",headingTag:"h3"}}),jt=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjAlMjBnZXRfcGVmdF9tb2RlbCUyQyUyMFByb21wdFR1bmluZ0NvbmZpZyUyQyUyMFRhc2tUeXBlJTJDJTIwUHJvbXB0VHVuaW5nSW5pdCUwQSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLkNBVVNBTF9MTSUyQyUyMCUyM1RoaXMlMjB0eXBlJTIwaW5kaWNhdGVzJTIwdGhlJTIwbW9kZWwlMjB3aWxsJTIwZ2VuZXJhdGUlMjB0ZXh0LiUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuUkFORE9NJTJDJTIwJTIwJTIzVGhlJTIwYWRkZWQlMjB2aXJ0dWFsJTIwdG9rZW5zJTIwYXJlJTIwaW5pdGlhbGl6YWQlMjB3aXRoJTIwcmFuZG9tJTIwbnVtYmVycyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRE5VTV9WSVJUVUFMX1RPS0VOUyUyQyUyMCUyM051bWJlciUyMG9mJTIwdmlydHVhbCUyMHRva2VucyUyMHRvJTIwYmUlMjBhZGRlZCUyMGFuZCUyMHRyYWluZWQuJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyX25hbWVfb3JfcGF0aCUzRG1vZGVsX25hbWUlMjAlMjNUaGUlMjBwcmUtdHJhaW5lZCUyMG1vZGVsLiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span>  get_peft_model, PromptTuningConfig, TaskType, PromptTuningInit

generation_config = PromptTuningConfig(
    task_type=TaskType.CAUSAL_LM, <span class="hljs-comment">#This type indicates the model will generate text.</span>
    prompt_tuning_init=PromptTuningInit.RANDOM,  <span class="hljs-comment">#The added virtual tokens are initializad with random numbers</span>
    num_virtual_tokens=NUM_VIRTUAL_TOKENS, <span class="hljs-comment">#Number of virtual tokens to be added and trained.</span>
    tokenizer_name_or_path=model_name <span class="hljs-comment">#The pre-trained model.</span>
)`,wrap:!1}}),gt=new f({props:{title:"Creating two Prompt Tuning Models.",local:"creating-two-prompt-tuning-models",headingTag:"h3"}}),Ut=new h({props:{code:"cGVmdF9tb2RlbF9wcm9tcHQlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEFwcmludChwZWZ0X21vZGVsX3Byb21wdC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>peft_model_prompt = get_peft_model(foundational_model, generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(peft_model_prompt.print_trainable_parameters())`,wrap:!1}}),$t=new h({props:{code:"cGVmdF9tb2RlbF9zZW50ZW5jZXMlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEFwcmludChwZWZ0X21vZGVsX3NlbnRlbmNlcy5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>peft_model_sentences = get_peft_model(foundational_model, generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(peft_model_sentences.print_trainable_parameters())`,wrap:!1}}),vt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZGVmJTIwY3JlYXRlX3RyYWluaW5nX2FyZ3VtZW50cyhwYXRoJTJDJTIwbGVhcm5pbmdfcmF0ZSUzRDAuMDAzNSUyQyUyMGVwb2NocyUzRDYpJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RwYXRoJTJDJTIwJTIzJTIwV2hlcmUlMjB0aGUlMjBtb2RlbCUyMHByZWRpY3Rpb25zJTIwYW5kJTIwY2hlY2twb2ludHMlMjB3aWxsJTIwYmUlMjB3cml0dGVuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlX2NwdSUzRFRydWUlMkMlMjAlMjMlMjBUaGlzJTIwaXMlMjBuZWNlc3NhcnklMjBmb3IlMjBDUFUlMjBjbHVzdGVycy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdXRvX2ZpbmRfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAlMjMlMjBGaW5kJTIwYSUyMHN1aXRhYmxlJTIwYmF0Y2glMjBzaXplJTIwdGhhdCUyMHdpbGwlMjBmaXQlMjBpbnRvJTIwbWVtb3J5JTIwYXV0b21hdGljYWxseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QlMjBsZWFybmluZ19yYXRlJTJDJTIwJTIzJTIwSGlnaGVyJTIwbGVhcm5pbmclMjByYXRlJTIwdGhhbiUyMGZ1bGwlMjBGaW5lLVR1bmluZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0RlcG9jaHMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhaW5pbmdfYXJncw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_training_arguments</span>(<span class="hljs-params">path, learning_rate=<span class="hljs-number">0.0035</span>, epochs=<span class="hljs-number">6</span></span>):
    training_args = TrainingArguments(
        output_dir=path, <span class="hljs-comment"># Where the model predictions and checkpoints will be written</span>
        use_cpu=<span class="hljs-literal">True</span>, <span class="hljs-comment"># This is necessary for CPU clusters.</span>
        auto_find_batch_size=<span class="hljs-literal">True</span>, <span class="hljs-comment"># Find a suitable batch size that will fit into memory automatically</span>
        learning_rate= learning_rate, <span class="hljs-comment"># Higher learning rate than full Fine-Tuning</span>
        num_train_epochs=epochs
    )
    <span class="hljs-keyword">return</span> training_args`,wrap:!1}}),Gt=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEF3b3JraW5nX2RpciUyMCUzRCUyMCUyMi4lMkYlMjIlMEElMEElMjNJcyUyMGJlc3QlMjB0byUyMHN0b3JlJTIwdGhlJTIwbW9kZWxzJTIwaW4lMjBzZXBhcmF0ZSUyMGZvbGRlcnMuJTBBJTIzQ3JlYXRlJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwZGlyZWN0b3JpZXMlMjB3aGVyZSUyMHRvJTIwc3RvcmUlMjB0aGUlMjBtb2RlbHMuJTBBb3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQlMjAlM0QlMjAlMjBvcy5wYXRoLmpvaW4od29ya2luZ19kaXIlMkMlMjAlMjJwZWZ0X291dHB1dHNfcHJvbXB0JTIyKSUwQW91dHB1dF9kaXJlY3Rvcnlfc2VudGVuY2VzJTIwJTNEJTIwb3MucGF0aC5qb2luKHdvcmtpbmdfZGlyJTJDJTIwJTIycGVmdF9vdXRwdXRzX3NlbnRlbmNlcyUyMiklMEElMEElMjNKdXN0JTIwY3JlYXRpbmclMjB0aGUlMjBkaXJlY3RvcmlzJTIwaWYlMjBub3QlMjBleGlzdC4lMEFpZiUyMG5vdCUyMG9zLnBhdGguZXhpc3RzKHdvcmtpbmdfZGlyKSUzQSUwQSUyMCUyMCUyMCUyMG9zLm1rZGlyKHdvcmtpbmdfZGlyKSUwQWlmJTIwbm90JTIwb3MucGF0aC5leGlzdHMob3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwb3MubWtkaXIob3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQpJTBBaWYlMjBub3QlMjBvcy5wYXRoLmV4aXN0cyhvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyklM0ElMEElMjAlMjAlMjAlMjBvcy5ta2RpcihvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyk=",highlighted:`<span class="hljs-keyword">import</span> os

working_dir = <span class="hljs-string">&quot;./&quot;</span>

<span class="hljs-comment">#Is best to store the models in separate folders.</span>
<span class="hljs-comment">#Create the name of the directories where to store the models.</span>
output_directory_prompt =  os.path.join(working_dir, <span class="hljs-string">&quot;peft_outputs_prompt&quot;</span>)
output_directory_sentences = os.path.join(working_dir, <span class="hljs-string">&quot;peft_outputs_sentences&quot;</span>)

<span class="hljs-comment">#Just creating the directoris if not exist.</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(working_dir):
    os.mkdir(working_dir)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(output_directory_prompt):
    os.mkdir(output_directory_prompt)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(output_directory_sentences):
    os.mkdir(output_directory_sentences)`,wrap:!1}}),Xt=new h({props:{code:"dHJhaW5pbmdfYXJnc19wcm9tcHQlMjAlM0QlMjBjcmVhdGVfdHJhaW5pbmdfYXJndW1lbnRzKG91dHB1dF9kaXJlY3RvcnlfcHJvbXB0JTJDJTIwMC4wMDMlMkMlMjBOVU1fRVBPQ0hTKSUwQXRyYWluaW5nX2FyZ3Nfc2VudGVuY2VzJTIwJTNEJTIwY3JlYXRlX3RyYWluaW5nX2FyZ3VtZW50cyhvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyUyQyUyMDAuMDAzJTJDJTIwTlVNX0VQT0NIUyk=",highlighted:`training_args_prompt = create_training_arguments(output_directory_prompt, <span class="hljs-number">0.003</span>, NUM_EPOCHS)
training_args_sentences = create_training_arguments(output_directory_sentences, <span class="hljs-number">0.003</span>, NUM_EPOCHS)`,wrap:!1}}),kt=new f({props:{title:"Train",local:"train",headingTag:"h2"}}),Bt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBZGVmJTIwY3JlYXRlX3RyYWluZXIobW9kZWwlMkMlMjB0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwJTIzJTIwV2UlMjBwYXNzJTIwaW4lMjB0aGUlMjBQRUZUJTIwdmVyc2lvbiUyMG9mJTIwdGhlJTIwZm91bmRhdGlvbiUyMG1vZGVsJTJDJTIwYmxvb216LTU2ME0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMCUyM1RoZSUyMGFyZ3MlMjBmb3IlMjB0aGUlMjB0cmFpbmluZy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUyMCUyM1RoZSUyMGRhdGFzZXQlMjB1c2VkJTIwdG8lMjB0eXJhaW4lMjB0aGUlMjBtb2RlbC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNERGF0YUNvbGxhdG9yRm9yTGFuZ3VhZ2VNb2RlbGluZyh0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMjAlMjMlMjBtbG0lM0RGYWxzZSUyMGluZGljYXRlcyUyMG5vdCUyMHRvJTIwdXNlJTIwbWFza2VkJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFpbmVy",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, DataCollatorForLanguageModeling
<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_trainer</span>(<span class="hljs-params">model, training_args, train_dataset</span>):
    trainer = Trainer(
        model=model, <span class="hljs-comment"># We pass in the PEFT version of the foundation model, bloomz-560M</span>
        args=training_args, <span class="hljs-comment">#The args for the training.</span>
        train_dataset=train_dataset, <span class="hljs-comment">#The dataset used to tyrain the model.</span>
        data_collator=DataCollatorForLanguageModeling(tokenizer, mlm=<span class="hljs-literal">False</span>) <span class="hljs-comment"># mlm=False indicates not to use masked language modeling</span>
    )
    <span class="hljs-keyword">return</span> trainer`,wrap:!1}}),Vt=new h({props:{code:"JTIzVHJhaW5pbmclMjBmaXJzdCUyMG1vZGVsLiUwQXRyYWluZXJfcHJvbXB0JTIwJTNEJTIwY3JlYXRlX3RyYWluZXIocGVmdF9tb2RlbF9wcm9tcHQlMkMlMjB0cmFpbmluZ19hcmdzX3Byb21wdCUyQyUyMHRyYWluX3NhbXBsZV9wcm9tcHQpJTBBdHJhaW5lcl9wcm9tcHQudHJhaW4oKQ==",highlighted:`<span class="hljs-comment">#Training first model.</span>
trainer_prompt = create_trainer(peft_model_prompt, training_args_prompt, train_sample_prompt)
trainer_prompt.train()`,wrap:!1}}),It=new h({props:{code:"JTIzVHJhaW5pbmclMjBzZWNvbmQlMjBtb2RlbC4lMEF0cmFpbmVyX3NlbnRlbmNlcyUyMCUzRCUyMGNyZWF0ZV90cmFpbmVyKHBlZnRfbW9kZWxfc2VudGVuY2VzJTJDJTIwdHJhaW5pbmdfYXJnc19zZW50ZW5jZXMlMkMlMjB0cmFpbl9zYW1wbGVfc2VudGVuY2VzKSUwQXRyYWluZXJfc2VudGVuY2VzLnRyYWluKCk=",highlighted:`<span class="hljs-comment">#Training second model.</span>
trainer_sentences = create_trainer(peft_model_sentences, training_args_sentences, train_sample_sentences)
trainer_sentences.train()`,wrap:!1}}),At=new f({props:{title:"Save models",local:"save-models",headingTag:"h2"}}),Ht=new h({props:{code:"dHJhaW5lcl9wcm9tcHQubW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG91dHB1dF9kaXJlY3RvcnlfcHJvbXB0KSUwQXRyYWluZXJfc2VudGVuY2VzLm1vZGVsLnNhdmVfcHJldHJhaW5lZChvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyk=",highlighted:`trainer_prompt.model.save_pretrained(output_directory_prompt)
trainer_sentences.model.save_pretrained(output_directory_sentences)`,wrap:!1}}),Yt=new f({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Nt=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFsb2FkZWRfbW9kZWxfcHJvbXB0JTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfZGlyZWN0b3J5X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyM2RldmljZV9tYXAlM0QnYXV0byclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpc190cmFpbmFibGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

loaded_model_prompt = PeftModel.from_pretrained(foundational_model,
                                         output_directory_prompt,
                                         <span class="hljs-comment">#device_map=&#x27;auto&#x27;,</span>
                                         is_trainable=<span class="hljs-literal">False</span>)`,wrap:!1}}),Qt=new h({props:{code:"bG9hZGVkX21vZGVsX3Byb21wdF9vdXRwdXRzJTIwJTNEJTIwZ2V0X291dHB1dHMobG9hZGVkX21vZGVsX3Byb21wdCUyQyUyMGlucHV0X3Byb21wdCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGxvYWRlZF9tb2RlbF9wcm9tcHRfb3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loaded_model_prompt_outputs = get_outputs(loaded_model_prompt, input_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(loaded_model_prompt_outputs, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),qt=new h({props:{code:"bG9hZGVkX21vZGVsX3Byb21wdC5sb2FkX2FkYXB0ZXIob3V0cHV0X2RpcmVjdG9yeV9zZW50ZW5jZXMlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJxdW90ZXMlMjIpJTBBbG9hZGVkX21vZGVsX3Byb21wdC5zZXRfYWRhcHRlciglMjJxdW90ZXMlMjIp",highlighted:`loaded_model_prompt.load_adapter(output_directory_sentences, adapter_name=<span class="hljs-string">&quot;quotes&quot;</span>)
loaded_model_prompt.set_adapter(<span class="hljs-string">&quot;quotes&quot;</span>)`,wrap:!1}}),Dt=new h({props:{code:"bG9hZGVkX21vZGVsX3NlbnRlbmNlc19vdXRwdXRzJTIwJTNEJTIwZ2V0X291dHB1dHMobG9hZGVkX21vZGVsX3Byb21wdCUyQyUyMGlucHV0X3NlbnRlbmNlcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGxvYWRlZF9tb2RlbF9zZW50ZW5jZXNfb3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loaded_model_sentences_outputs = get_outputs(loaded_model_prompt, input_sentences)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(loaded_model_sentences_outputs, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ee=new f({props:{title:"Conclusion",local:"conclusion",headingTag:"h1"}}),ie=new h({props:{code:"",highlighted:"",wrap:!1}}),oe=new ya({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/prompt_tuning_peft.md"}}),{c(){c=i("meta"),re=a(),pe=i("p"),Me=a(),m(w.$$.fragment),de=a(),m(b.$$.fragment),ue=a(),m(j.$$.fragment),ye=a(),g=i("p"),g.innerHTML=an,he=a(),T=i("p"),T.textContent=sn,fe=a(),U=i("p"),U.innerHTML=on,ce=a(),J=i("p"),J.textContent=pn,we=a(),m($.$$.fragment),be=a(),C=i("p"),C.textContent=mn,je=a(),_=i("p"),_.textContent=rn,ge=a(),Z=i("p"),Z.innerHTML=Mn,Te=a(),v=i("p"),v.innerHTML=dn,Ue=a(),G=i("p"),G.textContent=un,Je=a(),W=i("p"),W.innerHTML=yn,$e=a(),X=i("p"),X.textContent=hn,Ce=a(),m(k.$$.fragment),_e=a(),R=i("p"),R.textContent=fn,Ze=a(),B=i("p"),B.textContent=cn,ve=a(),m(V.$$.fragment),Ge=a(),I=i("p"),I.textContent=wn,We=a(),m(x.$$.fragment),Xe=a(),m(A.$$.fragment),ke=a(),F=i("p"),F.textContent=bn,Re=a(),m(H.$$.fragment),Be=a(),m(Y.$$.fragment),Ve=a(),z=i("p"),z.textContent=jn,Ie=a(),N=i("p"),N.textContent=gn,xe=a(),m(Q.$$.fragment),Ae=a(),m(E.$$.fragment),Fe=a(),m(S.$$.fragment),He=a(),P=i("p"),P.innerHTML=Tn,Ye=a(),L=i("p"),L.textContent=Un,ze=a(),m(q.$$.fragment),Ne=a(),D=i("p"),D.textContent=Jn,Qe=a(),K=i("p"),K.textContent=$n,Ee=a(),O=i("p"),O.textContent=Cn,Se=a(),tt=i("p"),tt.textContent=_n,Pe=a(),m(et.$$.fragment),Le=a(),lt=i("pre"),lt.textContent=Zn,qe=a(),m(nt.$$.fragment),De=a(),at=i("pre"),at.textContent=vn,Ke=a(),st=i("p"),st.textContent=Gn,Oe=a(),m(it.$$.fragment),tl=a(),ot=i("p"),ot.textContent=Wn,el=a(),pt=i("ul"),pt.innerHTML=Xn,ll=a(),m(mt.$$.fragment),nl=a(),m(rt.$$.fragment),al=a(),m(Mt.$$.fragment),sl=a(),m(dt.$$.fragment),il=a(),ut=i("pre"),ut.textContent=kn,ol=a(),m(yt.$$.fragment),pl=a(),m(ht.$$.fragment),ml=a(),m(ft.$$.fragment),rl=a(),m(ct.$$.fragment),Ml=a(),wt=i("p"),wt.innerHTML=Rn,dl=a(),bt=i("p"),bt.textContent=Bn,ul=a(),m(jt.$$.fragment),yl=a(),m(gt.$$.fragment),hl=a(),Tt=i("p"),Tt.textContent=Vn,fl=a(),m(Ut.$$.fragment),cl=a(),Jt=i("pre"),Jt.textContent=In,wl=a(),m($t.$$.fragment),bl=a(),Ct=i("pre"),Ct.textContent=xn,jl=a(),_t=i("p"),_t.innerHTML=An,gl=a(),Zt=i("p"),Zt.textContent=Fn,Tl=a(),m(vt.$$.fragment),Ul=a(),m(Gt.$$.fragment),Jl=a(),Wt=i("p"),Wt.textContent=Hn,$l=a(),m(Xt.$$.fragment),Cl=a(),m(kt.$$.fragment),_l=a(),Rt=i("p"),Rt.textContent=Yn,Zl=a(),m(Bt.$$.fragment),vl=a(),m(Vt.$$.fragment),Gl=a(),m(It.$$.fragment),Wl=a(),xt=i("p"),xt.textContent=zn,Xl=a(),m(At.$$.fragment),kl=a(),Ft=i("p"),Ft.textContent=Nn,Rl=a(),m(Ht.$$.fragment),Bl=a(),m(Yt.$$.fragment),Vl=a(),zt=i("p"),zt.textContent=Qn,Il=a(),m(Nt.$$.fragment),xl=a(),m(Qt.$$.fragment),Al=a(),Et=i("pre"),Et.textContent=En,Fl=a(),St=i("p"),St.textContent=Sn,Hl=a(),Pt=i("ul"),Pt.innerHTML=Pn,Yl=a(),Lt=i("p"),Lt.textContent=Ln,zl=a(),m(qt.$$.fragment),Nl=a(),m(Dt.$$.fragment),Ql=a(),Kt=i("pre"),Kt.textContent=qn,El=a(),Ot=i("p"),Ot.textContent=Dn,Sl=a(),te=i("ul"),te.innerHTML=Kn,Pl=a(),m(ee.$$.fragment),Ll=a(),le=i("p"),le.textContent=On,ql=a(),ne=i("p"),ne.textContent=ta,Dl=a(),ae=i("p"),ae.textContent=ea,Kl=a(),se=i("p"),se.innerHTML=la,Ol=a(),m(ie.$$.fragment),tn=a(),m(oe.$$.fragment),en=a(),me=i("p"),this.h()},l(t){const e=ra("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(l),re=s(t),pe=o(t,"P",{}),na(pe).forEach(l),Me=s(t),r(w.$$.fragment,t),de=s(t),r(b.$$.fragment,t),ue=s(t),r(j.$$.fragment,t),ye=s(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-zhrrkz"&&(g.innerHTML=an),he=s(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-g1kap"&&(T.textContent=sn),fe=s(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1ls58cl"&&(U.innerHTML=on),ce=s(t),J=o(t,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1456rmz"&&(J.textContent=pn),we=s(t),r($.$$.fragment,t),be=s(t),C=o(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-18lzvav"&&(C.textContent=mn),je=s(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-45uy3i"&&(_.textContent=rn),ge=s(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-18z3ipt"&&(Z.innerHTML=Mn),Te=s(t),v=o(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-qc7sdd"&&(v.innerHTML=dn),Ue=s(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1p5jk0l"&&(G.textContent=un),Je=s(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-10sha4z"&&(W.innerHTML=yn),$e=s(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1ny096o"&&(X.textContent=hn),Ce=s(t),r(k.$$.fragment,t),_e=s(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-j7tmb1"&&(R.textContent=fn),Ze=s(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1m9d1jc"&&(B.textContent=cn),ve=s(t),r(V.$$.fragment,t),Ge=s(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-hohwow"&&(I.textContent=wn),We=s(t),r(x.$$.fragment,t),Xe=s(t),r(A.$$.fragment,t),ke=s(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-z28z6b"&&(F.textContent=bn),Re=s(t),r(H.$$.fragment,t),Be=s(t),r(Y.$$.fragment,t),Ve=s(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-nnqgws"&&(z.textContent=jn),Ie=s(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1bfibd0"&&(N.textContent=gn),xe=s(t),r(Q.$$.fragment,t),Ae=s(t),r(E.$$.fragment,t),Fe=s(t),r(S.$$.fragment,t),He=s(t),P=o(t,"P",{"data-svelte-h":!0}),p(P)!=="svelte-12ic4qe"&&(P.innerHTML=Tn),Ye=s(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-f1cbgc"&&(L.textContent=Un),ze=s(t),r(q.$$.fragment,t),Ne=s(t),D=o(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ohj6o9"&&(D.textContent=Jn),Qe=s(t),K=o(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1q35fmx"&&(K.textContent=$n),Ee=s(t),O=o(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1o3evl6"&&(O.textContent=Cn),Se=s(t),tt=o(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1kirzpz"&&(tt.textContent=_n),Pe=s(t),r(et.$$.fragment,t),Le=s(t),lt=o(t,"PRE",{"data-svelte-h":!0}),p(lt)!=="svelte-j0gwzs"&&(lt.textContent=Zn),qe=s(t),r(nt.$$.fragment,t),De=s(t),at=o(t,"PRE",{"data-svelte-h":!0}),p(at)!=="svelte-156di1e"&&(at.textContent=vn),Ke=s(t),st=o(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1uwz1x1"&&(st.textContent=Gn),Oe=s(t),r(it.$$.fragment,t),tl=s(t),ot=o(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-t6xz5y"&&(ot.textContent=Wn),el=s(t),pt=o(t,"UL",{"data-svelte-h":!0}),p(pt)!=="svelte-q7foik"&&(pt.innerHTML=Xn),ll=s(t),r(mt.$$.fragment,t),nl=s(t),r(rt.$$.fragment,t),al=s(t),r(Mt.$$.fragment,t),sl=s(t),r(dt.$$.fragment,t),il=s(t),ut=o(t,"PRE",{"data-svelte-h":!0}),p(ut)!=="svelte-19qaqk6"&&(ut.textContent=kn),ol=s(t),r(yt.$$.fragment,t),pl=s(t),r(ht.$$.fragment,t),ml=s(t),r(ft.$$.fragment,t),rl=s(t),r(ct.$$.fragment,t),Ml=s(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-dosxno"&&(wt.innerHTML=Rn),dl=s(t),bt=o(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-199aanp"&&(bt.textContent=Bn),ul=s(t),r(jt.$$.fragment,t),yl=s(t),r(gt.$$.fragment,t),hl=s(t),Tt=o(t,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1d6c0z"&&(Tt.textContent=Vn),fl=s(t),r(Ut.$$.fragment,t),cl=s(t),Jt=o(t,"PRE",{"data-svelte-h":!0}),p(Jt)!=="svelte-1j4ogfu"&&(Jt.textContent=In),wl=s(t),r($t.$$.fragment,t),bl=s(t),Ct=o(t,"PRE",{"data-svelte-h":!0}),p(Ct)!=="svelte-1j4ogfu"&&(Ct.textContent=xn),jl=s(t),_t=o(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1ypb27x"&&(_t.innerHTML=An),gl=s(t),Zt=o(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1awt1kq"&&(Zt.textContent=Fn),Tl=s(t),r(vt.$$.fragment,t),Ul=s(t),r(Gt.$$.fragment,t),Jl=s(t),Wt=o(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-brx99y"&&(Wt.textContent=Hn),$l=s(t),r(Xt.$$.fragment,t),Cl=s(t),r(kt.$$.fragment,t),_l=s(t),Rt=o(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-nidd2f"&&(Rt.textContent=Yn),Zl=s(t),r(Bt.$$.fragment,t),vl=s(t),r(Vt.$$.fragment,t),Gl=s(t),r(It.$$.fragment,t),Wl=s(t),xt=o(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-mfp794"&&(xt.textContent=zn),Xl=s(t),r(At.$$.fragment,t),kl=s(t),Ft=o(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-cdfxhl"&&(Ft.textContent=Nn),Rl=s(t),r(Ht.$$.fragment,t),Bl=s(t),r(Yt.$$.fragment,t),Vl=s(t),zt=o(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-1m1edcj"&&(zt.textContent=Qn),Il=s(t),r(Nt.$$.fragment,t),xl=s(t),r(Qt.$$.fragment,t),Al=s(t),Et=o(t,"PRE",{"data-svelte-h":!0}),p(Et)!=="svelte-17c65rx"&&(Et.textContent=En),Fl=s(t),St=o(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1wnq88c"&&(St.textContent=Sn),Hl=s(t),Pt=o(t,"UL",{"data-svelte-h":!0}),p(Pt)!=="svelte-mfh99e"&&(Pt.innerHTML=Pn),Yl=s(t),Lt=o(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1i1i2t5"&&(Lt.textContent=Ln),zl=s(t),r(qt.$$.fragment,t),Nl=s(t),r(Dt.$$.fragment,t),Ql=s(t),Kt=o(t,"PRE",{"data-svelte-h":!0}),p(Kt)!=="svelte-1h21gmq"&&(Kt.textContent=qn),El=s(t),Ot=o(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1shp62p"&&(Ot.textContent=Dn),Sl=s(t),te=o(t,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-111al67"&&(te.innerHTML=Kn),Pl=s(t),r(ee.$$.fragment,t),Ll=s(t),le=o(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1cb43mv"&&(le.textContent=On),ql=s(t),ne=o(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-6kx7bz"&&(ne.textContent=ta),Dl=s(t),ae=o(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-108kauw"&&(ae.textContent=ea),Kl=s(t),se=o(t,"P",{"data-svelte-h":!0}),p(se)!=="svelte-pbb6ov"&&(se.innerHTML=la),Ol=s(t),r(ie.$$.fragment,t),tn=s(t),r(oe.$$.fragment,t),en=s(t),me=o(t,"P",{}),na(me).forEach(l),this.h()},h(){aa(c,"name","hf:doc:metadata"),aa(c,"content",fa)},m(t,e){Ma(document.head,c),n(t,re,e),n(t,pe,e),n(t,Me,e),M(w,t,e),n(t,de,e),M(b,t,e),n(t,ue,e),M(j,t,e),n(t,ye,e),n(t,g,e),n(t,he,e),n(t,T,e),n(t,fe,e),n(t,U,e),n(t,ce,e),n(t,J,e),n(t,we,e),M($,t,e),n(t,be,e),n(t,C,e),n(t,je,e),n(t,_,e),n(t,ge,e),n(t,Z,e),n(t,Te,e),n(t,v,e),n(t,Ue,e),n(t,G,e),n(t,Je,e),n(t,W,e),n(t,$e,e),n(t,X,e),n(t,Ce,e),M(k,t,e),n(t,_e,e),n(t,R,e),n(t,Ze,e),n(t,B,e),n(t,ve,e),M(V,t,e),n(t,Ge,e),n(t,I,e),n(t,We,e),M(x,t,e),n(t,Xe,e),M(A,t,e),n(t,ke,e),n(t,F,e),n(t,Re,e),M(H,t,e),n(t,Be,e),M(Y,t,e),n(t,Ve,e),n(t,z,e),n(t,Ie,e),n(t,N,e),n(t,xe,e),M(Q,t,e),n(t,Ae,e),M(E,t,e),n(t,Fe,e),M(S,t,e),n(t,He,e),n(t,P,e),n(t,Ye,e),n(t,L,e),n(t,ze,e),M(q,t,e),n(t,Ne,e),n(t,D,e),n(t,Qe,e),n(t,K,e),n(t,Ee,e),n(t,O,e),n(t,Se,e),n(t,tt,e),n(t,Pe,e),M(et,t,e),n(t,Le,e),n(t,lt,e),n(t,qe,e),M(nt,t,e),n(t,De,e),n(t,at,e),n(t,Ke,e),n(t,st,e),n(t,Oe,e),M(it,t,e),n(t,tl,e),n(t,ot,e),n(t,el,e),n(t,pt,e),n(t,ll,e),M(mt,t,e),n(t,nl,e),M(rt,t,e),n(t,al,e),M(Mt,t,e),n(t,sl,e),M(dt,t,e),n(t,il,e),n(t,ut,e),n(t,ol,e),M(yt,t,e),n(t,pl,e),M(ht,t,e),n(t,ml,e),M(ft,t,e),n(t,rl,e),M(ct,t,e),n(t,Ml,e),n(t,wt,e),n(t,dl,e),n(t,bt,e),n(t,ul,e),M(jt,t,e),n(t,yl,e),M(gt,t,e),n(t,hl,e),n(t,Tt,e),n(t,fl,e),M(Ut,t,e),n(t,cl,e),n(t,Jt,e),n(t,wl,e),M($t,t,e),n(t,bl,e),n(t,Ct,e),n(t,jl,e),n(t,_t,e),n(t,gl,e),n(t,Zt,e),n(t,Tl,e),M(vt,t,e),n(t,Ul,e),M(Gt,t,e),n(t,Jl,e),n(t,Wt,e),n(t,$l,e),M(Xt,t,e),n(t,Cl,e),M(kt,t,e),n(t,_l,e),n(t,Rt,e),n(t,Zl,e),M(Bt,t,e),n(t,vl,e),M(Vt,t,e),n(t,Gl,e),M(It,t,e),n(t,Wl,e),n(t,xt,e),n(t,Xl,e),M(At,t,e),n(t,kl,e),n(t,Ft,e),n(t,Rl,e),M(Ht,t,e),n(t,Bl,e),M(Yt,t,e),n(t,Vl,e),n(t,zt,e),n(t,Il,e),M(Nt,t,e),n(t,xl,e),M(Qt,t,e),n(t,Al,e),n(t,Et,e),n(t,Fl,e),n(t,St,e),n(t,Hl,e),n(t,Pt,e),n(t,Yl,e),n(t,Lt,e),n(t,zl,e),M(qt,t,e),n(t,Nl,e),M(Dt,t,e),n(t,Ql,e),n(t,Kt,e),n(t,El,e),n(t,Ot,e),n(t,Sl,e),n(t,te,e),n(t,Pl,e),M(ee,t,e),n(t,Ll,e),n(t,le,e),n(t,ql,e),n(t,ne,e),n(t,Dl,e),n(t,ae,e),n(t,Kl,e),n(t,se,e),n(t,Ol,e),M(ie,t,e),n(t,tn,e),M(oe,t,e),n(t,en,e),n(t,me,e),ln=!0},p:ia,i(t){ln||(d(w.$$.fragment,t),d(b.$$.fragment,t),d(j.$$.fragment,t),d($.$$.fragment,t),d(k.$$.fragment,t),d(V.$$.fragment,t),d(x.$$.fragment,t),d(A.$$.fragment,t),d(H.$$.fragment,t),d(Y.$$.fragment,t),d(Q.$$.fragment,t),d(E.$$.fragment,t),d(S.$$.fragment,t),d(q.$$.fragment,t),d(et.$$.fragment,t),d(nt.$$.fragment,t),d(it.$$.fragment,t),d(mt.$$.fragment,t),d(rt.$$.fragment,t),d(Mt.$$.fragment,t),d(dt.$$.fragment,t),d(yt.$$.fragment,t),d(ht.$$.fragment,t),d(ft.$$.fragment,t),d(ct.$$.fragment,t),d(jt.$$.fragment,t),d(gt.$$.fragment,t),d(Ut.$$.fragment,t),d($t.$$.fragment,t),d(vt.$$.fragment,t),d(Gt.$$.fragment,t),d(Xt.$$.fragment,t),d(kt.$$.fragment,t),d(Bt.$$.fragment,t),d(Vt.$$.fragment,t),d(It.$$.fragment,t),d(At.$$.fragment,t),d(Ht.$$.fragment,t),d(Yt.$$.fragment,t),d(Nt.$$.fragment,t),d(Qt.$$.fragment,t),d(qt.$$.fragment,t),d(Dt.$$.fragment,t),d(ee.$$.fragment,t),d(ie.$$.fragment,t),d(oe.$$.fragment,t),ln=!0)},o(t){u(w.$$.fragment,t),u(b.$$.fragment,t),u(j.$$.fragment,t),u($.$$.fragment,t),u(k.$$.fragment,t),u(V.$$.fragment,t),u(x.$$.fragment,t),u(A.$$.fragment,t),u(H.$$.fragment,t),u(Y.$$.fragment,t),u(Q.$$.fragment,t),u(E.$$.fragment,t),u(S.$$.fragment,t),u(q.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(mt.$$.fragment,t),u(rt.$$.fragment,t),u(Mt.$$.fragment,t),u(dt.$$.fragment,t),u(yt.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(ct.$$.fragment,t),u(jt.$$.fragment,t),u(gt.$$.fragment,t),u(Ut.$$.fragment,t),u($t.$$.fragment,t),u(vt.$$.fragment,t),u(Gt.$$.fragment,t),u(Xt.$$.fragment,t),u(kt.$$.fragment,t),u(Bt.$$.fragment,t),u(Vt.$$.fragment,t),u(It.$$.fragment,t),u(At.$$.fragment,t),u(Ht.$$.fragment,t),u(Yt.$$.fragment,t),u(Nt.$$.fragment,t),u(Qt.$$.fragment,t),u(qt.$$.fragment,t),u(Dt.$$.fragment,t),u(ee.$$.fragment,t),u(ie.$$.fragment,t),u(oe.$$.fragment,t),ln=!1},d(t){t&&(l(re),l(pe),l(Me),l(de),l(ue),l(ye),l(g),l(he),l(T),l(fe),l(U),l(ce),l(J),l(we),l(be),l(C),l(je),l(_),l(ge),l(Z),l(Te),l(v),l(Ue),l(G),l(Je),l(W),l($e),l(X),l(Ce),l(_e),l(R),l(Ze),l(B),l(ve),l(Ge),l(I),l(We),l(Xe),l(ke),l(F),l(Re),l(Be),l(Ve),l(z),l(Ie),l(N),l(xe),l(Ae),l(Fe),l(He),l(P),l(Ye),l(L),l(ze),l(Ne),l(D),l(Qe),l(K),l(Ee),l(O),l(Se),l(tt),l(Pe),l(Le),l(lt),l(qe),l(De),l(at),l(Ke),l(st),l(Oe),l(tl),l(ot),l(el),l(pt),l(ll),l(nl),l(al),l(sl),l(il),l(ut),l(ol),l(pl),l(ml),l(rl),l(Ml),l(wt),l(dl),l(bt),l(ul),l(yl),l(hl),l(Tt),l(fl),l(cl),l(Jt),l(wl),l(bl),l(Ct),l(jl),l(_t),l(gl),l(Zt),l(Tl),l(Ul),l(Jl),l(Wt),l($l),l(Cl),l(_l),l(Rt),l(Zl),l(vl),l(Gl),l(Wl),l(xt),l(Xl),l(kl),l(Ft),l(Rl),l(Bl),l(Vl),l(zt),l(Il),l(xl),l(Al),l(Et),l(Fl),l(St),l(Hl),l(Pt),l(Yl),l(Lt),l(zl),l(Nl),l(Ql),l(Kt),l(El),l(Ot),l(Sl),l(te),l(Pl),l(Ll),l(le),l(ql),l(ne),l(Dl),l(ae),l(Kl),l(se),l(Ol),l(tn),l(en),l(me)),l(c),y(w,t),y(b,t),y(j,t),y($,t),y(k,t),y(V,t),y(x,t),y(A,t),y(H,t),y(Y,t),y(Q,t),y(E,t),y(S,t),y(q,t),y(et,t),y(nt,t),y(it,t),y(mt,t),y(rt,t),y(Mt,t),y(dt,t),y(yt,t),y(ht,t),y(ft,t),y(ct,t),y(jt,t),y(gt,t),y(Ut,t),y($t,t),y(vt,t),y(Gt,t),y(Xt,t),y(kt,t),y(Bt,t),y(Vt,t),y(It,t),y(At,t),y(Ht,t),y(Yt,t),y(Nt,t),y(Qt,t),y(qt,t),y(Dt,t),y(ee,t),y(ie,t),y(oe,t)}}}const fa='{"title":"Prompt Tuning With PEFT.","local":"prompt-tuning-with-peft","sections":[{"title":"Brief introduction to Prompt Tuning.","local":"brief-introduction-to-prompt-tuning","sections":[],"depth":2},{"title":"What are we going to do in the notebook?","local":"what-are-we-going-to-do-in-the-notebook","sections":[],"depth":2},{"title":"Loading the PEFT Library","local":"loading-the-peft-library","sections":[{"title":"Loading the model and the tokenizers.","local":"loading-the-model-and-the-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Inference with the pre trained bloom model","local":"inference-with-the-pre-trained-bloom-model","sections":[],"depth":2},{"title":"Preparing the Datasets","local":"preparing-the-datasets","sections":[],"depth":2},{"title":"Fine-Tuning.","local":"fine-tuning","sections":[{"title":"PEFT configurations","local":"peft-configurations","sections":[],"depth":3},{"title":"Creating two Prompt Tuning Models.","local":"creating-two-prompt-tuning-models","sections":[],"depth":3}],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Save models","local":"save-models","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ca(nn){return oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ua extends pa{constructor(c){super(),ma(this,c,ca,ha,sa,{})}}export{Ua as component};
