import{s as ws,n as gs,o as Js}from"../chunks/scheduler.1f027d5a.js";import{S as Ts,i as js,e as i,s as n,c as p,h as bs,a as o,d as s,b as a,f as ys,g as c,j as r,k as us,l as Us,m as l,n as m,t as M,o as d,p as h}from"../chunks/index.5cb6ce42.js";import{C as fs}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Is,C as y}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as u,E as Cs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Zs(Rt){let w,Ce,fe,Ze,g,ve,J,Be,T,Ge,j,Vt='Authored By: <a href="https://huggingface.co/RichmondMongo" rel="nofollow">Richmond Alake</a>',Ae,b,We,U,Qt="The shell command sequence below installs libraries for leveraging open-source large language models (LLMs), embedding models, and database interaction functionalities. These libraries simplify the development of a RAG system, reducing the complexity to a small amount of code:",$e,f,St="<li>PyMongo: A Python library for interacting with MongoDB that enables functionalities to connect to a cluster and query data stored in collections and documents.</li> <li>Pandas: Provides a data structure for efficient data processing and analysis using Python</li> <li>Hugging Face datasets: Holds audio, vision, and text datasets</li> <li>Hugging Face Accelerate: Abstracts the complexity of writing code that leverages hardware accelerators such as GPUs. Accelerate is leveraged in the implementation to utilise the Gemma model on GPU resources.</li> <li>Hugging Face Transformers: Access to a vast collection of pre-trained models</li> <li>Hugging Face Sentence Transformers: Provides access to sentence, text, and image embeddings.</li>",ke,I,Re,C,Ve,Z,_t=`The data utilised in this tutorial is sourced from Hugging Face datasets, specifically the
<a href="https://huggingface.co/datasets/AIatMongoDB/embedded_movies" rel="nofollow">AIatMongoDB/embedded_movies dataset</a>.`,Qe,v,Se,B,xt="The operations within the following code snippet below focus on enforcing data integrity and quality.",_e,G,qt="<li>The first process ensures that each data point’s <code>fullplot</code> attribute is not empty, as this is the primary data we utilise in the embedding process.</li> <li>This step also ensures we remove the <code>plot_embedding</code> attribute from all data points as this will be replaced by new embeddings created with a different embedding model, the <code>gte-large</code>.</li>",xe,A,qe,W,Et=`Number of missing values in each column after removal:
num_mflix_comments      0
genres                  0
countries               0
directors              12
fullplot                0
writers                13
awards                  0
runtime                14
type                    0
rated                 279
metacritic            893
poster                 78
languages               1
imdb                    0
plot                    0
cast                    1
plot_embedding          1
title                   0
dtype: int64
`,Ee,$,Ne,k,Nt="<strong>The steps in the code snippets are as follows:</strong>",Xe,R,Xt="<li>Import the <code>SentenceTransformer</code> class to access the embedding models.</li> <li>Load the embedding model using the <code>SentenceTransformer</code> constructor to instantiate the <code>gte-large</code> embedding model.</li> <li>Define the <code>get_embedding</code> function, which takes a text string as input and returns a list of floats representing the embedding. The function first checks if the input text is not empty (after stripping whitespace). If the text is empty, it returns an empty list. Otherwise, it generates an embedding using the loaded model.</li> <li>Generate embeddings by applying the <code>get_embedding</code> function to the “fullplot” column of the <code>dataset_df</code> DataFrame, generating embeddings for each movie’s plot. The resulting list of embeddings is assigned to a new column named embedding.</li>",He,V,Ht="<em>Note: It’s not necessary to chunk the text in the full plot, as we can ensure that the text length remains within a manageable range.</em>",Ye,Q,Fe,S,ze,_,Yt="MongoDB acts as both an operational and a vector database. It offers a database solution that efficiently stores, queries and retrieves vector embeddings—the advantages of this lie in the simplicity of database maintenance, management and cost.",De,x,Ft="<strong>To create a new MongoDB database, set up a database cluster:</strong>",Pe,q,zt='<li><p>Head over to MongoDB official site and register for a <a href="https://www.mongodb.com/cloud/atlas/register?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alake" rel="nofollow">free MongoDB Atlas account</a>, or for existing users, <a href="https://account.mongodb.com/account/login?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alakee" rel="nofollow">sign into MongoDB Atlas</a>.</p></li> <li><p>Select the ‘Database’ option on the left-hand pane, which will navigate to the Database Deployment page, where there is a deployment specification of any existing cluster. Create a new database cluster by clicking on the “+Create” button.</p></li> <li><p>Select all the applicable configurations for the database cluster. Once all the configuration options are selected, click the “Create Cluster” button to deploy the newly created cluster. MongoDB also enables the creation of free clusters on the “Shared Tab”.</p> <p><em>Note: Don’t forget to whitelist the IP for the Python host or 0.0.0.0/0 for any IP when creating proof of concepts.</em></p></li> <li><p>After successfully creating and deploying the cluster, the cluster becomes accessible on the ‘Database Deployment’ page.</p></li> <li><p>Click on the “Connect” button of the cluster to view the option to set up a connection to the cluster via various language drivers.</p></li> <li><p>This tutorial only requires the cluster’s URI(unique resource identifier). Grab the URI and copy it into the Google Colabs Secrets environment in a variable named <code>MONGO_URI</code> or place it in a .env file or equivalent.</p></li>',Le,E,Ke,N,Dt="Before moving forward, ensure the following prerequisites are met",Oe,X,Pt="<li>Database cluster set up on MongoDB Atlas</li> <li>Obtained the URI to your cluster</li>",et,H,Lt='For assistance with database cluster setup and obtaining the URI, refer to our guide for <a href="https://www.mongodb.com/docs/guides/atlas/cluster/" rel="nofollow">setting up a MongoDB cluster</a> and <a href="https://www.mongodb.com/docs/guides/atlas/connection-string/" rel="nofollow">getting your connection string</a>',tt,Y,Kt="Once you have created a cluster, create the database and collection within the MongoDB Atlas cluster by clicking + Create Database in the cluster overview page.",st,F,Ot='Here is a guide for <a href="https://www.mongodb.com/basics/create-database" rel="nofollow">creating a database and collection</a>',lt,z,es="<strong>The database will be named <code>movies</code>.</strong>",nt,D,ts="<strong>The collection will be named <code>movie_collection_2</code>.</strong>",at,P,it,L,ss="At this point make sure that your vector index is created via MongoDB Atlas.",ot,K,ls="This next step is mandatory for conducting efficient and accurate vector-based searches based on the vector embeddings stored within the documents in the <code>movie_collection_2</code> collection.",rt,O,ns="Creating a Vector Search Index enables the ability to traverse the documents efficiently to retrieve documents with embeddings that match the query embedding based on vector similarity.",pt,ee,as='Go here to read more about <a href="https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/" rel="nofollow">MongoDB Vector Search Index</a>.',ct,te,mt,se,is="The <code>1024</code> value of the numDimension field corresponds to the dimension of the vector generated by the gte-large embedding model. If you use the <code>gte-base</code> or <code>gte-small</code> embedding models, the numDimension value in the vector search index must be set to 768 and 384, respectively.",Mt,le,dt,ne,os="The code snippet below also utilises PyMongo to create a MongoDB client object, representing the connection to the cluster and enabling access to its databases and collections.",ht,ae,yt,ie,rs=`Connection to MongoDB successful
`,ut,oe,wt,re,ps="Ingesting data into a MongoDB collection from a pandas DataFrame is a straightforward process that can be efficiently accomplished by converting the DataFrame into dictionaries and then utilising the <code>insert_many</code> method on the collection to pass the converted dataset records.",gt,pe,Jt,ce,cs=`Data ingestion into MongoDB completed
`,Tt,me,jt,Me,ms="The following step implements a function that returns a vector search result by generating a query embedding and defining a MongoDB aggregation pipeline.",bt,de,Ms="The pipeline, consisting of the <code>$vectorSearch</code> and <code>$project</code> stages, executes queries using the generated vector and formats the results to include only the required information, such as plot, title, and genres while incorporating a search score for each result.",Ut,he,ft,ye,It,ue,Ct,we,Zt,ge,ds=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as "Pearl Harbor."
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo & Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.
`,vt,Je,Bt,Te,Gt,je,hs=`<bos>Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara&#39;s uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as &quot;Pearl Harbor.&quot;
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship&#39;s maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne&#39;er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo &amp; Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.

Based on the search results, the best romantic movie to watch is **Shut Up and Kiss Me!** because it is a romantic comedy that explores the complexities of love and relationships. The movie is funny, heartwarming, and thought-provoking.<eos>
</eos></bos>`,At,be,Wt,Ue,$t,Ie,kt;return g=new Is({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_mongodb.ipynb"}]}}),J=new fs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new u({props:{title:"Building A RAG System with Gemma, MongoDB and Open Source Models",local:"building-a-rag-system-with-gemma-mongodb-and-open-source-models",headingTag:"h1"}}),b=new u({props:{title:"Step 1: Installing Libraries",local:"step-1-installing-libraries",headingTag:"h2"}}),I=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHB5bW9uZ28lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMEEhcGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwSW5zdGFsbCUyMGJlbG93JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:`!pip install datasets pandas pymongo sentence_transformers
!pip install -U transformers
<span class="hljs-comment"># Install below if using GPU</span>
!pip install accelerate`,wrap:!1}}),C=new u({props:{title:"Step 2: Data sourcing and preparation",local:"step-2-data-sourcing-and-preparation",headingTag:"h2"}}),v=new y({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGQUlhdE1vbmdvREIlMkZlbWJlZGRlZF9tb3ZpZXMlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMkFJYXRNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjB0aGUlMjBkYXRhc2V0JTIwdG8lMjBhJTIwcGFuZGFzJTIwZGF0YWZyYW1lJTBBZGF0YXNldF9kZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBZGF0YXNldF9kZi5oZWFkKDUp",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># https://huggingface.co/datasets/AIatMongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;AIatMongoDB/embedded_movies&quot;</span>)

<span class="hljs-comment"># Convert the dataset to a pandas dataframe</span>
dataset_df = pd.DataFrame(dataset[<span class="hljs-string">&quot;train&quot;</span>])

dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),A=new y({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3BuYShzdWJzZXQlM0QlNUIlMjJmdWxscGxvdCUyMiU1RCklMEFwcmludCglMjIlNUNuTnVtYmVyJTIwb2YlMjBtaXNzaW5nJTIwdmFsdWVzJTIwaW4lMjBlYWNoJTIwY29sdW1uJTIwYWZ0ZXIlMjByZW1vdmFsJTNBJTIyKSUwQXByaW50KGRhdGFzZXRfZGYuaXNudWxsKCkuc3VtKCkpJTBBJTBBJTIzJTIwUmVtb3ZlJTIwdGhlJTIwcGxvdF9lbWJlZGRpbmclMjBmcm9tJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMGluJTIwdGhlJTIwZGF0YXNldCUyMGFzJTIwd2UlMjBhcmUlMjBnb2luZyUyMHRvJTIwY3JlYXRlJTIwbmV3JTIwZW1iZWRkaW5ncyUyMHdpdGglMjBhbiUyMG9wZW4lMjBzb3VyY2UlMjBlbWJlZGRpbmclMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3AoY29sdW1ucyUzRCU1QiUyMnBsb3RfZW1iZWRkaW5nJTIyJTVEKSUwQWRhdGFzZXRfZGYuaGVhZCg1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Data Preparation</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.dropna(subset=[<span class="hljs-string">&quot;fullplot&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nNumber of missing values in each column after removal:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset_df.isnull().<span class="hljs-built_in">sum</span>())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.drop(columns=[<span class="hljs-string">&quot;plot_embedding&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),$=new u({props:{title:"Step 3: Generating embeddings",local:"step-3-generating-embeddings",headingTag:"h2"}}),Q=new y({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGhlbmxwZXIlMkZndGUtbGFyZ2UlMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMnRoZW5scGVyJTJGZ3RlLWxhcmdlJTIyKSUwQSUwQSUwQWRlZiUyMGdldF9lbWJlZGRpbmcodGV4dCUzQSUyMHN0ciklMjAtJTNFJTIwbGlzdCU1QmZsb2F0JTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjB0ZXh0LnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJBdHRlbXB0ZWQlMjB0byUyMGdldCUyMGVtYmVkZGluZyUyMGZvciUyMGVtcHR5JTIwdGV4dC4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTVEJTBBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTIwJTNEJTIwZW1iZWRkaW5nX21vZGVsLmVuY29kZSh0ZXh0KSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZy50b2xpc3QoKSUwQSUwQSUwQWRhdGFzZXRfZGYlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjBkYXRhc2V0X2RmJTVCJTIyZnVsbHBsb3QlMjIlNUQuYXBwbHkoZ2V0X2VtYmVkZGluZyklMEElMEFkYXRhc2V0X2RmLmhlYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># https://huggingface.co/thenlper/gte-large</span>
embedding_model = SentenceTransformer(<span class="hljs-string">&quot;thenlper/gte-large&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
        <span class="hljs-keyword">return</span> []

    embedding = embedding_model.encode(text)

    <span class="hljs-keyword">return</span> embedding.tolist()


dataset_df[<span class="hljs-string">&quot;embedding&quot;</span>] = dataset_df[<span class="hljs-string">&quot;fullplot&quot;</span>].apply(get_embedding)

dataset_df.head()`,wrap:!1}}),S=new u({props:{title:"Step 4: Database setup and connection",local:"step-4-database-setup-and-connection",headingTag:"h2"}}),E=new u({props:{title:"4.1 Database and Collection Setup",local:"41-database-and-collection-setup",headingTag:"h3"}}),P=new u({props:{title:"Step 5: Create a Vector Search Index",local:"step-5-create-a-vector-search-index",headingTag:"h2"}}),te=new y({props:{code:"JTdCJTBBJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIybnVtRGltZW5zaW9ucyUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJwYXRoJTIyJTNBJTIwJTIyZW1iZWRkaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyc2ltaWxhcml0eSUyMiUzQSUyMCUyMmNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ2ZWN0b3IlMjIlMEElMjAlMjAlMjAlN0QlNUQlMEElN0QlMEE=",highlighted:`{
 <span class="hljs-string">&quot;fields&quot;</span>: [{
     <span class="hljs-string">&quot;numDimensions&quot;</span>: <span class="hljs-number">1024</span>,
     <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
     <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
     <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;vector&quot;</span>
   }]
}
`,wrap:!1}}),le=new u({props:{title:"Step 6: Establish Data Connection",local:"step-6-establish-data-connection",headingTag:"h2"}}),ae=new y({props:{code:"aW1wb3J0JTIwcHltb25nbyUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQSUwQSUwQWRlZiUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkVzdGFibGlzaCUyMGNvbm5lY3Rpb24lMjB0byUyMHRoZSUyME1vbmdvREIuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2xpZW50JTIwJTNEJTIwcHltb25nby5Nb25nb0NsaWVudChtb25nb191cmkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQ29ubmVjdGlvbiUyMHRvJTIwTW9uZ29EQiUyMHN1Y2Nlc3NmdWwlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2xpZW50JTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwcHltb25nby5lcnJvcnMuQ29ubmVjdGlvbkZhaWx1cmUlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyQ29ubmVjdGlvbiUyMGZhaWxlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUwQSUwQSUwQW1vbmdvX3VyaSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJNT05HT19VUkklMjIpJTBBaWYlMjBub3QlMjBtb25nb191cmklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJNT05HT19VUkklMjBub3QlMjBzZXQlMjBpbiUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIyKSUwQSUwQW1vbmdvX2NsaWVudCUyMCUzRCUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUwQSUwQSUyMyUyMEluZ2VzdCUyMGRhdGElMjBpbnRvJTIwTW9uZ29EQiUwQWRiJTIwJTNEJTIwbW9uZ29fY2xpZW50JTVCJTIybW92aWVzJTIyJTVEJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRiJTVCJTIybW92aWVfY29sbGVjdGlvbl8yJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pymongo
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_mongo_client</span>(<span class="hljs-params">mongo_uri</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Establish connection to the MongoDB.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        client = pymongo.MongoClient(mongo_uri)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Connection to MongoDB successful&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> pymongo.errors.ConnectionFailure <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Connection failed: <span class="hljs-subst">{e}</span>&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


<span class="hljs-meta">... </span>mongo_uri = userdata.get(<span class="hljs-string">&quot;MONGO_URI&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> mongo_uri:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;MONGO_URI not set in environment variables&quot;</span>)

<span class="hljs-meta">... </span>mongo_client = get_mongo_client(mongo_uri)

<span class="hljs-meta">... </span><span class="hljs-comment"># Ingest data into MongoDB</span>
<span class="hljs-meta">... </span>db = mongo_client[<span class="hljs-string">&quot;movies&quot;</span>]
<span class="hljs-meta">... </span>collection = db[<span class="hljs-string">&quot;movie_collection_2&quot;</span>]`,wrap:!1}}),oe=new y({props:{code:"JTIzJTIwRGVsZXRlJTIwYW55JTIwZXhpc3RpbmclMjByZWNvcmRzJTIwaW4lMjB0aGUlMjBjb2xsZWN0aW9uJTBBY29sbGVjdGlvbi5kZWxldGVfbWFueSglN0IlN0Qp",highlighted:`<span class="hljs-comment"># Delete any existing records in the collection</span>
collection.delete_many({})`,wrap:!1}}),pe=new y({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldF9kZi50b19kaWN0KCUyMnJlY29yZHMlMjIpJTBBY29sbGVjdGlvbi5pbnNlcnRfbWFueShkb2N1bWVudHMpJTBBJTBBcHJpbnQoJTIyRGF0YSUyMGluZ2VzdGlvbiUyMGludG8lMjBNb25nb0RCJTIwY29tcGxldGVkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>documents = dataset_df.to_dict(<span class="hljs-string">&quot;records&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.insert_many(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into MongoDB completed&quot;</span>)`,wrap:!1}}),me=new u({props:{title:"Step 7: Perform Vector Search on User Queries",local:"step-7-perform-vector-search-on-user-queries",headingTag:"h2"}}),he=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">user_query, collection</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Perform a vector search in the MongoDB collection based on the user query.

    Args:
    user_query (str): The user&#x27;s query string.
    collection (MongoCollection): The MongoDB collection to search.

    Returns:
    list: A list of matching documents.
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># Generate embedding for the user query</span>
    query_embedding = get_embedding(user_query)

    <span class="hljs-keyword">if</span> query_embedding <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Invalid query or embedding generation failed.&quot;</span>

    <span class="hljs-comment"># Define the vector search pipeline</span>
    pipeline = [
        {
            <span class="hljs-string">&quot;$vectorSearch&quot;</span>: {
                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;vector_index&quot;</span>,
                <span class="hljs-string">&quot;queryVector&quot;</span>: query_embedding,
                <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
                <span class="hljs-string">&quot;numCandidates&quot;</span>: <span class="hljs-number">150</span>,  <span class="hljs-comment"># Number of candidate matches to consider</span>
                <span class="hljs-string">&quot;limit&quot;</span>: <span class="hljs-number">4</span>,  <span class="hljs-comment"># Return top 4 matches</span>
            }
        },
        {
            <span class="hljs-string">&quot;$project&quot;</span>: {
                <span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-number">0</span>,  <span class="hljs-comment"># Exclude the _id field</span>
                <span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the plot field</span>
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the title field</span>
                <span class="hljs-string">&quot;genres&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the genres field</span>
                <span class="hljs-string">&quot;score&quot;</span>: {<span class="hljs-string">&quot;$meta&quot;</span>: <span class="hljs-string">&quot;vectorSearchScore&quot;</span>},  <span class="hljs-comment"># Include the search score</span>
            }
        },
    ]

    <span class="hljs-comment"># Execute the search</span>
    results = collection.aggregate(pipeline)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(results)`,wrap:!1}}),ye=new u({props:{title:"Step 8: Handling user queries and loading Gemma",local:"step-8-handling-user-queries-and-loading-gemma",headingTag:"h2"}}),ue=new y({props:{code:"ZGVmJTIwZ2V0X3NlYXJjaF9yZXN1bHQocXVlcnklMkMlMjBjb2xsZWN0aW9uKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGdldF9rbm93bGVkZ2UlMjAlM0QlMjB2ZWN0b3Jfc2VhcmNoKHF1ZXJ5JTJDJTIwY29sbGVjdGlvbiklMEElMEElMjAlMjAlMjAlMjBzZWFyY2hfcmVzdWx0JTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVzdWx0JTIwaW4lMjBnZXRfa25vd2xlZGdlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VhcmNoX3Jlc3VsdCUyMCUyQiUzRCUyMGYlMjJUaXRsZSUzQSUyMCU3QnJlc3VsdC5nZXQoJ3RpdGxlJyUyQyUyMCdOJTJGQScpJTdEJTJDJTIwUGxvdCUzQSUyMCU3QnJlc3VsdC5nZXQoJ2Z1bGxwbG90JyUyQyUyMCdOJTJGQScpJTdEJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlYXJjaF9yZXN1bHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_search_result</span>(<span class="hljs-params">query, collection</span>):

    get_knowledge = vector_search(query, collection)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),we=new y({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFzb3VyY2VfaW5mb3JtYXRpb24lMjAlM0QlMjBnZXRfc2VhcmNoX3Jlc3VsdChxdWVyeSUyQyUyMGNvbGxlY3Rpb24pJTBBY29tYmluZWRfaW5mb3JtYXRpb24lMjAlM0QlMjBmJTIyUXVlcnklM0ElMjAlN0JxdWVyeSU3RCU1Q25Db250aW51ZSUyMHRvJTIwYW5zd2VyJTIwdGhlJTIwcXVlcnklMjBieSUyMHVzaW5nJTIwdGhlJTIwU2VhcmNoJTIwUmVzdWx0cyUzQSU1Q24lN0Jzb3VyY2VfaW5mb3JtYXRpb24lN0QuJTIyJTBBJTBBcHJpbnQoY29tYmluZWRfaW5mb3JtYXRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source_information = get_search_result(query, collection)
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_information = <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using the Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_information)`,wrap:!1}}),Je=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;)</span>
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Te=new y({props:{code:"JTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFyZXNwb25zZSUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MDApJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShyZXNwb25zZSU1QjAlNUQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">500</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(response[<span class="hljs-number">0</span>]))`,wrap:!1}}),be=new y({props:{code:"",highlighted:"",wrap:!1}}),Ue=new Cs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_mongodb.md"}}),{c(){w=i("meta"),Ce=n(),fe=i("p"),Ze=n(),p(g.$$.fragment),ve=n(),p(J.$$.fragment),Be=n(),p(T.$$.fragment),Ge=n(),j=i("p"),j.innerHTML=Vt,Ae=n(),p(b.$$.fragment),We=n(),U=i("p"),U.textContent=Qt,$e=n(),f=i("ul"),f.innerHTML=St,ke=n(),p(I.$$.fragment),Re=n(),p(C.$$.fragment),Ve=n(),Z=i("p"),Z.innerHTML=_t,Qe=n(),p(v.$$.fragment),Se=n(),B=i("p"),B.textContent=xt,_e=n(),G=i("ol"),G.innerHTML=qt,xe=n(),p(A.$$.fragment),qe=n(),W=i("pre"),W.textContent=Et,Ee=n(),p($.$$.fragment),Ne=n(),k=i("p"),k.innerHTML=Nt,Xe=n(),R=i("ol"),R.innerHTML=Xt,He=n(),V=i("p"),V.innerHTML=Ht,Ye=n(),p(Q.$$.fragment),Fe=n(),p(S.$$.fragment),ze=n(),_=i("p"),_.textContent=Yt,De=n(),x=i("p"),x.innerHTML=Ft,Pe=n(),q=i("ol"),q.innerHTML=zt,Le=n(),p(E.$$.fragment),Ke=n(),N=i("p"),N.textContent=Dt,Oe=n(),X=i("ul"),X.innerHTML=Pt,et=n(),H=i("p"),H.innerHTML=Lt,tt=n(),Y=i("p"),Y.textContent=Kt,st=n(),F=i("p"),F.innerHTML=Ot,lt=n(),z=i("p"),z.innerHTML=es,nt=n(),D=i("p"),D.innerHTML=ts,at=n(),p(P.$$.fragment),it=n(),L=i("p"),L.textContent=ss,ot=n(),K=i("p"),K.innerHTML=ls,rt=n(),O=i("p"),O.textContent=ns,pt=n(),ee=i("p"),ee.innerHTML=as,ct=n(),p(te.$$.fragment),mt=n(),se=i("p"),se.innerHTML=is,Mt=n(),p(le.$$.fragment),dt=n(),ne=i("p"),ne.textContent=os,ht=n(),p(ae.$$.fragment),yt=n(),ie=i("pre"),ie.textContent=rs,ut=n(),p(oe.$$.fragment),wt=n(),re=i("p"),re.innerHTML=ps,gt=n(),p(pe.$$.fragment),Jt=n(),ce=i("pre"),ce.textContent=cs,Tt=n(),p(me.$$.fragment),jt=n(),Me=i("p"),Me.textContent=ms,bt=n(),de=i("p"),de.innerHTML=Ms,Ut=n(),p(he.$$.fragment),ft=n(),p(ye.$$.fragment),It=n(),p(ue.$$.fragment),Ct=n(),p(we.$$.fragment),Zt=n(),ge=i("pre"),ge.textContent=ds,vt=n(),p(Je.$$.fragment),Bt=n(),p(Te.$$.fragment),Gt=n(),je=i("pre"),je.innerHTML=hs,At=n(),p(be.$$.fragment),Wt=n(),p(Ue.$$.fragment),$t=n(),Ie=i("p"),this.h()},l(e){const t=bs("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),Ce=a(e),fe=o(e,"P",{}),ys(fe).forEach(s),Ze=a(e),c(g.$$.fragment,e),ve=a(e),c(J.$$.fragment,e),Be=a(e),c(T.$$.fragment,e),Ge=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-v2pm3i"&&(j.innerHTML=Vt),Ae=a(e),c(b.$$.fragment,e),We=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1l8u5ax"&&(U.textContent=Qt),$e=a(e),f=o(e,"UL",{"data-svelte-h":!0}),r(f)!=="svelte-oizoqw"&&(f.innerHTML=St),ke=a(e),c(I.$$.fragment,e),Re=a(e),c(C.$$.fragment,e),Ve=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-mi16g3"&&(Z.innerHTML=_t),Qe=a(e),c(v.$$.fragment,e),Se=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-s56722"&&(B.textContent=xt),_e=a(e),G=o(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-18k6dgd"&&(G.innerHTML=qt),xe=a(e),c(A.$$.fragment,e),qe=a(e),W=o(e,"PRE",{"data-svelte-h":!0}),r(W)!=="svelte-kp0u3c"&&(W.textContent=Et),Ee=a(e),c($.$$.fragment,e),Ne=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-16a70y4"&&(k.innerHTML=Nt),Xe=a(e),R=o(e,"OL",{"data-svelte-h":!0}),r(R)!=="svelte-2t4hjb"&&(R.innerHTML=Xt),He=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-18ffxry"&&(V.innerHTML=Ht),Ye=a(e),c(Q.$$.fragment,e),Fe=a(e),c(S.$$.fragment,e),ze=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1bv8nrt"&&(_.textContent=Yt),De=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1lfzr8d"&&(x.innerHTML=Ft),Pe=a(e),q=o(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-1mt6yhl"&&(q.innerHTML=zt),Le=a(e),c(E.$$.fragment,e),Ke=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ee4dh7"&&(N.textContent=Dt),Oe=a(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-12k93hp"&&(X.innerHTML=Pt),et=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1rvrea9"&&(H.innerHTML=Lt),tt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-19eikyc"&&(Y.textContent=Kt),st=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-g1ykc5"&&(F.innerHTML=Ot),lt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1slb9bh"&&(z.innerHTML=es),nt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-7nku6n"&&(D.innerHTML=ts),at=a(e),c(P.$$.fragment,e),it=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-bgxno0"&&(L.textContent=ss),ot=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-ryzl16"&&(K.innerHTML=ls),rt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1haeg7n"&&(O.textContent=ns),pt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1x2bslh"&&(ee.innerHTML=as),ct=a(e),c(te.$$.fragment,e),mt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1lac1sw"&&(se.innerHTML=is),Mt=a(e),c(le.$$.fragment,e),dt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-c17qkj"&&(ne.textContent=os),ht=a(e),c(ae.$$.fragment,e),yt=a(e),ie=o(e,"PRE",{"data-svelte-h":!0}),r(ie)!=="svelte-1im4pel"&&(ie.textContent=rs),ut=a(e),c(oe.$$.fragment,e),wt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1f9pwum"&&(re.innerHTML=ps),gt=a(e),c(pe.$$.fragment,e),Jt=a(e),ce=o(e,"PRE",{"data-svelte-h":!0}),r(ce)!=="svelte-48vgel"&&(ce.textContent=cs),Tt=a(e),c(me.$$.fragment,e),jt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1r00an3"&&(Me.textContent=ms),bt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1hz15p5"&&(de.innerHTML=Ms),Ut=a(e),c(he.$$.fragment,e),ft=a(e),c(ye.$$.fragment,e),It=a(e),c(ue.$$.fragment,e),Ct=a(e),c(we.$$.fragment,e),Zt=a(e),ge=o(e,"PRE",{"data-svelte-h":!0}),r(ge)!=="svelte-kam1j9"&&(ge.textContent=ds),vt=a(e),c(Je.$$.fragment,e),Bt=a(e),c(Te.$$.fragment,e),Gt=a(e),je=o(e,"PRE",{"data-svelte-h":!0}),r(je)!=="svelte-146jypo"&&(je.innerHTML=hs),At=a(e),c(be.$$.fragment,e),Wt=a(e),c(Ue.$$.fragment,e),$t=a(e),Ie=o(e,"P",{}),ys(Ie).forEach(s),this.h()},h(){us(w,"name","hf:doc:metadata"),us(w,"content",vs)},m(e,t){Us(document.head,w),l(e,Ce,t),l(e,fe,t),l(e,Ze,t),m(g,e,t),l(e,ve,t),m(J,e,t),l(e,Be,t),m(T,e,t),l(e,Ge,t),l(e,j,t),l(e,Ae,t),m(b,e,t),l(e,We,t),l(e,U,t),l(e,$e,t),l(e,f,t),l(e,ke,t),m(I,e,t),l(e,Re,t),m(C,e,t),l(e,Ve,t),l(e,Z,t),l(e,Qe,t),m(v,e,t),l(e,Se,t),l(e,B,t),l(e,_e,t),l(e,G,t),l(e,xe,t),m(A,e,t),l(e,qe,t),l(e,W,t),l(e,Ee,t),m($,e,t),l(e,Ne,t),l(e,k,t),l(e,Xe,t),l(e,R,t),l(e,He,t),l(e,V,t),l(e,Ye,t),m(Q,e,t),l(e,Fe,t),m(S,e,t),l(e,ze,t),l(e,_,t),l(e,De,t),l(e,x,t),l(e,Pe,t),l(e,q,t),l(e,Le,t),m(E,e,t),l(e,Ke,t),l(e,N,t),l(e,Oe,t),l(e,X,t),l(e,et,t),l(e,H,t),l(e,tt,t),l(e,Y,t),l(e,st,t),l(e,F,t),l(e,lt,t),l(e,z,t),l(e,nt,t),l(e,D,t),l(e,at,t),m(P,e,t),l(e,it,t),l(e,L,t),l(e,ot,t),l(e,K,t),l(e,rt,t),l(e,O,t),l(e,pt,t),l(e,ee,t),l(e,ct,t),m(te,e,t),l(e,mt,t),l(e,se,t),l(e,Mt,t),m(le,e,t),l(e,dt,t),l(e,ne,t),l(e,ht,t),m(ae,e,t),l(e,yt,t),l(e,ie,t),l(e,ut,t),m(oe,e,t),l(e,wt,t),l(e,re,t),l(e,gt,t),m(pe,e,t),l(e,Jt,t),l(e,ce,t),l(e,Tt,t),m(me,e,t),l(e,jt,t),l(e,Me,t),l(e,bt,t),l(e,de,t),l(e,Ut,t),m(he,e,t),l(e,ft,t),m(ye,e,t),l(e,It,t),m(ue,e,t),l(e,Ct,t),m(we,e,t),l(e,Zt,t),l(e,ge,t),l(e,vt,t),m(Je,e,t),l(e,Bt,t),m(Te,e,t),l(e,Gt,t),l(e,je,t),l(e,At,t),m(be,e,t),l(e,Wt,t),m(Ue,e,t),l(e,$t,t),l(e,Ie,t),kt=!0},p:gs,i(e){kt||(M(g.$$.fragment,e),M(J.$$.fragment,e),M(T.$$.fragment,e),M(b.$$.fragment,e),M(I.$$.fragment,e),M(C.$$.fragment,e),M(v.$$.fragment,e),M(A.$$.fragment,e),M($.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(ue.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),M(Ue.$$.fragment,e),kt=!0)},o(e){d(g.$$.fragment,e),d(J.$$.fragment,e),d(T.$$.fragment,e),d(b.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(A.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(Te.$$.fragment,e),d(be.$$.fragment,e),d(Ue.$$.fragment,e),kt=!1},d(e){e&&(s(Ce),s(fe),s(Ze),s(ve),s(Be),s(Ge),s(j),s(Ae),s(We),s(U),s($e),s(f),s(ke),s(Re),s(Ve),s(Z),s(Qe),s(Se),s(B),s(_e),s(G),s(xe),s(qe),s(W),s(Ee),s(Ne),s(k),s(Xe),s(R),s(He),s(V),s(Ye),s(Fe),s(ze),s(_),s(De),s(x),s(Pe),s(q),s(Le),s(Ke),s(N),s(Oe),s(X),s(et),s(H),s(tt),s(Y),s(st),s(F),s(lt),s(z),s(nt),s(D),s(at),s(it),s(L),s(ot),s(K),s(rt),s(O),s(pt),s(ee),s(ct),s(mt),s(se),s(Mt),s(dt),s(ne),s(ht),s(yt),s(ie),s(ut),s(wt),s(re),s(gt),s(Jt),s(ce),s(Tt),s(jt),s(Me),s(bt),s(de),s(Ut),s(ft),s(It),s(Ct),s(Zt),s(ge),s(vt),s(Bt),s(Gt),s(je),s(At),s(Wt),s($t),s(Ie)),s(w),h(g,e),h(J,e),h(T,e),h(b,e),h(I,e),h(C,e),h(v,e),h(A,e),h($,e),h(Q,e),h(S,e),h(E,e),h(P,e),h(te,e),h(le,e),h(ae,e),h(oe,e),h(pe,e),h(me,e),h(he,e),h(ye,e),h(ue,e),h(we,e),h(Je,e),h(Te,e),h(be,e),h(Ue,e)}}}const vs='{"title":"Building A RAG System with Gemma, MongoDB and Open Source Models","local":"building-a-rag-system-with-gemma-mongodb-and-open-source-models","sections":[{"title":"Step 1: Installing Libraries","local":"step-1-installing-libraries","sections":[],"depth":2},{"title":"Step 2: Data sourcing and preparation","local":"step-2-data-sourcing-and-preparation","sections":[],"depth":2},{"title":"Step 3: Generating embeddings","local":"step-3-generating-embeddings","sections":[],"depth":2},{"title":"Step 4: Database setup and connection","local":"step-4-database-setup-and-connection","sections":[{"title":"4.1 Database and Collection Setup","local":"41-database-and-collection-setup","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Create a Vector Search Index","local":"step-5-create-a-vector-search-index","sections":[],"depth":2},{"title":"Step 6: Establish Data Connection","local":"step-6-establish-data-connection","sections":[],"depth":2},{"title":"Step 7: Perform Vector Search on User Queries","local":"step-7-perform-vector-search-on-user-queries","sections":[],"depth":2},{"title":"Step 8: Handling user queries and loading Gemma","local":"step-8-handling-user-queries-and-loading-gemma","sections":[],"depth":2}],"depth":1}';function Bs(Rt){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Ts{constructor(w){super(),js(this,w,Bs,Zs,ws,{})}}export{Rs as component};
