import{s as Jl,n as Ul,o as hl}from"../chunks/scheduler.1f027d5a.js";import{S as jl,i as Tl,e as o,s as n,c as r,h as bl,a as i,d as l,b as a,f as ml,g as p,j as M,k as dl,l as Il,m as s,n as y,t as c,o as u,p as w}from"../chunks/index.5cb6ce42.js";import{C as gl}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as fl,C as m}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as Te,E as Cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function vl(kt){let d,ge,be,fe,J,Ce,U,ve,h,Ze,j,Rt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Be,T,Wt='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/smolagents/index" rel="nofollow"><strong>smolagents</strong></a> to build awesome <strong>agents</strong>!',Ge,b,Vt="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",ke,I,_t='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',Re,g,$t='What is <strong>smolagents</strong>? It’s an library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/smolagents/index" rel="nofollow">documentation</a>.',We,f,Qt="Let’s see how to use it, and which use cases it can solve.",Ve,C,At="Run the line below to install required dependencies:",_e,v,$e,Z,Xt="Let’s login in order to call the HF Inference API:",Qe,B,Ae,G,Xe,k,Nt="For this use case, we want to show an agent that browses the web and is able to generate images.",Ne,R,St="To build it, we simply need to have two tools ready: image generation and web search.",Se,W,Ht="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we use a built-in tool.</li>",He,V,xe,_,xt=`TOOLCODE:
 from smolagents import Tool
from huggingface_hub import InferenceClient


class TextToImageTool(Tool):
    description = "This tool creates an image according to a prompt, which is a text description."
    name = "image_generator"
    inputs = &#123;"prompt": &#123;"type": "string", "description": "The image generator prompt. Don't hesitate to add details in the prompt to make the image look better, like 'high-res, photorealistic', etc."}}
    output_type = "image"
    model_sdxl = "black-forest-labs/FLUX.1-schnell"
    client = InferenceClient(model_sdxl)


    def forward(self, prompt):
        return self.client.text_to_image(prompt)
`,qe,$,qt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',Ee,Q,Ye,A,Et="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",ze,X,Yt="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",Fe,N,zt="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",Le,S,Ft="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",Pe,H,Lt="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",De,x,Ke,q,Pt="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",Oe,E,et,Y,Dt="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",tt,z,Kt="We want our system to select only from the most relevant sources of information, depending on the query.",lt,F,Ot="Our documentation pages come from the following sources:",st,L,nt,P,el=`['datasets-server', 'datasets', 'optimum', 'gradio', 'blog', 'course', 'hub-docs', 'pytorch-image-models', 'peft', 'evaluate', 'diffusers', 'hf-endpoints-documentation', 'deep-rl-class', 'transformers']
`,at,D,tl="👉 Now let’s build a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",ot,K,ll='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',it,O,Mt,ee,rt,te,sl="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",pt,le,nl="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",yt,se,ct,ne,ut,ae,wt,oe,al="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",mt,ie,ol=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,dt,Me,il="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",Jt,re,Ut,pe,Ml="Since the CodeAgent has a built-in Python code interpreter, we can use it to debug our faulty Python script!",ht,ye,jt,ce,rl="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",Tt,ue,pl="And the final code is the corrected code:",bt,we,It,me,yl=`numbers=[0, 1, 2]

for i in range(len(numbers)):
    print(numbers[i])
`,gt,de,ft,Je,cl="The use cases above should give you a glimpse into the possibilities of our Agents framework!",Ct,Ue,ul='For more advanced usage, read the <a href="https://huggingface.co/docs/smolagents/index" rel="nofollow">documentation</a>.',vt,he,wl="All feedback is welcome, it will help us improve the framework! 🚀",Zt,je,Bt,Ie,Gt;return J=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),U=new gl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new Te({props:{title:"Build an agent with tool-calling superpowers 🦸 using smolagents",local:"build-an-agent-with-tool-calling-superpowers--using-smolagents",headingTag:"h1"}}),v=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwZGF0YXNldHMlMjBsYW5nY2hhaW4lMjBzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMjBmYWlzcy1jcHUlMjBkdWNrZHVja2dvLXNlYXJjaCUyMG9wZW5haSUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents datasets langchain sentence-transformers faiss-cpu duckduckgo-search openai langchain-community --upgrade -q",wrap:!1}}),B=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),G=new Te({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),V=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBib3RoJTIwdG9vbHMlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyR2VuZXJhdGUlMjBtZSUyMGElMjBwaG90byUyMG9mJTIwdGhlJTIwY2FyJTIwdGhhdCUyMEphbWVzJTIwYm9uZCUyMGRyb3ZlJTIwaW4lMjB0aGUlMjBsYXRlc3QlMjBtb3ZpZS4lMjIlMkMlMEEpJTBBcmVzdWx0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, DuckDuckGoSearchTool

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Import tool from Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>search_tool = DuckDuckGoSearchTool()

<span class="hljs-meta">&gt;&gt;&gt; </span>model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the agent with both tools</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = CodeAgent(
<span class="hljs-meta">... </span>    tools=[image_generation_tool, search_tool], model=model
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run it!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = agent.run(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result`,wrap:!1}}),Q=new Te({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),x=new m({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),E=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMEElMjAlMjAlMjAlMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMHNvdXJjZV9kb2NzJTBBKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(
    source_docs
)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),L=new m({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),O=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][<span class="hljs-string">&quot;description&quot;</span>] = (
            <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>.replace(
                <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;\`&quot;</span>
            )
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(
                source
            ):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join(
            [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs]
        )`,wrap:!1}}),ee=new Te({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),se=new m({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwVHJ1ZSUwQSUwQWlmJTIwc2hhcmVfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHJldHJpZXZlciUyMGltcG9ydCUyMFJldHJpZXZlclRvb2wlMEElMEElMjAlMjAlMjAlMjBsb2dpbiglMjJ5b3VyX3Rva2VuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBJTIwJTIwJTIwJTIwdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBMb2FkaW5nJTIwdGhlJTIwdG9vbCUwQSUyMCUyMCUyMCUyMGZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwbG9hZF90b29sJTBBJTBBJTIwJTIwJTIwJTIwcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiUyQyUyMHZlY3RvcmRiJTNEdmVjdG9yZGIlMkMlMjBhbGxfc291cmNlcyUzRGFsbF9zb3VyY2VzJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`share_to_hub = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)

    <span class="hljs-comment"># Loading the tool</span>
    <span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool

    retriever_tool = load_tool(
        <span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources
    )`,wrap:!1}}),ne=new Te({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),ae=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2xDYWxsaW5nQWdlbnQlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIlM0R2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzJTNEYWxsX3NvdXJjZXMpJTBBYWdlbnQlMjAlM0QlMjBUb29sQ2FsbGluZ0FnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdmVyYm9zZSUzRDApJTBBJTBBYWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMHNob3clMjBtZSUyMGElMjBMT1JBJTIwZmluZXR1bmluZyUyMHNjcmlwdCUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, ToolCallingAgent

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb=vectordb, all_sources=all_sources)
agent = ToolCallingAgent(tools=[retriever_tool], model=model, verbose=<span class="hljs-number">0</span>)

agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),re=new Te({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),ye=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbnVtYmVycyUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobnVtYmVycyhpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMkMlMjB0aGVuJTIwcnVuJTIwaXQlMjB0byUyMG1ha2UlMjBzdXJlJTIwaXQlMjB3b3JrcyUyMGFuZCUyMHJldHVybiUyMHRoZSUyMGZpbmFsJTIwY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXJncyUzRGRpY3QoY29kZSUzRGNvZGUpJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], model=InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>))

code = <span class="hljs-string">&quot;&quot;&quot;
numbers=[0, 1, 2]

for i in range(4):
    print(numbers(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it, then run it to make sure it works and return the final code&quot;</span>,
    additional_args=<span class="hljs-built_in">dict</span>(code=code)
)`,wrap:!1}}),we=new m({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),de=new Te({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),je=new Cl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){d=o("meta"),ge=n(),be=o("p"),fe=n(),r(J.$$.fragment),Ce=n(),r(U.$$.fragment),ve=n(),r(h.$$.fragment),Ze=n(),j=o("p"),j.innerHTML=Rt,Be=n(),T=o("p"),T.innerHTML=Wt,Ge=n(),b=o("p"),b.innerHTML=Vt,ke=n(),I=o("p"),I.innerHTML=_t,Re=n(),g=o("p"),g.innerHTML=$t,We=n(),f=o("p"),f.textContent=Qt,Ve=n(),C=o("p"),C.textContent=At,_e=n(),r(v.$$.fragment),$e=n(),Z=o("p"),Z.textContent=Xt,Qe=n(),r(B.$$.fragment),Ae=n(),r(G.$$.fragment),Xe=n(),k=o("p"),k.textContent=Nt,Ne=n(),R=o("p"),R.textContent=St,Se=n(),W=o("ul"),W.innerHTML=Ht,He=n(),r(V.$$.fragment),xe=n(),_=o("pre"),_.textContent=xt,qe=n(),$=o("p"),$.innerHTML=qt,Ee=n(),r(Q.$$.fragment),Ye=n(),A=o("p"),A.innerHTML=Et,ze=n(),X=o("p"),X.textContent=Yt,Fe=n(),N=o("ul"),N.innerHTML=zt,Le=n(),S=o("p"),S.innerHTML=Ft,Pe=n(),H=o("p"),H.innerHTML=Lt,De=n(),r(x.$$.fragment),Ke=n(),q=o("p"),q.textContent=Pt,Oe=n(),r(E.$$.fragment),et=n(),Y=o("p"),Y.textContent=Dt,tt=n(),z=o("p"),z.textContent=Kt,lt=n(),F=o("p"),F.textContent=Ot,st=n(),r(L.$$.fragment),nt=n(),P=o("pre"),P.textContent=el,at=n(),D=o("p"),D.innerHTML=tl,ot=n(),K=o("p"),K.innerHTML=ll,it=n(),r(O.$$.fragment),Mt=n(),r(ee.$$.fragment),rt=n(),te=o("p"),te.innerHTML=sl,pt=n(),le=o("p"),le.innerHTML=nl,yt=n(),r(se.$$.fragment),ct=n(),r(ne.$$.fragment),ut=n(),r(ae.$$.fragment),wt=n(),oe=o("p"),oe.innerHTML=al,mt=n(),ie=o("p"),ie.textContent=ol,dt=n(),Me=o("p"),Me.innerHTML=il,Jt=n(),r(re.$$.fragment),Ut=n(),pe=o("p"),pe.textContent=Ml,ht=n(),r(ye.$$.fragment),jt=n(),ce=o("p"),ce.textContent=rl,Tt=n(),ue=o("p"),ue.textContent=pl,bt=n(),r(we.$$.fragment),It=n(),me=o("pre"),me.textContent=yl,gt=n(),r(de.$$.fragment),ft=n(),Je=o("p"),Je.textContent=cl,Ct=n(),Ue=o("p"),Ue.innerHTML=ul,vt=n(),he=o("p"),he.textContent=wl,Zt=n(),r(je.$$.fragment),Bt=n(),Ie=o("p"),this.h()},l(e){const t=bl("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),ge=a(e),be=i(e,"P",{}),ml(be).forEach(l),fe=a(e),p(J.$$.fragment,e),Ce=a(e),p(U.$$.fragment,e),ve=a(e),p(h.$$.fragment,e),Ze=a(e),j=i(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1xlqnsv"&&(j.innerHTML=Rt),Be=a(e),T=i(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-16ind9j"&&(T.innerHTML=Wt),Ge=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1mh34dv"&&(b.innerHTML=Vt),ke=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-mmy9qo"&&(I.innerHTML=_t),Re=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1u6j2au"&&(g.innerHTML=$t),We=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-fc6q9b"&&(f.textContent=Qt),Ve=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-16cuoal"&&(C.textContent=At),_e=a(e),p(v.$$.fragment,e),$e=a(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-64fox6"&&(Z.textContent=Xt),Qe=a(e),p(B.$$.fragment,e),Ae=a(e),p(G.$$.fragment,e),Xe=a(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1bnny6u"&&(k.textContent=Nt),Ne=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1yb5yrl"&&(R.textContent=St),Se=a(e),W=i(e,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-3qoj8n"&&(W.innerHTML=Ht),He=a(e),p(V.$$.fragment,e),xe=a(e),_=i(e,"PRE",{"data-svelte-h":!0}),M(_)!=="svelte-u5o6zi"&&(_.textContent=xt),qe=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1hg95q8"&&($.innerHTML=qt),Ee=a(e),p(Q.$$.fragment,e),Ye=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1wknlb6"&&(A.innerHTML=Et),ze=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-19h5931"&&(X.textContent=Yt),Fe=a(e),N=i(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-5uub6"&&(N.innerHTML=zt),Le=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1kfx2et"&&(S.innerHTML=Ft),Pe=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1qw64fs"&&(H.innerHTML=Lt),De=a(e),p(x.$$.fragment,e),Ke=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-jy4i2f"&&(q.textContent=Pt),Oe=a(e),p(E.$$.fragment,e),et=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-5pp8py"&&(Y.textContent=Dt),tt=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1cx88lu"&&(z.textContent=Kt),lt=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1vgfwws"&&(F.textContent=Ot),st=a(e),p(L.$$.fragment,e),nt=a(e),P=i(e,"PRE",{"data-svelte-h":!0}),M(P)!=="svelte-crsp42"&&(P.textContent=el),at=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1dsjmqj"&&(D.innerHTML=tl),ot=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-yb70ev"&&(K.innerHTML=ll),it=a(e),p(O.$$.fragment,e),Mt=a(e),p(ee.$$.fragment,e),rt=a(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-19hckuz"&&(te.innerHTML=sl),pt=a(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1wpkyax"&&(le.innerHTML=nl),yt=a(e),p(se.$$.fragment,e),ct=a(e),p(ne.$$.fragment,e),ut=a(e),p(ae.$$.fragment,e),wt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-6d9ubm"&&(oe.innerHTML=al),mt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-ud3g55"&&(ie.textContent=ol),dt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-3qqlok"&&(Me.innerHTML=il),Jt=a(e),p(re.$$.fragment,e),Ut=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1s1hpee"&&(pe.textContent=Ml),ht=a(e),p(ye.$$.fragment,e),jt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-168ebuv"&&(ce.textContent=rl),Tt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-vscncs"&&(ue.textContent=pl),bt=a(e),p(we.$$.fragment,e),It=a(e),me=i(e,"PRE",{"data-svelte-h":!0}),M(me)!=="svelte-1xg5a44"&&(me.textContent=yl),gt=a(e),p(de.$$.fragment,e),ft=a(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-hpfue3"&&(Je.textContent=cl),Ct=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1v6mkvd"&&(Ue.innerHTML=ul),vt=a(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1ctcozl"&&(he.textContent=wl),Zt=a(e),p(je.$$.fragment,e),Bt=a(e),Ie=i(e,"P",{}),ml(Ie).forEach(l),this.h()},h(){dl(d,"name","hf:doc:metadata"),dl(d,"content",Zl)},m(e,t){Il(document.head,d),s(e,ge,t),s(e,be,t),s(e,fe,t),y(J,e,t),s(e,Ce,t),y(U,e,t),s(e,ve,t),y(h,e,t),s(e,Ze,t),s(e,j,t),s(e,Be,t),s(e,T,t),s(e,Ge,t),s(e,b,t),s(e,ke,t),s(e,I,t),s(e,Re,t),s(e,g,t),s(e,We,t),s(e,f,t),s(e,Ve,t),s(e,C,t),s(e,_e,t),y(v,e,t),s(e,$e,t),s(e,Z,t),s(e,Qe,t),y(B,e,t),s(e,Ae,t),y(G,e,t),s(e,Xe,t),s(e,k,t),s(e,Ne,t),s(e,R,t),s(e,Se,t),s(e,W,t),s(e,He,t),y(V,e,t),s(e,xe,t),s(e,_,t),s(e,qe,t),s(e,$,t),s(e,Ee,t),y(Q,e,t),s(e,Ye,t),s(e,A,t),s(e,ze,t),s(e,X,t),s(e,Fe,t),s(e,N,t),s(e,Le,t),s(e,S,t),s(e,Pe,t),s(e,H,t),s(e,De,t),y(x,e,t),s(e,Ke,t),s(e,q,t),s(e,Oe,t),y(E,e,t),s(e,et,t),s(e,Y,t),s(e,tt,t),s(e,z,t),s(e,lt,t),s(e,F,t),s(e,st,t),y(L,e,t),s(e,nt,t),s(e,P,t),s(e,at,t),s(e,D,t),s(e,ot,t),s(e,K,t),s(e,it,t),y(O,e,t),s(e,Mt,t),y(ee,e,t),s(e,rt,t),s(e,te,t),s(e,pt,t),s(e,le,t),s(e,yt,t),y(se,e,t),s(e,ct,t),y(ne,e,t),s(e,ut,t),y(ae,e,t),s(e,wt,t),s(e,oe,t),s(e,mt,t),s(e,ie,t),s(e,dt,t),s(e,Me,t),s(e,Jt,t),y(re,e,t),s(e,Ut,t),s(e,pe,t),s(e,ht,t),y(ye,e,t),s(e,jt,t),s(e,ce,t),s(e,Tt,t),s(e,ue,t),s(e,bt,t),y(we,e,t),s(e,It,t),s(e,me,t),s(e,gt,t),y(de,e,t),s(e,ft,t),s(e,Je,t),s(e,Ct,t),s(e,Ue,t),s(e,vt,t),s(e,he,t),s(e,Zt,t),y(je,e,t),s(e,Bt,t),s(e,Ie,t),Gt=!0},p:Ul,i(e){Gt||(c(J.$$.fragment,e),c(U.$$.fragment,e),c(h.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(Q.$$.fragment,e),c(x.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(de.$$.fragment,e),c(je.$$.fragment,e),Gt=!0)},o(e){u(J.$$.fragment,e),u(U.$$.fragment,e),u(h.$$.fragment,e),u(v.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(x.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),Gt=!1},d(e){e&&(l(ge),l(be),l(fe),l(Ce),l(ve),l(Ze),l(j),l(Be),l(T),l(Ge),l(b),l(ke),l(I),l(Re),l(g),l(We),l(f),l(Ve),l(C),l(_e),l($e),l(Z),l(Qe),l(Ae),l(Xe),l(k),l(Ne),l(R),l(Se),l(W),l(He),l(xe),l(_),l(qe),l($),l(Ee),l(Ye),l(A),l(ze),l(X),l(Fe),l(N),l(Le),l(S),l(Pe),l(H),l(De),l(Ke),l(q),l(Oe),l(et),l(Y),l(tt),l(z),l(lt),l(F),l(st),l(nt),l(P),l(at),l(D),l(ot),l(K),l(it),l(Mt),l(rt),l(te),l(pt),l(le),l(yt),l(ct),l(ut),l(wt),l(oe),l(mt),l(ie),l(dt),l(Me),l(Jt),l(Ut),l(pe),l(ht),l(jt),l(ce),l(Tt),l(ue),l(bt),l(It),l(me),l(gt),l(ft),l(Je),l(Ct),l(Ue),l(vt),l(he),l(Zt),l(Bt),l(Ie)),l(d),w(J,e),w(U,e),w(h,e),w(v,e),w(B,e),w(G,e),w(V,e),w(Q,e),w(x,e),w(E,e),w(L,e),w(O,e),w(ee,e),w(se,e),w(ne,e),w(ae,e),w(re,e),w(ye,e),w(we,e),w(de,e),w(je,e)}}}const Zl='{"title":"Build an agent with tool-calling superpowers 🦸 using smolagents","local":"build-an-agent-with-tool-calling-superpowers--using-smolagents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function Bl(kt){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends jl{constructor(d){super(),Tl(this,d,Bl,vl,Jl,{})}}export{_l as component};
