import{s as tn,n as ln,o as nn}from"../chunks/scheduler.1f027d5a.js";import{S as an,i as sn,e as i,s as a,c as o,h as rn,a as r,d as l,b as s,f as en,g as h,j as p,k as ol,l as pn,m as n,n as m,t as c,o as d,p as y}from"../chunks/index.5cb6ce42.js";import{C as on}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as hn,C as u}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as M,E as mn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function cn(hl){let T,We,Se,He,g,_e,f,Qe,b,Le,J,ml='<em>Authored by: <a href="https://github.com/dcarpintero" rel="nofollow">Diego Carpintero</a></em>',Ze,U,cl="Knowledge Graphs provide a method for modeling and storing interlinked information in a format that is both human- and machine-understandable. These graphs consist of <em>nodes</em> and <em>edges</em>, representing entities and their relationships. Unlike traditional databases, the inherent expressiveness of graphs allows for richer semantic understanding, while providing the flexibility to accommodate new entity types and relationships without being constrained by a fixed schema.",Fe,j,dl="By combining knowledge graphs with embeddings (vector search), we can leverage <em>multi-hop connectivity</em> and <em>contextual understanding of information</em> to enhance reasoning and explainability in LLMs.",Xe,C,yl="This notebook explores the practical implementation of this approach, demonstrating how to:",Ye,v,ul='<li>Build a knowledge graph in <a href="https://neo4j.com/docs/" rel="nofollow">Neo4j</a> related to research publications using a synthetic dataset,</li> <li>Project a subset of our data fields into a high-dimensional vector space using an <a href="https://python.langchain.com/v0.2/docs/integrations/text_embedding/" rel="nofollow">embedding model</a>,</li> <li>Construct a vector index on those embeddings to enable similarity search, and</li> <li>Extract insights from our graph using natural language by easily converting user queries into <a href="https://neo4j.com/docs/cypher-manual/current/introduction/" rel="nofollow">cypher</a> statements with <a href="https://python.langchain.com/v0.2/docs/introduction/" rel="nofollow">LangChain</a>:</li>',Pe,w,Ml='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/knowledge-graphs.png"/>',ze,$,qe,E,De,I,Oe,x,Tl='We will create our Knowledge Graph using <a href="https://neo4j.com/docs/" rel="nofollow">Neo4j</a>, an open-source database management system that specializes in graph database technology.',Ke,R,wl='For a quick and easy setup, you can start a free instance on <a href="https://neo4j.com/product/auradb/" rel="nofollow">Neo4j Aura</a>.',et,B,gl="You might then set <code>NEO4J_URI</code>, <code>NEO4J_USERNAME</code>, and <code>NEO4J_PASSWORD</code> as environment variables using a <code>.env</code> file:",tt,k,lt,N,fl="Langchain provides the <code>Neo4jGraph</code> class to interact with Neo4j:",nt,G,at,A,st,S,bl='The below example creates a connection with our <code>Neo4j</code> database and populates it with <a href="https://github.com/dcarpintero/generative-ai-101/blob/main/dataset/synthetic_articles.csv" rel="nofollow">synthetic data</a> comprising research articles and their authors.',it,V,Jl="The entities are:",rt,W,Ul="<li><em>Researcher</em></li> <li><em>Article</em></li> <li><em>Topic</em></li>",pt,H,jl="Whereas the relationships are:",ot,_,Cl="<li><em>Researcher</em> —[PUBLISHED]—&gt; <em>Article</em></li> <li><em>Article</em> —[IN_TOPIC]—&gt; <em>Topic</em></li>",ht,Q,mt,L,vl="Let’s check that the nodes and relationships have been initialized correctly:",ct,Z,dt,F,$l=`Node properties:
Article &#123;title: STRING, abstract: STRING, publication_date: DATE, embedding: LIST}
Researcher &#123;name: STRING}
Topic &#123;name: STRING}
Relationship properties:

The relationships:
(:Article)-[:IN_TOPIC]->(:Topic)
(:Researcher)-[:PUBLISHED]->(:Article)
`,yt,X,El="Our knowledge graph can be inspected in the Neo4j workspace:",ut,Y,Il='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_00.png"/>',Mt,P,Tt,z,xl="Now we construct a vector index to efficiently search for relevant <em>articles</em> based on their <em>topic, title, and abstract</em>. This process involves calculating the embeddings for each article using these fields. At query time, the system finds the most similar articles to the user’s input by employing a similarity metric, such as cosine distance.",wt,q,gt,D,Rl='<strong>Note:</strong> To access OpenAI embedding models you will need to create an OpenAI account, get an API key, and set <code>OPENAI_API_KEY</code> as an environment variable. You might also find it useful to experiment with another <a href="https://python.langchain.com/v0.2/docs/integrations/text_embedding/" rel="nofollow">embedding model</a> integration.',ft,O,bt,K,Bl="<code>Langchain RetrievalQA</code> creates a question-answering (QA) chain using the above vector index as a retriever.",Jt,ee,Ut,te,kl="Let’s ask ’<em>which articles discuss how AI might affect our daily life?</em>‘:",jt,le,Ct,ne,Nl=`The articles that discuss how AI might affect our daily life are:

1. **The Impact of AI on Employment: A Comprehensive Study**
   *Abstract:* This study analyzes the potential effects of AI on various job sectors and suggests policy recommendations to mitigate negative impacts.

2. **The Societal Implications of Advanced AI: A Multidisciplinary Analysis**
   *Abstract:* Our study brings together experts from various fields to analyze the potential long-term impacts of advanced AI on society, economy, and culture.

These two articles would provide insights into how AI could potentially impact our daily lives from different perspectives.
`,vt,ae,$t,se,Gl="Knowledge graphs are excellent for making connections between entities, enabling the extraction of patterns and the discovery of new insights.",Et,ie,Al="This section demonstrates how to implement this process and integrate the results into an LLM pipeline using natural language queries.",It,re,xt,pe,Sl="To construct expressive and efficient queries <code>Neo4j</code> users <code>Cypher</code>, a declarative query language inspired by SQL. <code>LangChain</code> provides the wrapper <code>GraphCypherQAChain</code>, an abstraction layer that allows querying graph databases using natural language, making it easier to integrate graph-based data retrieval into LLM pipelines.",Rt,oe,Vl="In practice, <code>GraphCypherQAChain</code>:",Bt,he,Wl="<li>generates Cypher statements (queries for graph databases like Neo4j) from user input (natural language) applying in-context learning (prompt engineering),</li> <li>executes said statements against a graph database, and</li> <li>provides the results as context to ground the LLM responses on accurate, up-to-date information:</li>",kt,me,Hl="<strong>Note:</strong> This implementation involves executing model-generated graph queries, which carries inherent risks such as unintended access or modification of sensitive data in the database. To mitigate these risks, ensure that your database connection permissions are as restricted as possible to meet the specific needs of your chain/agent. While this approach reduces risk, it does not eliminate it entirely.",Nt,ce,Gt,de,At,ye,_l="Note in the following examples how the results from the cypher query execution are provided as context to the LLM:",St,ue,Vt,Me,Ql="In this example, our question ’<em>How many articles has published Emily Chen?</em>’ will be translated into the Cyper query:",Wt,Te,Ht,we,Ll=`which matches nodes labeled <code>Author</code> with the name ‘Emily Chen’ and traverses the <code>PUBLISHED</code> relationships to <code>Article</code> nodes.
It then counts the number of <code>Article</code> nodes connected to ‘Emily Chen’:`,_t,ge,Zl='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_01.png" width="40%"/>',Qt,fe,Lt,be,Fl=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r:Researcher &#123;name: "Emily Chen"})-[:PUBLISHED]->(a:Article)
RETURN COUNT(a) AS numberOfArticles
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'numberOfArticles': 7}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,Zt,Je,Ft,Ue,Xl="In this example, the query ’<em>are there any pair of researchers who have published more than three articles together?</em>’ results in the Cypher query:",Xt,je,Yt,Ce,Yl="which results in traversing from the <code>Researcher</code> nodes to the <code>PUBLISHED</code> relationship to find connected <code>Article</code> nodes, and then traversing back to find <code>Researchers</code> pairs.",Pt,ve,Pl='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_02.png"/>',zt,$e,qt,Ee,zl=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r1:Researcher)-[:PUBLISHED]->(a:Article)<-[:PUBLISHED]-(r2:Researcher)
WHERE r1 <> r2
WITH r1, r2, COUNT(a) AS sharedArticles
WHERE sharedArticles > 3
RETURN r1.name, r2.name, sharedArticles
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'r1.name': 'David Johnson', 'r2.name': 'Emily Chen', 'sharedArticles': 4}, &#123;'r1.name': 'Robert Taylor', 'r2.name': 'Emily Chen', 'sharedArticles': 4}, &#123;'r1.name': 'Emily Chen', 'r2.name': 'David Johnson', 'sharedArticles': 4}, &#123;'r1.name': 'Emily Chen', 'r2.name': 'Robert Taylor', 'sharedArticles': 4}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,Dt,Ie,Ot,xe,ql=`Let’s find out who is the researcher with most peers collaborations.
Our query ’<em>which researcher has collaborated with the most peers?</em>’ results now in the Cyper:`,Kt,Re,el,Be,Dl="Here, we need to start from all <code>Researcher</code> nodes and traverse their <code>PUBLISHED</code> relationships to find connected <code>Article</code> nodes. For each <code>Article</code> node, Neo4j then traverses back to find other <code>Researcher</code> nodes (peer) who have also published the same article.",tl,ke,Ol='<img src="https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/static/kg_sample_03.png"/>',ll,Ne,nl,Ge,Kl=`\x1B[1m> Entering new GraphCypherQAChain chain...\x1B[0m
Generated Cypher:
\x1B[32;1m\x1B[1;3mcypher
MATCH (r1:Researcher)-[:PUBLISHED]->(:Article)<-[:PUBLISHED]-(r2:Researcher)
WHERE r1 <> r2
WITH r1, COUNT(DISTINCT r2) AS collaborators
RETURN r1.name AS researcher, collaborators
ORDER BY collaborators DESC
LIMIT 1
\x1B[0m
Full Context:
\x1B[32;1m\x1B[1;3m[&#123;'researcher': 'David Johnson', 'collaborators': 6}]\x1B[0m

\x1B[1m> Finished chain.\x1B[0m
`,al,sl,il,Ae,rl,Ve,pl;return g=new hn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_knowledge_graphs_neo4j.ipynb"}]}}),f=new on({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new M({props:{title:"Enhancing RAG Reasoning with Knowledge Graphs",local:"enhancing-rag-reasoning-with-knowledge-graphs",headingTag:"h1"}}),$=new M({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),E=new u({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG5lbzRqJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluX29wZW5haSUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBweXRob24tZG90ZW52JTIwLS1xdWlldA==",highlighted:"%pip install neo4j langchain langchain_openai langchain-community python-dotenv --quiet",wrap:!1}}),I=new M({props:{title:"Set up a Neo4j instance",local:"set-up-a-neo4j-instance",headingTag:"h3"}}),k=new u({props:{code:"aW1wb3J0JTIwZG90ZW52JTBBZG90ZW52LmxvYWRfZG90ZW52KCcuZW52JyUyQyUyMG92ZXJyaWRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> dotenv
dotenv.load_dotenv(<span class="hljs-string">&#x27;.env&#x27;</span>, override=<span class="hljs-literal">True</span>)`,wrap:!1}}),G=new u({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5ncmFwaHMlMjBpbXBvcnQlMjBOZW80akdyYXBoJTBBJTBBZ3JhcGglMjAlM0QlMjBOZW80akdyYXBoKCUwQSUyMCUyMCUyMCUyMHVybCUzRG9zLmVudmlyb24lNUInTkVPNEpfVVJJJyU1RCUyQyUyMCUwQSUyMCUyMCUyMCUyMHVzZXJuYW1lJTNEb3MuZW52aXJvbiU1QidORU80Sl9VU0VSTkFNRSclNUQlMkMlMEElMjAlMjAlMjAlMjBwYXNzd29yZCUzRG9zLmVudmlyb24lNUInTkVPNEpfUEFTU1dPUkQnJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> langchain_community.graphs <span class="hljs-keyword">import</span> Neo4jGraph

graph = Neo4jGraph(
    url=os.environ[<span class="hljs-string">&#x27;NEO4J_URI&#x27;</span>], 
    username=os.environ[<span class="hljs-string">&#x27;NEO4J_USERNAME&#x27;</span>],
    password=os.environ[<span class="hljs-string">&#x27;NEO4J_PASSWORD&#x27;</span>],
)`,wrap:!1}}),A=new M({props:{title:"Loading Dataset into a Graph",local:"loading-dataset-into-a-graph",headingTag:"h3"}}),Q=new u({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZ3JhcGhzJTIwaW1wb3J0JTIwTmVvNGpHcmFwaCUwQSUwQWdyYXBoJTIwJTNEJTIwTmVvNGpHcmFwaCgpJTBBJTBBcV9sb2FkX2FydGljbGVzJTIwJTNEJTIwJTIyJTIyJTIyJTBBTE9BRCUyMENTViUyMFdJVEglMjBIRUFERVJTJTBBRlJPTSUyMCdodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZkY2FycGludGVybyUyRmdlbmVyYXRpdmUtYWktMTAxJTJGbWFpbiUyRmRhdGFzZXQlMkZzeW50aGV0aWNfYXJ0aWNsZXMuY3N2JyUyMCUwQUFTJTIwcm93JTIwJTBBRklFTERURVJNSU5BVE9SJTIwJyUzQiclMEFNRVJHRSUyMChhJTNBQXJ0aWNsZSUyMCU3QnRpdGxlJTNBcm93LlRpdGxlJTdEKSUwQVNFVCUyMGEuYWJzdHJhY3QlMjAlM0QlMjByb3cuQWJzdHJhY3QlMkMlMEElMjAlMjAlMjAlMjBhLnB1YmxpY2F0aW9uX2RhdGUlMjAlM0QlMjBkYXRlKHJvdy5QdWJsaWNhdGlvbl9EYXRlKSUwQUZPUkVBQ0glMjAocmVzZWFyY2hlciUyMGluJTIwc3BsaXQocm93LkF1dGhvcnMlMkMlMjAnJTJDJyklMjAlN0MlMjAlMEElMjAlMjAlMjAlMjBNRVJHRSUyMChwJTNBUmVzZWFyY2hlciUyMCU3Qm5hbWUlM0F0cmltKHJlc2VhcmNoZXIpJTdEKSUwQSUyMCUyMCUyMCUyME1FUkdFJTIwKHApLSU1QiUzQVBVQkxJU0hFRCU1RC0lM0UoYSkpJTBBRk9SRUFDSCUyMCh0b3BpYyUyMGluJTIwJTVCcm93LlRvcGljJTVEJTIwJTdDJTIwJTBBJTIwJTIwJTIwJTIwTUVSR0UlMjAodCUzQVRvcGljJTIwJTdCbmFtZSUzQXRyaW0odG9waWMpJTdEKSUwQSUyMCUyMCUyMCUyME1FUkdFJTIwKGEpLSU1QiUzQUlOX1RPUElDJTVELSUzRSh0KSklMEElMjIlMjIlMjIlMEElMEFncmFwaC5xdWVyeShxX2xvYWRfYXJ0aWNsZXMp",highlighted:`<span class="hljs-keyword">from</span> langchain_community.graphs <span class="hljs-keyword">import</span> Neo4jGraph

graph = Neo4jGraph()

q_load_articles = <span class="hljs-string">&quot;&quot;&quot;
LOAD CSV WITH HEADERS
FROM &#x27;https://raw.githubusercontent.com/dcarpintero/generative-ai-101/main/dataset/synthetic_articles.csv&#x27; 
AS row 
FIELDTERMINATOR &#x27;;&#x27;
MERGE (a:Article {title:row.Title})
SET a.abstract = row.Abstract,
    a.publication_date = date(row.Publication_Date)
FOREACH (researcher in split(row.Authors, &#x27;,&#x27;) | 
    MERGE (p:Researcher {name:trim(researcher)})
    MERGE (p)-[:PUBLISHED]-&gt;(a))
FOREACH (topic in [row.Topic] | 
    MERGE (t:Topic {name:trim(topic)})
    MERGE (a)-[:IN_TOPIC]-&gt;(t))
&quot;&quot;&quot;</span>

graph.query(q_load_articles)`,wrap:!1}}),Z=new u({props:{code:"Z3JhcGgucmVmcmVzaF9zY2hlbWEoKSUwQXByaW50KGdyYXBoLmdldF9zY2hlbWEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>graph.refresh_schema()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(graph.get_schema)`,wrap:!1}}),P=new M({props:{title:"Building a Vector Index",local:"building-a-vector-index",headingTag:"h3"}}),q=new u({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkudmVjdG9yc3RvcmVzJTIwaW1wb3J0JTIwTmVvNGpWZWN0b3IlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyME9wZW5BSUVtYmVkZGluZ3MlMEElMEF2ZWN0b3JfaW5kZXglMjAlM0QlMjBOZW80alZlY3Rvci5mcm9tX2V4aXN0aW5nX2dyYXBoKCUwQSUyMCUyMCUyMCUyME9wZW5BSUVtYmVkZGluZ3MoKSUyQyUwQSUyMCUyMCUyMCUyMHVybCUzRG9zLmVudmlyb24lNUInTkVPNEpfVVJJJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHVzZXJuYW1lJTNEb3MuZW52aXJvbiU1QidORU80Sl9VU0VSTkFNRSclNUQlMkMlMEElMjAlMjAlMjAlMjBwYXNzd29yZCUzRG9zLmVudmlyb24lNUInTkVPNEpfUEFTU1dPUkQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5kZXhfbmFtZSUzRCdhcnRpY2xlcyclMkMlMEElMjAlMjAlMjAlMjBub2RlX2xhYmVsJTNEJTIyQXJ0aWNsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfbm9kZV9wcm9wZXJ0aWVzJTNEJTVCJ3RvcGljJyUyQyUyMCd0aXRsZSclMkMlMjAnYWJzdHJhY3QnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX25vZGVfcHJvcGVydHklM0QnZW1iZWRkaW5nJyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Neo4jVector
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> OpenAIEmbeddings

vector_index = Neo4jVector.from_existing_graph(
    OpenAIEmbeddings(),
    url=os.environ[<span class="hljs-string">&#x27;NEO4J_URI&#x27;</span>],
    username=os.environ[<span class="hljs-string">&#x27;NEO4J_USERNAME&#x27;</span>],
    password=os.environ[<span class="hljs-string">&#x27;NEO4J_PASSWORD&#x27;</span>],
    index_name=<span class="hljs-string">&#x27;articles&#x27;</span>,
    node_label=<span class="hljs-string">&quot;Article&quot;</span>,
    text_node_properties=[<span class="hljs-string">&#x27;topic&#x27;</span>, <span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;abstract&#x27;</span>],
    embedding_node_property=<span class="hljs-string">&#x27;embedding&#x27;</span>,
)`,wrap:!1}}),O=new M({props:{title:"Q&A on Similarity",local:"qa-on-similarity",headingTag:"h2"}}),ee=new u({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBSZXRyaWV2YWxRQSUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQSUwQXZlY3Rvcl9xYSUyMCUzRCUyMFJldHJpZXZhbFFBLmZyb21fY2hhaW5fdHlwZSglMEElMjAlMjAlMjAlMjBsbG0lM0RDaGF0T3BlbkFJKCklMkMlMEElMjAlMjAlMjAlMjBjaGFpbl90eXBlJTNEJTIyc3R1ZmYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0R2ZWN0b3JfaW5kZXguYXNfcmV0cmlldmVyKCklMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> RetrievalQA
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

vector_qa = RetrievalQA.from_chain_type(
    llm=ChatOpenAI(),
    chain_type=<span class="hljs-string">&quot;stuff&quot;</span>,
    retriever=vector_index.as_retriever()
)`,wrap:!1}}),le=new u({props:{code:"ciUyMCUzRCUyMHZlY3Rvcl9xYS5pbnZva2UoJTBBJTIwJTIwJTIwJTIwJTdCJTIycXVlcnklMjIlM0ElMjAlMjJ3aGljaCUyMGFydGljbGVzJTIwZGlzY3VzcyUyMGhvdyUyMEFJJTIwbWlnaHQlMjBhZmZlY3QlMjBvdXIlMjBkYWlseSUyMGxpZmUlM0YlMjBpbmNsdWRlJTIwdGhlJTIwYXJ0aWNsZSUyMHRpdGxlcyUyMGFuZCUyMGFic3RyYWN0cy4lMjIlN0QlMEEpJTBBcHJpbnQociU1QidyZXN1bHQnJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>r = vector_qa.invoke(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;which articles discuss how AI might affect our daily life? include the article titles and abstracts.&quot;</span>}
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(r[<span class="hljs-string">&#x27;result&#x27;</span>])`,wrap:!1}}),ae=new M({props:{title:"Traversing Knowledge Graphs for Inference",local:"traversing-knowledge-graphs-for-inference",headingTag:"h2"}}),re=new M({props:{title:"Graph-Cypher-Chain w/ LangChain",local:"graph-cypher-chain-w-langchain",headingTag:"h3"}}),ce=new u({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBHcmFwaEN5cGhlclFBQ2hhaW4lMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEElMEFncmFwaC5yZWZyZXNoX3NjaGVtYSgpJTBBJTBBY3lwaGVyX2NoYWluJTIwJTNEJTIwR3JhcGhDeXBoZXJRQUNoYWluLmZyb21fbGxtKCUwQSUyMCUyMCUyMCUyMGN5cGhlcl9sbG0lMjAlM0QlMjBDaGF0T3BlbkFJKHRlbXBlcmF0dXJlJTNEMCUyQyUyMG1vZGVsX25hbWUlM0QnZ3B0LTRvJyklMkMlMEElMjAlMjAlMjAlMjBxYV9sbG0lMjAlM0QlMjBDaGF0T3BlbkFJKHRlbXBlcmF0dXJlJTNEMCUyQyUyMG1vZGVsX25hbWUlM0QnZ3B0LTRvJyklMkMlMjAlMEElMjAlMjAlMjAlMjBncmFwaCUzRGdyYXBoJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zZSUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> GraphCypherQAChain
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

graph.refresh_schema()

cypher_chain = GraphCypherQAChain.from_llm(
    cypher_llm = ChatOpenAI(temperature=<span class="hljs-number">0</span>, model_name=<span class="hljs-string">&#x27;gpt-4o&#x27;</span>),
    qa_llm = ChatOpenAI(temperature=<span class="hljs-number">0</span>, model_name=<span class="hljs-string">&#x27;gpt-4o&#x27;</span>), 
    graph=graph,
    verbose=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),de=new M({props:{title:"Query Samples using Natural Language",local:"query-samples-using-natural-language",headingTag:"h3"}}),ue=new M({props:{title:"” How many articles has published Emily Chen? ”",local:"-how-many-articles-has-published-emily-chen-",headingTag:"h4"}}),Te=new u({props:{code:"TUFUQ0glMjAociUzQVJlc2VhcmNoZXIlMjAlN0JuYW1lJTNBJTIwJTIyRW1pbHklMjBDaGVuJTIyJTdEKS0lNUIlM0FQVUJMSVNIRUQlNUQtJTNFKGElM0FBcnRpY2xlKSUwQVJFVFVSTiUyMENPVU5UKGEpJTIwQVMlMjBudW1iZXJPZkFydGljbGVz",highlighted:`MATCH (r:Researcher {name: <span class="hljs-string">&quot;Emily Chen&quot;</span>})-<span class="hljs-selector-attr">[:PUBLISHED]</span>-&gt;(<span class="hljs-selector-tag">a</span>:Article)
RETURN <span class="hljs-built_in">COUNT</span>(a) AS numberOfArticles`,wrap:!1}}),fe=new u({props:{code:"JTIzJTIwdGhlJTIwYW5zd2VyJTIwc2hvdWxkJTIwYmUlMjAnNyclMEFjeXBoZXJfY2hhaW4uaW52b2tlKCUwQSUyMCUyMCUyMCUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGFydGljbGVzJTIwaGFzJTIwcHVibGlzaGVkJTIwRW1pbHklMjBDaGVuJTNGJTIyJTdEJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the answer should be &#x27;7&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;How many articles has published Emily Chen?&quot;</span>}
<span class="hljs-meta">... </span>)`,wrap:!1}}),Je=new M({props:{title:"” Are there any pair of researchers who have published more than three articles together? ”",local:"-are-there-any-pair-of-researchers-who-have-published-more-than-three-articles-together-",headingTag:"h4"}}),je=new u({props:{code:"TUFUQ0glMjAocjElM0FSZXNlYXJjaGVyKS0lNUIlM0FQVUJMSVNIRUQlNUQtJTNFKGElM0FBcnRpY2xlKSUzQy0lNUIlM0FQVUJMSVNIRUQlNUQtKHIyJTNBUmVzZWFyY2hlciklMEFXSEVSRSUyMHIxJTIwJTNDJTNFJTIwcjIlMEFXSVRIJTIwcjElMkMlMjByMiUyQyUyMENPVU5UKGEpJTIwQVMlMjBzaGFyZWRBcnRpY2xlcyUwQVdIRVJFJTIwc2hhcmVkQXJ0aWNsZXMlMjAlM0UlMjAzJTBBUkVUVVJOJTIwcjEubmFtZSUyQyUyMHIyLm5hbWUlMkMlMjBzaGFyZWRBcnRpY2xlcw==",highlighted:`<span class="hljs-symbol">MATCH</span> (<span class="hljs-built_in">r1</span>:Researcher)-[:PUBLISHED]-&gt;(a:Article)&lt;-[:PUBLISHED]-(<span class="hljs-built_in">r2</span>:Researcher)
<span class="hljs-symbol">WHERE</span> <span class="hljs-built_in">r1</span> &lt;&gt; <span class="hljs-built_in">r2</span>
<span class="hljs-symbol">WITH</span> <span class="hljs-built_in">r1</span>, <span class="hljs-built_in">r2</span>, COUNT(a) AS sharedArticles
<span class="hljs-symbol">WHERE</span> sharedArticles &gt; <span class="hljs-number">3</span>
<span class="hljs-symbol">RETURN</span> <span class="hljs-built_in">r1</span>.name, <span class="hljs-built_in">r2</span>.name, sharedArticles`,wrap:!1}}),$e=new u({props:{code:"JTIzJTIwdGhlJTIwYW5zd2VyJTIwc2hvdWxkJTIwYmUlMjBEYXZpZCUyMEpvaG5zb24lMjAlMjYlMjBFbWlseSUyMENoZW4lMkMlMjBSb2JlcnQlMjBUYXlsb3IlMjAlMjYlMjBFbWlseSUyMENoZW4lMEFjeXBoZXJfY2hhaW4uaW52b2tlKCUwQSUyMCUyMCUyMCUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTIyYXJlJTIwdGhlcmUlMjBhbnklMjBwYWlyJTIwb2YlMjByZXNlYXJjaGVycyUyMHdobyUyMGhhdmUlMjBwdWJsaXNoZWQlMjBtb3JlJTIwdGhhbiUyMHRocmVlJTIwYXJ0aWNsZXMlMjB0b2dldGhlciUzRiUyMiU3RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the answer should be David Johnson &amp; Emily Chen, Robert Taylor &amp; Emily Chen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;are there any pair of researchers who have published more than three articles together?&quot;</span>}
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ie=new M({props:{title:"” which researcher has collaborated with the most peers? ”",local:"-which-researcher-has-collaborated-with-the-most-peers-",headingTag:"h4"}}),Re=new u({props:{code:"TUFUQ0glMjAociUzQVJlc2VhcmNoZXIpLSU1QiUzQVBVQkxJU0hFRCU1RC0lM0UoJTNBQXJ0aWNsZSklM0MtJTVCJTNBUFVCTElTSEVEJTVELShwZWVyJTNBUmVzZWFyY2hlciklMEFXSVRIJTIwciUyQyUyMENPVU5UKERJU1RJTkNUJTIwcGVlciklMjBBUyUyMHBlZXJDb3VudCUwQVJFVFVSTiUyMHIubmFtZSUyMEFTJTIwcmVzZWFyY2hlciUyQyUyMHBlZXJDb3VudCUwQU9SREVSJTIwQlklMjBwZWVyQ291bnQlMjBERVNDJTBBTElNSVQlMjAx",highlighted:`MATCH (r:Researcher)-[:PUBLISHED]-&gt;(:Article)&lt;-[:PUBLISHED]-(peer:Researcher)
<span class="hljs-keyword">WITH</span> r, COUNT(<span class="hljs-keyword">DISTINCT</span> peer) <span class="hljs-keyword">AS</span> peerCount
<span class="hljs-keyword">RETURN</span> r.name <span class="hljs-keyword">AS</span> researcher, peerCount
<span class="hljs-keyword">ORDER</span> <span class="hljs-keyword">BY</span> peerCount <span class="hljs-keyword">DESC</span>
<span class="hljs-keyword">LIMIT</span> <span class="hljs-number">1</span>`,wrap:!1}}),Ne=new u({props:{code:"JTIzJTIwdGhlJTIwYW5zd2VyJTIwc2hvdWxkJTIwYmUlMjAnRGF2aWQlMjBKb2huc29uJyUwQWN5cGhlcl9jaGFpbi5pbnZva2UoJTBBJTIwJTIwJTIwJTIwJTdCJTIycXVlcnklMjIlM0ElMjAlMjJXaGljaCUyMHJlc2VhcmNoZXIlMjBoYXMlMjBjb2xsYWJvcmF0ZWQlMjB3aXRoJTIwdGhlJTIwbW9zdCUyMHBlZXJzJTNGJTIyJTdEJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the answer should be &#x27;David Johnson&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cypher_chain.invoke(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;Which researcher has collaborated with the most peers?&quot;</span>}
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ae=new mn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_knowledge_graphs_neo4j.md"}}),{c(){T=i("meta"),We=a(),Se=i("p"),He=a(),o(g.$$.fragment),_e=a(),o(f.$$.fragment),Qe=a(),o(b.$$.fragment),Le=a(),J=i("p"),J.innerHTML=ml,Ze=a(),U=i("p"),U.innerHTML=cl,Fe=a(),j=i("p"),j.innerHTML=dl,Xe=a(),C=i("p"),C.textContent=yl,Ye=a(),v=i("ul"),v.innerHTML=ul,Pe=a(),w=i("p"),w.innerHTML=Ml,ze=a(),o($.$$.fragment),qe=a(),o(E.$$.fragment),De=a(),o(I.$$.fragment),Oe=a(),x=i("p"),x.innerHTML=Tl,Ke=a(),R=i("p"),R.innerHTML=wl,et=a(),B=i("p"),B.innerHTML=gl,tt=a(),o(k.$$.fragment),lt=a(),N=i("p"),N.innerHTML=fl,nt=a(),o(G.$$.fragment),at=a(),o(A.$$.fragment),st=a(),S=i("p"),S.innerHTML=bl,it=a(),V=i("p"),V.textContent=Jl,rt=a(),W=i("ul"),W.innerHTML=Ul,pt=a(),H=i("p"),H.textContent=jl,ot=a(),_=i("ul"),_.innerHTML=Cl,ht=a(),o(Q.$$.fragment),mt=a(),L=i("p"),L.textContent=vl,ct=a(),o(Z.$$.fragment),dt=a(),F=i("pre"),F.textContent=$l,yt=a(),X=i("p"),X.textContent=El,ut=a(),Y=i("p"),Y.innerHTML=Il,Mt=a(),o(P.$$.fragment),Tt=a(),z=i("p"),z.innerHTML=xl,wt=a(),o(q.$$.fragment),gt=a(),D=i("p"),D.innerHTML=Rl,ft=a(),o(O.$$.fragment),bt=a(),K=i("p"),K.innerHTML=Bl,Jt=a(),o(ee.$$.fragment),Ut=a(),te=i("p"),te.innerHTML=kl,jt=a(),o(le.$$.fragment),Ct=a(),ne=i("pre"),ne.textContent=Nl,vt=a(),o(ae.$$.fragment),$t=a(),se=i("p"),se.textContent=Gl,Et=a(),ie=i("p"),ie.textContent=Al,It=a(),o(re.$$.fragment),xt=a(),pe=i("p"),pe.innerHTML=Sl,Rt=a(),oe=i("p"),oe.innerHTML=Vl,Bt=a(),he=i("ul"),he.innerHTML=Wl,kt=a(),me=i("p"),me.innerHTML=Hl,Nt=a(),o(ce.$$.fragment),Gt=a(),o(de.$$.fragment),At=a(),ye=i("p"),ye.textContent=_l,St=a(),o(ue.$$.fragment),Vt=a(),Me=i("p"),Me.innerHTML=Ql,Wt=a(),o(Te.$$.fragment),Ht=a(),we=i("p"),we.innerHTML=Ll,_t=a(),ge=i("p"),ge.innerHTML=Zl,Qt=a(),o(fe.$$.fragment),Lt=a(),be=i("pre"),be.textContent=Fl,Zt=a(),o(Je.$$.fragment),Ft=a(),Ue=i("p"),Ue.innerHTML=Xl,Xt=a(),o(je.$$.fragment),Yt=a(),Ce=i("p"),Ce.innerHTML=Yl,Pt=a(),ve=i("p"),ve.innerHTML=Pl,zt=a(),o($e.$$.fragment),qt=a(),Ee=i("pre"),Ee.textContent=zl,Dt=a(),o(Ie.$$.fragment),Ot=a(),xe=i("p"),xe.innerHTML=ql,Kt=a(),o(Re.$$.fragment),el=a(),Be=i("p"),Be.innerHTML=Dl,tl=a(),ke=i("p"),ke.innerHTML=Ol,ll=a(),o(Ne.$$.fragment),nl=a(),Ge=i("pre"),Ge.textContent=Kl,al=a(),sl=i("hr"),il=a(),o(Ae.$$.fragment),rl=a(),Ve=i("p"),this.h()},l(e){const t=rn("svelte-u9bgzb",document.head);T=r(t,"META",{name:!0,content:!0}),t.forEach(l),We=s(e),Se=r(e,"P",{}),en(Se).forEach(l),He=s(e),h(g.$$.fragment,e),_e=s(e),h(f.$$.fragment,e),Qe=s(e),h(b.$$.fragment,e),Le=s(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-mvdklb"&&(J.innerHTML=ml),Ze=s(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-52elw8"&&(U.innerHTML=cl),Fe=s(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1g5432g"&&(j.innerHTML=dl),Xe=s(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-6rsqn2"&&(C.textContent=yl),Ye=s(e),v=r(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-sdyeqq"&&(v.innerHTML=ul),Pe=s(e),w=r(e,"P",{align:!0,"data-svelte-h":!0}),p(w)!=="svelte-xuaq4q"&&(w.innerHTML=Ml),ze=s(e),h($.$$.fragment,e),qe=s(e),h(E.$$.fragment,e),De=s(e),h(I.$$.fragment,e),Oe=s(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-18ea503"&&(x.innerHTML=Tl),Ke=s(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1nrats8"&&(R.innerHTML=wl),et=s(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-7n6nf8"&&(B.innerHTML=gl),tt=s(e),h(k.$$.fragment,e),lt=s(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1wv0i54"&&(N.innerHTML=fl),nt=s(e),h(G.$$.fragment,e),at=s(e),h(A.$$.fragment,e),st=s(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-39i9km"&&(S.innerHTML=bl),it=s(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1qnoqa2"&&(V.textContent=Jl),rt=s(e),W=r(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-1hn6thf"&&(W.innerHTML=Ul),pt=s(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ocw9sv"&&(H.textContent=jl),ot=s(e),_=r(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-17z0hxs"&&(_.innerHTML=Cl),ht=s(e),h(Q.$$.fragment,e),mt=s(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1n7uomx"&&(L.textContent=vl),ct=s(e),h(Z.$$.fragment,e),dt=s(e),F=r(e,"PRE",{"data-svelte-h":!0}),p(F)!=="svelte-rbst4l"&&(F.textContent=$l),yt=s(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-ftglnj"&&(X.textContent=El),ut=s(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-s0xiop"&&(Y.innerHTML=Il),Mt=s(e),h(P.$$.fragment,e),Tt=s(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1meq4zf"&&(z.innerHTML=xl),wt=s(e),h(q.$$.fragment,e),gt=s(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1uxbfv4"&&(D.innerHTML=Rl),ft=s(e),h(O.$$.fragment,e),bt=s(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-u0l32z"&&(K.innerHTML=Bl),Jt=s(e),h(ee.$$.fragment,e),Ut=s(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1t06psu"&&(te.innerHTML=kl),jt=s(e),h(le.$$.fragment,e),Ct=s(e),ne=r(e,"PRE",{"data-svelte-h":!0}),p(ne)!=="svelte-10f2otb"&&(ne.textContent=Nl),vt=s(e),h(ae.$$.fragment,e),$t=s(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1ryalx9"&&(se.textContent=Gl),Et=s(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-621mt"&&(ie.textContent=Al),It=s(e),h(re.$$.fragment,e),xt=s(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-t5mf75"&&(pe.innerHTML=Sl),Rt=s(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-u7o0ij"&&(oe.innerHTML=Vl),Bt=s(e),he=r(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-slh7db"&&(he.innerHTML=Wl),kt=s(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-176eme2"&&(me.innerHTML=Hl),Nt=s(e),h(ce.$$.fragment,e),Gt=s(e),h(de.$$.fragment,e),At=s(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-v5ffe8"&&(ye.textContent=_l),St=s(e),h(ue.$$.fragment,e),Vt=s(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1yfazxa"&&(Me.innerHTML=Ql),Wt=s(e),h(Te.$$.fragment,e),Ht=s(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1plev05"&&(we.innerHTML=Ll),_t=s(e),ge=r(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1y4zmei"&&(ge.innerHTML=Zl),Qt=s(e),h(fe.$$.fragment,e),Lt=s(e),be=r(e,"PRE",{"data-svelte-h":!0}),p(be)!=="svelte-1i2j01w"&&(be.textContent=Fl),Zt=s(e),h(Je.$$.fragment,e),Ft=s(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-10xfisa"&&(Ue.innerHTML=Xl),Xt=s(e),h(je.$$.fragment,e),Yt=s(e),Ce=r(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-q3bs1d"&&(Ce.innerHTML=Yl),Pt=s(e),ve=r(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1yvj1cf"&&(ve.innerHTML=Pl),zt=s(e),h($e.$$.fragment,e),qt=s(e),Ee=r(e,"PRE",{"data-svelte-h":!0}),p(Ee)!=="svelte-1mq04bw"&&(Ee.textContent=zl),Dt=s(e),h(Ie.$$.fragment,e),Ot=s(e),xe=r(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-40ghdk"&&(xe.innerHTML=ql),Kt=s(e),h(Re.$$.fragment,e),el=s(e),Be=r(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1tiwi45"&&(Be.innerHTML=Dl),tl=s(e),ke=r(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-18615mk"&&(ke.innerHTML=Ol),ll=s(e),h(Ne.$$.fragment,e),nl=s(e),Ge=r(e,"PRE",{"data-svelte-h":!0}),p(Ge)!=="svelte-bo2yaw"&&(Ge.textContent=Kl),al=s(e),sl=r(e,"HR",{}),il=s(e),h(Ae.$$.fragment,e),rl=s(e),Ve=r(e,"P",{}),en(Ve).forEach(l),this.h()},h(){ol(T,"name","hf:doc:metadata"),ol(T,"content",dn),ol(w,"align","center")},m(e,t){pn(document.head,T),n(e,We,t),n(e,Se,t),n(e,He,t),m(g,e,t),n(e,_e,t),m(f,e,t),n(e,Qe,t),m(b,e,t),n(e,Le,t),n(e,J,t),n(e,Ze,t),n(e,U,t),n(e,Fe,t),n(e,j,t),n(e,Xe,t),n(e,C,t),n(e,Ye,t),n(e,v,t),n(e,Pe,t),n(e,w,t),n(e,ze,t),m($,e,t),n(e,qe,t),m(E,e,t),n(e,De,t),m(I,e,t),n(e,Oe,t),n(e,x,t),n(e,Ke,t),n(e,R,t),n(e,et,t),n(e,B,t),n(e,tt,t),m(k,e,t),n(e,lt,t),n(e,N,t),n(e,nt,t),m(G,e,t),n(e,at,t),m(A,e,t),n(e,st,t),n(e,S,t),n(e,it,t),n(e,V,t),n(e,rt,t),n(e,W,t),n(e,pt,t),n(e,H,t),n(e,ot,t),n(e,_,t),n(e,ht,t),m(Q,e,t),n(e,mt,t),n(e,L,t),n(e,ct,t),m(Z,e,t),n(e,dt,t),n(e,F,t),n(e,yt,t),n(e,X,t),n(e,ut,t),n(e,Y,t),n(e,Mt,t),m(P,e,t),n(e,Tt,t),n(e,z,t),n(e,wt,t),m(q,e,t),n(e,gt,t),n(e,D,t),n(e,ft,t),m(O,e,t),n(e,bt,t),n(e,K,t),n(e,Jt,t),m(ee,e,t),n(e,Ut,t),n(e,te,t),n(e,jt,t),m(le,e,t),n(e,Ct,t),n(e,ne,t),n(e,vt,t),m(ae,e,t),n(e,$t,t),n(e,se,t),n(e,Et,t),n(e,ie,t),n(e,It,t),m(re,e,t),n(e,xt,t),n(e,pe,t),n(e,Rt,t),n(e,oe,t),n(e,Bt,t),n(e,he,t),n(e,kt,t),n(e,me,t),n(e,Nt,t),m(ce,e,t),n(e,Gt,t),m(de,e,t),n(e,At,t),n(e,ye,t),n(e,St,t),m(ue,e,t),n(e,Vt,t),n(e,Me,t),n(e,Wt,t),m(Te,e,t),n(e,Ht,t),n(e,we,t),n(e,_t,t),n(e,ge,t),n(e,Qt,t),m(fe,e,t),n(e,Lt,t),n(e,be,t),n(e,Zt,t),m(Je,e,t),n(e,Ft,t),n(e,Ue,t),n(e,Xt,t),m(je,e,t),n(e,Yt,t),n(e,Ce,t),n(e,Pt,t),n(e,ve,t),n(e,zt,t),m($e,e,t),n(e,qt,t),n(e,Ee,t),n(e,Dt,t),m(Ie,e,t),n(e,Ot,t),n(e,xe,t),n(e,Kt,t),m(Re,e,t),n(e,el,t),n(e,Be,t),n(e,tl,t),n(e,ke,t),n(e,ll,t),m(Ne,e,t),n(e,nl,t),n(e,Ge,t),n(e,al,t),n(e,sl,t),n(e,il,t),m(Ae,e,t),n(e,rl,t),n(e,Ve,t),pl=!0},p:ln,i(e){pl||(c(g.$$.fragment,e),c(f.$$.fragment,e),c(b.$$.fragment,e),c($.$$.fragment,e),c(E.$$.fragment,e),c(I.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(A.$$.fragment,e),c(Q.$$.fragment,e),c(Z.$$.fragment,e),c(P.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(Te.$$.fragment,e),c(fe.$$.fragment,e),c(Je.$$.fragment,e),c(je.$$.fragment,e),c($e.$$.fragment,e),c(Ie.$$.fragment,e),c(Re.$$.fragment,e),c(Ne.$$.fragment,e),c(Ae.$$.fragment,e),pl=!0)},o(e){d(g.$$.fragment,e),d(f.$$.fragment,e),d(b.$$.fragment,e),d($.$$.fragment,e),d(E.$$.fragment,e),d(I.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(A.$$.fragment,e),d(Q.$$.fragment,e),d(Z.$$.fragment,e),d(P.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d($e.$$.fragment,e),d(Ie.$$.fragment,e),d(Re.$$.fragment,e),d(Ne.$$.fragment,e),d(Ae.$$.fragment,e),pl=!1},d(e){e&&(l(We),l(Se),l(He),l(_e),l(Qe),l(Le),l(J),l(Ze),l(U),l(Fe),l(j),l(Xe),l(C),l(Ye),l(v),l(Pe),l(w),l(ze),l(qe),l(De),l(Oe),l(x),l(Ke),l(R),l(et),l(B),l(tt),l(lt),l(N),l(nt),l(at),l(st),l(S),l(it),l(V),l(rt),l(W),l(pt),l(H),l(ot),l(_),l(ht),l(mt),l(L),l(ct),l(dt),l(F),l(yt),l(X),l(ut),l(Y),l(Mt),l(Tt),l(z),l(wt),l(gt),l(D),l(ft),l(bt),l(K),l(Jt),l(Ut),l(te),l(jt),l(Ct),l(ne),l(vt),l($t),l(se),l(Et),l(ie),l(It),l(xt),l(pe),l(Rt),l(oe),l(Bt),l(he),l(kt),l(me),l(Nt),l(Gt),l(At),l(ye),l(St),l(Vt),l(Me),l(Wt),l(Ht),l(we),l(_t),l(ge),l(Qt),l(Lt),l(be),l(Zt),l(Ft),l(Ue),l(Xt),l(Yt),l(Ce),l(Pt),l(ve),l(zt),l(qt),l(Ee),l(Dt),l(Ot),l(xe),l(Kt),l(el),l(Be),l(tl),l(ke),l(ll),l(nl),l(Ge),l(al),l(sl),l(il),l(rl),l(Ve)),l(T),y(g,e),y(f,e),y(b,e),y($,e),y(E,e),y(I,e),y(k,e),y(G,e),y(A,e),y(Q,e),y(Z,e),y(P,e),y(q,e),y(O,e),y(ee,e),y(le,e),y(ae,e),y(re,e),y(ce,e),y(de,e),y(ue,e),y(Te,e),y(fe,e),y(Je,e),y(je,e),y($e,e),y(Ie,e),y(Re,e),y(Ne,e),y(Ae,e)}}}const dn='{"title":"Enhancing RAG Reasoning with Knowledge Graphs","local":"enhancing-rag-reasoning-with-knowledge-graphs","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"Set up a Neo4j instance","local":"set-up-a-neo4j-instance","sections":[],"depth":3},{"title":"Loading Dataset into a Graph","local":"loading-dataset-into-a-graph","sections":[],"depth":3},{"title":"Building a Vector Index","local":"building-a-vector-index","sections":[],"depth":3}],"depth":2},{"title":"Q&A on Similarity","local":"qa-on-similarity","sections":[],"depth":2},{"title":"Traversing Knowledge Graphs for Inference","local":"traversing-knowledge-graphs-for-inference","sections":[{"title":"Graph-Cypher-Chain w/ LangChain","local":"graph-cypher-chain-w-langchain","sections":[],"depth":3},{"title":"Query Samples using Natural Language","local":"query-samples-using-natural-language","sections":[{"title":"” How many articles has published Emily Chen? ”","local":"-how-many-articles-has-published-emily-chen-","sections":[],"depth":4},{"title":"” Are there any pair of researchers who have published more than three articles together? ”","local":"-are-there-any-pair-of-researchers-who-have-published-more-than-three-articles-together-","sections":[],"depth":4},{"title":"” which researcher has collaborated with the most peers? ”","local":"-which-researcher-has-collaborated-with-the-most-peers-","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function yn(hl){return nn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fn extends an{constructor(T){super(),sn(this,T,yn,cn,tn,{})}}export{fn as component};
