import{s as Vs,n as $s,o as Rs}from"../chunks/scheduler.1f027d5a.js";import{S as ks,i as Bs,e as i,s as a,c as M,h as Ns,a as r,d as l,b as n,f as gs,g as p,j as w,k as Fl,l as _s,m as s,n as o,t as y,o as U,p as m}from"../chunks/index.5cb6ce42.js";import{C as Es}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Fs,C as J}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as T,E as Gs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Zs(Gl){let u,Oe,De,et,b,tt,d,lt,j,st,h,Zl='<em>Authored by: <a href="https://github.com/scott-martens" rel="nofollow">Scott Martens</a> @ <a href="https://jina.ai" rel="nofollow">Jina AI</a></em>',at,f,xl="This notebook will show you how to make a simple Retrieval Augmented Generation (RAG) system that draws on an SQL database instead of drawing information from a document store.",nt,I,it,C,Al='<li>Given an SQL database, we extract SQL table definitions (the <code>CREATE</code> line in an SQL dump) and store them. In this tutorial, we’ve done this part for you and the definitions are stored in memory as a list. Scaling up from this example might require more sophisticated storage.</li> <li>The user enters a query in natural language.</li> <li><a href="https://jina.ai/reranker/" rel="nofollow">Jina Reranker v2</a> (<a href="https://huggingface.co/jinaai/jina-reranker-v2-base-multilingual" rel="nofollow"><code>jinaai/jina-reranker-v2-base-multilingual</code></a>), an SQL-aware reranking model from <a href="https://jina.ai" rel="nofollow">Jina AI</a>, sorts the table definitions in order of their relevance to the user’s query.</li> <li>We present <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.1" rel="nofollow">Mistral 7B Instruct v0.1 (<code>mistralai/Mistral-7B-Instruct-v0.1</code>)</a> with a prompt containing the user’s query and the top three table definitions, with a request to write an SQL query to fit the task.</li> <li>Mistral Instruct generates an SQL query and we run it against the database, retrieving a result.</li> <li>The SQL query result is converted to JSON and presented to Mistral Instruct in a new prompt, along with the user’s original query, the SQL query, and a request to compose an answer for the user in natural language.</li> <li>Mistral Instruct’s natural language text response is returned to the user.</li>',rt,g,Mt,V,Sl='For this tutorial, we are using a small open-access database of video game sales records <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">stored on GitHub</a>. We will be using the <a href="https://www.sqlite.org/index.html" rel="nofollow">SQLite</a> version because SQLite is very compact, cross-platform, and has built-in Python support.',pt,$,ot,R,Ql="We will be running the Jina Reranker v2 model locally. If you are using Google Colab to run this notebook, make sure you are using a runtime that has access to a GPU. If you are running it locally, you will need Python 3 (this tutorial was authored using a Python 3.11 installation) and it will run <em>much</em> faster with a CUDA-enabled GPU.",yt,k,vl='We will also use the open-source <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex RAG framework</a> extensively in this tutorial, and the <a href="https://huggingface.co/inference-api/serverless" rel="nofollow">Hugging Face Inference API</a> to access Mistral 7B Instruct v0.1. You will need a <a href="https://huggingface.co/login" rel="nofollow">Hugging Face account</a> and an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a> with at least <code>READ</code> access.',Ut,c,Wl='<p>If you are using Google Colab, SQLite is already installed. It may not be installed on your local computer.  If it’s not installed, follow the instructions on the <a href="https://www.sqlite.org/download.html" rel="nofollow">SQLite website</a> to install it. The Python interface code is built into Python and you don’t need to install any Python modules for it.</p>',mt,B,wt,N,Jt,_,Xl="First, install the required Python modules:",Tt,E,ut,F,ct,G,ql='Next, download the SQLite database <code>videogames.db</code> from <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub</a> to the local filespace If <code>wget</code> is not available on your system, download the database from <a href="https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db" rel="nofollow">this link</a> and put it in the same directory where you’re running this notebook:',bt,Z,dt,x,jt,A,Hl="The following code will download the model <code>jina-reranker-v2-base-multilingual</code> and run it locally:",ht,S,ft,Q,It,v,Yl="We will use LlamaIndex to create a holder object for the connection to the Hugging Face inference API and to the copy of <code>mistralai/Mixtral-8x7B-Instruct-v0.1</code> running there.",Ct,W,Ll='First, get a Hugging Face access token from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face Account Settings page</a>.',gt,X,zl="Enter it when prompted below:",Vt,q,$t,H,Pl="Next, initialize an instance of the <code>HuggingFaceInferenceAPI</code> class from LlamaIndex and store it as <code>mistral_llm</code>:",Rt,Y,kt,L,Bt,z,Dl='We extracted the eight table definitions from the <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">database import files located on GitHub</a>. Run the command below to put them into a Python list named <code>table_declarations</code>:',Nt,P,_t,D,Kl="Now, we define a function that takes a natural language query and the list of table definitions, scores all of them with Jina Reranker v2, returning them in order from highest scoring to lowest:",Et,K,Ft,O,Ol="Jina Reranker v2 scores every table definition we give it and by default this function will return all of them with their scores. The optional argument <code>top_n</code> limits the number of results returned to a user-defined number, starting with the highest scoring one.",Gt,ee,es="Try it out. First, define a query:",Zt,te,xt,le,ts="Run <code>rank_tables</code> to get a list of table definitions back. Let’s set <code>top_n</code> to 3 to limit the return list size and assign it to the variable <code>ranked_tables</code>, then inspect the result:",At,se,St,ae,ls="The output should include the tables <code>region_sales</code>, <code>platform</code> and <code>game_platform</code>, which all seem to be reasonable places to look for an answer to the query.",Qt,ne,vt,ie,ss="We’re going to have Mistral Instruct v0.1 write an SQL query that fulfils the user’s query, based on the declarations of the top three tables according to the reranker.",Wt,re,as="First, we make a prompt for that purpose using LlamaIndex’ <code>PromptTemplate</code> class:",Xt,Me,qt,pe,ns="We use the <code>format</code> method to fill in the template fields with the user query and top three table declarations from Jina Reranker v2:",Ht,oe,Yt,ye,is="You can see the actual text we’re going to pass to Mistral Instruct:",Lt,Ue,zt,me,rs="Now let’s send the prompt to Mistral Instruct and retrieve its response:",Pt,we,Dt,Je,Kt,Te,Ms=`Use the built-in Python interface to SQLite to run the query above
against the database <code>videogames.db</code>:`,Ot,ue,el,ce,ps='For details on the interface to SQLite, <a href="https://docs.python.org/3/library/sqlite3.html" rel="nofollow">see the Python3 documentation</a>.',tl,be,os="Inspect the result:",ll,de,sl,je,ys="You can check if this is correct by running your own SQL query. The sales data stored in this database is in the form of floating point numbers, presumably thousands or millions of unit sales.",al,he,nl,fe,Us="Now we will pass the user’s query, the SQL query, and the result back to Mistral Instruct with a new prompt template.",il,Ie,ms="First, make the new prompt template using LlamaIndex, the same as above:",rl,Ce,Ml,ge,ws=`We will convert the SQL output into JSON, a format Mistral Instruct v0.1
understands.`,pl,Ve,Js="Populate the template fields:",ol,$e,yl,Re,Ts="Now solicit a natural language response from Mistral Instruct:",Ul,ke,ml,Be,wl,Ne,us="Let’s organize all that into one function with exception trapping:",Jl,_e,Tl,Ee,cs="Try it out:",ul,Fe,cl,Ge,bs="Try some other queries:",bl,Ze,dl,xe,jl,Ae,hl,Se,fl,Qe,Il,ve,ds="Try your own queries:",Cl,We,gl,Xe,Vl,qe,js="We’ve shown you how to make a very basic RAG (retrieval-augmented generation) system for natural language question-answering that uses an SQL database as an information source.  In this implementation, we use the same large language model (Mistral Instruct v0.1), to generate SQL queries and to construct natural language responses.",$l,He,hs="The database here is a very small example, and scaling this up might demand a more sophisticated approach than just ranking a list of table definitions. You might want to use a two-stage process, where an embedding model and vector store initially retrieve more results, but the reranker model prunes that down to whatever number you are able to put into a prompt for a generative language model.",Rl,Ye,fs="This notebook has assumed no request requires more than three tables to satisfy, and obviously, in practice, this cannot always be true. Mistral 7B Instruct v0.1 is not guaranteed to produce correct (or even executable) SQL output. In production, something like this requires much more in-depth error handling.",kl,Le,Is="More sophisticated error handling, longer input context windows, and generative models specialized in SQL-specific tasks might make a big difference in practical applications.",Bl,ze,Cs="Nonetheless, you can see here how the RAG concept extends to structured databases, expanding its scope for use dramatically.",Nl,Pe,_l,Ke,El;return b=new Fs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_sql_reranker.ipynb"}]}}),d=new Es({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new T({props:{title:"RAG backed by SQL and Jina Reranker v2",local:"rag-backed-by-sql-and-jina-reranker-v2",headingTag:"h1"}}),I=new T({props:{title:"How it Works",local:"how-it-works",headingTag:"h3"}}),g=new T({props:{title:"The Database",local:"the-database",headingTag:"h3"}}),$=new T({props:{title:"Software and Hardware Requirements",local:"software-and-hardware-requirements",headingTag:"h3"}}),B=new T({props:{title:"Setting Up",local:"setting-up",headingTag:"h2"}}),N=new T({props:{title:"Install Requirements",local:"install-requirements",headingTag:"h3"}}),E=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcVUlMjB0cmFuc2Zvcm1lcnMlMjBlaW5vcHMlMjBsbGFtYS1pbmRleCUyMGxsYW1hLWluZGV4LXBvc3Rwcm9jZXNzb3ItamluYWFpLXJlcmFuayUyMCUyMGxsYW1hLWluZGV4LWxsbXMtaHVnZ2luZ2ZhY2UlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJpbmZlcmVuY2UlNUQlMjI=",highlighted:'!pip install -qU transformers einops llama-index llama-index-postprocessor-jinaai-rerank  llama-index-llms-huggingface <span class="hljs-string">&quot;huggingface_hub[inference]&quot;</span>',wrap:!1}}),F=new T({props:{title:"Download the Database",local:"download-the-database",headingTag:"h3"}}),Z=new J({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZiYnJ1bW0lMkZkYXRhYmFzZXN0YXIlMkZyYXclMkZtYWluJTJGc2FtcGxlX2RhdGFiYXNlcyUyRnNhbXBsZV9kYl92aWRlb2dhbWVzJTJGc3FsaXRlJTJGdmlkZW9nYW1lcy5kYg==",highlighted:"!wget https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db",wrap:!1}}),x=new T({props:{title:"Download and Run Jina Reranker v2",local:"download-and-run-jina-reranker-v2",headingTag:"h3"}}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFyZXJhbmtlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCdqaW5hYWklMkZqaW5hLXJlcmFua2VyLXYyLWJhc2UtbXVsdGlsaW5ndWFsJyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUwQSklMEElMEFyZXJhbmtlcl9tb2RlbC50bygnY3VkYScpJTIwJTIzJTIwb3IlMjAnY3B1JyUyMGlmJTIwbm8lMjBHUFUlMjBpcyUyMGF2YWlsYWJsZSUwQXJlcmFua2VyX21vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

reranker_model = AutoModelForSequenceClassification.from_pretrained(
    <span class="hljs-string">&#x27;jinaai/jina-reranker-v2-base-multilingual&#x27;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
)

reranker_model.to(<span class="hljs-string">&#x27;cuda&#x27;</span>) <span class="hljs-comment"># or &#x27;cpu&#x27; if no GPU is available</span>
reranker_model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),Q=new T({props:{title:"Set up the Interface to Mistral Instruct",local:"set-up-the-interface-to-mistral-instruct",headingTag:"h3"}}),q=new J({props:{code:"aW1wb3J0JTIwZ2V0cGFzcyUwQSUwQXByaW50KCUyMlBhc3RlJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjZXNzJTIwdG9rZW4lMjBoZXJlJTNBJTIwJTIyKSUwQWhmX3Rva2VuJTIwJTNEJTIwZ2V0cGFzcy5nZXRwYXNzKCk=",highlighted:`<span class="hljs-keyword">import</span> getpass

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Paste your Hugging Face access token here: &quot;</span>)
hf_token = getpass.getpass()`,wrap:!1}}),Y=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQSUwQW1pc3RyYWxfbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwdG9rZW4lM0RoZl90b2tlbiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

mistral_llm = HuggingFaceInferenceAPI(
    model_name=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, token=hf_token
)`,wrap:!1}}),L=new T({props:{title:"Using SQL-Aware Jina Reranker v2",local:"using-sql-aware-jina-reranker-v2",headingTag:"h2"}}),P=new J({props:{code:"dGFibGVfZGVjbGFyYXRpb25zJTIwJTNEJTIwJTVCJ0NSRUFURSUyMFRBQkxFJTIwcGxhdGZvcm0lMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RwbGF0Zm9ybV9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0InJTJDJTBBJTIwJ0NSRUFURSUyMFRBQkxFJTIwZ2VucmUlMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnZW5yZV9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0InJTJDJTBBJTIwJ0NSRUFURSUyMFRBQkxFJTIwcHVibGlzaGVyJTIwKCU1Q24lNUN0aWQlMjBJTlRFR0VSJTIwUFJJTUFSWSUyMEtFWSUyQyU1Q24lNUN0cHVibGlzaGVyX25hbWUlMjBURVhUJTIwREVGQVVMVCUyME5VTEwlNUNuKSUzQiclMkMlMEElMjAnQ1JFQVRFJTIwVEFCTEUlMjByZWdpb24lMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RyZWdpb25fbmFtZSUyMFRFWFQlMjBERUZBVUxUJTIwTlVMTCU1Q24pJTNCJyUyQyUwQSUyMCdDUkVBVEUlMjBUQUJMRSUyMGdhbWUlMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnZW5yZV9pZCUyMElOVEVHRVIlMkMlNUNuJTVDdGdhbWVfbmFtZSUyMFRFWFQlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0Q09OU1RSQUlOVCUyMGZrX2dtX2dlbiUyMEZPUkVJR04lMjBLRVklMjAoZ2VucmVfaWQpJTIwUkVGRVJFTkNFUyUyMGdlbnJlKGlkKSU1Q24pJTNCJyUyQyUwQSUyMCdDUkVBVEUlMjBUQUJMRSUyMGdhbWVfcHVibGlzaGVyJTIwKCU1Q24lNUN0aWQlMjBJTlRFR0VSJTIwUFJJTUFSWSUyMEtFWSUyQyU1Q24lNUN0Z2FtZV9pZCUyMElOVEVHRVIlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0cHVibGlzaGVyX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RDT05TVFJBSU5UJTIwZmtfZ3B1X2dhbSUyMEZPUkVJR04lMjBLRVklMjAoZ2FtZV9pZCklMjBSRUZFUkVOQ0VTJTIwZ2FtZShpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19ncHVfcHViJTIwRk9SRUlHTiUyMEtFWSUyMChwdWJsaXNoZXJfaWQpJTIwUkVGRVJFTkNFUyUyMHB1Ymxpc2hlcihpZCklNUNuKSUzQiclMkMlMEElMjAnQ1JFQVRFJTIwVEFCTEUlMjBnYW1lX3BsYXRmb3JtJTIwKCU1Q24lNUN0aWQlMjBJTlRFR0VSJTIwUFJJTUFSWSUyMEtFWSUyQyU1Q24lNUN0Z2FtZV9wdWJsaXNoZXJfaWQlMjBJTlRFR0VSJTIwREVGQVVMVCUyME5VTEwlMkMlNUNuJTVDdHBsYXRmb3JtX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RyZWxlYXNlX3llYXIlMjBJTlRFR0VSJTIwREVGQVVMVCUyME5VTEwlMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19ncGxfZ3AlMjBGT1JFSUdOJTIwS0VZJTIwKGdhbWVfcHVibGlzaGVyX2lkKSUyMFJFRkVSRU5DRVMlMjBnYW1lX3B1Ymxpc2hlcihpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19ncGxfcGxhJTIwRk9SRUlHTiUyMEtFWSUyMChwbGF0Zm9ybV9pZCklMjBSRUZFUkVOQ0VTJTIwcGxhdGZvcm0oaWQpJTVDbiklM0InJTJDJTBBJTIwJ0NSRUFURSUyMFRBQkxFJTIwcmVnaW9uX3NhbGVzJTIwKCU1Q24lNUN0cmVnaW9uX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RnYW1lX3BsYXRmb3JtX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RudW1fc2FsZXMlMjBSRUFMJTJDJTVDbiUyMCUyMCUyMENPTlNUUkFJTlQlMjBma19yc19ncCUyMEZPUkVJR04lMjBLRVklMjAoZ2FtZV9wbGF0Zm9ybV9pZCklMjBSRUZFUkVOQ0VTJTIwZ2FtZV9wbGF0Zm9ybShpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19yc19yZWclMjBGT1JFSUdOJTIwS0VZJTIwKHJlZ2lvbl9pZCklMjBSRUZFUkVOQ0VTJTIwcmVnaW9uKGlkKSU1Q24pJTNCJyU1RA==",highlighted:`table_declarations = [<span class="hljs-string">&#x27;CREATE TABLE platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tplatform_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE genre (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tpublisher_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE region (\\n\\tid INTEGER PRIMARY KEY,\\n\\tregion_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE game (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_id INTEGER,\\n\\tgame_name TEXT DEFAULT NULL,\\n\\tCONSTRAINT fk_gm_gen FOREIGN KEY (genre_id) REFERENCES genre(id)\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE game_publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_id INTEGER DEFAULT NULL,\\n\\tpublisher_id INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpu_gam FOREIGN KEY (game_id) REFERENCES game(id),\\n\\tCONSTRAINT fk_gpu_pub FOREIGN KEY (publisher_id) REFERENCES publisher(id)\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE game_platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_publisher_id INTEGER DEFAULT NULL,\\n\\tplatform_id INTEGER DEFAULT NULL,\\n\\trelease_year INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpl_gp FOREIGN KEY (game_publisher_id) REFERENCES game_publisher(id),\\n\\tCONSTRAINT fk_gpl_pla FOREIGN KEY (platform_id) REFERENCES platform(id)\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE region_sales (\\n\\tregion_id INTEGER DEFAULT NULL,\\n\\tgame_platform_id INTEGER DEFAULT NULL,\\n\\tnum_sales REAL,\\n   CONSTRAINT fk_rs_gp FOREIGN KEY (game_platform_id) REFERENCES game_platform(id),\\n\\tCONSTRAINT fk_rs_reg FOREIGN KEY (region_id) REFERENCES region(id)\\n);&#x27;</span>]`,wrap:!1}}),K=new J({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUdXBsZSUwQSUwQWRlZiUyMHJhbmtfdGFibGVzKHF1ZXJ5JTNBJTIwc3RyJTJDJTIwdGFibGVfc3BlY3MlM0ElMjBMaXN0JTVCc3RyJTVEJTJDJTIwdG9wX24lM0FpbnQlM0QwKSUyMC0lM0UlMjBMaXN0JTVCVHVwbGUlNUJmbG9hdCUyQyUyMHN0ciU1RCU1RCUzQSUwQSUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMEdldCUyMHNvcnRlZCUyMHBhaXJzJTIwb2YlMjBzY29yZXMlMjBhbmQlMjB0YWJsZSUyMHNwZWNpZmljYXRpb25zJTJDJTIwdGhlbiUyMHJldHVybiUyMHRoZSUyMHRvcCUyME4lMkMlMEElMjAlMjBvciUyMGFsbCUyMGlmJTIwdG9wX24lMjBpcyUyMDAlMjBvciUyMGRlZmF1bHQuJTBBJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwcGFpcnMlMjAlM0QlMjAlNUIlNUJxdWVyeSUyQyUyMHRhYmxlX3NwZWMlNUQlMjBmb3IlMjB0YWJsZV9zcGVjJTIwaW4lMjB0YWJsZV9zcGVjcyU1RCUwQSUyMCUyMHNjb3JlcyUyMCUzRCUyMHJlcmFua2VyX21vZGVsLmNvbXB1dGVfc2NvcmUocGFpcnMpJTBBJTIwJTIwc2NvcmVkX3RhYmxlcyUyMCUzRCUyMCU1QihzY29yZSUyQyUyMHRhYmxlX3NwZWMpJTIwZm9yJTIwc2NvcmUlMkMlMjB0YWJsZV9zcGVjJTIwaW4lMjB6aXAoc2NvcmVzJTJDJTIwdGFibGVfc3BlY3MpJTVEJTBBJTIwJTIwc2NvcmVkX3RhYmxlcy5zb3J0KGtleSUzRGxhbWJkYSUyMHglM0ElMjB4JTVCMCU1RCUyQyUyMHJldmVyc2UlM0RUcnVlKSUwQSUyMCUyMGlmJTIwdG9wX24lMjBhbmQlMjB0b3BfbiUyMCUzQyUyMGxlbihzY29yZWRfdGFibGVzKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlZF90YWJsZXMlNUIwJTNBdG9wX24lNUQlMEElMjAlMjByZXR1cm4lMjBzY29yZWRfdGFibGVz",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">rank_tables</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, table_specs: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>], top_n:<span class="hljs-built_in">int</span>=<span class="hljs-number">0</span></span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">str</span>]]:
  <span class="hljs-string">&quot;&quot;&quot;
  Get sorted pairs of scores and table specifications, then return the top N,
  or all if top_n is 0 or default.
  &quot;&quot;&quot;</span>
  pairs = [[query, table_spec] <span class="hljs-keyword">for</span> table_spec <span class="hljs-keyword">in</span> table_specs]
  scores = reranker_model.compute_score(pairs)
  scored_tables = [(score, table_spec) <span class="hljs-keyword">for</span> score, table_spec <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(scores, table_specs)]
  scored_tables.sort(key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">0</span>], reverse=<span class="hljs-literal">True</span>)
  <span class="hljs-keyword">if</span> top_n <span class="hljs-keyword">and</span> top_n &lt; <span class="hljs-built_in">len</span>(scored_tables):
    <span class="hljs-keyword">return</span> scored_tables[<span class="hljs-number">0</span>:top_n]
  <span class="hljs-keyword">return</span> scored_tables`,wrap:!1}}),te=new J({props:{code:"dXNlcl9xdWVyeSUyMCUzRCUyMCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMuJTIy",highlighted:'user_query = <span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>',wrap:!1}}),se=new J({props:{code:"cmFua2VkX3RhYmxlcyUyMCUzRCUyMHJhbmtfdGFibGVzKHVzZXJfcXVlcnklMkMlMjB0YWJsZV9kZWNsYXJhdGlvbnMlMkMlMjB0b3BfbiUzRDMpJTBBcmFua2VkX3RhYmxlcw==",highlighted:`ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
ranked_tables`,wrap:!1}}),ne=new T({props:{title:"Using Mistral Instruct to Generate SQL",local:"using-mistral-instruct-to-generate-sql",headingTag:"h2"}}),Me=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBQcm9tcHRUZW1wbGF0ZSUwQSUwQW1ha2Vfc3FsX3Byb21wdF90bXBsX3RleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBR2VuZXJhdGUlMjBhJTIwU1FMJTIwcXVlcnklMjB0byUyMGFuc3dlciUyMHRoZSUyMGZvbGxvd2luZyUyMHF1ZXN0aW9uJTIwZnJvbSUyMHRoZSUyMHVzZXIlM0ElMEElNUMlMjIlN0JxdWVyeV9zdHIlN0QlNUMlMjIlMEElMEFUaGUlMjBTUUwlMjBxdWVyeSUyMHNob3VsZCUyMHVzZSUyMG9ubHklMjB0YWJsZXMlMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwU1FMJTIwZGVmaW5pdGlvbnMlM0ElMEElMEFUYWJsZSUyMDElM0ElMEElN0J0YWJsZV8xJTdEJTBBJTBBVGFibGUlMjAyJTNBJTBBJTdCdGFibGVfMiU3RCUwQSUwQVRhYmxlJTIwMyUzQSUwQSU3QnRhYmxlXzMlN0QlMEElMEFNYWtlJTIwc3VyZSUyMHlvdSUyME9OTFklMjBvdXRwdXQlMjBhbiUyMFNRTCUyMHF1ZXJ5JTIwYW5kJTIwbm8lMjBleHBsYW5hdGlvbi4lMEElMjIlMjIlMjIlMEEpJTBBbWFrZV9zcWxfcHJvbXB0X3RtcGwlMjAlM0QlMjBQcm9tcHRUZW1wbGF0ZShtYWtlX3NxbF9wcm9tcHRfdG1wbF90ZXh0KQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> PromptTemplate

make_sql_prompt_tmpl_text = (
    <span class="hljs-string">&quot;&quot;&quot;
Generate a SQL query to answer the following question from the user:
\\&quot;{query_str}\\&quot;

The SQL query should use only tables with the following SQL definitions:

Table 1:
{table_1}

Table 2:
{table_2}

Table 3:
{table_3}

Make sure you ONLY output an SQL query and no explanation.
&quot;&quot;&quot;</span>
)
make_sql_prompt_tmpl = PromptTemplate(make_sql_prompt_tmpl_text)`,wrap:!1}}),oe=new J({props:{code:"bWFrZV9zcWxfcHJvbXB0JTIwJTNEJTIwbWFrZV9zcWxfcHJvbXB0X3RtcGwuZm9ybWF0KHF1ZXJ5X3N0ciUzRHVzZXJfcXVlcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YWJsZV8xJTNEcmFua2VkX3RhYmxlcyU1QjAlNUQlNUIxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFibGVfMiUzRHJhbmtlZF90YWJsZXMlNUIxJTVEJTVCMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhYmxlXzMlM0RyYW5rZWRfdGFibGVzJTVCMiU1RCU1QjElNUQp",highlighted:`make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query,
                                              table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>],
                                              table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>],
                                              table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>])`,wrap:!1}}),Ue=new J({props:{code:"cHJpbnQobWFrZV9zcWxfcHJvbXB0KQ==",highlighted:'<span class="hljs-built_in">print</span>(make_sql_prompt)',wrap:!1}}),we=new J({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBtaXN0cmFsX2xsbS5jb21wbGV0ZShtYWtlX3NxbF9wcm9tcHQpJTBBc3FsX3F1ZXJ5JTIwJTNEJTIwc3RyKHJlc3BvbnNlKSUwQXByaW50KHNxbF9xdWVyeSk=",highlighted:`response = mistral_llm.complete(make_sql_prompt)
sql_query = <span class="hljs-built_in">str</span>(response)
<span class="hljs-built_in">print</span>(sql_query)`,wrap:!1}}),Je=new T({props:{title:"Running the SQL query",local:"running-the-sql-query",headingTag:"h2"}}),ue=new J({props:{code:"aW1wb3J0JTIwc3FsaXRlMyUwQSUwQWNvbiUyMCUzRCUyMHNxbGl0ZTMuY29ubmVjdCglMjJ2aWRlb2dhbWVzLmRiJTIyKSUwQWN1ciUyMCUzRCUyMGNvbi5jdXJzb3IoKSUwQXNxbF9yZXNwb25zZSUyMCUzRCUyMGN1ci5leGVjdXRlKHNxbF9xdWVyeSkuZmV0Y2hhbGwoKQ==",highlighted:`<span class="hljs-keyword">import</span> sqlite3

con = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>)
cur = con.cursor()
sql_response = cur.execute(sql_query).fetchall()`,wrap:!1}}),de=new J({props:{code:"c3FsX3Jlc3BvbnNl",highlighted:"sql_response",wrap:!1}}),he=new T({props:{title:"Getting a Natural Language Answer",local:"getting-a-natural-language-answer",headingTag:"h2"}}),Ce=new J({props:{code:"cmFnX3Byb21wdF90bXBsX3N0ciUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEFVc2UlMjB0aGUlMjBpbmZvcm1hdGlvbiUyMGluJTIwdGhlJTIwSlNPTiUyMHRhYmxlJTIwdG8lMjBhbnN3ZXIlMjB0aGUlMjBmb2xsb3dpbmclMjB1c2VyJTIwcXVlcnkuJTBBRG8lMjBub3QlMjBleHBsYWluJTIwYW55dGhpbmclMkMlMjBqdXN0JTIwYW5zd2VyJTIwY29uY2lzZWx5LiUyMFVzZSUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMGluJTIweW91ciUwQWFuc3dlciUyQyUyMG5vdCUyMGNvbXB1dGVyJTIwZm9ybWF0dGluZy4lMEElMEFVU0VSJTIwUVVFUlklM0ElMjAlN0JxdWVyeV9zdHIlN0QlMEElMEFKU09OJTIwdGFibGUlM0ElMEElN0Jqc29uX3RhYmxlJTdEJTBBJTBBVGhpcyUyMHRhYmxlJTIwd2FzJTIwZ2VuZXJhdGVkJTIwYnklMjB0aGUlMjBmb2xsb3dpbmclMjBTUUwlMjBxdWVyeSUzQSUwQSU3QnNxbF9xdWVyeSU3RCUwQSUwQUFuc3dlciUyME9OTFklMjB1c2luZyUyMHRoZSUyMGluZm9ybWF0aW9uJTIwaW4lMjB0aGUlMjB0YWJsZSUyMGFuZCUyMHRoZSUyMFNRTCUyMHF1ZXJ5JTJDJTIwYW5kJTIwaWYlMjB0aGUlMEF0YWJsZSUyMGRvZXMlMjBub3QlMjBwcm92aWRlJTIwdGhlJTIwaW5mb3JtYXRpb24lMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXN0aW9uJTJDJTIwYW5zd2VyJTBBJTIyTm8lMjBJbmZvcm1hdGlvbiUyMi4lMEElMjIlMjIlMjIlMEEpJTBBcmFnX3Byb21wdF90bXBsJTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUocmFnX3Byb21wdF90bXBsX3N0cik=",highlighted:`rag_prompt_tmpl_str = (
    <span class="hljs-string">&quot;&quot;&quot;
Use the information in the JSON table to answer the following user query.
Do not explain anything, just answer concisely. Use natural language in your
answer, not computer formatting.

USER QUERY: {query_str}

JSON table:
{json_table}

This table was generated by the following SQL query:
{sql_query}

Answer ONLY using the information in the table and the SQL query, and if the
table does not provide the information to answer the question, answer
&quot;No Information&quot;.
&quot;&quot;&quot;</span>
)
rag_prompt_tmpl = PromptTemplate(rag_prompt_tmpl_str)`,wrap:!1}}),$e=new J({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJhZ19wcm9tcHQlMjAlM0QlMjByYWdfcHJvbXB0X3RtcGwuZm9ybWF0KHF1ZXJ5X3N0ciUzRCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uX3RhYmxlJTNEanNvbi5kdW1wcyhzcWxfcmVzcG9uc2UpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3FsX3F1ZXJ5JTNEc3FsX3F1ZXJ5KQ==",highlighted:`<span class="hljs-keyword">import</span> json

rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=<span class="hljs-string">&quot;Identify the top 10 platforms by total sales&quot;</span>,
                                    json_table=json.dumps(sql_response),
                                    sql_query=sql_query)`,wrap:!1}}),ke=new J({props:{code:"cmFnX3Jlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUocmFnX3Byb21wdCklMEFwcmludChzdHIocmFnX3Jlc3BvbnNlKSk=",highlighted:`rag_response = mistral_llm.complete(rag_prompt)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">str</span>(rag_response))`,wrap:!1}}),Be=new T({props:{title:"Try it yourself",local:"try-it-yourself",headingTag:"h2"}}),_e=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_sql</span>(<span class="hljs-params">user_query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
  <span class="hljs-keyword">try</span>:
    ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Ranking failed.\\nUser query:\\n<span class="hljs-subst">{user_query}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)

  make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query,
                                                table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>],
                                                table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>],
                                                table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>])

  <span class="hljs-keyword">try</span>:
    response = mistral_llm.complete(make_sql_prompt)
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL query generation failed\\nPrompt:\\n<span class="hljs-subst">{make_sql_prompt}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)

  <span class="hljs-comment"># Backslash removal is a necessary hack because sometimes Mistral puts them</span>
  <span class="hljs-comment"># in its generated code.</span>
  sql_query = <span class="hljs-built_in">str</span>(response).replace(<span class="hljs-string">&quot;\\\\&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)

  <span class="hljs-keyword">try</span>:
    sql_response = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>).cursor().execute(sql_query).fetchall()
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL querying failed. Query:\\n<span class="hljs-subst">{sql_query}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)

  rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query,
                                      json_table=json.dumps(sql_response),
                                      sql_query=sql_query)
  <span class="hljs-keyword">try</span>:
    rag_response = mistral_llm.complete(rag_prompt)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(rag_response)
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer generation failed. Prompt:\\n<span class="hljs-subst">{rag_prompt}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)`,wrap:!1}}),Fe=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJJZGVudGlmeSUyMHRoZSUyMHRvcCUyMDEwJTIwcGxhdGZvcm1zJTIwYnklMjB0b3RhbCUyMHNhbGVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>))',wrap:!1}}),Ze=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJTdW1tYXJpemUlMjBzYWxlcyUyMGJ5JTIwcmVnaW9uLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Summarize sales by region.&quot;</span>))',wrap:!1}}),xe=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJMaXN0JTIwdGhlJTIwcHVibGlzaGVyJTIwd2l0aCUyMHRoZSUyMGxhcmdlc3QlMjBudW1iZXIlMjBvZiUyMHB1Ymxpc2hlZCUyMGdhbWVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;List the publisher with the largest number of published games.&quot;</span>))',wrap:!1}}),Ae=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJEaXNwbGF5JTIwdGhlJTIweWVhciUyMHdpdGglMjBtb3N0JTIwZ2FtZXMlMjByZWxlYXNlZC4lMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Display the year with most games released.&quot;</span>))',wrap:!1}}),Se=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9uJTIwdGhlJTIwV2lpJTIwcGxhdGZvcm0lM0YlMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre on the Wii platform?&quot;</span>))',wrap:!1}}),Qe=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9mJTIwMjAxMiUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre of 2012?&quot;</span>))',wrap:!1}}),We=new J({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjIlM0NJTlNFUlQlMjBRVUVTVElPTiUyME9SJTIwSU5TVFJVQ1RJT04lMjBIRVJFJTNFJTIyKSk=",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;&lt;INSERT QUESTION OR INSTRUCTION HERE&gt;&quot;</span>))',wrap:!1}}),Xe=new T({props:{title:"Review and Conclusions",local:"review-and-conclusions",headingTag:"h2"}}),Pe=new Gs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_sql_reranker.md"}}),{c(){u=i("meta"),Oe=a(),De=i("p"),et=a(),M(b.$$.fragment),tt=a(),M(d.$$.fragment),lt=a(),M(j.$$.fragment),st=a(),h=i("p"),h.innerHTML=Zl,at=a(),f=i("p"),f.textContent=xl,nt=a(),M(I.$$.fragment),it=a(),C=i("ul"),C.innerHTML=Al,rt=a(),M(g.$$.fragment),Mt=a(),V=i("p"),V.innerHTML=Sl,pt=a(),M($.$$.fragment),ot=a(),R=i("p"),R.innerHTML=Ql,yt=a(),k=i("p"),k.innerHTML=vl,Ut=a(),c=i("blockquote"),c.innerHTML=Wl,mt=a(),M(B.$$.fragment),wt=a(),M(N.$$.fragment),Jt=a(),_=i("p"),_.textContent=Xl,Tt=a(),M(E.$$.fragment),ut=a(),M(F.$$.fragment),ct=a(),G=i("p"),G.innerHTML=ql,bt=a(),M(Z.$$.fragment),dt=a(),M(x.$$.fragment),jt=a(),A=i("p"),A.innerHTML=Hl,ht=a(),M(S.$$.fragment),ft=a(),M(Q.$$.fragment),It=a(),v=i("p"),v.innerHTML=Yl,Ct=a(),W=i("p"),W.innerHTML=Ll,gt=a(),X=i("p"),X.textContent=zl,Vt=a(),M(q.$$.fragment),$t=a(),H=i("p"),H.innerHTML=Pl,Rt=a(),M(Y.$$.fragment),kt=a(),M(L.$$.fragment),Bt=a(),z=i("p"),z.innerHTML=Dl,Nt=a(),M(P.$$.fragment),_t=a(),D=i("p"),D.textContent=Kl,Et=a(),M(K.$$.fragment),Ft=a(),O=i("p"),O.innerHTML=Ol,Gt=a(),ee=i("p"),ee.textContent=es,Zt=a(),M(te.$$.fragment),xt=a(),le=i("p"),le.innerHTML=ts,At=a(),M(se.$$.fragment),St=a(),ae=i("p"),ae.innerHTML=ls,Qt=a(),M(ne.$$.fragment),vt=a(),ie=i("p"),ie.textContent=ss,Wt=a(),re=i("p"),re.innerHTML=as,Xt=a(),M(Me.$$.fragment),qt=a(),pe=i("p"),pe.innerHTML=ns,Ht=a(),M(oe.$$.fragment),Yt=a(),ye=i("p"),ye.textContent=is,Lt=a(),M(Ue.$$.fragment),zt=a(),me=i("p"),me.textContent=rs,Pt=a(),M(we.$$.fragment),Dt=a(),M(Je.$$.fragment),Kt=a(),Te=i("p"),Te.innerHTML=Ms,Ot=a(),M(ue.$$.fragment),el=a(),ce=i("p"),ce.innerHTML=ps,tl=a(),be=i("p"),be.textContent=os,ll=a(),M(de.$$.fragment),sl=a(),je=i("p"),je.textContent=ys,al=a(),M(he.$$.fragment),nl=a(),fe=i("p"),fe.textContent=Us,il=a(),Ie=i("p"),Ie.textContent=ms,rl=a(),M(Ce.$$.fragment),Ml=a(),ge=i("p"),ge.textContent=ws,pl=a(),Ve=i("p"),Ve.textContent=Js,ol=a(),M($e.$$.fragment),yl=a(),Re=i("p"),Re.textContent=Ts,Ul=a(),M(ke.$$.fragment),ml=a(),M(Be.$$.fragment),wl=a(),Ne=i("p"),Ne.textContent=us,Jl=a(),M(_e.$$.fragment),Tl=a(),Ee=i("p"),Ee.textContent=cs,ul=a(),M(Fe.$$.fragment),cl=a(),Ge=i("p"),Ge.textContent=bs,bl=a(),M(Ze.$$.fragment),dl=a(),M(xe.$$.fragment),jl=a(),M(Ae.$$.fragment),hl=a(),M(Se.$$.fragment),fl=a(),M(Qe.$$.fragment),Il=a(),ve=i("p"),ve.textContent=ds,Cl=a(),M(We.$$.fragment),gl=a(),M(Xe.$$.fragment),Vl=a(),qe=i("p"),qe.textContent=js,$l=a(),He=i("p"),He.textContent=hs,Rl=a(),Ye=i("p"),Ye.textContent=fs,kl=a(),Le=i("p"),Le.textContent=Is,Bl=a(),ze=i("p"),ze.textContent=Cs,Nl=a(),M(Pe.$$.fragment),_l=a(),Ke=i("p"),this.h()},l(e){const t=Ns("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(l),Oe=n(e),De=r(e,"P",{}),gs(De).forEach(l),et=n(e),p(b.$$.fragment,e),tt=n(e),p(d.$$.fragment,e),lt=n(e),p(j.$$.fragment,e),st=n(e),h=r(e,"P",{"data-svelte-h":!0}),w(h)!=="svelte-15h4oc6"&&(h.innerHTML=Zl),at=n(e),f=r(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-igm0s6"&&(f.textContent=xl),nt=n(e),p(I.$$.fragment,e),it=n(e),C=r(e,"UL",{"data-svelte-h":!0}),w(C)!=="svelte-1xkzjuz"&&(C.innerHTML=Al),rt=n(e),p(g.$$.fragment,e),Mt=n(e),V=r(e,"P",{"data-svelte-h":!0}),w(V)!=="svelte-qg7j5l"&&(V.innerHTML=Sl),pt=n(e),p($.$$.fragment,e),ot=n(e),R=r(e,"P",{"data-svelte-h":!0}),w(R)!=="svelte-tat797"&&(R.innerHTML=Ql),yt=n(e),k=r(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-1ddj9ti"&&(k.innerHTML=vl),Ut=n(e),c=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),w(c)!=="svelte-1inkb4f"&&(c.innerHTML=Wl),mt=n(e),p(B.$$.fragment,e),wt=n(e),p(N.$$.fragment,e),Jt=n(e),_=r(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-u4asgs"&&(_.textContent=Xl),Tt=n(e),p(E.$$.fragment,e),ut=n(e),p(F.$$.fragment,e),ct=n(e),G=r(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-12d1e2b"&&(G.innerHTML=ql),bt=n(e),p(Z.$$.fragment,e),dt=n(e),p(x.$$.fragment,e),jt=n(e),A=r(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-w1clkv"&&(A.innerHTML=Hl),ht=n(e),p(S.$$.fragment,e),ft=n(e),p(Q.$$.fragment,e),It=n(e),v=r(e,"P",{"data-svelte-h":!0}),w(v)!=="svelte-14xvb0y"&&(v.innerHTML=Yl),Ct=n(e),W=r(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1slmc83"&&(W.innerHTML=Ll),gt=n(e),X=r(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1fwr6sh"&&(X.textContent=zl),Vt=n(e),p(q.$$.fragment,e),$t=n(e),H=r(e,"P",{"data-svelte-h":!0}),w(H)!=="svelte-1w3cr3e"&&(H.innerHTML=Pl),Rt=n(e),p(Y.$$.fragment,e),kt=n(e),p(L.$$.fragment,e),Bt=n(e),z=r(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-71eio4"&&(z.innerHTML=Dl),Nt=n(e),p(P.$$.fragment,e),_t=n(e),D=r(e,"P",{"data-svelte-h":!0}),w(D)!=="svelte-1twv85s"&&(D.textContent=Kl),Et=n(e),p(K.$$.fragment,e),Ft=n(e),O=r(e,"P",{"data-svelte-h":!0}),w(O)!=="svelte-o4furo"&&(O.innerHTML=Ol),Gt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-pvuljo"&&(ee.textContent=es),Zt=n(e),p(te.$$.fragment,e),xt=n(e),le=r(e,"P",{"data-svelte-h":!0}),w(le)!=="svelte-19tx4wc"&&(le.innerHTML=ts),At=n(e),p(se.$$.fragment,e),St=n(e),ae=r(e,"P",{"data-svelte-h":!0}),w(ae)!=="svelte-t2kwnd"&&(ae.innerHTML=ls),Qt=n(e),p(ne.$$.fragment,e),vt=n(e),ie=r(e,"P",{"data-svelte-h":!0}),w(ie)!=="svelte-gjatd0"&&(ie.textContent=ss),Wt=n(e),re=r(e,"P",{"data-svelte-h":!0}),w(re)!=="svelte-ia63v2"&&(re.innerHTML=as),Xt=n(e),p(Me.$$.fragment,e),qt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-1sgset9"&&(pe.innerHTML=ns),Ht=n(e),p(oe.$$.fragment,e),Yt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),w(ye)!=="svelte-1ylx49h"&&(ye.textContent=is),Lt=n(e),p(Ue.$$.fragment,e),zt=n(e),me=r(e,"P",{"data-svelte-h":!0}),w(me)!=="svelte-22s8s7"&&(me.textContent=rs),Pt=n(e),p(we.$$.fragment,e),Dt=n(e),p(Je.$$.fragment,e),Kt=n(e),Te=r(e,"P",{"data-svelte-h":!0}),w(Te)!=="svelte-1difuxa"&&(Te.innerHTML=Ms),Ot=n(e),p(ue.$$.fragment,e),el=n(e),ce=r(e,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-1kju3zy"&&(ce.innerHTML=ps),tl=n(e),be=r(e,"P",{"data-svelte-h":!0}),w(be)!=="svelte-1mogpba"&&(be.textContent=os),ll=n(e),p(de.$$.fragment,e),sl=n(e),je=r(e,"P",{"data-svelte-h":!0}),w(je)!=="svelte-1q6p39s"&&(je.textContent=ys),al=n(e),p(he.$$.fragment,e),nl=n(e),fe=r(e,"P",{"data-svelte-h":!0}),w(fe)!=="svelte-oj1hte"&&(fe.textContent=Us),il=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),w(Ie)!=="svelte-1p8oufy"&&(Ie.textContent=ms),rl=n(e),p(Ce.$$.fragment,e),Ml=n(e),ge=r(e,"P",{"data-svelte-h":!0}),w(ge)!=="svelte-1ugt2d7"&&(ge.textContent=ws),pl=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),w(Ve)!=="svelte-83tbvg"&&(Ve.textContent=Js),ol=n(e),p($e.$$.fragment,e),yl=n(e),Re=r(e,"P",{"data-svelte-h":!0}),w(Re)!=="svelte-1k3bapg"&&(Re.textContent=Ts),Ul=n(e),p(ke.$$.fragment,e),ml=n(e),p(Be.$$.fragment,e),wl=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),w(Ne)!=="svelte-k87ysy"&&(Ne.textContent=us),Jl=n(e),p(_e.$$.fragment,e),Tl=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),w(Ee)!=="svelte-1de9wqs"&&(Ee.textContent=cs),ul=n(e),p(Fe.$$.fragment,e),cl=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),w(Ge)!=="svelte-1xk2uad"&&(Ge.textContent=bs),bl=n(e),p(Ze.$$.fragment,e),dl=n(e),p(xe.$$.fragment,e),jl=n(e),p(Ae.$$.fragment,e),hl=n(e),p(Se.$$.fragment,e),fl=n(e),p(Qe.$$.fragment,e),Il=n(e),ve=r(e,"P",{"data-svelte-h":!0}),w(ve)!=="svelte-o0veke"&&(ve.textContent=ds),Cl=n(e),p(We.$$.fragment,e),gl=n(e),p(Xe.$$.fragment,e),Vl=n(e),qe=r(e,"P",{"data-svelte-h":!0}),w(qe)!=="svelte-14toh4c"&&(qe.textContent=js),$l=n(e),He=r(e,"P",{"data-svelte-h":!0}),w(He)!=="svelte-am4n5q"&&(He.textContent=hs),Rl=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),w(Ye)!=="svelte-1b0e8j0"&&(Ye.textContent=fs),kl=n(e),Le=r(e,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-1cmyhxx"&&(Le.textContent=Is),Bl=n(e),ze=r(e,"P",{"data-svelte-h":!0}),w(ze)!=="svelte-1t5qd6f"&&(ze.textContent=Cs),Nl=n(e),p(Pe.$$.fragment,e),_l=n(e),Ke=r(e,"P",{}),gs(Ke).forEach(l),this.h()},h(){Fl(u,"name","hf:doc:metadata"),Fl(u,"content",xs),Fl(c,"class","warning")},m(e,t){_s(document.head,u),s(e,Oe,t),s(e,De,t),s(e,et,t),o(b,e,t),s(e,tt,t),o(d,e,t),s(e,lt,t),o(j,e,t),s(e,st,t),s(e,h,t),s(e,at,t),s(e,f,t),s(e,nt,t),o(I,e,t),s(e,it,t),s(e,C,t),s(e,rt,t),o(g,e,t),s(e,Mt,t),s(e,V,t),s(e,pt,t),o($,e,t),s(e,ot,t),s(e,R,t),s(e,yt,t),s(e,k,t),s(e,Ut,t),s(e,c,t),s(e,mt,t),o(B,e,t),s(e,wt,t),o(N,e,t),s(e,Jt,t),s(e,_,t),s(e,Tt,t),o(E,e,t),s(e,ut,t),o(F,e,t),s(e,ct,t),s(e,G,t),s(e,bt,t),o(Z,e,t),s(e,dt,t),o(x,e,t),s(e,jt,t),s(e,A,t),s(e,ht,t),o(S,e,t),s(e,ft,t),o(Q,e,t),s(e,It,t),s(e,v,t),s(e,Ct,t),s(e,W,t),s(e,gt,t),s(e,X,t),s(e,Vt,t),o(q,e,t),s(e,$t,t),s(e,H,t),s(e,Rt,t),o(Y,e,t),s(e,kt,t),o(L,e,t),s(e,Bt,t),s(e,z,t),s(e,Nt,t),o(P,e,t),s(e,_t,t),s(e,D,t),s(e,Et,t),o(K,e,t),s(e,Ft,t),s(e,O,t),s(e,Gt,t),s(e,ee,t),s(e,Zt,t),o(te,e,t),s(e,xt,t),s(e,le,t),s(e,At,t),o(se,e,t),s(e,St,t),s(e,ae,t),s(e,Qt,t),o(ne,e,t),s(e,vt,t),s(e,ie,t),s(e,Wt,t),s(e,re,t),s(e,Xt,t),o(Me,e,t),s(e,qt,t),s(e,pe,t),s(e,Ht,t),o(oe,e,t),s(e,Yt,t),s(e,ye,t),s(e,Lt,t),o(Ue,e,t),s(e,zt,t),s(e,me,t),s(e,Pt,t),o(we,e,t),s(e,Dt,t),o(Je,e,t),s(e,Kt,t),s(e,Te,t),s(e,Ot,t),o(ue,e,t),s(e,el,t),s(e,ce,t),s(e,tl,t),s(e,be,t),s(e,ll,t),o(de,e,t),s(e,sl,t),s(e,je,t),s(e,al,t),o(he,e,t),s(e,nl,t),s(e,fe,t),s(e,il,t),s(e,Ie,t),s(e,rl,t),o(Ce,e,t),s(e,Ml,t),s(e,ge,t),s(e,pl,t),s(e,Ve,t),s(e,ol,t),o($e,e,t),s(e,yl,t),s(e,Re,t),s(e,Ul,t),o(ke,e,t),s(e,ml,t),o(Be,e,t),s(e,wl,t),s(e,Ne,t),s(e,Jl,t),o(_e,e,t),s(e,Tl,t),s(e,Ee,t),s(e,ul,t),o(Fe,e,t),s(e,cl,t),s(e,Ge,t),s(e,bl,t),o(Ze,e,t),s(e,dl,t),o(xe,e,t),s(e,jl,t),o(Ae,e,t),s(e,hl,t),o(Se,e,t),s(e,fl,t),o(Qe,e,t),s(e,Il,t),s(e,ve,t),s(e,Cl,t),o(We,e,t),s(e,gl,t),o(Xe,e,t),s(e,Vl,t),s(e,qe,t),s(e,$l,t),s(e,He,t),s(e,Rl,t),s(e,Ye,t),s(e,kl,t),s(e,Le,t),s(e,Bl,t),s(e,ze,t),s(e,Nl,t),o(Pe,e,t),s(e,_l,t),s(e,Ke,t),El=!0},p:$s,i(e){El||(y(b.$$.fragment,e),y(d.$$.fragment,e),y(j.$$.fragment,e),y(I.$$.fragment,e),y(g.$$.fragment,e),y($.$$.fragment,e),y(B.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(Z.$$.fragment,e),y(x.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(q.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(Me.$$.fragment,e),y(oe.$$.fragment,e),y(Ue.$$.fragment,e),y(we.$$.fragment,e),y(Je.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(he.$$.fragment,e),y(Ce.$$.fragment,e),y($e.$$.fragment,e),y(ke.$$.fragment,e),y(Be.$$.fragment,e),y(_e.$$.fragment,e),y(Fe.$$.fragment,e),y(Ze.$$.fragment,e),y(xe.$$.fragment,e),y(Ae.$$.fragment,e),y(Se.$$.fragment,e),y(Qe.$$.fragment,e),y(We.$$.fragment,e),y(Xe.$$.fragment,e),y(Pe.$$.fragment,e),El=!0)},o(e){U(b.$$.fragment,e),U(d.$$.fragment,e),U(j.$$.fragment,e),U(I.$$.fragment,e),U(g.$$.fragment,e),U($.$$.fragment,e),U(B.$$.fragment,e),U(N.$$.fragment,e),U(E.$$.fragment,e),U(F.$$.fragment,e),U(Z.$$.fragment,e),U(x.$$.fragment,e),U(S.$$.fragment,e),U(Q.$$.fragment,e),U(q.$$.fragment,e),U(Y.$$.fragment,e),U(L.$$.fragment,e),U(P.$$.fragment,e),U(K.$$.fragment,e),U(te.$$.fragment,e),U(se.$$.fragment,e),U(ne.$$.fragment,e),U(Me.$$.fragment,e),U(oe.$$.fragment,e),U(Ue.$$.fragment,e),U(we.$$.fragment,e),U(Je.$$.fragment,e),U(ue.$$.fragment,e),U(de.$$.fragment,e),U(he.$$.fragment,e),U(Ce.$$.fragment,e),U($e.$$.fragment,e),U(ke.$$.fragment,e),U(Be.$$.fragment,e),U(_e.$$.fragment,e),U(Fe.$$.fragment,e),U(Ze.$$.fragment,e),U(xe.$$.fragment,e),U(Ae.$$.fragment,e),U(Se.$$.fragment,e),U(Qe.$$.fragment,e),U(We.$$.fragment,e),U(Xe.$$.fragment,e),U(Pe.$$.fragment,e),El=!1},d(e){e&&(l(Oe),l(De),l(et),l(tt),l(lt),l(st),l(h),l(at),l(f),l(nt),l(it),l(C),l(rt),l(Mt),l(V),l(pt),l(ot),l(R),l(yt),l(k),l(Ut),l(c),l(mt),l(wt),l(Jt),l(_),l(Tt),l(ut),l(ct),l(G),l(bt),l(dt),l(jt),l(A),l(ht),l(ft),l(It),l(v),l(Ct),l(W),l(gt),l(X),l(Vt),l($t),l(H),l(Rt),l(kt),l(Bt),l(z),l(Nt),l(_t),l(D),l(Et),l(Ft),l(O),l(Gt),l(ee),l(Zt),l(xt),l(le),l(At),l(St),l(ae),l(Qt),l(vt),l(ie),l(Wt),l(re),l(Xt),l(qt),l(pe),l(Ht),l(Yt),l(ye),l(Lt),l(zt),l(me),l(Pt),l(Dt),l(Kt),l(Te),l(Ot),l(el),l(ce),l(tl),l(be),l(ll),l(sl),l(je),l(al),l(nl),l(fe),l(il),l(Ie),l(rl),l(Ml),l(ge),l(pl),l(Ve),l(ol),l(yl),l(Re),l(Ul),l(ml),l(wl),l(Ne),l(Jl),l(Tl),l(Ee),l(ul),l(cl),l(Ge),l(bl),l(dl),l(jl),l(hl),l(fl),l(Il),l(ve),l(Cl),l(gl),l(Vl),l(qe),l($l),l(He),l(Rl),l(Ye),l(kl),l(Le),l(Bl),l(ze),l(Nl),l(_l),l(Ke)),l(u),m(b,e),m(d,e),m(j,e),m(I,e),m(g,e),m($,e),m(B,e),m(N,e),m(E,e),m(F,e),m(Z,e),m(x,e),m(S,e),m(Q,e),m(q,e),m(Y,e),m(L,e),m(P,e),m(K,e),m(te,e),m(se,e),m(ne,e),m(Me,e),m(oe,e),m(Ue,e),m(we,e),m(Je,e),m(ue,e),m(de,e),m(he,e),m(Ce,e),m($e,e),m(ke,e),m(Be,e),m(_e,e),m(Fe,e),m(Ze,e),m(xe,e),m(Ae,e),m(Se,e),m(Qe,e),m(We,e),m(Xe,e),m(Pe,e)}}}const xs='{"title":"RAG backed by SQL and Jina Reranker v2","local":"rag-backed-by-sql-and-jina-reranker-v2","sections":[{"title":"How it Works","local":"how-it-works","sections":[],"depth":3},{"title":"The Database","local":"the-database","sections":[],"depth":3},{"title":"Software and Hardware Requirements","local":"software-and-hardware-requirements","sections":[],"depth":3},{"title":"Setting Up","local":"setting-up","sections":[{"title":"Install Requirements","local":"install-requirements","sections":[],"depth":3},{"title":"Download the Database","local":"download-the-database","sections":[],"depth":3},{"title":"Download and Run Jina Reranker v2","local":"download-and-run-jina-reranker-v2","sections":[],"depth":3},{"title":"Set up the Interface to Mistral Instruct","local":"set-up-the-interface-to-mistral-instruct","sections":[],"depth":3}],"depth":2},{"title":"Using SQL-Aware Jina Reranker v2","local":"using-sql-aware-jina-reranker-v2","sections":[],"depth":2},{"title":"Using Mistral Instruct to Generate SQL","local":"using-mistral-instruct-to-generate-sql","sections":[],"depth":2},{"title":"Running the SQL query","local":"running-the-sql-query","sections":[],"depth":2},{"title":"Getting a Natural Language Answer","local":"getting-a-natural-language-answer","sections":[],"depth":2},{"title":"Try it yourself","local":"try-it-yourself","sections":[],"depth":2},{"title":"Review and Conclusions","local":"review-and-conclusions","sections":[],"depth":2}],"depth":1}';function As(Gl){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qs extends ks{constructor(u){super(),Bs(this,u,As,Zs,Vs,{})}}export{qs as component};
