import{s as xi,n as Ui,o as Ji}from"../chunks/scheduler.1f027d5a.js";import{S as _i,i as Ii,e as n,s as i,c as m,h as Wi,a as o,d as s,b as a,f as pl,g as p,j as r,k as ft,q as ol,l as ct,m as l,n as u,t as h,o as f,p as c}from"../chunks/index.5cb6ce42.js";import{C as Zi}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as zi,C as d}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as M,E as Hi}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function qi(ul){let y,dt,ut,gt,j,yt,T,Mt,C,bt,$,hl='<em>Authored by: <a href="https://huggingface.co/jamarks" rel="nofollow">Jacob Marks</a></em>',wt,k,fl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_cover_image.jpg" alt="Art Analysis Cover Image"/>',vt,x,cl="Visual data like images is incredibly information-rich, but the unstructured nature of that data makes it difficult to analyze.",jt,U,dl='In this notebook, we’ll explore how to use multimodal embeddings and computed attributes to analyze artistic styles in images. We’ll use the <a href="https://huggingface.co/datasets/huggan/wikiart" rel="nofollow">WikiArt dataset</a> from 🤗 Hub, which we will load into FiftyOne for data analysis and visualization. We’ll dive into the data in a variety of ways:',Tt,J,gl='<li><p><strong>Image Similarity Search and Semantic Search</strong>: We’ll generate multimodal embeddings for the images in the dataset using a pre-trained <a href="https://huggingface.co/openai/clip-vit-base-patch32" rel="nofollow">CLIP</a> model from 🤗 Transformers and index the data to allow for unstructured searches.</p></li> <li><p><strong>Clustering and Visualization</strong>: We’ll cluster the images based on their artistic style using the embeddings and visualize the results using UMAP dimensionality reduction.</p></li> <li><p><strong>Uniqueness Analysis</strong>: We’ll use our embeddings to assign a uniqueness score to each image based on how similar it is to other images in the dataset.</p></li> <li><p><strong>Image Quality Analysis</strong>: We’ll compute image quality metrics like brightness, contrast, and saturation for each image and see how these metrics correlate with the artistic style of the images.</p></li>',Ct,_,$t,I,yl="To run this notebook, you’ll need to install the following libraries:",kt,W,xt,Z,Ml='To make downloads lightning-fast, install <a href="https://pypi.org/project/hf-transfer/" rel="nofollow">HF Transfer</a>:',Ut,z,Jt,H,bl="And enable by setting the environment variable <code>HF_HUB_ENABLE_HF_TRANSFER</code>:",_t,q,It,b,wl="<b>Note:</b> This notebook was tested with <code>transformers==4.40.0</code>, <code>huggingface_hub==0.22.2</code>, and <code>fiftyone==0.23.8</code>.",Wt,G,vl="Now let’s import the modules that we’ll need for this notebook:",Zt,L,zt,F,jl='We’ll start by loading the WikiArt dataset from 🤗 Hub into FiftyOne. This dataset can also be loaded through Hugging Face’s <code>datasets</code> library, but we’ll use <a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">FiftyOne’s 🤗 Hub integration</a> to get the data directly from the Datasets server. To make the computations fast, we’ll just download the first $1,000$ samples.',Ht,X,qt,R,Tl="Print out a summary of the dataset to see what it contains:",Gt,B,Lt,V,Cl=`Name:        wikiart
Media type:  image
Num samples: 1000
Persistent:  False
Tags:        []
Sample fields:
    id:       fiftyone.core.fields.ObjectIdField
    filepath: fiftyone.core.fields.StringField
    tags:     fiftyone.core.fields.ListField(fiftyone.core.fields.StringField)
    metadata: fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.metadata.ImageMetadata)
    artist:   fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    style:    fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    genre:    fiftyone.core.fields.EmbeddedDocumentField(fiftyone.core.labels.Classification)
    row_idx:  fiftyone.core.fields.IntField
`,Ft,A,$l='Visualize the dataset in the <a href="https://docs.voxel51.com/user_guide/app.html" rel="nofollow">FiftyOne App</a>:',Xt,P,Rt,N,kl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_wikiart_dataset.jpg" alt="WikiArt Dataset"/>',Bt,Y,xl="Let’s list out the names of the artists whose styles we’ll be analyzing:",Vt,E,At,S,Ul=`['Unknown Artist', 'albrecht-durer', 'boris-kustodiev', 'camille-pissarro', 'childe-hassam', 'claude-monet', 'edgar-degas', 'eugene-boudin', 'gustave-dore', 'ilya-repin', 'ivan-aivazovsky', 'ivan-shishkin', 'john-singer-sargent', 'marc-chagall', 'martiros-saryan', 'nicholas-roerich', 'pablo-picasso', 'paul-cezanne', 'pierre-auguste-renoir', 'pyotr-konchalovsky', 'raphael-kirchner', 'rembrandt', 'salvador-dali', 'vincent-van-gogh']
`,Pt,Q,Nt,O,Jl="When you find a piece of art that you like, it’s natural to want to find similar pieces. We can do this with vector embeddings! What’s more, by using multimodal embeddings, we will unlock the ability to find paintings that closely resemble a given text query, which could be a description of a painting or even a poem.",Yt,D,_l='Let’s generate multimodal embeddings for the images using a pre-trained CLIP Vision Transformer (ViT) model from 🤗 Transformers. Running <code>compute_similarity()</code> from the <a href="https://docs.voxel51.com/user_guide/brain.html" rel="nofollow">FiftyOne Brain</a> will compute these embeddings and use them to generate a similarity index on the dataset.',Et,K,St,ee,Il=`Computing embeddings...
 100% |███████████████| 1000/1000 [5.0m elapsed, 0s remaining, 3.3 samples/s]
`,Qt,g,rt,Wl="Alternatively, you could load the model directly from the 🤗 Transformers library and pass the model in directly:",rl,te,ml,mt,Zl='For a comprehensive guide to this and more, check out <a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library">FiftyOne’s 🤗 Transformers integration</a>.',Ot,se,zl="Refresh the FiftyOne App, select the checkbox for an image in the sample grid, and click the photo icon to see the most similar images in the dataset. On the backend, clicking this button triggers a query to the similarity index to find the most similar images to the selected image, based on the pre-computed embeddings, and displays them in the App.",Dt,le,Hl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_image_search.gif" alt="Image Similarity Search"/>',Kt,ie,ql="We can use this to see what art pieces are most similar to a given art piece. This can be useful for finding similar art pieces (to recommend to users or add to a collection) or getting inspiration for a new piece.",es,ae,Gl="But there’s more! Because CLIP is multimodal, we can also use it to perform semantic searches. This means we can search for images based on text queries. For example, we can search for “pastel trees” and see all the images in the dataset that are similar to that query. To do this, click on the search icon in the FiftyOne App and enter a text query:",ts,ne,Ll='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_semantic_search.gif" alt="Semantic Search"/>',ss,oe,Fl="Behind the scenes, the text is tokenized, embedded with CLIP’s text encoder, and then used to query the similarity index to find the most similar images in the dataset. This is a powerful way to search for images based on text queries and can be useful for finding images that match a particular theme or style. And this is not limited to CLIP; you can use any CLIP-like model from 🤗 Transformers that can generate embeddings for images and text!",ls,w,Xl='💡 For efficient vector search and indexing over large datasets, FiftyOne has native <a href="https://voxel51.com/vector-search">integrations with open source vector databases</a>.',is,re,as,me,Rl="By performing similarity and semantic searches, we can begin to interact with the data more effectively. But we can also take this a step further and add some unsupervised learning into the mix. This will help us identify artistic patterns in the WikiArt dataset, from stylistic, to topical, and even motifs that are hard to put into words.",ns,pe,Bl="We will do this in two ways:",os,ue,Vl="<li><strong>Dimensionality Reduction</strong>: We’ll use UMAP to reduce the dimensionality of the embeddings to 2D and visualize the data in a scatter plot. This will allow us to see how the images cluster based on their style, genre, and artist.</li> <li><strong>Clustering</strong>: We’ll use K-Means clustering to cluster the images based on their embeddings and see what groups emerge.</li>",rs,he,Al="For dimensionality reduction, we will run <code>compute_visualization()</code> from the FiftyOne Brain, passing in the previously computed embeddings. We specify <code>method=&quot;umap&quot;</code> to use UMAP for dimensionality reduction, but we could also use PCA or t-SNE:",ms,fe,ps,ce,Pl=`Generating visualization...
`,us,de,Nl="Now we can open a panel in the FiftyOne App, where we will see one 2D point for each image in the dataset. We can color the points by any field in the dataset, such as the artist or genre, to see how strongly these attributes are captured by our image features:",hs,ge,Yl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_visualize_embeddings.gif" alt="UMAP Visualization"/>',fs,ye,El='We can also run clustering on the embeddings to group similar images together — perhaps the dominant features of these works of art are not captured by the existing labels, or maybe there are distinct sub-genres that we want to identify. To cluster our data, we will need to download the <a href="https://github.com/jacobmarks/clustering-plugin" rel="nofollow">FiftyOne Clustering Plugin</a>:',cs,Me,ds,be,Sl="Refreshing the app again, we can then access the clustering functionality via an operator in the app. Hit the backtick key to open the operator list, type “cluster” and select the operator from the dropdown. This will open an interactive panel where we can specify the clustering algorithm, hyperparameters, and the field to cluster on. To keep it simple, we’ll use K-Means clustering with $10$ clusters.",gs,we,Ql="We can then visualize the clusters in the app and see how the images group together based on their embeddings:",ys,ve,Ol='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_clustering.gif" alt="K-means Clustering"/>',Ms,je,Dl="We can see that some of the clusters select for artist; others select for genre or style. Others are more abstract and may represent sub-genres or other groupings that are not immediately obvious from the data.",bs,Te,ws,Ce,Kl="One interesting question we can ask about our dataset is how <em>unique</em> each image is. This question is important for many applications, such as recommending similar images, detecting duplicates, or identifying outliers. In the context of art, how unique a painting is could be an important factor in determining its value.",vs,$e,ei="While there are a million ways to characterize uniqueness, our image embeddings allow us to quantitatively assign each sample a uniqueness score based on how similar it is to other samples in the dataset. Explicitly, the FiftyOne Brain’s <code>compute_uniqueness()</code> function looks at the distance between each sample’s embedding and its nearest neighbors, and computes a score between $0$ and $1$ based on this distance. A score of $0$ means the sample is nondescript or very similar to others, while a score of $1$ means the sample is very unique.",js,ke,Ts,xe,ti=`Computing uniqueness...
Uniqueness computation complete
`,Cs,Ue,si="We can then color by this in the embeddings panel, filter by uniqueness score, or even sort by it to see the most unique images in the dataset:",$s,Je,ks,_e,li='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_most_unique.jpg" alt="Most Unique Images"/>',xs,Ie,Us,We,ii='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_least_unique.jpg" alt="Least Unique Images"/>',Js,Ze,ai="Going a step further, we can also answer the question of which artist tends to produce the most unique works. We can compute the average uniqueness score for each artist across all of their works of art:",_s,ze,Is,He,ni=`Unknown Artist: 0.7932221632002723
boris-kustodiev: 0.7480731948424676
salvador-dali: 0.7368807620414014
raphael-kirchner: 0.7315448102204755
ilya-repin: 0.7204744626806383
marc-chagall: 0.7169373812321908
rembrandt: 0.715205220292227
martiros-saryan: 0.708560775790436
childe-hassam: 0.7018343391132756
edgar-degas: 0.699912746806587
albrecht-durer: 0.6969358680800216
john-singer-sargent: 0.6839955708720844
pablo-picasso: 0.6835137858302969
pyotr-konchalovsky: 0.6780653000855895
nicholas-roerich: 0.6676504687452387
ivan-aivazovsky: 0.6484361530090199
vincent-van-gogh: 0.6472004520699081
gustave-dore: 0.6307283287457358
pierre-auguste-renoir: 0.6271467146993583
paul-cezanne: 0.6251076007168186
eugene-boudin: 0.6103397516167454
camille-pissarro: 0.6046182609119615
claude-monet: 0.5998234558947573
ivan-shishkin: 0.589796389836674
`,Ws,qe,oi="It would seem that the artist with the most unique works in our dataset is Boris Kustodiev! Let’s take a look at some of his works:",Zs,Ge,zs,Le,ri='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_kustodiev_view.jpg" alt="Boris Kustodiev Artwork"/>',Hs,Fe,qs,Xe,mi="To round things out, let’s go back to the basics and analyze some core qualities of the images in our dataset. We’ll compute standard metrics like brightness, contrast, and saturation for each image and see how these metrics correlate with the artistic style and genre of the art pieces.",Gs,Re,pi='To run these analyses, we will need to download the <a href="https://github.com/jacobmarks/image-quality-issues" rel="nofollow">FiftyOne Image Quality Plugin</a>:',Ls,Be,Fs,Ve,ui="Refresh the app and open the operators list again. This time type <code>compute</code> and select one of the image quality operators. We’ll start with brightness:",Xs,Ae,hi='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_compute_brightness.gif" alt="Compute Brightness"/>',Rs,Pe,fi="When the operator finishes running, we will have a new field in our dataset that contains the brightness score for each image. We can then visualize this data in the app:",Bs,Ne,ci='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_brightness.gif" alt="Brightness"/>',Vs,Ye,di="We can also color by brightness, and even see how it correlates with other fields in the dataset like style:",As,Ee,gi='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_style_by_brightness.gif" alt="Style by Brightness"/>',Ps,Se,yi="Now do the same for contrast and saturation. Here are the results for saturation:",Ns,Qe,Mi='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/art_analysis_filter_by_saturation.jpg" alt="Filter by Saturation"/>',Ys,Oe,bi="Hopefully this illustrates how not everything boils down to applying deep neural networks to your data. Sometimes, simple metrics can be just as informative and can provide a different perspective on your data 🤓!",Es,v,wi='📚 For larger datasets, you may want to <a href="https://docs.voxel51.com/plugins/using_plugins.html#delegated-operations">delegate the operations</a> for later execution.',Ss,De,Qs,Ke,vi='In this notebook, we’ve explored how to use multimodal embeddings, unsupervised learning, and traditional image processing techniques to analyze artistic styles in images. We’ve seen how to perform image similarity and semantic searches, cluster images based on their style, analyze the uniqueness of images, and compute image quality metrics. These techniques can be applied to a wide range of visual datasets, from art collections to medical images to satellite imagery. Try <a href="https://docs.voxel51.com/integrations/huggingface.html#loading-datasets-from-the-hub" rel="nofollow">loading a different dataset from the Hugging Face Hub</a> and see what insights you can uncover!',Os,et,ji="If you want to go even further, here are some additional analyses you could try:",Ds,tt,Ti='<li><strong>Zero-Shot Classification</strong>: Use a pre-trained vision-language model from 🤗 Transformers to categorize images in the dataset by topic or subject, without any training data. Check out this <a href="https://docs.voxel51.com/tutorials/zero_shot_classification.html" rel="nofollow">Zero-Shot Classification tutorial</a> for more info.</li> <li><strong>Image Captioning</strong>: Use a pre-trained vision-language model from 🤗 Transformers to generate captions for the images in the dataset. Then use this for topic modeling or cluster artwork based on embeddings for these captions. Check out FiftyOne’s <a href="https://github.com/jacobmarks/fiftyone-image-captioning-plugin" rel="nofollow">Image Captioning Plugin</a> for more info.</li>',Ks,st,el,lt,Ci='<li><a href="https://docs.voxel51.com/integrations/huggingface.html#huggingface-hub" rel="nofollow">FiftyOne 🤝 🤗 Hub Integration</a></li> <li><a href="https://docs.voxel51.com/integrations/huggingface.html#transformers-library" rel="nofollow">FiftyOne 🤝 🤗 Transformers Integration</a></li> <li><a href="https://voxel51.com/vector-search/" rel="nofollow">FiftyOne Vector Search Integrations</a></li> <li><a href="https://docs.voxel51.com/tutorials/dimension_reduction.html" rel="nofollow">Visualizing Data with Dimensionality Reduction Techniques</a></li> <li><a href="https://docs.voxel51.com/tutorials/clustering.html" rel="nofollow">Clustering Images with Embeddings</a></li> <li><a href="https://docs.voxel51.com/tutorials/uniqueness.html" rel="nofollow">Exploring Image Uniqueness with FiftyOne</a></li>',tl,it,sl,at,$i='<a href="https://github.com/voxel51/fiftyone/" rel="nofollow">FiftyOne</a> is the leading open source toolkit for building high-quality datasets and computer vision models. With over 2M downloads, FiftyOne is trusted by developers and researchers across the globe.',ll,nt,ki='💪 The FiftyOne team welcomes contributions from the open source community! If you’re interested in contributing to FiftyOne, check out the <a href="https://github.com/voxel51/fiftyone/blob/develop/CONTRIBUTING.md" rel="nofollow">contributing guide</a>.',il,ot,al,ht,nl;return j=new zi({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/analyzing_art_with_hf_and_fiftyone.ipynb"}]}}),T=new Zi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new M({props:{title:"Analyzing Artistic Styles with Multimodal Embeddings",local:"analyzing-artistic-styles-with-multimodal-embeddings",headingTag:"h1"}}),_=new M({props:{title:"Let’s get started! 🚀",local:"lets-get-started-",headingTag:"h2"}}),W=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMHRyYW5zZm9ybWVycyUyMGh1Z2dpbmdmYWNlX2h1YiUyMGZpZnR5b25lJTIwdW1hcC1sZWFybg==",highlighted:"!pip install -U transformers huggingface_hub fiftyone umap-learn",wrap:!1}}),z=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGhmLXRyYW5zZmVy",highlighted:"pip install hf-transfer",wrap:!1}}),q=new d({props:{code:"aW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIySEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUyMiU1RCUyMCUzRCUyMCUyMjElMjI=",highlighted:`import os
os.environ[<span class="hljs-string">&quot;HF_HUB_ENABLE_HF_TRANSFER&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>`,wrap:!1}}),L=new d({props:{code:"aW1wb3J0JTIwZmlmdHlvbmUlMjBhcyUyMGZvJTIwJTIzJTIwYmFzZSUyMGxpYnJhcnklMjBhbmQlMjBhcHAlMEFpbXBvcnQlMjBmaWZ0eW9uZS56b28lMjBhcyUyMGZveiUyMCUyMyUyMHpvbyUyMGRhdGFzZXRzJTIwYW5kJTIwbW9kZWxzJTBBaW1wb3J0JTIwZmlmdHlvbmUuYnJhaW4lMjBhcyUyMGZvYiUyMCUyMyUyME1MJTIwcm91dGluZXMlMEFmcm9tJTIwZmlmdHlvbmUlMjBpbXBvcnQlMjBWaWV3RmllbGQlMjBhcyUyMEYlMjAlMjMlMjBmb3IlMjBkZWZpbmluZyUyMGN1c3RvbSUyMHZpZXdzJTBBaW1wb3J0JTIwZmlmdHlvbmUudXRpbHMuaHVnZ2luZ2ZhY2UlMjBhcyUyMGZvdWglMjAlMjMlMjBmb3IlMjBsb2FkaW5nJTIwZGF0YXNldHMlMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2U=",highlighted:`<span class="hljs-keyword">import</span> fiftyone <span class="hljs-keyword">as</span> fo <span class="hljs-comment"># base library and app</span>
<span class="hljs-keyword">import</span> fiftyone.zoo <span class="hljs-keyword">as</span> foz <span class="hljs-comment"># zoo datasets and models</span>
<span class="hljs-keyword">import</span> fiftyone.brain <span class="hljs-keyword">as</span> fob <span class="hljs-comment"># ML routines</span>
<span class="hljs-keyword">from</span> fiftyone <span class="hljs-keyword">import</span> ViewField <span class="hljs-keyword">as</span> F <span class="hljs-comment"># for defining custom views</span>
<span class="hljs-keyword">import</span> fiftyone.utils.huggingface <span class="hljs-keyword">as</span> fouh <span class="hljs-comment"># for loading datasets from Hugging Face</span>`,wrap:!1}}),X=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGZvdWgubG9hZF9mcm9tX2h1YiglMEElMjAlMjAlMjAlMjAlMjJodWdnYW4lMkZ3aWtpYXJ0JTIyJTJDJTIwJTIzJTIzJTIwcmVwb19pZCUwQSUyMCUyMCUyMCUyMGZvcm1hdCUzRCUyMnBhcnF1ZXQlMjIlMkMlMjAlMjMlMjMlMjBmb3IlMjBQYXJxdWV0JTIwZm9ybWF0JTBBJTIwJTIwJTIwJTIwY2xhc3NpZmljYXRpb25fZmllbGRzJTNEJTVCJTIyYXJ0aXN0JTIyJTJDJTIwJTIyc3R5bGUlMjIlMkMlMjAlMjJnZW5yZSUyMiU1RCUyQyUyMCUyMyUyMGNvbHVtbnMlMjB0byUyMHN0b3JlJTIwYXMlMjBjbGFzc2lmaWNhdGlvbiUyMGZpZWxkcyUwQSUyMCUyMCUyMCUyMG1heF9zYW1wbGVzJTNEMTAwMCUyQyUyMCUyMyUyMG51bWJlciUyMG9mJTIwc2FtcGxlcyUyMHRvJTIwbG9hZCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJ3aWtpYXJ0JTIyJTJDJTIwJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwZGF0YXNldCUyMGluJTIwRmlmdHlPbmUlMEEp",highlighted:`dataset = fouh.load_from_hub(
    <span class="hljs-string">&quot;huggan/wikiart&quot;</span>, <span class="hljs-comment">## repo_id</span>
    <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;parquet&quot;</span>, <span class="hljs-comment">## for Parquet format</span>
    classification_fields=[<span class="hljs-string">&quot;artist&quot;</span>, <span class="hljs-string">&quot;style&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>], <span class="hljs-comment"># columns to store as classification fields</span>
    max_samples=<span class="hljs-number">1000</span>, <span class="hljs-comment"># number of samples to load</span>
    name=<span class="hljs-string">&quot;wikiart&quot;</span>, <span class="hljs-comment"># name of the dataset in FiftyOne</span>
)`,wrap:!1}}),B=new d({props:{code:"cHJpbnQoZGF0YXNldCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset)',wrap:!1}}),P=new d({props:{code:"c2Vzc2lvbiUyMCUzRCUyMGZvLmxhdW5jaF9hcHAoZGF0YXNldCk=",highlighted:"session = fo.launch_app(dataset)",wrap:!1}}),E=new d({props:{code:"YXJ0aXN0cyUyMCUzRCUyMGRhdGFzZXQuZGlzdGluY3QoJTIyYXJ0aXN0LmxhYmVsJTIyKSUwQXByaW50KGFydGlzdHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>artists = dataset.distinct(<span class="hljs-string">&quot;artist.label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(artists)`,wrap:!1}}),Q=new M({props:{title:"Finding Similar Artwork",local:"finding-similar-artwork",headingTag:"h2"}}),K=new d({props:{code:"Zm9iLmNvbXB1dGVfc2ltaWxhcml0eSglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTIwJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24tdHJhbnNmb3JtZXItdG9yY2glMjIlMkMlMjAlMjMlMjMlMjB0eXBlJTIwb2YlMjBtb2RlbCUyMHRvJTIwbG9hZCUyMGZyb20lMjBtb2RlbCUyMHpvbyUwQSUyMCUyMCUyMCUyMG5hbWVfb3JfcGF0aCUzRCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gzMiUyMiUyQyUyMCUyMyUyMyUyMHJlcG9faWQlMjBvZiUyMGNoZWNrcG9pbnQlMEElMjAlMjAlMjAlMjBlbWJlZGRpbmdzJTNEJTIyY2xpcF9lbWJlZGRpbmdzJTIyJTJDJTIwJTIzJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwZmllbGQlMjB0byUyMHN0b3JlJTIwZW1iZWRkaW5ncyUwQSUyMCUyMCUyMCUyMGJyYWluX2tleSUzRCUyMmNsaXBfc2ltJTIyJTJDJTIwJTIzJTIzJTIwa2V5JTIwdG8lMjBzdG9yZSUyMHNpbWlsYXJpdHklMjBpbmRleCUyMGluZm8lMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjAlMjMlMjMlMjBiYXRjaCUyMHNpemUlMjBmb3IlMjBpbmZlcmVuY2UlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_similarity(
<span class="hljs-meta">... </span>    dataset, 
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;zero-shot-classification-transformer-torch&quot;</span>, <span class="hljs-comment">## type of model to load from model zoo</span>
<span class="hljs-meta">... </span>    name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>, <span class="hljs-comment">## repo_id of checkpoint</span>
<span class="hljs-meta">... </span>    embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>, <span class="hljs-comment">## name of the field to store embeddings</span>
<span class="hljs-meta">... </span>    brain_key=<span class="hljs-string">&quot;clip_sim&quot;</span>, <span class="hljs-comment">## key to store similarity index info</span>
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">32</span>, <span class="hljs-comment">## batch size for inference</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),te=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBNb2RlbCUwQW1vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMzIlMjIpJTBBZm9iLmNvbXB1dGVfc2ltaWxhcml0eSglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTJDJTIwJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlM0QlMjJjbGlwX2VtYmVkZGluZ3MlMjIlMkMlMjAlMjMlMjMlMjBuYW1lJTIwb2YlMjB0aGUlMjBmaWVsZCUyMHRvJTIwc3RvcmUlMjBlbWJlZGRpbmdzJTBBJTIwJTIwJTIwJTIwYnJhaW5fa2V5JTNEJTIyY2xpcF9zaW0lMjIlMjAlMjMlMjMlMjBrZXklMjB0byUyMHN0b3JlJTIwc2ltaWxhcml0eSUyMGluZGV4JTIwaW5mbyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPModel
model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)
fob.compute_similarity(
    dataset, 
    model=model,
    embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>, <span class="hljs-comment">## name of the field to store embeddings</span>
    brain_key=<span class="hljs-string">&quot;clip_sim&quot;</span> <span class="hljs-comment">## key to store similarity index info</span>
)`,wrap:!1}}),re=new M({props:{title:"Uncovering Artistic Motifs with Clustering and Visualization",local:"uncovering-artistic-motifs-with-clustering-and-visualization",headingTag:"h2"}}),fe=new d({props:{code:"Zm9iLmNvbXB1dGVfdmlzdWFsaXphdGlvbihkYXRhc2V0JTJDJTIwZW1iZWRkaW5ncyUzRCUyMmNsaXBfZW1iZWRkaW5ncyUyMiUyQyUyMG1ldGhvZCUzRCUyMnVtYXAlMjIlMkMlMjBicmFpbl9rZXklM0QlMjJjbGlwX3ZpcyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_visualization(dataset, embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>, method=<span class="hljs-string">&quot;umap&quot;</span>, brain_key=<span class="hljs-string">&quot;clip_vis&quot;</span>)',wrap:!1}}),Me=new d({props:{code:"IWZpZnR5b25lJTIwcGx1Z2lucyUyMGRvd25sb2FkJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFjb2JtYXJrcyUyRmNsdXN0ZXJpbmctcGx1Z2lu",highlighted:"!fiftyone plugins download https://github.com/jacobmarks/clustering-plugin",wrap:!1}}),Te=new M({props:{title:"Identifying the Most Unique Works of Art",local:"identifying-the-most-unique-works-of-art",headingTag:"h2"}}),ke=new d({props:{code:"Zm9iLmNvbXB1dGVfdW5pcXVlbmVzcyhkYXRhc2V0JTJDJTIwZW1iZWRkaW5ncyUzRCUyMmNsaXBfZW1iZWRkaW5ncyUyMiklMjAlMjMlMjBjb21wdXRlJTIwdW5pcXVlbmVzcyUyMHVzaW5nJTIwQ0xJUCUyMGVtYmVkZGluZ3M=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>fob.compute_uniqueness(dataset, embeddings=<span class="hljs-string">&quot;clip_embeddings&quot;</span>) <span class="hljs-comment"># compute uniqueness using CLIP embeddings</span>',wrap:!1}}),Je=new d({props:{code:"bW9zdF91bmlxdWVfdmlldyUyMCUzRCUyMGRhdGFzZXQuc29ydF9ieSglMjJ1bmlxdWVuZXNzJTIyJTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBc2Vzc2lvbi52aWV3JTIwJTNEJTIwbW9zdF91bmlxdWVfdmlldy52aWV3KCklMjAlMjMlMjBNb3N0JTIwdW5pcXVlJTIwaW1hZ2Vz",highlighted:`most_unique_view = dataset.sort_by(<span class="hljs-string">&quot;uniqueness&quot;</span>, reverse=<span class="hljs-literal">True</span>)
session.view = most_unique_view.view() <span class="hljs-comment"># Most unique images</span>`,wrap:!1}}),Ie=new d({props:{code:"bGVhc3RfdW5pcXVlX3ZpZXclMjAlM0QlMjBkYXRhc2V0LnNvcnRfYnkoJTIydW5pcXVlbmVzcyUyMiUyQyUyMHJldmVyc2UlM0RGYWxzZSklMEFzZXNzaW9uLnZpZXclMjAlM0QlMjBsZWFzdF91bmlxdWVfdmlldy52aWV3KCklMjAlMjMlMjBMZWFzdCUyMHVuaXF1ZSUyMGltYWdlcw==",highlighted:`least_unique_view = dataset.sort_by(<span class="hljs-string">&quot;uniqueness&quot;</span>, reverse=<span class="hljs-literal">False</span>)
session.view = least_unique_view.view() <span class="hljs-comment"># Least unique images</span>`,wrap:!1}}),ze=new d({props:{code:"YXJ0aXN0X3VuaXF1ZV9zY29yZXMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBhcnRpc3QlM0ElMjBkYXRhc2V0Lm1hdGNoKEYoJTIyYXJ0aXN0LmxhYmVsJTIyKSUyMCUzRCUzRCUyMGFydGlzdCkubWVhbiglMjJ1bmlxdWVuZXNzJTIyKSUwQSUyMCUyMCUyMCUyMGZvciUyMGFydGlzdCUyMGluJTIwYXJ0aXN0cyUwQSU3RCUwQSUwQXNvcnRlZF9hcnRpc3RzJTIwJTNEJTIwc29ydGVkKCUwQSUyMCUyMCUyMCUyMGFydGlzdF91bmlxdWVfc2NvcmVzJTJDJTIwa2V5JTNEYXJ0aXN0X3VuaXF1ZV9zY29yZXMuZ2V0JTJDJTIwcmV2ZXJzZSUzRFRydWUlMEEpJTBBJTBBZm9yJTIwYXJ0aXN0JTIwaW4lMjBzb3J0ZWRfYXJ0aXN0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JhcnRpc3QlN0QlM0ElMjAlN0JhcnRpc3RfdW5pcXVlX3Njb3JlcyU1QmFydGlzdCU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>artist_unique_scores = {
<span class="hljs-meta">... </span>    artist: dataset.<span class="hljs-keyword">match</span>(F(<span class="hljs-string">&quot;artist.label&quot;</span>) == artist).mean(<span class="hljs-string">&quot;uniqueness&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> artist <span class="hljs-keyword">in</span> artists
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_artists = <span class="hljs-built_in">sorted</span>(
<span class="hljs-meta">... </span>    artist_unique_scores, key=artist_unique_scores.get, reverse=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> artist <span class="hljs-keyword">in</span> sorted_artists:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{artist}</span>: <span class="hljs-subst">{artist_unique_scores[artist]}</span>&quot;</span>)`,wrap:!1}}),Ge=new d({props:{code:"a3VzdG9kaWV2X3ZpZXclMjAlM0QlMjBkYXRhc2V0Lm1hdGNoKEYoJTIyYXJ0aXN0LmxhYmVsJTIyKSUyMCUzRCUzRCUyMCUyMmJvcmlzLWt1c3RvZGlldiUyMiklMEFzZXNzaW9uLnZpZXclMjAlM0QlMjBrdXN0b2RpZXZfdmlldy52aWV3KCk=",highlighted:`kustodiev_view = dataset.<span class="hljs-keyword">match</span>(F(<span class="hljs-string">&quot;artist.label&quot;</span>) == <span class="hljs-string">&quot;boris-kustodiev&quot;</span>)
session.view = kustodiev_view.view()`,wrap:!1}}),Fe=new M({props:{title:"Characterizing Art with Visual Qualities",local:"characterizing-art-with-visual-qualities",headingTag:"h2"}}),Be=new d({props:{code:"IWZpZnR5b25lJTIwcGx1Z2lucyUyMGRvd25sb2FkJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFjb2JtYXJrcyUyRmltYWdlLXF1YWxpdHktaXNzdWVzJTJG",highlighted:"!fiftyone plugins download https://github.com/jacobmarks/image-quality-issues/",wrap:!1}}),De=new M({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),st=new M({props:{title:"📚 Resources",local:"-resources",headingTag:"h3"}}),it=new M({props:{title:"FiftyOne Open Source Project",local:"fiftyone-open-source-project",headingTag:"h2"}}),ot=new Hi({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/analyzing_art_with_hf_and_fiftyone.md"}}),{c(){y=n("meta"),dt=i(),ut=n("p"),gt=i(),m(j.$$.fragment),yt=i(),m(T.$$.fragment),Mt=i(),m(C.$$.fragment),bt=i(),$=n("p"),$.innerHTML=hl,wt=i(),k=n("p"),k.innerHTML=fl,vt=i(),x=n("p"),x.textContent=cl,jt=i(),U=n("p"),U.innerHTML=dl,Tt=i(),J=n("ul"),J.innerHTML=gl,Ct=i(),m(_.$$.fragment),$t=i(),I=n("p"),I.textContent=yl,kt=i(),m(W.$$.fragment),xt=i(),Z=n("p"),Z.innerHTML=Ml,Ut=i(),m(z.$$.fragment),Jt=i(),H=n("p"),H.innerHTML=bl,_t=i(),m(q.$$.fragment),It=i(),b=n("div"),b.innerHTML=wl,Wt=i(),G=n("p"),G.textContent=vl,Zt=i(),m(L.$$.fragment),zt=i(),F=n("p"),F.innerHTML=jl,Ht=i(),m(X.$$.fragment),qt=i(),R=n("p"),R.textContent=Tl,Gt=i(),m(B.$$.fragment),Lt=i(),V=n("pre"),V.textContent=Cl,Ft=i(),A=n("p"),A.innerHTML=$l,Xt=i(),m(P.$$.fragment),Rt=i(),N=n("p"),N.innerHTML=kl,Bt=i(),Y=n("p"),Y.textContent=xl,Vt=i(),m(E.$$.fragment),At=i(),S=n("pre"),S.textContent=Ul,Pt=i(),m(Q.$$.fragment),Nt=i(),O=n("p"),O.textContent=Jl,Yt=i(),D=n("p"),D.innerHTML=_l,Et=i(),m(K.$$.fragment),St=i(),ee=n("pre"),ee.textContent=Il,Qt=i(),g=n("div"),rt=n("p"),rt.textContent=Wl,rl=i(),m(te.$$.fragment),ml=i(),mt=n("p"),mt.innerHTML=Zl,Ot=i(),se=n("p"),se.textContent=zl,Dt=i(),le=n("p"),le.innerHTML=Hl,Kt=i(),ie=n("p"),ie.textContent=ql,es=i(),ae=n("p"),ae.textContent=Gl,ts=i(),ne=n("p"),ne.innerHTML=Ll,ss=i(),oe=n("p"),oe.textContent=Fl,ls=i(),w=n("div"),w.innerHTML=Xl,is=i(),m(re.$$.fragment),as=i(),me=n("p"),me.textContent=Rl,ns=i(),pe=n("p"),pe.textContent=Bl,os=i(),ue=n("ol"),ue.innerHTML=Vl,rs=i(),he=n("p"),he.innerHTML=Al,ms=i(),m(fe.$$.fragment),ps=i(),ce=n("pre"),ce.textContent=Pl,us=i(),de=n("p"),de.textContent=Nl,hs=i(),ge=n("p"),ge.innerHTML=Yl,fs=i(),ye=n("p"),ye.innerHTML=El,cs=i(),m(Me.$$.fragment),ds=i(),be=n("p"),be.textContent=Sl,gs=i(),we=n("p"),we.textContent=Ql,ys=i(),ve=n("p"),ve.innerHTML=Ol,Ms=i(),je=n("p"),je.textContent=Dl,bs=i(),m(Te.$$.fragment),ws=i(),Ce=n("p"),Ce.innerHTML=Kl,vs=i(),$e=n("p"),$e.innerHTML=ei,js=i(),m(ke.$$.fragment),Ts=i(),xe=n("pre"),xe.textContent=ti,Cs=i(),Ue=n("p"),Ue.textContent=si,$s=i(),m(Je.$$.fragment),ks=i(),_e=n("p"),_e.innerHTML=li,xs=i(),m(Ie.$$.fragment),Us=i(),We=n("p"),We.innerHTML=ii,Js=i(),Ze=n("p"),Ze.textContent=ai,_s=i(),m(ze.$$.fragment),Is=i(),He=n("pre"),He.textContent=ni,Ws=i(),qe=n("p"),qe.textContent=oi,Zs=i(),m(Ge.$$.fragment),zs=i(),Le=n("p"),Le.innerHTML=ri,Hs=i(),m(Fe.$$.fragment),qs=i(),Xe=n("p"),Xe.textContent=mi,Gs=i(),Re=n("p"),Re.innerHTML=pi,Ls=i(),m(Be.$$.fragment),Fs=i(),Ve=n("p"),Ve.innerHTML=ui,Xs=i(),Ae=n("p"),Ae.innerHTML=hi,Rs=i(),Pe=n("p"),Pe.textContent=fi,Bs=i(),Ne=n("p"),Ne.innerHTML=ci,Vs=i(),Ye=n("p"),Ye.textContent=di,As=i(),Ee=n("p"),Ee.innerHTML=gi,Ps=i(),Se=n("p"),Se.textContent=yi,Ns=i(),Qe=n("p"),Qe.innerHTML=Mi,Ys=i(),Oe=n("p"),Oe.textContent=bi,Es=i(),v=n("div"),v.innerHTML=wi,Ss=i(),m(De.$$.fragment),Qs=i(),Ke=n("p"),Ke.innerHTML=vi,Os=i(),et=n("p"),et.textContent=ji,Ds=i(),tt=n("ul"),tt.innerHTML=Ti,Ks=i(),m(st.$$.fragment),el=i(),lt=n("ul"),lt.innerHTML=Ci,tl=i(),m(it.$$.fragment),sl=i(),at=n("p"),at.innerHTML=$i,ll=i(),nt=n("p"),nt.innerHTML=ki,il=i(),m(ot.$$.fragment),al=i(),ht=n("p"),this.h()},l(e){const t=Wi("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),dt=a(e),ut=o(e,"P",{}),pl(ut).forEach(s),gt=a(e),p(j.$$.fragment,e),yt=a(e),p(T.$$.fragment,e),Mt=a(e),p(C.$$.fragment,e),bt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-c0uagn"&&($.innerHTML=hl),wt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1xzj7ip"&&(k.innerHTML=fl),vt=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1e7ek37"&&(x.textContent=cl),jt=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1iyj6t"&&(U.innerHTML=dl),Tt=a(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-1ag4oir"&&(J.innerHTML=gl),Ct=a(e),p(_.$$.fragment,e),$t=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1qmzeog"&&(I.textContent=yl),kt=a(e),p(W.$$.fragment,e),xt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-x4dwdl"&&(Z.innerHTML=Ml),Ut=a(e),p(z.$$.fragment,e),Jt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-m5ur8v"&&(H.innerHTML=bl),_t=a(e),p(q.$$.fragment,e),It=a(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-plk5pn"&&(b.innerHTML=wl),Wt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1o6b4mq"&&(G.textContent=vl),Zt=a(e),p(L.$$.fragment,e),zt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-12g0lsk"&&(F.innerHTML=jl),Ht=a(e),p(X.$$.fragment,e),qt=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-127sumy"&&(R.textContent=Tl),Gt=a(e),p(B.$$.fragment,e),Lt=a(e),V=o(e,"PRE",{"data-svelte-h":!0}),r(V)!=="svelte-1odavx8"&&(V.textContent=Cl),Ft=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-vuii1o"&&(A.innerHTML=$l),Xt=a(e),p(P.$$.fragment,e),Rt=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1cy8zue"&&(N.innerHTML=kl),Bt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1g82nj1"&&(Y.textContent=xl),Vt=a(e),p(E.$$.fragment,e),At=a(e),S=o(e,"PRE",{"data-svelte-h":!0}),r(S)!=="svelte-rh6f0n"&&(S.textContent=Ul),Pt=a(e),p(Q.$$.fragment,e),Nt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-n0vei3"&&(O.textContent=Jl),Yt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-suzdib"&&(D.innerHTML=_l),Et=a(e),p(K.$$.fragment,e),St=a(e),ee=o(e,"PRE",{"data-svelte-h":!0}),r(ee)!=="svelte-mmre29"&&(ee.textContent=Il),Qt=a(e),g=o(e,"DIV",{style:!0});var pt=pl(g);rt=o(pt,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1wi6mic"&&(rt.textContent=Wl),rl=a(pt),p(te.$$.fragment,pt),ml=a(pt),mt=o(pt,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-17feko9"&&(mt.innerHTML=Zl),pt.forEach(s),Ot=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1tpltlf"&&(se.textContent=zl),Dt=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-w8rr2"&&(le.innerHTML=Hl),Kt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-13ty9jr"&&(ie.textContent=ql),es=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1no06fa"&&(ae.textContent=Gl),ts=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-8ah19l"&&(ne.innerHTML=Ll),ss=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-5h5wzx"&&(oe.textContent=Fl),ls=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-18x11l8"&&(w.innerHTML=Xl),is=a(e),p(re.$$.fragment,e),as=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1r77spf"&&(me.textContent=Rl),ns=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1qcvkae"&&(pe.textContent=Bl),os=a(e),ue=o(e,"OL",{"data-svelte-h":!0}),r(ue)!=="svelte-5zfsmn"&&(ue.innerHTML=Vl),rs=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-8r9m0o"&&(he.innerHTML=Al),ms=a(e),p(fe.$$.fragment,e),ps=a(e),ce=o(e,"PRE",{"data-svelte-h":!0}),r(ce)!=="svelte-bhg5yk"&&(ce.textContent=Pl),us=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-87sjkb"&&(de.textContent=Nl),hs=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-guqvsc"&&(ge.innerHTML=Yl),fs=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-zs2wz8"&&(ye.innerHTML=El),cs=a(e),p(Me.$$.fragment,e),ds=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-s01bpa"&&(be.textContent=Sl),gs=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-18xo104"&&(we.textContent=Ql),ys=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1ccs8bm"&&(ve.innerHTML=Ol),Ms=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-li7lmx"&&(je.textContent=Dl),bs=a(e),p(Te.$$.fragment,e),ws=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-128i6zr"&&(Ce.innerHTML=Kl),vs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1k8dn9i"&&($e.innerHTML=ei),js=a(e),p(ke.$$.fragment,e),Ts=a(e),xe=o(e,"PRE",{"data-svelte-h":!0}),r(xe)!=="svelte-326il2"&&(xe.textContent=ti),Cs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1v04iac"&&(Ue.textContent=si),$s=a(e),p(Je.$$.fragment,e),ks=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1tb2ntu"&&(_e.innerHTML=li),xs=a(e),p(Ie.$$.fragment,e),Us=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1vqafg6"&&(We.innerHTML=ii),Js=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1wxy7d9"&&(Ze.textContent=ai),_s=a(e),p(ze.$$.fragment,e),Is=a(e),He=o(e,"PRE",{"data-svelte-h":!0}),r(He)!=="svelte-1n3row5"&&(He.textContent=ni),Ws=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1e52zeb"&&(qe.textContent=oi),Zs=a(e),p(Ge.$$.fragment,e),zs=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-13rc4gu"&&(Le.innerHTML=ri),Hs=a(e),p(Fe.$$.fragment,e),qs=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-9plt2b"&&(Xe.textContent=mi),Gs=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-43mgrp"&&(Re.innerHTML=pi),Ls=a(e),p(Be.$$.fragment,e),Fs=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-11qfm07"&&(Ve.innerHTML=ui),Xs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-ojjfuj"&&(Ae.innerHTML=hi),Rs=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-10dfbs0"&&(Pe.textContent=fi),Bs=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1tiw0lq"&&(Ne.innerHTML=ci),Vs=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-euuo6"&&(Ye.textContent=di),As=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-b6ayaa"&&(Ee.innerHTML=gi),Ps=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1wg7oa8"&&(Se.textContent=yi),Ns=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1aj2nhz"&&(Qe.innerHTML=Mi),Ys=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1f4cd5i"&&(Oe.textContent=bi),Es=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-126gsaj"&&(v.innerHTML=wi),Ss=a(e),p(De.$$.fragment,e),Qs=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-ov7mgi"&&(Ke.innerHTML=vi),Os=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-c0pn89"&&(et.textContent=ji),Ds=a(e),tt=o(e,"UL",{"data-svelte-h":!0}),r(tt)!=="svelte-ryyicq"&&(tt.innerHTML=Ti),Ks=a(e),p(st.$$.fragment,e),el=a(e),lt=o(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-752r11"&&(lt.innerHTML=Ci),tl=a(e),p(it.$$.fragment,e),sl=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-mmnfnj"&&(at.innerHTML=$i),ll=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1n8g4zz"&&(nt.innerHTML=ki),il=a(e),p(ot.$$.fragment,e),al=a(e),ht=o(e,"P",{}),pl(ht).forEach(s),this.h()},h(){ft(y,"name","hf:doc:metadata"),ft(y,"content",Gi),ft(b,"class","alert alert-block alert-info"),ol(g,"padding","10px"),ol(g,"border-left","5px solid #0078d4"),ol(g,"font-family","Arial, sans-serif"),ol(g,"margin","10px 0"),ft(w,"class","alert alert-block alert-info"),ft(v,"class","alert alert-block alert-info")},m(e,t){ct(document.head,y),l(e,dt,t),l(e,ut,t),l(e,gt,t),u(j,e,t),l(e,yt,t),u(T,e,t),l(e,Mt,t),u(C,e,t),l(e,bt,t),l(e,$,t),l(e,wt,t),l(e,k,t),l(e,vt,t),l(e,x,t),l(e,jt,t),l(e,U,t),l(e,Tt,t),l(e,J,t),l(e,Ct,t),u(_,e,t),l(e,$t,t),l(e,I,t),l(e,kt,t),u(W,e,t),l(e,xt,t),l(e,Z,t),l(e,Ut,t),u(z,e,t),l(e,Jt,t),l(e,H,t),l(e,_t,t),u(q,e,t),l(e,It,t),l(e,b,t),l(e,Wt,t),l(e,G,t),l(e,Zt,t),u(L,e,t),l(e,zt,t),l(e,F,t),l(e,Ht,t),u(X,e,t),l(e,qt,t),l(e,R,t),l(e,Gt,t),u(B,e,t),l(e,Lt,t),l(e,V,t),l(e,Ft,t),l(e,A,t),l(e,Xt,t),u(P,e,t),l(e,Rt,t),l(e,N,t),l(e,Bt,t),l(e,Y,t),l(e,Vt,t),u(E,e,t),l(e,At,t),l(e,S,t),l(e,Pt,t),u(Q,e,t),l(e,Nt,t),l(e,O,t),l(e,Yt,t),l(e,D,t),l(e,Et,t),u(K,e,t),l(e,St,t),l(e,ee,t),l(e,Qt,t),l(e,g,t),ct(g,rt),ct(g,rl),u(te,g,null),ct(g,ml),ct(g,mt),l(e,Ot,t),l(e,se,t),l(e,Dt,t),l(e,le,t),l(e,Kt,t),l(e,ie,t),l(e,es,t),l(e,ae,t),l(e,ts,t),l(e,ne,t),l(e,ss,t),l(e,oe,t),l(e,ls,t),l(e,w,t),l(e,is,t),u(re,e,t),l(e,as,t),l(e,me,t),l(e,ns,t),l(e,pe,t),l(e,os,t),l(e,ue,t),l(e,rs,t),l(e,he,t),l(e,ms,t),u(fe,e,t),l(e,ps,t),l(e,ce,t),l(e,us,t),l(e,de,t),l(e,hs,t),l(e,ge,t),l(e,fs,t),l(e,ye,t),l(e,cs,t),u(Me,e,t),l(e,ds,t),l(e,be,t),l(e,gs,t),l(e,we,t),l(e,ys,t),l(e,ve,t),l(e,Ms,t),l(e,je,t),l(e,bs,t),u(Te,e,t),l(e,ws,t),l(e,Ce,t),l(e,vs,t),l(e,$e,t),l(e,js,t),u(ke,e,t),l(e,Ts,t),l(e,xe,t),l(e,Cs,t),l(e,Ue,t),l(e,$s,t),u(Je,e,t),l(e,ks,t),l(e,_e,t),l(e,xs,t),u(Ie,e,t),l(e,Us,t),l(e,We,t),l(e,Js,t),l(e,Ze,t),l(e,_s,t),u(ze,e,t),l(e,Is,t),l(e,He,t),l(e,Ws,t),l(e,qe,t),l(e,Zs,t),u(Ge,e,t),l(e,zs,t),l(e,Le,t),l(e,Hs,t),u(Fe,e,t),l(e,qs,t),l(e,Xe,t),l(e,Gs,t),l(e,Re,t),l(e,Ls,t),u(Be,e,t),l(e,Fs,t),l(e,Ve,t),l(e,Xs,t),l(e,Ae,t),l(e,Rs,t),l(e,Pe,t),l(e,Bs,t),l(e,Ne,t),l(e,Vs,t),l(e,Ye,t),l(e,As,t),l(e,Ee,t),l(e,Ps,t),l(e,Se,t),l(e,Ns,t),l(e,Qe,t),l(e,Ys,t),l(e,Oe,t),l(e,Es,t),l(e,v,t),l(e,Ss,t),u(De,e,t),l(e,Qs,t),l(e,Ke,t),l(e,Os,t),l(e,et,t),l(e,Ds,t),l(e,tt,t),l(e,Ks,t),u(st,e,t),l(e,el,t),l(e,lt,t),l(e,tl,t),u(it,e,t),l(e,sl,t),l(e,at,t),l(e,ll,t),l(e,nt,t),l(e,il,t),u(ot,e,t),l(e,al,t),l(e,ht,t),nl=!0},p:Ui,i(e){nl||(h(j.$$.fragment,e),h(T.$$.fragment,e),h(C.$$.fragment,e),h(_.$$.fragment,e),h(W.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(X.$$.fragment,e),h(B.$$.fragment,e),h(P.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(re.$$.fragment,e),h(fe.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Ge.$$.fragment,e),h(Fe.$$.fragment,e),h(Be.$$.fragment,e),h(De.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(ot.$$.fragment,e),nl=!0)},o(e){f(j.$$.fragment,e),f(T.$$.fragment,e),f(C.$$.fragment,e),f(_.$$.fragment,e),f(W.$$.fragment,e),f(z.$$.fragment,e),f(q.$$.fragment,e),f(L.$$.fragment,e),f(X.$$.fragment,e),f(B.$$.fragment,e),f(P.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(re.$$.fragment,e),f(fe.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),f(ke.$$.fragment,e),f(Je.$$.fragment,e),f(Ie.$$.fragment,e),f(ze.$$.fragment,e),f(Ge.$$.fragment,e),f(Fe.$$.fragment,e),f(Be.$$.fragment,e),f(De.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(ot.$$.fragment,e),nl=!1},d(e){e&&(s(dt),s(ut),s(gt),s(yt),s(Mt),s(bt),s($),s(wt),s(k),s(vt),s(x),s(jt),s(U),s(Tt),s(J),s(Ct),s($t),s(I),s(kt),s(xt),s(Z),s(Ut),s(Jt),s(H),s(_t),s(It),s(b),s(Wt),s(G),s(Zt),s(zt),s(F),s(Ht),s(qt),s(R),s(Gt),s(Lt),s(V),s(Ft),s(A),s(Xt),s(Rt),s(N),s(Bt),s(Y),s(Vt),s(At),s(S),s(Pt),s(Nt),s(O),s(Yt),s(D),s(Et),s(St),s(ee),s(Qt),s(g),s(Ot),s(se),s(Dt),s(le),s(Kt),s(ie),s(es),s(ae),s(ts),s(ne),s(ss),s(oe),s(ls),s(w),s(is),s(as),s(me),s(ns),s(pe),s(os),s(ue),s(rs),s(he),s(ms),s(ps),s(ce),s(us),s(de),s(hs),s(ge),s(fs),s(ye),s(cs),s(ds),s(be),s(gs),s(we),s(ys),s(ve),s(Ms),s(je),s(bs),s(ws),s(Ce),s(vs),s($e),s(js),s(Ts),s(xe),s(Cs),s(Ue),s($s),s(ks),s(_e),s(xs),s(Us),s(We),s(Js),s(Ze),s(_s),s(Is),s(He),s(Ws),s(qe),s(Zs),s(zs),s(Le),s(Hs),s(qs),s(Xe),s(Gs),s(Re),s(Ls),s(Fs),s(Ve),s(Xs),s(Ae),s(Rs),s(Pe),s(Bs),s(Ne),s(Vs),s(Ye),s(As),s(Ee),s(Ps),s(Se),s(Ns),s(Qe),s(Ys),s(Oe),s(Es),s(v),s(Ss),s(Qs),s(Ke),s(Os),s(et),s(Ds),s(tt),s(Ks),s(el),s(lt),s(tl),s(sl),s(at),s(ll),s(nt),s(il),s(al),s(ht)),s(y),c(j,e),c(T,e),c(C,e),c(_,e),c(W,e),c(z,e),c(q,e),c(L,e),c(X,e),c(B,e),c(P,e),c(E,e),c(Q,e),c(K,e),c(te),c(re,e),c(fe,e),c(Me,e),c(Te,e),c(ke,e),c(Je,e),c(Ie,e),c(ze,e),c(Ge,e),c(Fe,e),c(Be,e),c(De,e),c(st,e),c(it,e),c(ot,e)}}}const Gi='{"title":"Analyzing Artistic Styles with Multimodal Embeddings","local":"analyzing-artistic-styles-with-multimodal-embeddings","sections":[{"title":"Let’s get started! 🚀","local":"lets-get-started-","sections":[],"depth":2},{"title":"Finding Similar Artwork","local":"finding-similar-artwork","sections":[],"depth":2},{"title":"Uncovering Artistic Motifs with Clustering and Visualization","local":"uncovering-artistic-motifs-with-clustering-and-visualization","sections":[],"depth":2},{"title":"Identifying the Most Unique Works of Art","local":"identifying-the-most-unique-works-of-art","sections":[],"depth":2},{"title":"Characterizing Art with Visual Qualities","local":"characterizing-art-with-visual-qualities","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[{"title":"📚 Resources","local":"-resources","sections":[],"depth":3}],"depth":2},{"title":"FiftyOne Open Source Project","local":"fiftyone-open-source-project","sections":[],"depth":2}],"depth":1}';function Li(ul){return Ji(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ai extends _i{constructor(y){super(),Ii(this,y,Li,qi,xi,{})}}export{Ai as component};
