import{s as Pt,a as Dt,n as Kt,o as Ot}from"../chunks/scheduler.1f027d5a.js";import{S as te,i as ee,e as M,s as a,c as o,h as le,a as u,d as l,b as n,f as Xt,g as i,j as d,k as L,l as se,m as s,n as r,t as p,o as m,p as c}from"../chunks/index.5cb6ce42.js";import{C as ae}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as ne,C as f}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as P,E as oe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function ie(Gt){let w,O,D,tt,J,et,h,lt,j,st,g,Rt='We will be using the SmolVLM-Instruct model from HuggingFaceTB to extract structured information from documents. We will run the VLM using the Hugging Face Transformers library and the <a href="https://github.com/dottxt-ai/outlines" rel="nofollow">Outlines library</a>, which facilitates structured generation based on limiting token sampling probabilities.',at,T,kt='<p>This approach is based on a <a href="https://dottxt-ai.github.io/outlines/latest/cookbook/atomic_caption/" rel="nofollow">Outlines tutorial</a>.</p>',nt,b,ot,U,Nt="First, let’s install the necessary libraries.",it,I,rt,$,Vt="Let’s continue with importing the necessary libraries.",pt,B,mt,Z,ct,C,Yt='We will start by initialising our model from <a href="https://huggingface.co/HuggingFaceTB/SmolVLM-Instruct" rel="nofollow">HuggingFaceTB/SmolVLM-Instruct</a>. Outlines expects us to pass in a model class and processor class, so we will make this example a bit more generic by creating a function that returns those. Alternatively, you could look at the model and tokenizer config within the <a href="https://huggingface.co/HuggingFaceTB/SmolVLM-Instruct/tree/main" rel="nofollow">Hub repo files</a>, and import those classes directly.',Mt,_,ut,x,dt,v,Ft='Now, we are going to define a function that will define how the output of our model will be structured. We will be using the <a href="https://huggingface.co/datasets/openbmb/RLAIF-V-Dataset" rel="nofollow">openbmb/RLAIF-V-Dataset</a>, which contains a set of images along with questions and their chosen and rejected reponses. This is an okay dataset but we want to create additional text-image-to-text data on top of the images to get our own structured dataset, and potentially fine-tune our model on it. We will use the model to generate a caption, a question and a simple quality tag for the image.',yt,W,wt,X,At="Now, let’s come up with an extraction prompt.",ft,G,Jt,R,Qt="Let’s load our image dataset.",ht,k,jt,N,qt="Now, let’s define a function that will extract the structured information from the image. We will format the prompt using the <code>apply_chat_template</code> method and pass it to the model along with the image after that.",gt,V,Tt,Y,Ht="Let’s now push our new dataset to the Hub.",bt,F,Ut,y,St,It,A,zt="The results are not perfect, but they are a good starting point to continue exploring with different models and prompts!",$t,Q,Bt,q,Et="We’ve seen how to extract structured information from documents using a vision language model. We can use similar extractive methods to extract structured information from documents, using somehting like <code>pdf2image</code> to convert the document to images and running information extraction on each image pdf of the page.",Zt,H,Ct,S,_t,z,Lt='<li>Take a look at the <a href="https://github.com/outlines-ai/outlines" rel="nofollow">Outlines</a> library for more information on how to use it. Explore the different methods and parameters.</li> <li>Explore extraction on your own usecase with your own model.</li> <li>Use a different method of extracting structured information from documents.</li>',xt,E,vt,K,Wt;return J=new ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/structured_generation_vision_language_models.ipynb"}]}}),h=new ae({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new P({props:{title:"Structured Generation from Images or Documents Using Vision Language Models",local:"structured-generation-from-images-or-documents-using-vision-language-models",headingTag:"h1"}}),b=new P({props:{title:"Dependencies and imports",local:"dependencies-and-imports",headingTag:"h2"}}),I=new f({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBvdXRsaW5lcyUyMHRyYW5zZm9ybWVycyUyMHRvcmNoJTIwZmxhc2gtYXR0biUyMGRhdGFzZXRzJTIwc2VudGVuY2VwaWVjZQ==",highlighted:"%pip install accelerate outlines transformers torch flash-attn datasets sentencepiece",wrap:!1}}),B=new f({props:{code:"aW1wb3J0JTIwb3V0bGluZXMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjBvdXRsaW5lcy5tb2RlbHMudHJhbnNmb3JtZXJzX3Zpc2lvbiUyMGltcG9ydCUyMHRyYW5zZm9ybWVyc192aXNpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0JTJDJTIwQXV0b1Byb2Nlc3NvciUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbA==",highlighted:`<span class="hljs-keyword">import</span> outlines
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> outlines.models.transformers_vision <span class="hljs-keyword">import</span> transformers_vision
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, AutoProcessor
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel`,wrap:!1}}),Z=new P({props:{title:"Initialising our model",local:"initialising-our-model",headingTag:"h2"}}),_=new f({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sVkxNLUluc3RydWN0JTIyJTBBJTBBJTBBZGVmJTIwZ2V0X21vZGVsX2FuZF9wcm9jZXNzb3JfY2xhc3MobW9kZWxfbmFtZSUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dC5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMjAlMjAlMjAlMjBwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUyMCUyMCUyMCUyMGNsYXNzZXMlMjAlM0QlMjBtb2RlbC5fX2NsYXNzX18lMkMlMjBwcm9jZXNzb3IuX19jbGFzc19fJTBBJTIwJTIwJTIwJTIwZGVsJTIwbW9kZWwlMkMlMjBwcm9jZXNzb3IlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjbGFzc2VzJTBBJTBBJTBBbW9kZWxfY2xhc3MlMkMlMjBwcm9jZXNzb3JfY2xhc3MlMjAlM0QlMjBnZXRfbW9kZWxfYW5kX3Byb2Nlc3Nvcl9jbGFzcyhtb2RlbF9uYW1lKSUwQSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFlbGlmJTIwdG9yY2guYmFja2VuZHMubXBzLmlzX2F2YWlsYWJsZSgpJTNBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwJTIybXBzJTIyJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMCUyMmNwdSUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwdHJhbnNmb3JtZXJzX3Zpc2lvbiglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY2xhc3MlM0Rtb2RlbF9jbGFzcyUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRGRldmljZSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMnRvcmNoX2R0eXBlJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlMkMlMjAlMjJkZXZpY2VfbWFwJTIyJTNBJTIwJTIyYXV0byUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3Nvcl9rd2FyZ3MlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzb3JfY2xhc3MlM0Rwcm9jZXNzb3JfY2xhc3MlMkMlMEEp",highlighted:`model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolVLM-Instruct&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_model_and_processor_class</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span></span>):
    model = AutoModelForImageTextToText.from_pretrained(model_name)
    processor = AutoProcessor.from_pretrained(model_name)
    classes = model.__class__, processor.__class__
    <span class="hljs-keyword">del</span> model, processor
    <span class="hljs-keyword">return</span> classes


model_class, processor_class = get_model_and_processor_class(model_name)

<span class="hljs-keyword">if</span> torch.cuda.is_available():
    device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-keyword">elif</span> torch.backends.mps.is_available():
    device = <span class="hljs-string">&quot;mps&quot;</span>
<span class="hljs-keyword">else</span>:
    device = <span class="hljs-string">&quot;cpu&quot;</span>

model = transformers_vision(
    model_name,
    model_class=model_class,
    device=device,
    model_kwargs={<span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;device_map&quot;</span>: <span class="hljs-string">&quot;auto&quot;</span>},
    processor_kwargs={<span class="hljs-string">&quot;device&quot;</span>: device},
    processor_class=processor_class,
)`,wrap:!1}}),x=new P({props:{title:"Structured Generation",local:"structured-generation",headingTag:"h2"}}),W=new f({props:{code:"Y2xhc3MlMjBJbWFnZURhdGEoQmFzZU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHF1YWxpdHklM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwc3RyJTBBJTBBc3RydWN0dXJlZF9nZW5lcmF0b3IlMjAlM0QlMjBvdXRsaW5lcy5nZW5lcmF0ZS5qc29uKG1vZGVsJTJDJTIwSW1hZ2VEYXRhKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageData</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    quality: <span class="hljs-built_in">str</span>
    description: <span class="hljs-built_in">str</span>
    question: <span class="hljs-built_in">str</span>

structured_generator = outlines.generate.json(model, ImageData)`,wrap:!1}}),G=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBWW91JTIwYXJlJTIwYW4lMjBpbWFnZSUyMGFuYWx5c2lzJTIwYXNzaXNhbnQuJTBBJTBBUHJvdmlkZSUyMGElMjBxdWFsaXR5JTIwdGFnJTJDJTIwYSUyMGRlc2NyaXB0aW9uJTIwYW5kJTIwYSUyMHF1ZXN0aW9uLiUwQSUwQVRoZSUyMHF1YWxpdHklMjBjYW4lMjBlaXRoZXIlMjBiZSUyMCUyMmdvb2QlMjIlMkMlMjAlMjJva2F5JTIyJTIwb3IlMjAlMjJiYWQlMjIuJTBBVGhlJTIwcXVlc3Rpb24lMjBzaG91bGQlMjBiZSUyMGNvbmNpc2UlMjBhbmQlMjBvYmplY3RpdmUuJTBBJTBBUmV0dXJuJTIweW91ciUyMHJlc3BvbnNlJTIwYXMlMjBhJTIwdmFsaWQlMjBKU09OJTIwb2JqZWN0LiUwQSUyMiUyMiUyMi5zdHJpcCgp",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;
You are an image analysis assisant.

Provide a quality tag, a description and a question.

The quality can either be &quot;good&quot;, &quot;okay&quot; or &quot;bad&quot;.
The question should be concise and objective.

Return your response as a valid JSON object.
&quot;&quot;&quot;</span>.strip()`,wrap:!1}}),k=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvcGVuYm1iJTJGUkxBSUYtVi1EYXRhc2V0JTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwJTVEJTIyKSUwQWRhdGFzZXQ=",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;openbmb/RLAIF-V-Dataset&quot;</span>, split=<span class="hljs-string">&quot;train[:10]&quot;</span>)
dataset`,wrap:!1}}),V=new f({props:{code:"ZGVmJTIwZXh0cmFjdChyb3cpJTNBJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjBwcm9tcHQlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjBmb3JtYXR0ZWRfcHJvbXB0JTIwJTNEJTIwbW9kZWwucHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHN0cnVjdHVyZWRfZ2VuZXJhdG9yKGZvcm1hdHRlZF9wcm9tcHQlMkMlMjAlNUJyb3clNUIlMjJpbWFnZSUyMiU1RCU1RCklMEElMjAlMjAlMjAlMjByb3clNUInc3ludGhldGljX3F1ZXN0aW9uJyU1RCUyMCUzRCUyMHJlc3VsdC5xdWVzdGlvbiUwQSUyMCUyMCUyMCUyMHJvdyU1QidzeW50aGV0aWNfZGVzY3JpcHRpb24nJTVEJTIwJTNEJTIwcmVzdWx0LmRlc2NyaXB0aW9uJTBBJTIwJTIwJTIwJTIwcm93JTVCJ3N5bnRoZXRpY19xdWFsaXR5JyU1RCUyMCUzRCUyMHJlc3VsdC5xdWFsaXR5JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcm93JTBBJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjBleHRyYWN0KHgpKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract</span>(<span class="hljs-params">row</span>):
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: prompt}],
        },
    ]

    formatted_prompt = model.processor.apply_chat_template(
        messages, add_generation_prompt=<span class="hljs-literal">True</span>
    )

    result = structured_generator(formatted_prompt, [row[<span class="hljs-string">&quot;image&quot;</span>]])
    row[<span class="hljs-string">&#x27;synthetic_question&#x27;</span>] = result.question
    row[<span class="hljs-string">&#x27;synthetic_description&#x27;</span>] = result.description
    row[<span class="hljs-string">&#x27;synthetic_quality&#x27;</span>] = result.quality
    <span class="hljs-keyword">return</span> row


dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: extract(x))
dataset`,wrap:!1}}),F=new f({props:{code:"ZGF0YXNldC5wdXNoX3RvX2h1YiglMjJkYXZpZGJlcmVuc3RlaW4xOTU3JTJGc3RydWN0dXJlZC1nZW5lcmF0aW9uLWluZm9ybWF0aW9uLWV4dHJhY3Rpb24tdmxtcy1vcGVuYm1iLVJMQUlGLVYtRGF0YXNldCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:'dataset.push_to_hub(<span class="hljs-string">&quot;davidberenstein1957/structured-generation-information-extraction-vlms-openbmb-RLAIF-V-Dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),Q=new P({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),H=new f({props:{code:"cGRmX3BhdGglMjAlM0QlMjAlMjJwYXRoJTJGdG8lMkZ5b3VyJTJGcGRmJTJGZmlsZS5wZGYlMjIlMEFwYWdlcyUyMCUzRCUyMGNvbnZlcnRfZnJvbV9wYXRoKHBkZl9wYXRoKSUwQWZvciUyMHBhZ2UlMjBpbiUyMHBhZ2VzJTNBJTBBJTIwJTIwJTIwJTIwZXh0cmFjdF9vYmplY3RzJTIwJTNEJTIwZXh0cmFjdF9vYmplY3RzKHBhZ2UlMkMlMjBwcm9tcHQp",highlighted:`pdf_path = <span class="hljs-string">&quot;path/to/your/pdf/file.pdf&quot;</span>
pages = convert_from_path(pdf_path)
<span class="hljs-keyword">for</span> page <span class="hljs-keyword">in</span> pages:
    extract_objects = extract_objects(page, prompt)`,wrap:!1}}),S=new P({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),E=new oe({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/structured_generation_vision_language_models.md"}}),{c(){w=M("meta"),O=a(),D=M("p"),tt=a(),o(J.$$.fragment),et=a(),o(h.$$.fragment),lt=a(),o(j.$$.fragment),st=a(),g=M("p"),g.innerHTML=Rt,at=a(),T=M("blockquote"),T.innerHTML=kt,nt=a(),o(b.$$.fragment),ot=a(),U=M("p"),U.textContent=Nt,it=a(),o(I.$$.fragment),rt=a(),$=M("p"),$.textContent=Vt,pt=a(),o(B.$$.fragment),mt=a(),o(Z.$$.fragment),ct=a(),C=M("p"),C.innerHTML=Yt,Mt=a(),o(_.$$.fragment),ut=a(),o(x.$$.fragment),dt=a(),v=M("p"),v.innerHTML=Ft,yt=a(),o(W.$$.fragment),wt=a(),X=M("p"),X.textContent=At,ft=a(),o(G.$$.fragment),Jt=a(),R=M("p"),R.textContent=Qt,ht=a(),o(k.$$.fragment),jt=a(),N=M("p"),N.innerHTML=qt,gt=a(),o(V.$$.fragment),Tt=a(),Y=M("p"),Y.textContent=Ht,bt=a(),o(F.$$.fragment),Ut=a(),y=M("iframe"),It=a(),A=M("p"),A.textContent=zt,$t=a(),o(Q.$$.fragment),Bt=a(),q=M("p"),q.innerHTML=Et,Zt=a(),o(H.$$.fragment),Ct=a(),o(S.$$.fragment),_t=a(),z=M("ul"),z.innerHTML=Lt,xt=a(),o(E.$$.fragment),vt=a(),K=M("p"),this.h()},l(t){const e=le("svelte-u9bgzb",document.head);w=u(e,"META",{name:!0,content:!0}),e.forEach(l),O=n(t),D=u(t,"P",{}),Xt(D).forEach(l),tt=n(t),i(J.$$.fragment,t),et=n(t),i(h.$$.fragment,t),lt=n(t),i(j.$$.fragment,t),st=n(t),g=u(t,"P",{"data-svelte-h":!0}),d(g)!=="svelte-84hlf0"&&(g.innerHTML=Rt),at=n(t),T=u(t,"BLOCKQUOTE",{"data-svelte-h":!0}),d(T)!=="svelte-wbtxpu"&&(T.innerHTML=kt),nt=n(t),i(b.$$.fragment,t),ot=n(t),U=u(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1vmewof"&&(U.textContent=Nt),it=n(t),i(I.$$.fragment,t),rt=n(t),$=u(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-1t87pq4"&&($.textContent=Vt),pt=n(t),i(B.$$.fragment,t),mt=n(t),i(Z.$$.fragment,t),ct=n(t),C=u(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1dcc9xp"&&(C.innerHTML=Yt),Mt=n(t),i(_.$$.fragment,t),ut=n(t),i(x.$$.fragment,t),dt=n(t),v=u(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-g2jocn"&&(v.innerHTML=Ft),yt=n(t),i(W.$$.fragment,t),wt=n(t),X=u(t,"P",{"data-svelte-h":!0}),d(X)!=="svelte-oswmnk"&&(X.textContent=At),ft=n(t),i(G.$$.fragment,t),Jt=n(t),R=u(t,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1cpu0q"&&(R.textContent=Qt),ht=n(t),i(k.$$.fragment,t),jt=n(t),N=u(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-ju559a"&&(N.innerHTML=qt),gt=n(t),i(V.$$.fragment,t),Tt=n(t),Y=u(t,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-9ozoda"&&(Y.textContent=Ht),bt=n(t),i(F.$$.fragment,t),Ut=n(t),y=u(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Xt(y).forEach(l),It=n(t),A=u(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-62ujx0"&&(A.textContent=zt),$t=n(t),i(Q.$$.fragment,t),Bt=n(t),q=u(t,"P",{"data-svelte-h":!0}),d(q)!=="svelte-a7iz4v"&&(q.innerHTML=Et),Zt=n(t),i(H.$$.fragment,t),Ct=n(t),i(S.$$.fragment,t),_t=n(t),z=u(t,"UL",{"data-svelte-h":!0}),d(z)!=="svelte-o8vxx7"&&(z.innerHTML=Lt),xt=n(t),i(E.$$.fragment,t),vt=n(t),K=u(t,"P",{}),Xt(K).forEach(l),this.h()},h(){L(w,"name","hf:doc:metadata"),L(w,"content",re),Dt(y.src,St="https://huggingface.co/datasets/davidberenstein1957/structured-generation-information-extraction-vlms-openbmb-RLAIF-V-Dataset/embed/viewer/default/train?row=3")||L(y,"src",St),L(y,"frameborder","0"),L(y,"width","100%"),L(y,"height","560px")},m(t,e){se(document.head,w),s(t,O,e),s(t,D,e),s(t,tt,e),r(J,t,e),s(t,et,e),r(h,t,e),s(t,lt,e),r(j,t,e),s(t,st,e),s(t,g,e),s(t,at,e),s(t,T,e),s(t,nt,e),r(b,t,e),s(t,ot,e),s(t,U,e),s(t,it,e),r(I,t,e),s(t,rt,e),s(t,$,e),s(t,pt,e),r(B,t,e),s(t,mt,e),r(Z,t,e),s(t,ct,e),s(t,C,e),s(t,Mt,e),r(_,t,e),s(t,ut,e),r(x,t,e),s(t,dt,e),s(t,v,e),s(t,yt,e),r(W,t,e),s(t,wt,e),s(t,X,e),s(t,ft,e),r(G,t,e),s(t,Jt,e),s(t,R,e),s(t,ht,e),r(k,t,e),s(t,jt,e),s(t,N,e),s(t,gt,e),r(V,t,e),s(t,Tt,e),s(t,Y,e),s(t,bt,e),r(F,t,e),s(t,Ut,e),s(t,y,e),s(t,It,e),s(t,A,e),s(t,$t,e),r(Q,t,e),s(t,Bt,e),s(t,q,e),s(t,Zt,e),r(H,t,e),s(t,Ct,e),r(S,t,e),s(t,_t,e),s(t,z,e),s(t,xt,e),r(E,t,e),s(t,vt,e),s(t,K,e),Wt=!0},p:Kt,i(t){Wt||(p(J.$$.fragment,t),p(h.$$.fragment,t),p(j.$$.fragment,t),p(b.$$.fragment,t),p(I.$$.fragment,t),p(B.$$.fragment,t),p(Z.$$.fragment,t),p(_.$$.fragment,t),p(x.$$.fragment,t),p(W.$$.fragment,t),p(G.$$.fragment,t),p(k.$$.fragment,t),p(V.$$.fragment,t),p(F.$$.fragment,t),p(Q.$$.fragment,t),p(H.$$.fragment,t),p(S.$$.fragment,t),p(E.$$.fragment,t),Wt=!0)},o(t){m(J.$$.fragment,t),m(h.$$.fragment,t),m(j.$$.fragment,t),m(b.$$.fragment,t),m(I.$$.fragment,t),m(B.$$.fragment,t),m(Z.$$.fragment,t),m(_.$$.fragment,t),m(x.$$.fragment,t),m(W.$$.fragment,t),m(G.$$.fragment,t),m(k.$$.fragment,t),m(V.$$.fragment,t),m(F.$$.fragment,t),m(Q.$$.fragment,t),m(H.$$.fragment,t),m(S.$$.fragment,t),m(E.$$.fragment,t),Wt=!1},d(t){t&&(l(O),l(D),l(tt),l(et),l(lt),l(st),l(g),l(at),l(T),l(nt),l(ot),l(U),l(it),l(rt),l($),l(pt),l(mt),l(ct),l(C),l(Mt),l(ut),l(dt),l(v),l(yt),l(wt),l(X),l(ft),l(Jt),l(R),l(ht),l(jt),l(N),l(gt),l(Tt),l(Y),l(bt),l(Ut),l(y),l(It),l(A),l($t),l(Bt),l(q),l(Zt),l(Ct),l(_t),l(z),l(xt),l(vt),l(K)),l(w),c(J,t),c(h,t),c(j,t),c(b,t),c(I,t),c(B,t),c(Z,t),c(_,t),c(x,t),c(W,t),c(G,t),c(k,t),c(V,t),c(F,t),c(Q,t),c(H,t),c(S,t),c(E,t)}}}const re='{"title":"Structured Generation from Images or Documents Using Vision Language Models","local":"structured-generation-from-images-or-documents-using-vision-language-models","sections":[{"title":"Dependencies and imports","local":"dependencies-and-imports","sections":[],"depth":2},{"title":"Initialising our model","local":"initialising-our-model","sections":[],"depth":2},{"title":"Structured Generation","local":"structured-generation","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function pe(Gt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends te{constructor(w){super(),ee(this,w,pe,ie,Pt,{})}}export{ye as component};
