import{s as us,n as ds,o as ws}from"../chunks/scheduler.1f027d5a.js";import{S as Js,i as js,e as i,s as n,c as r,h as Ts,a as o,d as s,b as a,f as Ie,g as c,j as p,k as Be,l as Us,m as l,n as M,t as h,o as m,p as y}from"../chunks/index.5cb6ce42.js";import{C as bs}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as gs,C as u}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as d,E as fs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Is(Et){let w,Ce,ge,Ze,J,Ge,j,ve,T,We,U,At='<em>Authored by: <a href="https://huggingface.co/andrewrreed" rel="nofollow">Andrew Reed</a></em>',ke,b,Nt="This notebook demonstrates how you can easily transition from OpenAI models to Open LLMs without needing to refactor any existing code.",_e,g,xt='<a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> now offers a <a href="https://huggingface.co/blog/tgi-messages-api" rel="nofollow">Messages API</a>, making it directly compatible with the OpenAI Chat Completion API. This means that any existing scripts that use OpenAI models (via the OpenAI client library or third-party tools like LangChain or LlamaIndex) can be directly swapped out to use any open LLM running on a TGI endpoint!',Re,f,Vt="This allows you to quickly test out and benefit from the numerous advantages offered by open models. Things like:",Ee,I,$t="<li>Complete control and transparency over models and data</li> <li>No more worrying about rate limits</li> <li>The ability to fully customize systems according to your specific needs</li>",Ae,B,Xt="In this notebook, we’ll show you how to:",Ne,C,St='<li><a href="#section_1">Create Inference Endpoint to Deploy a Model with TGI</a></li> <li><a href="#section_2">Query the Inference Endpoint with OpenAI Client Libraries</a></li> <li><a href="#section_3">Integrate the Endpoint with LangChain and LlamaIndex Workflows</a></li>',xe,Z,Qt="<strong>Let’s dive in!</strong>",Ve,G,$e,v,Ft="First we need to install dependencies and set an HF API key.",Xe,W,Se,k,Qe,Te,Fe,_,Ye,R,Yt='To get started, let’s deploy <a href="https://huggingface.co/NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO" rel="nofollow">Nous-Hermes-2-Mixtral-8x7B-DPO</a>, a fine-tuned Mixtral model, to Inference Endpoints using TGI.',qe,E,qt='We can deploy the model in just <a href="https://ui.endpoints.huggingface.co/new?vendor=aws&amp;repository=NousResearch%2FNous-Hermes-2-Mixtral-8x7B-DPO&amp;tgi_max_total_tokens=32000&amp;tgi=true&amp;tgi_max_input_length=1024&amp;task=text-generation&amp;instance_size=2xlarge&amp;tgi_max_batch_prefill_tokens=2048&amp;tgi_max_batch_total_tokens=1024000&amp;no_suggested_compute=true&amp;accelerator=gpu&amp;region=us-east-1" rel="nofollow">a few clicks from the UI</a>, or take advantage of the <code>huggingface_hub</code> Python library to programmatically create and manage Inference Endpoints.',He,A,Ht='We’ll use the Hub library here by specifing an endpoint name and model repository, along with the task of <code>text-generation</code>. In this example, we use a <code>protected</code> type so access to the deployed model will require a valid Hugging Face token. We also need to configure the hardware requirements like vendor, region, accelerator, instance type, and size. You can check out the list of available resource options <a href="https://api.endpoints.huggingface.cloud/#get-/v2/provider" rel="nofollow">using this API call</a>, and view recommended configurations for select models in the catalog <a href="https://ui.endpoints.huggingface.co/catalog" rel="nofollow">here</a>.',Le,N,Lt='<em>Note: You may need to request a quota upgrade by sending an email to <a href="mailto:api-enterprise@huggingface.co">api-enterprise@huggingface.co</a></em>',ze,x,Pe,V,zt=`running
`,Oe,$,Pt="It will take a few minutes for our deployment to spin up. We can use the <code>.wait()</code> utility to block the running thread until the endpoint reaches a final “running” state. Once running, we can confirm its status and take it for a spin via the UI Playground:",De,X,Ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/messages-api/endpoint-overview.png" alt="IE UI Overview"/>',Ke,S,Dt="Great, we now have a working endpoint!",et,Q,Kt='<em>Note: When deploying with <code>huggingface_hub</code>, your endpoint will scale-to-zero after 15 minutes of idle time by default to optimize cost during periods of inactivity. Check out <a href="https://huggingface.co/docs/huggingface_hub/guides/inference_endpoints" rel="nofollow">the Hub Python Library documentation</a> to see all the functionality available for managing your endpoint lifecycle.</em>',tt,Ue,st,F,lt,Y,es="As mentioned above, since our model is hosted with TGI it now supports a Messages API meaning we can query it directly using the familiar OpenAI client libraries.",nt,q,at,H,ts='The example below shows how to make this transition using the <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI Python Library</a>. Simply replace the <code>&lt;ENDPOINT_URL&gt;</code> with your endpoint URL (be sure to include the <code>v1/</code> the suffix) and populate the <code>&lt;HF_API_KEY&gt;</code> field with a valid Hugging Face user token. The <code>&lt;ENDPOINT_URL&gt;</code> can be gathered from Inference Endpoints UI, or from the endpoint object we created above with <code>endpoint.url</code>.',it,L,ss="We can then use the client as usual, passing a list of messages to stream responses from our Inference Endpoint.",ot,z,pt,P,ls=`Open-source software is important due to a number of reasons, including:

1. Collaboration: The collaborative nature of open-source software allows developers from around the world to work together, share their ideas and improve the code. This often results in faster progress and better software.

2. Transparency: With open-source software, the code is publicly available, making it easy to see exactly how the software functions, and allowing users to determine if there are any security vulnerabilities.

3. Customization: Being able to access the code also allows users to customize the software to better suit their needs. This makes open-source software incredibly versatile, as users can tweak it to suit their specific use case.

4. Quality: Open-source software is often developed by large communities of dedicated developers, who work together to improve the software. This results in a higher level of quality than might be found in proprietary software.

5. Cost: Open-source software is often provided free of charge, which makes it accessible to a wider range of users. This can be especially important for organizations with limited budgets for software.

6. Shared Benefit: By sharing the code of open-source software, everyone can benefit from the hard work of the developers. This contributes to the overall advancement of technology, as users and developers work together to improve and build upon the software.

In summary, open-source software provides a collaborative platform that leads to high-quality, customizable, and transparent software, all available at little or no cost, benefiting both individuals and the technology community as a whole.<|im_end|>
`,rt,O,ns='Behind the scenes, TGI’s Messages API automatically converts the list of messages into the model’s required instruction format using its <a href="https://huggingface.co/docs/transformers/chat_templating" rel="nofollow">chat template</a>.',ct,D,as="<em>Note: Certain OpenAI features, like function calling, are not compatible with TGI. Currently, the Messages API supports the following chat completion parameters: <code>stream</code>, <code>max_new_tokens</code>, <code>frequency_penalty</code>, <code>logprobs</code>, <code>seed</code>, <code>temperature</code>, and <code>top_p</code>.</em>",Mt,K,ht,ee,is='Here’s the same streaming example above, but using the <a href="https://github.com/openai/openai-node" rel="nofollow">OpenAI Javascript/Typescript Library</a>.',mt,te,yt,be,ut,se,dt,le,os="Now, let’s see how to use this newly created endpoint with popular RAG frameworks like LangChain and LlamaIndex.",wt,ne,Jt,ae,ps='To use it in <a href="https://python.langchain.com/docs/get_started/introduction" rel="nofollow">LangChain</a>, simply create an instance of <code>ChatOpenAI</code> and pass your <code>&lt;ENDPOINT_URL&gt;</code> and <code>&lt;HF_API_TOKEN&gt;</code> as follows:',jt,ie,Tt,oe,rs="We’re able to directly leverage the same <code>ChatOpenAI</code> class that we would have used with the OpenAI models. This allows all previous code to work with our endpoint by changing just one line of code.",Ut,pe,cs="Let’s now use our Mixtral model in a simple RAG pipeline to answer a question over the contents of a HF blog post.",bt,re,gt,ce,ft,Me,Ms='Similarly, you can also use a TGI endpoint in <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex</a>. We’ll use the <code>OpenAILike</code> class, and instantiate it by configuring some additional arguments (i.e. <code>is_local</code>, <code>is_function_calling_model</code>, <code>is_chat_model</code>, <code>context_window</code>).',It,he,hs="<em>Note: that the context window argument should match the value previously set for <code>MAX_TOTAL_TOKENS</code> of your endpoint.</em>",Bt,me,Ct,ye,ms="We can now use it in a similar RAG pipeline. Keep in mind that the previous choice of <code>MAX_INPUT_LENGTH</code> in your Inference Endpoint will directly influence the number of retrieved chunk (<code>similarity_top_k</code>) the model can process.",Zt,ue,Gt,de,vt,we,ys="After you are done with your endpoint, you can either pause or delete it. This step can be completed via the UI, or programmatically like follows.",Wt,Je,kt,je,_t,fe,Rt;return J=new gs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/tgi_messages_api_demo.ipynb"}]}}),j=new bs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new d({props:{title:"Migrating from OpenAI to Open LLMs Using TGI’s Messages API",local:"migrating-from-openai-to-open-llms-using-tgis-messages-api",headingTag:"h1"}}),G=new d({props:{title:"Setup",local:"setup",headingTag:"h2"}}),W=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtcSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBsYW5nY2hhaW5odWIlMjBsYW5nY2hhaW4tb3BlbmFpJTIwbGxhbWEtaW5kZXglMjBjaHJvbWFkYiUyMGJzNCUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMHRvcmNoJTIwdG9yY2h2aXNpb24lMjB0b3JjaGF1ZGlvJTIwbGxhbWEtaW5kZXgtbGxtcy1vcGVuYWktbGlrZSUyMGxsYW1hLWluZGV4LWVtYmVkZGluZ3MtaHVnZ2luZ2ZhY2U=",highlighted:"!pip install --upgrade -q huggingface_hub langchain langchain-community langchainhub langchain-openai llama-index chromadb bs4 sentence_transformers torch torchvision torchaudio llama-index-llms-openai-like llama-index-embeddings-huggingface",wrap:!1}}),k=new u({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnZXRwYXNzJTBBJTBBJTIzJTIwZW50ZXIlMjBBUEklMjBrZXklMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjBIRl9BUElfS0VZJTIwJTNEJTIwZ2V0cGFzcy5nZXRwYXNzKCk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> getpass

<span class="hljs-comment"># enter API key</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = HF_API_KEY = getpass.getpass()`,wrap:!1}}),_=new d({props:{title:"1. Create an Inference Endpoint",local:"1-create-an-inference-endpoint",headingTag:"h2"}}),x=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybm91cy1oZXJtZXMtMi1taXh0cmFsLTh4N2ItZGVtbyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJOb3VzUmVzZWFyY2glMkZOb3VzLUhlcm1lcy0yLU1peHRyYWwtOHg3Qi1EUE8lMjIlMkMlMEElMjAlMjAlMjAlMjBmcmFtZXdvcmslM0QlMjJweXRvcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTNEJTIyZ3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVuZG9yJTNEJTIyYXdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVnaW9uJTNEJTIydXMtZWFzdC0xJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnByb3RlY3RlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QlMjJwNGRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfSU5QVVRfTEVOR1RIJTIyJTNBJTIwJTIyNDA5NiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9CQVRDSF9QUkVGSUxMX1RPS0VOUyUyMiUzQSUyMCUyMjQwOTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMzIwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTAyNDAwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0FzaGEtMTczNDU0MCUyMiUyQyUyMCUyMCUyMyUyMG11c3QlMjBiZSUyMCUzRSUzRCUyMDEuNC4wJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKSUwQSUwQWVuZHBvaW50LndhaXQoKSUwQXByaW50KGVuZHBvaW50LnN0YXR1cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;nous-hermes-2-mixtral-8x7b-demo&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;p4de&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;2xlarge&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;32000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:sha-1734540&quot;</span>,  <span class="hljs-comment"># must be &gt;= 1.4.0</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(endpoint.status)`,wrap:!1}}),F=new d({props:{title:"2. Query the Inference Endpoint with OpenAI Client Libraries",local:"2-query-the-inference-endpoint-with-openai-client-libraries",headingTag:"h2"}}),q=new d({props:{title:"With the Python client",local:"with-the-python-client",headingTag:"h3"}}),z=new u({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQUJBU0VfVVJMJTIwJTNEJTIwZW5kcG9pbnQudXJsJTBBJTBBJTIzJTIwaW5pdCUyMHRoZSUyMGNsaWVudCUyMGJ1dCUyMHBvaW50JTIwaXQlMjB0byUyMFRHSSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRG9zLnBhdGguam9pbihCQVNFX1VSTCUyQyUyMCUyMnYxJTJGJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBKSUwQWNoYXRfY29tcGxldGlvbiUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDUwMCUyQyUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-meta">&gt;&gt;&gt; </span>BASE_URL = endpoint.url

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init the client but point it to TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = OpenAI(
<span class="hljs-meta">... </span>    base_url=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
<span class="hljs-meta">... </span>    api_key=HF_API_KEY,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>chat_completion = client.chat.completions.create(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tgi&quot;</span>,
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span>},
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    stream=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),K=new d({props:{title:"With the JavaScript client",local:"with-the-javascript-client",headingTag:"h3"}}),te=new u({props:{code:"aW1wb3J0JTIwT3BlbkFJJTIwZnJvbSUyMCUyMm9wZW5haSUyMiUzQiUwQSUwQWNvbnN0JTIwb3BlbmFpJTIwJTNEJTIwbmV3JTIwT3BlbkFJKCU3QiUwQSUyMCUyMGJhc2VVUkwlM0ElMjAlMjIlM0NFTkRQT0lOVF9VUkwlM0UlMjIlMjAlMkIlMjAlMjIlMkZ2MSUyRiUyMiUyQyUyMCUyRiUyRiUyMHJlcGxhY2UlMjB3aXRoJTIweW91ciUyMGVuZHBvaW50JTIwdXJsJTBBJTIwJTIwYXBpS2V5JTNBJTIwJTIyJTNDSEZfQVBJX1RPS0VOJTNFJTIyJTJDJTIwJTJGJTJGJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwdG9rZW4lMEElN0QpJTNCJTBBJTBBYXN5bmMlMjBmdW5jdGlvbiUyMG1haW4oKSUyMCU3QiUwQSUyMCUyMGNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwYXdhaXQlMjBvcGVuYWkuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTdCJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMHJvbGUlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTIwJTIwZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKGNodW5rLmNob2ljZXMlNUIwJTVEJTNGLmRlbHRhJTNGLmNvbnRlbnQlMjAlN0MlN0MlMjAlMjIlMjIpJTNCJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBbWFpbigpJTNC",highlighted:`<span class="hljs-keyword">import</span> <span class="hljs-title class_">OpenAI</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;openai&quot;</span>;

<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">OpenAI</span>({
  <span class="hljs-attr">baseURL</span>: <span class="hljs-string">&quot;&lt;ENDPOINT_URL&gt;&quot;</span> + <span class="hljs-string">&quot;/v1/&quot;</span>, <span class="hljs-comment">// replace with your endpoint url</span>
  <span class="hljs-attr">apiKey</span>: <span class="hljs-string">&quot;&lt;HF_API_TOKEN&gt;&quot;</span>, <span class="hljs-comment">// replace with your token</span>
});

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">main</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">const</span> stream = <span class="hljs-keyword">await</span> openai.<span class="hljs-property">chat</span>.<span class="hljs-property">completions</span>.<span class="hljs-title function_">create</span>({
    <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
    <span class="hljs-attr">messages</span>: [
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span> },
    ],
    <span class="hljs-attr">stream</span>: <span class="hljs-literal">true</span>,
    <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  });
  <span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>?.<span class="hljs-property">content</span> || <span class="hljs-string">&quot;&quot;</span>);
  }
}

<span class="hljs-title function_">main</span>();`,wrap:!1}}),se=new d({props:{title:"3. Integrate with LangChain and LlamaIndex",local:"3-integrate-with-langchain-and-llamaindex",headingTag:"h2"}}),ne=new d({props:{title:"How to use with LangChain",local:"how-to-use-with-langchain",headingTag:"h3"}}),ie=new u({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBJTBBbGxtJTIwJTNEJTIwQ2hhdE9wZW5BSSglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9iYXNlJTNEb3MucGF0aC5qb2luKEJBU0VfVVJMJTJDJTIwJTIydjElMkYlMjIpJTJDJTBBKSUwQWxsbS5pbnZva2UoJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

llm = ChatOpenAI(
    model_name=<span class="hljs-string">&quot;tgi&quot;</span>,
    openai_api_key=HF_API_KEY,
    openai_api_base=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
)
llm.invoke(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),re=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain <span class="hljs-keyword">import</span> hub
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> WebBaseLoader
<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnableParallel
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-comment"># Load, chunk and index the contents of the blog</span>
loader = WebBaseLoader(
    web_paths=(<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>,),
)
docs = loader.load()

<span class="hljs-comment"># declare an HF embedding model</span>
hf_embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">200</span>)
splits = text_splitter.split_documents(docs)
vectorstore = Chroma.from_documents(documents=splits, embedding=hf_embeddings)

<span class="hljs-comment"># Retrieve and generate using the relevant snippets of the blog</span>
retriever = vectorstore.as_retriever()
prompt = hub.pull(<span class="hljs-string">&quot;rlm/rag-prompt&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_docs</span>(<span class="hljs-params">docs</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs)


rag_chain_from_docs = (
    RunnablePassthrough.assign(context=(<span class="hljs-keyword">lambda</span> x: format_docs(x[<span class="hljs-string">&quot;context&quot;</span>])))
    | prompt
    | llm
    | StrOutputParser()
)

rag_chain_with_source = RunnableParallel(
    {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}
).assign(answer=rag_chain_from_docs)

rag_chain_with_source.invoke(
    <span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>
)`,wrap:!1}}),ce=new d({props:{title:"How to use with LlamaIndex",local:"how-to-use-with-llamaindex",headingTag:"h3"}}),me=new u({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMub3BlbmFpX2xpa2UlMjBpbXBvcnQlMjBPcGVuQUlMaWtlJTBBJTBBbGxtJTIwJTNEJTIwT3BlbkFJTGlrZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0RCQVNFX1VSTCUyMCUyQiUyMCUyMiUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfY2hhdF9tb2RlbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBpc19sb2NhbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwaXNfZnVuY3Rpb25fY2FsbGluZ19tb2RlbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF93aW5kb3clM0Q0MDk2JTJDJTBBKSUwQSUwQWxsbS5jb21wbGV0ZSglMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.openai_like <span class="hljs-keyword">import</span> OpenAILike

llm = OpenAILike(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    api_key=HF_API_KEY,
    api_base=BASE_URL + <span class="hljs-string">&quot;/v1/&quot;</span>,
    is_chat_model=<span class="hljs-literal">True</span>,
    is_local=<span class="hljs-literal">False</span>,
    is_function_calling_model=<span class="hljs-literal">False</span>,
    context_window=<span class="hljs-number">4096</span>,
)

llm.complete(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),ue=new u({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTJDJTIwZG93bmxvYWRfbG9hZGVyJTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQWZyb20lMjBsbGFtYV9pbmRleC5jb3JlLnF1ZXJ5X2VuZ2luZSUyMGltcG9ydCUyMENpdGF0aW9uUXVlcnlFbmdpbmUlMEElMEFTaW1wbGVXZWJQYWdlUmVhZGVyJTIwJTNEJTIwZG93bmxvYWRfbG9hZGVyKCUyMlNpbXBsZVdlYlBhZ2VSZWFkZXIlMjIpJTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwU2ltcGxlV2ViUGFnZVJlYWRlcihodG1sX3RvX3RleHQlM0RUcnVlKS5sb2FkX2RhdGEoJTBBJTIwJTIwJTIwJTIwJTVCJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmJsb2clMkZvcGVuLXNvdXJjZS1sbG1zLWFzLWFnZW50cyUyMiU1RCUwQSklMEElMEElMjMlMjBMb2FkJTIwZW1iZWRkaW5nJTIwbW9kZWwlMEFlbWJlZF9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWxhcmdlLWVuLXYxLjUlMjIpJTBBJTBBJTIzJTIwUGFzcyUyMExMTSUyMHRvJTIwcGlwZWxpbmUlMEFpbmRleCUyMCUzRCUyMFZlY3RvclN0b3JlSW5kZXguZnJvbV9kb2N1bWVudHMoJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzJTJDJTIwZW1iZWRfbW9kZWwlM0RlbWJlZF9tb2RlbCUyQyUyMHNob3dfcHJvZ3Jlc3MlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMFF1ZXJ5JTIwdGhlJTIwaW5kZXglMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBDaXRhdGlvblF1ZXJ5RW5naW5lLmZyb21fYXJncyglMEElMjAlMjAlMjAlMjBpbmRleCUyQyUwQSUyMCUyMCUyMCUyMHNpbWlsYXJpdHlfdG9wX2slM0QyJTJDJTBBKSUwQXJlc3BvbnNlJTIwJTNEJTIwcXVlcnlfZW5naW5lLnF1ZXJ5KCUwQSUyMCUyMCUyMCUyMCUyMkFjY29yZGluZyUyMHRvJTIwdGhpcyUyMGFydGljbGUlMjB3aGljaCUyMG9wZW4tc291cmNlJTIwbW9kZWwlMjBpcyUyMHRoZSUyMGJlc3QlMjBmb3IlMjBhbiUyMGFnZW50JTIwYmVoYXZpb3VyJTNGJTIyJTBBKSUwQSUwQXJlc3BvbnNlLnJlc3BvbnNl",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex, download_loader
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.core.query_engine <span class="hljs-keyword">import</span> CitationQueryEngine

SimpleWebPageReader = download_loader(<span class="hljs-string">&quot;SimpleWebPageReader&quot;</span>)

documents = SimpleWebPageReader(html_to_text=<span class="hljs-literal">True</span>).load_data(
    [<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>]
)

<span class="hljs-comment"># Load embedding model</span>
embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

<span class="hljs-comment"># Pass LLM to pipeline</span>
index = VectorStoreIndex.from_documents(
    documents, embed_model=embed_model, show_progress=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Query the index</span>
query_engine = CitationQueryEngine.from_args(
    index,
    similarity_top_k=<span class="hljs-number">2</span>,
)
response = query_engine.query(
    <span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>
)

response.response`,wrap:!1}}),de=new d({props:{title:"Wrap up",local:"wrap-up",headingTag:"h2"}}),Je=new u({props:{code:"JTIzJTIwcGF1c2UlMjBvdXIlMjBydW5uaW5nJTIwZW5kcG9pbnQlMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBJTIzJTIwb3B0aW9uYWxseSUyMGRlbGV0ZSUwQSUyMyUyMGVuZHBvaW50LmRlbGV0ZSgp",highlighted:`<span class="hljs-comment"># pause our running endpoint</span>
endpoint.pause()

<span class="hljs-comment"># optionally delete</span>
<span class="hljs-comment"># endpoint.delete()</span>`,wrap:!1}}),je=new fs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/tgi_messages_api_demo.md"}}),{c(){w=i("meta"),Ce=n(),ge=i("p"),Ze=n(),r(J.$$.fragment),Ge=n(),r(j.$$.fragment),ve=n(),r(T.$$.fragment),We=n(),U=i("p"),U.innerHTML=At,ke=n(),b=i("p"),b.textContent=Nt,_e=n(),g=i("p"),g.innerHTML=xt,Re=n(),f=i("p"),f.textContent=Vt,Ee=n(),I=i("ul"),I.innerHTML=$t,Ae=n(),B=i("p"),B.textContent=Xt,Ne=n(),C=i("ol"),C.innerHTML=St,xe=n(),Z=i("p"),Z.innerHTML=Qt,Ve=n(),r(G.$$.fragment),$e=n(),v=i("p"),v.textContent=Ft,Xe=n(),r(W.$$.fragment),Se=n(),r(k.$$.fragment),Qe=n(),Te=i("a"),Fe=n(),r(_.$$.fragment),Ye=n(),R=i("p"),R.innerHTML=Yt,qe=n(),E=i("p"),E.innerHTML=qt,He=n(),A=i("p"),A.innerHTML=Ht,Le=n(),N=i("p"),N.innerHTML=Lt,ze=n(),r(x.$$.fragment),Pe=n(),V=i("pre"),V.textContent=zt,Oe=n(),$=i("p"),$.innerHTML=Pt,De=n(),X=i("p"),X.innerHTML=Ot,Ke=n(),S=i("p"),S.textContent=Dt,et=n(),Q=i("p"),Q.innerHTML=Kt,tt=n(),Ue=i("a"),st=n(),r(F.$$.fragment),lt=n(),Y=i("p"),Y.textContent=es,nt=n(),r(q.$$.fragment),at=n(),H=i("p"),H.innerHTML=ts,it=n(),L=i("p"),L.textContent=ss,ot=n(),r(z.$$.fragment),pt=n(),P=i("pre"),P.textContent=ls,rt=n(),O=i("p"),O.innerHTML=ns,ct=n(),D=i("p"),D.innerHTML=as,Mt=n(),r(K.$$.fragment),ht=n(),ee=i("p"),ee.innerHTML=is,mt=n(),r(te.$$.fragment),yt=n(),be=i("a"),ut=n(),r(se.$$.fragment),dt=n(),le=i("p"),le.textContent=os,wt=n(),r(ne.$$.fragment),Jt=n(),ae=i("p"),ae.innerHTML=ps,jt=n(),r(ie.$$.fragment),Tt=n(),oe=i("p"),oe.innerHTML=rs,Ut=n(),pe=i("p"),pe.textContent=cs,bt=n(),r(re.$$.fragment),gt=n(),r(ce.$$.fragment),ft=n(),Me=i("p"),Me.innerHTML=Ms,It=n(),he=i("p"),he.innerHTML=hs,Bt=n(),r(me.$$.fragment),Ct=n(),ye=i("p"),ye.innerHTML=ms,Zt=n(),r(ue.$$.fragment),Gt=n(),r(de.$$.fragment),vt=n(),we=i("p"),we.textContent=ys,Wt=n(),r(Je.$$.fragment),kt=n(),r(je.$$.fragment),_t=n(),fe=i("p"),this.h()},l(e){const t=Ts("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),Ce=a(e),ge=o(e,"P",{}),Ie(ge).forEach(s),Ze=a(e),c(J.$$.fragment,e),Ge=a(e),c(j.$$.fragment,e),ve=a(e),c(T.$$.fragment,e),We=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-15bmh6z"&&(U.innerHTML=At),ke=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-ifj9j3"&&(b.textContent=Nt),_e=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-19stfnn"&&(g.innerHTML=xt),Re=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1h5h72d"&&(f.textContent=Vt),Ee=a(e),I=o(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-o7yv73"&&(I.innerHTML=$t),Ae=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-i15w4q"&&(B.textContent=Xt),Ne=a(e),C=o(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-dmuq8i"&&(C.innerHTML=St),xe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1yaed00"&&(Z.innerHTML=Qt),Ve=a(e),c(G.$$.fragment,e),$e=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1mbafnu"&&(v.textContent=Ft),Xe=a(e),c(W.$$.fragment,e),Se=a(e),c(k.$$.fragment,e),Qe=a(e),Te=o(e,"A",{id:!0}),Ie(Te).forEach(s),Fe=a(e),c(_.$$.fragment,e),Ye=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1srz11y"&&(R.innerHTML=Yt),qe=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1nafhc7"&&(E.innerHTML=qt),He=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1qq4fhb"&&(A.innerHTML=Ht),Le=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1vrlf2e"&&(N.innerHTML=Lt),ze=a(e),c(x.$$.fragment,e),Pe=a(e),V=o(e,"PRE",{"data-svelte-h":!0}),p(V)!=="svelte-105t8kl"&&(V.textContent=zt),Oe=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-13u8bul"&&($.innerHTML=Pt),De=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-8mpmx4"&&(X.innerHTML=Ot),Ke=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1hh5tjb"&&(S.textContent=Dt),et=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1nk8k00"&&(Q.innerHTML=Kt),tt=a(e),Ue=o(e,"A",{id:!0}),Ie(Ue).forEach(s),st=a(e),c(F.$$.fragment,e),lt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-m2ihxo"&&(Y.textContent=es),nt=a(e),c(q.$$.fragment,e),at=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1vvrp5u"&&(H.innerHTML=ts),it=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-5sa4me"&&(L.textContent=ss),ot=a(e),c(z.$$.fragment,e),pt=a(e),P=o(e,"PRE",{"data-svelte-h":!0}),p(P)!=="svelte-1gevisn"&&(P.textContent=ls),rt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-9ab64r"&&(O.innerHTML=ns),ct=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-15i27pe"&&(D.innerHTML=as),Mt=a(e),c(K.$$.fragment,e),ht=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-a5y7nz"&&(ee.innerHTML=is),mt=a(e),c(te.$$.fragment,e),yt=a(e),be=o(e,"A",{id:!0}),Ie(be).forEach(s),ut=a(e),c(se.$$.fragment,e),dt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1i9oels"&&(le.textContent=os),wt=a(e),c(ne.$$.fragment,e),Jt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1qdzd81"&&(ae.innerHTML=ps),jt=a(e),c(ie.$$.fragment,e),Tt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-4flxc0"&&(oe.innerHTML=rs),Ut=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-c9m7s5"&&(pe.textContent=cs),bt=a(e),c(re.$$.fragment,e),gt=a(e),c(ce.$$.fragment,e),ft=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-gt52es"&&(Me.innerHTML=Ms),It=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1oxfz4m"&&(he.innerHTML=hs),Bt=a(e),c(me.$$.fragment,e),Ct=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1yqegdk"&&(ye.innerHTML=ms),Zt=a(e),c(ue.$$.fragment,e),Gt=a(e),c(de.$$.fragment,e),vt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-132npwv"&&(we.textContent=ys),Wt=a(e),c(Je.$$.fragment,e),kt=a(e),c(je.$$.fragment,e),_t=a(e),fe=o(e,"P",{}),Ie(fe).forEach(s),this.h()},h(){Be(w,"name","hf:doc:metadata"),Be(w,"content",Bs),Be(Te,"id","section_1"),Be(Ue,"id","section_2"),Be(be,"id","section_3")},m(e,t){Us(document.head,w),l(e,Ce,t),l(e,ge,t),l(e,Ze,t),M(J,e,t),l(e,Ge,t),M(j,e,t),l(e,ve,t),M(T,e,t),l(e,We,t),l(e,U,t),l(e,ke,t),l(e,b,t),l(e,_e,t),l(e,g,t),l(e,Re,t),l(e,f,t),l(e,Ee,t),l(e,I,t),l(e,Ae,t),l(e,B,t),l(e,Ne,t),l(e,C,t),l(e,xe,t),l(e,Z,t),l(e,Ve,t),M(G,e,t),l(e,$e,t),l(e,v,t),l(e,Xe,t),M(W,e,t),l(e,Se,t),M(k,e,t),l(e,Qe,t),l(e,Te,t),l(e,Fe,t),M(_,e,t),l(e,Ye,t),l(e,R,t),l(e,qe,t),l(e,E,t),l(e,He,t),l(e,A,t),l(e,Le,t),l(e,N,t),l(e,ze,t),M(x,e,t),l(e,Pe,t),l(e,V,t),l(e,Oe,t),l(e,$,t),l(e,De,t),l(e,X,t),l(e,Ke,t),l(e,S,t),l(e,et,t),l(e,Q,t),l(e,tt,t),l(e,Ue,t),l(e,st,t),M(F,e,t),l(e,lt,t),l(e,Y,t),l(e,nt,t),M(q,e,t),l(e,at,t),l(e,H,t),l(e,it,t),l(e,L,t),l(e,ot,t),M(z,e,t),l(e,pt,t),l(e,P,t),l(e,rt,t),l(e,O,t),l(e,ct,t),l(e,D,t),l(e,Mt,t),M(K,e,t),l(e,ht,t),l(e,ee,t),l(e,mt,t),M(te,e,t),l(e,yt,t),l(e,be,t),l(e,ut,t),M(se,e,t),l(e,dt,t),l(e,le,t),l(e,wt,t),M(ne,e,t),l(e,Jt,t),l(e,ae,t),l(e,jt,t),M(ie,e,t),l(e,Tt,t),l(e,oe,t),l(e,Ut,t),l(e,pe,t),l(e,bt,t),M(re,e,t),l(e,gt,t),M(ce,e,t),l(e,ft,t),l(e,Me,t),l(e,It,t),l(e,he,t),l(e,Bt,t),M(me,e,t),l(e,Ct,t),l(e,ye,t),l(e,Zt,t),M(ue,e,t),l(e,Gt,t),M(de,e,t),l(e,vt,t),l(e,we,t),l(e,Wt,t),M(Je,e,t),l(e,kt,t),M(je,e,t),l(e,_t,t),l(e,fe,t),Rt=!0},p:ds,i(e){Rt||(h(J.$$.fragment,e),h(j.$$.fragment,e),h(T.$$.fragment,e),h(G.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(_.$$.fragment,e),h(x.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(z.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),Rt=!0)},o(e){m(J.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(x.$$.fragment,e),m(F.$$.fragment,e),m(q.$$.fragment,e),m(z.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),Rt=!1},d(e){e&&(s(Ce),s(ge),s(Ze),s(Ge),s(ve),s(We),s(U),s(ke),s(b),s(_e),s(g),s(Re),s(f),s(Ee),s(I),s(Ae),s(B),s(Ne),s(C),s(xe),s(Z),s(Ve),s($e),s(v),s(Xe),s(Se),s(Qe),s(Te),s(Fe),s(Ye),s(R),s(qe),s(E),s(He),s(A),s(Le),s(N),s(ze),s(Pe),s(V),s(Oe),s($),s(De),s(X),s(Ke),s(S),s(et),s(Q),s(tt),s(Ue),s(st),s(lt),s(Y),s(nt),s(at),s(H),s(it),s(L),s(ot),s(pt),s(P),s(rt),s(O),s(ct),s(D),s(Mt),s(ht),s(ee),s(mt),s(yt),s(be),s(ut),s(dt),s(le),s(wt),s(Jt),s(ae),s(jt),s(Tt),s(oe),s(Ut),s(pe),s(bt),s(gt),s(ft),s(Me),s(It),s(he),s(Bt),s(Ct),s(ye),s(Zt),s(Gt),s(vt),s(we),s(Wt),s(kt),s(_t),s(fe)),s(w),y(J,e),y(j,e),y(T,e),y(G,e),y(W,e),y(k,e),y(_,e),y(x,e),y(F,e),y(q,e),y(z,e),y(K,e),y(te,e),y(se,e),y(ne,e),y(ie,e),y(re,e),y(ce,e),y(me,e),y(ue,e),y(de,e),y(Je,e),y(je,e)}}}const Bs='{"title":"Migrating from OpenAI to Open LLMs Using TGI’s Messages API","local":"migrating-from-openai-to-open-llms-using-tgis-messages-api","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"1. Create an Inference Endpoint","local":"1-create-an-inference-endpoint","sections":[],"depth":2},{"title":"2. Query the Inference Endpoint with OpenAI Client Libraries","local":"2-query-the-inference-endpoint-with-openai-client-libraries","sections":[{"title":"With the Python client","local":"with-the-python-client","sections":[],"depth":3},{"title":"With the JavaScript client","local":"with-the-javascript-client","sections":[],"depth":3}],"depth":2},{"title":"3. Integrate with LangChain and LlamaIndex","local":"3-integrate-with-langchain-and-llamaindex","sections":[{"title":"How to use with LangChain","local":"how-to-use-with-langchain","sections":[],"depth":3},{"title":"How to use with LlamaIndex","local":"how-to-use-with-llamaindex","sections":[],"depth":3}],"depth":2},{"title":"Wrap up","local":"wrap-up","sections":[],"depth":2}],"depth":1}';function Cs(Et){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends Js{constructor(w){super(),js(this,w,Cs,Is,us,{})}}export{_s as component};
