import{s as Ra,n as Xa,o as Na}from"../chunks/scheduler.1f027d5a.js";import{S as Va,i as Ya,e as i,s as M,c as e,h as Qa,a as c,d as a,b as t,f as Wa,g as J,j as U,k as fa,l as Fa,m as n,n as p,t as y,o as T,p as j}from"../chunks/index.5cb6ce42.js";import{C as za}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as ka,C as w}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as o,E as Ea}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function va(ta){let r,Fl,Yl,zl,m,kl,I,El,u,vl,h,ea='<em>Authored by: <a href="https://github.com/behroozazarkhalili" rel="nofollow">Behrooz Azarkhalili</a></em>',Sl,b,Ja="This notebook demonstrates <strong>advanced GRPO (Group Relative Policy Optimization)</strong> for mathematical reasoning using a comprehensive multi-reward training system. We’ll fine-tune a model on the GSM8K dataset with four specialized reward functions.",Hl,d,pa="<strong>Key Features:</strong>",_l,C,ya="<li><strong>4 Reward Functions</strong>: Format compliance, approximate matching, answer correctness, and number extraction</li> <li><strong>Memory Efficient</strong>: 4-bit quantization + LoRA for consumer GPUs</li> <li><strong>Interactive Monitoring</strong>: Real-time training metrics with trackio dashboard</li> <li><strong>Structured Output</strong>: Enforces step-by-step reasoning format</li>",$l,B,Ta="The model learns to generate structured mathematical solutions with clear reasoning steps and accurate numerical answers.",ql,A,xl,g,ja="Install the required packages for GRPO training with memory-efficient techniques.",Ll,Z,Kl,G,Dl,W,ia="Verify GPU availability and display hardware specifications for optimal training configuration.",Pl,f,Ol,R,ls,X,ca="Import essential libraries for GRPO training, model configuration, and experiment tracking.",ss,N,as,V,ns,Y,wa="Choose a compact but capable model suitable for mathematical reasoning with memory constraints.",Ms,Q,ts,F,es,z,Js,k,ps,E,Ua="Apply Low-Rank Adaptation to train only ~0.1% of parameters while maintaining performance.",ys,v,Ts,S,js,H,oa="Configure the GSM8K mathematical reasoning dataset with structured output format for step-by-step solutions.",is,_,cs,$,ws,q,Us,x,os,L,ra="Implement four complementary reward functions to evaluate different aspects of mathematical reasoning:",rs,K,ma="<li><strong>Exact Format Matching</strong>: Perfect structure compliance</li> <li><strong>Approximate Matching</strong>: Partial credit for format elements</li> <li><strong>Answer Correctness</strong>: Mathematical accuracy with graduated scoring</li> <li><strong>Number Extraction</strong>: Ability to parse and output numerical results</li>",ms,D,Is,P,us,O,hs,ll,bs,sl,ds,al,Cs,nl,Ia="Configure training parameters optimized for mathematical reasoning with memory constraints.",Bs,Ml,As,tl,gs,el,Zs,Jl,ua="Set up the GRPO trainer with our multi-reward system and experiment tracking.",Gs,pl,Ws,yl,fs,Tl,ha="Start the training process with real-time reward monitoring. Watch for gradual improvement in both format compliance and mathematical accuracy.",Rs,jl,Xs,il,Ns,cl,ba="Launch the interactive trackio dashboard to analyze training progress, reward evolution, and model performance metrics.",Vs,wl,Ys,Ul,Qs,ol,da="Test the trained model’s mathematical reasoning capability with structured output validation.",Fs,rl,zs,ml,ks,Il,Es,ul,Ca="Free GPU memory and clear cached tensors for optimal resource management.",vs,hl,Ss,bl,Hs,dl,_s,Cl,$s,Bl,qs,Al,Ba='<li><strong>GRPO Algorithm</strong>: <a href="https://arxiv.org/abs/2402.03300" rel="nofollow">Group Relative Policy Optimization</a> - The original GRPO paper introducing group-based relative policy optimization</li> <li><strong>GSM8K Dataset</strong>: <a href="https://arxiv.org/abs/2110.14168" rel="nofollow">Training Verifiers to Solve Math Word Problems</a> - Cobbe et al., OpenAI</li> <li><strong>LoRA</strong>: <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">Low-Rank Adaptation of Large Language Models</a> - Hu et al., Microsoft</li> <li><strong>QLoRA</strong>: <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">Efficient Finetuning of Quantized LLMs</a> - Dettmers et al., 4-bit quantization for efficient training</li>',xs,gl,Ls,Zl,Aa='<li><strong>TRL (Transformers Reinforcement Learning)</strong>: <a href="https://github.com/huggingface/trl" rel="nofollow">HuggingFace TRL</a> - Official library for RLHF and advanced training techniques</li> <li><strong>Transformers</strong>: <a href="https://github.com/huggingface/transformers" rel="nofollow">HuggingFace Transformers</a> - State-of-the-art NLP library</li> <li><strong>PEFT</strong>: <a href="https://github.com/huggingface/peft" rel="nofollow">Parameter-Efficient Fine-Tuning</a> - Efficient adaptation methods</li> <li><strong>BitsAndBytes</strong>: <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">8-bit &amp; 4-bit Quantization</a> - Memory-efficient training</li>',Ks,Gl,Ds,Wl,ga='<li><strong>Qwen2.5-3B-Instruct</strong>: <a href="https://github.com/QwenLM/Qwen2.5" rel="nofollow">Qwen Model Series</a> - Alibaba’s instruction-tuned language model</li> <li><strong>Alternative Models</strong>: Gemma-2B, DialoGPT, GPT-2 (configurable in the notebook)</li>',Ps,fl,Os,Rl,Za='<li><strong>GSM8K</strong>: <a href="https://huggingface.co/datasets/openai/gsm8k" rel="nofollow">OpenAI GSM8K</a> - Grade School Math 8K problems dataset</li> <li><strong>Format</strong>: Mathematical word problems requiring multi-step reasoning and numerical answers</li>',la,Xl,sa,Nl,Ga="<li><strong>Reinforcement Learning from Human Feedback (RLHF)</strong>: Training language models using reward signals</li> <li><strong>Group Relative Policy Optimization</strong>: Advanced RL technique comparing responses in groups rather than absolute scoring</li> <li><strong>Structured Generation</strong>: Teaching models to follow specific output formats with reasoning sections</li> <li><strong>Multi-Reward Training</strong>: Using multiple reward functions for comprehensive evaluation</li>",aa,Vl,na,Ql,Ma;return m=new ka({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/trl_grpo_reasoning_advanced_reward.ipynb"}]}}),I=new za({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new o({props:{title:"Advanced GRPO Fine-tuning for Mathematical Reasoning with Multi-Reward Training",local:"advanced-grpo-fine-tuning-for-mathematical-reasoning-with-multi-reward-training",headingTag:"h1"}}),A=new o({props:{title:"Installation and Setup",local:"installation-and-setup",headingTag:"h2"}}),Z=new w({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjBmb3IlMjBHUlBPJTIwbWF0aGVtYXRpY2FsJTIwcmVhc29uaW5nJTIwdHJhaW5pbmclMEEhcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwdHJsJTIwYml0c2FuZGJ5dGVzJTIwcGVmdCUyMHRyYWNraW8=",highlighted:`<span class="hljs-comment"># Install required packages for GRPO mathematical reasoning training</span>
!pip install transformers datasets trl bitsandbytes peft trackio`,wrap:!1}}),G=new o({props:{title:"GPU Environment Detection",local:"gpu-environment-detection",headingTag:"h2"}}),f=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBWZXJpZnklMjBDVURBJTIwYXZhaWxhYmlsaXR5JTIwYW5kJTIwZGlzcGxheSUyMEdQVSUyMHNwZWNpZmljYXRpb25zJTBBcHJpbnQoZiUyMkNVREElMjBhdmFpbGFibGUlM0ElMjAlN0J0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTdEJTIyKSUwQXByaW50KGYlMjJOdW1iZXIlMjBvZiUyMEdQVXMlM0ElMjAlN0J0b3JjaC5jdWRhLmRldmljZV9jb3VudCgpJTdEJTIyKSUwQSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERpc3BsYXklMjBjdXJyZW50JTIwR1BVJTIwZGV0YWlscyUyMGZvciUyMHRyYWluaW5nJTIwb3B0aW1pemF0aW9uJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkN1cnJlbnQlMjBHUFUlM0ElMjAlN0J0b3JjaC5jdWRhLmN1cnJlbnRfZGV2aWNlKCklN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG5hbWUlM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgpJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHUFUlMjBtZW1vcnklM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfcHJvcGVydGllcygwKS50b3RhbF9tZW1vcnklMjAlMkYlMjAxZTklM0EuMWYlN0QlMjBHQiUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJvdmlkZSUyMGd1aWRhbmNlJTIwZm9yJTIwZW5hYmxpbmclMjBHUFUlMjBpbiUyMENvbGFiJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUUyJTlBJUEwJUVGJUI4JThGJTIwJTIwTm8lMjBHUFUlMjBhdmFpbGFibGUuJTIwVGhpcyUyMG5vdGVib29rJTIwcmVxdWlyZXMlMjBhJTIwR1BVJTIwZm9yJTIwZWZmaWNpZW50JTIwdHJhaW5pbmcuJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluJTIwQ29sYWIlM0ElMjBSdW50aW1lJTIwJUUyJTg2JTkyJTIwQ2hhbmdlJTIwcnVudGltZSUyMHR5cGUlMjAlRTIlODYlOTIlMjBIYXJkd2FyZSUyMGFjY2VsZXJhdG9yJTIwJUUyJTg2JTkyJTIwR1BVJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Verify CUDA availability and display GPU specifications</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CUDA available: <span class="hljs-subst">{torch.cuda.is_available()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of GPUs: <span class="hljs-subst">{torch.cuda.device_count()}</span>&quot;</span>)

<span class="hljs-keyword">if</span> torch.cuda.is_available():
    <span class="hljs-comment"># Display current GPU details for training optimization</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Current GPU: <span class="hljs-subst">{torch.cuda.current_device()}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU name: <span class="hljs-subst">{torch.cuda.get_device_name()}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory: <span class="hljs-subst">{torch.cuda.get_device_properties(<span class="hljs-number">0</span>).total_memory / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># Provide guidance for enabling GPU in Colab</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  No GPU available. This notebook requires a GPU for efficient training.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;In Colab: Runtime → Change runtime type → Hardware accelerator → GPU&quot;</span>)`,wrap:!1}}),R=new o({props:{title:"Core Library Imports",local:"core-library-imports",headingTag:"h2"}}),N=new w({props:{code:"aW1wb3J0JTIwdHJhY2tpbyUyMCUyMCUyMyUyMEV4cGVyaW1lbnQlMjB0cmFja2luZyUyMGRhc2hib2FyZCUwQWltcG9ydCUyMHJlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVnZXglMjBwYXR0ZXJucyUyMGZvciUyMHJld2FyZCUyMGZ1bmN0aW9ucyUwQSUwQSUyMyUyMEdSUE8lMjB0cmFpbmluZyUyMGNvbXBvbmVudHMlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwR1JQT0NvbmZpZyUyQyUyMEdSUE9UcmFpbmVyJTBBJTBBJTIzJTIwTW9kZWwlMjBhbmQlMjB0b2tlbml6YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwJTIwJTIwJTIzJTIwQ2F1c2FsJTIwbGFuZ3VhZ2UlMjBtb2RlbCUyMGxvYWRpbmclMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVGV4dCUyMHRva2VuaXphdGlvbiUwQSUyMCUyMCUyMCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUyMCUyMCUyMCUyMCUyMCUyMyUyMFF1YW50aXphdGlvbiUyMGNvbmZpZ3VyYXRpb24lMEEpJTBBJTBBJTIzJTIwUGFyYW1ldGVyLWVmZmljaWVudCUyMGZpbmUtdHVuaW5nJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBUYXNrVHlwZSUwQSUwQSUyMyUyMERhdGFzZXQlMjBoYW5kbGluZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMExvZ2dpbmclMjBjb25maWd1cmF0aW9uJTBBaW1wb3J0JTIwbG9nZ2luZyUwQWxvZ2dpbmcuYmFzaWNDb25maWcobGV2ZWwlM0Rsb2dnaW5nLklORk8pJTBBbG9nZ2VyJTIwJTNEJTIwbG9nZ2luZy5nZXRMb2dnZXIoX19uYW1lX18pJTBBJTBBJTIzJTIwU3VwcHJlc3MlMjBodHRweCUyMHJlcXVlc3QlMjBsb2dzJTIwdGhhdCUyMGFwcGVhciUyMGR1cmluZyUyMHRyYWNraW8lMjB1c2FnZSUwQWxvZ2dpbmcuZ2V0TG9nZ2VyKCUyMmh0dHB4JTIyKS5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcpJTBBbG9nZ2luZy5nZXRMb2dnZXIoJTIyZ3JhZGlvX2NsaWVudCUyMikuc2V0TGV2ZWwobG9nZ2luZy5XQVJOSU5HKQ==",highlighted:`<span class="hljs-keyword">import</span> trackio  <span class="hljs-comment"># Experiment tracking dashboard</span>
<span class="hljs-keyword">import</span> re       <span class="hljs-comment"># Regex patterns for reward functions</span>

<span class="hljs-comment"># GRPO training components</span>
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOConfig, GRPOTrainer

<span class="hljs-comment"># Model and tokenization</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,   <span class="hljs-comment"># Causal language model loading</span>
    AutoTokenizer,          <span class="hljs-comment"># Text tokenization</span>
    BitsAndBytesConfig,     <span class="hljs-comment"># Quantization configuration</span>
)

<span class="hljs-comment"># Parameter-efficient fine-tuning</span>
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model, TaskType

<span class="hljs-comment"># Dataset handling</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Logging configuration</span>
<span class="hljs-keyword">import</span> logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

<span class="hljs-comment"># Suppress httpx request logs that appear during trackio usage</span>
logging.getLogger(<span class="hljs-string">&quot;httpx&quot;</span>).setLevel(logging.WARNING)
logging.getLogger(<span class="hljs-string">&quot;gradio_client&quot;</span>).setLevel(logging.WARNING)`,wrap:!1}}),V=new o({props:{title:"Model Selection and Configuration",local:"model-selection-and-configuration",headingTag:"h2"}}),Q=new w({props:{code:"JTIzJTIwU2VsZWN0JTIwbW9kZWwlMjBvcHRpbWl6ZWQlMjBmb3IlMjBpbnN0cnVjdGlvbi1mb2xsb3dpbmclMjBhbmQlMjByZWFzb25pbmclMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyUXdlbiUyRlF3ZW4yLjUtM0ItSW5zdHJ1Y3QlMjIlMjAlMjAlMjMlMjAzQiUyMHBhcmFtZXRlciUyMG1vZGVsJTIwYmFsYW5jZXMlMjBjYXBhYmlsaXR5JTIwYW5kJTIwbWVtb3J5JTIwdXNhZ2UlMEFtYXhfc2VxX2xlbmd0aCUyMCUzRCUyMDIwNDglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUb2tlbiUyMGxpbWl0JTIwZm9yJTIwbWF0aGVtYXRpY2FsJTIwcHJvYmxlbXMlMjAocmVkdWNlJTIwaWYlMjBPT00pJTBBJTBBcHJpbnQoZiUyMkxvYWRpbmclMjBtb2RlbCUzQSUyMCU3Qm1vZGVsX25hbWUlN0QlMjIpJTBBcHJpbnQoZiUyMk1heCUyMHNlcXVlbmNlJTIwbGVuZ3RoJTNBJTIwJTdCbWF4X3NlcV9sZW5ndGglN0QlMjIp",highlighted:`<span class="hljs-comment"># Select model optimized for instruction-following and reasoning</span>
model_name = <span class="hljs-string">&quot;Qwen/Qwen2.5-3B-Instruct&quot;</span>  <span class="hljs-comment"># 3B parameter model balances capability and memory usage</span>
max_seq_length = <span class="hljs-number">2048</span>                     <span class="hljs-comment"># Token limit for mathematical problems (reduce if OOM)</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loading model: <span class="hljs-subst">{model_name}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max sequence length: <span class="hljs-subst">{max_seq_length}</span>&quot;</span>)`,wrap:!1}}),F=new w({props:{code:"JTIzJTIwQ29uZmlndXJlJTIwNC1iaXQlMjBxdWFudGl6YXRpb24lMjBmb3IlMjB+NzUlMjUlMjBtZW1vcnklMjByZWR1Y3Rpb24lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBFbmFibGUlMjA0LWJpdCUyMHByZWNpc2lvbiUyMCh2cyUyMDE2LWJpdCUyMGRlZmF1bHQpJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vcm1hbEZsb2F0NCUzQSUyMG9wdGltYWwlMjBmb3IlMjBuZXVyYWwlMjBuZXR3b3JrJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTIzJTIwVXNlJTIwRlAxNiUyMGZvciUyMGZvcndhcmQlMkZiYWNrd2FyZCUyMHBhc3NlcyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRnVydGhlciUyMHF1YW50aXplJTIwcXVhbnRpemF0aW9uJTIwY29uc3RhbnRzJTBBKSUwQSUwQXByaW50KCUyMiVFMiU5QyU4NSUyMDQtYml0JTIwcXVhbnRpemF0aW9uJTIwY29uZmlndXJlZCUyMiklMEFwcmludCglMjIlMjAlMjAlMjBNZW1vcnklMjByZWR1Y3Rpb24lM0ElMjB+NzUlMjUlMjB2cyUyMEZQMTYlMjIp",highlighted:`<span class="hljs-comment"># Configure 4-bit quantization for ~75% memory reduction</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,                    <span class="hljs-comment"># Enable 4-bit precision (vs 16-bit default)</span>
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,           <span class="hljs-comment"># NormalFloat4: optimal for neural network weights</span>
    bnb_4bit_compute_dtype=torch.float16, <span class="hljs-comment"># Use FP16 for forward/backward passes</span>
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,      <span class="hljs-comment"># Further quantize quantization constants</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ 4-bit quantization configured&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;   Memory reduction: ~75% vs FP16&quot;</span>)`,wrap:!1}}),z=new w({props:{code:"JTIzJTIwTG9hZCUyMG1vZGVsJTIwd2l0aCUyMHF1YW50aXphdGlvbiUyMGFuZCUyMGF1dG9tYXRpYyUyMGRldmljZSUyMG1hcHBpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWclMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBcHBseSUyMDQtYml0JTIwcXVhbnRpemF0aW9uJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBdXRvLWRpc3RyaWJ1dGUlMjBhY3Jvc3MlMjBhdmFpbGFibGUlMjBHUFVzJTJGQ1BVJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQWxsb3clMjBjdXN0b20lMjBtb2RlbCUyMGNvZGUlMjBleGVjdXRpb24lMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjBGUDE2JTIwZm9yJTIwbm9uLXF1YW50aXplZCUyMG9wZXJhdGlvbnMlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMGNvcnJlc3BvbmRpbmclMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQWxsb3clMjBjdXN0b20lMjB0b2tlbml6ZXIlMjBjb2RlJTBBKSUwQSUwQSUyMyUyMEVuc3VyZSUyMHRva2VuaXplciUyMGhhcyUyMHByb3BlciUyMHBhZGRpbmclMjB0b2tlbiUyMGZvciUyMGJhdGNoJTIwcHJvY2Vzc2luZyUwQWlmJTIwdG9rZW5pemVyLnBhZF90b2tlbiUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTBBJTBBcHJpbnQoZiUyMiVFMiU5QyU4NSUyME1vZGVsJTIwbG9hZGVkJTIwc3VjY2Vzc2Z1bGx5ISUyMiklMEFwcmludChmJTIyJUYwJTlGJTkzJThBJTIwTW9kZWwlMjBwYXJhbWV0ZXJzJTNBJTIwfiU3QnN1bShwLm51bWVsKCklMjBmb3IlMjBwJTIwaW4lMjBtb2RlbC5wYXJhbWV0ZXJzKCkpJTIwJTJGJTIwMWU2JTNBLjFmJTdETSUyMiklMEFwcmludChmJTIyJUYwJTlGJUE3JUFFJTIwUXVhbnRpemVkJTIwcGFyYW1ldGVycyUzQSUyMH4lN0JzdW0ocC5udW1lbCgpJTIwZm9yJTIwcCUyMGluJTIwbW9kZWwucGFyYW1ldGVycygpJTIwaWYlMjBoYXNhdHRyKHAlMkMlMjAncXVhbnRfdHlwZScpKSUyMCUyRiUyMDFlNiUzQS4xZiU3RE0lMjIp",highlighted:`<span class="hljs-comment"># Load model with quantization and automatic device mapping</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    quantization_config=bnb_config,      <span class="hljs-comment"># Apply 4-bit quantization</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,                   <span class="hljs-comment"># Auto-distribute across available GPUs/CPU</span>
    trust_remote_code=<span class="hljs-literal">True</span>,              <span class="hljs-comment"># Allow custom model code execution</span>
    torch_dtype=torch.float16,           <span class="hljs-comment"># Use FP16 for non-quantized operations</span>
)

<span class="hljs-comment"># Load corresponding tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(
    model_name,
    trust_remote_code=<span class="hljs-literal">True</span>               <span class="hljs-comment"># Allow custom tokenizer code</span>
)

<span class="hljs-comment"># Ensure tokenizer has proper padding token for batch processing</span>
<span class="hljs-keyword">if</span> tokenizer.pad_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Model loaded successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Model parameters: ~<span class="hljs-subst">{<span class="hljs-built_in">sum</span>(p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters()) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span>M&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🧮 Quantized parameters: ~<span class="hljs-subst">{<span class="hljs-built_in">sum</span>(p.numel() <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> model.parameters() <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(p, <span class="hljs-string">&#x27;quant_type&#x27;</span>)) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span>M&quot;</span>)`,wrap:!1}}),k=new o({props:{title:"LoRA Configuration",local:"lora-configuration",headingTag:"h2"}}),v=new w({props:{code:"JTIzJTIwQ29uZmlndXJlJTIwTG9SQSUyMGZvciUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUyMGFkYXB0YXRpb24lMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmFuayUzQSUyMGFkYXB0YXRpb24lMjBjYXBhY2l0eSUyMCgxNiUyMGdvb2QlMjBmb3IlMjByZWFzb25pbmclMjB0YXNrcyklMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTY2FsaW5nJTIwZmFjdG9yJTIwKHR5cGljYWxseSUyMDJ4JTIwcmFuayklMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUyMCUyMyUyMEZvY3VzJTIwb24lMjBhdHRlbnRpb24lMjBxdWVyeSUyRnZhbHVlJTIwZm9yJTIwcmVhc29uaW5nJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVndWxhcml6YXRpb24lMjB0byUyMHByZXZlbnQlMjBvdmVyZml0dGluZyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2tpcCUyMGJpYXMlMjBhZGFwdGF0aW9uJTIwZm9yJTIwc2ltcGxpY2l0eSUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLkNBVVNBTF9MTSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENhdXNhbCUyMGxhbmd1YWdlJTIwbW9kZWxpbmclMjB0YXNrJTBBKSUwQSUwQXByaW50KCUyMiVGMCU5RiU5NCVBNyUyMEFwcGx5aW5nJTIwTG9SQSUyMGFkYXB0YXRpb24lMjB0byUyMG1vZGVsLi4uJTIyKSUwQSUwQSUyMyUyMEFwcGx5JTIwTG9SQSUyMGNvbmZpZ3VyYXRpb24lMjB0byUyMGNyZWF0ZSUyMHRyYWluYWJsZSUyMGFkYXB0ZXIlMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwbG9yYV9jb25maWcpJTBBJTBBJTIzJTIwRGlzcGxheSUyMHBhcmFtZXRlciUyMGVmZmljaWVuY3klMEFwcmludCglMjIlRjAlOUYlOTMlOEElMjBMb1JBJTIwVHJhaW5pbmclMjBQYXJhbWV0ZXJzJTIwU3VtbWFyeSUzQSUyMiklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTIwJTIwJTIzJTIwU2hvd3MlMjB0cmFpbmFibGUlMjB2cyUyMHRvdGFsJTIwcGFyYW1ldGVycw==",highlighted:`<span class="hljs-comment"># Configure LoRA for mathematical reasoning adaptation</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,                              <span class="hljs-comment"># Rank: adaptation capacity (16 good for reasoning tasks)</span>
    lora_alpha=<span class="hljs-number">32</span>,                     <span class="hljs-comment"># Scaling factor (typically 2x rank)</span>
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>], <span class="hljs-comment"># Focus on attention query/value for reasoning</span>
    lora_dropout=<span class="hljs-number">0.1</span>,                  <span class="hljs-comment"># Regularization to prevent overfitting</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,                       <span class="hljs-comment"># Skip bias adaptation for simplicity</span>
    task_type=TaskType.CAUSAL_LM,      <span class="hljs-comment"># Causal language modeling task</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔧 Applying LoRA adaptation to model...&quot;</span>)

<span class="hljs-comment"># Apply LoRA configuration to create trainable adapter</span>
model = get_peft_model(model, lora_config)

<span class="hljs-comment"># Display parameter efficiency</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📊 LoRA Training Parameters Summary:&quot;</span>)
model.print_trainable_parameters()  <span class="hljs-comment"># Shows trainable vs total parameters</span>`,wrap:!1}}),S=new o({props:{title:"GSM8K Dataset Setup",local:"gsm8k-dataset-setup",headingTag:"h2"}}),_=new w({props:{code:"JTIzJTIwRGVmaW5lJTIwc3RydWN0dXJlZCUyMG91dHB1dCUyMGZvcm1hdCUyMGZvciUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUwQXJlYXNvbmluZ19zdGFydCUyMCUzRCUyMCUyMiUzQ3N0YXJ0X3dvcmtpbmdfb3V0JTNFJTIyJTIwJTIwJTIwJTIzJTIwQmVnaW4lMjByZWFzb25pbmclMjBzZWN0aW9uJTBBcmVhc29uaW5nX2VuZCUyMCUzRCUyMCUyMiUzQ2VuZF93b3JraW5nX291dCUzRSUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEVuZCUyMHJlYXNvbmluZyUyMHNlY3Rpb24lMEFzb2x1dGlvbl9zdGFydCUyMCUzRCUyMCUyMiUzQ1NPTFVUSU9OJTNFJTIyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmVnaW4lMjBmaW5hbCUyMGFuc3dlciUwQXNvbHV0aW9uX2VuZCUyMCUzRCUyMCUyMiUzQyUyRlNPTFVUSU9OJTNFJTIyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW5kJTIwZmluYWwlMjBhbnN3ZXIlMEElMEElMjMlMjBTeXN0ZW0lMjBwcm9tcHQlMjB0aGF0JTIwdGVhY2hlcyUyMHRoZSUyMG1vZGVsJTIwb3VyJTIwZGVzaXJlZCUyMHJlYXNvbmluZyUyMHN0cnVjdHVyZSUwQXN5c3RlbV9wcm9tcHQlMjAlM0QlMjBmJTIyJTIyJTIyWW91JTIwYXJlJTIwYSUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUyMGFzc2lzdGFudC4lMEFXaGVuJTIwZ2l2ZW4lMjBhJTIwbWF0aCUyMHByb2JsZW0lM0ElMEExLiUyMFNob3clMjB5b3VyJTIwc3RlcC1ieS1zdGVwJTIwd29yayUyMGJldHdlZW4lMjAlN0JyZWFzb25pbmdfc3RhcnQlN0QlMjBhbmQlMjAlN0JyZWFzb25pbmdfZW5kJTdEJTBBMi4lMjBQcm92aWRlJTIweW91ciUyMGZpbmFsJTIwbnVtZXJpY2FsJTIwYW5zd2VyJTIwYmV0d2VlbiUyMCU3QnNvbHV0aW9uX3N0YXJ0JTdEJTIwYW5kJTIwJTdCc29sdXRpb25fZW5kJTdEJTBBMy4lMjBCZSUyMHByZWNpc2UlMjBhbmQlMjBzaG93JTIwYWxsJTIwY2FsY3VsYXRpb24lMjBzdGVwcyUyMGNsZWFybHkuJTIyJTIyJTIyJTBBJTBBcHJpbnQoJTIyJUUyJTlDJTg1JTIwRm9ybWF0JTIwdG9rZW5zJTIwYW5kJTIwc3lzdGVtJTIwcHJvbXB0JTIwZGVmaW5lZCUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwUmVhc29uaW5nJTIwZm9ybWF0JTNBJTIwJTdCcmVhc29uaW5nX3N0YXJ0JTdEJTIwLi4uJTIwJTdCcmVhc29uaW5nX2VuZCU3RCUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwU29sdXRpb24lMjBmb3JtYXQlM0ElMjAlN0Jzb2x1dGlvbl9zdGFydCU3RCUyMC4uLiUyMCU3QnNvbHV0aW9uX2VuZCU3RCUyMik=",highlighted:`<span class="hljs-comment"># Define structured output format for mathematical reasoning</span>
reasoning_start = <span class="hljs-string">&quot;&lt;start_working_out&gt;&quot;</span>   <span class="hljs-comment"># Begin reasoning section</span>
reasoning_end = <span class="hljs-string">&quot;&lt;end_working_out&gt;&quot;</span>       <span class="hljs-comment"># End reasoning section</span>
solution_start = <span class="hljs-string">&quot;&lt;SOLUTION&gt;&quot;</span>            <span class="hljs-comment"># Begin final answer</span>
solution_end = <span class="hljs-string">&quot;&lt;/SOLUTION&gt;&quot;</span>              <span class="hljs-comment"># End final answer</span>

<span class="hljs-comment"># System prompt that teaches the model our desired reasoning structure</span>
system_prompt = <span class="hljs-string">f&quot;&quot;&quot;You are a mathematical reasoning assistant.
When given a math problem:
1. Show your step-by-step work between <span class="hljs-subst">{reasoning_start}</span> and <span class="hljs-subst">{reasoning_end}</span>
2. Provide your final numerical answer between <span class="hljs-subst">{solution_start}</span> and <span class="hljs-subst">{solution_end}</span>
3. Be precise and show all calculation steps clearly.&quot;&quot;&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Format tokens and system prompt defined&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Reasoning format: <span class="hljs-subst">{reasoning_start}</span> ... <span class="hljs-subst">{reasoning_end}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Solution format: <span class="hljs-subst">{solution_start}</span> ... <span class="hljs-subst">{solution_end}</span>&quot;</span>)`,wrap:!1}}),$=new w({props:{code:"JTIzJTIwRGF0YXNldCUyMHByb2Nlc3NpbmclMjB1dGlsaXRpZXMlMEFkZWYlMjBleHRyYWN0X2hhc2hfYW5zd2VyKHRleHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRXh0cmFjdCUyMG51bWVyaWNhbCUyMGFuc3dlciUyMGZyb20lMjBHU004SyUyMGZvcm1hdCUyMCglMjMlMjMlMjMlMjMlMjBtYXJrZXIpJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjIlMjMlMjMlMjMlMjMlMjIlMjBub3QlMjBpbiUyMHRleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIzJTIwR1NNOEslMjB1c2VzJTIwZm9ybWF0JTNBJTIwJTIyRXhwbGFuYXRpb24uLi4lMjAlMjMlMjMlMjMlMjMlMjA0MiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQuc3BsaXQoJTIyJTIzJTIzJTIzJTIzJTIyKSU1QjElNUQuc3RyaXAoKSUwQSUwQWRlZiUyMHByb2Nlc3NfZGF0YXNldF9leGFtcGxlKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29udmVydCUyMEdTTThLJTIwZXhhbXBsZSUyMHRvJTIwY29udmVyc2F0aW9uJTIwZm9ybWF0JTIwZm9yJTIwR1JQTyUyMHRyYWluaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lMjAlM0QlMjBleGFtcGxlJTVCJTIycXVlc3Rpb24lMjIlNUQlMEElMjAlMjAlMjAlMjBhbnN3ZXIlMjAlM0QlMjBleHRyYWN0X2hhc2hfYW5zd2VyKGV4YW1wbGUlNUIlMjJhbnN3ZXIlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwY29udmVyc2F0aW9uJTIwd2l0aCUyMHN5c3RlbSUyMHByb21wdCUyMGZvciUyMHN0cnVjdHVyZWQlMjByZWFzb25pbmclMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9wcm9tcHQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBxdWVzdGlvbiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMHByb21wdCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMElucHV0JTIwY29udmVyc2F0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYW5zd2VyJTIyJTNBJTIwYW5zd2VyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR3JvdW5kJTIwdHJ1dGglMjBmb3IlMjByZXdhcmQlMjBmdW5jdGlvbnMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBEYXRhc2V0JTIwcHJvY2Vzc2luZyUyMGZ1bmN0aW9ucyUyMGRlZmluZWQlMjIp",highlighted:`<span class="hljs-comment"># Dataset processing utilities</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_hash_answer</span>(<span class="hljs-params">text</span>):
    <span class="hljs-string">&quot;&quot;&quot;Extract numerical answer from GSM8K format (#### marker)&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;####&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> text:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    <span class="hljs-comment"># GSM8K uses format: &quot;Explanation... #### 42&quot;</span>
    <span class="hljs-keyword">return</span> text.split(<span class="hljs-string">&quot;####&quot;</span>)[<span class="hljs-number">1</span>].strip()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_dataset_example</span>(<span class="hljs-params">example</span>):
    <span class="hljs-string">&quot;&quot;&quot;Convert GSM8K example to conversation format for GRPO training&quot;&quot;&quot;</span>
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    answer = extract_hash_answer(example[<span class="hljs-string">&quot;answer&quot;</span>])
    
    <span class="hljs-comment"># Create conversation with system prompt for structured reasoning</span>
    prompt = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
    ]
    
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;prompt&quot;</span>: prompt,           <span class="hljs-comment"># Input conversation</span>
        <span class="hljs-string">&quot;answer&quot;</span>: answer,          <span class="hljs-comment"># Ground truth for reward functions</span>
    }

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Dataset processing functions defined&quot;</span>)`,wrap:!1}}),q=new w({props:{code:"JTIzJTIwTG9hZCUyMGFuZCUyMHByZXByb2Nlc3MlMjBHU004SyUyMHRyYWluaW5nJTIwZGF0YXNldCUwQXByaW50KCUyMiVGMCU5RiU5NCU4NCUyMExvYWRpbmclMjBHU004SyUyMG1hdGhlbWF0aWNhbCUyMHJlYXNvbmluZyUyMGRhdGFzZXQuLi4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvcGVuYWklMkZnc204ayUyMiUyQyUyMCUyMm1haW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMEFwcGx5JTIwY29udmVyc2F0aW9uJTIwZm9ybWF0dGluZyUyMHRvJTIwYWxsJTIwZXhhbXBsZXMlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocHJvY2Vzc19kYXRhc2V0X2V4YW1wbGUpJTBBJTBBcHJpbnQoZiUyMiVFMiU5QyU4NSUyMERhdGFzZXQlMjBsb2FkZWQlMjBhbmQlMjBwcm9jZXNzZWQhJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOTMlOEElMjBUcmFpbmluZyUyMGV4YW1wbGVzJTNBJTIwJTdCbGVuKGRhdGFzZXQpJTNBJTJDJTdEJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOEUlQUYlMjBTYW1wbGUlMjBxdWVzdGlvbiUzQSUyMCU3QmRhdGFzZXQlNUIwJTVEJTVCJ3Byb21wdCclNUQlNUIxJTVEJTVCJ2NvbnRlbnQnJTVEJTdELi4uJTIyKSUwQXByaW50KGYlMjIlRjAlOUYlOEUlQUYlMjBTYW1wbGUlMjBhbnN3ZXIlM0ElMjAlN0JkYXRhc2V0JTVCMCU1RCU1QidhbnN3ZXInJTVEJTdEJTIyKSUwQSUwQSUyMyUyMFNob3clMjBzdHJ1Y3R1cmUlMjBvZiUyMGZpcnN0JTIwZXhhbXBsZSUyMGZvciUyMHZlcmlmaWNhdGlvbiUwQXByaW50KGYlMjIlNUNuJUYwJTlGJTkzJThCJTIwRXhhbXBsZSUyMHN0cnVjdHVyZSUzQSUyMiklMEFwcmludChmJTIyJTIwJTIwJTIwUHJvbXB0JTNBJTIwJTdCbGVuKGRhdGFzZXQlNUIwJTVEJTVCJ3Byb21wdCclNUQpJTdEJTIwbWVzc2FnZXMlMjAoc3lzdGVtJTIwJTJCJTIwdXNlciklMjIpJTBBcHJpbnQoZiUyMiUyMCUyMCUyMEFuc3dlciUzQSUyMCU3QmRhdGFzZXQlNUIwJTVEJTVCJ2Fuc3dlciclNUQlN0QlMjAoZ3JvdW5kJTIwdHJ1dGglMjBmb3IlMjByZXdhcmRzKSUyMik=",highlighted:`<span class="hljs-comment"># Load and preprocess GSM8K training dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔄 Loading GSM8K mathematical reasoning dataset...&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&quot;main&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Apply conversation formatting to all examples</span>
dataset = dataset.<span class="hljs-built_in">map</span>(process_dataset_example)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Dataset loaded and processed!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Training examples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Sample question: <span class="hljs-subst">{dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;prompt&#x27;</span>][<span class="hljs-number">1</span>][<span class="hljs-string">&#x27;content&#x27;</span>]}</span>...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Sample answer: <span class="hljs-subst">{dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>)

<span class="hljs-comment"># Show structure of first example for verification</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📋 Example structure:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Prompt: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;prompt&#x27;</span>])}</span> messages (system + user)&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Answer: <span class="hljs-subst">{dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;answer&#x27;</span>]}</span> (ground truth for rewards)&quot;</span>)`,wrap:!1}}),x=new o({props:{title:"Multi-Reward System Design",local:"multi-reward-system-design",headingTag:"h2"}}),D=new w({props:{code:"JTIzJTIwQ29tcGlsZWQlMjByZWdleCUyMHBhdHRlcm5zJTIwZm9yJTIwZWZmaWNpZW50JTIwcmV3YXJkJTIwY29tcHV0YXRpb24lMEFtYXRjaF9mb3JtYXQlMjAlM0QlMjByZS5jb21waWxlKCUwQSUyMCUyMCUyMCUyMHJmJTIyJTVFJTVCJTVDcyU1RCU3QiU3QjAlMkMlN0QlN0QlMjIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBPcHRpb25hbCUyMHdoaXRlc3BhY2UlMjBhdCUyMHN0YXJ0JTBBJTIwJTIwJTIwJTIwcmYlMjIlN0JyZWFzb25pbmdfc3RhcnQlN0QuJTJCJTNGJTdCcmVhc29uaW5nX2VuZCU3RC4qJTNGJTIyJTIwJTIwJTIzJTIwUmVhc29uaW5nJTIwc2VjdGlvbiUyMChub24tZ3JlZWR5KSUwQSUyMCUyMCUyMCUyMHJmJTIyJTdCc29sdXRpb25fc3RhcnQlN0QoLiUyQiUzRiklN0Jzb2x1dGlvbl9lbmQlN0QlMjIlMjAlMjAlMjAlMjAlMjAlMjMlMjBTb2x1dGlvbiUyMHNlY3Rpb24lMjB3aXRoJTIwY2FwdHVyZSUyMGdyb3VwJTBBJTIwJTIwJTIwJTIwcmYlMjIlNUIlNUNzJTVEJTdCJTdCMCUyQyU3RCU3RCUyNCUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME9wdGlvbmFsJTIwd2hpdGVzcGFjZSUyMGF0JTIwZW5kJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0RyZS5NVUxUSUxJTkUlMjAlN0MlMjByZS5ET1RBTEwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNdWx0aS1saW5lJTIwbWF0Y2hpbmclMjB3aXRoJTIwLiUyMG1hdGNoaW5nJTIwbmV3bGluZXMlMEEpJTBBJTBBbWF0Y2hfbnVtYmVycyUyMCUzRCUyMHJlLmNvbXBpbGUoJTBBJTIwJTIwJTIwJTIwcmYlMjIlN0Jzb2x1dGlvbl9zdGFydCU3RC4qJTNGKCU1QiU1Q2QlNUMuJTVEJTdCJTdCMSUyQyU3RCU3RCklMjIlMkMlMjAlMjMlMjBFeHRyYWN0JTIwbnVtYmVycyUyMGZyb20lMjBzb2x1dGlvbiUyMHNlY3Rpb24lMEElMjAlMjAlMjAlMjBmbGFncyUzRHJlLk1VTFRJTElORSUyMCU3QyUyMHJlLkRPVEFMTCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEZsZXhpYmxlJTIwcGF0dGVybiUyMG1hdGNoaW5nJTBBKQ==",highlighted:`<span class="hljs-comment"># Compiled regex patterns for efficient reward computation</span>
match_format = re.<span class="hljs-built_in">compile</span>(
    <span class="hljs-string">rf&quot;^[\\s]{{0,}}&quot;</span>                      <span class="hljs-comment"># Optional whitespace at start</span>
    <span class="hljs-string">rf&quot;<span class="hljs-subst">{reasoning_start}</span>.+?<span class="hljs-subst">{reasoning_end}</span>.*?&quot;</span>  <span class="hljs-comment"># Reasoning section (non-greedy)</span>
    <span class="hljs-string">rf&quot;<span class="hljs-subst">{solution_start}</span>(.+?)<span class="hljs-subst">{solution_end}</span>&quot;</span>     <span class="hljs-comment"># Solution section with capture group</span>
    <span class="hljs-string">rf&quot;[\\s]{{0,}}$&quot;</span>,                     <span class="hljs-comment"># Optional whitespace at end</span>
    flags=re.MULTILINE | re.DOTALL       <span class="hljs-comment"># Multi-line matching with . matching newlines</span>
)

match_numbers = re.<span class="hljs-built_in">compile</span>(
    <span class="hljs-string">rf&quot;<span class="hljs-subst">{solution_start}</span>.*?([\\d\\.]{{1,}})&quot;</span>, <span class="hljs-comment"># Extract numbers from solution section</span>
    flags=re.MULTILINE | re.DOTALL        <span class="hljs-comment"># Flexible pattern matching</span>
)`,wrap:!1}}),P=new w({props:{code:"JTIzJTIwUmV3YXJkJTIwRnVuY3Rpb24lMjAxJTNBJTIwRXhhY3QlMjBGb3JtYXQlMjBDb21wbGlhbmNlJTBBZGVmJTIwbWF0Y2hfZm9ybWF0X2V4YWN0bHkoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBIaWdoJTIwcmV3YXJkJTIwKDMuMCklMjBmb3IlMjBwZXJmZWN0JTIwZm9ybWF0JTIwYWRoZXJlbmNlJTBBJTIwJTIwJTIwJTIwRW5zdXJlcyUyMG1vZGVsJTIwbGVhcm5zJTIwdGhlJTIwY29tcGxldGUlMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTIwcGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGNvbXBsZXRpb24lMjBpbiUyMGNvbXBsZXRpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjb21wbGV0aW9uJTVCMCU1RCU1QiUyMmNvbnRlbnQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDaGVjayUyMGlmJTIwcmVzcG9uc2UlMjBtYXRjaGVzJTIwY29tcGxldGUlMjBmb3JtYXQlMjBwYXR0ZXJuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlM0QlMjAzLjAlMjBpZiUyMG1hdGNoX2Zvcm1hdC5zZWFyY2gocmVzcG9uc2UpJTIwaXMlMjBub3QlMjBOb25lJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3Jlcy5hcHBlbmQoc2NvcmUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NvcmVz",highlighted:`<span class="hljs-comment"># Reward Function 1: Exact Format Compliance</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">match_format_exactly</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    High reward (3.0) for perfect format adherence
    Ensures model learns the complete structured output pattern
    &quot;&quot;&quot;</span>
    scores = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        response = completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>]
        <span class="hljs-comment"># Check if response matches complete format pattern</span>
        score = <span class="hljs-number">3.0</span> <span class="hljs-keyword">if</span> match_format.search(response) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>
        scores.append(score)
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),O=new w({props:{code:"JTIzJTIwUmV3YXJkJTIwRnVuY3Rpb24lMjAyJTNBJTIwUGFydGlhbCUyMEZvcm1hdCUyMENyZWRpdCUwQWRlZiUyMG1hdGNoX2Zvcm1hdF9hcHByb3hpbWF0ZWx5KGNvbXBsZXRpb25zJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwR3JhZHVhdGVkJTIwc2NvcmluZyUyMGZvciUyMGZvcm1hdCUyMGVsZW1lbnRzJTBBJTIwJTIwJTIwJTIwRW5jb3VyYWdlcyUyMGxlYXJuaW5nJTIwaW5kaXZpZHVhbCUyMGNvbXBvbmVudHMlMjBldmVuJTIwaWYlMjBub3QlMjBwZXJmZWN0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwc2NvcmVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGNvbXBsZXRpb24lNUIwJTVEJTVCJTIyY29udGVudCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEF3YXJkJTIwJTJCMC41JTIwZm9yJTIwY29ycmVjdCUyMHRva2VuJTIwY291bnQlMkMlMjAtMC41JTIwZm9yJTIwd3JvbmclMjBjb3VudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTJCJTNEJTIwMC41JTIwaWYlMjByZXNwb25zZS5jb3VudChyZWFzb25pbmdfc3RhcnQpJTIwJTNEJTNEJTIwMSUyMGVsc2UlMjAtMC41JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlMkIlM0QlMjAwLjUlMjBpZiUyMHJlc3BvbnNlLmNvdW50KHJlYXNvbmluZ19lbmQpJTIwJTNEJTNEJTIwMSUyMGVsc2UlMjAtMC41JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlMkIlM0QlMjAwLjUlMjBpZiUyMHJlc3BvbnNlLmNvdW50KHNvbHV0aW9uX3N0YXJ0KSUyMCUzRCUzRCUyMDElMjBlbHNlJTIwLTAuNSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTIwJTJCJTNEJTIwMC41JTIwaWYlMjByZXNwb25zZS5jb3VudChzb2x1dGlvbl9lbmQpJTIwJTNEJTNEJTIwMSUyMGVsc2UlMjAtMC41JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChzY29yZSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZXM=",highlighted:`<span class="hljs-comment"># Reward Function 2: Partial Format Credit</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">match_format_approximately</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Graduated scoring for format elements
    Encourages learning individual components even if not perfect
    &quot;&quot;&quot;</span>
    scores = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        response = completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>]
        score = <span class="hljs-number">0</span>
        
        <span class="hljs-comment"># Award +0.5 for correct token count, -0.5 for wrong count</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(reasoning_start) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(reasoning_end) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(solution_start) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        score += <span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> response.count(solution_end) == <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> -<span class="hljs-number">0.5</span>
        
        scores.append(score)
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),ll=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Reward Function 3: Mathematical Accuracy</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_answer_correctness</span>(<span class="hljs-params">prompts, completions, answer, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Graduated scoring for mathematical accuracy:
    - 3.0: Exact match
    - 1.5: Within 10% (close answer)
    - 0.5: Within 20% (reasonable attempt)
    - -0.5: Wrong answer (penalty for incorrect math)
    &quot;&quot;&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    
    <span class="hljs-comment"># Extract answers using format pattern</span>
    extracted_responses = [
        guess.group(<span class="hljs-number">1</span>) <span class="hljs-keyword">if</span> (guess := match_format.search(r)) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
        <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses
    ]
    
    scores = []
    <span class="hljs-keyword">for</span> guess, true_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(extracted_responses, answer):
        <span class="hljs-keyword">if</span> guess <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:  <span class="hljs-comment"># No extractable answer</span>
            scores.append(<span class="hljs-number">0</span>)
            <span class="hljs-keyword">continue</span>
            
        <span class="hljs-comment"># Exact string match gets full points</span>
        <span class="hljs-keyword">if</span> guess.strip() == true_answer.strip():
            scores.append(<span class="hljs-number">3.0</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-comment"># Try numerical comparison for partial credit</span>
            <span class="hljs-keyword">try</span>:
                ratio = <span class="hljs-built_in">float</span>(guess) / <span class="hljs-built_in">float</span>(true_answer)
                <span class="hljs-keyword">if</span> <span class="hljs-number">0.9</span> &lt;= ratio &lt;= <span class="hljs-number">1.1</span>:      <span class="hljs-comment"># Within 10%</span>
                    scores.append(<span class="hljs-number">1.5</span>)
                <span class="hljs-keyword">elif</span> <span class="hljs-number">0.8</span> &lt;= ratio &lt;= <span class="hljs-number">1.2</span>:    <span class="hljs-comment"># Within 20%</span>
                    scores.append(<span class="hljs-number">0.5</span>)
                <span class="hljs-keyword">else</span>:                         <span class="hljs-comment"># Wrong answer</span>
                    scores.append(-<span class="hljs-number">0.5</span>)
            <span class="hljs-keyword">except</span> (ValueError, ZeroDivisionError):
                scores.append(-<span class="hljs-number">0.5</span>)           <span class="hljs-comment"># Invalid numerical format</span>
    
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),sl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Reward Function 4: Number Extraction Ability  </span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_numbers_extraction</span>(<span class="hljs-params">prompts, completions, answer, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Tests the model&#x27;s ability to extract numerical values from solution sections
    Complementary to exact format matching - focuses on parsing capability
    &quot;&quot;&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    
    <span class="hljs-comment"># Extract numbers from solution sections using number pattern</span>
    extracted_responses = [
        guess.group(<span class="hljs-number">1</span>) <span class="hljs-keyword">if</span> (guess := match_numbers.search(r)) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
        <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses
    ]
    
    scores = []
    <span class="hljs-keyword">for</span> guess, true_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(extracted_responses, answer):
        <span class="hljs-keyword">if</span> guess <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:  <span class="hljs-comment"># No extractable number</span>
            scores.append(<span class="hljs-number">0</span>)
            <span class="hljs-keyword">continue</span>
            
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># Simple numerical equality check</span>
            true_val = <span class="hljs-built_in">float</span>(true_answer.strip())
            guess_val = <span class="hljs-built_in">float</span>(guess.strip())
            <span class="hljs-comment"># Binary scoring: correct (1.5) or incorrect (0)</span>
            scores.append(<span class="hljs-number">1.5</span> <span class="hljs-keyword">if</span> guess_val == true_val <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>)
        <span class="hljs-keyword">except</span> (ValueError, TypeError):
            scores.append(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Invalid number format</span>
    
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),al=new o({props:{title:"GRPO Training Setup",local:"grpo-training-setup",headingTag:"h2"}}),Ml=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Configure GRPO training parameters for mathematical reasoning</span>
training_args = GRPOConfig(
    <span class="hljs-comment"># Learning parameters optimized for reasoning tasks</span>
    learning_rate=<span class="hljs-number">5e-6</span>,              <span class="hljs-comment"># Conservative LR to prevent destabilizing reasoning</span>
    
    <span class="hljs-comment"># Memory-efficient batch configuration</span>
    per_device_train_batch_size=<span class="hljs-number">2</span>,   <span class="hljs-comment"># Small batch for GPU memory constraints</span>
    gradient_accumulation_steps=<span class="hljs-number">8</span>,   <span class="hljs-comment"># Effective batch size = 2 * 8 = 16</span>
    
    <span class="hljs-comment"># Sequence length limits for mathematical problems</span>
    max_prompt_length=<span class="hljs-number">1024</span>,          <span class="hljs-comment"># Sufficient for complex word problems</span>
    max_completion_length=<span class="hljs-number">1024</span>,      <span class="hljs-comment"># Room for detailed step-by-step reasoning</span>
    
    <span class="hljs-comment"># Training duration and monitoring</span>
    max_steps=<span class="hljs-number">10</span>,                    <span class="hljs-comment"># Short demo run (increase to 500+ for production)</span>
    logging_steps=<span class="hljs-number">1</span>,                 <span class="hljs-comment"># Log metrics every step for close monitoring</span>
    
    <span class="hljs-comment"># Stability and output configuration</span>
    output_dir=<span class="hljs-string">&quot;./trl_grpo_outputs&quot;</span>,
    max_grad_norm=<span class="hljs-number">0.1</span>,               <span class="hljs-comment"># Aggressive gradient clipping for stable training</span>
    report_to=<span class="hljs-string">&quot;trackio&quot;</span>,                <span class="hljs-comment"># use trackio for experiment tracking (instead of wandb/tensorboard)</span>
)`,wrap:!1}}),tl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Create unique run name with timestamp to ensure fresh tracking</span>
<span class="hljs-keyword">import</span> datetime
timestamp = datetime.datetime.now().strftime(<span class="hljs-string">&quot;%Y%m%d-%H%M%S&quot;</span>)
run_name = <span class="hljs-string">f&quot;qwen2.5-3b-gsm8k-grpo-<span class="hljs-subst">{timestamp}</span>&quot;</span>

<span class="hljs-comment"># Initialize trackio experiment tracking with unique run name</span>
trackio.init(
    project=<span class="hljs-string">&quot;GRPO-Mathematical-Reasoning&quot;</span>,  <span class="hljs-comment"># Project name for organization</span>
    name=run_name,                         <span class="hljs-comment"># Unique run identifier with timestamp</span>
    config={
        <span class="hljs-comment"># Model and dataset configuration</span>
        <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Qwen/Qwen2.5-3B-Instruct&quot;</span>,
        <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;GSM8K&quot;</span>, 
        <span class="hljs-string">&quot;technique&quot;</span>: <span class="hljs-string">&quot;GRPO + LoRA + 4-bit&quot;</span>,
        
        <span class="hljs-comment"># Training hyperparameters</span>
        <span class="hljs-string">&quot;learning_rate&quot;</span>: training_args.learning_rate,
        <span class="hljs-string">&quot;batch_size&quot;</span>: training_args.per_device_train_batch_size,
        <span class="hljs-string">&quot;gradient_accumulation_steps&quot;</span>: training_args.gradient_accumulation_steps,
        <span class="hljs-string">&quot;effective_batch_size&quot;</span>: training_args.per_device_train_batch_size * training_args.gradient_accumulation_steps,
        <span class="hljs-string">&quot;max_steps&quot;</span>: training_args.max_steps,
        
        <span class="hljs-comment"># LoRA configuration</span>
        <span class="hljs-string">&quot;lora_r&quot;</span>: <span class="hljs-number">16</span>,
        <span class="hljs-string">&quot;lora_alpha&quot;</span>: <span class="hljs-number">32</span>,
        
        <span class="hljs-comment"># GRPO-specific settings</span>
        <span class="hljs-string">&quot;num_generations&quot;</span>: training_args.num_generations,  <span class="hljs-comment"># Default: 8 generations per step</span>
        <span class="hljs-string">&quot;max_prompt_length&quot;</span>: training_args.max_prompt_length,
        <span class="hljs-string">&quot;max_completion_length&quot;</span>: training_args.max_completion_length,
        
        <span class="hljs-comment"># Reward system</span>
        <span class="hljs-string">&quot;num_reward_functions&quot;</span>: <span class="hljs-number">4</span>,
    }
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎯 GRPO Configuration Summary:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Learning rate: <span class="hljs-subst">{training_args.learning_rate}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Effective batch size: <span class="hljs-subst">{training_args.per_device_train_batch_size * training_args.gradient_accumulation_steps}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Training steps: <span class="hljs-subst">{training_args.max_steps}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   Generations per step: <span class="hljs-subst">{training_args.num_generations}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Trackio experiment tracking initialized&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Run name: <span class="hljs-subst">{run_name}</span>&quot;</span>)`,wrap:!1}}),el=new o({props:{title:"Trainer Initialization with Trackio Integration",local:"trainer-initialization-with-trackio-integration",headingTag:"h2"}}),pl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Initialize GRPO trainer with multi-reward system</span>
<span class="hljs-comment"># trackio_callback = TrackioCallback()  # Create trackio logging callback</span>

trainer = GRPOTrainer(
    model=model,                      <span class="hljs-comment"># LoRA-adapted quantized model</span>
    reward_funcs=[                    <span class="hljs-comment"># Four complementary reward functions</span>
        match_format_exactly,         <span class="hljs-comment"># Perfect structure compliance</span>
        match_format_approximately,   <span class="hljs-comment"># Partial format credit</span>
        check_answer_correctness,     <span class="hljs-comment"># Mathematical accuracy</span>
        check_numbers_extraction,     <span class="hljs-comment"># Number parsing ability</span>
    ],
    args=training_args,               <span class="hljs-comment"># Training configuration</span>
    train_dataset=dataset,            <span class="hljs-comment"># Processed GSM8K dataset</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ GRPO Trainer initialized successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Training dataset: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span> examples&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Reward functions: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(trainer.reward_funcs)}</span> active&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📈 Trackio integration: Enabled&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔄 Ready for training with <span class="hljs-subst">{training_args.num_generations}</span> generations per step&quot;</span>)`,wrap:!1}}),yl=new o({props:{title:"Begin GRPO Training",local:"begin-grpo-training",headingTag:"h2"}}),jl=new w({props:{code:"JTIzJTIwRXhlY3V0ZSUyMEdSUE8lMjB0cmFpbmluZyUyMHdpdGglMjBtdWx0aS1yZXdhcmQlMjBvcHRpbWl6YXRpb24lMEFwcmludCglMjIlRjAlOUYlOUElODAlMjBTdGFydGluZyUyMEdSUE8lMjB0cmFpbmluZy4uLiUyMiklMEFwcmludCglMjIlRjAlOUYlOTMlOEElMjBNb25pdG9yJTIwbWV0cmljcyUzQSUyMHJld2FyZCUyMHNjb3JlcyUyQyUyMEtMJTIwZGl2ZXJnZW5jZSUyQyUyMHBvbGljeSUyMGdyYWRpZW50cyUyMiklMEFwcmludCglMjIlRjAlOUYlOTQlOEQlMjBUcmFja2lvJTIwd2lsbCUyMGxvZyUzQSUyMGxvc3NlcyUyQyUyMHJld2FyZHMlMkMlMjBsZWFybmluZyUyMHJhdGUlMkMlMjBncmFkaWVudHMlMjIpJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwdHJhaW5pbmclMjBwcm9jZXNzJTBBdHJhaW5lci50cmFpbigpJTBBJTBBJTIzJTIwQ29tcGxldGUlMjB0aGUlMjB0cmFja2lvJTIwZXhwZXJpbWVudCUwQXRyYWNraW8uZmluaXNoKCklMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBUcmFpbmluZyUyMGNvbXBsZXRlZCUyMHN1Y2Nlc3NmdWxseSElMjIpJTBBcHJpbnQoZiUyMiVGMCU5RiU5MiVCRSUyME1vZGVsJTIwc2F2ZWQlMjB0byUzQSUyMCU3QnRyYWluaW5nX2FyZ3Mub3V0cHV0X2RpciU3RCUyMik=",highlighted:`<span class="hljs-comment"># Execute GRPO training with multi-reward optimization</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Starting GRPO training...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📊 Monitor metrics: reward scores, KL divergence, policy gradients&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔍 Trackio will log: losses, rewards, learning rate, gradients&quot;</span>)

<span class="hljs-comment"># Run the training process</span>
trainer.train()

<span class="hljs-comment"># Complete the trackio experiment</span>
trackio.finish()

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Training completed successfully!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;💾 Model saved to: <span class="hljs-subst">{training_args.output_dir}</span>&quot;</span>)`,wrap:!1}}),il=new o({props:{title:"Experiment Dashboard",local:"experiment-dashboard",headingTag:"h2"}}),wl=new w({props:{code:"JTIzJTIwTGF1bmNoJTIwaW50ZXJhY3RpdmUlMjB0cmFja2lvJTIwZGFzaGJvYXJkJTIwZm9yJTIwZXhwZXJpbWVudCUyMGFuYWx5c2lzJTBBJTIzJTIwVmlldyUyMHRyYWluaW5nJTIwY3VydmVzJTJDJTIwcmV3YXJkJTIwcHJvZ3Jlc3Npb24lMkMlMjBsb3NzJTIwZXZvbHV0aW9uJTJDJTIwYW5kJTIwaHlwZXJwYXJhbWV0ZXIlMjBlZmZlY3RzJTBBdHJhY2tpby5zaG93KHByb2plY3QlM0QlMjJHUlBPLU1hdGhlbWF0aWNhbC1SZWFzb25pbmclMjIpJTBBJTBBJTBBJTIzJTIwQWx0ZXJuYXRpdmUlM0ElMjBMYXVuY2glMjBmcm9tJTIwY29tbWFuZCUyMGxpbmUlMjB3aXRoJTNBJTIwdHJhY2tpbyUyMHNob3clMjAtLXByb2plY3QlMjAlMjJHUlBPLU1hdGhlbWF0aWNhbC1SZWFzb25pbmclMjI=",highlighted:`<span class="hljs-comment"># Launch interactive trackio dashboard for experiment analysis</span>
<span class="hljs-comment"># View training curves, reward progression, loss evolution, and hyperparameter effects</span>
trackio.show(project=<span class="hljs-string">&quot;GRPO-Mathematical-Reasoning&quot;</span>)


<span class="hljs-comment"># Alternative: Launch from command line with: trackio show --project &quot;GRPO-Mathematical-Reasoning&quot;</span>`,wrap:!1}}),Ul=new o({props:{title:"Model Evaluation and Testing",local:"model-evaluation-and-testing",headingTag:"h2"}}),rl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Define model testing function with optimized generation parameters</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_model</span>(<span class="hljs-params">question, max_length=<span class="hljs-number">512</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Test the trained model on mathematical questions
    
    Args:
        question (str): Mathematical problem to solve
        max_length (int): Maximum tokens to generate
        
    Returns:
        str: Model&#x27;s structured response with reasoning and solution
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Format input using conversation template</span>
    messages = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
    ]
    
    <span class="hljs-comment"># Apply chat template and tokenize</span>
    text = tokenizer.apply_chat_template(
        messages,
        add_generation_prompt=<span class="hljs-literal">True</span>,      <span class="hljs-comment"># Add assistant prompt</span>
        tokenize=<span class="hljs-literal">False</span>,                  <span class="hljs-comment"># Return string, not tokens</span>
    )
    
    <span class="hljs-comment"># Tokenize and move to appropriate device</span>
    inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤔 Processing: <span class="hljs-subst">{question}</span>&quot;</span>)
    
    <span class="hljs-comment"># Generate response with reasoning-optimized parameters</span>
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model.generate(
            **inputs,
            max_new_tokens=max_length,
            temperature=<span class="hljs-number">0.7</span>,                    <span class="hljs-comment"># Balance creativity and consistency</span>
            do_sample=<span class="hljs-literal">True</span>,                     <span class="hljs-comment"># Enable sampling for varied reasoning paths</span>
            top_p=<span class="hljs-number">0.9</span>,                         <span class="hljs-comment"># Nucleus sampling for quality</span>
            pad_token_id=tokenizer.eos_token_id,
            repetition_penalty=<span class="hljs-number">1.1</span>,            <span class="hljs-comment"># Reduce repetitive reasoning steps</span>
            length_penalty=<span class="hljs-number">1.0</span>,                <span class="hljs-comment"># Neutral preference for response length</span>
            early_stopping=<span class="hljs-literal">True</span>,               <span class="hljs-comment"># Stop at natural completion</span>
        )
    
    <span class="hljs-comment"># Decode and extract only the generated portion</span>
    response = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
    generated_text = response[<span class="hljs-built_in">len</span>(text):].strip()
    
    <span class="hljs-keyword">return</span> generated_text`,wrap:!1}}),ml=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Test model on GSM8K problem</span>
gsm8k_question = <span class="hljs-string">&quot;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&quot;</span>
expected_answer = <span class="hljs-string">&quot;72&quot;</span>

<span class="hljs-comment"># Generate response</span>
gsm8k_response = test_model(gsm8k_question, max_length=<span class="hljs-number">768</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{gsm8k_question}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model Response:\\n<span class="hljs-subst">{gsm8k_response}</span>&quot;</span>)

<span class="hljs-comment"># Validate format compliance</span>
has_reasoning = reasoning_start <span class="hljs-keyword">in</span> gsm8k_response <span class="hljs-keyword">and</span> reasoning_end <span class="hljs-keyword">in</span> gsm8k_response
has_solution = solution_start <span class="hljs-keyword">in</span> gsm8k_response <span class="hljs-keyword">and</span> solution_end <span class="hljs-keyword">in</span> gsm8k_response

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nFormat Check:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Reasoning section: <span class="hljs-subst">{has_reasoning}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Solution section: <span class="hljs-subst">{has_solution}</span>&quot;</span>)

<span class="hljs-comment"># Check answer accuracy if solution section exists</span>
<span class="hljs-keyword">if</span> has_solution:
    <span class="hljs-keyword">try</span>:
        solution_text = gsm8k_response.split(solution_start)[<span class="hljs-number">1</span>].split(solution_end)[<span class="hljs-number">0</span>].strip()
        extracted_number = <span class="hljs-string">&#x27;&#x27;</span>.join(<span class="hljs-built_in">filter</span>(<span class="hljs-built_in">str</span>.isdigit, solution_text))
        expected_number = <span class="hljs-string">&#x27;&#x27;</span>.join(<span class="hljs-built_in">filter</span>(<span class="hljs-built_in">str</span>.isdigit, expected_answer))
        is_correct = extracted_number == expected_number
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Extracted: <span class="hljs-subst">{solution_text}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Expected: <span class="hljs-subst">{expected_answer}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Correct: <span class="hljs-subst">{is_correct}</span>&quot;</span>)
    <span class="hljs-keyword">except</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Could not extract solution&quot;</span>)`,wrap:!1}}),Il=new o({props:{title:"Clean Up Resources",local:"clean-up-resources",headingTag:"h2"}}),hl=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBZGVmJTIwcmVtb3ZlX3RyYWNraW9fcHJvamVjdChwcm9qZWN0X25hbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmVtb3ZlJTIwYSUyMHRyYWNraW8lMjBwcm9qZWN0JTIwYnklMjBkZWxldGluZyUyMGl0cyUyMGRhdGFiYXNlJTIwZmlsZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGNhY2hlX2RpciUyMCUzRCUyMFBhdGguaG9tZSgpJTIwJTJGJTIwJTIyLmNhY2hlJTIyJTIwJTJGJTIwJTIyaHVnZ2luZ2ZhY2UlMjIlMjAlMkYlMjAlMjJ0cmFja2lvJTIyJTBBJTIwJTIwJTIwJTIwZGJfZmlsZSUyMCUzRCUyMGNhY2hlX2RpciUyMCUyRiUyMGYlMjIlN0Jwcm9qZWN0X25hbWUlN0QuZGIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBpZiUyMGRiX2ZpbGUuZXhpc3RzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYl9maWxlLnVubGluaygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlJlbW92ZWQlMjB0cmFja2lvJTIwcHJvamVjdCUzQSUyMCU3QnByb2plY3RfbmFtZSU3RCUyMiklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByb2plY3QlMjBub3QlMjBmb3VuZCUzQSUyMCU3QnByb2plY3RfbmFtZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_trackio_project</span>(<span class="hljs-params">project_name</span>):
    <span class="hljs-string">&quot;&quot;&quot;Remove a trackio project by deleting its database file&quot;&quot;&quot;</span>
    cache_dir = Path.home() / <span class="hljs-string">&quot;.cache&quot;</span> / <span class="hljs-string">&quot;huggingface&quot;</span> / <span class="hljs-string">&quot;trackio&quot;</span>
    db_file = cache_dir / <span class="hljs-string">f&quot;<span class="hljs-subst">{project_name}</span>.db&quot;</span>
    
    <span class="hljs-keyword">if</span> db_file.exists():
        db_file.unlink()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Removed trackio project: <span class="hljs-subst">{project_name}</span>&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Project not found: <span class="hljs-subst">{project_name}</span>&quot;</span>)`,wrap:!1}}),bl=new w({props:{code:"JTIzJTIwQ2xlYW4lMjB1cCUyMHRyYWNraW8lMjBleHBlcmltZW50JTIwZGF0YWJhc2UlMjB0byUyMGZyZWUlMjBzdG9yYWdlJTIwc3BhY2UlMEElMjMlMjBXQVJOSU5HJTNBJTIwVGhpcyUyMHBlcm1hbmVudGx5JTIwZGVsZXRlcyUyMGFsbCUyMGV4cGVyaW1lbnQlMjBsb2dzJTIwYW5kJTIwbWV0cmljcyUwQXJlbW92ZV90cmFja2lvX3Byb2plY3QoJTIyR1JQTy1NYXRoZW1hdGljYWwtUmVhc29uaW5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Clean up trackio experiment database to free storage space</span>
<span class="hljs-comment"># WARNING: This permanently deletes all experiment logs and metrics</span>
remove_trackio_project(<span class="hljs-string">&quot;GRPO-Mathematical-Reasoning&quot;</span>)`,wrap:!1}}),dl=new w({props:{code:"JTIzJTIwRnJlZSUyMEdQVSUyMG1lbW9yeSUyMGFuZCUyMGNsZWFyJTIwUHl0aG9uJTIwZ2FyYmFnZSUyMGNvbGxlY3Rpb24lMEFpbXBvcnQlMjBnYyUwQSUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKSUyMCUyMCUyMyUyMENsZWFyJTIwUHlUb3JjaCUyMENVREElMjBtZW1vcnklMjBjYWNoZSUwQWdjLmNvbGxlY3QoKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMFB5dGhvbiUyMGdhcmJhZ2UlMjBjb2xsZWN0b3IlMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBHUFUlMjBtZW1vcnklMjBjYWNoZSUyMGNsZWFyZWQlMjIpJTBBcHJpbnQoJTIyJUUyJTlDJTg1JTIwUHl0aG9uJTIwZ2FyYmFnZSUyMGNvbGxlY3Rpb24lMjBjb21wbGV0ZWQlMjIpJTBBcHJpbnQoJTIyJUYwJTlGJUE3JUI5JTIwUmVzb3VyY2VzJTIwZnJlZWQlMjBmb3IlMjBvdGhlciUyMHByb2Nlc3NlcyUyMik=",highlighted:`<span class="hljs-comment"># Free GPU memory and clear Python garbage collection</span>
<span class="hljs-keyword">import</span> gc

torch.cuda.empty_cache()  <span class="hljs-comment"># Clear PyTorch CUDA memory cache</span>
gc.collect()              <span class="hljs-comment"># Run Python garbage collector</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ GPU memory cache cleared&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Python garbage collection completed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🧹 Resources freed for other processes&quot;</span>)`,wrap:!1}}),Cl=new o({props:{title:"References",local:"references",headingTag:"h2"}}),Bl=new o({props:{title:"Papers and Research",local:"papers-and-research",headingTag:"h3"}}),gl=new o({props:{title:"Libraries and Frameworks",local:"libraries-and-frameworks",headingTag:"h3"}}),Gl=new o({props:{title:"Models Used",local:"models-used",headingTag:"h3"}}),fl=new o({props:{title:"Datasets",local:"datasets",headingTag:"h3"}}),Xl=new o({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h3"}}),Vl=new Ea({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/trl_grpo_reasoning_advanced_reward.md"}}),{c(){r=i("meta"),Fl=M(),Yl=i("p"),zl=M(),e(m.$$.fragment),kl=M(),e(I.$$.fragment),El=M(),e(u.$$.fragment),vl=M(),h=i("p"),h.innerHTML=ea,Sl=M(),b=i("p"),b.innerHTML=Ja,Hl=M(),d=i("p"),d.innerHTML=pa,_l=M(),C=i("ul"),C.innerHTML=ya,$l=M(),B=i("p"),B.textContent=Ta,ql=M(),e(A.$$.fragment),xl=M(),g=i("p"),g.textContent=ja,Ll=M(),e(Z.$$.fragment),Kl=M(),e(G.$$.fragment),Dl=M(),W=i("p"),W.textContent=ia,Pl=M(),e(f.$$.fragment),Ol=M(),e(R.$$.fragment),ls=M(),X=i("p"),X.textContent=ca,ss=M(),e(N.$$.fragment),as=M(),e(V.$$.fragment),ns=M(),Y=i("p"),Y.textContent=wa,Ms=M(),e(Q.$$.fragment),ts=M(),e(F.$$.fragment),es=M(),e(z.$$.fragment),Js=M(),e(k.$$.fragment),ps=M(),E=i("p"),E.textContent=Ua,ys=M(),e(v.$$.fragment),Ts=M(),e(S.$$.fragment),js=M(),H=i("p"),H.textContent=oa,is=M(),e(_.$$.fragment),cs=M(),e($.$$.fragment),ws=M(),e(q.$$.fragment),Us=M(),e(x.$$.fragment),os=M(),L=i("p"),L.textContent=ra,rs=M(),K=i("ol"),K.innerHTML=ma,ms=M(),e(D.$$.fragment),Is=M(),e(P.$$.fragment),us=M(),e(O.$$.fragment),hs=M(),e(ll.$$.fragment),bs=M(),e(sl.$$.fragment),ds=M(),e(al.$$.fragment),Cs=M(),nl=i("p"),nl.textContent=Ia,Bs=M(),e(Ml.$$.fragment),As=M(),e(tl.$$.fragment),gs=M(),e(el.$$.fragment),Zs=M(),Jl=i("p"),Jl.textContent=ua,Gs=M(),e(pl.$$.fragment),Ws=M(),e(yl.$$.fragment),fs=M(),Tl=i("p"),Tl.textContent=ha,Rs=M(),e(jl.$$.fragment),Xs=M(),e(il.$$.fragment),Ns=M(),cl=i("p"),cl.textContent=ba,Vs=M(),e(wl.$$.fragment),Ys=M(),e(Ul.$$.fragment),Qs=M(),ol=i("p"),ol.textContent=da,Fs=M(),e(rl.$$.fragment),zs=M(),e(ml.$$.fragment),ks=M(),e(Il.$$.fragment),Es=M(),ul=i("p"),ul.textContent=Ca,vs=M(),e(hl.$$.fragment),Ss=M(),e(bl.$$.fragment),Hs=M(),e(dl.$$.fragment),_s=M(),e(Cl.$$.fragment),$s=M(),e(Bl.$$.fragment),qs=M(),Al=i("ul"),Al.innerHTML=Ba,xs=M(),e(gl.$$.fragment),Ls=M(),Zl=i("ul"),Zl.innerHTML=Aa,Ks=M(),e(Gl.$$.fragment),Ds=M(),Wl=i("ul"),Wl.innerHTML=ga,Ps=M(),e(fl.$$.fragment),Os=M(),Rl=i("ul"),Rl.innerHTML=Za,la=M(),e(Xl.$$.fragment),sa=M(),Nl=i("ul"),Nl.innerHTML=Ga,aa=M(),e(Vl.$$.fragment),na=M(),Ql=i("p"),this.h()},l(l){const s=Qa("svelte-u9bgzb",document.head);r=c(s,"META",{name:!0,content:!0}),s.forEach(a),Fl=t(l),Yl=c(l,"P",{}),Wa(Yl).forEach(a),zl=t(l),J(m.$$.fragment,l),kl=t(l),J(I.$$.fragment,l),El=t(l),J(u.$$.fragment,l),vl=t(l),h=c(l,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1wcfxf7"&&(h.innerHTML=ea),Sl=t(l),b=c(l,"P",{"data-svelte-h":!0}),U(b)!=="svelte-6p9g8x"&&(b.innerHTML=Ja),Hl=t(l),d=c(l,"P",{"data-svelte-h":!0}),U(d)!=="svelte-dcww01"&&(d.innerHTML=pa),_l=t(l),C=c(l,"UL",{"data-svelte-h":!0}),U(C)!=="svelte-1hq0wzg"&&(C.innerHTML=ya),$l=t(l),B=c(l,"P",{"data-svelte-h":!0}),U(B)!=="svelte-17fp8qc"&&(B.textContent=Ta),ql=t(l),J(A.$$.fragment,l),xl=t(l),g=c(l,"P",{"data-svelte-h":!0}),U(g)!=="svelte-1mnh5n9"&&(g.textContent=ja),Ll=t(l),J(Z.$$.fragment,l),Kl=t(l),J(G.$$.fragment,l),Dl=t(l),W=c(l,"P",{"data-svelte-h":!0}),U(W)!=="svelte-1lu8zsw"&&(W.textContent=ia),Pl=t(l),J(f.$$.fragment,l),Ol=t(l),J(R.$$.fragment,l),ls=t(l),X=c(l,"P",{"data-svelte-h":!0}),U(X)!=="svelte-1ylljg7"&&(X.textContent=ca),ss=t(l),J(N.$$.fragment,l),as=t(l),J(V.$$.fragment,l),ns=t(l),Y=c(l,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-6voocq"&&(Y.textContent=wa),Ms=t(l),J(Q.$$.fragment,l),ts=t(l),J(F.$$.fragment,l),es=t(l),J(z.$$.fragment,l),Js=t(l),J(k.$$.fragment,l),ps=t(l),E=c(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-vh53r0"&&(E.textContent=Ua),ys=t(l),J(v.$$.fragment,l),Ts=t(l),J(S.$$.fragment,l),js=t(l),H=c(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-lfycyc"&&(H.textContent=oa),is=t(l),J(_.$$.fragment,l),cs=t(l),J($.$$.fragment,l),ws=t(l),J(q.$$.fragment,l),Us=t(l),J(x.$$.fragment,l),os=t(l),L=c(l,"P",{"data-svelte-h":!0}),U(L)!=="svelte-jcs93c"&&(L.textContent=ra),rs=t(l),K=c(l,"OL",{"data-svelte-h":!0}),U(K)!=="svelte-1ei9pa4"&&(K.innerHTML=ma),ms=t(l),J(D.$$.fragment,l),Is=t(l),J(P.$$.fragment,l),us=t(l),J(O.$$.fragment,l),hs=t(l),J(ll.$$.fragment,l),bs=t(l),J(sl.$$.fragment,l),ds=t(l),J(al.$$.fragment,l),Cs=t(l),nl=c(l,"P",{"data-svelte-h":!0}),U(nl)!=="svelte-1cgqac7"&&(nl.textContent=Ia),Bs=t(l),J(Ml.$$.fragment,l),As=t(l),J(tl.$$.fragment,l),gs=t(l),J(el.$$.fragment,l),Zs=t(l),Jl=c(l,"P",{"data-svelte-h":!0}),U(Jl)!=="svelte-te58gc"&&(Jl.textContent=ua),Gs=t(l),J(pl.$$.fragment,l),Ws=t(l),J(yl.$$.fragment,l),fs=t(l),Tl=c(l,"P",{"data-svelte-h":!0}),U(Tl)!=="svelte-1dre9tl"&&(Tl.textContent=ha),Rs=t(l),J(jl.$$.fragment,l),Xs=t(l),J(il.$$.fragment,l),Ns=t(l),cl=c(l,"P",{"data-svelte-h":!0}),U(cl)!=="svelte-1r7ghy8"&&(cl.textContent=ba),Vs=t(l),J(wl.$$.fragment,l),Ys=t(l),J(Ul.$$.fragment,l),Qs=t(l),ol=c(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-15chlyi"&&(ol.textContent=da),Fs=t(l),J(rl.$$.fragment,l),zs=t(l),J(ml.$$.fragment,l),ks=t(l),J(Il.$$.fragment,l),Es=t(l),ul=c(l,"P",{"data-svelte-h":!0}),U(ul)!=="svelte-rt167n"&&(ul.textContent=Ca),vs=t(l),J(hl.$$.fragment,l),Ss=t(l),J(bl.$$.fragment,l),Hs=t(l),J(dl.$$.fragment,l),_s=t(l),J(Cl.$$.fragment,l),$s=t(l),J(Bl.$$.fragment,l),qs=t(l),Al=c(l,"UL",{"data-svelte-h":!0}),U(Al)!=="svelte-1yuqaza"&&(Al.innerHTML=Ba),xs=t(l),J(gl.$$.fragment,l),Ls=t(l),Zl=c(l,"UL",{"data-svelte-h":!0}),U(Zl)!=="svelte-1f7hqi0"&&(Zl.innerHTML=Aa),Ks=t(l),J(Gl.$$.fragment,l),Ds=t(l),Wl=c(l,"UL",{"data-svelte-h":!0}),U(Wl)!=="svelte-1gpkmz1"&&(Wl.innerHTML=ga),Ps=t(l),J(fl.$$.fragment,l),Os=t(l),Rl=c(l,"UL",{"data-svelte-h":!0}),U(Rl)!=="svelte-sgvdwa"&&(Rl.innerHTML=Za),la=t(l),J(Xl.$$.fragment,l),sa=t(l),Nl=c(l,"UL",{"data-svelte-h":!0}),U(Nl)!=="svelte-189ntwt"&&(Nl.innerHTML=Ga),aa=t(l),J(Vl.$$.fragment,l),na=t(l),Ql=c(l,"P",{}),Wa(Ql).forEach(a),this.h()},h(){fa(r,"name","hf:doc:metadata"),fa(r,"content",Sa)},m(l,s){Fa(document.head,r),n(l,Fl,s),n(l,Yl,s),n(l,zl,s),p(m,l,s),n(l,kl,s),p(I,l,s),n(l,El,s),p(u,l,s),n(l,vl,s),n(l,h,s),n(l,Sl,s),n(l,b,s),n(l,Hl,s),n(l,d,s),n(l,_l,s),n(l,C,s),n(l,$l,s),n(l,B,s),n(l,ql,s),p(A,l,s),n(l,xl,s),n(l,g,s),n(l,Ll,s),p(Z,l,s),n(l,Kl,s),p(G,l,s),n(l,Dl,s),n(l,W,s),n(l,Pl,s),p(f,l,s),n(l,Ol,s),p(R,l,s),n(l,ls,s),n(l,X,s),n(l,ss,s),p(N,l,s),n(l,as,s),p(V,l,s),n(l,ns,s),n(l,Y,s),n(l,Ms,s),p(Q,l,s),n(l,ts,s),p(F,l,s),n(l,es,s),p(z,l,s),n(l,Js,s),p(k,l,s),n(l,ps,s),n(l,E,s),n(l,ys,s),p(v,l,s),n(l,Ts,s),p(S,l,s),n(l,js,s),n(l,H,s),n(l,is,s),p(_,l,s),n(l,cs,s),p($,l,s),n(l,ws,s),p(q,l,s),n(l,Us,s),p(x,l,s),n(l,os,s),n(l,L,s),n(l,rs,s),n(l,K,s),n(l,ms,s),p(D,l,s),n(l,Is,s),p(P,l,s),n(l,us,s),p(O,l,s),n(l,hs,s),p(ll,l,s),n(l,bs,s),p(sl,l,s),n(l,ds,s),p(al,l,s),n(l,Cs,s),n(l,nl,s),n(l,Bs,s),p(Ml,l,s),n(l,As,s),p(tl,l,s),n(l,gs,s),p(el,l,s),n(l,Zs,s),n(l,Jl,s),n(l,Gs,s),p(pl,l,s),n(l,Ws,s),p(yl,l,s),n(l,fs,s),n(l,Tl,s),n(l,Rs,s),p(jl,l,s),n(l,Xs,s),p(il,l,s),n(l,Ns,s),n(l,cl,s),n(l,Vs,s),p(wl,l,s),n(l,Ys,s),p(Ul,l,s),n(l,Qs,s),n(l,ol,s),n(l,Fs,s),p(rl,l,s),n(l,zs,s),p(ml,l,s),n(l,ks,s),p(Il,l,s),n(l,Es,s),n(l,ul,s),n(l,vs,s),p(hl,l,s),n(l,Ss,s),p(bl,l,s),n(l,Hs,s),p(dl,l,s),n(l,_s,s),p(Cl,l,s),n(l,$s,s),p(Bl,l,s),n(l,qs,s),n(l,Al,s),n(l,xs,s),p(gl,l,s),n(l,Ls,s),n(l,Zl,s),n(l,Ks,s),p(Gl,l,s),n(l,Ds,s),n(l,Wl,s),n(l,Ps,s),p(fl,l,s),n(l,Os,s),n(l,Rl,s),n(l,la,s),p(Xl,l,s),n(l,sa,s),n(l,Nl,s),n(l,aa,s),p(Vl,l,s),n(l,na,s),n(l,Ql,s),Ma=!0},p:Xa,i(l){Ma||(y(m.$$.fragment,l),y(I.$$.fragment,l),y(u.$$.fragment,l),y(A.$$.fragment,l),y(Z.$$.fragment,l),y(G.$$.fragment,l),y(f.$$.fragment,l),y(R.$$.fragment,l),y(N.$$.fragment,l),y(V.$$.fragment,l),y(Q.$$.fragment,l),y(F.$$.fragment,l),y(z.$$.fragment,l),y(k.$$.fragment,l),y(v.$$.fragment,l),y(S.$$.fragment,l),y(_.$$.fragment,l),y($.$$.fragment,l),y(q.$$.fragment,l),y(x.$$.fragment,l),y(D.$$.fragment,l),y(P.$$.fragment,l),y(O.$$.fragment,l),y(ll.$$.fragment,l),y(sl.$$.fragment,l),y(al.$$.fragment,l),y(Ml.$$.fragment,l),y(tl.$$.fragment,l),y(el.$$.fragment,l),y(pl.$$.fragment,l),y(yl.$$.fragment,l),y(jl.$$.fragment,l),y(il.$$.fragment,l),y(wl.$$.fragment,l),y(Ul.$$.fragment,l),y(rl.$$.fragment,l),y(ml.$$.fragment,l),y(Il.$$.fragment,l),y(hl.$$.fragment,l),y(bl.$$.fragment,l),y(dl.$$.fragment,l),y(Cl.$$.fragment,l),y(Bl.$$.fragment,l),y(gl.$$.fragment,l),y(Gl.$$.fragment,l),y(fl.$$.fragment,l),y(Xl.$$.fragment,l),y(Vl.$$.fragment,l),Ma=!0)},o(l){T(m.$$.fragment,l),T(I.$$.fragment,l),T(u.$$.fragment,l),T(A.$$.fragment,l),T(Z.$$.fragment,l),T(G.$$.fragment,l),T(f.$$.fragment,l),T(R.$$.fragment,l),T(N.$$.fragment,l),T(V.$$.fragment,l),T(Q.$$.fragment,l),T(F.$$.fragment,l),T(z.$$.fragment,l),T(k.$$.fragment,l),T(v.$$.fragment,l),T(S.$$.fragment,l),T(_.$$.fragment,l),T($.$$.fragment,l),T(q.$$.fragment,l),T(x.$$.fragment,l),T(D.$$.fragment,l),T(P.$$.fragment,l),T(O.$$.fragment,l),T(ll.$$.fragment,l),T(sl.$$.fragment,l),T(al.$$.fragment,l),T(Ml.$$.fragment,l),T(tl.$$.fragment,l),T(el.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(jl.$$.fragment,l),T(il.$$.fragment,l),T(wl.$$.fragment,l),T(Ul.$$.fragment,l),T(rl.$$.fragment,l),T(ml.$$.fragment,l),T(Il.$$.fragment,l),T(hl.$$.fragment,l),T(bl.$$.fragment,l),T(dl.$$.fragment,l),T(Cl.$$.fragment,l),T(Bl.$$.fragment,l),T(gl.$$.fragment,l),T(Gl.$$.fragment,l),T(fl.$$.fragment,l),T(Xl.$$.fragment,l),T(Vl.$$.fragment,l),Ma=!1},d(l){l&&(a(Fl),a(Yl),a(zl),a(kl),a(El),a(vl),a(h),a(Sl),a(b),a(Hl),a(d),a(_l),a(C),a($l),a(B),a(ql),a(xl),a(g),a(Ll),a(Kl),a(Dl),a(W),a(Pl),a(Ol),a(ls),a(X),a(ss),a(as),a(ns),a(Y),a(Ms),a(ts),a(es),a(Js),a(ps),a(E),a(ys),a(Ts),a(js),a(H),a(is),a(cs),a(ws),a(Us),a(os),a(L),a(rs),a(K),a(ms),a(Is),a(us),a(hs),a(bs),a(ds),a(Cs),a(nl),a(Bs),a(As),a(gs),a(Zs),a(Jl),a(Gs),a(Ws),a(fs),a(Tl),a(Rs),a(Xs),a(Ns),a(cl),a(Vs),a(Ys),a(Qs),a(ol),a(Fs),a(zs),a(ks),a(Es),a(ul),a(vs),a(Ss),a(Hs),a(_s),a($s),a(qs),a(Al),a(xs),a(Ls),a(Zl),a(Ks),a(Ds),a(Wl),a(Ps),a(Os),a(Rl),a(la),a(sa),a(Nl),a(aa),a(na),a(Ql)),a(r),j(m,l),j(I,l),j(u,l),j(A,l),j(Z,l),j(G,l),j(f,l),j(R,l),j(N,l),j(V,l),j(Q,l),j(F,l),j(z,l),j(k,l),j(v,l),j(S,l),j(_,l),j($,l),j(q,l),j(x,l),j(D,l),j(P,l),j(O,l),j(ll,l),j(sl,l),j(al,l),j(Ml,l),j(tl,l),j(el,l),j(pl,l),j(yl,l),j(jl,l),j(il,l),j(wl,l),j(Ul,l),j(rl,l),j(ml,l),j(Il,l),j(hl,l),j(bl,l),j(dl,l),j(Cl,l),j(Bl,l),j(gl,l),j(Gl,l),j(fl,l),j(Xl,l),j(Vl,l)}}}const Sa='{"title":"Advanced GRPO Fine-tuning for Mathematical Reasoning with Multi-Reward Training","local":"advanced-grpo-fine-tuning-for-mathematical-reasoning-with-multi-reward-training","sections":[{"title":"Installation and Setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"GPU Environment Detection","local":"gpu-environment-detection","sections":[],"depth":2},{"title":"Core Library Imports","local":"core-library-imports","sections":[],"depth":2},{"title":"Model Selection and Configuration","local":"model-selection-and-configuration","sections":[],"depth":2},{"title":"LoRA Configuration","local":"lora-configuration","sections":[],"depth":2},{"title":"GSM8K Dataset Setup","local":"gsm8k-dataset-setup","sections":[],"depth":2},{"title":"Multi-Reward System Design","local":"multi-reward-system-design","sections":[],"depth":2},{"title":"GRPO Training Setup","local":"grpo-training-setup","sections":[],"depth":2},{"title":"Trainer Initialization with Trackio Integration","local":"trainer-initialization-with-trackio-integration","sections":[],"depth":2},{"title":"Begin GRPO Training","local":"begin-grpo-training","sections":[],"depth":2},{"title":"Experiment Dashboard","local":"experiment-dashboard","sections":[],"depth":2},{"title":"Model Evaluation and Testing","local":"model-evaluation-and-testing","sections":[],"depth":2},{"title":"Clean Up Resources","local":"clean-up-resources","sections":[],"depth":2},{"title":"References","local":"references","sections":[{"title":"Papers and Research","local":"papers-and-research","sections":[],"depth":3},{"title":"Libraries and Frameworks","local":"libraries-and-frameworks","sections":[],"depth":3},{"title":"Models Used","local":"models-used","sections":[],"depth":3},{"title":"Datasets","local":"datasets","sections":[],"depth":3},{"title":"Key Concepts","local":"key-concepts","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ha(ta){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends Va{constructor(r){super(),Ya(this,r,Ha,va,Ra,{})}}export{Ka as component};
