import{s as Pn,n as Kn,o as On}from"../chunks/scheduler.1f027d5a.js";import{S as tl,i as el,e as i,s,c as d,h as nl,a as p,d as n,b as a,f as Dn,g as r,j as g,k as on,l as ll,m as l,n as M,t as c,o,p as m}from"../chunks/index.5cb6ce42.js";import{C as sl}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as al,C as j}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as u,E as il}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function dl(mn){let h,_t,xt,Yt,w,Xt,T,Ht,b,St,f,gn='<em>Authored by: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',zt,J,Ft,U,jn="I have a dataset I want to embed for semantic search (or QA, or RAG), I want the easiest way to do embed this and put it in a new dataset.",qt,I,Lt,$,un='I’m using a dataset from my favorite subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a>. Because it has long entries, I will use the new <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> since it has an 8k context length. I will deploy this using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a> to save time and money. To follow this tutorial, you will need to <strong>have already added a payment method</strong>. If you haven’t, you can add one here in <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">billing</a>. To make it even easier, I’ll make this fully API based.',Dt,C,hn='To make this MUCH faster I will use the <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> image. This has many benefits like:',Pt,A,yn="<li>No model graph compilation step</li> <li>Small docker images and fast boot times. Get ready for true serverless!</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",Kt,B,wn='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Ot,k,te,G,ee,W,ne,Z,le,E,se,N,Tn=`<code>DATASET_IN</code> is where your text data is
<code>DATASET_OUT</code> is where your embeddings will be stored`,ae,R,bn="Note I used 5 for the <code>MAX_WORKERS</code> since <code>jina-embeddings-v2</code> are quite memory hungry.",ie,V,de,v,fn='Inference Endpoints offers a number of GPUs that you can choose from. Check the <a href="https://huggingface.co/docs/inference-endpoints/en/pricing#gpu-instances" rel="nofollow">documentation</a> for GPU and alternative accelerators for information.',pe,y,Jn="<p>You may need to email us for access to some architectures.</p>",re,x,Un='<thead><tr><th align="center">Provider</th> <th align="center">Instance Type</th> <th align="center">Instance Size</th> <th align="center">Hourly rate</th> <th align="center">GPUs</th> <th align="center">Memory</th> <th align="center">Architecture</th></tr></thead> <tbody><tr><td align="center">aws</td> <td align="center">nvidia-a10g</td> <td align="center">x1</td> <td align="center">\\$1</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA A10G</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-t4</td> <td align="center">x1</td> <td align="center">\\$0.5</td> <td align="center">1</td> <td align="center">14GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-t4</td> <td align="center">x4</td> <td align="center">\\$3</td> <td align="center">4</td> <td align="center">56GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x1</td> <td align="center">\\$0.8</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x4</td> <td align="center">\\$3.8</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x1</td> <td align="center">\\$4</td> <td align="center">1</td> <td align="center">80GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a10g</td> <td align="center">x4</td> <td align="center">\\$5</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA A10G</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x2</td> <td align="center">\\$8</td> <td align="center">2</td> <td align="center">160GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x4</td> <td align="center">\\$16</td> <td align="center">4</td> <td align="center">320GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x8</td> <td align="center">\\$32</td> <td align="center">8</td> <td align="center">640GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-t4</td> <td align="center">x1</td> <td align="center">\\$0.5</td> <td align="center">1</td> <td align="center">16GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x1</td> <td align="center">\\$1</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x4</td> <td align="center">\\$5</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x1</td> <td align="center">\\$6</td> <td align="center">1</td> <td align="center">80 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x2</td> <td align="center">\\$12</td> <td align="center">2</td> <td align="center">160 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x4</td> <td align="center">\\$24</td> <td align="center">4</td> <td align="center">320 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x8</td> <td align="center">\\$48</td> <td align="center">8</td> <td align="center">640 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x1</td> <td align="center">\\$12.5</td> <td align="center">1</td> <td align="center">80 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x2</td> <td align="center">\\$25</td> <td align="center">2</td> <td align="center">160 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x4</td> <td align="center">\\$50</td> <td align="center">4</td> <td align="center">320 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x8</td> <td align="center">\\$100</td> <td align="center">8</td> <td align="center">640 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">aws</td> <td align="center">inf2</td> <td align="center">x1</td> <td align="center">\\$0.75</td> <td align="center">1</td> <td align="center">32GB</td> <td align="center">AWS Inferentia2</td></tr> <tr><td align="center">aws</td> <td align="center">inf2</td> <td align="center">x12</td> <td align="center">\\$12</td> <td align="center">12</td> <td align="center">384GB</td> <td align="center">AWS Inferentia2</td></tr></tbody>',Me,Q,ce,_,oe,Y,In="Some users might have payment registered in an organization. This allows you to connect to an organization (that you are a member of) with a payment method.",me,X,$n="Leave it blank is you want to use your username.",ge,H,je,S,Cn=`What is your Hugging Face 🤗 username or organization? (with an added payment method) ········
`,ue,z,he,F,ye,q,we,L,Te,D,be,P,An='We are going to use the <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> to create an <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a>. This should provide a few main benefits:',fe,K,Bn="<li>It’s convenient (No clicking)</li> <li>It’s repeatable (We have the code to run it easily)</li> <li>It’s cheaper (No time spent waiting for it to load, and automatically shut it down)</li>",Je,O,Ue,tt,kn="There are a few design choices here:",Ie,et,Gn='<li>As discussed before we are using <code>jinaai/jina-embeddings-v2-base-en</code> as our model. <ul><li>For reproducibility we are pinning it to a specific revision.</li></ul></li> <li>If you are interested in more models, check out the supported list <a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">here</a>. <ul><li>Note that most embedding models are based on the BERT architecture.</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> is chosen based on our number of workers and the context window of our embedding model.</li> <li><code>type=&quot;protected&quot;</code> utilized the security from Inference Endpoints detailed here.</li> <li>I’m using <strong>1x Nvidia A10</strong> since <code>jina-embeddings-v2</code> is memory hungry (remember the 8k context length).</li> <li>You should consider further tuning <code>MAX_BATCH_TOKENS</code> and <code>MAX_CONCURRENT_REQUESTS</code> if you have high workloads</li>',$e,nt,Ce,lt,Ae,st,Wn=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,Be,at,Zn="When we use <code>endpoint.client.post</code> we get a bytes string back. This is a little tedious because we need to convert this to an <code>np.array</code>, but it’s just a couple quick lines in python.",ke,it,Ge,dt,En="You may have inputs that exceed the context. In such scenarios, it’s up to you to handle them. In my case, I’d like to truncate rather than have an error. Let’s test that it works.",We,pt,Ze,rt,Nn=`The length of the embedding_input is: 300000
`,Ee,Mt,Ne,ct,Rn="Here I send a document, update it with the embedding, and return it. This happens in parallel with <code>MAX_WORKERS</code>.",Re,ot,Ve,mt,ve,gt,Vn=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,xe,jt,Qe,ut,vn="Now that we have finished, let’s pause the endpoint so we don’t incur any extra charges, this will also allow us to analyze the cost.",_e,ht,Ye,yt,xn=`Endpoint Status: paused
`,Xe,wt,He,Tt,Qn="We now have our documents updated with the embeddings we wanted. First we need to convert it back to a <code>Dataset</code> format. I find it easiest to go from list of dicts -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code>",Se,bt,ze,ft,_n="I’m uploading it to the user’s account by default (as opposed to uploading to an organization) but feel free to push to wherever you want by setting the user in the <code>repo_id</code> or in the config by setting <code>DATASET_OUT</code>",Fe,Jt,qe,Ut,Le,It,Yn=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,De,$t,Pe,Ct,Xn="<li>Go to your <code>dashboard_url</code> printed below</li> <li>Click on the Usage &amp; Cost tab</li> <li>See how much you have spent</li>",Ke,At,Oe,Bt,Hn=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,tn,kt,en,Gt,Sn=`Hit enter to continue with the notebook
`,nn,Wt,zn="We can see that it only took <code>$0.04</code> to pay for this!",ln,Zt,sn,Et,Fn="Now that we are done, we don’t need our endpoint anymore. We can delete our endpoint programmatically.",an,Nt,qn='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',dn,Rt,pn,Vt,Ln=`Endpoint deleted successfully
`,rn,vt,Mn,Qt,cn;return w=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),T=new sl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new u({props:{title:"How to use Inference Endpoints to Embed Documents",local:"how-to-use-inference-endpoints-to-embed-documents",headingTag:"h1"}}),J=new u({props:{title:"Goal",local:"goal",headingTag:"h2"}}),I=new u({props:{title:"Approach",local:"approach",headingTag:"h2"}}),k=new u({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),G=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),W=new u({props:{title:"Imports",local:"imports",headingTag:"h2"}}),Z=new j({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),E=new u({props:{title:"Config",local:"config",headingTag:"h2"}}),V=new j({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCdkZXJlay10aG9tYXMlMkZkYXRhc2V0LWNyZWF0b3ItcmVkZGl0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyclMEFEQVRBU0VUX09VVCUyMCUzRCUyMCUyMnByb2Nlc3NlZC1zdWJzZXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBRU5EUE9JTlRfTkFNRSUyMCUzRCUyMCUyMmJvcnUtamluYS1lbWJlZGRpbmdzLWRlbW8taWUlMjIlMEElMEFNQVhfV09SS0VSUyUyMCUzRCUyMDUlMjAlMjAlMjMlMjBUaGlzJTIwaXMlMjBmb3IlMjBob3clMjBtYW55JTIwYXN5bmMlMjB3b3JrZXJzJTIweW91JTIwd2FudC4lMjBDaG9vc2UlMjBiYXNlZCUyMG9uJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjBoYXJkd2FyZSUyMCUwQVJPV19DT1VOVCUyMCUzRCUyMDEwMCUyMCUyMCUyMyUyMENob29zZSUyME5vbmUlMjB0byUyMHVzZSUyMGFsbCUyMHJvd3MlMkMlMjBJbSUyMHVzaW5nJTIwMTAwJTIwanVzdCUyMGZvciUyMGElMjBkZW1v",highlighted:`DATASET_IN = <span class="hljs-string">&#x27;derek-thomas/dataset-creator-reddit-bestofredditorupdates&#x27;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware </span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),Q=new j({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTNEJTIyYXdzJTIyJTBBUkVHSU9OJTNEJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUzRCUyMngxJTIyJTBBSU5TVEFOQ0VfVFlQRSUzRCUyMm52aWRpYS1hMTBnJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR=<span class="hljs-string">&quot;aws&quot;</span>
REGION=<span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE=<span class="hljs-string">&quot;x1&quot;</span>
INSTANCE_TYPE=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>`,wrap:!1}}),_=new j({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),H=new j({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiduYW1lJyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>who = whoami()
<span class="hljs-meta">&gt;&gt;&gt; </span>organization = getpass(prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&#x27;name&#x27;</span>]`,wrap:!1}}),z=new u({props:{title:"Get Dataset",local:"get-dataset",headingTag:"h2"}}),F=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIndHJhaW4nJTVE",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&#x27;train&#x27;</span>]`,wrap:!1}}),q=new j({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1Qid0cmFpbiclNUQudG9fcGFuZGFzKCkudG9fZGljdCgncmVjb3JkcycpJTVCJTNBUk9XX0NPVU5UJTVEJTBBbGVuKGRvY3VtZW50cyklMkMlMjBkb2N1bWVudHMlNUIwJTVE",highlighted:`documents = dataset[<span class="hljs-string">&#x27;train&#x27;</span>].to_pandas().to_dict(<span class="hljs-string">&#x27;records&#x27;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new u({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),D=new u({props:{title:"Create Inference Endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),O=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Loaded endpoint&#x27;</span>)`,wrap:!1}}),nt=new u({props:{title:"Wait until it’s running",local:"wait-until-its-running",headingTag:"h2"}}),lt=new j({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),it=new j({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJ1RoaXMlMjBzb3VuZCUyMHRyYWNrJTIwd2FzJTIwYmVhdXRpZnVsISUyMEl0JTIwcGFpbnRzJTIwdGhlJTIwc2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyEnJTJDJTIwJ3RydW5jYXRlJyUzQSUyMFRydWUlN0QlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwbnAuYXJyYXkoanNvbi5sb2FkcyhyZXNwb25zZS5kZWNvZGUoKSkpJTBBcmVzcG9uc2UlNUIwJTVEJTVCJTNBMjAlNUQ=",highlighted:`response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&#x27;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&#x27;</span>, <span class="hljs-string">&#x27;truncate&#x27;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),pt=new j({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJ1RoaXMlMjBpbnB1dCUyMHdpbGwlMjBnZXQlMjBtdWx0aXBsaWVkJyUyMColMjAxMDAwMCUwQXByaW50KGYnVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJyklMEFyZXNwb25zZSUyMCUzRCUyMGVuZHBvaW50LmNsaWVudC5wb3N0KGpzb24lM0QlN0IlMjJpbnB1dHMlMjIlM0ElMjBlbWJlZGRpbmdfaW5wdXQlMkMlMjAndHJ1bmNhdGUnJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&#x27;This input will get multiplied&#x27;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&#x27;truncate&#x27;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),Mt=new u({props:{title:"Get Embeddings",local:"get-embeddings",headingTag:"h1"}}),ot=new j({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUInY29udGVudCclNUQlMkMlMjAndHJ1bmNhdGUnJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwbnAuYXJyYXkoanNvbi5sb2FkcyhyZXN1bHQuZGVjb2RlKCkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3VtZW50JTVCJ2VtYmVkZGluZyclNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&#x27;content&#x27;</span>], <span class="hljs-string">&#x27;truncate&#x27;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&#x27;embedding&#x27;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]
    
    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),mt=new j({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJ2VtYmVkZGluZyclMjBpbiUyMGRvY3VtZW50LmtleXMoKSUyMGFuZCUyMGxlbihkb2N1bWVudCU1QidlbWJlZGRpbmcnJTVEKSUyMCUzRCUzRCUyMDc2OCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvdW50JTIwJTJCJTNEJTIwMSUwQXByaW50KGYnRW1iZWRkaW5ncyUyMCUzRCUyMCU3QmNvdW50JTdEJTIwZG9jdW1lbnRzJTIwJTNEJTIwJTdCbGVuKGRvY3VtZW50cyklN0QnKSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;embedding&#x27;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&#x27;embedding&#x27;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&#x27;</span>)

            
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),jt=new u({props:{title:"Pause Inference Endpoint",local:"pause-inference-endpoint",headingTag:"h2"}}),ht=new j({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),wt=new u({props:{title:"Push updated dataset to Hub",local:"push-updated-dataset-to-hub",headingTag:"h1"}}),bt=new j({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJ3RyYWluJyUzQSUyMERhdGFzZXQuZnJvbV9wYW5kYXMoZGYpJTdEKQ==",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&#x27;train&#x27;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),Jt=new j({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),Ut=new j({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),$t=new u({props:{title:"Analyze Usage",local:"analyze-usage",headingTag:"h1"}}),At=new j({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYnaHR0cHMlM0ElMkYlMkZ1aS5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY28lMkYlN0JuYW1lc3BhY2UlN0QlMkZlbmRwb2ludHMlMkYlN0JFTkRQT0lOVF9OQU1FJTdEJyUwQXByaW50KGRhc2hib2FyZF91cmwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&#x27;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),kt=new j({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),Zt=new u({props:{title:"Delete Endpoint",local:"delete-endpoint",headingTag:"h1"}}),Rt=new j({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCgnRW5kcG9pbnQlMjBkZWxldGVkJTIwc3VjY2Vzc2Z1bGx5JyklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJ0RlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseScp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Endpoint deleted successfully&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Delete Endpoint in manually&#x27;</span>)`,wrap:!1}}),vt=new il({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.md"}}),{c(){h=i("meta"),_t=s(),xt=i("p"),Yt=s(),d(w.$$.fragment),Xt=s(),d(T.$$.fragment),Ht=s(),d(b.$$.fragment),St=s(),f=i("p"),f.innerHTML=gn,zt=s(),d(J.$$.fragment),Ft=s(),U=i("p"),U.textContent=jn,qt=s(),d(I.$$.fragment),Lt=s(),$=i("p"),$.innerHTML=un,Dt=s(),C=i("p"),C.innerHTML=hn,Pt=s(),A=i("ul"),A.innerHTML=yn,Kt=s(),B=i("p"),B.innerHTML=wn,Ot=s(),d(k.$$.fragment),te=s(),d(G.$$.fragment),ee=s(),d(W.$$.fragment),ne=s(),d(Z.$$.fragment),le=s(),d(E.$$.fragment),se=s(),N=i("p"),N.innerHTML=Tn,ae=s(),R=i("p"),R.innerHTML=bn,ie=s(),d(V.$$.fragment),de=s(),v=i("p"),v.innerHTML=fn,pe=s(),y=i("blockquote"),y.innerHTML=Jn,re=s(),x=i("table"),x.innerHTML=Un,Me=s(),d(Q.$$.fragment),ce=s(),d(_.$$.fragment),oe=s(),Y=i("p"),Y.textContent=In,me=s(),X=i("p"),X.textContent=$n,ge=s(),d(H.$$.fragment),je=s(),S=i("pre"),S.textContent=Cn,ue=s(),d(z.$$.fragment),he=s(),d(F.$$.fragment),ye=s(),d(q.$$.fragment),we=s(),d(L.$$.fragment),Te=s(),d(D.$$.fragment),be=s(),P=i("p"),P.innerHTML=An,fe=s(),K=i("ul"),K.innerHTML=Bn,Je=s(),d(O.$$.fragment),Ue=s(),tt=i("p"),tt.textContent=kn,Ie=s(),et=i("ul"),et.innerHTML=Gn,$e=s(),d(nt.$$.fragment),Ce=s(),d(lt.$$.fragment),Ae=s(),st=i("pre"),st.textContent=Wn,Be=s(),at=i("p"),at.innerHTML=Zn,ke=s(),d(it.$$.fragment),Ge=s(),dt=i("p"),dt.textContent=En,We=s(),d(pt.$$.fragment),Ze=s(),rt=i("pre"),rt.textContent=Nn,Ee=s(),d(Mt.$$.fragment),Ne=s(),ct=i("p"),ct.innerHTML=Rn,Re=s(),d(ot.$$.fragment),Ve=s(),d(mt.$$.fragment),ve=s(),gt=i("pre"),gt.textContent=Vn,xe=s(),d(jt.$$.fragment),Qe=s(),ut=i("p"),ut.textContent=vn,_e=s(),d(ht.$$.fragment),Ye=s(),yt=i("pre"),yt.textContent=xn,Xe=s(),d(wt.$$.fragment),He=s(),Tt=i("p"),Tt.innerHTML=Qn,Se=s(),d(bt.$$.fragment),ze=s(),ft=i("p"),ft.innerHTML=_n,Fe=s(),d(Jt.$$.fragment),qe=s(),d(Ut.$$.fragment),Le=s(),It=i("pre"),It.textContent=Yn,De=s(),d($t.$$.fragment),Pe=s(),Ct=i("ol"),Ct.innerHTML=Xn,Ke=s(),d(At.$$.fragment),Oe=s(),Bt=i("pre"),Bt.textContent=Hn,tn=s(),d(kt.$$.fragment),en=s(),Gt=i("pre"),Gt.textContent=Sn,nn=s(),Wt=i("p"),Wt.innerHTML=zn,ln=s(),d(Zt.$$.fragment),sn=s(),Et=i("p"),Et.textContent=Fn,an=s(),Nt=i("p"),Nt.innerHTML=qn,dn=s(),d(Rt.$$.fragment),pn=s(),Vt=i("pre"),Vt.textContent=Ln,rn=s(),d(vt.$$.fragment),Mn=s(),Qt=i("p"),this.h()},l(t){const e=nl("svelte-u9bgzb",document.head);h=p(e,"META",{name:!0,content:!0}),e.forEach(n),_t=a(t),xt=p(t,"P",{}),Dn(xt).forEach(n),Yt=a(t),r(w.$$.fragment,t),Xt=a(t),r(T.$$.fragment,t),Ht=a(t),r(b.$$.fragment,t),St=a(t),f=p(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-kkdsiw"&&(f.innerHTML=gn),zt=a(t),r(J.$$.fragment,t),Ft=a(t),U=p(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1qwdsg4"&&(U.textContent=jn),qt=a(t),r(I.$$.fragment,t),Lt=a(t),$=p(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-cznpu6"&&($.innerHTML=un),Dt=a(t),C=p(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1bpd7g5"&&(C.innerHTML=hn),Pt=a(t),A=p(t,"UL",{"data-svelte-h":!0}),g(A)!=="svelte-amjqu"&&(A.innerHTML=yn),Kt=a(t),B=p(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-12ly3c2"&&(B.innerHTML=wn),Ot=a(t),r(k.$$.fragment,t),te=a(t),r(G.$$.fragment,t),ee=a(t),r(W.$$.fragment,t),ne=a(t),r(Z.$$.fragment,t),le=a(t),r(E.$$.fragment,t),se=a(t),N=p(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-roo1xs"&&(N.innerHTML=Tn),ae=a(t),R=p(t,"P",{"data-svelte-h":!0}),g(R)!=="svelte-10xqojr"&&(R.innerHTML=bn),ie=a(t),r(V.$$.fragment,t),de=a(t),v=p(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-i0fwvi"&&(v.innerHTML=fn),pe=a(t),y=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),g(y)!=="svelte-baxtwm"&&(y.innerHTML=Jn),re=a(t),x=p(t,"TABLE",{"data-svelte-h":!0}),g(x)!=="svelte-7ezz4v"&&(x.innerHTML=Un),Me=a(t),r(Q.$$.fragment,t),ce=a(t),r(_.$$.fragment,t),oe=a(t),Y=p(t,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1oubx8o"&&(Y.textContent=In),me=a(t),X=p(t,"P",{"data-svelte-h":!0}),g(X)!=="svelte-13so4pe"&&(X.textContent=$n),ge=a(t),r(H.$$.fragment,t),je=a(t),S=p(t,"PRE",{"data-svelte-h":!0}),g(S)!=="svelte-19lh5zm"&&(S.textContent=Cn),ue=a(t),r(z.$$.fragment,t),he=a(t),r(F.$$.fragment,t),ye=a(t),r(q.$$.fragment,t),we=a(t),r(L.$$.fragment,t),Te=a(t),r(D.$$.fragment,t),be=a(t),P=p(t,"P",{"data-svelte-h":!0}),g(P)!=="svelte-8d5fhe"&&(P.innerHTML=An),fe=a(t),K=p(t,"UL",{"data-svelte-h":!0}),g(K)!=="svelte-16ejamp"&&(K.innerHTML=Bn),Je=a(t),r(O.$$.fragment,t),Ue=a(t),tt=p(t,"P",{"data-svelte-h":!0}),g(tt)!=="svelte-1whwkpr"&&(tt.textContent=kn),Ie=a(t),et=p(t,"UL",{"data-svelte-h":!0}),g(et)!=="svelte-9i31ws"&&(et.innerHTML=Gn),$e=a(t),r(nt.$$.fragment,t),Ce=a(t),r(lt.$$.fragment,t),Ae=a(t),st=p(t,"PRE",{"data-svelte-h":!0}),g(st)!=="svelte-19liytu"&&(st.textContent=Wn),Be=a(t),at=p(t,"P",{"data-svelte-h":!0}),g(at)!=="svelte-il5t0k"&&(at.innerHTML=Zn),ke=a(t),r(it.$$.fragment,t),Ge=a(t),dt=p(t,"P",{"data-svelte-h":!0}),g(dt)!=="svelte-16s019k"&&(dt.textContent=En),We=a(t),r(pt.$$.fragment,t),Ze=a(t),rt=p(t,"PRE",{"data-svelte-h":!0}),g(rt)!=="svelte-11ebe9s"&&(rt.textContent=Nn),Ee=a(t),r(Mt.$$.fragment,t),Ne=a(t),ct=p(t,"P",{"data-svelte-h":!0}),g(ct)!=="svelte-iwjedl"&&(ct.innerHTML=Rn),Re=a(t),r(ot.$$.fragment,t),Ve=a(t),r(mt.$$.fragment,t),ve=a(t),gt=p(t,"PRE",{"data-svelte-h":!0}),g(gt)!=="svelte-ff4u6w"&&(gt.textContent=Vn),xe=a(t),r(jt.$$.fragment,t),Qe=a(t),ut=p(t,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-80w8ff"&&(ut.textContent=vn),_e=a(t),r(ht.$$.fragment,t),Ye=a(t),yt=p(t,"PRE",{"data-svelte-h":!0}),g(yt)!=="svelte-v5xolv"&&(yt.textContent=xn),Xe=a(t),r(wt.$$.fragment,t),He=a(t),Tt=p(t,"P",{"data-svelte-h":!0}),g(Tt)!=="svelte-13ozgsg"&&(Tt.innerHTML=Qn),Se=a(t),r(bt.$$.fragment,t),ze=a(t),ft=p(t,"P",{"data-svelte-h":!0}),g(ft)!=="svelte-1t2e8el"&&(ft.innerHTML=_n),Fe=a(t),r(Jt.$$.fragment,t),qe=a(t),r(Ut.$$.fragment,t),Le=a(t),It=p(t,"PRE",{"data-svelte-h":!0}),g(It)!=="svelte-dj57zs"&&(It.textContent=Yn),De=a(t),r($t.$$.fragment,t),Pe=a(t),Ct=p(t,"OL",{"data-svelte-h":!0}),g(Ct)!=="svelte-seqler"&&(Ct.innerHTML=Xn),Ke=a(t),r(At.$$.fragment,t),Oe=a(t),Bt=p(t,"PRE",{"data-svelte-h":!0}),g(Bt)!=="svelte-109618w"&&(Bt.textContent=Hn),tn=a(t),r(kt.$$.fragment,t),en=a(t),Gt=p(t,"PRE",{"data-svelte-h":!0}),g(Gt)!=="svelte-1gk9phr"&&(Gt.textContent=Sn),nn=a(t),Wt=p(t,"P",{"data-svelte-h":!0}),g(Wt)!=="svelte-1ga4kzi"&&(Wt.innerHTML=zn),ln=a(t),r(Zt.$$.fragment,t),sn=a(t),Et=p(t,"P",{"data-svelte-h":!0}),g(Et)!=="svelte-3kjw6t"&&(Et.textContent=Fn),an=a(t),Nt=p(t,"P",{"data-svelte-h":!0}),g(Nt)!=="svelte-1124toy"&&(Nt.innerHTML=qn),dn=a(t),r(Rt.$$.fragment,t),pn=a(t),Vt=p(t,"PRE",{"data-svelte-h":!0}),g(Vt)!=="svelte-ulyp9n"&&(Vt.textContent=Ln),rn=a(t),r(vt.$$.fragment,t),Mn=a(t),Qt=p(t,"P",{}),Dn(Qt).forEach(n),this.h()},h(){on(h,"name","hf:doc:metadata"),on(h,"content",pl),on(y,"class","tip")},m(t,e){ll(document.head,h),l(t,_t,e),l(t,xt,e),l(t,Yt,e),M(w,t,e),l(t,Xt,e),M(T,t,e),l(t,Ht,e),M(b,t,e),l(t,St,e),l(t,f,e),l(t,zt,e),M(J,t,e),l(t,Ft,e),l(t,U,e),l(t,qt,e),M(I,t,e),l(t,Lt,e),l(t,$,e),l(t,Dt,e),l(t,C,e),l(t,Pt,e),l(t,A,e),l(t,Kt,e),l(t,B,e),l(t,Ot,e),M(k,t,e),l(t,te,e),M(G,t,e),l(t,ee,e),M(W,t,e),l(t,ne,e),M(Z,t,e),l(t,le,e),M(E,t,e),l(t,se,e),l(t,N,e),l(t,ae,e),l(t,R,e),l(t,ie,e),M(V,t,e),l(t,de,e),l(t,v,e),l(t,pe,e),l(t,y,e),l(t,re,e),l(t,x,e),l(t,Me,e),M(Q,t,e),l(t,ce,e),M(_,t,e),l(t,oe,e),l(t,Y,e),l(t,me,e),l(t,X,e),l(t,ge,e),M(H,t,e),l(t,je,e),l(t,S,e),l(t,ue,e),M(z,t,e),l(t,he,e),M(F,t,e),l(t,ye,e),M(q,t,e),l(t,we,e),M(L,t,e),l(t,Te,e),M(D,t,e),l(t,be,e),l(t,P,e),l(t,fe,e),l(t,K,e),l(t,Je,e),M(O,t,e),l(t,Ue,e),l(t,tt,e),l(t,Ie,e),l(t,et,e),l(t,$e,e),M(nt,t,e),l(t,Ce,e),M(lt,t,e),l(t,Ae,e),l(t,st,e),l(t,Be,e),l(t,at,e),l(t,ke,e),M(it,t,e),l(t,Ge,e),l(t,dt,e),l(t,We,e),M(pt,t,e),l(t,Ze,e),l(t,rt,e),l(t,Ee,e),M(Mt,t,e),l(t,Ne,e),l(t,ct,e),l(t,Re,e),M(ot,t,e),l(t,Ve,e),M(mt,t,e),l(t,ve,e),l(t,gt,e),l(t,xe,e),M(jt,t,e),l(t,Qe,e),l(t,ut,e),l(t,_e,e),M(ht,t,e),l(t,Ye,e),l(t,yt,e),l(t,Xe,e),M(wt,t,e),l(t,He,e),l(t,Tt,e),l(t,Se,e),M(bt,t,e),l(t,ze,e),l(t,ft,e),l(t,Fe,e),M(Jt,t,e),l(t,qe,e),M(Ut,t,e),l(t,Le,e),l(t,It,e),l(t,De,e),M($t,t,e),l(t,Pe,e),l(t,Ct,e),l(t,Ke,e),M(At,t,e),l(t,Oe,e),l(t,Bt,e),l(t,tn,e),M(kt,t,e),l(t,en,e),l(t,Gt,e),l(t,nn,e),l(t,Wt,e),l(t,ln,e),M(Zt,t,e),l(t,sn,e),l(t,Et,e),l(t,an,e),l(t,Nt,e),l(t,dn,e),M(Rt,t,e),l(t,pn,e),l(t,Vt,e),l(t,rn,e),M(vt,t,e),l(t,Mn,e),l(t,Qt,e),cn=!0},p:Kn,i(t){cn||(c(w.$$.fragment,t),c(T.$$.fragment,t),c(b.$$.fragment,t),c(J.$$.fragment,t),c(I.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(W.$$.fragment,t),c(Z.$$.fragment,t),c(E.$$.fragment,t),c(V.$$.fragment,t),c(Q.$$.fragment,t),c(_.$$.fragment,t),c(H.$$.fragment,t),c(z.$$.fragment,t),c(F.$$.fragment,t),c(q.$$.fragment,t),c(L.$$.fragment,t),c(D.$$.fragment,t),c(O.$$.fragment,t),c(nt.$$.fragment,t),c(lt.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(Mt.$$.fragment,t),c(ot.$$.fragment,t),c(mt.$$.fragment,t),c(jt.$$.fragment,t),c(ht.$$.fragment,t),c(wt.$$.fragment,t),c(bt.$$.fragment,t),c(Jt.$$.fragment,t),c(Ut.$$.fragment,t),c($t.$$.fragment,t),c(At.$$.fragment,t),c(kt.$$.fragment,t),c(Zt.$$.fragment,t),c(Rt.$$.fragment,t),c(vt.$$.fragment,t),cn=!0)},o(t){o(w.$$.fragment,t),o(T.$$.fragment,t),o(b.$$.fragment,t),o(J.$$.fragment,t),o(I.$$.fragment,t),o(k.$$.fragment,t),o(G.$$.fragment,t),o(W.$$.fragment,t),o(Z.$$.fragment,t),o(E.$$.fragment,t),o(V.$$.fragment,t),o(Q.$$.fragment,t),o(_.$$.fragment,t),o(H.$$.fragment,t),o(z.$$.fragment,t),o(F.$$.fragment,t),o(q.$$.fragment,t),o(L.$$.fragment,t),o(D.$$.fragment,t),o(O.$$.fragment,t),o(nt.$$.fragment,t),o(lt.$$.fragment,t),o(it.$$.fragment,t),o(pt.$$.fragment,t),o(Mt.$$.fragment,t),o(ot.$$.fragment,t),o(mt.$$.fragment,t),o(jt.$$.fragment,t),o(ht.$$.fragment,t),o(wt.$$.fragment,t),o(bt.$$.fragment,t),o(Jt.$$.fragment,t),o(Ut.$$.fragment,t),o($t.$$.fragment,t),o(At.$$.fragment,t),o(kt.$$.fragment,t),o(Zt.$$.fragment,t),o(Rt.$$.fragment,t),o(vt.$$.fragment,t),cn=!1},d(t){t&&(n(_t),n(xt),n(Yt),n(Xt),n(Ht),n(St),n(f),n(zt),n(Ft),n(U),n(qt),n(Lt),n($),n(Dt),n(C),n(Pt),n(A),n(Kt),n(B),n(Ot),n(te),n(ee),n(ne),n(le),n(se),n(N),n(ae),n(R),n(ie),n(de),n(v),n(pe),n(y),n(re),n(x),n(Me),n(ce),n(oe),n(Y),n(me),n(X),n(ge),n(je),n(S),n(ue),n(he),n(ye),n(we),n(Te),n(be),n(P),n(fe),n(K),n(Je),n(Ue),n(tt),n(Ie),n(et),n($e),n(Ce),n(Ae),n(st),n(Be),n(at),n(ke),n(Ge),n(dt),n(We),n(Ze),n(rt),n(Ee),n(Ne),n(ct),n(Re),n(Ve),n(ve),n(gt),n(xe),n(Qe),n(ut),n(_e),n(Ye),n(yt),n(Xe),n(He),n(Tt),n(Se),n(ze),n(ft),n(Fe),n(qe),n(Le),n(It),n(De),n(Pe),n(Ct),n(Ke),n(Oe),n(Bt),n(tn),n(en),n(Gt),n(nn),n(Wt),n(ln),n(sn),n(Et),n(an),n(Nt),n(dn),n(pn),n(Vt),n(rn),n(Mn),n(Qt)),n(h),m(w,t),m(T,t),m(b,t),m(J,t),m(I,t),m(k,t),m(G,t),m(W,t),m(Z,t),m(E,t),m(V,t),m(Q,t),m(_,t),m(H,t),m(z,t),m(F,t),m(q,t),m(L,t),m(D,t),m(O,t),m(nt,t),m(lt,t),m(it,t),m(pt,t),m(Mt,t),m(ot,t),m(mt,t),m(jt,t),m(ht,t),m(wt,t),m(bt,t),m(Jt,t),m(Ut,t),m($t,t),m(At,t),m(kt,t),m(Zt,t),m(Rt,t),m(vt,t)}}}const pl='{"title":"How to use Inference Endpoints to Embed Documents","local":"how-to-use-inference-endpoints-to-embed-documents","sections":[{"title":"Goal","local":"goal","sections":[],"depth":2},{"title":"Approach","local":"approach","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Imports","local":"imports","sections":[],"depth":2},{"title":"Config","local":"config","sections":[],"depth":2},{"title":"Get Dataset","local":"get-dataset","sections":[],"depth":2}],"depth":1}';function rl(mn){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends tl{constructor(h){super(),el(this,h,rl,dl,Pn,{})}}export{jl as component};
