import{s as Il,n as Rl,o as kl}from"../chunks/scheduler.e0212c12.js";import{S as Zl,i as El,e as p,s,c as m,h as Fl,a as i,d as l,b as a,f as Ql,g as o,j as M,k as Bl,l as _l,m as n,n as r,t as u,o as y,p as b}from"../chunks/index.a585a37c.js";import{C as Wl,H as Vt,E as Xl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d07a257.js";import{D as Nl,C as U}from"../chunks/DocNotebookDropdown.7c42a056.js";function Hl(He){let f,Gt,vt,Qt,J,Bt,T,It,c,Rt,C,Se='본문: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a>의 <a href="https://huggingface.co/learn/cookbook/rag_zephyr_langchain" rel="nofollow">Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain</a>을 번역하고, 한국어 모델로 변경했습니다.',kt,w,Ae='번역: <a href="https://github.com/jun048098" rel="nofollow">신혁준</a>',Zt,h,Le='이 노트북은 <a href="https://huggingface.co/yanolja/EEVE-Korean-Instruct-10.8B-v1.0" rel="nofollow"><code>yanolja/EEVE-Korean-Instruct-10.8B-v1.0</code></a> 모델과 LangChain을 사용하여 프로젝트의 GitHub 이슈에 대한 RAG(검색 기반 생성)를 빠르게 구축하는 방법을 보여줍니다.',Et,d,ze="<strong>RAG란 무엇인가?</strong>",Ft,j,Ye="RAG는 강력한 대규모 언어 모델(LLM)이 특정 콘텐츠를 인식하지 못하거나 해당 콘텐츠를 훈련 데이터에 포함되지 않아서, 혹은 그 콘텐츠를 본 적이 있어도 잘못된 정보를 생성할 때 이러한 문제를 해결하기 위한 인기 있는 접근 방식입니다. 이러한 특정 콘텐츠는 독점적이거나 민감할 수 있으며, 이 예시와 같이 최근의 자주 업데이트되는 데이터일 수 있습니다.",_t,g,Pe="만약 데이터가 정적이고 정기적으로 변경되지 않는 경우, 대규모 모델을 미세 조정(fine-tuning)하는 것을 고려할 수 있습니다. 그러나 많은 경우, 미세 조정은 비용이 많이 들며 데이터 드리프트 문제를 해결하기 위해 반복적으로 수행할 경우 “모델 이동(model shift)“이 발생할 수 있습니다. 이는 모델의 동작이 바람직하지 않은 방식으로 변하는 현상입니다.",Wt,$,qe="<strong>RAG (검색 증강 생성)</strong>은 모델의 미세 조정이 필요하지 않습니다. 대신, RAG는 LLM에 추가적인 컨텍스트를 제공하기 위해 관련 데이터를 검색하여 더 잘 정보를 제공하는 응답을 생성할 수 있도록 합니다.",Xt,V,Oe="다음은 간단한 설명입니다:",Nt,v,De='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG 다이어그램"/>',Ht,x,Ke="<li><p>외부 데이터는 별도의 임베딩 모델을 사용해 임베딩 벡터로 변환되며, 벡터는 데이터베이스에 저장됩니다. 임베딩 모델은 일반적으로 작아서 임베딩 벡터를 정기적으로 업데이트하는 것이 모델을 미세 조정하는 것보다 빠르고 저렴하며 간편합니다.</p></li> <li><p>동시에, 미세 조정이 필요하지 않다는 점은 더 강력한 LLM이 출시되면 이를 자유롭게 교체하거나 더 빠른 추론이 필요한 경우 더 작은 증류된 모델로 전환할 수 있는 유연성을 제공합니다.</p></li>",St,G,tl="이제 오픈 소스 LLM, 임베딩 모델, LangChain을 사용하여 RAG를 구축하는 방법을 살펴보겠습니다.",At,Q,el="먼저, 필요한 의존성을 설치합니다:",Lt,B,zt,I,Yt,R,Pt,k,qt,Z,ll='이 예시에서는 <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT 라이브러리의 저장소</a>에서 모든 이슈(Open 이슈와 Close 이슈 모두)를 로드할 것입니다.',Ot,E,nl='먼저, GitHub API에 접근하기 위해 <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub 개인 접근 토큰</a>을 발급받아야 합니다.',Dt,F,Kt,_,sl='다음으로, <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> 저장소의 모든 이슈를 로드하겠습니다:',te,W,al="<li>기본적으로 풀 리퀘스트도 이슈로 간주되지만, <code>include_prs=False</code>로 설정하여 데이터를 가져올 때 이를 제외하도록 설정합니다.</li> <li><code>state = &quot;all&quot;</code>로 설정하면 열린 이슈와 닫힌 이슈 모두를 로드하게 됩니다.</li>",ee,X,le,N,pl="개별 GitHub 이슈의 내용은 임베딩 모델이 입력으로 받을 수 있는 길이보다 길 수 있습니다. 모든 내용을 임베딩하려면 문서를 적절한 크기의 조각으로 나누어야 합니다.",ne,H,il="가장 일반적이고 간단한 문서 나누기(청킹) 방법은 고정된 크기의 청크를 정의하고, 이 청크별 GitHub 이슈의 내용은 임베딩 모델이 입력으로 받을 수 있는 길이보다 길 수 있습니다. 모든 내용을 임베딩하려면 문서를 적절한 크기의 조각으로 나누어야 합니다.",se,S,Ml='가장 일반적이고 간단한 문서 나누기(청킹) 방법은 고정된 크기의 청크를 정의하고, 이 청크들 간에 겹침이 있을지 여부를 결정하는 것입니다. 청크들 사이에 일부 내용의 중복을 유지하면 청크들 간의 의미적 문맥을 보존할 수 있습니다. 일반적인 텍스트에 대한 추천 분할기는 <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/recursive_text_splitter" rel="nofollow">RecursiveCharacterTextSplitter</a>이며, 여기에서도 이를 사용할 것입니다.',ae,A,pe,L,ie,z,ml="이제 문서가 모두 적절한 크기로 나누어졌으니, 해당 문서들의 임베딩을 사용하여 데이터베이스를 생성할 수 있습니다.",Me,Y,ol='문서 조각의 임베딩을 생성하기 위해 <code>HuggingFaceEmbeddings</code>와 <a href="https://huggingface.co/BAAI/bge-m3" rel="nofollow"><code>BAAI/bge-m3</code></a> 임베딩 모델을 사용할 것입니다. Hugging Face Hub에는 이 외에도 다양한 임베딩 모델이 있으며, <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) 리더보드</a>를 통해 성능이 좋은 모델들을 확인할 수 있습니다.',me,P,rl="벡터 데이터베이스를 생성하기 위해서는 Facebook AI가 개발한 <code>FAISS</code> 라이브러리를 사용할 것입니다. 이 라이브러리는 밀집 벡터의 유사성 검색과 클러스터링을 효율적으로 처리하며, 이는 우리가 여기서 필요한 기능입니다. FAISS는 현재 대규모 데이터셋에서 최근접 이웃(NN) 검색을 위해 가장 널리 사용되는 라이브러리 중 하나입니다.",oe,q,ul="우리는 LangChain API를 통해 임베딩 모델과 FAISS에 접근할 것입니다.",re,O,ue,D,yl="비정형 쿼리를 입력받아 해당 문서를 반환(검색)할 방법이 필요합니다. 이를 위해 <code>db</code>를 백엔드로 사용하여 <code>as_retriever</code> 메서드를 사용할 것입니다:",ye,K,bl="<li><code>search_type=&quot;similarity&quot;</code>는 쿼리와 문서 사이의 유사성 검색을 수행하고자 한다는 것을 의미합니다.</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code>는 검색기가 상위 4개의 결과를 반환하도록 지시하는 설정입니다.</li>",be,tt,Ue,et,Ul="벡터 데이터베이스와 검색기가 설정되었으니, 이제 체인의 다음 부분인 모델을 설정해야 합니다.",fe,lt,Je,nt,fl='이번 예시에서는 한국어 모델로 <a href="https://huggingface.co/yanolja/EEVE-Korean-Instruct-10.8B-v1.0" rel="nofollow"><code>yanolja/EEVE-Korean-Instruct-10.8B-v1.0</code></a>를 선택했습니다.',Te,st,Jl='매주 여러 모델이 새롭게 출시되므로, 최신 모델로 교체하고 싶을 수 있습니다. 오픈소스 LLM의 최신 동향을 파악하는 가장 좋은 방법은 [한국어 오픈소스 LLM 리더보드](<a href="https://huggingface.co/spaces/upstage/open-ko-llm-leaderboard" rel="nofollow">https://huggingface.co/spaces/upstage/open-ko-llm-leaderboard</a>, <a href="https://lk.instruct.kr/)%EB%A5%BC" rel="nofollow">https://lk.instruct.kr/)를</a> 확인하는 것입니다.',ce,at,Tl="추론 속도를 빠르게 하고, Colab 실행을 위해서 양자화된 버전의 모델을 로드할 것입니다:",Ce,pt,we,it,he,Mt,cl="마침내, LLM 체인을 설정하는 데 필요한 모든 구성 요소가 준비되었습니다.",de,mt,Cl="먼저, 로드한 모델과 해당 토크나이저를 사용하여 <code>text_generation</code> 파이프라인을 생성합니다.",je,ot,wl="다음으로, 프롬프트 템플릿을 만듭니다. 이 템플릿은 모델의 형식을 따라야 하므로, 모델 체크포인트를 교체할 경우 적절한 형식을 사용하도록 해야 합니다.",ge,rt,$e,ut,hl="참고: <em>메시지 리스트(딕셔너리 형태: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>)를 적절한 채팅 형식의 문자열로 변환하려면 <code>tokenizer.apply_chat_template</code>를 사용할 수 있습니다.</em>",Ve,yt,dl="마지막으로, <code>llm_chain</code>과 검색기를 결합하여 RAG 체인을 생성해야 합니다. 원본 질문과 검색된 문서들을 최종 생성 단계로 전달합니다:",ve,bt,xe,Ut,Ge,ft,jl="RAG가 라이브러리 관련 질문에 대한 답변을 생성하는 데 어떤 차이를 만드는지 살펴보겠습니다.",Qe,Jt,gl="수집한 PEFT 라이브러리의 이슈가 영어로 작성되어서 영어로 질문하여 문서를 검색합니다.",Be,Tt,$l="프롬프트로 답변은 한글로 나오도록 합니다.",Ie,ct,Re,Ct,Vl="먼저, 컨텍스트를 추가하지 않고 모델 자체만으로 어떤 답변을 얻을 수 있는지 살펴보겠습니다:",ke,wt,Ze,ht,vl=`모델은 질문을 전기를 공급하는 어댑터에 관한 것으로 해석했지만, PEFT의 맥락에서 “adapters”는 LoRA 어댑터를 의미합니다.<br/>
GitHub 이슈를 검색해 컨텍스트를 추가하면 모델이 더 관련성 높은 답변을 제공할 수 있는지 확인해 보겠습니다:`,Ee,dt,Fe,jt,xl="보시다시피, 컨텍스트를 추가하면 동일한 모델이 라이브러리 관련 질문에 대해 훨씬 더 관련성 있고 정보에 기반한 답변을 제공하는 데 큰 도움이 됩니다.",_e,gt,Gl="특히, 여러 어댑터를 결합하여 추론하는 기능이 라이브러리에 추가되었으며, 이 정보는 검색된 문서에서 찾을 수 있습니다. 따라서 RAG로 문서 임베딩을 포함하는 것이 유용할 수 있습니다.",We,$t,Xe,xt,Ne;return J=new Nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/ko/rag_zephyr_langchain.ipynb"}]}}),T=new Wl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),c=new Vt({props:{title:"GitHub 이슈를 위한 EEVE와 LangChain을 사용한 간단한 RAG",local:"github-이슈를-위한-eeve와-langchain을-사용한-간단한-rag",headingTag:"h1"}}),B=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),I=new U({props:{code:"JTIzJTIwR29vZ2xlJTIwQ29sYWIlRUMlOTclOTAlRUMlODQlOUMlMjAlRUMlOEIlQTQlRUQlOTYlODklRUQlOTUlOTglRUIlOEElOTQlMjAlRUElQjIlQkQlRUMlOUElQjAlMjBMYW5nQ2hhaW4lRUMlOUQlODQlMjAlRUMlODQlQTQlRUMlQjklOTglRUQlOTUlOTglRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlQjQlMjBVVEYtOCUyMCVFQiVBMSU5QyVFQyVCQyU4MCVFQyU5RCVCQyVFQyU5RCU4NCUyMCVFQyU4MiVBQyVFQyU5QSVBOSVFRCU5NSU5OCVFQSVCMyVBMCUyMCVFQyU5RSU4OCVFQiU4QSU5NCVFQyVBNyU4MCUyMCVFRCU5OSU5NSVFQyU5RCVCOCVFRCU5NSU5OCVFQSVCOCVCMCUyMCVFQyU5QyU4NCVFRCU5NSVCNCUyMCVFQyU5RCVCNCUyMCVFQyU4NSU4MCVFQyU5RCU4NCUyMCVFQyU4QiVBNCVFRCU5NiU4OSVFRCU5NSVCNCVFQyU5NSVCQyUyMCVFRCU5NSVBMCUyMCVFQyU4OCU5OCVFQiU4RiU4NCUyMCVFQyU5RSU4OCVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEFpbXBvcnQlMjBsb2NhbGUlMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># Google Colab에서 실행하는 경우 LangChain을 설치하기 위해 UTF-8 로케일을 사용하고 있는지 확인하기 위해 이 셀을 실행해야 할 수도 있습니다.</span>
<span class="hljs-keyword">import</span> locale
locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),R=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHk=",highlighted:"!pip install -q langchain langchain-community",wrap:!1}}),k=new Vt({props:{title:"데이터 준비",local:"데이터-준비",headingTag:"h2"}}),F=new U({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),X=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwc3RhdGUlM0QlMjJhbGwlMjIlMEEpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(
    repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>,
    access_token=ACCESS_TOKEN,
    include_prs=<span class="hljs-literal">False</span>,
    state=<span class="hljs-string">&quot;all&quot;</span>
)

docs = loader.load()`,wrap:!1}}),A=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),L=new Vt({props:{title:"임베딩 및 검색기 생성",local:"임베딩-및-검색기-생성",headingTag:"h2"}}),O=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QnQkFBSSUyRmJnZS1iYXNlLWVuLXYxLjUnKSk=",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs,
                          HuggingFaceEmbeddings(model_name=<span class="hljs-string">&#x27;BAAI/bge-base-en-v1.5&#x27;</span>))`,wrap:!1}}),tt=new U({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKCUwQSUyMCUyMCUyMCUyMHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlYXJjaF9rd2FyZ3MlM0QlN0InayclM0ElMjA0JTdEJTBBKQ==",highlighted:`retriever = db.as_retriever(
    search_type=<span class="hljs-string">&quot;similarity&quot;</span>,
    search_kwargs={<span class="hljs-string">&#x27;k&#x27;</span>: <span class="hljs-number">4</span>}
)`,wrap:!1}}),lt=new Vt({props:{title:"양자화된 모델 로드",local:"양자화된-모델-로드",headingTag:"h2"}}),pt=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCd5YW5vbGphJTJGRUVWRS1Lb3JlYW4tSW5zdHJ1Y3QtMTAuOEItdjEuMCclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&#x27;yanolja/EEVE-Korean-Instruct-10.8B-v1.0&#x27;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),it=new Vt({props:{title:"LLM 체인 설정",local:"llm-체인-설정",headingTag:"h2"}}),rt=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjB1c2VyJTIwYW5kJTIwYW4lMjBhcnRpZmljaWFsJTIwaW50ZWxsaWdlbmNlJTIwYXNzaXN0YW50LiUyMFRoZSUyMGFzc2lzdGFudCUyMGdpdmVzJTIwaGVscGZ1bCUyQyUyMGRldGFpbGVkJTJDJTIwYW5kJTIwcG9saXRlJTIwYW5zd2VycyUyMHRvJTIwdGhlJTIwdXNlcidzJTIwcXVlc3Rpb25zLiUwQUh1bWFuJTNBJTIwQ29udGV4dCVFQiVBNSVCQyUyMCVFQyU5RCVCRCVFQSVCMyVBMCUyMFF1ZXN0aW9uJUVDJTk3JTkwJTIwJUVEJTk1JTlDJUVBJUI1JUFEJUVDJTk2JUI0JUVCJUExJTlDJTIwJUVCJThCJUI1JUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0LiUwQUNvbnRleHQlM0ElMjAlN0Jjb250ZXh0JTdEJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUwQUFzc2lzdGFudCUzQSU1Q24lMEElMjIlMjIlMjIlMEElMEFwcm9tcHQlMjAlM0QlMjBQcm9tcHRUZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF92YXJpYWJsZXMlM0QlNUIlMjJjb250ZXh0JTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZW1wbGF0ZSUzRHByb21wdF90ZW1wbGF0ZSUyQyUwQSklMEElMEFsbG1fY2hhaW4lMjAlM0QlMjBwcm9tcHQlMjAlN0MlMjBsbG0lMjAlN0MlMjBTdHJPdXRwdXRQYXJzZXIoKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
A chat between a curious user and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the user&#x27;s questions.
Human: Context를 읽고 Question에 한국어로 답하세요.
Context: {context}
Question: {question}
Assistant:\\n
&quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),bt=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCglMEElMjAlN0IlMjJjb250ZXh0JTIyJTNBJTIwcmV0cmlldmVyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBSdW5uYWJsZVBhc3N0aHJvdWdoKCklN0QlMEElMjAlMjAlMjAlMjAlN0MlMjBsbG1fY2hhaW4lMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = (
 {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}
    | llm_chain
)`,wrap:!1}}),Ut=new Vt({props:{title:"결과 비교",local:"결과-비교",headingTag:"h2"}}),ct=new U({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),wt=new U({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>:<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),dt=new U({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),$t=new Xl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/ko/rag_zephyr_langchain.md"}}),{c(){f=p("meta"),Gt=s(),vt=p("p"),Qt=s(),m(J.$$.fragment),Bt=s(),m(T.$$.fragment),It=s(),m(c.$$.fragment),Rt=s(),C=p("p"),C.innerHTML=Se,kt=s(),w=p("p"),w.innerHTML=Ae,Zt=s(),h=p("p"),h.innerHTML=Le,Et=s(),d=p("p"),d.innerHTML=ze,Ft=s(),j=p("p"),j.textContent=Ye,_t=s(),g=p("p"),g.textContent=Pe,Wt=s(),$=p("p"),$.innerHTML=qe,Xt=s(),V=p("p"),V.textContent=Oe,Nt=s(),v=p("p"),v.innerHTML=De,Ht=s(),x=p("ul"),x.innerHTML=Ke,St=s(),G=p("p"),G.textContent=tl,At=s(),Q=p("p"),Q.textContent=el,Lt=s(),m(B.$$.fragment),zt=s(),m(I.$$.fragment),Yt=s(),m(R.$$.fragment),Pt=s(),m(k.$$.fragment),qt=s(),Z=p("p"),Z.innerHTML=ll,Ot=s(),E=p("p"),E.innerHTML=nl,Dt=s(),m(F.$$.fragment),Kt=s(),_=p("p"),_.innerHTML=sl,te=s(),W=p("ul"),W.innerHTML=al,ee=s(),m(X.$$.fragment),le=s(),N=p("p"),N.textContent=pl,ne=s(),H=p("p"),H.textContent=il,se=s(),S=p("p"),S.innerHTML=Ml,ae=s(),m(A.$$.fragment),pe=s(),m(L.$$.fragment),ie=s(),z=p("p"),z.textContent=ml,Me=s(),Y=p("p"),Y.innerHTML=ol,me=s(),P=p("p"),P.innerHTML=rl,oe=s(),q=p("p"),q.textContent=ul,re=s(),m(O.$$.fragment),ue=s(),D=p("p"),D.innerHTML=yl,ye=s(),K=p("ul"),K.innerHTML=bl,be=s(),m(tt.$$.fragment),Ue=s(),et=p("p"),et.textContent=Ul,fe=s(),m(lt.$$.fragment),Je=s(),nt=p("p"),nt.innerHTML=fl,Te=s(),st=p("p"),st.innerHTML=Jl,ce=s(),at=p("p"),at.textContent=Tl,Ce=s(),m(pt.$$.fragment),we=s(),m(it.$$.fragment),he=s(),Mt=p("p"),Mt.textContent=cl,de=s(),mt=p("p"),mt.innerHTML=Cl,je=s(),ot=p("p"),ot.textContent=wl,ge=s(),m(rt.$$.fragment),$e=s(),ut=p("p"),ut.innerHTML=hl,Ve=s(),yt=p("p"),yt.innerHTML=dl,ve=s(),m(bt.$$.fragment),xe=s(),m(Ut.$$.fragment),Ge=s(),ft=p("p"),ft.textContent=jl,Qe=s(),Jt=p("p"),Jt.textContent=gl,Be=s(),Tt=p("p"),Tt.textContent=$l,Ie=s(),m(ct.$$.fragment),Re=s(),Ct=p("p"),Ct.textContent=Vl,ke=s(),m(wt.$$.fragment),Ze=s(),ht=p("p"),ht.innerHTML=vl,Ee=s(),m(dt.$$.fragment),Fe=s(),jt=p("p"),jt.textContent=xl,_e=s(),gt=p("p"),gt.textContent=Gl,We=s(),m($t.$$.fragment),Xe=s(),xt=p("p"),this.h()},l(t){const e=Fl("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(l),Gt=a(t),vt=i(t,"P",{}),Ql(vt).forEach(l),Qt=a(t),o(J.$$.fragment,t),Bt=a(t),o(T.$$.fragment,t),It=a(t),o(c.$$.fragment,t),Rt=a(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1nfrzmd"&&(C.innerHTML=Se),kt=a(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1sa2xxj"&&(w.innerHTML=Ae),Zt=a(t),h=i(t,"P",{"data-svelte-h":!0}),M(h)!=="svelte-ka828j"&&(h.innerHTML=Le),Et=a(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1n1t81"&&(d.innerHTML=ze),Ft=a(t),j=i(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-10ga0ii"&&(j.textContent=Ye),_t=a(t),g=i(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-6qz5es"&&(g.textContent=Pe),Wt=a(t),$=i(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1671lfy"&&($.innerHTML=qe),Xt=a(t),V=i(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1iie3uw"&&(V.textContent=Oe),Nt=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1mgszfw"&&(v.innerHTML=De),Ht=a(t),x=i(t,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-kgp79v"&&(x.innerHTML=Ke),St=a(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1sb91xu"&&(G.textContent=tl),At=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-mf3g6w"&&(Q.textContent=el),Lt=a(t),o(B.$$.fragment,t),zt=a(t),o(I.$$.fragment,t),Yt=a(t),o(R.$$.fragment,t),Pt=a(t),o(k.$$.fragment,t),qt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-xd3fji"&&(Z.innerHTML=ll),Ot=a(t),E=i(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1hoyze8"&&(E.innerHTML=nl),Dt=a(t),o(F.$$.fragment,t),Kt=a(t),_=i(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1ft022z"&&(_.innerHTML=sl),te=a(t),W=i(t,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-14a2405"&&(W.innerHTML=al),ee=a(t),o(X.$$.fragment,t),le=a(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-si1zim"&&(N.textContent=pl),ne=a(t),H=i(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1ugvyb3"&&(H.textContent=il),se=a(t),S=i(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1bk5vub"&&(S.innerHTML=Ml),ae=a(t),o(A.$$.fragment,t),pe=a(t),o(L.$$.fragment,t),ie=a(t),z=i(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-8e0o97"&&(z.textContent=ml),Me=a(t),Y=i(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-t79ewh"&&(Y.innerHTML=ol),me=a(t),P=i(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-jkyafg"&&(P.innerHTML=rl),oe=a(t),q=i(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-19bgymi"&&(q.textContent=ul),re=a(t),o(O.$$.fragment,t),ue=a(t),D=i(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1hrik01"&&(D.innerHTML=yl),ye=a(t),K=i(t,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-11idja7"&&(K.innerHTML=bl),be=a(t),o(tt.$$.fragment,t),Ue=a(t),et=i(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1wn2xq7"&&(et.textContent=Ul),fe=a(t),o(lt.$$.fragment,t),Je=a(t),nt=i(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-nncb7n"&&(nt.innerHTML=fl),Te=a(t),st=i(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-8ybpgc"&&(st.innerHTML=Jl),ce=a(t),at=i(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-15uzghm"&&(at.textContent=Tl),Ce=a(t),o(pt.$$.fragment,t),we=a(t),o(it.$$.fragment,t),he=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-y6rc2w"&&(Mt.textContent=cl),de=a(t),mt=i(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1p4m1m4"&&(mt.innerHTML=Cl),je=a(t),ot=i(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-4je54k"&&(ot.textContent=wl),ge=a(t),o(rt.$$.fragment,t),$e=a(t),ut=i(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-j3fp7m"&&(ut.innerHTML=hl),Ve=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-19xo7cv"&&(yt.innerHTML=dl),ve=a(t),o(bt.$$.fragment,t),xe=a(t),o(Ut.$$.fragment,t),Ge=a(t),ft=i(t,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-qirnt8"&&(ft.textContent=jl),Qe=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-1owfvqc"&&(Jt.textContent=gl),Be=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-9vywbl"&&(Tt.textContent=$l),Ie=a(t),o(ct.$$.fragment,t),Re=a(t),Ct=i(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-1sgap1m"&&(Ct.textContent=Vl),ke=a(t),o(wt.$$.fragment,t),Ze=a(t),ht=i(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-1mpcpjd"&&(ht.innerHTML=vl),Ee=a(t),o(dt.$$.fragment,t),Fe=a(t),jt=i(t,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-121m37b"&&(jt.textContent=xl),_e=a(t),gt=i(t,"P",{"data-svelte-h":!0}),M(gt)!=="svelte-3b4clz"&&(gt.textContent=Gl),We=a(t),o($t.$$.fragment,t),Xe=a(t),xt=i(t,"P",{}),Ql(xt).forEach(l),this.h()},h(){Bl(f,"name","hf:doc:metadata"),Bl(f,"content",Sl)},m(t,e){_l(document.head,f),n(t,Gt,e),n(t,vt,e),n(t,Qt,e),r(J,t,e),n(t,Bt,e),r(T,t,e),n(t,It,e),r(c,t,e),n(t,Rt,e),n(t,C,e),n(t,kt,e),n(t,w,e),n(t,Zt,e),n(t,h,e),n(t,Et,e),n(t,d,e),n(t,Ft,e),n(t,j,e),n(t,_t,e),n(t,g,e),n(t,Wt,e),n(t,$,e),n(t,Xt,e),n(t,V,e),n(t,Nt,e),n(t,v,e),n(t,Ht,e),n(t,x,e),n(t,St,e),n(t,G,e),n(t,At,e),n(t,Q,e),n(t,Lt,e),r(B,t,e),n(t,zt,e),r(I,t,e),n(t,Yt,e),r(R,t,e),n(t,Pt,e),r(k,t,e),n(t,qt,e),n(t,Z,e),n(t,Ot,e),n(t,E,e),n(t,Dt,e),r(F,t,e),n(t,Kt,e),n(t,_,e),n(t,te,e),n(t,W,e),n(t,ee,e),r(X,t,e),n(t,le,e),n(t,N,e),n(t,ne,e),n(t,H,e),n(t,se,e),n(t,S,e),n(t,ae,e),r(A,t,e),n(t,pe,e),r(L,t,e),n(t,ie,e),n(t,z,e),n(t,Me,e),n(t,Y,e),n(t,me,e),n(t,P,e),n(t,oe,e),n(t,q,e),n(t,re,e),r(O,t,e),n(t,ue,e),n(t,D,e),n(t,ye,e),n(t,K,e),n(t,be,e),r(tt,t,e),n(t,Ue,e),n(t,et,e),n(t,fe,e),r(lt,t,e),n(t,Je,e),n(t,nt,e),n(t,Te,e),n(t,st,e),n(t,ce,e),n(t,at,e),n(t,Ce,e),r(pt,t,e),n(t,we,e),r(it,t,e),n(t,he,e),n(t,Mt,e),n(t,de,e),n(t,mt,e),n(t,je,e),n(t,ot,e),n(t,ge,e),r(rt,t,e),n(t,$e,e),n(t,ut,e),n(t,Ve,e),n(t,yt,e),n(t,ve,e),r(bt,t,e),n(t,xe,e),r(Ut,t,e),n(t,Ge,e),n(t,ft,e),n(t,Qe,e),n(t,Jt,e),n(t,Be,e),n(t,Tt,e),n(t,Ie,e),r(ct,t,e),n(t,Re,e),n(t,Ct,e),n(t,ke,e),r(wt,t,e),n(t,Ze,e),n(t,ht,e),n(t,Ee,e),r(dt,t,e),n(t,Fe,e),n(t,jt,e),n(t,_e,e),n(t,gt,e),n(t,We,e),r($t,t,e),n(t,Xe,e),n(t,xt,e),Ne=!0},p:Rl,i(t){Ne||(u(J.$$.fragment,t),u(T.$$.fragment,t),u(c.$$.fragment,t),u(B.$$.fragment,t),u(I.$$.fragment,t),u(R.$$.fragment,t),u(k.$$.fragment,t),u(F.$$.fragment,t),u(X.$$.fragment,t),u(A.$$.fragment,t),u(L.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(pt.$$.fragment,t),u(it.$$.fragment,t),u(rt.$$.fragment,t),u(bt.$$.fragment,t),u(Ut.$$.fragment,t),u(ct.$$.fragment,t),u(wt.$$.fragment,t),u(dt.$$.fragment,t),u($t.$$.fragment,t),Ne=!0)},o(t){y(J.$$.fragment,t),y(T.$$.fragment,t),y(c.$$.fragment,t),y(B.$$.fragment,t),y(I.$$.fragment,t),y(R.$$.fragment,t),y(k.$$.fragment,t),y(F.$$.fragment,t),y(X.$$.fragment,t),y(A.$$.fragment,t),y(L.$$.fragment,t),y(O.$$.fragment,t),y(tt.$$.fragment,t),y(lt.$$.fragment,t),y(pt.$$.fragment,t),y(it.$$.fragment,t),y(rt.$$.fragment,t),y(bt.$$.fragment,t),y(Ut.$$.fragment,t),y(ct.$$.fragment,t),y(wt.$$.fragment,t),y(dt.$$.fragment,t),y($t.$$.fragment,t),Ne=!1},d(t){t&&(l(Gt),l(vt),l(Qt),l(Bt),l(It),l(Rt),l(C),l(kt),l(w),l(Zt),l(h),l(Et),l(d),l(Ft),l(j),l(_t),l(g),l(Wt),l($),l(Xt),l(V),l(Nt),l(v),l(Ht),l(x),l(St),l(G),l(At),l(Q),l(Lt),l(zt),l(Yt),l(Pt),l(qt),l(Z),l(Ot),l(E),l(Dt),l(Kt),l(_),l(te),l(W),l(ee),l(le),l(N),l(ne),l(H),l(se),l(S),l(ae),l(pe),l(ie),l(z),l(Me),l(Y),l(me),l(P),l(oe),l(q),l(re),l(ue),l(D),l(ye),l(K),l(be),l(Ue),l(et),l(fe),l(Je),l(nt),l(Te),l(st),l(ce),l(at),l(Ce),l(we),l(he),l(Mt),l(de),l(mt),l(je),l(ot),l(ge),l($e),l(ut),l(Ve),l(yt),l(ve),l(xe),l(Ge),l(ft),l(Qe),l(Jt),l(Be),l(Tt),l(Ie),l(Re),l(Ct),l(ke),l(Ze),l(ht),l(Ee),l(Fe),l(jt),l(_e),l(gt),l(We),l(Xe),l(xt)),l(f),b(J,t),b(T,t),b(c,t),b(B,t),b(I,t),b(R,t),b(k,t),b(F,t),b(X,t),b(A,t),b(L,t),b(O,t),b(tt,t),b(lt,t),b(pt,t),b(it,t),b(rt,t),b(bt,t),b(Ut,t),b(ct,t),b(wt,t),b(dt,t),b($t,t)}}}const Sl='{"title":"GitHub 이슈를 위한 EEVE와 LangChain을 사용한 간단한 RAG","local":"github-이슈를-위한-eeve와-langchain을-사용한-간단한-rag","sections":[{"title":"데이터 준비","local":"데이터-준비","sections":[],"depth":2},{"title":"임베딩 및 검색기 생성","local":"임베딩-및-검색기-생성","sections":[],"depth":2},{"title":"양자화된 모델 로드","local":"양자화된-모델-로드","sections":[],"depth":2},{"title":"LLM 체인 설정","local":"llm-체인-설정","sections":[],"depth":2},{"title":"결과 비교","local":"결과-비교","sections":[],"depth":2}],"depth":1}';function Al(He){return kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Zl{constructor(f){super(),El(this,f,Al,Hl,Il,{})}}export{ql as component};
