# 오픈소스 AI Cookbook

오픈소스 AI Cookbook에는 오픈소스 도구와 모델을 활용해 AI 애플리케이션을 만들고 다양한 머신러닝 과제를 해결하는 노트북이 모여 있습니다.

## 최신 노트북

최근 추가된 노트북을 살펴보세요:

- [Custom Biomedical Dataset으로 Vision Transformer 모델 Fine-tuning 하기](fine_tuning_vit_custom_dataset_ko)
- [한국어 Advanced RAG 구현: Hugging Face와 LangChain 활용한 Cookbook](advanced_ko_rag)
- [구조화된 생성으로 근거 강조 표시가 있는 RAG 시스템 구축하기](structured_generation)
- [지식 그래프를 활용한 RAG 추론 향상](ko_rag_with_knowledge_graphs_neo4j)
- [GitHub 이슈를 위한 EEVE와 LangChain을 사용한 간단한 RAG](rag_zephyr_langchain)
- [다중 에이전트 계층 구조에서 여러 에이전트가 협업하도록 하기](multiagent_web_assistant)
- [유사성 검색을 위한 멀티모달 데이터 임베딩](faiss_with_hf_datasets_and_clip)
- [개인용 GPU에서 TRL로 SmolVLM DPO 파인튜닝하기](ko_fine_tuning_vlm_dpo_smolvlm_instruct)
- [커스텀 데이터셋으로 객체 탐지 모델 파인튜닝하기, Spaces에 배포하기, 그리고 Gradio API 연동하기](fine_tuning_detr_custom_dataset)
- [허깅페이스 허브를 백엔드로 사용한 벡터 검색](vector_search_with_hub_as_backend)

더 다양한 노트북을 확인하고 싶다면 Cookbook's [GitHub 리포지토리](https://github.com/huggingface/cookbook)에 방문해보세요.

## 기여하기

오픈소스 AI Cookbook은 커뮤니티의 노력으로 만들어지며, 여러분의 기여를 환영합니다! 
Cookbook의 [기여 가이드](https://github.com/huggingface/cookbook/blob/main/README.md)를 확인하고 여러분의 "레시피"를 추가하는 방법을 알아보세요.


<EditOnGithub source="https://github.com/huggingface/cookbook/blob/main/notebooks/ko/index.md" />