import{s as At,a as It,n as ht,o as ft}from"../chunks/scheduler.1f027d5a.js";import{S as gt,i as bt,e as n,s as a,c as i,h as Ct,a as p,d as t,b as M,f as Fs,g as j,j as y,k as U,l as $t,m as e,n as o,t as J,o as r,p as T}from"../chunks/index.6117a65d.js";import{D as Et,C as c}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as w,E as Bt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function Zt(Rs){let m,Bl,$l,Zl,I,Gl,A,ql,h,xs='<em>作者：<a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> 和 <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',Vl,f,Ss='<li><strong>库</strong>: <a href="https://github.com/argilla-io/argilla" rel="nofollow">argilla</a>, <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">hf-inference-endpoints</a></li> <li><strong>组件</strong>: <a href="https://distilabel.argilla.io/dev/components-gallery/steps/loaddatafromdicts/" rel="nofollow">LoadDataFromDicts</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/ultrafeedback/" rel="nofollow">UltraFeedback</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/groupcolumns/" rel="nofollow">KeepColumns</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/textgenerationtoargilla/" rel="nofollow">PreferenceToArgilla</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/llms/inferenceendpointsllm/" rel="nofollow">InferenceEndpointsLLM</a>, <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/global_step/" rel="nofollow">GlobalStep</a></li>',kl,g,zs='在本教程中，我们将使用 <strong>distilabel</strong> 清理数据集，利用大型语言模型（LLMs）作为评审者，通过提供 AI 反馈来评估数据的质量。<a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> 是一个用于工程师的合成数据和 AI 反馈框架，帮助快速、可靠且可扩展地构建基于经过验证的研究论文的管道。查看文档 <a href="https://distilabel.argilla.io/latest/" rel="nofollow">这里</a>。',Ql,b,Hs='为了评估响应，我们将使用与 distilabel 集成的 <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">无服务器 HF 推理 API</a>。该服务免费但有请求限制，允许你通过简单的 HTTP 请求测试和评估超过 150,000 个公开模型，或者使用你自己的私有模型，推理任务在 Hugging Face 共享基础设施上进行。如果需要更多计算能力，您可以使用 <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">Hugging Face 推理端点</a> 部署自己的推理端点。',Wl,C,Ys='最后，为了进一步整理数据，我们将使用 <a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a>，它允许我们对数据质量提供人工反馈。Argilla 是一个为 AI 工程师和领域专家提供的协作工具，帮助他们为项目构建高质量的数据集。查看文档 <a href="https://docs.argilla.io/latest/" rel="nofollow">这里</a>。',Nl,$,_l,E,Xl,B,Ls="为了完成本教程，你需要通过 pip 安装 distilabel SDK 和一些第三方库。",vl,Z,Fl,G,Rl,q,Ds="让我们进行必要的导入：",xl,V,Sl,k,Ps="你需要一个 <code>HF_TOKEN</code> 才能使用 HF 推理端点。在此 Notebook 中直接登录以使用它。",zl,Q,Hl,W,Yl,N,Ks='你可以跳过此步骤，或者将其替换为任何其他数据评估工具，但如果缺乏数据质量，模型的性能将受到影响，因此我们建议你查看你的数据。如果你已经部署了 Argilla，可以跳过此步骤。否则，你可以按照 <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">此指南</a> 快速部署 Argilla。',Ll,_,Os="同时，你需要将 Argilla 作为 distilabel 的附加组件安装。",Dl,X,Pl,v,Kl,F,lt='在这种情况下，我们将清理一个偏好数据集，因此我们将使用 Hugging Face Hub 上的 <a href="https://huggingface.co/datasets/Intel/orca_dpo_pairs" rel="nofollow"><code>Intel/orca_dpo_pairs</code></a> 数据集。',Ol,u,st,ls,R,ss,x,tt="接下来，我们将打乱 <code>chosen</code> 和 <code>rejected</code> 列，以避免数据集中的任何偏差。",ts,S,es,z,as,H,Ms,Y,et='步骤是 distilabel 管道中的一个模块，用于操作、生成或评估数据等任务。提供了一组预定义的步骤，但你也可以创建 <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/#defining-custom-steps" rel="nofollow">自定义步骤</a>。与之前章节中的数据预处理不同，你可以使用自定义步骤来打乱列。这个步骤应该放在一个单独的模块中，以便导入并在管道中使用。在这种情况下，管道将首先使用 <code>LoadDataFromHub</code> 步骤加载 <code>orca_dpo_pairs</code> 数据集，然后应用 <code>ShuffleStep</code> 步骤。',ns,L,ps,D,is,P,js,K,at="为了清理一个现有的偏好数据集，我们需要定义一个包含所有必要步骤的 <code>Pipeline</code>。类似的工作流也可以用于清理 SFT（监督微调）数据集。接下来，我们将详细讲解每个步骤。",os,O,Js,ll,Mt="我们将使用刚才打乱的数据集作为源数据。",rs,sl,nt="<li>组件：<code>LoadDataFromDicts</code></li> <li>输入列：<code>system</code>、<code>question</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code> 和 <code>order</code>，与加载的字典列表中的键相同。</li> <li>输出列：<code>system</code>、<code>instruction</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code> 和 <code>order</code>。我们将使用 <code>output_mappings</code> 来重命名列。</li>",Ts,tl,ys,el,cs,al,pt='为了评估响应的质量，我们将使用 <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-70B-Instruct</code></a>，并应用 <code>UltraFeedback</code> 任务，根据不同维度（如有用性、诚实性、遵循指令的能力、真实性）来评判响应。对于 SFT 数据集，您可以改用 <a href="../papers/prometheus.md"><code>PrometheusEval</code></a>。',ws,Ml,it="<li>组件：使用 <code>InferenceEndpointsLLM</code> 的 <code>UltraFeedback</code> 任务</li> <li>输入列：<code>instruction</code>、<code>generations</code></li> <li>输出列：<code>ratings</code>、<code>rationales</code>、<code>distilabel_metadata</code>、<code>model_name</code></li>",us,nl,jt='根据你的使用场景并为了提高结果，你可以使用任何 <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">你选择的其他 LLM</a>。',ds,pl,Us,il,ms,jl,ot="我们将去除不需要的列。",Is,ol,Jt="<li>组件：<code>KeepColumns</code></li> <li>输入列：<code>system</code>、<code>instruction</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code>、<code>ratings</code>、<code>rationales</code>、<code>distilabel_metadata</code> 和 <code>model_name</code></li> <li>输出列：<code>instruction</code>、<code>chosen</code>、<code>rejected</code>、<code>generations</code> 和 <code>order</code></li>",As,Jl,hs,rl,fs,Tl,rt="你可以使用 Argilla 进一步整理您的数据。",gs,yl,Tt="<li>组件：<code>PreferenceToArgilla</code> 步骤</li> <li>输入列：<code>instruction</code>、<code>generations</code>、<code>generation_models</code>、<code>ratings</code></li> <li>输出列：<code>instruction</code>、<code>generations</code>、<code>generation_models</code>、<code>ratings</code></li>",bs,cl,Cs,wl,$s,ul,yt="下面，你可以看到完整管道定义:",Es,dl,Bs,Ul,ct="现在我们来运行管道，清理我们的偏好数据集。",Zs,ml,Gs,Il,wt='让我们检查一下！如果你已经将数据加载到 Argilla 中，你可以在 <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">Argilla UI 中开始标注</a>。',qs,Al,ut='你可以将数据集推送到 Hub 以便与社区共享，并 <a href="https://huggingface.co/docs/hub/datasets-viewer-embed" rel="nofollow">嵌入它以探索数据</a>。',Vs,hl,ks,d,dt,Qs,fl,Ws,gl,Ut="在本教程中，我们展示了使用 distilabel 构建清理偏好数据集管道的详细步骤。然而，你可以根据自己的使用场景自定义此管道，例如清理 SFT 数据集或添加自定义步骤。",Ns,bl,mt="我们以一个偏好数据集作为起点，并通过打乱数据来避免任何偏差。接下来，我们使用一个模型通过无服务器的 Hugging Face 推理 API 评估了响应，遵循了 UltraFeedback 标准。最后，我们保留了必要的列，并使用 Argilla 进行了进一步的数据整理。",_s,Cl,Xs,El,vs;return I=new Et({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/clean_dataset_judges_distilabel.ipynb"}]}}),A=new w({props:{title:"使用大型语言模型作为评审者清理现有的偏好数据集",local:"使用大型语言模型作为评审者清理现有的偏好数据集",headingTag:"h2"}}),$=new w({props:{title:"开始",local:"开始",headingTag:"h2"}}),E=new w({props:{title:"安装依赖",local:"安装依赖",headingTag:"h3"}}),Z=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCaGYtaW5mZXJlbmNlLWVuZHBvaW50cyU1RCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[hf-inference-endpoints]&quot;</span>',wrap:!1}}),G=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnN+JTNENC4wJTIyJTIwJTIydG9yY2h+JTNEMi4wJTIy",highlighted:'!pip install <span class="hljs-string">&quot;transformers~=4.0&quot;</span> <span class="hljs-string">&quot;torch~=2.0&quot;</span>',wrap:!1}}),V=new c({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBLZWVwQ29sdW1ucyUyQyUwQSUyMCUyMCUyMCUyMExvYWREYXRhRnJvbURpY3RzJTJDJTBBJTIwJTIwJTIwJTIwUHJlZmVyZW5jZVRvQXJnaWxsYSUyQyUwQSklMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcy50YXNrcyUyMGltcG9ydCUyMFVsdHJhRmVlZGJhY2s=",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> (
    KeepColumns,
    LoadDataFromDicts,
    PreferenceToArgilla,
)
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> UltraFeedback`,wrap:!1}}),Q=new c({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMEFsb2dpbih0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBhZGRfdG9fZ2l0X2NyZWRlbnRpYWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new w({props:{title:"（可选）部署 Argilla",local:"可选部署-argilla",headingTag:"h3"}}),X=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCYXJnaWxsYSUyQyUyMGhmLWluZmVyZW5jZS1lbmRwb2ludHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[argilla, hf-inference-endpoints]&quot;</span>',wrap:!1}}),v=new w({props:{title:"数据集",local:"数据集",headingTag:"h2"}}),R=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJJbnRlbCUyRm9yY2FfZHBvX3BhaXJzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTIwJTVEJTIyKQ==",highlighted:'dataset = load_dataset(<span class="hljs-string">&quot;Intel/orca_dpo_pairs&quot;</span>, split=<span class="hljs-string">&quot;train[:20]&quot;</span>)',wrap:!1}}),S=new c({props:{code:"ZGVmJTIwc2h1ZmZsZV9hbmRfdHJhY2soY2hvc2VuJTJDJTIwcmVqZWN0ZWQpJTNBJTBBJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMCU1QmNob3NlbiUyQyUyMHJlamVjdGVkJTVEJTBBJTIwJTIwJTIwJTIwcmFuZG9tLnNodWZmbGUocGFpciklMEElMjAlMjAlMjAlMjBvcmRlciUyMCUzRCUyMCU1QiUyMmNob3NlbiUyMiUyMGlmJTIweCUyMCUzRCUzRCUyMGNob3NlbiUyMGVsc2UlMjAlMjJyZWplY3RlZCUyMiUyMGZvciUyMHglMjBpbiUyMHBhaXIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMHBhaXIlMkMlMjAlMjJvcmRlciUyMiUzQSUyMG9yZGVyJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjBzaHVmZmxlX2FuZF90cmFjayh4JTVCJTIyY2hvc2VuJTIyJTVEJTJDJTIweCU1QiUyMnJlamVjdGVkJTIyJTVEKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">shuffle_and_track</span>(<span class="hljs-params">chosen, rejected</span>):
    pair = [chosen, rejected]
    random.shuffle(pair)
    order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order}

dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: shuffle_and_track(x[<span class="hljs-string">&quot;chosen&quot;</span>], x[<span class="hljs-string">&quot;rejected&quot;</span>]))`,wrap:!1}}),z=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9fbGlzdCgp",highlighted:"dataset = dataset.to_list()",wrap:!1}}),H=new w({props:{title:"（可选）创建自定义步骤",local:"可选创建自定义步骤",headingTag:"h3"}}),L=new c({props:{code:"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",highlighted:`&lt;CopyLLMTxtMenu containerStyle=<span class="hljs-string">&quot;float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;&quot;</span>&gt;&lt;/CopyLLMTxtMenu&gt;

<span class="hljs-comment"># &quot;shuffle_step.py&quot;</span>
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TYPE_CHECKING, <span class="hljs-type">List</span>
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> GlobalStep, StepInput

<span class="hljs-keyword">if</span> TYPE_CHECKING:
    <span class="hljs-keyword">from</span> distilabel.steps.typing <span class="hljs-keyword">import</span> StepOutput
    
<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ShuffleStep</span>(<span class="hljs-title class_ inherited__">GlobalStep</span>):
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>]

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">outputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;order&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">self, inputs: StepInput</span>) -&gt; <span class="hljs-string">&quot;StepOutput&quot;</span>:
        outputs = []

        <span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span> <span class="hljs-keyword">in</span> inputs:
            chosen = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;chosen&quot;</span>]
            rejected = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;rejected&quot;</span>]
            pair = [chosen, rejected]
            random.shuffle(pair)
            order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]
            
            outputs.append({<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;instruction&quot;</span>], <span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order})

        <span class="hljs-keyword">yield</span> outputs`,wrap:!1}}),D=new c({props:{code:"ZnJvbSUyMHNodWZmbGVfc3RlcCUyMGltcG9ydCUyMFNodWZmbGVTdGVw",highlighted:'<span class="hljs-keyword">from</span> shuffle_step <span class="hljs-keyword">import</span> ShuffleStep',wrap:!1}}),P=new w({props:{title:"定义管道",local:"定义管道",headingTag:"h2"}}),O=new w({props:{title:"加载数据集",local:"加载数据集",headingTag:"h3"}}),tl=new c({props:{code:"bG9hZF9kYXRhc2V0JTIwJTNEJTIwTG9hZERhdGFGcm9tRGljdHMoJTBBJTIwJTIwJTIwJTIwZGF0YSUzRGRhdGFzZXQlNUIlM0ExJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X21hcHBpbmdzJTNEJTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJpbnN0cnVjdGlvbiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFsb2FkX2RhdGFzZXQubG9hZCgpJTBBbmV4dChsb2FkX2RhdGFzZXQucHJvY2VzcygpKQ==",highlighted:`load_dataset = LoadDataFromDicts(
    data=dataset[:<span class="hljs-number">1</span>],
    output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>},
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
load_dataset.load()
<span class="hljs-built_in">next</span>(load_dataset.process())`,wrap:!1}}),el=new w({props:{title:"评估响应",local:"评估响应",headingTag:"h3"}}),pl=new c({props:{code:"ZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXJfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0QlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC43JTdEJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFldmFsdWF0ZV9yZXNwb25zZXMubG9hZCgpJTBBbmV4dCglMEElMjAlMjAlMjAlMjBldmFsdWF0ZV9yZXNwb25zZXMucHJvY2VzcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMldoYXQncyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMFNwYWluJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhdGlvbnMlMjIlM0ElMjAlNUIlMjJNYWRyaWQlMjIlMkMlMjAlMjJCYXJjZWxvbmElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`evaluate_responses = UltraFeedback(
    aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
    llm=InferenceEndpointsLLM(
        model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
    ),
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
evaluate_responses.load()
<span class="hljs-built_in">next</span>(
    evaluate_responses.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
            }
        ]
    )
)`,wrap:!1}}),il=new w({props:{title:"仅保留必要的列",local:"仅保留必要的列",headingTag:"h3"}}),Jl=new c({props:{code:"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",highlighted:`keep_columns = KeepColumns(
    columns=[
        <span class="hljs-string">&quot;instruction&quot;</span>,
        <span class="hljs-string">&quot;generations&quot;</span>,
        <span class="hljs-string">&quot;order&quot;</span>,
        <span class="hljs-string">&quot;ratings&quot;</span>,
        <span class="hljs-string">&quot;rationales&quot;</span>,
        <span class="hljs-string">&quot;model_name&quot;</span>,
    ],
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
keep_columns.load()
<span class="hljs-built_in">next</span>(
    keep_columns.process(
        [
            {
                <span class="hljs-string">&quot;system&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;Madrid&quot;</span>,
                <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;Barcelona&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
                <span class="hljs-string">&quot;order&quot;</span>: [<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>],
                <span class="hljs-string">&quot;ratings&quot;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">1</span>],
                <span class="hljs-string">&quot;rationales&quot;</span>: [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            }
        ]
    )
)`,wrap:!1}}),rl=new w({props:{title:"（可选）进一步的数据整理",local:"可选进一步的数据整理",headingTag:"h3"}}),cl=new c({props:{code:"dG9fYXJnaWxsYSUyMCUzRCUyMFByZWZlcmVuY2VUb0FyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyY2xlYW5lZC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF93b3Jrc3BhY2UlM0QlMjJhcmdpbGxhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXItc3BhY2UtbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjIlNUJ5b3VyLWFwaS1rZXklNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTBBKQ==",highlighted:`to_argilla = PreferenceToArgilla(
    dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
    dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    num_generations=<span class="hljs-number">2</span>
)`,wrap:!1}}),wl=new w({props:{title:"运行管道",local:"运行管道",headingTag:"h2"}}),dl=new c({props:{code:"d2l0aCUyMFBpcGVsaW5lKG5hbWUlM0QlMjJjbGVhbi1kYXRhc2V0JTIyKSUyMGFzJTIwcGlwZWxpbmUlM0ElMEElMEElMjAlMjAlMjAlMjBsb2FkX2RhdGFzZXQlMjAlM0QlMjBMb2FkRGF0YUZyb21EaWN0cyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhJTNEZGF0YXNldCUyQyUyMG91dHB1dF9tYXBwaW5ncyUzRCU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXJfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0QlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC43JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBrZWVwX2NvbHVtbnMlMjAlM0QlMjBLZWVwQ29sdW1ucyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9ucyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9yZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmF0aW5ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJhdGlvbmFsZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHRvX2FyZ2lsbGElMjAlM0QlMjBQcmVmZXJlbmNlVG9BcmdpbGxhKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCUyMmNsZWFuZWQtZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfd29ya3NwYWNlJTNEJTIyYXJnaWxsYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRiU1QnlvdXItb3duZXItbmFtZSU1RC0lNUJ5b3VyLXNwYWNlLW5hbWUlNUQuaGYuc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyJTVCeW91ci1hcGkta2V5JTVEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2dlbmVyYXRpb25zJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBsb2FkX2RhdGFzZXQuY29ubmVjdChldmFsdWF0ZV9yZXNwb25zZXMpJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGVfcmVzcG9uc2VzLmNvbm5lY3Qoa2VlcF9jb2x1bW5zKSUwQSUyMCUyMCUyMCUyMGtlZXBfY29sdW1ucy5jb25uZWN0KHRvX2FyZ2lsbGEp",highlighted:`<span class="hljs-keyword">with</span> Pipeline(name=<span class="hljs-string">&quot;clean-dataset&quot;</span>) <span class="hljs-keyword">as</span> pipeline:

    load_dataset = LoadDataFromDicts(
        data=dataset, output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>}
    )

    evaluate_responses = UltraFeedback(
        aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
        llm=InferenceEndpointsLLM(
            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
        ),
    )

    keep_columns = KeepColumns(
        columns=[
            <span class="hljs-string">&quot;instruction&quot;</span>,
            <span class="hljs-string">&quot;generations&quot;</span>,
            <span class="hljs-string">&quot;order&quot;</span>,
            <span class="hljs-string">&quot;ratings&quot;</span>,
            <span class="hljs-string">&quot;rationales&quot;</span>,
            <span class="hljs-string">&quot;model_name&quot;</span>,
        ]
    )

    to_argilla = PreferenceToArgilla(
        dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
        dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
        api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
        api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
        num_generations=<span class="hljs-number">2</span>,
    )

    load_dataset.connect(evaluate_responses)
    evaluate_responses.connect(keep_columns)
    keep_columns.connect(to_argilla)`,wrap:!1}}),ml=new c({props:{code:"ZGlzdGlzZXQlMjAlM0QlMjBwaXBlbGluZS5ydW4oKQ==",highlighted:"distiset = pipeline.run()",wrap:!1}}),hl=new c({props:{code:"ZGlzdGlzZXQucHVzaF90b19odWIoJTIyJTVCeW91ci1vd25lci1uYW1lJTVEJTJGZXhhbXBsZS1jbGVhbmVkLXByZWZlcmVuY2UtZGF0YXNldCUyMik=",highlighted:'distiset.push_to_hub(<span class="hljs-string">&quot;[your-owner-name]/example-cleaned-preference-dataset&quot;</span>)',wrap:!1}}),fl=new w({props:{title:"总结",local:"总结",headingTag:"h2"}}),Cl=new Bt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/clean_dataset_judges_distilabel.md"}}),{c(){m=n("meta"),Bl=a(),$l=n("p"),Zl=a(),i(I.$$.fragment),Gl=a(),i(A.$$.fragment),ql=a(),h=n("p"),h.innerHTML=xs,Vl=a(),f=n("ul"),f.innerHTML=Ss,kl=a(),g=n("p"),g.innerHTML=zs,Ql=a(),b=n("p"),b.innerHTML=Hs,Wl=a(),C=n("p"),C.innerHTML=Ys,Nl=a(),i($.$$.fragment),_l=a(),i(E.$$.fragment),Xl=a(),B=n("p"),B.textContent=Ls,vl=a(),i(Z.$$.fragment),Fl=a(),i(G.$$.fragment),Rl=a(),q=n("p"),q.textContent=Ds,xl=a(),i(V.$$.fragment),Sl=a(),k=n("p"),k.innerHTML=Ps,zl=a(),i(Q.$$.fragment),Hl=a(),i(W.$$.fragment),Yl=a(),N=n("p"),N.innerHTML=Ks,Ll=a(),_=n("p"),_.textContent=Os,Dl=a(),i(X.$$.fragment),Pl=a(),i(v.$$.fragment),Kl=a(),F=n("p"),F.innerHTML=lt,Ol=a(),u=n("iframe"),ls=a(),i(R.$$.fragment),ss=a(),x=n("p"),x.innerHTML=tt,ts=a(),i(S.$$.fragment),es=a(),i(z.$$.fragment),as=a(),i(H.$$.fragment),Ms=a(),Y=n("p"),Y.innerHTML=et,ns=a(),i(L.$$.fragment),ps=a(),i(D.$$.fragment),is=a(),i(P.$$.fragment),js=a(),K=n("p"),K.innerHTML=at,os=a(),i(O.$$.fragment),Js=a(),ll=n("p"),ll.textContent=Mt,rs=a(),sl=n("ul"),sl.innerHTML=nt,Ts=a(),i(tl.$$.fragment),ys=a(),i(el.$$.fragment),cs=a(),al=n("p"),al.innerHTML=pt,ws=a(),Ml=n("ul"),Ml.innerHTML=it,us=a(),nl=n("p"),nl.innerHTML=jt,ds=a(),i(pl.$$.fragment),Us=a(),i(il.$$.fragment),ms=a(),jl=n("p"),jl.textContent=ot,Is=a(),ol=n("ul"),ol.innerHTML=Jt,As=a(),i(Jl.$$.fragment),hs=a(),i(rl.$$.fragment),fs=a(),Tl=n("p"),Tl.textContent=rt,gs=a(),yl=n("ul"),yl.innerHTML=Tt,bs=a(),i(cl.$$.fragment),Cs=a(),i(wl.$$.fragment),$s=a(),ul=n("p"),ul.textContent=yt,Es=a(),i(dl.$$.fragment),Bs=a(),Ul=n("p"),Ul.textContent=ct,Zs=a(),i(ml.$$.fragment),Gs=a(),Il=n("p"),Il.innerHTML=wt,qs=a(),Al=n("p"),Al.innerHTML=ut,Vs=a(),i(hl.$$.fragment),ks=a(),d=n("iframe"),Qs=a(),i(fl.$$.fragment),Ws=a(),gl=n("p"),gl.textContent=Ut,Ns=a(),bl=n("p"),bl.textContent=mt,_s=a(),i(Cl.$$.fragment),Xs=a(),El=n("p"),this.h()},l(l){const s=Ct("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(t),Bl=M(l),$l=p(l,"P",{}),Fs($l).forEach(t),Zl=M(l),j(I.$$.fragment,l),Gl=M(l),j(A.$$.fragment,l),ql=M(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-18u8apm"&&(h.innerHTML=xs),Vl=M(l),f=p(l,"UL",{"data-svelte-h":!0}),y(f)!=="svelte-119nnf8"&&(f.innerHTML=Ss),kl=M(l),g=p(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-lad58m"&&(g.innerHTML=zs),Ql=M(l),b=p(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1i8rsrr"&&(b.innerHTML=Hs),Wl=M(l),C=p(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-6zyc4i"&&(C.innerHTML=Ys),Nl=M(l),j($.$$.fragment,l),_l=M(l),j(E.$$.fragment,l),Xl=M(l),B=p(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-h3ae58"&&(B.textContent=Ls),vl=M(l),j(Z.$$.fragment,l),Fl=M(l),j(G.$$.fragment,l),Rl=M(l),q=p(l,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1g9f284"&&(q.textContent=Ds),xl=M(l),j(V.$$.fragment,l),Sl=M(l),k=p(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-3pmo5z"&&(k.innerHTML=Ps),zl=M(l),j(Q.$$.fragment,l),Hl=M(l),j(W.$$.fragment,l),Yl=M(l),N=p(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-etg8dh"&&(N.innerHTML=Ks),Ll=M(l),_=p(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-hpj2rw"&&(_.textContent=Os),Dl=M(l),j(X.$$.fragment,l),Pl=M(l),j(v.$$.fragment,l),Kl=M(l),F=p(l,"P",{"data-svelte-h":!0}),y(F)!=="svelte-12x6420"&&(F.innerHTML=lt),Ol=M(l),u=p(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Fs(u).forEach(t),ls=M(l),j(R.$$.fragment,l),ss=M(l),x=p(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1m3502q"&&(x.innerHTML=tt),ts=M(l),j(S.$$.fragment,l),es=M(l),j(z.$$.fragment,l),as=M(l),j(H.$$.fragment,l),Ms=M(l),Y=p(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-bw8lrw"&&(Y.innerHTML=et),ns=M(l),j(L.$$.fragment,l),ps=M(l),j(D.$$.fragment,l),is=M(l),j(P.$$.fragment,l),js=M(l),K=p(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-kjisqd"&&(K.innerHTML=at),os=M(l),j(O.$$.fragment,l),Js=M(l),ll=p(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-1lf7wyh"&&(ll.textContent=Mt),rs=M(l),sl=p(l,"UL",{"data-svelte-h":!0}),y(sl)!=="svelte-hnxjjr"&&(sl.innerHTML=nt),Ts=M(l),j(tl.$$.fragment,l),ys=M(l),j(el.$$.fragment,l),cs=M(l),al=p(l,"P",{"data-svelte-h":!0}),y(al)!=="svelte-1uvhabi"&&(al.innerHTML=pt),ws=M(l),Ml=p(l,"UL",{"data-svelte-h":!0}),y(Ml)!=="svelte-2fairt"&&(Ml.innerHTML=it),us=M(l),nl=p(l,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-1iehnu5"&&(nl.innerHTML=jt),ds=M(l),j(pl.$$.fragment,l),Us=M(l),j(il.$$.fragment,l),ms=M(l),jl=p(l,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-vgutsj"&&(jl.textContent=ot),Is=M(l),ol=p(l,"UL",{"data-svelte-h":!0}),y(ol)!=="svelte-1uxreds"&&(ol.innerHTML=Jt),As=M(l),j(Jl.$$.fragment,l),hs=M(l),j(rl.$$.fragment,l),fs=M(l),Tl=p(l,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-1ug6eg9"&&(Tl.textContent=rt),gs=M(l),yl=p(l,"UL",{"data-svelte-h":!0}),y(yl)!=="svelte-1dtu78m"&&(yl.innerHTML=Tt),bs=M(l),j(cl.$$.fragment,l),Cs=M(l),j(wl.$$.fragment,l),$s=M(l),ul=p(l,"P",{"data-svelte-h":!0}),y(ul)!=="svelte-uv1p0b"&&(ul.textContent=yt),Es=M(l),j(dl.$$.fragment,l),Bs=M(l),Ul=p(l,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-1s8zpio"&&(Ul.textContent=ct),Zs=M(l),j(ml.$$.fragment,l),Gs=M(l),Il=p(l,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-1dc3rsp"&&(Il.innerHTML=wt),qs=M(l),Al=p(l,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-i1p8nu"&&(Al.innerHTML=ut),Vs=M(l),j(hl.$$.fragment,l),ks=M(l),d=p(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Fs(d).forEach(t),Qs=M(l),j(fl.$$.fragment,l),Ws=M(l),gl=p(l,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-7z51hg"&&(gl.textContent=Ut),Ns=M(l),bl=p(l,"P",{"data-svelte-h":!0}),y(bl)!=="svelte-v2wenh"&&(bl.textContent=mt),_s=M(l),j(Cl.$$.fragment,l),Xs=M(l),El=p(l,"P",{}),Fs(El).forEach(t),this.h()},h(){U(m,"name","hf:doc:metadata"),U(m,"content",Gt),It(u.src,st="https://huggingface.co/datasets/Intel/orca_dpo_pairs/embed/viewer/default/train")||U(u,"src",st),U(u,"frameborder","0"),U(u,"width","100%"),U(u,"height","560px"),It(d.src,dt="https://huggingface.co/datasets/distilabel-internal-testing/example-cleaned-preference-dataset/embed/viewer/default/train")||U(d,"src",dt),U(d,"frameborder","0"),U(d,"width","100%"),U(d,"height","560px")},m(l,s){$t(document.head,m),e(l,Bl,s),e(l,$l,s),e(l,Zl,s),o(I,l,s),e(l,Gl,s),o(A,l,s),e(l,ql,s),e(l,h,s),e(l,Vl,s),e(l,f,s),e(l,kl,s),e(l,g,s),e(l,Ql,s),e(l,b,s),e(l,Wl,s),e(l,C,s),e(l,Nl,s),o($,l,s),e(l,_l,s),o(E,l,s),e(l,Xl,s),e(l,B,s),e(l,vl,s),o(Z,l,s),e(l,Fl,s),o(G,l,s),e(l,Rl,s),e(l,q,s),e(l,xl,s),o(V,l,s),e(l,Sl,s),e(l,k,s),e(l,zl,s),o(Q,l,s),e(l,Hl,s),o(W,l,s),e(l,Yl,s),e(l,N,s),e(l,Ll,s),e(l,_,s),e(l,Dl,s),o(X,l,s),e(l,Pl,s),o(v,l,s),e(l,Kl,s),e(l,F,s),e(l,Ol,s),e(l,u,s),e(l,ls,s),o(R,l,s),e(l,ss,s),e(l,x,s),e(l,ts,s),o(S,l,s),e(l,es,s),o(z,l,s),e(l,as,s),o(H,l,s),e(l,Ms,s),e(l,Y,s),e(l,ns,s),o(L,l,s),e(l,ps,s),o(D,l,s),e(l,is,s),o(P,l,s),e(l,js,s),e(l,K,s),e(l,os,s),o(O,l,s),e(l,Js,s),e(l,ll,s),e(l,rs,s),e(l,sl,s),e(l,Ts,s),o(tl,l,s),e(l,ys,s),o(el,l,s),e(l,cs,s),e(l,al,s),e(l,ws,s),e(l,Ml,s),e(l,us,s),e(l,nl,s),e(l,ds,s),o(pl,l,s),e(l,Us,s),o(il,l,s),e(l,ms,s),e(l,jl,s),e(l,Is,s),e(l,ol,s),e(l,As,s),o(Jl,l,s),e(l,hs,s),o(rl,l,s),e(l,fs,s),e(l,Tl,s),e(l,gs,s),e(l,yl,s),e(l,bs,s),o(cl,l,s),e(l,Cs,s),o(wl,l,s),e(l,$s,s),e(l,ul,s),e(l,Es,s),o(dl,l,s),e(l,Bs,s),e(l,Ul,s),e(l,Zs,s),o(ml,l,s),e(l,Gs,s),e(l,Il,s),e(l,qs,s),e(l,Al,s),e(l,Vs,s),o(hl,l,s),e(l,ks,s),e(l,d,s),e(l,Qs,s),o(fl,l,s),e(l,Ws,s),e(l,gl,s),e(l,Ns,s),e(l,bl,s),e(l,_s,s),o(Cl,l,s),e(l,Xs,s),e(l,El,s),vs=!0},p:ht,i(l){vs||(J(I.$$.fragment,l),J(A.$$.fragment,l),J($.$$.fragment,l),J(E.$$.fragment,l),J(Z.$$.fragment,l),J(G.$$.fragment,l),J(V.$$.fragment,l),J(Q.$$.fragment,l),J(W.$$.fragment,l),J(X.$$.fragment,l),J(v.$$.fragment,l),J(R.$$.fragment,l),J(S.$$.fragment,l),J(z.$$.fragment,l),J(H.$$.fragment,l),J(L.$$.fragment,l),J(D.$$.fragment,l),J(P.$$.fragment,l),J(O.$$.fragment,l),J(tl.$$.fragment,l),J(el.$$.fragment,l),J(pl.$$.fragment,l),J(il.$$.fragment,l),J(Jl.$$.fragment,l),J(rl.$$.fragment,l),J(cl.$$.fragment,l),J(wl.$$.fragment,l),J(dl.$$.fragment,l),J(ml.$$.fragment,l),J(hl.$$.fragment,l),J(fl.$$.fragment,l),J(Cl.$$.fragment,l),vs=!0)},o(l){r(I.$$.fragment,l),r(A.$$.fragment,l),r($.$$.fragment,l),r(E.$$.fragment,l),r(Z.$$.fragment,l),r(G.$$.fragment,l),r(V.$$.fragment,l),r(Q.$$.fragment,l),r(W.$$.fragment,l),r(X.$$.fragment,l),r(v.$$.fragment,l),r(R.$$.fragment,l),r(S.$$.fragment,l),r(z.$$.fragment,l),r(H.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(tl.$$.fragment,l),r(el.$$.fragment,l),r(pl.$$.fragment,l),r(il.$$.fragment,l),r(Jl.$$.fragment,l),r(rl.$$.fragment,l),r(cl.$$.fragment,l),r(wl.$$.fragment,l),r(dl.$$.fragment,l),r(ml.$$.fragment,l),r(hl.$$.fragment,l),r(fl.$$.fragment,l),r(Cl.$$.fragment,l),vs=!1},d(l){l&&(t(Bl),t($l),t(Zl),t(Gl),t(ql),t(h),t(Vl),t(f),t(kl),t(g),t(Ql),t(b),t(Wl),t(C),t(Nl),t(_l),t(Xl),t(B),t(vl),t(Fl),t(Rl),t(q),t(xl),t(Sl),t(k),t(zl),t(Hl),t(Yl),t(N),t(Ll),t(_),t(Dl),t(Pl),t(Kl),t(F),t(Ol),t(u),t(ls),t(ss),t(x),t(ts),t(es),t(as),t(Ms),t(Y),t(ns),t(ps),t(is),t(js),t(K),t(os),t(Js),t(ll),t(rs),t(sl),t(Ts),t(ys),t(cs),t(al),t(ws),t(Ml),t(us),t(nl),t(ds),t(Us),t(ms),t(jl),t(Is),t(ol),t(As),t(hs),t(fs),t(Tl),t(gs),t(yl),t(bs),t(Cs),t($s),t(ul),t(Es),t(Bs),t(Ul),t(Zs),t(Gs),t(Il),t(qs),t(Al),t(Vs),t(ks),t(d),t(Qs),t(Ws),t(gl),t(Ns),t(bl),t(_s),t(Xs),t(El)),t(m),T(I,l),T(A,l),T($,l),T(E,l),T(Z,l),T(G,l),T(V,l),T(Q,l),T(W,l),T(X,l),T(v,l),T(R,l),T(S,l),T(z,l),T(H,l),T(L,l),T(D,l),T(P,l),T(O,l),T(tl,l),T(el,l),T(pl,l),T(il,l),T(Jl,l),T(rl,l),T(cl,l),T(wl,l),T(dl,l),T(ml,l),T(hl,l),T(fl,l),T(Cl,l)}}}const Gt='{"title":"使用大型语言模型作为评审者清理现有的偏好数据集","local":"使用大型语言模型作为评审者清理现有的偏好数据集","sections":[],"depth":2}';function qt(Rs){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends gt{constructor(m){super(),bt(this,m,qt,Zt,At,{})}}export{Nt as component};
