import{s as Ua,a as da,n as ha,o as Ia}from"../chunks/scheduler.1f027d5a.js";import{S as ja,i as ba,e as i,s,c as p,h as fa,a as o,d as l,b as a,f as Ht,g as y,j as M,k as w,l as f,m as n,n as c,t as r,o as J,p as u}from"../chunks/index.6117a65d.js";import{C as Ga}from"../chunks/CopyLLMTxtMenu.0ff8411a.js";import{D as ga,C as m}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as T,E as Ba}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function Ca(An){let d,xt,Wt,Vt,G,Xt,g,Rt,B,kt,C,Pn='<em>作者: <a href="https://huggingface.co/dmaniloff" rel="nofollow">Diego Maniloff</a></em>',_t,Z,Yt,v,Dn='在本 Notebook 中，我们将展示如何使用 <a href="https://www.gradio.app/" rel="nofollow">Gradio</a> 让任何机器学习模型栩栩如生。Gradio 是一个库，允许你从任何 Python 函数创建网页演示并与全世界分享 🌎！',St,W,Kn="📚 本 Notebook 涵盖内容：",Qt,$,On="<li>创建一个 <code>Hello, World!</code> 演示：Gradio 基础</li> <li>将你的演示移至 Hugging Face Spaces</li> <li>让它更有趣：利用 🤗 Hub 的真实案例</li> <li>一些 Gradio 的酷炫“电池内置”功能</li>",Lt,H,es="⏭️ 在本 Notebook 的末尾，你会找到一个 <code>进一步阅读</code> 列表，包含链接，帮助你继续深入探索。",Nt,x,zt,V,ts="要开始，请安装 <code>gradio</code> 库以及 <code>transformers</code>。",Ft,X,qt,R,Et,k,At,_,ls="Gradio 的核心功能是将任何 Python 函数转换为网页界面。",Pt,Y,ns="假设我们有一个简单的函数，它接受 <code>name</code> 和 <code>intensity</code> 作为参数，并返回一个字符串，如下所示：",Dt,S,Kt,Q,ss="如果你对名字为 ‘Diego’ 调用这个函数，你将得到如下所示的输出字符串：",Ot,L,el,N,as=`Hello, Diego!!!
`,tl,z,is="使用 Gradio，我们可以通过 <code>gr.Interface</code> 类为这个函数构建一个界面。我们只需要传入我们上面创建的 <code>greet</code> 函数，以及该函数所期望的输入和输出类型：",ll,F,nl,q,os='注意到我们传入了 <code>[&quot;text&quot;, &quot;slider&quot;]</code> 作为输入，以及 <code>[&quot;text&quot;]</code> 作为输出——这些在 Gradio 中被称为 <a href="https://www.gradio.app/docs/gradio/introduction" rel="nofollow">组件</a>。',sl,E,Ms="这就是我们第一个演示所需要的全部内容。赶紧试试吧 👇🏼！在 <code>name</code> 文本框中输入你的名字，调整你想要的强度，然后点击 <code>Submit</code>。",al,A,il,P,ol,D,ps="到目前为止，你已经了解了如何将一个基本的 Python 函数转换成一个适合网页展示的演示。然而，我们所做的仅仅是一个非常简单的函数，甚至有点无聊！",Ml,K,ys="现在，让我们考虑一个更有趣的例子，这个例子能突出展示 Gradio 最初的目的：展示最前沿的机器学习模型。最近，我的一位好朋友请我帮忙处理她做的一个访谈录音。她需要将音频文件转化成一个井井有条的文本摘要。我是怎么帮助她的呢？我构建了一个 Gradio 应用！",pl,O,cs="接下来，我们一起来看看如何构建会议转录工具。我们可以将这个过程分为两个部分：",yl,ee,rs="<li>将音频文件转录成文本</li> <li>将文本组织成章节、段落、列表等。我们也可以在这里加入摘要功能。</li>",cl,te,rl,le,Js="在这一部分，我们将构建一个演示，处理会议转录工具的第一步：将音频转换成文本。",Jl,ne,us="正如我们所学到的，构建一个 Gradio 演示的关键是拥有一个执行我们想展示逻辑的 Python 函数。对于音频转文本的转换，我们将使用强大的 <code>transformers</code> 库，并通过它的 <code>pipeline</code> 工具来使用一个流行的音频转文本模型 —— <code>distil-whisper/distil-large-v3</code>。",ul,se,ms="以下是 <code>transcribe</code> 函数，它接受我们想要转换的音频作为输入：",ml,ae,Tl,ie,Ts='现在我们有了 Python 函数，我们可以通过将它传递给 <code>gr.Interface</code> 来进行演示。注意，在这种情况下，函数所期望的输入是我们要转换的音频。Gradio 包含了许多有用的组件，其中之一是 <a href="https://www.gradio.app/docs/gradio/audio" rel="nofollow">Audio</a>，正是我们演示所需要的 🎶 😎。',wl,oe,dl,Me,ws="赶紧试试看 👆！你可以上传一个 <code>.mp3</code> 文件，或者点击 🎤 按钮录制你自己的声音。",Ul,pe,ds='如果你想要一个实际的会议录音样本，可以查看 <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio" rel="nofollow">MeetingBank_Audio 数据集</a>，这是一个包含6个美国主要城市市议会会议的音频数据集。为了进行测试，我尝试了几个 <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio/blob/main/Denver/mp3/Denver-21.zip" rel="nofollow">丹佛会议</a>。',hl,U,Us='<p>另外，查看 <code>Interface</code> 的 <a href="https://www.gradio.app/docs/gradio/interface#interface-from_pipeline" rel="nofollow">from_pipeline</a> 构造函数，它可以直接从一个 <code>pipeline</code> 构建 <code>Interface</code>。</p>',Il,ye,jl,ce,hs="在会议转录工具的第二部分，我们需要组织上一部分转录得到的文本。",bl,re,Is='同样地，为了构建一个 Gradio 演示，我们需要一个包含我们关心的逻辑的 Python 函数。对于文本的组织和总结，我们将使用一个经过“指令调优”的模型，它被训练来执行广泛的任务。我们有许多选项可以选择，例如 <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-8B-Instruct</a> 或 <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3" rel="nofollow">mistralai/Mistral-7B-Instruct-v0.3</a>。在我们的例子中，我们将使用 <a href="https://huggingface.co/microsoft/Phi-3-mini-4k-instruct" rel="nofollow">microsoft/Phi-3-mini-4k-instruct</a>。',fl,Je,js='就像第一部分一样，我们本可以利用 <code>transformers</code> 中的 <code>pipeline</code> 工具来完成这项任务，但这次我们将利用这个机会展示 <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">无服务器推理 API</a>，它是 Hugging Face Hub 中的一项 API，允许我们免费使用数千个公开可访问的（或你自己私有授权的）机器学习模型！查看无服务器推理 API 的 <a href="https://huggingface.co/learn/cookbook/en/enterprise_hub_serverless_inference_api" rel="nofollow">食谱</a> 部分。',Gl,ue,bs='使用无服务器推理 API 意味着，我们将通过 <code>InferenceClient</code>（这是 <code>huggingface_hub</code> 库的一部分）来调用模型，而不是像我们在音频转换部分那样通过 <code>pipeline</code> 调用模型（<a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python 库</a>）。为了使用 <code>InferenceClient</code>，我们需要通过 <code>notebook_login()</code> 登录到 🤗 Hub，这将弹出一个对话框，要求输入你的用户访问令牌以进行身份验证。',gl,me,fs='你可以从 <a href="https://huggingface.co/settings/tokens" rel="nofollow">个人设置页面</a> 管理你的令牌，并请尽量使用 <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">细粒度</a> 令牌，以提高安全性。',Bl,Te,Cl,we,Gs="现在我们已经登录到 Hub，我们可以通过 <code>InferenceClient</code> 使用无服务器推理 API 编写我们的文本处理函数。",Zl,de,gs="这一部分的代码将被结构化为两个函数：",vl,Ue,Bs="<li><code>build_messages</code>：用于将消息提示格式化为 LLM（大语言模型）所需的格式；</li> <li><code>organize_text</code>：实际将原始会议文本传递给 LLM 进行组织（以及根据我们提供的提示进行总结）。</li>",Wl,he,$l,Ie,Hl,je,Cs="现在我们有了文本组织函数 <code>organize_text</code>，我们也可以为它构建一个演示：",xl,be,Vl,fe,Zs="赶紧试试看 👆！如果你在上面的演示中点击 “Submit”，你会看到输出文本是转录内容的一个更清晰、更有条理的版本，其中包含了标题和会议不同部分的章节。",Xl,Ge,vs="你可以尝试调整 <code>user_input</code> 变量，控制 LLM 提示，看看能否得到一个总结。",Rl,ge,kl,Be,Ws="到目前为止，我们已经为会议转录工具的两个步骤编写了函数：",_l,Ce,$s="<li>将音频转换成文本文件，</li> <li>将该文本文件组织成格式良好的会议文档。</li>",Yl,Ze,Hs="接下来，我们只需要将这两个函数整合在一起，并为组合后的步骤构建一个演示。换句话说，我们的完整会议转录工具就是一个新的函数（我们将其创意命名为 <code>meeting_transcript_tool</code> 😀），它将 <code>transcribe</code> 的输出传递给 <code>organize_text</code>：",Sl,ve,Ql,We,xs="赶紧试试看 👆！现在这是我们完整的转录工具演示。如果你提供一个音频文件，输出将是已经组织（并可能已总结）的会议版本。超级酷 😎。",Ll,$e,Nl,He,Vs="如果你已经完成到这里，那么恭喜你，你现在已经掌握了如何使用 Gradio 创建机器学习模型的演示 👏！",zl,xe,Xs="接下来，我们将向你展示如何将你全新的演示迁移到 Hugging Face Spaces。除了 Gradio 的易用性和强大功能，将你的演示迁移到 🤗 Spaces 还能为你提供永久托管、每次更新应用时的便捷部署，以及与任何人分享你工作的能力！需要注意的是，如果你长时间没有使用或更改你的 Space，它会进入休眠状态。",Fl,Ve,Rs='第一步是前往 <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>，从模板中选择 “Gradio”，然后将其余选项保留为默认设置（你以后可以修改这些选项）：',ql,h,ks,El,Xe,_s='这将创建一个新的 Space，你可以在其中填充你的演示代码。作为一个示例，我创建了 🤗 Space <code>dmaniloff/meeting-transcript-tool</code>，你可以通过 <a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool" rel="nofollow">这里</a> 访问。',Al,Re,Ys="我们需要编辑两个文件：",Pl,I,ke,Zt,Ss="<code>app.py</code> —— 这是演示代码所在的地方，内容应该如下所示：",Fn,_e,qn,Ye,vt,Qs="<code>requirements.txt</code> —— 这是我们告诉 Space 需要哪些库的地方，内容应该如下所示：",En,Se,Dl,Qe,Kl,Le,Ls="Gradio 自带了许多非常酷的功能，开箱即用。我们无法在这篇 Notebook 中覆盖所有功能，但以下是我们将要查看的三个功能：",Ol,Ne,Ns="<li><strong>作为 API 访问</strong></li> <li><strong>通过公共 URL 分享</strong></li> <li><strong>标记功能</strong></li>",en,ze,tn,Fe,zs="使用 Gradio 构建网页演示的一个好处是，你会自动获得一个 API 🙌！这意味着，你可以使用标准的 HTTP 客户端（如 <code>curl</code> 或 Python 的 <code>requests</code> 库）来访问你 Python 函数的功能。",ln,qe,Fs='如果你仔细查看我们上面创建的演示，你会看到在底部有一个链接，写着 “Use via API”。如果你点击我创建的 Space（<a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool/blob/main/app.py" rel="nofollow">dmaniloff/meeting-transcript-tool</a>）中的链接，你将看到如下内容：',nn,j,qs,sn,Ee,Es="让我们复制并粘贴下面的代码，使用我们的 Space 作为 API",an,Ae,on,Pe,Mn,De,As=`Loaded as API: https://dmaniloff-meeting-transcript-tool.hf.space ✔
Certainly! Below is an organized version of a hypothetical meeting transcript. Since the original transcript you've provided is quite minimal, I'll create a more detailed and structured example featuring a meeting summary.

---

# Meeting Transcript: Project Alpha Kickoff

**Date:** April 7, 2023

**Location:** Conference Room B, TechCorp Headquarters


**Attendees:**

- John Smith (Project Manager)

- Emily Johnson (Lead Developer)

- Michael Brown (Marketing Lead)

- Lisa Green (Design Lead)


**Meeting Duration:** 1 hour 30 minutes


## Opening Remarks

**John Smith:**

Good morning everyone, and thank you for joining this kickoff meeting for Project Alpha. Today, we'll discuss our project vision, milestones, and roles. Let's get started.


## Vision and Goals

**Emily Johnson:**

The main goal of Project Alpha is to
`,pn,Ke,Ps="哇！刚刚发生了什么？让我们来分解一下：",yn,Oe,Ds="<li>我们安装了 <code>gradio_client</code>，这是一个专门用于与 Gradio 构建的 API 交互的包。</li> <li>我们通过提供想要查询的 🤗 Space 的名称来实例化客户端。</li> <li>我们调用了客户端的 <code>predict</code> 方法，并传入了一个示例音频文件。</li>",cn,et,Ks="Gradio 客户端会为我们处理 HTTP POST 请求，同时它还提供了像读取输入音频文件（通过 <code>handle_file</code> 函数）这样的功能，音频文件将由我们的会议转录工具处理。",rn,tt,Os="再次强调，使用这个客户端是一个选择，你完全可以直接运行 <code>curl -X POST https://dmaniloff-meeting-transcript-tool.hf.space/call/predict [...]</code>，并传入请求所需的所有参数。",Jn,b,ea="<p>上述调用得到的输出是一个由我们用于文本组织的 LLM 生成的虚拟会议，因为示例输入文件并非真实的会议录音。你可以调整 LLM 的提示，以适应这种情况。</p>",un,lt,mn,nt,ta="Gradio 的另一个酷功能是，即使你在本地计算机上构建了演示（在将其移到 🤗 Space 之前），你仍然可以通过将 <code>share=True</code> 传递给 <code>launch</code> 来将其分享给全世界，如下所示：",Tn,st,wn,at,la="你可能已经注意到，在这个 Google Colab 环境中，这个行为默认启用，因此我们之前创建的演示已经有了一个公共 URL，你可以分享给任何人 🌎。返回 ⬆ 并查看日志中 <code>Running on public URL:</code> 的部分来找到它 🔎！",dn,it,Un,ot,na='<a href="https://www.gradio.app/guides/using-flagging" rel="nofollow">标记功能</a>是 Gradio 内置的一项功能，它允许你的演示用户提供反馈。你可能已经注意到，我们创建的第一个演示底部有一个 <code>Flag</code> 按钮。',hn,Mt,sa="在默认选项下，当用户点击该按钮时，输入和输出示例会被保存到一个 CSV 日志文件中，供你稍后查看。如果演示涉及音频（如我们的例子），这些音频文件会被单独保存到一个并行目录中，并且这些文件的路径会被记录在 CSV 文件中。",In,pt,aa="现在，回到我们第一个演示，再次尝试一下，然后点击 <code>Flag</code> 按钮。你会看到一个新的日志文件会在 <code>flagged</code> 目录中创建：",jn,yt,bn,ct,ia=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
`,fn,rt,oa="在这个例子中，我设置了 <code>name=diego</code> 和 <code>intensity=29</code> 作为输入，并点击了标记（Flag）。你可以看到，日志文件包括了函数的输入、输出（<code>&quot;Hello, diego!!!!!!!!!!!!!!!!!!!!!!!!!!!!!&quot;</code>），以及时间戳。",Gn,Jt,Ma="虽然记录用户认为有问题的输入和输出清单总比没有好，Gradio 的标记功能实际上能做得更多。例如，你可以提供一个 <code>flagging_options</code> 参数，让你自定义用户反馈或错误的类型，比如 <code>[&quot;Incorrect&quot;, &quot;Ambiguous&quot;]</code>。需要注意的是，这要求 <code>allow_flagging</code> 必须设置为 <code>&quot;manual&quot;</code>，如下所示：",gn,ut,Bn,mt,pa="去试试上面的代码吧 👆！你会看到，标记按钮现在变成了 <code>Flag as Incorrect</code> 和 <code>Flag as Ambiguous</code>，而新的日志文件将反映出这些选项：",Cn,Tt,Zn,wt,ya=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
Diego,5,"Hello, Diego!!!!!",Ambiguous,,2024-06-29 22:08:04.281030
`,vn,dt,Wn,Ut,ca="在这篇 Notebook 中，我们学习了如何使用 Gradio 演示任何机器学习模型。",$n,ht,ra="首先，我们了解了如何为一个简单的 Python 函数设置接口；其次，我们深入探讨了 Gradio 的真正强项：为机器学习模型构建演示。",Hn,It,Ja="在这一过程中，我们学习了如何通过 <code>transformers</code> 库及其 <code>pipeline</code> 函数轻松地利用 🤗 Hub 中的模型，以及如何使用 <code>gr.Audio</code> 等多媒体输入。",xn,jt,ua="接着，我们学习了如何将你的 Gradio 演示托管到 🤗 Spaces 上，这样你可以让演示一直在云端运行，并为你的演示提供灵活的计算资源。",Vn,bt,ma="最后，我们展示了 Gradio 内置的一些非常酷的功能，比如 API 访问、公用 URL 和标记功能。",Xn,ft,Rn,Gt,Ta="如果你希望进一步深入，可以查看每个部分结尾的 <code>进一步阅读</code> 链接，继续探索更多功能和应用。",kn,gt,_n,Bt,wa='<li><a href="https://www.gradio.app/guides/quickstart#building-your-first-demo" rel="nofollow">你的第一个 Gradio 演示</a></li> <li><a href="https://www.gradio.app/docs/gradio/introduction" rel="nofollow">Gradio 组件</a></li> <li><a href="https://huggingface.co/docs/transformers/en/index" rel="nofollow">Transformers 库</a></li> <li><a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Pipeline 函数</a></li> <li><a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python 库</a></li> <li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">无服务器推理 API</a></li> <li><a href="https://huggingface.co/spaces" rel="nofollow">🤗 Spaces</a></li> <li><a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Spaces 文档</a></li>',Yn,Ct,Sn,$t,Qn;return G=new ga({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/enterprise_cookbook_gradio.ipynb"}]}}),g=new Ga({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new T({props:{title:"使用 Spaces 和 Gradio 创建演示",local:"使用-spaces-和-gradio-创建演示",headingTag:"h1"}}),Z=new T({props:{title:"介绍",local:"介绍",headingTag:"h2"}}),x=new T({props:{title:"设置",local:"设置",headingTag:"h2"}}),X=new m({props:{code:"IXBpcCUyMC1xJTIwaW5zdGFsbCUyMGdyYWRpbyUzRCUzRDQuMzYuMSUwQSFwaXAlMjAtcSUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlM0QlM0Q0LjQxLjI=",highlighted:`!pip -q install gradio==<span class="hljs-number">4.36</span><span class="hljs-number">.1</span>
!pip -q install transformers==<span class="hljs-number">4.41</span><span class="hljs-number">.2</span>`,wrap:!1}}),R=new m({props:{code:"JTIzJTIwdGhlJTIwdXN1YWwlMjBzaG9ydGhhbmQlMjBpcyUyMHRvJTIwaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3I=",highlighted:`<span class="hljs-comment"># the usual shorthand is to import gradio as gr</span>
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr`,wrap:!1}}),k=new T({props:{title:"你的第一个演示：Gradio 基础",local:"你的第一个演示gradio-基础",headingTag:"h2"}}),S=new m({props:{code:"ZGVmJTIwZ3JlZXQobmFtZSUzQSUyMHN0ciUyQyUyMGludGVuc2l0eSUzQSUyMGludCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySGVsbG8lMkMlMjAlMjIlMjAlMkIlMjBuYW1lJTIwJTJCJTIwJTIyISUyMiUyMColMjBpbnQoaW50ZW5zaXR5KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greet</span>(<span class="hljs-params">name: <span class="hljs-built_in">str</span>, intensity: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Hello, &quot;</span> + name + <span class="hljs-string">&quot;!&quot;</span> * <span class="hljs-built_in">int</span>(intensity)`,wrap:!1}}),L=new m({props:{code:"cHJpbnQoZ3JlZXQoJTIyRGllZ28lMjIlMkMlMjAzKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(greet(<span class="hljs-string">&quot;Diego&quot;</span>, <span class="hljs-number">3</span>))',wrap:!1}}),F=new m({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSk=",highlighted:`demo = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>], <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],          <span class="hljs-comment"># the output is a text box</span>
)`,wrap:!1}}),A=new m({props:{code:"JTIzJTIwdGhlJTIwbGF1bmNoJTIwbWV0aG9kJTIwd2lsbCUyMGZpcmUlMjB1cCUyMHRoZSUyMGludGVyZmFjZSUyMHdlJTIwanVzdCUyMGNyZWF0ZWQlMEFkZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-comment"># the launch method will fire up the interface we just created</span>
demo.launch()`,wrap:!1}}),P=new T({props:{title:"让我们做得更有趣：会议转录工具",local:"让我们做得更有趣会议转录工具",headingTag:"h2"}}),te=new T({props:{title:"音频转文本",local:"音频转文本",headingTag:"h3"}}),ae=new m({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0ZW1wZmlsZSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMDAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBJTBBQVVESU9fTU9ERUxfTkFNRSUyMCUzRCUyMCUyMmRpc3RpbC13aGlzcGVyJTJGZGlzdGlsLWxhcmdlLXYzJTIyJTIwJTIzJTIwZmFzdGVyJTIwYW5kJTIwdmVyeSUyMGNsb3NlJTIwaW4lMjBwZXJmb3JtYW5jZSUyMHRvJTIwdGhlJTIwZnVsbC1zaXplJTIwJTIyb3BlbmFpJTJGd2hpc3Blci1sYXJnZS12MyUyMiUwQUJBVENIX1NJWkUlMjAlM0QlMjA4JTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RBVURJT19NT0RFTF9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwY2h1bmtfbGVuZ3RoX3MlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRGRldmljZSUyQyUwQSklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlKGF1ZGlvX2lucHV0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkZ1bmN0aW9uJTIwdG8lMjBjb252ZXJ0JTIwYXVkaW8lMjB0byUyMHRleHQuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBhdWRpb19pbnB1dCUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwZ3IuRXJyb3IoJTIyTm8lMjBhdWRpbyUyMGZpbGUlMjBzdWJtaXR0ZWQhJTIyKSUwQSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9faW5wdXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEQkFUQ0hfU0laRSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuX3RpbWVzdGFtcHMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-number">0</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

AUDIO_MODEL_NAME = <span class="hljs-string">&quot;distil-whisper/distil-large-v3&quot;</span> <span class="hljs-comment"># faster and very close in performance to the full-size &quot;openai/whisper-large-v3&quot;</span>
BATCH_SIZE = <span class="hljs-number">8</span>


pipe = pipeline(
    task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=AUDIO_MODEL_NAME,
    chunk_length_s=<span class="hljs-number">30</span>,
    device=device,
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">audio_input</span>):
    <span class="hljs-string">&quot;&quot;&quot;Function to convert audio to text.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_input <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> gr.Error(<span class="hljs-string">&quot;No audio file submitted!&quot;</span>)

    output = pipe(
        audio_input,
        batch_size=BATCH_SIZE,
        generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
        return_timestamps=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),oe=new m({props:{code:"cGFydF8xX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0R0cmFuc2NyaWJlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8odHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUyMCUyMyUyMCUyMmZpbGVwYXRoJTIyJTIwcGFzc2VzJTIwYSUyMHN0ciUyMHBhdGglMjB0byUyMGElMjB0ZW1wb3JhcnklMjBmaWxlJTIwY29udGFpbmluZyUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTIwJTIzJTIwZ2l2ZSUyMHVzZXJzJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjBjb3B5JTIwdGhlJTIwcmVzdWx0cyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyVHJhbnNjcmliZSUyMEF1ZGlvJTIwdG8lMjBUZXh0JTIyJTJDJTIwJTIzJTIwZ2l2ZSUyMG91ciUyMGRlbW8lMjBhJTIwdGl0bGUlMjAlM0EpJTBBKSUwQSUwQXBhcnRfMV9kZW1vLmxhdW5jaCgp",highlighted:`part_1_demo = gr.Interface(
    fn=transcribe,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>), <span class="hljs-comment"># &quot;filepath&quot; passes a str path to a temporary file containing the audio</span>
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>), <span class="hljs-comment"># give users the option to copy the results</span>
    title=<span class="hljs-string">&quot;Transcribe Audio to Text&quot;</span>, <span class="hljs-comment"># give our demo a title :)</span>
)

part_1_demo.launch()`,wrap:!1}}),ye=new T({props:{title:"组织和总结文本",local:"组织和总结文本",headingTag:"h3"}}),Te=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIwcnVubmluZyUyMHRoaXMlMjB3aWxsJTIwcHJvbXB0JTIweW91JTIwdG8lMjBlbnRlciUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMGNyZWRlbnRpYWxzJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, InferenceClient

<span class="hljs-comment"># running this will prompt you to enter your Hugging Face credentials</span>
notebook_login()`,wrap:!1}}),he=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># sample meeting transcript from huuuyeah/MeetingBank_Audio</span>
<span class="hljs-comment"># this is just a copy-paste from the output of part 1 using one of the Denver meetings</span>
sample_transcript = <span class="hljs-string">&quot;&quot;&quot;
 Good evening. Welcome to the Denver City Council meeting of Monday, May 8, 2017. My name is Kelly Velez. I&#x27;m your Council Secretary. According to our rules of procedure, when our Council President, Albus Brooks, and Council President Pro Tem, JoLynn Clark, are both absent, the Council Secretary calls the meeting to order. Please rise and join Councilman Herndon in the Pledge of Allegiance. Madam Secretary, roll call. Roll call. Here. Mark. Espinosa. Here. Platt. Delmar. Here. Here. Here. Here. We have five members present. There is not a quorum this evening. Many of the council members are participating in an urban exploration trip in Portland, Oregon, pursuant to Section 3.3.4 of the city charter. Because there is not a quorum of seven council members present, all of tonight&#x27;s business will move to next week, to Monday, May 15th. Seeing no other business before this body except to wish Councilwoman Keniche a very happy birthday this meeting is adjourned Thank you. A standard model and an energy efficient model likely will be returned to you in energy savings many times during its lifespan. Now, what size do you need? Air conditioners are not a one-size-or-type fits all. Before you buy an air conditioner, you need to consider the size of your home and the cost to operate the unit per hour. Do you want a room air conditioner, which costs less but cools a smaller area, or do you want a central air conditioner, which cools your entire house but costs more? Do your homework. Now, let&#x27;s discuss evaporative coolers. In low humidity areas, evaporating water into the air provides a natural and energy efficient means of cooling. Evaporative coolers, also called swamp coolers, cool outdoor air by passing it over water saturated pads, causing the water to evaporate into it. Evaporative coolers cost about one half as much to install as central air conditioners and use about one-quarter as much energy. However, they require more frequent maintenance than refrigerated air conditioners, and they&#x27;re suitable only for areas with low humidity. Watch the maintenance tips at the end of this segment to learn more. And finally, fans. When air moves around in your home, it creates a wind chill effect. A mere two-mile-an-hour breeze will make your home feel four degrees cooler and therefore you can set your thermostat a bit higher. Ceiling fans and portable oscillating fans are cheap to run and they make your house feel cooler. You can also install a whole house fan to draw the hot air out of your home. A whole house fan draws cool outdoor air inside through open windows and exhausts hot room air through the attic to the outside. The result is excellent ventilation, lower indoor temperatures, and improved evaporative cooling. But remember, there are many low-cost, no-cost ways that you can keep your home cool. You should focus on these long before you turn on your AC or even before you purchase an AC. But if you are going to purchase a new cooling system, remember to get one that&#x27;s energy efficient and the correct size for your home. Wait, wait, don&#x27;t go away, there&#x27;s more. After this segment of the presentation is over, you&#x27;re going to be given the option to view maintenance tips about air conditioners and evaporative coolers. Now all of these tips are brought to you by the people at Xcel Energy. Thanks for watching.
&quot;&quot;&quot;</span>`,wrap:!1}}),Ie=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQVRFWFRfTU9ERUxfTkFNRSUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQobWVldGluZ190cmFuc2NyaXB0KSUzQSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUyMG1vZGVsJTNEVEVYVF9NT0RFTF9OQU1FJTJDJTIwbWF4X3Rva2VucyUzRDI1MCUyQyUyMHNlZWQlM0Q0MzAlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTBBJTBBZGVmJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUyMC0lM0UlMjBsaXN0JTNBJTBBJTIwJTIwJTIwJTIwc3lzdGVtX2lucHV0JTIwJTNEJTIwJTIyWW91JTIwYXJlJTIwYW4lMjBhc3NpdGFudCUyMHRoYXQlMjBvcmdhbml6ZXMlMjBtZWV0aW5nJTIwbWludXRlcy4lMjIlMEElMjAlMjAlMjAlMjB1c2VyX2lucHV0JTIwJTNEJTIwJTIyJTIyJTIyVGFrZSUyMHRoaXMlMjByYXclMjBtZWV0aW5nJTIwdHJhbnNjcmlwdCUyMGFuZCUyMHJldHVybiUyMGFuJTIwb3JnYW5pemVkJTIwdmVyc2lvbi4lMEElMjAlMjAlMjAlMjBIZXJlJTIwaXMlMjB0aGUlMjB0cmFuc2NyaXB0JTNBJTBBJTIwJTIwJTIwJTIwJTdCbWVldGluZ190cmFuc2NyaXB0JTdEJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyLmZvcm1hdChtZWV0aW5nX3RyYW5zY3JpcHQlM0RtZWV0aW5nX3RyYW5zY3JpcHQpJTBBJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9pbnB1dCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHVzZXJfaW5wdXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXNzYWdlcw==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

TEXT_MODEL_NAME = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

client = InferenceClient()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">meeting_transcript</span>):
    messages = build_messages(meeting_transcript)
    response = client.chat_completion(
        messages, model=TEXT_MODEL_NAME, max_tokens=<span class="hljs-number">250</span>, seed=<span class="hljs-number">430</span>
    )
    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


<span class="hljs-keyword">def</span> <span class="hljs-title function_">build_messages</span>(<span class="hljs-params">meeting_transcript</span>) -&gt; <span class="hljs-built_in">list</span>:
    system_input = <span class="hljs-string">&quot;You are an assitant that organizes meeting minutes.&quot;</span>
    user_input = <span class="hljs-string">&quot;&quot;&quot;Take this raw meeting transcript and return an organized version.
    Here is the transcript:
    {meeting_transcript}
    &quot;&quot;&quot;</span>.<span class="hljs-built_in">format</span>(meeting_transcript=meeting_transcript)

    messages = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_input},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_input},
    ]
    <span class="hljs-keyword">return</span> messages`,wrap:!1}}),be=new m({props:{code:"cGFydF8yX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0Rvcmdhbml6ZV90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuVGV4dGJveCh2YWx1ZSUzRHNhbXBsZV90cmFuc2NyaXB0KSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5UZXh0Ym94KHNob3dfY29weV9idXR0b24lM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQ2xlYW4lMjBVcCUyMFRyYW5zY3JpcHQlMjBUZXh0JTIyJTJDJTBBKSUwQXBhcnRfMl9kZW1vLmxhdW5jaCgp",highlighted:`part_2_demo = gr.Interface(
    fn=organize_text,
    inputs=gr.Textbox(value=sample_transcript),
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
    title=<span class="hljs-string">&quot;Clean Up Transcript Text&quot;</span>,
)
part_2_demo.launch()`,wrap:!1}}),ge=new T({props:{title:"整合所有部分",local:"整合所有部分",headingTag:"h3"}}),ve=new m({props:{code:"ZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woYXVkaW9faW5wdXQpJTNBJTBBJTIwJTIwJTIwJTIwbWVldGluZ190ZXh0JTIwJTNEJTIwdHJhbnNjcmliZShhdWRpb19pbnB1dCklMEElMjAlMjAlMjAlMjBvcmdhbml6ZWRfdGV4dCUyMCUzRCUyMG9yZ2FuaXplX3RleHQobWVldGluZ190ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZ2FuaXplZF90ZXh0JTBBJTBBJTBBZnVsbF9kZW1vJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEbWVldGluZ190cmFuc2NyaXB0X3Rvb2wlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJUaGUlMjBDb21wbGV0ZSUyME1lZXRpbmclMjBUcmFuc2NyaXB0aW9uJTIwVG9vbCUyMiUyQyUwQSklMEFmdWxsX2RlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">audio_input</span>):
    meeting_text = transcribe(audio_input)
    organized_text = organize_text(meeting_text)
    <span class="hljs-keyword">return</span> organized_text


full_demo = gr.Interface(
    fn=meeting_transcript_tool,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
    title=<span class="hljs-string">&quot;The Complete Meeting Transcription Tool&quot;</span>,
)
full_demo.launch()`,wrap:!1}}),$e=new T({props:{title:"将你的演示迁移到 🤗 Spaces",local:"将你的演示迁移到--spaces",headingTag:"h2"}}),_e=new m({props:{code:"JTIzJTIwYXBwLnB5JTIwJUU3JTlBJTg0JUU1JUE0JUE3JUU3JUJBJUIyJUVGJUJDJTlBJTBBJTBBZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMHRyYW5zY3JpYmUoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-comment"># app.py 的大纲：</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">...</span>):
   ...`,wrap:!1}}),Se=new m({props:{code:"JTIzJTIwcmVxdWlyZW1lbnRzLnR4dCUyMCVFNyU5QSU4NCVFNSU4NiU4NSVFNSVBRSVCOSVFRiVCQyU5QSUwQXRvcmNoJTBBdHJhbnNmb3JtZXJz",highlighted:`<span class="hljs-comment"># requirements.txt 的内容：</span>
<span class="hljs-attribute">torch</span>
transformers`,wrap:!1}}),Qe=new T({props:{title:"Gradio 自带“电池” 🔋",local:"gradio-自带电池-",headingTag:"h2"}}),ze=new T({props:{title:"作为 API 访问",local:"作为-api-访问",headingTag:"h3"}}),Ae=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjBncmFkaW9fY2xpZW50",highlighted:"!pip install gradio_client",wrap:!1}}),Pe=new m({props:{code:"ZnJvbSUyMGdyYWRpb19jbGllbnQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBoYW5kbGVfZmlsZSUwQSUwQWNsaWVudCUyMCUzRCUyMENsaWVudCglMjJkbWFuaWxvZmYlMkZtZWV0aW5nLXRyYW5zY3JpcHQtdG9vbCUyMiklMEFyZXN1bHQlMjAlM0QlMjBjbGllbnQucHJlZGljdCglMEElMDklMDlhdWRpb19pbnB1dCUzRGhhbmRsZV9maWxlKCdodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZncmFkaW8tYXBwJTJGZ3JhZGlvJTJGcmF3JTJGbWFpbiUyRnRlc3QlMkZ0ZXN0X2ZpbGVzJTJGYXVkaW9fc2FtcGxlLndhdicpJTJDJTBBJTA5JTA5YXBpX25hbWUlM0QlMjIlMkZwcmVkaWN0JTIyJTBBKSUwQXByaW50KHJlc3VsdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> gradio_client <span class="hljs-keyword">import</span> Client, handle_file

<span class="hljs-meta">&gt;&gt;&gt; </span>client = Client(<span class="hljs-string">&quot;dmaniloff/meeting-transcript-tool&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = client.predict(
<span class="hljs-meta">&gt;&gt;&gt; </span>		audio_input=handle_file(<span class="hljs-string">&#x27;https://github.com/gradio-app/gradio/raw/main/test/test_files/audio_sample.wav&#x27;</span>),
<span class="hljs-meta">&gt;&gt;&gt; </span>		api_name=<span class="hljs-string">&quot;/predict&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)`,wrap:!1}}),lt=new T({props:{title:"通过公共 URL 分享",local:"通过公共-url-分享",headingTag:"h3"}}),st=new m({props:{code:"ZGVtby5sYXVuY2goc2hhcmUlM0RUcnVlKQ==",highlighted:'demo.launch(share=<span class="hljs-literal">True</span>)',wrap:!1}}),it=new T({props:{title:"标记功能",local:"标记功能",headingTag:"h3"}}),yt=new m({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),ut=new m({props:{code:"ZGVtb193aXRoX2N1c3RvbV9mbGFnZ2luZyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSUyMCUyMCUyMCUyMGFsbG93X2ZsYWdnaW5nJTNEJTIybWFudWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ2dpbmdfb3B0aW9ucyUzRCU1QiUyMkluY29ycmVjdCUyMiUyQyUyMCUyMkFtYmlndW91cyUyMiU1RCUyQyUwQSklMEFkZW1vX3dpdGhfY3VzdG9tX2ZsYWdnaW5nLmxhdW5jaCgp",highlighted:`demo_with_custom_flagging = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>], <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],          <span class="hljs-comment"># the output is a text box</span>
    allow_flagging=<span class="hljs-string">&quot;manual&quot;</span>,
    flagging_options=[<span class="hljs-string">&quot;Incorrect&quot;</span>, <span class="hljs-string">&quot;Ambiguous&quot;</span>],
)
demo_with_custom_flagging.launch()`,wrap:!1}}),Tt=new m({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),dt=new T({props:{title:"总结与下一步",local:"总结与下一步",headingTag:"h2"}}),ft=new T({props:{title:"下一步",local:"下一步",headingTag:"h3"}}),gt=new T({props:{title:"⏭️ 进一步阅读",local:"-进一步阅读",headingTag:"h2"}}),Ct=new Ba({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/enterprise_cookbook_gradio.md"}}),{c(){d=i("meta"),xt=s(),Wt=i("p"),Vt=s(),p(G.$$.fragment),Xt=s(),p(g.$$.fragment),Rt=s(),p(B.$$.fragment),kt=s(),C=i("p"),C.innerHTML=Pn,_t=s(),p(Z.$$.fragment),Yt=s(),v=i("p"),v.innerHTML=Dn,St=s(),W=i("p"),W.textContent=Kn,Qt=s(),$=i("ul"),$.innerHTML=On,Lt=s(),H=i("p"),H.innerHTML=es,Nt=s(),p(x.$$.fragment),zt=s(),V=i("p"),V.innerHTML=ts,Ft=s(),p(X.$$.fragment),qt=s(),p(R.$$.fragment),Et=s(),p(k.$$.fragment),At=s(),_=i("p"),_.textContent=ls,Pt=s(),Y=i("p"),Y.innerHTML=ns,Dt=s(),p(S.$$.fragment),Kt=s(),Q=i("p"),Q.textContent=ss,Ot=s(),p(L.$$.fragment),el=s(),N=i("pre"),N.textContent=as,tl=s(),z=i("p"),z.innerHTML=is,ll=s(),p(F.$$.fragment),nl=s(),q=i("p"),q.innerHTML=os,sl=s(),E=i("p"),E.innerHTML=Ms,al=s(),p(A.$$.fragment),il=s(),p(P.$$.fragment),ol=s(),D=i("p"),D.textContent=ps,Ml=s(),K=i("p"),K.textContent=ys,pl=s(),O=i("p"),O.textContent=cs,yl=s(),ee=i("ol"),ee.innerHTML=rs,cl=s(),p(te.$$.fragment),rl=s(),le=i("p"),le.textContent=Js,Jl=s(),ne=i("p"),ne.innerHTML=us,ul=s(),se=i("p"),se.innerHTML=ms,ml=s(),p(ae.$$.fragment),Tl=s(),ie=i("p"),ie.innerHTML=Ts,wl=s(),p(oe.$$.fragment),dl=s(),Me=i("p"),Me.innerHTML=ws,Ul=s(),pe=i("p"),pe.innerHTML=ds,hl=s(),U=i("blockquote"),U.innerHTML=Us,Il=s(),p(ye.$$.fragment),jl=s(),ce=i("p"),ce.textContent=hs,bl=s(),re=i("p"),re.innerHTML=Is,fl=s(),Je=i("p"),Je.innerHTML=js,Gl=s(),ue=i("p"),ue.innerHTML=bs,gl=s(),me=i("p"),me.innerHTML=fs,Bl=s(),p(Te.$$.fragment),Cl=s(),we=i("p"),we.innerHTML=Gs,Zl=s(),de=i("p"),de.textContent=gs,vl=s(),Ue=i("ul"),Ue.innerHTML=Bs,Wl=s(),p(he.$$.fragment),$l=s(),p(Ie.$$.fragment),Hl=s(),je=i("p"),je.innerHTML=Cs,xl=s(),p(be.$$.fragment),Vl=s(),fe=i("p"),fe.textContent=Zs,Xl=s(),Ge=i("p"),Ge.innerHTML=vs,Rl=s(),p(ge.$$.fragment),kl=s(),Be=i("p"),Be.textContent=Ws,_l=s(),Ce=i("ol"),Ce.innerHTML=$s,Yl=s(),Ze=i("p"),Ze.innerHTML=Hs,Sl=s(),p(ve.$$.fragment),Ql=s(),We=i("p"),We.textContent=xs,Ll=s(),p($e.$$.fragment),Nl=s(),He=i("p"),He.textContent=Vs,zl=s(),xe=i("p"),xe.textContent=Xs,Fl=s(),Ve=i("p"),Ve.innerHTML=Rs,ql=s(),h=i("img"),El=s(),Xe=i("p"),Xe.innerHTML=_s,Al=s(),Re=i("p"),Re.textContent=Ys,Pl=s(),I=i("ul"),ke=i("li"),Zt=i("p"),Zt.innerHTML=Ss,Fn=s(),p(_e.$$.fragment),qn=s(),Ye=i("li"),vt=i("p"),vt.innerHTML=Qs,En=s(),p(Se.$$.fragment),Dl=s(),p(Qe.$$.fragment),Kl=s(),Le=i("p"),Le.textContent=Ls,Ol=s(),Ne=i("ul"),Ne.innerHTML=Ns,en=s(),p(ze.$$.fragment),tn=s(),Fe=i("p"),Fe.innerHTML=zs,ln=s(),qe=i("p"),qe.innerHTML=Fs,nn=s(),j=i("img"),sn=s(),Ee=i("p"),Ee.textContent=Es,an=s(),p(Ae.$$.fragment),on=s(),p(Pe.$$.fragment),Mn=s(),De=i("pre"),De.textContent=As,pn=s(),Ke=i("p"),Ke.textContent=Ps,yn=s(),Oe=i("ul"),Oe.innerHTML=Ds,cn=s(),et=i("p"),et.innerHTML=Ks,rn=s(),tt=i("p"),tt.innerHTML=Os,Jn=s(),b=i("blockquote"),b.innerHTML=ea,un=s(),p(lt.$$.fragment),mn=s(),nt=i("p"),nt.innerHTML=ta,Tn=s(),p(st.$$.fragment),wn=s(),at=i("p"),at.innerHTML=la,dn=s(),p(it.$$.fragment),Un=s(),ot=i("p"),ot.innerHTML=na,hn=s(),Mt=i("p"),Mt.textContent=sa,In=s(),pt=i("p"),pt.innerHTML=aa,jn=s(),p(yt.$$.fragment),bn=s(),ct=i("pre"),ct.textContent=ia,fn=s(),rt=i("p"),rt.innerHTML=oa,Gn=s(),Jt=i("p"),Jt.innerHTML=Ma,gn=s(),p(ut.$$.fragment),Bn=s(),mt=i("p"),mt.innerHTML=pa,Cn=s(),p(Tt.$$.fragment),Zn=s(),wt=i("pre"),wt.textContent=ya,vn=s(),p(dt.$$.fragment),Wn=s(),Ut=i("p"),Ut.textContent=ca,$n=s(),ht=i("p"),ht.textContent=ra,Hn=s(),It=i("p"),It.innerHTML=Ja,xn=s(),jt=i("p"),jt.textContent=ua,Vn=s(),bt=i("p"),bt.textContent=ma,Xn=s(),p(ft.$$.fragment),Rn=s(),Gt=i("p"),Gt.innerHTML=Ta,kn=s(),p(gt.$$.fragment),_n=s(),Bt=i("ul"),Bt.innerHTML=wa,Yn=s(),p(Ct.$$.fragment),Sn=s(),$t=i("p"),this.h()},l(e){const t=fa("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),xt=a(e),Wt=o(e,"P",{}),Ht(Wt).forEach(l),Vt=a(e),y(G.$$.fragment,e),Xt=a(e),y(g.$$.fragment,e),Rt=a(e),y(B.$$.fragment,e),kt=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-42vwqb"&&(C.innerHTML=Pn),_t=a(e),y(Z.$$.fragment,e),Yt=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-iut4rq"&&(v.innerHTML=Dn),St=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-wwjoyp"&&(W.textContent=Kn),Qt=a(e),$=o(e,"UL",{"data-svelte-h":!0}),M($)!=="svelte-qv3x33"&&($.innerHTML=On),Lt=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-vnfp10"&&(H.innerHTML=es),Nt=a(e),y(x.$$.fragment,e),zt=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-15ztoit"&&(V.innerHTML=ts),Ft=a(e),y(X.$$.fragment,e),qt=a(e),y(R.$$.fragment,e),Et=a(e),y(k.$$.fragment,e),At=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-k5nikz"&&(_.textContent=ls),Pt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1olg54w"&&(Y.innerHTML=ns),Dt=a(e),y(S.$$.fragment,e),Kt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1bkc819"&&(Q.textContent=ss),Ot=a(e),y(L.$$.fragment,e),el=a(e),N=o(e,"PRE",{"data-svelte-h":!0}),M(N)!=="svelte-1d8bxpj"&&(N.textContent=as),tl=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-qwv6cb"&&(z.innerHTML=is),ll=a(e),y(F.$$.fragment,e),nl=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1c6hyey"&&(q.innerHTML=os),sl=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1j40g2"&&(E.innerHTML=Ms),al=a(e),y(A.$$.fragment,e),il=a(e),y(P.$$.fragment,e),ol=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1mivl1s"&&(D.textContent=ps),Ml=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-p634a7"&&(K.textContent=ys),pl=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-zfscxy"&&(O.textContent=cs),yl=a(e),ee=o(e,"OL",{"data-svelte-h":!0}),M(ee)!=="svelte-1niuusy"&&(ee.innerHTML=rs),cl=a(e),y(te.$$.fragment,e),rl=a(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-sspr1l"&&(le.textContent=Js),Jl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-4xlung"&&(ne.innerHTML=us),ul=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1qrdog0"&&(se.innerHTML=ms),ml=a(e),y(ae.$$.fragment,e),Tl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-g0uujd"&&(ie.innerHTML=Ts),wl=a(e),y(oe.$$.fragment,e),dl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-hkjs55"&&(Me.innerHTML=ws),Ul=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-kij1hn"&&(pe.innerHTML=ds),hl=a(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(U)!=="svelte-pn70d"&&(U.innerHTML=Us),Il=a(e),y(ye.$$.fragment,e),jl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1iig2p"&&(ce.textContent=hs),bl=a(e),re=o(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-55qe2c"&&(re.innerHTML=Is),fl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1ybrymz"&&(Je.innerHTML=js),Gl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1gz85wf"&&(ue.innerHTML=bs),gl=a(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1glkbwi"&&(me.innerHTML=fs),Bl=a(e),y(Te.$$.fragment,e),Cl=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-eoj3fv"&&(we.innerHTML=Gs),Zl=a(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-1pz4rgw"&&(de.textContent=gs),vl=a(e),Ue=o(e,"UL",{"data-svelte-h":!0}),M(Ue)!=="svelte-7voccs"&&(Ue.innerHTML=Bs),Wl=a(e),y(he.$$.fragment,e),$l=a(e),y(Ie.$$.fragment,e),Hl=a(e),je=o(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-15oox72"&&(je.innerHTML=Cs),xl=a(e),y(be.$$.fragment,e),Vl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-jjao7a"&&(fe.textContent=Zs),Xl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1ydv8aj"&&(Ge.innerHTML=vs),Rl=a(e),y(ge.$$.fragment,e),kl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-w4x6up"&&(Be.textContent=Ws),_l=a(e),Ce=o(e,"OL",{"data-svelte-h":!0}),M(Ce)!=="svelte-1633e6r"&&(Ce.innerHTML=$s),Yl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-gfpnv0"&&(Ze.innerHTML=Hs),Sl=a(e),y(ve.$$.fragment,e),Ql=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-15j0vkx"&&(We.textContent=xs),Ll=a(e),y($e.$$.fragment,e),Nl=a(e),He=o(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-si7k3i"&&(He.textContent=Vs),zl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-xy4y65"&&(xe.textContent=Xs),Fl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-2qcowo"&&(Ve.innerHTML=Rs),ql=a(e),h=o(e,"IMG",{src:!0,width:!0,alt:!0}),El=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-9hnolg"&&(Xe.innerHTML=_s),Al=a(e),Re=o(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-n9et4y"&&(Re.textContent=Ys),Pl=a(e),I=o(e,"UL",{});var Ln=Ht(I);ke=o(Ln,"LI",{});var Nn=Ht(ke);Zt=o(Nn,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1damafo"&&(Zt.innerHTML=Ss),Fn=a(Nn),y(_e.$$.fragment,Nn),Nn.forEach(l),qn=a(Ln),Ye=o(Ln,"LI",{});var zn=Ht(Ye);vt=o(zn,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-yys94r"&&(vt.innerHTML=Qs),En=a(zn),y(Se.$$.fragment,zn),zn.forEach(l),Ln.forEach(l),Dl=a(e),y(Qe.$$.fragment,e),Kl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-12oxiv0"&&(Le.textContent=Ls),Ol=a(e),Ne=o(e,"UL",{"data-svelte-h":!0}),M(Ne)!=="svelte-6uk95a"&&(Ne.innerHTML=Ns),en=a(e),y(ze.$$.fragment,e),tn=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-1hal2st"&&(Fe.innerHTML=zs),ln=a(e),qe=o(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-146j8ks"&&(qe.innerHTML=Fs),nn=a(e),j=o(e,"IMG",{src:!0,width:!0,alt:!0}),sn=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1auwlpe"&&(Ee.textContent=Es),an=a(e),y(Ae.$$.fragment,e),on=a(e),y(Pe.$$.fragment,e),Mn=a(e),De=o(e,"PRE",{"data-svelte-h":!0}),M(De)!=="svelte-1f419gx"&&(De.textContent=As),pn=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-1a8wkwm"&&(Ke.textContent=Ps),yn=a(e),Oe=o(e,"UL",{"data-svelte-h":!0}),M(Oe)!=="svelte-1lgtums"&&(Oe.innerHTML=Ds),cn=a(e),et=o(e,"P",{"data-svelte-h":!0}),M(et)!=="svelte-gs0pp8"&&(et.innerHTML=Ks),rn=a(e),tt=o(e,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1uociye"&&(tt.innerHTML=Os),Jn=a(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(b)!=="svelte-1ert7ok"&&(b.innerHTML=ea),un=a(e),y(lt.$$.fragment,e),mn=a(e),nt=o(e,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-h6ij0p"&&(nt.innerHTML=ta),Tn=a(e),y(st.$$.fragment,e),wn=a(e),at=o(e,"P",{"data-svelte-h":!0}),M(at)!=="svelte-1q0mzas"&&(at.innerHTML=la),dn=a(e),y(it.$$.fragment,e),Un=a(e),ot=o(e,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-1ax23a6"&&(ot.innerHTML=na),hn=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-1wk1wqn"&&(Mt.textContent=sa),In=a(e),pt=o(e,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-1deoilo"&&(pt.innerHTML=aa),jn=a(e),y(yt.$$.fragment,e),bn=a(e),ct=o(e,"PRE",{"data-svelte-h":!0}),M(ct)!=="svelte-t58374"&&(ct.textContent=ia),fn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-14ma68"&&(rt.innerHTML=oa),Gn=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-vld201"&&(Jt.innerHTML=Ma),gn=a(e),y(ut.$$.fragment,e),Bn=a(e),mt=o(e,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1kjmans"&&(mt.innerHTML=pa),Cn=a(e),y(Tt.$$.fragment,e),Zn=a(e),wt=o(e,"PRE",{"data-svelte-h":!0}),M(wt)!=="svelte-p76wiz"&&(wt.textContent=ya),vn=a(e),y(dt.$$.fragment,e),Wn=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-1dxammp"&&(Ut.textContent=ca),$n=a(e),ht=o(e,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-lplahd"&&(ht.textContent=ra),Hn=a(e),It=o(e,"P",{"data-svelte-h":!0}),M(It)!=="svelte-19qkbkl"&&(It.innerHTML=Ja),xn=a(e),jt=o(e,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-chz8sq"&&(jt.textContent=ua),Vn=a(e),bt=o(e,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-nz77e1"&&(bt.textContent=ma),Xn=a(e),y(ft.$$.fragment,e),Rn=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-12sj9nf"&&(Gt.innerHTML=Ta),kn=a(e),y(gt.$$.fragment,e),_n=a(e),Bt=o(e,"UL",{"data-svelte-h":!0}),M(Bt)!=="svelte-qgqz09"&&(Bt.innerHTML=wa),Yn=a(e),y(Ct.$$.fragment,e),Sn=a(e),$t=o(e,"P",{}),Ht($t).forEach(l),this.h()},h(){w(d,"name","hf:doc:metadata"),w(d,"content",Za),w(U,"class","tip"),da(h.src,ks="https://github.com/dmaniloff/public-screenshots/blob/main/create-new-space.png?raw=true")||w(h,"src",ks),w(h,"width","350"),w(h,"alt","image description"),da(j.src,qs="https://github.com/dmaniloff/public-screenshots/blob/main/gradio-as-api.png?raw=true")||w(j,"src",qs),w(j,"width","750"),w(j,"alt","image description"),w(b,"class","tip")},m(e,t){f(document.head,d),n(e,xt,t),n(e,Wt,t),n(e,Vt,t),c(G,e,t),n(e,Xt,t),c(g,e,t),n(e,Rt,t),c(B,e,t),n(e,kt,t),n(e,C,t),n(e,_t,t),c(Z,e,t),n(e,Yt,t),n(e,v,t),n(e,St,t),n(e,W,t),n(e,Qt,t),n(e,$,t),n(e,Lt,t),n(e,H,t),n(e,Nt,t),c(x,e,t),n(e,zt,t),n(e,V,t),n(e,Ft,t),c(X,e,t),n(e,qt,t),c(R,e,t),n(e,Et,t),c(k,e,t),n(e,At,t),n(e,_,t),n(e,Pt,t),n(e,Y,t),n(e,Dt,t),c(S,e,t),n(e,Kt,t),n(e,Q,t),n(e,Ot,t),c(L,e,t),n(e,el,t),n(e,N,t),n(e,tl,t),n(e,z,t),n(e,ll,t),c(F,e,t),n(e,nl,t),n(e,q,t),n(e,sl,t),n(e,E,t),n(e,al,t),c(A,e,t),n(e,il,t),c(P,e,t),n(e,ol,t),n(e,D,t),n(e,Ml,t),n(e,K,t),n(e,pl,t),n(e,O,t),n(e,yl,t),n(e,ee,t),n(e,cl,t),c(te,e,t),n(e,rl,t),n(e,le,t),n(e,Jl,t),n(e,ne,t),n(e,ul,t),n(e,se,t),n(e,ml,t),c(ae,e,t),n(e,Tl,t),n(e,ie,t),n(e,wl,t),c(oe,e,t),n(e,dl,t),n(e,Me,t),n(e,Ul,t),n(e,pe,t),n(e,hl,t),n(e,U,t),n(e,Il,t),c(ye,e,t),n(e,jl,t),n(e,ce,t),n(e,bl,t),n(e,re,t),n(e,fl,t),n(e,Je,t),n(e,Gl,t),n(e,ue,t),n(e,gl,t),n(e,me,t),n(e,Bl,t),c(Te,e,t),n(e,Cl,t),n(e,we,t),n(e,Zl,t),n(e,de,t),n(e,vl,t),n(e,Ue,t),n(e,Wl,t),c(he,e,t),n(e,$l,t),c(Ie,e,t),n(e,Hl,t),n(e,je,t),n(e,xl,t),c(be,e,t),n(e,Vl,t),n(e,fe,t),n(e,Xl,t),n(e,Ge,t),n(e,Rl,t),c(ge,e,t),n(e,kl,t),n(e,Be,t),n(e,_l,t),n(e,Ce,t),n(e,Yl,t),n(e,Ze,t),n(e,Sl,t),c(ve,e,t),n(e,Ql,t),n(e,We,t),n(e,Ll,t),c($e,e,t),n(e,Nl,t),n(e,He,t),n(e,zl,t),n(e,xe,t),n(e,Fl,t),n(e,Ve,t),n(e,ql,t),n(e,h,t),n(e,El,t),n(e,Xe,t),n(e,Al,t),n(e,Re,t),n(e,Pl,t),n(e,I,t),f(I,ke),f(ke,Zt),f(ke,Fn),c(_e,ke,null),f(I,qn),f(I,Ye),f(Ye,vt),f(Ye,En),c(Se,Ye,null),n(e,Dl,t),c(Qe,e,t),n(e,Kl,t),n(e,Le,t),n(e,Ol,t),n(e,Ne,t),n(e,en,t),c(ze,e,t),n(e,tn,t),n(e,Fe,t),n(e,ln,t),n(e,qe,t),n(e,nn,t),n(e,j,t),n(e,sn,t),n(e,Ee,t),n(e,an,t),c(Ae,e,t),n(e,on,t),c(Pe,e,t),n(e,Mn,t),n(e,De,t),n(e,pn,t),n(e,Ke,t),n(e,yn,t),n(e,Oe,t),n(e,cn,t),n(e,et,t),n(e,rn,t),n(e,tt,t),n(e,Jn,t),n(e,b,t),n(e,un,t),c(lt,e,t),n(e,mn,t),n(e,nt,t),n(e,Tn,t),c(st,e,t),n(e,wn,t),n(e,at,t),n(e,dn,t),c(it,e,t),n(e,Un,t),n(e,ot,t),n(e,hn,t),n(e,Mt,t),n(e,In,t),n(e,pt,t),n(e,jn,t),c(yt,e,t),n(e,bn,t),n(e,ct,t),n(e,fn,t),n(e,rt,t),n(e,Gn,t),n(e,Jt,t),n(e,gn,t),c(ut,e,t),n(e,Bn,t),n(e,mt,t),n(e,Cn,t),c(Tt,e,t),n(e,Zn,t),n(e,wt,t),n(e,vn,t),c(dt,e,t),n(e,Wn,t),n(e,Ut,t),n(e,$n,t),n(e,ht,t),n(e,Hn,t),n(e,It,t),n(e,xn,t),n(e,jt,t),n(e,Vn,t),n(e,bt,t),n(e,Xn,t),c(ft,e,t),n(e,Rn,t),n(e,Gt,t),n(e,kn,t),c(gt,e,t),n(e,_n,t),n(e,Bt,t),n(e,Yn,t),c(Ct,e,t),n(e,Sn,t),n(e,$t,t),Qn=!0},p:ha,i(e){Qn||(r(G.$$.fragment,e),r(g.$$.fragment,e),r(B.$$.fragment,e),r(Z.$$.fragment,e),r(x.$$.fragment,e),r(X.$$.fragment,e),r(R.$$.fragment,e),r(k.$$.fragment,e),r(S.$$.fragment,e),r(L.$$.fragment,e),r(F.$$.fragment,e),r(A.$$.fragment,e),r(P.$$.fragment,e),r(te.$$.fragment,e),r(ae.$$.fragment,e),r(oe.$$.fragment,e),r(ye.$$.fragment,e),r(Te.$$.fragment,e),r(he.$$.fragment,e),r(Ie.$$.fragment,e),r(be.$$.fragment,e),r(ge.$$.fragment,e),r(ve.$$.fragment,e),r($e.$$.fragment,e),r(_e.$$.fragment,e),r(Se.$$.fragment,e),r(Qe.$$.fragment,e),r(ze.$$.fragment,e),r(Ae.$$.fragment,e),r(Pe.$$.fragment,e),r(lt.$$.fragment,e),r(st.$$.fragment,e),r(it.$$.fragment,e),r(yt.$$.fragment,e),r(ut.$$.fragment,e),r(Tt.$$.fragment,e),r(dt.$$.fragment,e),r(ft.$$.fragment,e),r(gt.$$.fragment,e),r(Ct.$$.fragment,e),Qn=!0)},o(e){J(G.$$.fragment,e),J(g.$$.fragment,e),J(B.$$.fragment,e),J(Z.$$.fragment,e),J(x.$$.fragment,e),J(X.$$.fragment,e),J(R.$$.fragment,e),J(k.$$.fragment,e),J(S.$$.fragment,e),J(L.$$.fragment,e),J(F.$$.fragment,e),J(A.$$.fragment,e),J(P.$$.fragment,e),J(te.$$.fragment,e),J(ae.$$.fragment,e),J(oe.$$.fragment,e),J(ye.$$.fragment,e),J(Te.$$.fragment,e),J(he.$$.fragment,e),J(Ie.$$.fragment,e),J(be.$$.fragment,e),J(ge.$$.fragment,e),J(ve.$$.fragment,e),J($e.$$.fragment,e),J(_e.$$.fragment,e),J(Se.$$.fragment,e),J(Qe.$$.fragment,e),J(ze.$$.fragment,e),J(Ae.$$.fragment,e),J(Pe.$$.fragment,e),J(lt.$$.fragment,e),J(st.$$.fragment,e),J(it.$$.fragment,e),J(yt.$$.fragment,e),J(ut.$$.fragment,e),J(Tt.$$.fragment,e),J(dt.$$.fragment,e),J(ft.$$.fragment,e),J(gt.$$.fragment,e),J(Ct.$$.fragment,e),Qn=!1},d(e){e&&(l(xt),l(Wt),l(Vt),l(Xt),l(Rt),l(kt),l(C),l(_t),l(Yt),l(v),l(St),l(W),l(Qt),l($),l(Lt),l(H),l(Nt),l(zt),l(V),l(Ft),l(qt),l(Et),l(At),l(_),l(Pt),l(Y),l(Dt),l(Kt),l(Q),l(Ot),l(el),l(N),l(tl),l(z),l(ll),l(nl),l(q),l(sl),l(E),l(al),l(il),l(ol),l(D),l(Ml),l(K),l(pl),l(O),l(yl),l(ee),l(cl),l(rl),l(le),l(Jl),l(ne),l(ul),l(se),l(ml),l(Tl),l(ie),l(wl),l(dl),l(Me),l(Ul),l(pe),l(hl),l(U),l(Il),l(jl),l(ce),l(bl),l(re),l(fl),l(Je),l(Gl),l(ue),l(gl),l(me),l(Bl),l(Cl),l(we),l(Zl),l(de),l(vl),l(Ue),l(Wl),l($l),l(Hl),l(je),l(xl),l(Vl),l(fe),l(Xl),l(Ge),l(Rl),l(kl),l(Be),l(_l),l(Ce),l(Yl),l(Ze),l(Sl),l(Ql),l(We),l(Ll),l(Nl),l(He),l(zl),l(xe),l(Fl),l(Ve),l(ql),l(h),l(El),l(Xe),l(Al),l(Re),l(Pl),l(I),l(Dl),l(Kl),l(Le),l(Ol),l(Ne),l(en),l(tn),l(Fe),l(ln),l(qe),l(nn),l(j),l(sn),l(Ee),l(an),l(on),l(Mn),l(De),l(pn),l(Ke),l(yn),l(Oe),l(cn),l(et),l(rn),l(tt),l(Jn),l(b),l(un),l(mn),l(nt),l(Tn),l(wn),l(at),l(dn),l(Un),l(ot),l(hn),l(Mt),l(In),l(pt),l(jn),l(bn),l(ct),l(fn),l(rt),l(Gn),l(Jt),l(gn),l(Bn),l(mt),l(Cn),l(Zn),l(wt),l(vn),l(Wn),l(Ut),l($n),l(ht),l(Hn),l(It),l(xn),l(jt),l(Vn),l(bt),l(Xn),l(Rn),l(Gt),l(kn),l(_n),l(Bt),l(Yn),l(Sn),l($t)),l(d),u(G,e),u(g,e),u(B,e),u(Z,e),u(x,e),u(X,e),u(R,e),u(k,e),u(S,e),u(L,e),u(F,e),u(A,e),u(P,e),u(te,e),u(ae,e),u(oe,e),u(ye,e),u(Te,e),u(he,e),u(Ie,e),u(be,e),u(ge,e),u(ve,e),u($e,e),u(_e),u(Se),u(Qe,e),u(ze,e),u(Ae,e),u(Pe,e),u(lt,e),u(st,e),u(it,e),u(yt,e),u(ut,e),u(Tt,e),u(dt,e),u(ft,e),u(gt,e),u(Ct,e)}}}const Za='{"title":"使用 Spaces 和 Gradio 创建演示","local":"使用-spaces-和-gradio-创建演示","sections":[{"title":"介绍","local":"介绍","sections":[],"depth":2},{"title":"设置","local":"设置","sections":[],"depth":2},{"title":"你的第一个演示：Gradio 基础","local":"你的第一个演示gradio-基础","sections":[],"depth":2},{"title":"让我们做得更有趣：会议转录工具","local":"让我们做得更有趣会议转录工具","sections":[{"title":"音频转文本","local":"音频转文本","sections":[],"depth":3},{"title":"组织和总结文本","local":"组织和总结文本","sections":[],"depth":3},{"title":"整合所有部分","local":"整合所有部分","sections":[],"depth":3}],"depth":2},{"title":"将你的演示迁移到 🤗 Spaces","local":"将你的演示迁移到--spaces","sections":[],"depth":2},{"title":"Gradio 自带“电池” 🔋","local":"gradio-自带电池-","sections":[{"title":"作为 API 访问","local":"作为-api-访问","sections":[],"depth":3},{"title":"通过公共 URL 分享","local":"通过公共-url-分享","sections":[],"depth":3},{"title":"标记功能","local":"标记功能","sections":[],"depth":3}],"depth":2},{"title":"总结与下一步","local":"总结与下一步","sections":[{"title":"下一步","local":"下一步","sections":[],"depth":3}],"depth":2},{"title":"⏭️ 进一步阅读","local":"-进一步阅读","sections":[],"depth":2}],"depth":1}';function va(An){return Ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends ja{constructor(d){super(),ba(this,d,va,Ca,Ua,{})}}export{Xa as component};
