import{s as ul,n as hl,o as fl}from"../chunks/scheduler.1f027d5a.js";import{S as Ml,i as bl,e as d,s as n,c as i,h as gl,a as u,d as l,b as a,f as cl,g as p,j as h,k as dl,l as wl,m as s,n as o,t as m,o as r,p as c}from"../chunks/index.6117a65d.js";import{C as yl}from"../chunks/CopyLLMTxtMenu.0ff8411a.js";import{D as Jl,C as f}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as M,E as $l}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function jl(Bt){let b,Ce,Ue,Ie,g,ve,w,Ze,y,ke,J,Nt='<em>作者: <a href="https://github.com/zc277584121" rel="nofollow">张晨</a></em>',We,$,At='<a href="https://milvus.io/" rel="nofollow">Milvus</a> 是一个广受欢迎的开源向量数据库，为人工智能应用提供高性能和可扩展的向量相似性搜索。在本教程中，我们将向您展示如何使用 Hugging Face 和 Milvus 构建 RAG（检索增强生成）流程。',_e,j,Et="RAG 系统将检索系统与 LLM 相结合。该系统首先使用向量数据库 Milvus 从语料库中检索相关文档，然后使用 Hugging Face 的 LLM 根据检索到的文档生成回答。",xe,T,Re,U,Ve,G,Be,C,Xt="<p>如果您使用 Google Colab，要启用刚刚安装的依赖项，您可能需要 <strong>重新启动运行时</strong>（单击屏幕顶部的“运行时”菜单，然后从下拉菜单中选择“重新启动会话”） 。</p>",Ne,I,Ht='另外，我们建议您配置您的 <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">Hugging Face User Access Token</a>，并将其设置在您的环境变量中，因为我们将使用 Hugging Face Hub 的 LLM 。如果不设置 token 环境变量，您可能会受到较低的请求速率限制。',Ae,v,Ee,Z,Xe,k,zt='我们使用 <a href="https://artificialintelligenceact.eu/wp-content/uploads/2021/08/The-AI-Act.pdf" rel="nofollow">AI Act PDF</a> 作为我们 RAG 中的私有知识。这是一个针对人工智能的监管框架，具有不同风险级别，对应或多或少的监管。',He,W,ze,_,Qt='我们使用 LangChain 的 <a href="https://python.langchain.com/v0.1/docs/modules/data_connection/document_loaders/pdf/" rel="nofollow"><code>PyPDFLoader</code></a> 从 PDF 中提取文本，然后将文本拆分为更小的块。默认情况下，我们将块大小设置为 1000，重叠设置为 200，这意味着每个块将有近 1000 个字符，两个块之间的重叠将是 200 个字符。',Qe,x,qe,R,qt=`108
`,Fe,V,Ye,B,Se,N,Le,A,Ft='定义一个函数来生成文本 embedding。我们使用 <a href="https://huggingface.co/BAAI/bge-small-en-v1.5" rel="nofollow">BGE embedding模型</a> 作为示例，但您也可以将其更改为任何其他 embedding 模型，例如在 <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB排行榜</a> 上选择。',Pe,E,De,X,Yt="生成测试 embedding 并打印其大小和前几个元素。",Ke,H,Oe,z,St=`384
[-0.07660683244466782, 0.025316666811704636, 0.012505513615906239, 0.004595153499394655, 0.025780051946640015, 0.03816710412502289, 0.08050819486379623, 0.003035430097952485, 0.02439221926033497, 0.0048803347162902355]
`,et,Q,tt,q,lt,F,st,Y,Lt='<p>对于 <code>MilvusClient</code> 的参数：</p> <ul><li>将 <code>uri</code> 设置为本地文件，例如 <code>./hf_milvus_demo.db</code> ，是最方便的方法，因为它会自动使用 <a href="https://milvus.io/docs/milvus_lite.md" rel="nofollow">Milvus Lite</a> 将所有数据存储在此文件中。</li> <li>如果您有大量数据，例如超过一百万个向量，您可以在 <a href="https://milvus.io/docs/quickstart.md" rel="nofollow">Docker 或 Kubernetes</a> 上设置性能更高的 Milvus 服务器。在此设置中，请使用服务器 uri，例如 <code>http://localhost:19530</code> 作为您的 <code>uri</code> 。</li> <li>如果您想使用 Milvus 的全托管云服务 <a href="https://zilliz.com/cloud" rel="nofollow">Zilliz Cloud</a> ，请调整 <code>uri</code> 和 <code>token</code>，分别对应 Zilliz Cloud 中 <a href="https://docs.zilliz.com/docs/on-zilliz-cloud-console#cluster-details" rel="nofollow">Public Endpoint 和 Api key</a> 。</li></ul>',nt,S,Pt="检查 collection 是否已存在，如果存在则将其删除。",at,L,it,P,Dt="使用指定参数创建一个新 collection。",pt,D,Kt="如果我们不指定任何字段信息，Milvus 会自动创建一个默认的 <code>id</code> 字段作为主键，并创建一个 <code>vector</code> 字段来存储向量数据。保留的 JSON 字段用于存储未定义 schema 的字段及其值。",ot,K,mt,O,rt,ee,Ot="迭代文本行，创建 embedding，然后将数据插入到 Milvus 中。",ct,te,el="这是一个新字段 <code>text</code>，它是 collection schema 中的未定义字段。它将自动添加到保留的 JSON 动态字段中，从更高的层次看来，它可被视为普通字段。",dt,le,ut,se,ht,ne,ft,ae,tl="让我们具体指定一个有关该语料的问题。",Mt,ie,bt,pe,ll="在 collection 中搜索问题并检索语义前 3 个匹配项。",gt,oe,wt,me,sl="我们来看看查询的搜索结果",yt,re,Jt,ce,nl=`[
    [
        "EN 6  EN 2. LEGAL  BASIS,  SUBSIDIARITY  AND  PROPORTIONALITY  \\n2.1. Legal  basis  \\nThe legal basis for the proposal is in the first place Article 114 of the Treaty on the \\nFunctioning of the European Union (TFEU), which provides for the adoption of measures to \\nensure the establishment and f unctioning of the internal market.  \\nThis proposal constitutes a core part of the EU digital single market strategy. The primary \\nobjective of this proposal is to ensure the proper functioning of the internal market by setting \\nharmonised rules in particular on the development, placing on the Union market and the use \\nof products and services making use of AI technologies or provided as stand -alone AI \\nsystems. Some Member States are already considering national rules to ensure that AI is safe \\nand is developed a nd used in compliance with fundamental rights obligations. This will likely \\nlead to two main problems: i) a fragmentation of the internal market on essential elements",
        0.7412998080253601
    ],
    [
        "applications and prevent market fragmentation.  \\nTo achieve those objectives, this proposal presents a balanced and proportionate horizontal \\nregulatory approach to AI that is limited to the minimum necessary requirements to address \\nthe risks and problems linked to AI, withou t unduly constraining or hindering technological \\ndevelopment or otherwise disproportionately increasing the cost of placing AI solutions on \\nthe market.  The proposal sets a robust and flexible legal framework. On the one hand, it is \\ncomprehensive and future -proof in its fundamental regulatory choices, including the \\nprinciple -based requirements that AI systems should comply with. On the other hand, it puts \\nin place a proportionate regulatory system centred on a well -defined risk -based regulatory \\napproach that  does not create unnecessary restrictions to trade, whereby legal intervention is \\ntailored to those concrete situations where there is a justified cause for concern or where such",
        0.696428656578064
    ],
    [
        "approach that  does not create unnecessary restrictions to trade, whereby legal intervention is \\ntailored to those concrete situations where there is a justified cause for concern or where such \\nconcern can reasonably be anticipated in the near future. At the same time, t he legal \\nframework includes flexible mechanisms that enable it to be dynamically adapted as the \\ntechnology evolves and new concerning situations emerge.  \\nThe proposal sets harmonised rules for the development, placement on the market and use of \\nAI systems i n the Union following a proportionate risk -based approach. It proposes a single \\nfuture -proof definition of AI. Certain particularly harmful AI practices are prohibited as \\ncontravening Union values, while specific restrictions and safeguards are proposed in  relation \\nto certain uses of remote biometric identification systems for the purpose of law enforcement. \\nThe proposal lays down a solid risk methodology to define \\u201chigh -risk\\u201d AI systems that pose",
        0.6891457438468933
    ]
]
`,$t,de,jt,ue,al="在合并到 LLM 提示词之前，我们首先将检索到的文档列表展平为纯字符串。",Tt,he,Ut,fe,il="定义语言模型的提示词。该提示与从 Milvus 检索到的文档组合在一起。",Gt,Me,Ct,be,pl='我们使用部署在 Hugging Face 推理服务上的 <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B-Instruct-v0.1</a> 根据提示词生成响应。',It,ge,vt,we,ol="我们设置提示词格式并生成最后的回答。",Zt,ye,kt,Je,Wt,$e,ml=`The legal basis for the proposal is Article 114 of the Treaty on the Functioning of the European Union (TFEU), which provides for the adoption of measures to ensure the establishment and functioning of the internal market. The proposal aims to establish harmonized rules for the development, placing on the market, and use of AI systems in the Union following a proportionate risk-based approach.
`,_t,je,rl="恭喜！您已经使用 Hugging Face 和 Milvus 构建了 RAG 流程。",xt,Te,Rt,Ge,Vt;return g=new Jl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_hf_and_milvus.ipynb"}]}}),w=new yl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new M({props:{title:"使用 Hugging Face 和 Milvus 构建 RAG 系统",local:"使用-hugging-face-和-milvus-构建-rag-系统",headingTag:"h1"}}),T=new M({props:{title:"准备",local:"准备",headingTag:"h2"}}),U=new M({props:{title:"依赖关系和环境",local:"依赖关系和环境",headingTag:"h3"}}),G=new f({props:{code:"ISUyMHBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBweW1pbHZ1cyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGh1Z2dpbmdmYWNlLWh1YiUyMGxhbmdjaGFpbl9jb21tdW5pdHklMjBsYW5nY2hhaW4tdGV4dC1zcGxpdHRlcnMlMjBweXBkZiUyMHRxZG0=",highlighted:"! pip install --upgrade pymilvus sentence-transformers huggingface-hub langchain_community langchain-text-splitters pypdf tqdm",wrap:!1}}),v=new f({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjAlMjJoZl8uLi4lMjI=",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),Z=new M({props:{title:"准备数据",local:"准备数据",headingTag:"h3"}}),W=new f({props:{code:"JTI1JTI1YmFzaCUwQSUwQWlmJTIwJTVCJTIwISUyMC1mJTIwJTIyVGhlLUFJLUFjdC5wZGYlMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwd2dldCUyMC1xJTIwaHR0cHMlM0ElMkYlMkZhcnRpZmljaWFsaW50ZWxsaWdlbmNlYWN0LmV1JTJGd3AtY29udGVudCUyRnVwbG9hZHMlMkYyMDIxJTJGMDglMkZUaGUtQUktQWN0LnBkZiUwQWZp",highlighted:`%%bash

<span class="hljs-keyword">if</span> [ ! -f <span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span> ]; then
    wget -q https://artificialintelligenceact.eu/wp-content/uploads/<span class="hljs-number">2021</span>/08/The-AI-Act.pdf
fi`,wrap:!1}}),x=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZG9jdW1lbnRfbG9hZGVycyUyMGltcG9ydCUyMFB5UERGTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwUHlQREZMb2FkZXIoJTIyVGhlLUFJLUFjdC5wZGYlMjIpJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCklMEFwcmludChsZW4oZG9jcykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> PyPDFLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>loader = PyPDFLoader(<span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs = loader.load()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(docs))`,wrap:!1}}),V=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl90ZXh0X3NwbGl0dGVycyUyMGltcG9ydCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlciUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDEwMDAlMkMlMjBjaHVua19vdmVybGFwJTNEMjAwKSUwQWNodW5rcyUyMCUzRCUyMHRleHRfc3BsaXR0ZXIuc3BsaXRfZG9jdW1lbnRzKGRvY3Mp",highlighted:`<span class="hljs-keyword">from</span> langchain_text_splitters <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">1000</span>, chunk_overlap=<span class="hljs-number">200</span>)
chunks = text_splitter.split_documents(docs)`,wrap:!1}}),B=new f({props:{code:"dGV4dF9saW5lcyUyMCUzRCUyMCU1QmNodW5rLnBhZ2VfY29udGVudCUyMGZvciUyMGNodW5rJTIwaW4lMjBjaHVua3MlNUQ=",highlighted:'text_lines = [chunk.page_content <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> chunks]',wrap:!1}}),N=new M({props:{title:"准备 embedding 模型",local:"准备-embedding-模型",headingTag:"h3"}}),E=new f({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEElMEFkZWYlMjBlbWJfdGV4dCh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZ19tb2RlbC5lbmNvZGUoJTVCdGV4dCU1RCUyQyUyMG5vcm1hbGl6ZV9lbWJlZGRpbmdzJTNEVHJ1ZSkudG9saXN0KCklNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

embedding_model = SentenceTransformer(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">emb_text</span>(<span class="hljs-params">text</span>):
    <span class="hljs-keyword">return</span> embedding_model.encode([text], normalize_embeddings=<span class="hljs-literal">True</span>).tolist()[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new f({props:{code:"dGVzdF9lbWJlZGRpbmclMjAlM0QlMjBlbWJfdGV4dCglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiklMEFlbWJlZGRpbmdfZGltJTIwJTNEJTIwbGVuKHRlc3RfZW1iZWRkaW5nKSUwQXByaW50KGVtYmVkZGluZ19kaW0pJTBBcHJpbnQodGVzdF9lbWJlZGRpbmclNUIlM0ExMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>test_embedding = emb_text(<span class="hljs-string">&quot;This is a test&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_dim = <span class="hljs-built_in">len</span>(test_embedding)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(embedding_dim)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(test_embedding[:<span class="hljs-number">10</span>])`,wrap:!1}}),Q=new M({props:{title:"将数据加载到 Milvus 中",local:"将数据加载到-milvus-中",headingTag:"h2"}}),q=new M({props:{title:"创建 collection",local:"创建-collection",headingTag:"h3"}}),F=new f({props:{code:"ZnJvbSUyMHB5bWlsdnVzJTIwaW1wb3J0JTIwTWlsdnVzQ2xpZW50JTBBJTBBbWlsdnVzX2NsaWVudCUyMCUzRCUyME1pbHZ1c0NsaWVudCh1cmklM0QlMjIuJTJGaGZfbWlsdnVzX2RlbW8uZGIlMjIpJTBBJTBBY29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIycmFnX2NvbGxlY3Rpb24lMjI=",highlighted:`<span class="hljs-keyword">from</span> pymilvus <span class="hljs-keyword">import</span> MilvusClient

milvus_client = MilvusClient(uri=<span class="hljs-string">&quot;./hf_milvus_demo.db&quot;</span>)

collection_name = <span class="hljs-string">&quot;rag_collection&quot;</span>`,wrap:!1}}),L=new f({props:{code:"aWYlMjBtaWx2dXNfY2xpZW50Lmhhc19jb2xsZWN0aW9uKGNvbGxlY3Rpb25fbmFtZSklM0ElMEElMjAlMjAlMjAlMjBtaWx2dXNfY2xpZW50LmRyb3BfY29sbGVjdGlvbihjb2xsZWN0aW9uX25hbWUp",highlighted:`<span class="hljs-keyword">if</span> milvus_client.has_collection(collection_name):
    milvus_client.drop_collection(collection_name)`,wrap:!1}}),K=new f({props:{code:"bWlsdnVzX2NsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0Rjb2xsZWN0aW9uX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkaW1lbnNpb24lM0RlbWJlZGRpbmdfZGltJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX3R5cGUlM0QlMjJJUCUyMiUyQyUyMCUyMCUyMyUyMElubmVyJTIwcHJvZHVjdCUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwY29uc2lzdGVuY3lfbGV2ZWwlM0QlMjJTdHJvbmclMjIlMkMlMjAlMjAlMjMlMjBTdHJvbmclMjBjb25zaXN0ZW5jeSUyMGxldmVsJTBBKQ==",highlighted:`milvus_client.create_collection(
    collection_name=collection_name,
    dimension=embedding_dim,
    metric_type=<span class="hljs-string">&quot;IP&quot;</span>,  <span class="hljs-comment"># Inner product distance</span>
    consistency_level=<span class="hljs-string">&quot;Strong&quot;</span>,  <span class="hljs-comment"># Strong consistency level</span>
)`,wrap:!1}}),O=new M({props:{title:"插入数据",local:"插入数据",headingTag:"h3"}}),le=new f({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZGF0YSUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGklMkMlMjBsaW5lJTIwaW4lMjBlbnVtZXJhdGUodHFkbSh0ZXh0X2xpbmVzJTJDJTIwZGVzYyUzRCUyMkNyZWF0aW5nJTIwZW1iZWRkaW5ncyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YS5hcHBlbmQoJTdCJTIyaWQlMjIlM0ElMjBpJTJDJTIwJTIydmVjdG9yJTIyJTNBJTIwZW1iX3RleHQobGluZSklMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwbGluZSU3RCklMEElMEFpbnNlcnRfcmVzJTIwJTNEJTIwbWlsdnVzX2NsaWVudC5pbnNlcnQoY29sbGVjdGlvbl9uYW1lJTNEY29sbGVjdGlvbl9uYW1lJTJDJTIwZGF0YSUzRGRhdGEpJTBBaW5zZXJ0X3JlcyU1QiUyMmluc2VydF9jb3VudCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

data = []

<span class="hljs-keyword">for</span> i, line <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(text_lines, desc=<span class="hljs-string">&quot;Creating embeddings&quot;</span>)):
    data.append({<span class="hljs-string">&quot;id&quot;</span>: i, <span class="hljs-string">&quot;vector&quot;</span>: emb_text(line), <span class="hljs-string">&quot;text&quot;</span>: line})

insert_res = milvus_client.insert(collection_name=collection_name, data=data)
insert_res[<span class="hljs-string">&quot;insert_count&quot;</span>]`,wrap:!1}}),se=new M({props:{title:"构建 RAG",local:"构建-rag",headingTag:"h2"}}),ne=new M({props:{title:"检索查询数据",local:"检索查询数据",headingTag:"h3"}}),ie=new f({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBsZWdhbCUyMGJhc2lzJTIwZm9yJTIwdGhlJTIwcHJvcG9zYWwlM0YlMjI=",highlighted:'question = <span class="hljs-string">&quot;What is the legal basis for the proposal?&quot;</span>',wrap:!1}}),oe=new f({props:{code:"c2VhcmNoX3JlcyUyMCUzRCUyMG1pbHZ1c19jbGllbnQuc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fbmFtZSUzRGNvbGxlY3Rpb25fbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJfdGV4dChxdWVzdGlvbiklMEElMjAlMjAlMjAlMjAlNUQlMkMlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjAlNjBlbWJfdGV4dCU2MCUyMGZ1bmN0aW9uJTIwdG8lMjBjb252ZXJ0JTIwdGhlJTIwcXVlc3Rpb24lMjB0byUyMGFuJTIwZW1iZWRkaW5nJTIwdmVjdG9yJTBBJTIwJTIwJTIwJTIwbGltaXQlM0QzJTJDJTIwJTIwJTIzJTIwUmV0dXJuJTIwdG9wJTIwMyUyMHJlc3VsdHMlMEElMjAlMjAlMjAlMjBzZWFyY2hfcGFyYW1zJTNEJTdCJTIybWV0cmljX3R5cGUlMjIlM0ElMjAlMjJJUCUyMiUyQyUyMCUyMnBhcmFtcyUyMiUzQSUyMCU3QiU3RCU3RCUyQyUyMCUyMCUyMyUyMElubmVyJTIwcHJvZHVjdCUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2ZpZWxkcyUzRCU1QiUyMnRleHQlMjIlNUQlMkMlMjAlMjAlMjMlMjBSZXR1cm4lMjB0aGUlMjB0ZXh0JTIwZmllbGQlMEEp",highlighted:`search_res = milvus_client.search(
    collection_name=collection_name,
    data=[
        emb_text(question)
    ],  <span class="hljs-comment"># Use the \`emb_text\` function to convert the question to an embedding vector</span>
    limit=<span class="hljs-number">3</span>,  <span class="hljs-comment"># Return top 3 results</span>
    search_params={<span class="hljs-string">&quot;metric_type&quot;</span>: <span class="hljs-string">&quot;IP&quot;</span>, <span class="hljs-string">&quot;params&quot;</span>: {}},  <span class="hljs-comment"># Inner product distance</span>
    output_fields=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># Return the text field</span>
)`,wrap:!1}}),re=new f({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJldHJpZXZlZF9saW5lc193aXRoX2Rpc3RhbmNlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMChyZXMlNUIlMjJlbnRpdHklMjIlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcmVzJTVCJTIyZGlzdGFuY2UlMjIlNUQpJTIwZm9yJTIwcmVzJTIwaW4lMjBzZWFyY2hfcmVzJTVCMCU1RCUwQSU1RCUwQXByaW50KGpzb24uZHVtcHMocmV0cmlldmVkX2xpbmVzX3dpdGhfZGlzdGFuY2VzJTJDJTIwaW5kZW50JTNENCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json

<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_lines_with_distances = [
<span class="hljs-meta">... </span>    (res[<span class="hljs-string">&quot;entity&quot;</span>][<span class="hljs-string">&quot;text&quot;</span>], res[<span class="hljs-string">&quot;distance&quot;</span>]) <span class="hljs-keyword">for</span> res <span class="hljs-keyword">in</span> search_res[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(json.dumps(retrieved_lines_with_distances, indent=<span class="hljs-number">4</span>))`,wrap:!1}}),de=new M({props:{title:"使用 LLM 获取 RAG 回答",local:"使用-llm-获取-rag-回答",headingTag:"h3"}}),he=new f({props:{code:"Y29udGV4dCUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbiglMEElMjAlMjAlMjAlMjAlNUJsaW5lX3dpdGhfZGlzdGFuY2UlNUIwJTVEJTIwZm9yJTIwbGluZV93aXRoX2Rpc3RhbmNlJTIwaW4lMjByZXRyaWV2ZWRfbGluZXNfd2l0aF9kaXN0YW5jZXMlNUQlMEEp",highlighted:`context = <span class="hljs-string">&quot;\\n&quot;</span>.join(
    [line_with_distance[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> line_with_distance <span class="hljs-keyword">in</span> retrieved_lines_with_distances]
)`,wrap:!1}}),Me=new f({props:{code:"UFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBVXNlJTIwdGhlJTIwZm9sbG93aW5nJTIwcGllY2VzJTIwb2YlMjBpbmZvcm1hdGlvbiUyMGVuY2xvc2VkJTIwaW4lMjAlM0Njb250ZXh0JTNFJTIwdGFncyUyMHRvJTIwcHJvdmlkZSUyMGFuJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbiUyMGVuY2xvc2VkJTIwaW4lMjAlM0NxdWVzdGlvbiUzRSUyMHRhZ3MuJTBBJTNDY29udGV4dCUzRSUwQSU3QmNvbnRleHQlN0QlMEElM0MlMkZjb250ZXh0JTNFJTBBJTNDcXVlc3Rpb24lM0UlMEElN0JxdWVzdGlvbiU3RCUwQSUzQyUyRnF1ZXN0aW9uJTNFJTBBJTIyJTIyJTIy",highlighted:`PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Use the following pieces of information enclosed in &lt;context&gt; tags to provide an answer to the question enclosed in &lt;question&gt; tags.
&lt;context&gt;
{context}
&lt;/context&gt;
&lt;question&gt;
{question}
&lt;/question&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ge=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItSW5zdHJ1Y3QtdjAuMSUyMiUwQSUwQWxsbV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQobW9kZWwlM0RyZXBvX2lkJTJDJTIwdGltZW91dCUzRDEyMCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(model=repo_id, timeout=<span class="hljs-number">120</span>)`,wrap:!1}}),ye=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwUFJPTVBULmZvcm1hdChjb250ZXh0JTNEY29udGV4dCUyQyUyMHF1ZXN0aW9uJTNEcXVlc3Rpb24p",highlighted:'prompt = PROMPT.<span class="hljs-built_in">format</span>(context=context, question=question)',wrap:!1}}),Je=new f({props:{code:"YW5zd2VyJTIwJTNEJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBKS5zdHJpcCgpJTBBcHJpbnQoYW5zd2VyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>answer = llm_client.text_generation(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>).strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),Te=new $l({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_hf_and_milvus.md"}}),{c(){b=d("meta"),Ce=n(),Ue=d("p"),Ie=n(),i(g.$$.fragment),ve=n(),i(w.$$.fragment),Ze=n(),i(y.$$.fragment),ke=n(),J=d("p"),J.innerHTML=Nt,We=n(),$=d("p"),$.innerHTML=At,_e=n(),j=d("p"),j.textContent=Et,xe=n(),i(T.$$.fragment),Re=n(),i(U.$$.fragment),Ve=n(),i(G.$$.fragment),Be=n(),C=d("blockquote"),C.innerHTML=Xt,Ne=n(),I=d("p"),I.innerHTML=Ht,Ae=n(),i(v.$$.fragment),Ee=n(),i(Z.$$.fragment),Xe=n(),k=d("p"),k.innerHTML=zt,He=n(),i(W.$$.fragment),ze=n(),_=d("p"),_.innerHTML=Qt,Qe=n(),i(x.$$.fragment),qe=n(),R=d("pre"),R.textContent=qt,Fe=n(),i(V.$$.fragment),Ye=n(),i(B.$$.fragment),Se=n(),i(N.$$.fragment),Le=n(),A=d("p"),A.innerHTML=Ft,Pe=n(),i(E.$$.fragment),De=n(),X=d("p"),X.textContent=Yt,Ke=n(),i(H.$$.fragment),Oe=n(),z=d("pre"),z.textContent=St,et=n(),i(Q.$$.fragment),tt=n(),i(q.$$.fragment),lt=n(),i(F.$$.fragment),st=n(),Y=d("blockquote"),Y.innerHTML=Lt,nt=n(),S=d("p"),S.textContent=Pt,at=n(),i(L.$$.fragment),it=n(),P=d("p"),P.textContent=Dt,pt=n(),D=d("p"),D.innerHTML=Kt,ot=n(),i(K.$$.fragment),mt=n(),i(O.$$.fragment),rt=n(),ee=d("p"),ee.textContent=Ot,ct=n(),te=d("p"),te.innerHTML=el,dt=n(),i(le.$$.fragment),ut=n(),i(se.$$.fragment),ht=n(),i(ne.$$.fragment),ft=n(),ae=d("p"),ae.textContent=tl,Mt=n(),i(ie.$$.fragment),bt=n(),pe=d("p"),pe.textContent=ll,gt=n(),i(oe.$$.fragment),wt=n(),me=d("p"),me.textContent=sl,yt=n(),i(re.$$.fragment),Jt=n(),ce=d("pre"),ce.textContent=nl,$t=n(),i(de.$$.fragment),jt=n(),ue=d("p"),ue.textContent=al,Tt=n(),i(he.$$.fragment),Ut=n(),fe=d("p"),fe.textContent=il,Gt=n(),i(Me.$$.fragment),Ct=n(),be=d("p"),be.innerHTML=pl,It=n(),i(ge.$$.fragment),vt=n(),we=d("p"),we.textContent=ol,Zt=n(),i(ye.$$.fragment),kt=n(),i(Je.$$.fragment),Wt=n(),$e=d("pre"),$e.textContent=ml,_t=n(),je=d("p"),je.textContent=rl,xt=n(),i(Te.$$.fragment),Rt=n(),Ge=d("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);b=u(t,"META",{name:!0,content:!0}),t.forEach(l),Ce=a(e),Ue=u(e,"P",{}),cl(Ue).forEach(l),Ie=a(e),p(g.$$.fragment,e),ve=a(e),p(w.$$.fragment,e),Ze=a(e),p(y.$$.fragment,e),ke=a(e),J=u(e,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1chlthn"&&(J.innerHTML=Nt),We=a(e),$=u(e,"P",{"data-svelte-h":!0}),h($)!=="svelte-17b5h5k"&&($.innerHTML=At),_e=a(e),j=u(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-s7wopg"&&(j.textContent=Et),xe=a(e),p(T.$$.fragment,e),Re=a(e),p(U.$$.fragment,e),Ve=a(e),p(G.$$.fragment,e),Be=a(e),C=u(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(C)!=="svelte-19llaah"&&(C.innerHTML=Xt),Ne=a(e),I=u(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-lusge4"&&(I.innerHTML=Ht),Ae=a(e),p(v.$$.fragment,e),Ee=a(e),p(Z.$$.fragment,e),Xe=a(e),k=u(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-nbxe55"&&(k.innerHTML=zt),He=a(e),p(W.$$.fragment,e),ze=a(e),_=u(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-3vo957"&&(_.innerHTML=Qt),Qe=a(e),p(x.$$.fragment,e),qe=a(e),R=u(e,"PRE",{"data-svelte-h":!0}),h(R)!=="svelte-q6t6yp"&&(R.textContent=qt),Fe=a(e),p(V.$$.fragment,e),Ye=a(e),p(B.$$.fragment,e),Se=a(e),p(N.$$.fragment,e),Le=a(e),A=u(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-101d5kf"&&(A.innerHTML=Ft),Pe=a(e),p(E.$$.fragment,e),De=a(e),X=u(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-12ffb5h"&&(X.textContent=Yt),Ke=a(e),p(H.$$.fragment,e),Oe=a(e),z=u(e,"PRE",{"data-svelte-h":!0}),h(z)!=="svelte-citxyn"&&(z.textContent=St),et=a(e),p(Q.$$.fragment,e),tt=a(e),p(q.$$.fragment,e),lt=a(e),p(F.$$.fragment,e),st=a(e),Y=u(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(Y)!=="svelte-1fnjc2l"&&(Y.innerHTML=Lt),nt=a(e),S=u(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-lb7voj"&&(S.textContent=Pt),at=a(e),p(L.$$.fragment,e),it=a(e),P=u(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1x8w3ez"&&(P.textContent=Dt),pt=a(e),D=u(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-1w83t7l"&&(D.innerHTML=Kt),ot=a(e),p(K.$$.fragment,e),mt=a(e),p(O.$$.fragment,e),rt=a(e),ee=u(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-yu2mi1"&&(ee.textContent=Ot),ct=a(e),te=u(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-b8v197"&&(te.innerHTML=el),dt=a(e),p(le.$$.fragment,e),ut=a(e),p(se.$$.fragment,e),ht=a(e),p(ne.$$.fragment,e),ft=a(e),ae=u(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-15ym3a8"&&(ae.textContent=tl),Mt=a(e),p(ie.$$.fragment,e),bt=a(e),pe=u(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-xy3ubc"&&(pe.textContent=ll),gt=a(e),p(oe.$$.fragment,e),wt=a(e),me=u(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1rwok4e"&&(me.textContent=sl),yt=a(e),p(re.$$.fragment,e),Jt=a(e),ce=u(e,"PRE",{"data-svelte-h":!0}),h(ce)!=="svelte-sx7p7m"&&(ce.textContent=nl),$t=a(e),p(de.$$.fragment,e),jt=a(e),ue=u(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-14bvkzq"&&(ue.textContent=al),Tt=a(e),p(he.$$.fragment,e),Ut=a(e),fe=u(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-1rq6yrp"&&(fe.textContent=il),Gt=a(e),p(Me.$$.fragment,e),Ct=a(e),be=u(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-1ubdl5e"&&(be.innerHTML=pl),It=a(e),p(ge.$$.fragment,e),vt=a(e),we=u(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-fobs8u"&&(we.textContent=ol),Zt=a(e),p(ye.$$.fragment,e),kt=a(e),p(Je.$$.fragment,e),Wt=a(e),$e=u(e,"PRE",{"data-svelte-h":!0}),h($e)!=="svelte-18i7g4t"&&($e.textContent=ml),_t=a(e),je=u(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1d9opac"&&(je.textContent=rl),xt=a(e),p(Te.$$.fragment,e),Rt=a(e),Ge=u(e,"P",{}),cl(Ge).forEach(l),this.h()},h(){dl(b,"name","hf:doc:metadata"),dl(b,"content",Tl)},m(e,t){wl(document.head,b),s(e,Ce,t),s(e,Ue,t),s(e,Ie,t),o(g,e,t),s(e,ve,t),o(w,e,t),s(e,Ze,t),o(y,e,t),s(e,ke,t),s(e,J,t),s(e,We,t),s(e,$,t),s(e,_e,t),s(e,j,t),s(e,xe,t),o(T,e,t),s(e,Re,t),o(U,e,t),s(e,Ve,t),o(G,e,t),s(e,Be,t),s(e,C,t),s(e,Ne,t),s(e,I,t),s(e,Ae,t),o(v,e,t),s(e,Ee,t),o(Z,e,t),s(e,Xe,t),s(e,k,t),s(e,He,t),o(W,e,t),s(e,ze,t),s(e,_,t),s(e,Qe,t),o(x,e,t),s(e,qe,t),s(e,R,t),s(e,Fe,t),o(V,e,t),s(e,Ye,t),o(B,e,t),s(e,Se,t),o(N,e,t),s(e,Le,t),s(e,A,t),s(e,Pe,t),o(E,e,t),s(e,De,t),s(e,X,t),s(e,Ke,t),o(H,e,t),s(e,Oe,t),s(e,z,t),s(e,et,t),o(Q,e,t),s(e,tt,t),o(q,e,t),s(e,lt,t),o(F,e,t),s(e,st,t),s(e,Y,t),s(e,nt,t),s(e,S,t),s(e,at,t),o(L,e,t),s(e,it,t),s(e,P,t),s(e,pt,t),s(e,D,t),s(e,ot,t),o(K,e,t),s(e,mt,t),o(O,e,t),s(e,rt,t),s(e,ee,t),s(e,ct,t),s(e,te,t),s(e,dt,t),o(le,e,t),s(e,ut,t),o(se,e,t),s(e,ht,t),o(ne,e,t),s(e,ft,t),s(e,ae,t),s(e,Mt,t),o(ie,e,t),s(e,bt,t),s(e,pe,t),s(e,gt,t),o(oe,e,t),s(e,wt,t),s(e,me,t),s(e,yt,t),o(re,e,t),s(e,Jt,t),s(e,ce,t),s(e,$t,t),o(de,e,t),s(e,jt,t),s(e,ue,t),s(e,Tt,t),o(he,e,t),s(e,Ut,t),s(e,fe,t),s(e,Gt,t),o(Me,e,t),s(e,Ct,t),s(e,be,t),s(e,It,t),o(ge,e,t),s(e,vt,t),s(e,we,t),s(e,Zt,t),o(ye,e,t),s(e,kt,t),o(Je,e,t),s(e,Wt,t),s(e,$e,t),s(e,_t,t),s(e,je,t),s(e,xt,t),o(Te,e,t),s(e,Rt,t),s(e,Ge,t),Vt=!0},p:hl,i(e){Vt||(m(g.$$.fragment,e),m(w.$$.fragment,e),m(y.$$.fragment,e),m(T.$$.fragment,e),m(U.$$.fragment,e),m(G.$$.fragment,e),m(v.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(x.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(F.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(ge.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(Te.$$.fragment,e),Vt=!0)},o(e){r(g.$$.fragment,e),r(w.$$.fragment,e),r(y.$$.fragment,e),r(T.$$.fragment,e),r(U.$$.fragment,e),r(G.$$.fragment,e),r(v.$$.fragment,e),r(Z.$$.fragment,e),r(W.$$.fragment,e),r(x.$$.fragment,e),r(V.$$.fragment,e),r(B.$$.fragment,e),r(N.$$.fragment,e),r(E.$$.fragment,e),r(H.$$.fragment,e),r(Q.$$.fragment,e),r(q.$$.fragment,e),r(F.$$.fragment,e),r(L.$$.fragment,e),r(K.$$.fragment,e),r(O.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ie.$$.fragment,e),r(oe.$$.fragment,e),r(re.$$.fragment,e),r(de.$$.fragment,e),r(he.$$.fragment,e),r(Me.$$.fragment,e),r(ge.$$.fragment,e),r(ye.$$.fragment,e),r(Je.$$.fragment,e),r(Te.$$.fragment,e),Vt=!1},d(e){e&&(l(Ce),l(Ue),l(Ie),l(ve),l(Ze),l(ke),l(J),l(We),l($),l(_e),l(j),l(xe),l(Re),l(Ve),l(Be),l(C),l(Ne),l(I),l(Ae),l(Ee),l(Xe),l(k),l(He),l(ze),l(_),l(Qe),l(qe),l(R),l(Fe),l(Ye),l(Se),l(Le),l(A),l(Pe),l(De),l(X),l(Ke),l(Oe),l(z),l(et),l(tt),l(lt),l(st),l(Y),l(nt),l(S),l(at),l(it),l(P),l(pt),l(D),l(ot),l(mt),l(rt),l(ee),l(ct),l(te),l(dt),l(ut),l(ht),l(ft),l(ae),l(Mt),l(bt),l(pe),l(gt),l(wt),l(me),l(yt),l(Jt),l(ce),l($t),l(jt),l(ue),l(Tt),l(Ut),l(fe),l(Gt),l(Ct),l(be),l(It),l(vt),l(we),l(Zt),l(kt),l(Wt),l($e),l(_t),l(je),l(xt),l(Rt),l(Ge)),l(b),c(g,e),c(w,e),c(y,e),c(T,e),c(U,e),c(G,e),c(v,e),c(Z,e),c(W,e),c(x,e),c(V,e),c(B,e),c(N,e),c(E,e),c(H,e),c(Q,e),c(q,e),c(F,e),c(L,e),c(K,e),c(O,e),c(le,e),c(se,e),c(ne,e),c(ie,e),c(oe,e),c(re,e),c(de,e),c(he,e),c(Me,e),c(ge,e),c(ye,e),c(Je,e),c(Te,e)}}}const Tl='{"title":"使用 Hugging Face 和 Milvus 构建 RAG 系统","local":"使用-hugging-face-和-milvus-构建-rag-系统","sections":[{"title":"准备","local":"准备","sections":[{"title":"依赖关系和环境","local":"依赖关系和环境","sections":[],"depth":3},{"title":"准备数据","local":"准备数据","sections":[],"depth":3},{"title":"准备 embedding 模型","local":"准备-embedding-模型","sections":[],"depth":3}],"depth":2},{"title":"将数据加载到 Milvus 中","local":"将数据加载到-milvus-中","sections":[{"title":"创建 collection","local":"创建-collection","sections":[],"depth":3},{"title":"插入数据","local":"插入数据","sections":[],"depth":3}],"depth":2},{"title":"构建 RAG","local":"构建-rag","sections":[{"title":"检索查询数据","local":"检索查询数据","sections":[],"depth":3},{"title":"使用 LLM 获取 RAG 回答","local":"使用-llm-获取-rag-回答","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ul(Bt){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends Ml{constructor(b){super(),bl(this,b,Ul,jl,ul,{})}}export{kl as component};
