import{s as jl,n as Ul,o as Bl}from"../chunks/scheduler.1f027d5a.js";import{S as Cl,i as xl,e as p,s as n,c as M,h as Gl,a as i,d as l,b as a,f as gl,g as o,j as m,k as $l,l as Il,m as s,n as u,t as r,o as J,p as b}from"../chunks/index.6117a65d.js";import{C as vl}from"../chunks/CopyLLMTxtMenu.0ff8411a.js";import{D as Zl,C as T}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as jt,E as _l}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function kl(Xe){let y,Ct,Ut,xt,f,Gt,d,It,w,vt,c,We='<em>作者: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Zt,h,Ve='本 notebook 展示了如何使用 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> 模型和 LangChain 快速构建一个针对项目 GitHub issues 的简单 RAG。',_t,g,Ne="<strong>什么是 RAG</strong>",kt,$,Fe="RAG 是一个很流行的方法，用来解决强大的 LLM 不知道具体内容的问题，因为具体内容不在其训练数据中，或者当它看到它之前时产生幻觉。这样的具体内容可能是专有的、敏感的，或者，就像这个例子中一样，是最近的和更新的。",Rt,j,Ee="如果你的数据集是静态的和不需要定期更新的，那么你可能会考虑微调一个大模型。但在大多数情况下，微调模型花费巨大并且重复去微调的话(比如，处理数据漂移的时候)，可能会导致“模型偏移”。这种情况模型行为的变换就不是设计的那样了。",Ht,U,Le="<strong>RAG (检索增强生成)</strong> 并不需要模型微调。相反， RAG 通过提供检索到的额外的相关内容喂给 LLM 以此来获得更好的回答。",Xt,B,Se="这里是一个简单说明：",Wt,C,ze='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',Vt,x,Ae="<li><p>额外的数据通过独立的嵌入模型会被转化为嵌入向量，这些向量会储存在向量数据库里。嵌入模型通常都比较小，因此在常规偏差上更新嵌入向量相比于微调模型会更快，便宜，和简单。</p></li> <li><p>与此同时，由于不需要微调，给了你极大的自由度去切换选择你自己的更强的 LLM，或者对于更快速的推理去切换更小的蒸馏模型。</p></li>",Nt,G,Qe="让我们用开源的 LLM ，嵌入模型，和 LangChain 快速构建一个针对项目 GitHub issues 的简单 RAG。",Ft,I,Ye="首先安装相关依赖：",Et,v,Lt,Z,St,_,zt,k,At,R,Pe='在这个例子中，我们会从<a href="https://github.com/huggingface/peft" rel="nofollow">PEFT 库的仓库</a>加载所有的 issues（包括现在开放的和已经关闭的）。',Qt,H,qe='首先，你需要获取一个 <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub 个人权限 token</a> 来访问 GitHub API。',Yt,X,Pt,W,De='下一步，我们将会加载  <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> 仓库中所有的 issues:',qt,V,Ke="<li>默认情况下， PR 也被认定为 issues，这里我们要设置 <code>include_prs=False</code> 来排除 PR。</li> <li>设置 <code>state = &quot;all&quot;</code> 意味着我们会把开放和已经关闭的 issues 都加载了。</li>",Dt,N,Kt,F,Oe="个人仓库的 issues 内容可能会长于一个嵌入模型可以最为输入处理的长度。如果我们想要嵌入所有可用的内容，我们需要把文档分割成适当大小的块。",Ot,E,tl="最普通直接的切块方法就是定义一个固定的块大小，以及判断块之间是否加入重叠。保存一些块之间的重叠允许我们去保存一些语义上下文。",te,L,el="其他方法通常更复杂，会考虑到文档的结构和上下文。例如，人们可能希望根据句子或段落来分割文档，然而，固定大小的分块在大多数常见情况下都表现得很好，所以我们将在这里采用这种方法。",ee,S,le,z,se,A,ll="现在所有的文档都设置成立合适的大小，我们可以用他们的嵌入创建一个数据集了。",ne,Q,sl='为了创建文档块嵌入，我们将会使用 <code>HuggingFaceEmbeddings</code> 和 <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> 嵌入模型。在 Hub 上有许多其他的嵌入模型可用，你也可以查看 <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a> 关注表现最好的模型。',ae,Y,nl="为了创建向量数据库，我们将会使用 <code>FAISS</code> 库。这个库提供高效的相似度搜索和稠密向量的聚类，正是我们需要的。FAISS 目前是大规模数据集上 NN 搜索最常用的库之一。",pe,P,al="我们通过 LangChain 的 API 来获取嵌入模型和 FAISS 向量数据库。",ie,q,me,D,pl="我们需要一种方式，来返回给定无结构的查询所需要的文档。针对这个，我们会使用 <code>as_retriever</code> 方法，使用 <code>db</code> 作为支柱：",Me,K,il="<li><code>search_type=&quot;similarity&quot;</code> 意味着我们会执行查询和文档之间的相似度搜索</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> 指示我们指定返回的最高的 4 个结果</li>",oe,O,ue,tt,ml="向量数据库和检索器现在设置好了，下一步我们需要设置好链中的下一块 - 模型。",re,et,Je,lt,Ml='针对本例，我们选择 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, 一个小而强大的模型。',be,st,ol='随着每周都会出好多模型，你可能会想要替换这个模型到最新的最好的模型。最好的方式是查看 <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>。',Te,nt,ul="为了推理更快，我们将加载模型的量化版本：",ye,at,fe,pt,de,it,rl="最后，我们有了所有的需要设置的 LLM 链的部分。",we,mt,Jl="首先，使用加载的模型和他的tokenizer创建一个文本生成的流水线(pipeline)",ce,Mt,bl="下一步，创建一个提示模板-这个应该遵循模型的格式，所以如果你替换了模型检查点，确保使用合适的格式。",he,ot,ge,ut,Tl="注意：你也可以使用 <code>tokenizer.apply_chat_template</code> 转换列表消息为合适聊天格式的字符串（字典也行  <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>）",$e,rt,yl="最后，我们需要将 LLM 链与检索器(retriever)结合起来创建一个 RAG 链。我们将原始问题以及检索到的文档上下文传递到最后生成步骤：",je,Jt,Ue,bt,Be,Tt,fl="让我们看看对于特定领域库的问题不同的 RAG 的生成的回答。",Ce,yt,xe,ft,dl="首先，让我们看看仅仅通过模型自身不加检索内容能得到什么答案:",Ge,dt,Ie,wt,wl=`可以看到，模型将这个问题解释为关于物理电脑适配器的问题，而在 PEFT 的背景下，“适配器”指的是 LoRA 适配器。
让我们看看添加 GitHub issues 的上下文是否有助于模型给出更相关的答案：`,ve,ct,Ze,ht,cl="我们可以看到，加入检索的信息后，同一个模型能够对于特定库的问题给出更准确、更相关的答案。",_e,gt,hl="值得注意的是，将多个适配器结合用于推理的功能已经被添加到库中，人们可以在文档中找到这些信息，因此在下一个迭代的RAG中，包含文档嵌入可能是有价值的。",ke,$t,Re,Bt,He;return f=new Zl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_zephyr_langchain.ipynb"}]}}),d=new vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new jt({props:{title:"用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG",local:"用-hugging-face-zephyr-和-langchain-针对-github-issues-构建简单的-rag",headingTag:"h1"}}),v=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),Z=new T({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale
locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),_=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHk=",highlighted:"!pip install -q langchain langchain-community",wrap:!1}}),k=new jt({props:{title:"准备数据",local:"准备数据",headingTag:"h2"}}),X=new T({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),N=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwc3RhdGUlM0QlMjJhbGwlMjIlMEEpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(
    repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>,
    access_token=ACCESS_TOKEN,
    include_prs=<span class="hljs-literal">False</span>,
    state=<span class="hljs-string">&quot;all&quot;</span>
)

docs = loader.load()`,wrap:!1}}),S=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),z=new jt({props:{title:"创建嵌入和检索器",local:"创建嵌入和检索器",headingTag:"h2"}}),q=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QnQkFBSSUyRmJnZS1iYXNlLWVuLXYxLjUnKSk=",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs,
                          HuggingFaceEmbeddings(model_name=<span class="hljs-string">&#x27;BAAI/bge-base-en-v1.5&#x27;</span>))`,wrap:!1}}),O=new T({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKCUwQSUyMCUyMCUyMCUyMHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlYXJjaF9rd2FyZ3MlM0QlN0InayclM0ElMjA0JTdEJTBBKQ==",highlighted:`retriever = db.as_retriever(
    search_type=<span class="hljs-string">&quot;similarity&quot;</span>,
    search_kwargs={<span class="hljs-string">&#x27;k&#x27;</span>: <span class="hljs-number">4</span>}
)`,wrap:!1}}),et=new jt({props:{title:"加载量化模型",local:"加载量化模型",headingTag:"h2"}}),at=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCdIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGEnJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),pt=new jt({props:{title:"设置 LLM 链",local:"设置-llm-链",headingTag:"h2"}}),ot=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),Jt=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCglMEElMjAlN0IlMjJjb250ZXh0JTIyJTNBJTIwcmV0cmlldmVyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBSdW5uYWJsZVBhc3N0aHJvdWdoKCklN0QlMEElMjAlMjAlMjAlMjAlN0MlMjBsbG1fY2hhaW4lMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = (
 {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}
    | llm_chain
)`,wrap:!1}}),bt=new jt({props:{title:"比较结果",local:"比较结果",headingTag:"h2"}}),yt=new T({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),dt=new T({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>:<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),ct=new T({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),$t=new _l({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_zephyr_langchain.md"}}),{c(){y=p("meta"),Ct=n(),Ut=p("p"),xt=n(),M(f.$$.fragment),Gt=n(),M(d.$$.fragment),It=n(),M(w.$$.fragment),vt=n(),c=p("p"),c.innerHTML=We,Zt=n(),h=p("p"),h.innerHTML=Ve,_t=n(),g=p("p"),g.innerHTML=Ne,kt=n(),$=p("p"),$.textContent=Fe,Rt=n(),j=p("p"),j.textContent=Ee,Ht=n(),U=p("p"),U.innerHTML=Le,Xt=n(),B=p("p"),B.textContent=Se,Wt=n(),C=p("p"),C.innerHTML=ze,Vt=n(),x=p("ul"),x.innerHTML=Ae,Nt=n(),G=p("p"),G.textContent=Qe,Ft=n(),I=p("p"),I.textContent=Ye,Et=n(),M(v.$$.fragment),Lt=n(),M(Z.$$.fragment),St=n(),M(_.$$.fragment),zt=n(),M(k.$$.fragment),At=n(),R=p("p"),R.innerHTML=Pe,Qt=n(),H=p("p"),H.innerHTML=qe,Yt=n(),M(X.$$.fragment),Pt=n(),W=p("p"),W.innerHTML=De,qt=n(),V=p("ul"),V.innerHTML=Ke,Dt=n(),M(N.$$.fragment),Kt=n(),F=p("p"),F.textContent=Oe,Ot=n(),E=p("p"),E.textContent=tl,te=n(),L=p("p"),L.textContent=el,ee=n(),M(S.$$.fragment),le=n(),M(z.$$.fragment),se=n(),A=p("p"),A.textContent=ll,ne=n(),Q=p("p"),Q.innerHTML=sl,ae=n(),Y=p("p"),Y.innerHTML=nl,pe=n(),P=p("p"),P.textContent=al,ie=n(),M(q.$$.fragment),me=n(),D=p("p"),D.innerHTML=pl,Me=n(),K=p("ul"),K.innerHTML=il,oe=n(),M(O.$$.fragment),ue=n(),tt=p("p"),tt.textContent=ml,re=n(),M(et.$$.fragment),Je=n(),lt=p("p"),lt.innerHTML=Ml,be=n(),st=p("p"),st.innerHTML=ol,Te=n(),nt=p("p"),nt.textContent=ul,ye=n(),M(at.$$.fragment),fe=n(),M(pt.$$.fragment),de=n(),it=p("p"),it.textContent=rl,we=n(),mt=p("p"),mt.textContent=Jl,ce=n(),Mt=p("p"),Mt.textContent=bl,he=n(),M(ot.$$.fragment),ge=n(),ut=p("p"),ut.innerHTML=Tl,$e=n(),rt=p("p"),rt.textContent=yl,je=n(),M(Jt.$$.fragment),Ue=n(),M(bt.$$.fragment),Be=n(),Tt=p("p"),Tt.textContent=fl,Ce=n(),M(yt.$$.fragment),xe=n(),ft=p("p"),ft.textContent=dl,Ge=n(),M(dt.$$.fragment),Ie=n(),wt=p("p"),wt.textContent=wl,ve=n(),M(ct.$$.fragment),Ze=n(),ht=p("p"),ht.textContent=cl,_e=n(),gt=p("p"),gt.textContent=hl,ke=n(),M($t.$$.fragment),Re=n(),Bt=p("p"),this.h()},l(t){const e=Gl("svelte-u9bgzb",document.head);y=i(e,"META",{name:!0,content:!0}),e.forEach(l),Ct=a(t),Ut=i(t,"P",{}),gl(Ut).forEach(l),xt=a(t),o(f.$$.fragment,t),Gt=a(t),o(d.$$.fragment,t),It=a(t),o(w.$$.fragment,t),vt=a(t),c=i(t,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1dsumsc"&&(c.innerHTML=We),Zt=a(t),h=i(t,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1nxrv0b"&&(h.innerHTML=Ve),_t=a(t),g=i(t,"P",{"data-svelte-h":!0}),m(g)!=="svelte-15ot3ve"&&(g.innerHTML=Ne),kt=a(t),$=i(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-11u8woo"&&($.textContent=Fe),Rt=a(t),j=i(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1fwpup0"&&(j.textContent=Ee),Ht=a(t),U=i(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-2xs5eo"&&(U.innerHTML=Le),Xt=a(t),B=i(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-2l10hj"&&(B.textContent=Se),Wt=a(t),C=i(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1c1z86r"&&(C.innerHTML=ze),Vt=a(t),x=i(t,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-1cd3ng1"&&(x.innerHTML=Ae),Nt=a(t),G=i(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-nhx78j"&&(G.textContent=Qe),Ft=a(t),I=i(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-10677r8"&&(I.textContent=Ye),Et=a(t),o(v.$$.fragment,t),Lt=a(t),o(Z.$$.fragment,t),St=a(t),o(_.$$.fragment,t),zt=a(t),o(k.$$.fragment,t),At=a(t),R=i(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1f0miko"&&(R.innerHTML=Pe),Qt=a(t),H=i(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1fd32v"&&(H.innerHTML=qe),Yt=a(t),o(X.$$.fragment,t),Pt=a(t),W=i(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1hkyu0j"&&(W.innerHTML=De),qt=a(t),V=i(t,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-1a0rln0"&&(V.innerHTML=Ke),Dt=a(t),o(N.$$.fragment,t),Kt=a(t),F=i(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-ryc3lv"&&(F.textContent=Oe),Ot=a(t),E=i(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-s0tphm"&&(E.textContent=tl),te=a(t),L=i(t,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1ir96rw"&&(L.textContent=el),ee=a(t),o(S.$$.fragment,t),le=a(t),o(z.$$.fragment,t),se=a(t),A=i(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-frdo0o"&&(A.textContent=ll),ne=a(t),Q=i(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1cfgvps"&&(Q.innerHTML=sl),ae=a(t),Y=i(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-x85d74"&&(Y.innerHTML=nl),pe=a(t),P=i(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-9ffz7p"&&(P.textContent=al),ie=a(t),o(q.$$.fragment,t),me=a(t),D=i(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-xex2hi"&&(D.innerHTML=pl),Me=a(t),K=i(t,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-4jbas3"&&(K.innerHTML=il),oe=a(t),o(O.$$.fragment,t),ue=a(t),tt=i(t,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-5nilxz"&&(tt.textContent=ml),re=a(t),o(et.$$.fragment,t),Je=a(t),lt=i(t,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-df64rt"&&(lt.innerHTML=Ml),be=a(t),st=i(t,"P",{"data-svelte-h":!0}),m(st)!=="svelte-1yhmn0n"&&(st.innerHTML=ol),Te=a(t),nt=i(t,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-jk1sm8"&&(nt.textContent=ul),ye=a(t),o(at.$$.fragment,t),fe=a(t),o(pt.$$.fragment,t),de=a(t),it=i(t,"P",{"data-svelte-h":!0}),m(it)!=="svelte-oeo873"&&(it.textContent=rl),we=a(t),mt=i(t,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-if5n97"&&(mt.textContent=Jl),ce=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1a017u5"&&(Mt.textContent=bl),he=a(t),o(ot.$$.fragment,t),ge=a(t),ut=i(t,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-kibc99"&&(ut.innerHTML=Tl),$e=a(t),rt=i(t,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-18onexw"&&(rt.textContent=yl),je=a(t),o(Jt.$$.fragment,t),Ue=a(t),o(bt.$$.fragment,t),Be=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1hik170"&&(Tt.textContent=fl),Ce=a(t),o(yt.$$.fragment,t),xe=a(t),ft=i(t,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-gn3i6x"&&(ft.textContent=dl),Ge=a(t),o(dt.$$.fragment,t),Ie=a(t),wt=i(t,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-15qdncx"&&(wt.textContent=wl),ve=a(t),o(ct.$$.fragment,t),Ze=a(t),ht=i(t,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-11ic9g3"&&(ht.textContent=cl),_e=a(t),gt=i(t,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-gcl5gb"&&(gt.textContent=hl),ke=a(t),o($t.$$.fragment,t),Re=a(t),Bt=i(t,"P",{}),gl(Bt).forEach(l),this.h()},h(){$l(y,"name","hf:doc:metadata"),$l(y,"content",Rl)},m(t,e){Il(document.head,y),s(t,Ct,e),s(t,Ut,e),s(t,xt,e),u(f,t,e),s(t,Gt,e),u(d,t,e),s(t,It,e),u(w,t,e),s(t,vt,e),s(t,c,e),s(t,Zt,e),s(t,h,e),s(t,_t,e),s(t,g,e),s(t,kt,e),s(t,$,e),s(t,Rt,e),s(t,j,e),s(t,Ht,e),s(t,U,e),s(t,Xt,e),s(t,B,e),s(t,Wt,e),s(t,C,e),s(t,Vt,e),s(t,x,e),s(t,Nt,e),s(t,G,e),s(t,Ft,e),s(t,I,e),s(t,Et,e),u(v,t,e),s(t,Lt,e),u(Z,t,e),s(t,St,e),u(_,t,e),s(t,zt,e),u(k,t,e),s(t,At,e),s(t,R,e),s(t,Qt,e),s(t,H,e),s(t,Yt,e),u(X,t,e),s(t,Pt,e),s(t,W,e),s(t,qt,e),s(t,V,e),s(t,Dt,e),u(N,t,e),s(t,Kt,e),s(t,F,e),s(t,Ot,e),s(t,E,e),s(t,te,e),s(t,L,e),s(t,ee,e),u(S,t,e),s(t,le,e),u(z,t,e),s(t,se,e),s(t,A,e),s(t,ne,e),s(t,Q,e),s(t,ae,e),s(t,Y,e),s(t,pe,e),s(t,P,e),s(t,ie,e),u(q,t,e),s(t,me,e),s(t,D,e),s(t,Me,e),s(t,K,e),s(t,oe,e),u(O,t,e),s(t,ue,e),s(t,tt,e),s(t,re,e),u(et,t,e),s(t,Je,e),s(t,lt,e),s(t,be,e),s(t,st,e),s(t,Te,e),s(t,nt,e),s(t,ye,e),u(at,t,e),s(t,fe,e),u(pt,t,e),s(t,de,e),s(t,it,e),s(t,we,e),s(t,mt,e),s(t,ce,e),s(t,Mt,e),s(t,he,e),u(ot,t,e),s(t,ge,e),s(t,ut,e),s(t,$e,e),s(t,rt,e),s(t,je,e),u(Jt,t,e),s(t,Ue,e),u(bt,t,e),s(t,Be,e),s(t,Tt,e),s(t,Ce,e),u(yt,t,e),s(t,xe,e),s(t,ft,e),s(t,Ge,e),u(dt,t,e),s(t,Ie,e),s(t,wt,e),s(t,ve,e),u(ct,t,e),s(t,Ze,e),s(t,ht,e),s(t,_e,e),s(t,gt,e),s(t,ke,e),u($t,t,e),s(t,Re,e),s(t,Bt,e),He=!0},p:Ul,i(t){He||(r(f.$$.fragment,t),r(d.$$.fragment,t),r(w.$$.fragment,t),r(v.$$.fragment,t),r(Z.$$.fragment,t),r(_.$$.fragment,t),r(k.$$.fragment,t),r(X.$$.fragment,t),r(N.$$.fragment,t),r(S.$$.fragment,t),r(z.$$.fragment,t),r(q.$$.fragment,t),r(O.$$.fragment,t),r(et.$$.fragment,t),r(at.$$.fragment,t),r(pt.$$.fragment,t),r(ot.$$.fragment,t),r(Jt.$$.fragment,t),r(bt.$$.fragment,t),r(yt.$$.fragment,t),r(dt.$$.fragment,t),r(ct.$$.fragment,t),r($t.$$.fragment,t),He=!0)},o(t){J(f.$$.fragment,t),J(d.$$.fragment,t),J(w.$$.fragment,t),J(v.$$.fragment,t),J(Z.$$.fragment,t),J(_.$$.fragment,t),J(k.$$.fragment,t),J(X.$$.fragment,t),J(N.$$.fragment,t),J(S.$$.fragment,t),J(z.$$.fragment,t),J(q.$$.fragment,t),J(O.$$.fragment,t),J(et.$$.fragment,t),J(at.$$.fragment,t),J(pt.$$.fragment,t),J(ot.$$.fragment,t),J(Jt.$$.fragment,t),J(bt.$$.fragment,t),J(yt.$$.fragment,t),J(dt.$$.fragment,t),J(ct.$$.fragment,t),J($t.$$.fragment,t),He=!1},d(t){t&&(l(Ct),l(Ut),l(xt),l(Gt),l(It),l(vt),l(c),l(Zt),l(h),l(_t),l(g),l(kt),l($),l(Rt),l(j),l(Ht),l(U),l(Xt),l(B),l(Wt),l(C),l(Vt),l(x),l(Nt),l(G),l(Ft),l(I),l(Et),l(Lt),l(St),l(zt),l(At),l(R),l(Qt),l(H),l(Yt),l(Pt),l(W),l(qt),l(V),l(Dt),l(Kt),l(F),l(Ot),l(E),l(te),l(L),l(ee),l(le),l(se),l(A),l(ne),l(Q),l(ae),l(Y),l(pe),l(P),l(ie),l(me),l(D),l(Me),l(K),l(oe),l(ue),l(tt),l(re),l(Je),l(lt),l(be),l(st),l(Te),l(nt),l(ye),l(fe),l(de),l(it),l(we),l(mt),l(ce),l(Mt),l(he),l(ge),l(ut),l($e),l(rt),l(je),l(Ue),l(Be),l(Tt),l(Ce),l(xe),l(ft),l(Ge),l(Ie),l(wt),l(ve),l(Ze),l(ht),l(_e),l(gt),l(ke),l(Re),l(Bt)),l(y),b(f,t),b(d,t),b(w,t),b(v,t),b(Z,t),b(_,t),b(k,t),b(X,t),b(N,t),b(S,t),b(z,t),b(q,t),b(O,t),b(et,t),b(at,t),b(pt,t),b(ot,t),b(Jt,t),b(bt,t),b(yt,t),b(dt,t),b(ct,t),b($t,t)}}}const Rl='{"title":"用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG","local":"用-hugging-face-zephyr-和-langchain-针对-github-issues-构建简单的-rag","sections":[{"title":"准备数据","local":"准备数据","sections":[],"depth":2},{"title":"创建嵌入和检索器","local":"创建嵌入和检索器","sections":[],"depth":2},{"title":"加载量化模型","local":"加载量化模型","sections":[],"depth":2},{"title":"设置 LLM 链","local":"设置-llm-链","sections":[],"depth":2},{"title":"比较结果","local":"比较结果","sections":[],"depth":2}],"depth":1}';function Hl(Xe){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Cl{constructor(y){super(),xl(this,y,Hl,kl,jl,{})}}export{El as component};
