import{s as Cs,n as hs,o as bs}from"../chunks/scheduler.1f027d5a.js";import{S as ds,i as fs,e as M,s as n,c as i,h as gs,a as p,d as t,b as a,f as ws,g as o,j as y,k as Is,l as Bs,m as e,n as j,t as U,o as c,p as J}from"../chunks/index.6117a65d.js";import{C as Qs}from"../chunks/CopyLLMTxtMenu.0ff8411a.js";import{D as qs,C as u}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as Ll,E as As}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function Zs(zl){let r,al,el,Ml,T,pl,m,yl,w,il,I,Dl='<em>作者：<a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ol,C,Kl="在本教程中，我们将学习如何实现一个利用 SQL 的智能体，使用 <code>transformers.agents</code>。",jl,h,Pl="与标准文本到 SQL pipeline 相比，<strong>它有什么优势？</strong>",Ul,b,Ol="标准的文本到 SQL pipeline 是脆弱的，因为生成的 SQL 查询可能是错误的。更糟糕的是，查询可能是错误的，但并不会引发错误，而是返回一些错误的/无用的输出，且不会发出警报。",cl,d,ls="👉 相比之下，<strong>智能体系统能够批判性地检查输出，并决定是否需要更改查询</strong>，从而大大提高其性能。",Jl,f,ss="让我们开始构建这个智能体吧！💪",ul,g,rl,B,Tl,Q,ml,q,ts="让我们检查系统是否能通过一个基本查询正常工作：",wl,A,Il,Z,es=`(1, 'Alan Payne', 12.06, 1.2)
(2, 'Alex Mason', 23.86, 0.24)
(3, 'Woodrow Wilson', 53.43, 5.43)
(4, 'Margaret James', 21.11, 1.0)
`,Cl,W,hl,R,ns="现在，让我们将 SQL 表格使其可由智能体（工具）检索。",bl,S,as="智能体的 <code>description</code> 属性将被嵌入到大语言模型（LLM）的提示中，这样它就能了解如何使用这个工具。在这个步骤中，我们需要描述 SQL 表格的结构，以便让智能体能够正确地执行查询并与数据库交互。",dl,E,fl,$,Ms=`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT
`,gl,N,ps='现在，让我们构建我们的工具。它需要以下内容：（详细信息请参阅<a href="https://huggingface.co/docs/transformers/en/agents#create-a-new-tool" rel="nofollow">文档</a>）',Bl,v,ys="<li>带有 <code>Args:</code> 部分的文档字符串</li> <li>类型提示</li>",Ql,H,ql,V,is="现在让我们创建一个利用这个工具的智能体。",Al,G,os="我们将使用 <code>ReactCodeAgent</code>，它是 <code>transformers.agents</code> 的主要智能体类：一个根据 ReAct 框架编写代码并能迭代先前输出的智能体。",Zl,k,js='<code>llm_engine</code> 是驱动智能体系统的 LLM。<code>HfEngine</code> 允许你通过 HF 的推理 API 调用 LLM，无论是通过无服务器或专用端点，但你也可以使用任何专有的 API：查看<a href="agent_change_llm">这个指南</a>以了解如何进行适配。',Wl,_,Rl,x,Sl,X,El,Y,Us="现在让我们增加一点难度！我们希望智能体能够处理跨多个表的连接查询。",$l,F,cs="因此，让我们创建一个第二个表，用于记录每个 <code>receipt_id</code> 对应的服务员姓名！",Nl,L,vl,z,Js="我们需要更新 <code>SQLExecutorTool</code>，将这个表的描述添加进去，以便让 LLM 能够正确地利用这个表中的信息。",Hl,D,Vl,K,us=`Allows you to perform SQL queries on the table. Beware that this tool's output is a string representation of the execution output.
It can use the following tables:

Table 'receipts':
Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT

Table 'waiters':
Columns:
  - receipt_id: INTEGER
  - waiter_name: VARCHAR(16)
`,Gl,P,rs='由于这个请求比之前的更具挑战性，我们将切换 LLM 引擎，使用更强大的 <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a>！',kl,O,_l,ll,Ts="它直接就能工作！设置过程出乎意料地简单，不是吗？",xl,sl,ms="✅ 现在你可以去构建你一直梦想的文本到 SQL 系统了！✨",Xl,tl,Yl,nl,Fl;return T=new qs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_text_to_sql.ipynb"}]}}),m=new Qs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Ll({props:{title:"用于文本到 SQL 的智能体，带有自动错误修正功能",local:"用于文本到-sql-的智能体带有自动错误修正功能",headingTag:"h1"}}),g=new Ll({props:{title:"设置 SQL 表",local:"设置-sql-表",headingTag:"h2"}}),B=new u({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBJTIzJTIwY3JlYXRlJTIwY2l0eSUyMFNRTCUyMHRhYmxlJTBBdGFibGVfbmFtZSUyMCUzRCUyMCUyMnJlY2VpcHRzJTIyJTBBcmVjZWlwdHMlMjAlM0QlMjBUYWJsZSglMEElMjAlMjAlMjAlMjB0YWJsZV9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGFfb2JqJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnJlY2VpcHRfaWQlMjIlMkMlMjBJbnRlZ2VyJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJjdXN0b21lcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycHJpY2UlMjIlMkMlMjBGbG9hdCklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIydGlwJTIyJTJDJTIwRmxvYXQpJTJDJTBBKSUwQW1ldGFkYXRhX29iai5jcmVhdGVfYWxsKGVuZ2luZSk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)`,wrap:!1}}),Q=new u({props:{code:"cm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjBzdG10JTIwJTNEJTIwaW5zZXJ0KHJlY2VpcHRzKS52YWx1ZXMoKipyb3cpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5iZWdpbigpJTIwYXMlMjBjb25uZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3Vyc29yJTIwJTNEJTIwY29ubmVjdGlvbi5leGVjdXRlKHN0bXQp",highlighted:`rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),A=new u({props:{code:"d2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KCUyMiUyMiUyMlNFTEVDVCUyMColMjBmcm9tJTIwcmVjZWlwdHMlMjIlMjIlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJvdyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
<span class="hljs-meta">... </span>    rows = con.execute(text(<span class="hljs-string">&quot;&quot;&quot;SELECT * from receipts&quot;&quot;&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(row)`,wrap:!1}}),W=new Ll({props:{title:"构建我们的智能体",local:"构建我们的智能体",headingTag:"h2"}}),E=new u({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTBBJTIwJTIwJTIwJTIwJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCUwQSklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span>columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

<span class="hljs-meta">&gt;&gt;&gt; </span>table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join(
<span class="hljs-meta">... </span>    [<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmQXBpRW5naW5lJTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBsbG1fZW5naW5lJTNESGZBcGlFbmdpbmUoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent, HfApiEngine

agent = ReactCodeAgent(
    tools=[sql_engine],
    llm_engine=HfApiEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>),
)`,wrap:!1}}),x=new u({props:{code:"YWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)',wrap:!1}}),X=new Ll({props:{title:"提高难度：表格连接",local:"提高难度表格连接",headingTag:"h2"}}),L=new u({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),D=new u({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
<span class="hljs-meta">... </span>It can use the following tables:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
<span class="hljs-meta">... </span>    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

<span class="hljs-meta">... </span>    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

<span class="hljs-meta">... </span>    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join(
<span class="hljs-meta">... </span>        [<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),O=new u({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBKSUwQSUwQWFnZW50LnJ1biglMjJXaGljaCUyMHdhaXRlciUyMGdvdCUyMG1vcmUlMjB0b3RhbCUyMG1vbmV5JTIwZnJvbSUyMHRpcHMlM0YlMjIp",highlighted:`sql_engine.description = updated_description

agent = ReactCodeAgent(
    tools=[sql_engine],
    llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),tl=new As({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_text_to_sql.md"}}),{c(){r=M("meta"),al=n(),el=M("p"),Ml=n(),i(T.$$.fragment),pl=n(),i(m.$$.fragment),yl=n(),i(w.$$.fragment),il=n(),I=M("p"),I.innerHTML=Dl,ol=n(),C=M("p"),C.innerHTML=Kl,jl=n(),h=M("p"),h.innerHTML=Pl,Ul=n(),b=M("p"),b.textContent=Ol,cl=n(),d=M("p"),d.innerHTML=ls,Jl=n(),f=M("p"),f.textContent=ss,ul=n(),i(g.$$.fragment),rl=n(),i(B.$$.fragment),Tl=n(),i(Q.$$.fragment),ml=n(),q=M("p"),q.textContent=ts,wl=n(),i(A.$$.fragment),Il=n(),Z=M("pre"),Z.textContent=es,Cl=n(),i(W.$$.fragment),hl=n(),R=M("p"),R.textContent=ns,bl=n(),S=M("p"),S.innerHTML=as,dl=n(),i(E.$$.fragment),fl=n(),$=M("pre"),$.textContent=Ms,gl=n(),N=M("p"),N.innerHTML=ps,Bl=n(),v=M("ul"),v.innerHTML=ys,Ql=n(),i(H.$$.fragment),ql=n(),V=M("p"),V.textContent=is,Al=n(),G=M("p"),G.innerHTML=os,Zl=n(),k=M("p"),k.innerHTML=js,Wl=n(),i(_.$$.fragment),Rl=n(),i(x.$$.fragment),Sl=n(),i(X.$$.fragment),El=n(),Y=M("p"),Y.textContent=Us,$l=n(),F=M("p"),F.innerHTML=cs,Nl=n(),i(L.$$.fragment),vl=n(),z=M("p"),z.innerHTML=Js,Hl=n(),i(D.$$.fragment),Vl=n(),K=M("pre"),K.textContent=us,Gl=n(),P=M("p"),P.innerHTML=rs,kl=n(),i(O.$$.fragment),_l=n(),ll=M("p"),ll.textContent=Ts,xl=n(),sl=M("p"),sl.textContent=ms,Xl=n(),i(tl.$$.fragment),Yl=n(),nl=M("p"),this.h()},l(l){const s=gs("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(t),al=a(l),el=p(l,"P",{}),ws(el).forEach(t),Ml=a(l),o(T.$$.fragment,l),pl=a(l),o(m.$$.fragment,l),yl=a(l),o(w.$$.fragment,l),il=a(l),I=p(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-w1hogd"&&(I.innerHTML=Dl),ol=a(l),C=p(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1kzip2m"&&(C.innerHTML=Kl),jl=a(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-s9giff"&&(h.innerHTML=Pl),Ul=a(l),b=p(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1yq44h6"&&(b.textContent=Ol),cl=a(l),d=p(l,"P",{"data-svelte-h":!0}),y(d)!=="svelte-10z3rx4"&&(d.innerHTML=ls),Jl=a(l),f=p(l,"P",{"data-svelte-h":!0}),y(f)!=="svelte-ox2w5p"&&(f.textContent=ss),ul=a(l),o(g.$$.fragment,l),rl=a(l),o(B.$$.fragment,l),Tl=a(l),o(Q.$$.fragment,l),ml=a(l),q=p(l,"P",{"data-svelte-h":!0}),y(q)!=="svelte-vrancr"&&(q.textContent=ts),wl=a(l),o(A.$$.fragment,l),Il=a(l),Z=p(l,"PRE",{"data-svelte-h":!0}),y(Z)!=="svelte-jbb28p"&&(Z.textContent=es),Cl=a(l),o(W.$$.fragment,l),hl=a(l),R=p(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1iymuye"&&(R.textContent=ns),bl=a(l),S=p(l,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1vaxqe4"&&(S.innerHTML=as),dl=a(l),o(E.$$.fragment,l),fl=a(l),$=p(l,"PRE",{"data-svelte-h":!0}),y($)!=="svelte-1pz02dc"&&($.textContent=Ms),gl=a(l),N=p(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-7y2etl"&&(N.innerHTML=ps),Bl=a(l),v=p(l,"UL",{"data-svelte-h":!0}),y(v)!=="svelte-ciujzo"&&(v.innerHTML=ys),Ql=a(l),o(H.$$.fragment,l),ql=a(l),V=p(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-fykgvz"&&(V.textContent=is),Al=a(l),G=p(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-suwmw6"&&(G.innerHTML=os),Zl=a(l),k=p(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-fo5zjp"&&(k.innerHTML=js),Wl=a(l),o(_.$$.fragment,l),Rl=a(l),o(x.$$.fragment,l),Sl=a(l),o(X.$$.fragment,l),El=a(l),Y=p(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-15yz8gi"&&(Y.textContent=Us),$l=a(l),F=p(l,"P",{"data-svelte-h":!0}),y(F)!=="svelte-1l1nhz2"&&(F.innerHTML=cs),Nl=a(l),o(L.$$.fragment,l),vl=a(l),z=p(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-xsp927"&&(z.innerHTML=Js),Hl=a(l),o(D.$$.fragment,l),Vl=a(l),K=p(l,"PRE",{"data-svelte-h":!0}),y(K)!=="svelte-d75mf2"&&(K.textContent=us),Gl=a(l),P=p(l,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1npnq3m"&&(P.innerHTML=rs),kl=a(l),o(O.$$.fragment,l),_l=a(l),ll=p(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-4etgcn"&&(ll.textContent=Ts),xl=a(l),sl=p(l,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-7shr5l"&&(sl.textContent=ms),Xl=a(l),o(tl.$$.fragment,l),Yl=a(l),nl=p(l,"P",{}),ws(nl).forEach(t),this.h()},h(){Is(r,"name","hf:doc:metadata"),Is(r,"content",Ws)},m(l,s){Bs(document.head,r),e(l,al,s),e(l,el,s),e(l,Ml,s),j(T,l,s),e(l,pl,s),j(m,l,s),e(l,yl,s),j(w,l,s),e(l,il,s),e(l,I,s),e(l,ol,s),e(l,C,s),e(l,jl,s),e(l,h,s),e(l,Ul,s),e(l,b,s),e(l,cl,s),e(l,d,s),e(l,Jl,s),e(l,f,s),e(l,ul,s),j(g,l,s),e(l,rl,s),j(B,l,s),e(l,Tl,s),j(Q,l,s),e(l,ml,s),e(l,q,s),e(l,wl,s),j(A,l,s),e(l,Il,s),e(l,Z,s),e(l,Cl,s),j(W,l,s),e(l,hl,s),e(l,R,s),e(l,bl,s),e(l,S,s),e(l,dl,s),j(E,l,s),e(l,fl,s),e(l,$,s),e(l,gl,s),e(l,N,s),e(l,Bl,s),e(l,v,s),e(l,Ql,s),j(H,l,s),e(l,ql,s),e(l,V,s),e(l,Al,s),e(l,G,s),e(l,Zl,s),e(l,k,s),e(l,Wl,s),j(_,l,s),e(l,Rl,s),j(x,l,s),e(l,Sl,s),j(X,l,s),e(l,El,s),e(l,Y,s),e(l,$l,s),e(l,F,s),e(l,Nl,s),j(L,l,s),e(l,vl,s),e(l,z,s),e(l,Hl,s),j(D,l,s),e(l,Vl,s),e(l,K,s),e(l,Gl,s),e(l,P,s),e(l,kl,s),j(O,l,s),e(l,_l,s),e(l,ll,s),e(l,xl,s),e(l,sl,s),e(l,Xl,s),j(tl,l,s),e(l,Yl,s),e(l,nl,s),Fl=!0},p:hs,i(l){Fl||(U(T.$$.fragment,l),U(m.$$.fragment,l),U(w.$$.fragment,l),U(g.$$.fragment,l),U(B.$$.fragment,l),U(Q.$$.fragment,l),U(A.$$.fragment,l),U(W.$$.fragment,l),U(E.$$.fragment,l),U(H.$$.fragment,l),U(_.$$.fragment,l),U(x.$$.fragment,l),U(X.$$.fragment,l),U(L.$$.fragment,l),U(D.$$.fragment,l),U(O.$$.fragment,l),U(tl.$$.fragment,l),Fl=!0)},o(l){c(T.$$.fragment,l),c(m.$$.fragment,l),c(w.$$.fragment,l),c(g.$$.fragment,l),c(B.$$.fragment,l),c(Q.$$.fragment,l),c(A.$$.fragment,l),c(W.$$.fragment,l),c(E.$$.fragment,l),c(H.$$.fragment,l),c(_.$$.fragment,l),c(x.$$.fragment,l),c(X.$$.fragment,l),c(L.$$.fragment,l),c(D.$$.fragment,l),c(O.$$.fragment,l),c(tl.$$.fragment,l),Fl=!1},d(l){l&&(t(al),t(el),t(Ml),t(pl),t(yl),t(il),t(I),t(ol),t(C),t(jl),t(h),t(Ul),t(b),t(cl),t(d),t(Jl),t(f),t(ul),t(rl),t(Tl),t(ml),t(q),t(wl),t(Il),t(Z),t(Cl),t(hl),t(R),t(bl),t(S),t(dl),t(fl),t($),t(gl),t(N),t(Bl),t(v),t(Ql),t(ql),t(V),t(Al),t(G),t(Zl),t(k),t(Wl),t(Rl),t(Sl),t(El),t(Y),t($l),t(F),t(Nl),t(vl),t(z),t(Hl),t(Vl),t(K),t(Gl),t(P),t(kl),t(_l),t(ll),t(xl),t(sl),t(Xl),t(Yl),t(nl)),t(r),J(T,l),J(m,l),J(w,l),J(g,l),J(B,l),J(Q,l),J(A,l),J(W,l),J(E,l),J(H,l),J(_,l),J(x,l),J(X,l),J(L,l),J(D,l),J(O,l),J(tl,l)}}}const Ws='{"title":"用于文本到 SQL 的智能体，带有自动错误修正功能","local":"用于文本到-sql-的智能体带有自动错误修正功能","sections":[{"title":"设置 SQL 表","local":"设置-sql-表","sections":[],"depth":2},{"title":"构建我们的智能体","local":"构建我们的智能体","sections":[],"depth":2},{"title":"提高难度：表格连接","local":"提高难度表格连接","sections":[],"depth":2}],"depth":1}';function Rs(zl){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends ds{constructor(r){super(),fs(this,r,Rs,Zs,Cs,{})}}export{Hs as component};
