import{s as Pt,n as Dt,o as Kt}from"../chunks/scheduler.1f027d5a.js";import{S as Ot,i as le,e as p,s as n,c as M,h as se,a as i,d as t,b as a,f as qt,g as j,j as u,k as Lt,l as te,m as e,n as m,t as d,o as c,p as o}from"../chunks/index.6117a65d.js";import{C as ee}from"../chunks/CopyLLMTxtMenu.0ff8411a.js";import{D as ne,C as r}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as T,E as ae}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function pe(dt){let y,_l,Ql,Xl,h,Yl,w,Sl,J,Hl,b,ct='<em>作者: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',zl,U,Fl,g,ot="我有一个数据集，我想为其嵌入语义搜索（或问答，或 RAG），我希望以最简单的方式嵌入这个数据集并将其放入一个新的数据集中。",ql,f,Ll,$,ut='我将使用我最喜欢的 subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a> 中的数据集。因为它有很长的条目，同时使用新的 <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> 嵌入模型，因为它有 8k 的上下文长度。还将使用 <a href="https://huggingface.co/inference-endpoints" rel="nofollow">推理端点</a> 部署这个，以节省时间和金钱。要跟随这个教程，你需要<strong>已经添加了支付方式</strong>。如果你还没有添加，可以在 <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">账单</a> 中添加。为了使操作更加简单，我将完全基于 API 进行操作。',Pl,C,rt='为了使这个过程更快，我将使用 <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> 镜像。这有许多好处，比如：',Dl,I,Tt="<li>无需模型图编译步骤</li> <li>Docker 镜像小，启动时间快。真正的无服务器！</li> <li>基于 token 的动态批处理</li> <li>使用 Flash 注意力机制、Candle 和 cuBLASLt 优化的 transformers 代码进行推理</li> <li>Safetensors 权重加载</li> <li>生产就绪（使用 Open Telemetry 进行分布式跟踪，Prometheus 指标）</li>",Kl,A,yt='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Ol,B,ls,k,ss,Z,ts,W,es,G,ns,R,ht=`<code>DATASET_IN</code> 你文本数据的位置
<code>DATASET_OUT</code> 你的嵌入储存的位置`,as,E,wt="注意：我将 <code>MAX_WORKERS</code> 设置为 5，因为 <code>jina-embeddings-v2</code> 对内存的需求较大。",ps,N,Ms,V,Jt="Hugging Face 在推理端点中提供了多种 GPU 供选择。下面以表格形式呈现：",is,x,bt="<thead><tr><th>GPU</th> <th>实例类型</th> <th>实例大小</th> <th>vRAM</th></tr></thead> <tbody><tr><td>1x Nvidia Tesla T4</td> <td>g4dn.xlarge</td> <td>small</td> <td>16GB</td></tr> <tr><td>4x Nvidia Tesla T4</td> <td>g4dn.12xlarge</td> <td>large</td> <td>64GB</td></tr> <tr><td>1x Nvidia A10G</td> <td>g5.2xlarge</td> <td>medium</td> <td>24GB</td></tr> <tr><td>4x Nvidia A10G</td> <td>g5.12xlarge</td> <td>xxlarge</td> <td>96GB</td></tr> <tr><td>1x Nvidia A100*</td> <td>p4de</td> <td>xlarge</td> <td>80GB</td></tr> <tr><td>2x Nvidia A100*</td> <td>p4de</td> <td>2xlarge</td> <td>160GB</td></tr></tbody>",js,Q,Ut="*注意，对于 A100 的机型你需要发邮件给我们来获取权限。",ms,v,ds,_,cs,X,gt="有些用户可能会在组织中注册支付信息。这肯能会使你的支付方式链接组织。",os,Y,ft="如果你想使用你自己的用户名，请将其留空。",us,S,rs,H,$t=`What is your Hugging Face 🤗 username or organization? (with an added payment method) ········
`,Ts,z,ys,F,hs,q,ws,L,Js,P,bs,D,Ct='我们将使用 <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> 来创建一个 <a href="https://huggingface.co/inference-endpoints" rel="nofollow">推理端点</a>。主要有以下几个好处：',Us,K,It="<li>方便（无需点击）</li> <li>可重复（我们有代码可以轻松运行它）</li> <li>更便宜（无需花费时间等待加载，并且可以自动关闭）</li>",gs,O,fs,ll,At="这里有几个设计选择：",$s,sl,Bt='<li>像之前所说，我们使用 <code>jinaai/jina-embeddings-v2-base-en</code> 作为我们的模型。<ul><li>为了可复现性，我们将它固定到一个特定的修订版本。</li></ul></li> <li>如果你对更多模型感兴趣，可以查看支持<a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">列表</a>。<ul><li>请注意，大多数嵌入模型都是基于 BERT 架构的。</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> 是根据我们的工作数量和嵌入模型的上下文窗口来选择的。</li> <li><code>type=&quot;protected&quot;</code> 利用的是推理端点详细说明的安全功能。</li> <li>我使用 <strong>1x Nvidia A10</strong>，因为 <code>jina-embeddings-v2</code> 对内存的需求很大（记住 8k 的上下文长度）。</li> <li>如果你有高工作负载的需求，你应该考虑进一步调整 <code>MAX_BATCH_TOKENS</code> 和 <code>MAX_CONCURRENT_REQUESTS</code>。</li>',Cs,tl,Is,el,As,nl,kt=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,Bs,al,Zt="当我们使用 <code>endpoint.client.post</code> 时，我们得到一个字节字符串。这有点繁琐，因为我们需要将这个字节字符串转换为一个 <code>np.array</code>，但这只是 Python 中的几行快速代码。",ks,pl,Zs,Ml,Wt="你可能遇到超过上下文长度的输入。在这种情况下，需要你来处理它们。在我的情况下，我更愿意截断而不是出现错误。让我们测试一下这是否有效。",Ws,il,Gs,jl,Gt=`The length of the embedding_input is: 300000
`,Rs,ml,Es,dl,Rt="在这里，我发送一个文档，用嵌入更新它，然后返回它。这是与 <code>MAX_WORKERS</code> 并行的发生的。",Ns,cl,Vs,ol,xs,ul,Et=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,Qs,rl,vs,Tl,Nt="现在我们已经完成了嵌入，让我们暂停端点，以免产生任何额外费用，同时这也允许我们分析成本。",_s,yl,Xs,hl,Vt=`Endpoint Status: paused
`,Ys,wl,Ss,Jl,xt="现在我们的文档已经更新了我们想要的嵌入。首先我们需要将其转换回 <code>Dataset</code> 格式。我发现从字典列表 -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code> 这条路径最为简单。",Hs,bl,zs,Ul,Qt="我默认将其上传到用户的账户（而不是上传到组织），但你可以通过在 <code>repo_id</code> 中设置用户或在配置中通过设置 <code>DATASET_OUT</code> 来自由推送到任何你想要的地方。",Fs,gl,qs,fl,Ls,$l,vt=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,Ps,Cl,Ds,Il,_t="<li>前往下面打印的 <code>dashboard_url</code></li> <li>点击使用与成本 (Usage &amp; Cost) 标签</li> <li>查看你已经花费了多少</li>",Ks,Al,Os,Bl,Xt=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,lt,kl,st,Zl,Yt=`Hit enter to continue with the notebook
`,tt,Wl,St="我们可以看到只花了 <code>$0.04</code> !",et,Gl,nt,Rl,Ht="现在我们已经完成了，不再需要我们的端点了。我们可以以编程方式删除端点。",at,El,zt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',pt,Nl,Mt,Vl,Ft=`Endpoint deleted successfully
`,it,xl,jt,vl,mt;return h=new ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),w=new ee({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new T({props:{title:"怎么使用推理端点去嵌入文档",local:"怎么使用推理端点去嵌入文档",headingTag:"h1"}}),U=new T({props:{title:"目标",local:"目标",headingTag:"h2"}}),f=new T({props:{title:"方法",local:"方法",headingTag:"h2"}}),B=new T({props:{title:"环境(Requirements)",local:"环境requirements",headingTag:"h2"}}),k=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),Z=new T({props:{title:"导入包",local:"导入包",headingTag:"h2"}}),W=new r({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),G=new T({props:{title:"设置(Config)",local:"设置config",headingTag:"h2"}}),N=new r({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCdkZXJlay10aG9tYXMlMkZkYXRhc2V0LWNyZWF0b3ItcmVkZGl0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyclMEFEQVRBU0VUX09VVCUyMCUzRCUyMCUyMnByb2Nlc3NlZC1zdWJzZXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBRU5EUE9JTlRfTkFNRSUyMCUzRCUyMCUyMmJvcnUtamluYS1lbWJlZGRpbmdzLWRlbW8taWUlMjIlMEElMEFNQVhfV09SS0VSUyUyMCUzRCUyMDUlMjAlMjAlMjMlMjBUaGlzJTIwaXMlMjBmb3IlMjBob3clMjBtYW55JTIwYXN5bmMlMjB3b3JrZXJzJTIweW91JTIwd2FudC4lMjBDaG9vc2UlMjBiYXNlZCUyMG9uJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjBoYXJkd2FyZSUyMCUwQVJPV19DT1VOVCUyMCUzRCUyMDEwMCUyMCUyMCUyMyUyMENob29zZSUyME5vbmUlMjB0byUyMHVzZSUyMGFsbCUyMHJvd3MlMkMlMjBJbSUyMHVzaW5nJTIwMTAwJTIwanVzdCUyMGZvciUyMGElMjBkZW1v",highlighted:`DATASET_IN = <span class="hljs-string">&#x27;derek-thomas/dataset-creator-reddit-bestofredditorupdates&#x27;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware </span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),v=new r({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTNEJTIyYXdzJTIyJTBBUkVHSU9OJTNEJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUzRCUyMm1lZGl1bSUyMiUwQUlOU1RBTkNFX1RZUEUlM0QlMjJnNS4yeGxhcmdlJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR=<span class="hljs-string">&quot;aws&quot;</span>
REGION=<span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE=<span class="hljs-string">&quot;medium&quot;</span>
INSTANCE_TYPE=<span class="hljs-string">&quot;g5.2xlarge&quot;</span>`,wrap:!1}}),_=new r({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),S=new r({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiduYW1lJyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>who = whoami()
<span class="hljs-meta">&gt;&gt;&gt; </span>organization = getpass(prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&#x27;name&#x27;</span>]`,wrap:!1}}),z=new T({props:{title:"获取数据",local:"获取数据",headingTag:"h2"}}),F=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIndHJhaW4nJTVE",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&#x27;train&#x27;</span>]`,wrap:!1}}),q=new r({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1Qid0cmFpbiclNUQudG9fcGFuZGFzKCkudG9fZGljdCgncmVjb3JkcycpJTVCJTNBUk9XX0NPVU5UJTVEJTBBbGVuKGRvY3VtZW50cyklMkMlMjBkb2N1bWVudHMlNUIwJTVE",highlighted:`documents = dataset[<span class="hljs-string">&#x27;train&#x27;</span>].to_pandas().to_dict(<span class="hljs-string">&#x27;records&#x27;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new T({props:{title:"推理端点",local:"推理端点",headingTag:"h1"}}),P=new T({props:{title:"创建推理端点",local:"创建推理端点",headingTag:"h2"}}),O=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Loaded endpoint&#x27;</span>)`,wrap:!1}}),tl=new T({props:{title:"等待直到它运行起来",local:"等待直到它运行起来",headingTag:"h2"}}),el=new r({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),pl=new r({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJ1RoaXMlMjBzb3VuZCUyMHRyYWNrJTIwd2FzJTIwYmVhdXRpZnVsISUyMEl0JTIwcGFpbnRzJTIwdGhlJTIwc2VuZXJ5JTIwaW4lMjB5b3VyJTIwbWluZCUyMHNvJTIwd2VsbCUyMEklMjB3b3VsZCUyMHJlY29tZW5kJTIwaXQlMjBldmVuJTIwdG8lMjBwZW9wbGUlMjB3aG8lMjBoYXRlJTIwdmlkLiUyMGdhbWUlMjBtdXNpYyEnJTJDJTIwJ3RydW5jYXRlJyUzQSUyMFRydWUlN0QlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwbnAuYXJyYXkoanNvbi5sb2FkcyhyZXNwb25zZS5kZWNvZGUoKSkpJTBBcmVzcG9uc2UlNUIwJTVEJTVCJTNBMjAlNUQ=",highlighted:`response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&#x27;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&#x27;</span>, <span class="hljs-string">&#x27;truncate&#x27;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),il=new r({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJ1RoaXMlMjBpbnB1dCUyMHdpbGwlMjBnZXQlMjBtdWx0aXBsaWVkJyUyMColMjAxMDAwMCUwQXByaW50KGYnVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJyklMEFyZXNwb25zZSUyMCUzRCUyMGVuZHBvaW50LmNsaWVudC5wb3N0KGpzb24lM0QlN0IlMjJpbnB1dHMlMjIlM0ElMjBlbWJlZGRpbmdfaW5wdXQlMkMlMjAndHJ1bmNhdGUnJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&#x27;This input will get multiplied&#x27;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&#x27;truncate&#x27;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),ml=new T({props:{title:"获取嵌入",local:"获取嵌入",headingTag:"h1"}}),cl=new r({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUInY29udGVudCclNUQlMkMlMjAndHJ1bmNhdGUnJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwbnAuYXJyYXkoanNvbi5sb2FkcyhyZXN1bHQuZGVjb2RlKCkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3VtZW50JTVCJ2VtYmVkZGluZyclNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&#x27;content&#x27;</span>], <span class="hljs-string">&#x27;truncate&#x27;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&#x27;embedding&#x27;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]
    
    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),ol=new r({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJ2VtYmVkZGluZyclMjBpbiUyMGRvY3VtZW50LmtleXMoKSUyMGFuZCUyMGxlbihkb2N1bWVudCU1QidlbWJlZGRpbmcnJTVEKSUyMCUzRCUzRCUyMDc2OCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvdW50JTIwJTJCJTNEJTIwMSUwQXByaW50KGYnRW1iZWRkaW5ncyUyMCUzRCUyMCU3QmNvdW50JTdEJTIwZG9jdW1lbnRzJTIwJTNEJTIwJTdCbGVuKGRvY3VtZW50cyklN0QnKSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;embedding&#x27;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&#x27;embedding&#x27;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&#x27;</span>)

            
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),rl=new T({props:{title:"暂停推理端点",local:"暂停推理端点",headingTag:"h2"}}),yl=new r({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),wl=new T({props:{title:"将更新后的数据集推送到 Hub",local:"将更新后的数据集推送到-hub",headingTag:"h1"}}),bl=new r({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJ3RyYWluJyUzQSUyMERhdGFzZXQuZnJvbV9wYW5kYXMoZGYpJTdEKQ==",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&#x27;train&#x27;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),gl=new r({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),fl=new r({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),Cl=new T({props:{title:"分析使用情况",local:"分析使用情况",headingTag:"h1"}}),Al=new r({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYnaHR0cHMlM0ElMkYlMkZ1aS5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY28lMkYlN0JuYW1lc3BhY2UlN0QlMkZlbmRwb2ludHMlMkYlN0JFTkRQT0lOVF9OQU1FJTdEJyUwQXByaW50KGRhc2hib2FyZF91cmwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&#x27;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),kl=new r({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),Gl=new T({props:{title:"删除端点",local:"删除端点",headingTag:"h1"}}),Nl=new r({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCgnRW5kcG9pbnQlMjBkZWxldGVkJTIwc3VjY2Vzc2Z1bGx5JyklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJ0RlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseScp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Endpoint deleted successfully&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Delete Endpoint in manually&#x27;</span>)`,wrap:!1}}),xl=new ae({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/automatic_embedding_tei_inference_endpoints.md"}}),{c(){y=p("meta"),_l=n(),Ql=p("p"),Xl=n(),M(h.$$.fragment),Yl=n(),M(w.$$.fragment),Sl=n(),M(J.$$.fragment),Hl=n(),b=p("p"),b.innerHTML=ct,zl=n(),M(U.$$.fragment),Fl=n(),g=p("p"),g.textContent=ot,ql=n(),M(f.$$.fragment),Ll=n(),$=p("p"),$.innerHTML=ut,Pl=n(),C=p("p"),C.innerHTML=rt,Dl=n(),I=p("ul"),I.innerHTML=Tt,Kl=n(),A=p("p"),A.innerHTML=yt,Ol=n(),M(B.$$.fragment),ls=n(),M(k.$$.fragment),ss=n(),M(Z.$$.fragment),ts=n(),M(W.$$.fragment),es=n(),M(G.$$.fragment),ns=n(),R=p("p"),R.innerHTML=ht,as=n(),E=p("p"),E.innerHTML=wt,ps=n(),M(N.$$.fragment),Ms=n(),V=p("p"),V.textContent=Jt,is=n(),x=p("table"),x.innerHTML=bt,js=n(),Q=p("p"),Q.textContent=Ut,ms=n(),M(v.$$.fragment),ds=n(),M(_.$$.fragment),cs=n(),X=p("p"),X.textContent=gt,os=n(),Y=p("p"),Y.textContent=ft,us=n(),M(S.$$.fragment),rs=n(),H=p("pre"),H.textContent=$t,Ts=n(),M(z.$$.fragment),ys=n(),M(F.$$.fragment),hs=n(),M(q.$$.fragment),ws=n(),M(L.$$.fragment),Js=n(),M(P.$$.fragment),bs=n(),D=p("p"),D.innerHTML=Ct,Us=n(),K=p("ul"),K.innerHTML=It,gs=n(),M(O.$$.fragment),fs=n(),ll=p("p"),ll.textContent=At,$s=n(),sl=p("ul"),sl.innerHTML=Bt,Cs=n(),M(tl.$$.fragment),Is=n(),M(el.$$.fragment),As=n(),nl=p("pre"),nl.textContent=kt,Bs=n(),al=p("p"),al.innerHTML=Zt,ks=n(),M(pl.$$.fragment),Zs=n(),Ml=p("p"),Ml.textContent=Wt,Ws=n(),M(il.$$.fragment),Gs=n(),jl=p("pre"),jl.textContent=Gt,Rs=n(),M(ml.$$.fragment),Es=n(),dl=p("p"),dl.innerHTML=Rt,Ns=n(),M(cl.$$.fragment),Vs=n(),M(ol.$$.fragment),xs=n(),ul=p("pre"),ul.textContent=Et,Qs=n(),M(rl.$$.fragment),vs=n(),Tl=p("p"),Tl.textContent=Nt,_s=n(),M(yl.$$.fragment),Xs=n(),hl=p("pre"),hl.textContent=Vt,Ys=n(),M(wl.$$.fragment),Ss=n(),Jl=p("p"),Jl.innerHTML=xt,Hs=n(),M(bl.$$.fragment),zs=n(),Ul=p("p"),Ul.innerHTML=Qt,Fs=n(),M(gl.$$.fragment),qs=n(),M(fl.$$.fragment),Ls=n(),$l=p("pre"),$l.textContent=vt,Ps=n(),M(Cl.$$.fragment),Ds=n(),Il=p("ol"),Il.innerHTML=_t,Ks=n(),M(Al.$$.fragment),Os=n(),Bl=p("pre"),Bl.textContent=Xt,lt=n(),M(kl.$$.fragment),st=n(),Zl=p("pre"),Zl.textContent=Yt,tt=n(),Wl=p("p"),Wl.innerHTML=St,et=n(),M(Gl.$$.fragment),nt=n(),Rl=p("p"),Rl.textContent=Ht,at=n(),El=p("p"),El.innerHTML=zt,pt=n(),M(Nl.$$.fragment),Mt=n(),Vl=p("pre"),Vl.textContent=Ft,it=n(),M(xl.$$.fragment),jt=n(),vl=p("p"),this.h()},l(l){const s=se("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(t),_l=a(l),Ql=i(l,"P",{}),qt(Ql).forEach(t),Xl=a(l),j(h.$$.fragment,l),Yl=a(l),j(w.$$.fragment,l),Sl=a(l),j(J.$$.fragment,l),Hl=a(l),b=i(l,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1w9xzi"&&(b.innerHTML=ct),zl=a(l),j(U.$$.fragment,l),Fl=a(l),g=i(l,"P",{"data-svelte-h":!0}),u(g)!=="svelte-11ferzq"&&(g.textContent=ot),ql=a(l),j(f.$$.fragment,l),Ll=a(l),$=i(l,"P",{"data-svelte-h":!0}),u($)!=="svelte-1bfbx2r"&&($.innerHTML=ut),Pl=a(l),C=i(l,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1dh13d5"&&(C.innerHTML=rt),Dl=a(l),I=i(l,"UL",{"data-svelte-h":!0}),u(I)!=="svelte-32bf82"&&(I.innerHTML=Tt),Kl=a(l),A=i(l,"P",{"data-svelte-h":!0}),u(A)!=="svelte-12ly3c2"&&(A.innerHTML=yt),Ol=a(l),j(B.$$.fragment,l),ls=a(l),j(k.$$.fragment,l),ss=a(l),j(Z.$$.fragment,l),ts=a(l),j(W.$$.fragment,l),es=a(l),j(G.$$.fragment,l),ns=a(l),R=i(l,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1s6k4ux"&&(R.innerHTML=ht),as=a(l),E=i(l,"P",{"data-svelte-h":!0}),u(E)!=="svelte-zys9gx"&&(E.innerHTML=wt),ps=a(l),j(N.$$.fragment,l),Ms=a(l),V=i(l,"P",{"data-svelte-h":!0}),u(V)!=="svelte-gdta8b"&&(V.textContent=Jt),is=a(l),x=i(l,"TABLE",{"data-svelte-h":!0}),u(x)!=="svelte-17os0b1"&&(x.innerHTML=bt),js=a(l),Q=i(l,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1fw5clw"&&(Q.textContent=Ut),ms=a(l),j(v.$$.fragment,l),ds=a(l),j(_.$$.fragment,l),cs=a(l),X=i(l,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1b5lb69"&&(X.textContent=gt),os=a(l),Y=i(l,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1qjkre5"&&(Y.textContent=ft),us=a(l),j(S.$$.fragment,l),rs=a(l),H=i(l,"PRE",{"data-svelte-h":!0}),u(H)!=="svelte-19lh5zm"&&(H.textContent=$t),Ts=a(l),j(z.$$.fragment,l),ys=a(l),j(F.$$.fragment,l),hs=a(l),j(q.$$.fragment,l),ws=a(l),j(L.$$.fragment,l),Js=a(l),j(P.$$.fragment,l),bs=a(l),D=i(l,"P",{"data-svelte-h":!0}),u(D)!=="svelte-hku60d"&&(D.innerHTML=Ct),Us=a(l),K=i(l,"UL",{"data-svelte-h":!0}),u(K)!=="svelte-1wudrob"&&(K.innerHTML=It),gs=a(l),j(O.$$.fragment,l),fs=a(l),ll=i(l,"P",{"data-svelte-h":!0}),u(ll)!=="svelte-1ul0qyr"&&(ll.textContent=At),$s=a(l),sl=i(l,"UL",{"data-svelte-h":!0}),u(sl)!=="svelte-9ob4d1"&&(sl.innerHTML=Bt),Cs=a(l),j(tl.$$.fragment,l),Is=a(l),j(el.$$.fragment,l),As=a(l),nl=i(l,"PRE",{"data-svelte-h":!0}),u(nl)!=="svelte-19liytu"&&(nl.textContent=kt),Bs=a(l),al=i(l,"P",{"data-svelte-h":!0}),u(al)!=="svelte-12l6vzi"&&(al.innerHTML=Zt),ks=a(l),j(pl.$$.fragment,l),Zs=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),u(Ml)!=="svelte-x6ui04"&&(Ml.textContent=Wt),Ws=a(l),j(il.$$.fragment,l),Gs=a(l),jl=i(l,"PRE",{"data-svelte-h":!0}),u(jl)!=="svelte-11ebe9s"&&(jl.textContent=Gt),Rs=a(l),j(ml.$$.fragment,l),Es=a(l),dl=i(l,"P",{"data-svelte-h":!0}),u(dl)!=="svelte-yr8pow"&&(dl.innerHTML=Rt),Ns=a(l),j(cl.$$.fragment,l),Vs=a(l),j(ol.$$.fragment,l),xs=a(l),ul=i(l,"PRE",{"data-svelte-h":!0}),u(ul)!=="svelte-ff4u6w"&&(ul.textContent=Et),Qs=a(l),j(rl.$$.fragment,l),vs=a(l),Tl=i(l,"P",{"data-svelte-h":!0}),u(Tl)!=="svelte-5f3lhv"&&(Tl.textContent=Nt),_s=a(l),j(yl.$$.fragment,l),Xs=a(l),hl=i(l,"PRE",{"data-svelte-h":!0}),u(hl)!=="svelte-v5xolv"&&(hl.textContent=Vt),Ys=a(l),j(wl.$$.fragment,l),Ss=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),u(Jl)!=="svelte-6kwgar"&&(Jl.innerHTML=xt),Hs=a(l),j(bl.$$.fragment,l),zs=a(l),Ul=i(l,"P",{"data-svelte-h":!0}),u(Ul)!=="svelte-1uolelw"&&(Ul.innerHTML=Qt),Fs=a(l),j(gl.$$.fragment,l),qs=a(l),j(fl.$$.fragment,l),Ls=a(l),$l=i(l,"PRE",{"data-svelte-h":!0}),u($l)!=="svelte-dj57zs"&&($l.textContent=vt),Ps=a(l),j(Cl.$$.fragment,l),Ds=a(l),Il=i(l,"OL",{"data-svelte-h":!0}),u(Il)!=="svelte-gpezbg"&&(Il.innerHTML=_t),Ks=a(l),j(Al.$$.fragment,l),Os=a(l),Bl=i(l,"PRE",{"data-svelte-h":!0}),u(Bl)!=="svelte-109618w"&&(Bl.textContent=Xt),lt=a(l),j(kl.$$.fragment,l),st=a(l),Zl=i(l,"PRE",{"data-svelte-h":!0}),u(Zl)!=="svelte-1gk9phr"&&(Zl.textContent=Yt),tt=a(l),Wl=i(l,"P",{"data-svelte-h":!0}),u(Wl)!=="svelte-f3ucyx"&&(Wl.innerHTML=St),et=a(l),j(Gl.$$.fragment,l),nt=a(l),Rl=i(l,"P",{"data-svelte-h":!0}),u(Rl)!=="svelte-1tw7uc3"&&(Rl.textContent=Ht),at=a(l),El=i(l,"P",{"data-svelte-h":!0}),u(El)!=="svelte-1124toy"&&(El.innerHTML=zt),pt=a(l),j(Nl.$$.fragment,l),Mt=a(l),Vl=i(l,"PRE",{"data-svelte-h":!0}),u(Vl)!=="svelte-ulyp9n"&&(Vl.textContent=Ft),it=a(l),j(xl.$$.fragment,l),jt=a(l),vl=i(l,"P",{}),qt(vl).forEach(t),this.h()},h(){Lt(y,"name","hf:doc:metadata"),Lt(y,"content",Me)},m(l,s){te(document.head,y),e(l,_l,s),e(l,Ql,s),e(l,Xl,s),m(h,l,s),e(l,Yl,s),m(w,l,s),e(l,Sl,s),m(J,l,s),e(l,Hl,s),e(l,b,s),e(l,zl,s),m(U,l,s),e(l,Fl,s),e(l,g,s),e(l,ql,s),m(f,l,s),e(l,Ll,s),e(l,$,s),e(l,Pl,s),e(l,C,s),e(l,Dl,s),e(l,I,s),e(l,Kl,s),e(l,A,s),e(l,Ol,s),m(B,l,s),e(l,ls,s),m(k,l,s),e(l,ss,s),m(Z,l,s),e(l,ts,s),m(W,l,s),e(l,es,s),m(G,l,s),e(l,ns,s),e(l,R,s),e(l,as,s),e(l,E,s),e(l,ps,s),m(N,l,s),e(l,Ms,s),e(l,V,s),e(l,is,s),e(l,x,s),e(l,js,s),e(l,Q,s),e(l,ms,s),m(v,l,s),e(l,ds,s),m(_,l,s),e(l,cs,s),e(l,X,s),e(l,os,s),e(l,Y,s),e(l,us,s),m(S,l,s),e(l,rs,s),e(l,H,s),e(l,Ts,s),m(z,l,s),e(l,ys,s),m(F,l,s),e(l,hs,s),m(q,l,s),e(l,ws,s),m(L,l,s),e(l,Js,s),m(P,l,s),e(l,bs,s),e(l,D,s),e(l,Us,s),e(l,K,s),e(l,gs,s),m(O,l,s),e(l,fs,s),e(l,ll,s),e(l,$s,s),e(l,sl,s),e(l,Cs,s),m(tl,l,s),e(l,Is,s),m(el,l,s),e(l,As,s),e(l,nl,s),e(l,Bs,s),e(l,al,s),e(l,ks,s),m(pl,l,s),e(l,Zs,s),e(l,Ml,s),e(l,Ws,s),m(il,l,s),e(l,Gs,s),e(l,jl,s),e(l,Rs,s),m(ml,l,s),e(l,Es,s),e(l,dl,s),e(l,Ns,s),m(cl,l,s),e(l,Vs,s),m(ol,l,s),e(l,xs,s),e(l,ul,s),e(l,Qs,s),m(rl,l,s),e(l,vs,s),e(l,Tl,s),e(l,_s,s),m(yl,l,s),e(l,Xs,s),e(l,hl,s),e(l,Ys,s),m(wl,l,s),e(l,Ss,s),e(l,Jl,s),e(l,Hs,s),m(bl,l,s),e(l,zs,s),e(l,Ul,s),e(l,Fs,s),m(gl,l,s),e(l,qs,s),m(fl,l,s),e(l,Ls,s),e(l,$l,s),e(l,Ps,s),m(Cl,l,s),e(l,Ds,s),e(l,Il,s),e(l,Ks,s),m(Al,l,s),e(l,Os,s),e(l,Bl,s),e(l,lt,s),m(kl,l,s),e(l,st,s),e(l,Zl,s),e(l,tt,s),e(l,Wl,s),e(l,et,s),m(Gl,l,s),e(l,nt,s),e(l,Rl,s),e(l,at,s),e(l,El,s),e(l,pt,s),m(Nl,l,s),e(l,Mt,s),e(l,Vl,s),e(l,it,s),m(xl,l,s),e(l,jt,s),e(l,vl,s),mt=!0},p:Dt,i(l){mt||(d(h.$$.fragment,l),d(w.$$.fragment,l),d(J.$$.fragment,l),d(U.$$.fragment,l),d(f.$$.fragment,l),d(B.$$.fragment,l),d(k.$$.fragment,l),d(Z.$$.fragment,l),d(W.$$.fragment,l),d(G.$$.fragment,l),d(N.$$.fragment,l),d(v.$$.fragment,l),d(_.$$.fragment,l),d(S.$$.fragment,l),d(z.$$.fragment,l),d(F.$$.fragment,l),d(q.$$.fragment,l),d(L.$$.fragment,l),d(P.$$.fragment,l),d(O.$$.fragment,l),d(tl.$$.fragment,l),d(el.$$.fragment,l),d(pl.$$.fragment,l),d(il.$$.fragment,l),d(ml.$$.fragment,l),d(cl.$$.fragment,l),d(ol.$$.fragment,l),d(rl.$$.fragment,l),d(yl.$$.fragment,l),d(wl.$$.fragment,l),d(bl.$$.fragment,l),d(gl.$$.fragment,l),d(fl.$$.fragment,l),d(Cl.$$.fragment,l),d(Al.$$.fragment,l),d(kl.$$.fragment,l),d(Gl.$$.fragment,l),d(Nl.$$.fragment,l),d(xl.$$.fragment,l),mt=!0)},o(l){c(h.$$.fragment,l),c(w.$$.fragment,l),c(J.$$.fragment,l),c(U.$$.fragment,l),c(f.$$.fragment,l),c(B.$$.fragment,l),c(k.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(G.$$.fragment,l),c(N.$$.fragment,l),c(v.$$.fragment,l),c(_.$$.fragment,l),c(S.$$.fragment,l),c(z.$$.fragment,l),c(F.$$.fragment,l),c(q.$$.fragment,l),c(L.$$.fragment,l),c(P.$$.fragment,l),c(O.$$.fragment,l),c(tl.$$.fragment,l),c(el.$$.fragment,l),c(pl.$$.fragment,l),c(il.$$.fragment,l),c(ml.$$.fragment,l),c(cl.$$.fragment,l),c(ol.$$.fragment,l),c(rl.$$.fragment,l),c(yl.$$.fragment,l),c(wl.$$.fragment,l),c(bl.$$.fragment,l),c(gl.$$.fragment,l),c(fl.$$.fragment,l),c(Cl.$$.fragment,l),c(Al.$$.fragment,l),c(kl.$$.fragment,l),c(Gl.$$.fragment,l),c(Nl.$$.fragment,l),c(xl.$$.fragment,l),mt=!1},d(l){l&&(t(_l),t(Ql),t(Xl),t(Yl),t(Sl),t(Hl),t(b),t(zl),t(Fl),t(g),t(ql),t(Ll),t($),t(Pl),t(C),t(Dl),t(I),t(Kl),t(A),t(Ol),t(ls),t(ss),t(ts),t(es),t(ns),t(R),t(as),t(E),t(ps),t(Ms),t(V),t(is),t(x),t(js),t(Q),t(ms),t(ds),t(cs),t(X),t(os),t(Y),t(us),t(rs),t(H),t(Ts),t(ys),t(hs),t(ws),t(Js),t(bs),t(D),t(Us),t(K),t(gs),t(fs),t(ll),t($s),t(sl),t(Cs),t(Is),t(As),t(nl),t(Bs),t(al),t(ks),t(Zs),t(Ml),t(Ws),t(Gs),t(jl),t(Rs),t(Es),t(dl),t(Ns),t(Vs),t(xs),t(ul),t(Qs),t(vs),t(Tl),t(_s),t(Xs),t(hl),t(Ys),t(Ss),t(Jl),t(Hs),t(zs),t(Ul),t(Fs),t(qs),t(Ls),t($l),t(Ps),t(Ds),t(Il),t(Ks),t(Os),t(Bl),t(lt),t(st),t(Zl),t(tt),t(Wl),t(et),t(nt),t(Rl),t(at),t(El),t(pt),t(Mt),t(Vl),t(it),t(jt),t(vl)),t(y),o(h,l),o(w,l),o(J,l),o(U,l),o(f,l),o(B,l),o(k,l),o(Z,l),o(W,l),o(G,l),o(N,l),o(v,l),o(_,l),o(S,l),o(z,l),o(F,l),o(q,l),o(L,l),o(P,l),o(O,l),o(tl,l),o(el,l),o(pl,l),o(il,l),o(ml,l),o(cl,l),o(ol,l),o(rl,l),o(yl,l),o(wl,l),o(bl,l),o(gl,l),o(fl,l),o(Cl,l),o(Al,l),o(kl,l),o(Gl,l),o(Nl,l),o(xl,l)}}}const Me='{"title":"怎么使用推理端点去嵌入文档","local":"怎么使用推理端点去嵌入文档","sections":[{"title":"目标","local":"目标","sections":[],"depth":2},{"title":"方法","local":"方法","sections":[],"depth":2},{"title":"环境(Requirements)","local":"环境requirements","sections":[],"depth":2},{"title":"导入包","local":"导入包","sections":[],"depth":2},{"title":"设置(Config)","local":"设置config","sections":[],"depth":2},{"title":"获取数据","local":"获取数据","sections":[],"depth":2}],"depth":1}';function ie(dt){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends Ot{constructor(y){super(),le(this,y,ie,pe,Pt,{})}}export{ue as component};
