import{s as Ts,o as fs,n as gs}from"../chunks/scheduler.355ac1c8.js";import{S as Cs,i as Zs,e as m,s as n,c as i,h as ks,a as o,d as s,b as a,f as hs,g as r,j as u,k as Js,l as Bs,m as t,n as p,t as d,o as M,p as c,q as Is,r as $s}from"../chunks/index.433eedb0.js";import{T as js}from"../chunks/Tip.2b2f89d9.js";import{C as Gs,H as Ge,E as vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.861063c8.js";import{Y as Us}from"../chunks/Youtube.3325c198.js";import{C as y}from"../chunks/CodeBlock.35909010.js";import{C as Ws}from"../chunks/CourseFloatingBanner.78a39c14.js";function Xs(Be){let w,b="✏️ <strong>Probier es selbt!</strong> Ändere die vorherige Trainingsschleife, um dein Modell auf dem SST-2-Datensatz fein zu tunen.";return{c(){w=m("p"),w.innerHTML=b},l(h){w=o(h,"P",{"data-svelte-h":!0}),u(w)!=="svelte-10uj33w"&&(w.innerHTML=b)},m(h,Ie){t(h,w,Ie)},p:gs,d(h){h&&s(w)}}}function zs(Be){let w;return{c(){w=Is('⚠️ Um von dem Geschwindigkeitsvorteil der Cloud TPUs zu profitieren, empfehlen wir, deine Samples mit den Argumenten `padding="max_length"` und `max_length` des Tokenizers auf eine feste Länge aufzufüllen.')},l(b){w=$s(b,'⚠️ Um von dem Geschwindigkeitsvorteil der Cloud TPUs zu profitieren, empfehlen wir, deine Samples mit den Argumenten `padding="max_length"` und `max_length` des Tokenizers auf eine feste Länge aufzufüllen.')},m(b,h){t(b,w,h)},d(b){b&&s(w)}}}function Rs(Be){let w,b,h,Ie,U,ve,T,We,f,Xe,g,ze,C,El="In diesem Abschnitt befassen wir uns damit, wie wir die gleichen Ergebnisse wie im letzten Abschnitt erzielen können, ohne die Klasse <code>Trainer</code> zu verwenden. Auch hier gehen wir davon aus, dass du die Datenverarbeitung in Abschnitt 2 durchgeführt hast. Hier ist eine kurze Zusammenfassung mit allem, was du brauchst:",Re,Z,Ae,k,_e,B,Fl="Bevor wir unsere Trainingsschleife schreiben, müssen wir noch einige Objekte definieren. Zunächst müssen wir die Datalader definieren, mit denen wir über die Batches iterieren werden. Doch bevor wir diese Dataloader definieren können, müssen wir unsere <code>tokenized_datasets</code> nachbearbeiten, um einige Dinge zu erledigen, die der <code>Trainer</code> automatisch für uns erledigt hat. Konkret heißt das, dass wir:",Ye,I,Ql="<li>Die Spalten entfernen, die Werte enthalten, die das Modell nicht erwartet (wie die Spalten <code>sentence1</code> und <code>sentence2</code>).</li> <li>Die Spalte <code>label</code> in <code>labels</code> umbenennen (weil das Modell erwartet, dass das Argument <code>labels</code> heißt).</li> <li>Das Format der Datensätze anpassen, so dass sie PyTorch-Tensoren statt Listen zurückgeben.</li>",Ve,$,xl="Das <code>tokenized_datasets</code> hat eine Methode für jeden dieser Schritte:",Ne,G,Ee,v,Hl="Anschließend können wir überprüfen, ob der Output nur Spalten enthält, die unser Modell akzeptiert:",Fe,W,Qe,X,Sl="Jetzt können wir ganz einfach unsere Dataloader definieren:",xe,z,He,R,Ll="Um sicher zu gehen, überprüfen wir ein Batch auf Fehler in der Datenverarbeitung:",Se,A,Le,_,De,Y,Dl="Beachte, dass die Dimensionen der Tensoren wahrscheinlich etwas anders aussehen werden, da wir für den Trainingsdatenlader <code>shuffle=True</code> eingestellt haben und innerhalb des Batches auf die maximale Länge auffüllen.",Ke,V,Kl="Da wir nun mit der Datenvorverarbeitung fertig sind (ein zufriedenstellendes aber schwer erreichbares Ziel für jeden ML-Experten), können wir uns nun dem Modell zuwenden. Wir instanziieren es genauso wie im vorherigen Abschnitt:",qe,N,Pe,E,ql="Als weitere Sicherheitsmaßnahme übergeben wir unseren Batch an das Modell, um sicherzustellen, dass beim Training alles glatt läuft:",Oe,F,el,Q,ll,x,Pl="Alle 🤗 Transformer Modelle geben den Verlust zurück, wenn <code>labels</code> angegeben werden, und wir erhalten zusätzlich die Logits (zwei für jede Eingabe in unserem Batch, also einen Tensor der Größe 8 x 2).",sl,H,Ol='Wir sind fast so weit, unsere Trainingsschleife zu schreiben! Es fehlen nur noch zwei Dinge: ein Optimierer und ein Scheduler für die Lernrate. Da wir versuchen, das zu wiederholen, was der <code>Trainer</code> automatisch gemacht hat, werden wir die gleichen Standardwerte verwenden. Der Optimierer, den der <code>Trainer</code> verwendet, heißt “AdamW” und ist größtenteils derselbe wie Adam, abgesehen von einer Abwandlung für die “Weight Decay Regularization” (siehe [“Decoupled Weight Decay Regularization”] (<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>) von Ilya Loshchilov und Frank Hutter):',tl,S,nl,L,es="Der standardmäßig verwendete Scheduler für die Lernrate ist ein linearer Abstieg vom Maximalwert (5e-5) auf 0. Um ihn richtig zu definieren, müssen wir die Anzahl der Trainingsschritte kennen, d.h. die Anzahl der Epochen, die die Trainingsschleife durchlaufen soll, multipliziert mit der Anzahl der Trainingsbatches (der Länge unseres Trainingsdatenordners). Der <code>Trainer</code> verwendet standardmäßig drei Epochen, woran wir uns hier orientieren werden:",al,D,il,K,rl,q,pl,P,ls="Ein letzter Hinweis: Wir wollen die GPU zum Training nutzen, wenn wir Zugang zu einer haben (auf einer CPU kann das Training mehrere Stunden statt ein paar Minuten dauern). Dazu definieren wir <code>device</code> als Gerät auf dem wir unser Modell und unsere Batches speichern:",dl,O,Ml,ee,cl,le,ss="Wir sind jetzt bereit für das Training! Um ein Gefühl dafür zu bekommen, wann das Training abgeschlossen sein wird, fügen wir mit der Bibliothek <code>tqdm</code> einen Fortschrittsbalken über die Anzahl der Trainingsschritte ein:",ml,se,ol,te,ts="Der Kern der Trainingsschleife sieht ähnlich aus wie in der Einleitung. Da wir keine Berichte angefordert haben, gibt die Trainingsschleife nichts über die Performance des Modells zurück. Dafür müssen wir eine Evaluationsschleife einfügen.",ul,ne,yl,ae,ns="Wie schon zuvor verwenden wir eine Metrik, die von der 🤗 Evaluate-Bibliothek bereitgestellt wird. Wir haben bereits die Methode <code>metric.compute()</code> gesehen, aber Metriken können auch Batches für uns akkumulieren, wenn wir die Vorhersageschleife mit der Methode <code>add_batch()</code> durchlaufen. Sobald wir alle Batches gesammelt haben, können wir das Endergebnis mit der Methode <code>metric.compute()</code> ermitteln. So implementierst du all das in eine Evaluationsschleife:",wl,ie,bl,re,hl,pe,as="Auch hier werden deine Ergebnisse wegen der Zufälligkeit bei der Initialisierung des Modellkopfes und der Datenverteilung etwas anders ausfallen, aber sie sollten in etwa gleich sein.",Jl,J,jl,de,Ul,Me,Tl,ce,is='Die Trainingsschleife, die wir zuvor definiert haben, funktioniert gut auf einer einzelnen CPU oder GPU. Aber mit der Bibliothek <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> können wir mit wenigen Anpassungen verteiltes Training auf mehreren GPUs oder TPUs implementieren. Beginnend mit der Erstellung der Trainings- und Validierungsdaten, sieht unsere manuelle Trainingsschleife nun folgendermaßen aus:',fl,me,gl,oe,rs="Und hier sind die Änderungen:",Cl,ue,Zl,ye,ps="Die erste Zeile, die hinzugefügt werden muss, ist die Import-Zeile. Die zweite Zeile instanziiert ein <code>Accelerator</code>-Objekt, das die Hardware analysiert und die richtige verteilte Umgebung initialisiert. Accelerate kümmert sich um die Anordnung der Geräte, du kannst also die Zeilen entfernen, die das Modell auf dem Gerät platzieren (oder, wenn du das möchtest, sie so ändern, dass sie <code>accelerator.device</code> anstelle von <code>device</code> verwenden).",kl,we,ds="Der Hauptteil der Arbeit wird dann in der Zeile erledigt, die die Dataloader, das Modell und den Optimierer an <code>accelerator.prepare()</code> sendet. Dadurch werden diese Objekte in den richtigen Container verpackt, damit das verteilte Training wie vorgesehen funktioniert. Die verbleibenden Änderungen sind das Entfernen der Zeile, die das Batch auf dem Gerät mit <code>device</code> ablegt (wenn du das beibehalten willst, kannst du es einfach in <code>accelerator.device</code> ändern) und das Ersetzen von <code>loss.backward()</code> durch <code>accelerator.backward(loss)</code>.",Bl,j,Il,be,Ms="Wenn du damit experimentieren möchtest, siehst du hier, wie die komplette Trainingsschleife mit 🤗 Accelerate aussieht:",$l,he,Gl,Je,cs="Wenn dies in das Script <code>train.py</code> eingefügt wird, kann das Script auf jeder Art von verteilter Hardware ausgeführt werden. Um es auf deiner verteilten Hardware auszuprobieren, führe den folgenden Befehl aus:",vl,je,Wl,Ue,ms="Du wirst dann aufgefordert werden, einige Fragen zu beantworten und die Antworten in eine Konfigurationsdatei zu schreiben, die von diesem Befehl verwendet wird:",Xl,Te,zl,fe,os="Damit wird das verteilte Training gestartet.",Rl,ge,us="Wenn du das in einem Notebook ausprobieren möchtest (z. B. um es mit TPUs auf Colab zu testen), füge den Code einfach in eine <code>training_function()</code> ein und führe eine letzte Zelle mit aus:",Al,Ce,_l,Ze,ys='Weitere Beispiele findest du in dem <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate Repo</a>.',Yl,ke,Vl,$e,Nl;return U=new Gs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new Ge({props:{title:"Komplettes Training",local:"komplettes-training",headingTag:"h1"}}),f=new Ws({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/de/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/de/chapter3/section4.ipynb"}]}}),g=new Us({props:{id:"Dh9CL8fyG80"}}),Z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),k=new Ge({props:{title:"Vorbereitung für das Training",local:"vorbereitung-für-das-training",headingTag:"h3"}}),G=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),W=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),z=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),A=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),_=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),Q=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),S=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),q=new Ge({props:{title:"Die Trainingsschleife",local:"die-trainingsschleife",headingTag:"h3"}}),O=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),ee=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),se=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ne=new Ge({props:{title:"Die Evaluationsschleife",local:"die-evaluationsschleife",headingTag:"h3"}}),ie=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),re=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),J=new js({props:{$$slots:{default:[Xs]},$$scope:{ctx:Be}}}),de=new Ge({props:{title:"Verbessere deine Trainingsschleife mit 🤗 Accelerate",local:"verbessere-deine-trainingsschleife-mit--accelerate",headingTag:"h3"}}),Me=new Us({props:{id:"s7dy8QRgjJ0"}}),me=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ue=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from torch.optim import AdamW
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),j=new js({props:{$$slots:{default:[zs]},$$scope:{ctx:Be}}}),he=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),je=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Te=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ce=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),ke=new vs({props:{source:"https://github.com/huggingface/course/blob/main/chapters/de/chapter3/4.mdx"}}),{c(){w=m("meta"),b=n(),h=m("p"),Ie=n(),i(U.$$.fragment),ve=n(),i(T.$$.fragment),We=n(),i(f.$$.fragment),Xe=n(),i(g.$$.fragment),ze=n(),C=m("p"),C.innerHTML=El,Re=n(),i(Z.$$.fragment),Ae=n(),i(k.$$.fragment),_e=n(),B=m("p"),B.innerHTML=Fl,Ye=n(),I=m("ul"),I.innerHTML=Ql,Ve=n(),$=m("p"),$.innerHTML=xl,Ne=n(),i(G.$$.fragment),Ee=n(),v=m("p"),v.textContent=Hl,Fe=n(),i(W.$$.fragment),Qe=n(),X=m("p"),X.textContent=Sl,xe=n(),i(z.$$.fragment),He=n(),R=m("p"),R.textContent=Ll,Se=n(),i(A.$$.fragment),Le=n(),i(_.$$.fragment),De=n(),Y=m("p"),Y.innerHTML=Dl,Ke=n(),V=m("p"),V.textContent=Kl,qe=n(),i(N.$$.fragment),Pe=n(),E=m("p"),E.textContent=ql,Oe=n(),i(F.$$.fragment),el=n(),i(Q.$$.fragment),ll=n(),x=m("p"),x.innerHTML=Pl,sl=n(),H=m("p"),H.innerHTML=Ol,tl=n(),i(S.$$.fragment),nl=n(),L=m("p"),L.innerHTML=es,al=n(),i(D.$$.fragment),il=n(),i(K.$$.fragment),rl=n(),i(q.$$.fragment),pl=n(),P=m("p"),P.innerHTML=ls,dl=n(),i(O.$$.fragment),Ml=n(),i(ee.$$.fragment),cl=n(),le=m("p"),le.innerHTML=ss,ml=n(),i(se.$$.fragment),ol=n(),te=m("p"),te.textContent=ts,ul=n(),i(ne.$$.fragment),yl=n(),ae=m("p"),ae.innerHTML=ns,wl=n(),i(ie.$$.fragment),bl=n(),i(re.$$.fragment),hl=n(),pe=m("p"),pe.textContent=as,Jl=n(),i(J.$$.fragment),jl=n(),i(de.$$.fragment),Ul=n(),i(Me.$$.fragment),Tl=n(),ce=m("p"),ce.innerHTML=is,fl=n(),i(me.$$.fragment),gl=n(),oe=m("p"),oe.textContent=rs,Cl=n(),i(ue.$$.fragment),Zl=n(),ye=m("p"),ye.innerHTML=ps,kl=n(),we=m("p"),we.innerHTML=ds,Bl=n(),i(j.$$.fragment),Il=n(),be=m("p"),be.textContent=Ms,$l=n(),i(he.$$.fragment),Gl=n(),Je=m("p"),Je.innerHTML=cs,vl=n(),i(je.$$.fragment),Wl=n(),Ue=m("p"),Ue.textContent=ms,Xl=n(),i(Te.$$.fragment),zl=n(),fe=m("p"),fe.textContent=os,Rl=n(),ge=m("p"),ge.innerHTML=us,Al=n(),i(Ce.$$.fragment),_l=n(),Ze=m("p"),Ze.innerHTML=ys,Yl=n(),i(ke.$$.fragment),Vl=n(),$e=m("p"),this.h()},l(e){const l=ks("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(s),b=a(e),h=o(e,"P",{}),hs(h).forEach(s),Ie=a(e),r(U.$$.fragment,e),ve=a(e),r(T.$$.fragment,e),We=a(e),r(f.$$.fragment,e),Xe=a(e),r(g.$$.fragment,e),ze=a(e),C=o(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-u9dlj6"&&(C.innerHTML=El),Re=a(e),r(Z.$$.fragment,e),Ae=a(e),r(k.$$.fragment,e),_e=a(e),B=o(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-10uwzhv"&&(B.innerHTML=Fl),Ye=a(e),I=o(e,"UL",{"data-svelte-h":!0}),u(I)!=="svelte-97ia1"&&(I.innerHTML=Ql),Ve=a(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1xre5mi"&&($.innerHTML=xl),Ne=a(e),r(G.$$.fragment,e),Ee=a(e),v=o(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1ne07l6"&&(v.textContent=Hl),Fe=a(e),r(W.$$.fragment,e),Qe=a(e),X=o(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1qzexy9"&&(X.textContent=Sl),xe=a(e),r(z.$$.fragment,e),He=a(e),R=o(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-58ge5g"&&(R.textContent=Ll),Se=a(e),r(A.$$.fragment,e),Le=a(e),r(_.$$.fragment,e),De=a(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-tuv6h6"&&(Y.innerHTML=Dl),Ke=a(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-qcm9iy"&&(V.textContent=Kl),qe=a(e),r(N.$$.fragment,e),Pe=a(e),E=o(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1o9btcm"&&(E.textContent=ql),Oe=a(e),r(F.$$.fragment,e),el=a(e),r(Q.$$.fragment,e),ll=a(e),x=o(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1xdm3p"&&(x.innerHTML=Pl),sl=a(e),H=o(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-n59cj8"&&(H.innerHTML=Ol),tl=a(e),r(S.$$.fragment,e),nl=a(e),L=o(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1d7k25q"&&(L.innerHTML=es),al=a(e),r(D.$$.fragment,e),il=a(e),r(K.$$.fragment,e),rl=a(e),r(q.$$.fragment,e),pl=a(e),P=o(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-10laz2u"&&(P.innerHTML=ls),dl=a(e),r(O.$$.fragment,e),Ml=a(e),r(ee.$$.fragment,e),cl=a(e),le=o(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-5rg5wc"&&(le.innerHTML=ss),ml=a(e),r(se.$$.fragment,e),ol=a(e),te=o(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-p31dwq"&&(te.textContent=ts),ul=a(e),r(ne.$$.fragment,e),yl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1ho21o0"&&(ae.innerHTML=ns),wl=a(e),r(ie.$$.fragment,e),bl=a(e),r(re.$$.fragment,e),hl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-14ibogl"&&(pe.textContent=as),Jl=a(e),r(J.$$.fragment,e),jl=a(e),r(de.$$.fragment,e),Ul=a(e),r(Me.$$.fragment,e),Tl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-105b2zv"&&(ce.innerHTML=is),fl=a(e),r(me.$$.fragment,e),gl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-1b5atwv"&&(oe.textContent=rs),Cl=a(e),r(ue.$$.fragment,e),Zl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1rigc9c"&&(ye.innerHTML=ps),kl=a(e),we=o(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-2rrnhi"&&(we.innerHTML=ds),Bl=a(e),r(j.$$.fragment,e),Il=a(e),be=o(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1la63xh"&&(be.textContent=Ms),$l=a(e),r(he.$$.fragment,e),Gl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1l337r5"&&(Je.innerHTML=cs),vl=a(e),r(je.$$.fragment,e),Wl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-134ovcr"&&(Ue.textContent=ms),Xl=a(e),r(Te.$$.fragment,e),zl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1m2v744"&&(fe.textContent=os),Rl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-umh1t9"&&(ge.innerHTML=us),Al=a(e),r(Ce.$$.fragment,e),_l=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1vh5l4m"&&(Ze.innerHTML=ys),Yl=a(e),r(ke.$$.fragment,e),Vl=a(e),$e=o(e,"P",{}),hs($e).forEach(s),this.h()},h(){Js(w,"name","hf:doc:metadata"),Js(w,"content",As)},m(e,l){Bs(document.head,w),t(e,b,l),t(e,h,l),t(e,Ie,l),p(U,e,l),t(e,ve,l),p(T,e,l),t(e,We,l),p(f,e,l),t(e,Xe,l),p(g,e,l),t(e,ze,l),t(e,C,l),t(e,Re,l),p(Z,e,l),t(e,Ae,l),p(k,e,l),t(e,_e,l),t(e,B,l),t(e,Ye,l),t(e,I,l),t(e,Ve,l),t(e,$,l),t(e,Ne,l),p(G,e,l),t(e,Ee,l),t(e,v,l),t(e,Fe,l),p(W,e,l),t(e,Qe,l),t(e,X,l),t(e,xe,l),p(z,e,l),t(e,He,l),t(e,R,l),t(e,Se,l),p(A,e,l),t(e,Le,l),p(_,e,l),t(e,De,l),t(e,Y,l),t(e,Ke,l),t(e,V,l),t(e,qe,l),p(N,e,l),t(e,Pe,l),t(e,E,l),t(e,Oe,l),p(F,e,l),t(e,el,l),p(Q,e,l),t(e,ll,l),t(e,x,l),t(e,sl,l),t(e,H,l),t(e,tl,l),p(S,e,l),t(e,nl,l),t(e,L,l),t(e,al,l),p(D,e,l),t(e,il,l),p(K,e,l),t(e,rl,l),p(q,e,l),t(e,pl,l),t(e,P,l),t(e,dl,l),p(O,e,l),t(e,Ml,l),p(ee,e,l),t(e,cl,l),t(e,le,l),t(e,ml,l),p(se,e,l),t(e,ol,l),t(e,te,l),t(e,ul,l),p(ne,e,l),t(e,yl,l),t(e,ae,l),t(e,wl,l),p(ie,e,l),t(e,bl,l),p(re,e,l),t(e,hl,l),t(e,pe,l),t(e,Jl,l),p(J,e,l),t(e,jl,l),p(de,e,l),t(e,Ul,l),p(Me,e,l),t(e,Tl,l),t(e,ce,l),t(e,fl,l),p(me,e,l),t(e,gl,l),t(e,oe,l),t(e,Cl,l),p(ue,e,l),t(e,Zl,l),t(e,ye,l),t(e,kl,l),t(e,we,l),t(e,Bl,l),p(j,e,l),t(e,Il,l),t(e,be,l),t(e,$l,l),p(he,e,l),t(e,Gl,l),t(e,Je,l),t(e,vl,l),p(je,e,l),t(e,Wl,l),t(e,Ue,l),t(e,Xl,l),p(Te,e,l),t(e,zl,l),t(e,fe,l),t(e,Rl,l),t(e,ge,l),t(e,Al,l),p(Ce,e,l),t(e,_l,l),t(e,Ze,l),t(e,Yl,l),p(ke,e,l),t(e,Vl,l),t(e,$e,l),Nl=!0},p(e,[l]){const ws={};l&2&&(ws.$$scope={dirty:l,ctx:e}),J.$set(ws);const bs={};l&2&&(bs.$$scope={dirty:l,ctx:e}),j.$set(bs)},i(e){Nl||(d(U.$$.fragment,e),d(T.$$.fragment,e),d(f.$$.fragment,e),d(g.$$.fragment,e),d(Z.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(z.$$.fragment,e),d(A.$$.fragment,e),d(_.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(J.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(j.$$.fragment,e),d(he.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d(ke.$$.fragment,e),Nl=!0)},o(e){M(U.$$.fragment,e),M(T.$$.fragment,e),M(f.$$.fragment,e),M(g.$$.fragment,e),M(Z.$$.fragment,e),M(k.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(_.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(J.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(me.$$.fragment,e),M(ue.$$.fragment,e),M(j.$$.fragment,e),M(he.$$.fragment,e),M(je.$$.fragment,e),M(Te.$$.fragment,e),M(Ce.$$.fragment,e),M(ke.$$.fragment,e),Nl=!1},d(e){e&&(s(b),s(h),s(Ie),s(ve),s(We),s(Xe),s(ze),s(C),s(Re),s(Ae),s(_e),s(B),s(Ye),s(I),s(Ve),s($),s(Ne),s(Ee),s(v),s(Fe),s(Qe),s(X),s(xe),s(He),s(R),s(Se),s(Le),s(De),s(Y),s(Ke),s(V),s(qe),s(Pe),s(E),s(Oe),s(el),s(ll),s(x),s(sl),s(H),s(tl),s(nl),s(L),s(al),s(il),s(rl),s(pl),s(P),s(dl),s(Ml),s(cl),s(le),s(ml),s(ol),s(te),s(ul),s(yl),s(ae),s(wl),s(bl),s(hl),s(pe),s(Jl),s(jl),s(Ul),s(Tl),s(ce),s(fl),s(gl),s(oe),s(Cl),s(Zl),s(ye),s(kl),s(we),s(Bl),s(Il),s(be),s($l),s(Gl),s(Je),s(vl),s(Wl),s(Ue),s(Xl),s(zl),s(fe),s(Rl),s(ge),s(Al),s(_l),s(Ze),s(Yl),s(Vl),s($e)),s(w),c(U,e),c(T,e),c(f,e),c(g,e),c(Z,e),c(k,e),c(G,e),c(W,e),c(z,e),c(A,e),c(_,e),c(N,e),c(F,e),c(Q,e),c(S,e),c(D,e),c(K,e),c(q,e),c(O,e),c(ee,e),c(se,e),c(ne,e),c(ie,e),c(re,e),c(J,e),c(de,e),c(Me,e),c(me,e),c(ue,e),c(j,e),c(he,e),c(je,e),c(Te,e),c(Ce,e),c(ke,e)}}}const As='{"title":"Komplettes Training","local":"komplettes-training","sections":[{"title":"Vorbereitung für das Training","local":"vorbereitung-für-das-training","sections":[],"depth":3},{"title":"Die Trainingsschleife","local":"die-trainingsschleife","sections":[],"depth":3},{"title":"Die Evaluationsschleife","local":"die-evaluationsschleife","sections":[],"depth":3},{"title":"Verbessere deine Trainingsschleife mit 🤗 Accelerate","local":"verbessere-deine-trainingsschleife-mit--accelerate","sections":[],"depth":3}],"depth":1}';function _s(Be){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Cs{constructor(w){super(),Zs(this,w,_s,Rs,Ts,{})}}export{Hs as component};
