# Quiz am Ende des Kapitels

In diesem Kapitel hast du viel gelernt! Mach dir keine Sorgen, wenn du noch nicht alle Einzelheiten verstanden hast. In den nächsten Kapiteln wirst du mehr darüber erfahren, wie die Dinge im Einzelnen funktionieren.

Doch zuerst wollen wir noch testen, was du in diesem Kapitel gelernt hast!


### 1. Erkunde den Hub und suche nach dem Checkpoint `roberta-large-mnli`. Welche Aufgabe unterstützt er?


<Question
	choices={[
		{
			text: "Summarization (Textzusammenfassung)",
			explain: "Sieh nochmal auf der Seite des Modells<a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli</a> nach."
		},
		{
			text: "Text Classification (Textklassifizierung)",
			explain: "Genauer gesagt, wird klassifiziert, ob zwei Sätze hinsichtlich dreier Labels (Widerspruch (engl. Contradiction), Neutral, Konsequenz (engl. Entailment)) logisch miteinander verbunden sind - eine Aufgabe, die auch als <em>Natural Language Inference</em> bezeichnet wird.",
			correct: true
		},
		{
			text: "Text Generation (Textgenerierung)",
			explain: "Sieh nochmal auf der Seite des Modells <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli</a> nach."
		}
	]}
/>

### 2. Was gibt der folgende Code zurück?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "Er gibt die Ergebnisse der Klassifizierung für diesen Satz für die Labels \"positive\" oder \"negative\" zurück.",
			explain: "Das ist nicht richtig - dafür müsstest du eine <code>sentiment-analysis</code>-Pipeline verwenden."
		},
		{
			text: "Er wird einen generierten Text zurückgeben, der diesen Satz vervollständigt.",
			explain: "Das ist nicht richtig - dafür müsstest du eine <code>text-generation</code>-Pipeline verwenden.",
		},
		{
			text: "Er gibt Begriffe zurück, die für Personen, Organisationen oder Orte stehen.",
			explain: "Außerdem werden mit <code>grouped_entities=True</code> die Wörter, die zur selben Entität gehören, gruppiert, wie z. B. \"Hugging Face\".",
			correct: true
		}
	]}
/>

### 3. Wodurch müsste ... in diesem Codebeispiel ersetzt werden?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you.",
			explain: "Das stimmt nicht. Schau dir die <code>bert-base-cased</code>-Übersichtsseite des Modells an und versuche, deinen Fehler zu entdecken."
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "Richtig! Der Mask Token dieses Modells ist [MASK].",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "Leider falsch. Diese Pipeline füllt maskierte Wörter auf, also braucht sie irgendwo einen Mask Token."
		}
	]}
/>

### 4. Warum wird dieser Code nicht funktionieren?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "Diese Pipeline erfordert, dass Labels angegeben werden, damit der Text klassifiziert werden kann.",
			explain: "Richtig — der korrekte Code muss <code>candidate_labels=[...]</code> enthalten.",
			correct: true
		},
		{
			text: "Diese Pipeline erfordert mehrere Sätze, nicht nur einen.",
			explain: "Das ist falsch - obwohl diese Pipeline, wenn sie korrekt verwendet wird, eine Liste von Sätzen verarbeiten kann (wie alle anderen Pipelines)."
		},
		{
			text: "Die 🤗 Transformers-Bibliothek funktioniert wie immer nicht.",
			explain: "Zu dieser Antwort erübrigt sich jeder Kommentar!"
		},
		{
			text: "Diese Pipeline erfordert längere Inputs; diese hier sind zu kurz.",
			explain: "Das ist falsch. Übrigens wird ein sehr langer Text bei der Verarbeitung durch diese Pipeline gestutzt (engl. truncated) bzw. gekürzt."
		}
	]}
/>

### 5. Was bedeutet der Begriff "Transfer Learning"?

<Question
	choices={[
		{
			text: "Übertragen des im Pretraining erlangten Wissens auf ein neues Modell, indem es auf demselben Datensatz trainiert wird.",
			explain: "Nein, das wären dann zwei Versionen desselben Modells."
		},
		{
			text: "Übertragen des im Pretraining erlangten Wissens auf ein neues Modell durch Initialisierung des zweiten Modells mit der Gewichtung des ersten Modells.",
			explain: "Richtig: Wenn das zweite Modell für eine neue Aufgabe trainiert wird, *überträgt* (engl. transfer) es das Wissen des ersten Modells.",
			correct: true
		},
		{
			text: "Übertragen des im Pretraining erlangten Wissens auf ein neues Modell, indem das zweite Modell mit der gleichen Architektur wie das erste Modell aufgebaut wird.",
			explain: "Die Architektur ist nur die Art und Weise, wie das Modell aufgebaut ist. Es wird in diesem Fall kein Wissen geteilt oder übertragen."
		}
	]}
/>

### 6. Richtig oder falsch? Ein Sprachmodell benötigt im Rahmen des Pretraining in der Regel keine Labels.


<Question
	choices={[
		{
			text: "Richtig",
			explain: "Das Pretraining ist in der Regel <em>selbstüberwacht</em> (engl. self-supervised), d. h. die Labels werden automatisch aus den Inputs erstellt (wie z. B. die Vorhersage des nächsten Wortes oder das Auffüllen einiger maskierter Wörter).",
			correct: true
		},
		{
			text: "Falsch",
			explain: "Das ist nicht die richtige Antwort."
		}
	]}
/>

### 7. Wähle den Satz aus, der die Begriffe "Modell", "Architektur" und "Gewichte" bzw. "Gewichtung" am besten beschreibt.

<Question
	choices={[
		{
			text: "Wenn ein Modell ein Gebäude ist, ist seine Architektur der Bauplan und die Gewichte sind die Menschen, die darin leben.",
			explain: "In Anlehnung an diese Metapher wären die Gewichte die Ziegel (und weitere Materialien), die zum Bau des Gebäudes verwendet werden."
		},
		{
			text: "Eine Architektur ist eine Karte zum Aufbau eines Modells und ihre Gewichte sind die Städte, die auf der Karte dargestellt sind.",
			explain: "Das Problem bei dieser Metapher ist, dass eine Karte in der Regel nur eine Realität abbildet (es gibt nur eine Stadt in Frankreich namens Paris). Für eine bestimmte Architektur sind jedoch verschiedene Gewichtungen möglich."
		},
		{
			text: "Eine Architektur ist eine Abfolge von mathematischen Funktionen zum Aufbau eines Modells und ihre Gewichte sind die Parameter dieser Funktionen.",
			explain: "Dieselben mathematischen Funktionen (Architektur) können verwendet werden, um verschiedene Modelle zu erstellen, indem unterschiedliche Parameter (Gewichte) verwendet werden.",
			correct: true
		}
	]}
/>


### 8. Welche dieser Modelle würdest du nutzen, um einen Prompt bzw. Text-Input durch einen generierten Text vervollständigen zu lassen?

<Question
	choices={[
		{
			text: "Ein Encoder-Modell",
			explain: "Ein Encoder-Modell erzeugt eine Repräsentation für den gesamten Satz. Diese ist für Aufgaben wie die Klassifizierung besser geeignet."
		},
		{
			text: "Ein Decoder-Modell",
			explain: "Decoder-Modelle eignen sich perfekt für die Generierung von Text auf Basis eines Prompts bzw. Input-Textes.",
			correct: true
		},
		{
			text: "Ein Sequence-to-Sequence-Modell",
			explain: "Sequence-to-Sequence-Modelle eignen sich besser für Aufgaben, bei denen du Sätze generieren möchtest, die jeweils einen Bezug zu den Input-Sätzen haben, und nicht auf einen bestimmten Prompt zurückzuführen sind."
		}
	]}
/>

### 9. Welche dieser Modelle würdest du für die Zusammenfassung von Texten verwenden?

<Question
	choices={[
		{
			text: "Ein Encoder-Modell",
			explain: "Ein Encoder-Modell erzeugt eine Repräsentation für den gesamten Satz. Diese ist für Aufgaben wie die Klassifizierung besser geeignet."
		},
		{
			text: "Ein Decoder-Modell",
			explain: "Decoder-Modelle sind gut für die Erstellung von Text-Outputs (wie Zusammenfassungen), aber sie haben nicht die Fähigkeit, einen Gesamtkontext wie den kompletten Text für die Zusammenfassung zu nutzen."
		},
		{
			text: "Ein Sequence-to-Sequence-Modell",
			explain: "Sequence-to-Sequence-Modelle eignen sich perfekt für eine Textzusammenfassungsaufgabe.",
			correct: true
		}
	]}
/>

### 10. Welche Art von Modellen würdest du verwenden, um Text-Inputs entsprechend bestimmter Labels zu klassifizieren?

<Question
	choices={[
		{
			text: "Ein Encoder-Modell",
			explain: "Ein Encoder-Modell erzeugt eine Repräsentation für den gesamten Satz. Diese eignet sich perfekt für eine Aufgabe wie die Klassifizierung.",
			correct: true
		},
		{
			text: "Ein Decoder-Modell",
			explain: "Decoder-Modelle eignen sich für die Generierung von Output-Texten, aber nicht dafür, ein Label für einen bestimmten Satz zu ermitteln."
		},
		{
			text: "Ein Sequence-to-Sequence-Modell",
			explain: "Sequence-to-Sequence-Modelle eignen sich besser für Aufgaben, bei denen du Text auf der Grundlage eines vorgegebenen Satzes und nicht eines Labels generieren möchtest.",
		}
	]}
/>

### 11. Welche mögliche Ursache kann eine vom Modell zu beobachtende Voreingenommenheit (Bias) haben?

<Question
	choices={[
		{
			text: "Das Modell ist eine feingetunte Version eines vortrainierten Modells, das den Bias aus dem Pretraining übernommen hat.",
			explain: "Bei der Anwendung von Transfer Learning wird ein Bias, der dem vortrainierten Modell zugrunde lag, auch beim feingetunten Modell durchsickern.",
			correct: true
		},
		{
			text: "Die Daten, mit denen das Modell trainiert wurde, spiegeln Voreingenommenheiten wider bzw. sind mit einem Bias versehen.",
			explain: "Dies ist die offensichtlichste Ursache für eine Voreingenommenheit (Bias), aber nicht die einzige.",
			correct: true
		},
		{
			text: "Das Maß, auf dessen Grundlage das Modell optimiert wurde, führt zu einem Bias.",
			explain: "Eine weniger offensichtliche Ursache für Voreingenommenheiten (Bias) ist die Art und Weise, wie das Modell trainiert wird. Bspw. wenn du dein Modell einfach blindlings in Bezug auf das von dir gewählte Maß optimierst.",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter1/10.mdx" />