# Computerlinguistik

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Bevor wir uns mit Transformer-Modellen beschäftigen, wollen wir dir einen kurzen Überblick darüber geben, was Computerlinguistik (engl. Natural Language Processing, NLP) ist und welche Gründe es gibt, sich damit zu befassen.

## Was ist Computerlinguistik (CL)?

CL ist ein Bereich der Linguistik und des Maschinellen Lernens (engl. Machine Learning, ML), der sich darauf konzentriert, alle mit menschlicher Sprache zusammenhängenden Dinge zu verstehen. Das Ziel bei CL-Aufgabenstellungen (engl. Tasks) ist es, nicht nur einzelne Wörter zu verstehen, sondern auch den Kontext dieser Wörter zu erfassen.

Im Folgenden findest du eine Liste der häufigsten CL-Aufgabenstellungen mit jeweils einigen Beispielen:

- **Ganze Sätze klassifizieren**: Die mit einer bestimmten Bewertung verbundene Stimmungslage ermitteln, erkennen, ob eine E-Mail Spam ist, bestimmen, ob ein Satz grammatikalisch korrekt ist oder ob zwei Sätze logisch zusammenhängen oder nicht
- **Jedes einzelne Wort in einem Satz klassifizieren**: Identifizieren der grammatikalischen Bestandteile eines Satzes (Substantiv, Verb, Adjektiv) oder der benannten Entitäten (Person, Ort, Organisation) (engl. Named Entities)
- **Generieren von Textinhalten**: Einen Prompt durch einen automatisch generierten Text vervollständigen oder Lücken in einem Text auffüllen, in dem einzelne Wörter maskiert sind
- **Eine Antwort aus einem Text extrahieren**: Auf Basis einer Frage und eines gegebenen Kontexts die Antwort auf die Frage anhand der im Kontext enthaltenen Informationen extrahieren
- **Generieren eines neuen Satzes auf Basis eines Input-Textes**: Einen Text in eine andere Sprache automatisch übersetzen, Zusammenfassen eines Textes

Die Computerlinguistik ist jedoch nicht nur auf die Verarbeitung geschriebener Texte beschränkt. Sie stellt sich auch komplexen Herausforderungen in den Bereichen der Spracherkennung (engl. Speech Recognition) und Computer Vision, wie z. B. ein Transkript einer Audioaufnahme zu erstellen oder ein Bild zu beschreiben.

## Warum ist Computerlinguistik so schwierig?

Computer verarbeiten Informationen nicht auf die gleiche Weise wie Menschen. Wenn wir zum Beispiel den Satz "Ich bin hungrig" lesen, können wir seine Bedeutung leicht erfassen. Genauso können wir bei zwei Sätzen wie "Ich habe Hunger" und "Ich bin traurig" leicht feststellen, wie ähnlich sie sind. Für ML-Modelle sind solche Aufgaben schwieriger zu lösen. Der Text muss erst so verarbeitet werden, dass das Modell in der Lage ist, daraus zu lernen. Und weil Sprache komplex ist, müssen wir uns genau überlegen, wie diese Verarbeitung erfolgen sollte. Es wurde eine rege Forschung dazu betrieben, wie Texte repräsentiert werden können. Einige dieser Methoden werden wir uns im nächsten Kapitel ansehen.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter1/2.mdx" />