# Der Hugging Face Hub

Der [Hugging Face Hub](https://huggingface.co/) –- unsere Hauptwebseite –- ist eine zentrale Platform, wo Nutzer*innen "state-of-the-art" Modelle und Datensätze entdecken, benutzen und dazu beitragen können. Eine große Vielfalt an Modellen steht öffentlich zur Verfügung auf der Platform – insgesamt mehr als 10000 Modelle. In diesem Kapitel fokusieren wir uns auf die Modelle und die Datensätze werden wir uns im Kapitel 5 anschauen.

Die Modelle auf dem Hub sind nicht auf 🤗 Transformers bzw. NLP eingeschränkt.
Es gibt Modelle von [Flair](https://github.com/flairNLP/flair) und [AllenNLP](https://github.com/allenai/allennlp) für NLP, [Asteroid](https://github.com/asteroid-team/asteroid) und [pyannote](https://github.com/pyannote/pyannote-audio) für Spracherkennung, und [timm](https://github.com/rwightman/pytorch-image-models) für Computer Vision, um ein paar Beispiele zu nennen.

Jedes Modell wird als Git-Repository gehosted, was Versionierung und Reproduzierbarkeit ermöglicht. Durch das Teilen eines Modells wird dieses der Community zur Verfügung gestellt. Somit wird das Teilen und die Anwendung vom Modell einfacher und jede/r hat die Möglichkeit, das Modell zu Verwenden, ohne es selbst trainieren zu müssen.

Dazu löst das Teilen eines Modells auf dem Hub automatisch das Deployment einer Hosted-Inferenz-API für das Modell aus. Jede/r in der Communinity kann das Modell direkt auf der Modellsseite mit benutzerdefinierten Inputs und passenden Widgets ausprobieren.

Das Beste ist, dass sowohl das Teilen als auch das Nutzen von öffentlichen Modellen auf dem Hub völlig kostenlos erfolgt! [Bezahlte Pläne](https://huggingface.co/pricing) gibt es auch, falls du Modelle privat teilen möchtest. 

Das folgende Video zeigt, wie man auf dem Hub navigieren kann.

<Youtube id="XvSGPZFEjDY"/>

Ein huggingface.co Account ist für den folgenden Teil erforderlich, da wir Repositories auf dem Hugging Face Hub erstellen und verwalten werden: [Account erstellen](https://huggingface.co/join)


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter4/1.mdx" />