import{s as Ie,a as Te,n as Ce,o as ke}from"../chunks/scheduler.cc52f4b9.js";import{S as Ge,i as Ze,e as i,s as l,c as h,h as xe,a as r,d as s,b as n,f as re,g as M,j as u,k as o,l as Be,m as a,n as d,t as y,o as w,p as f}from"../chunks/index.5b747fde.js";import{C as ve,H as pe,E as $e}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{C as ge}from"../chunks/CodeBlock.665bfc37.js";import{C as Ae}from"../chunks/CourseFloatingBanner.b33fcd79.js";function We(ce){let m,q,Q,N,b,R,J,_,j,Y,U,ue="Now that we can build and share a basic interface, let’s explore some more advanced features such as state, and interpretation.",z,T,X,g,me=`Gradio supports <em>session state</em>, where data persists across multiple submits within a
page load. Session state is useful for building demos of, for example, chatbots where you want to
persist data as the user interacts with the model. Note that session state does not share data between different users of your model.`,V,I,he="To store data in a session state, you need to do three things:",F,C,Me="<li>Pass in an <em>extra parameter</em> into your function, which represents the state of the interface.</li> <li>At the end of the function, return the updated value of the state as an <em>extra return value</em>.</li> <li>Add the ‘state’ input and ‘state’ output components when creating your <code>Interface</code>.</li>",H,k,de="See the chatbot example below:",L,G,D,p,ye,K,Z,we=`Notice how the state of the output component persists across submits.
Note: you can pass in a default value to the state parameter,
which is used as the initial value of the state.`,P,x,O,B,fe="Most machine learning models are black boxes and the internal logic of the function is hidden from the end user. To encourage transparency, we’ve made it very easy to add interpretation to your model by simply setting the interpretation keyword in the Interface class to default. This allows your users to understand what parts of the input are responsible for the output. Take a look at the simple interface below which shows an image classifier that also includes interpretation:",ee,v,te,$,be="Test the interpretation function by submitting an input then clicking Interpret under the output component.",se,c,Je,ae,A,je=`Besides the default interpretation method Gradio provides, you can also specify <code>shap</code> for the <code>interpretation</code> parameter and set the <code>num_shap</code> parameter. This uses Shapley-based interpretation, which you can read more about <a href="https://christophm.github.io/interpretable-ml-book/shap.html" rel="nofollow">here</a>.
Lastly, you can also pass in your own interpretation function into the <code>interpretation</code> parameter. See an example in Gradio’s getting started page <a href="https://gradio.app/getting_started/" rel="nofollow">here</a>.`,le,W,Ue="This wraps up our deep dive into the <code>Interface</code> class of Gradio. As we’ve seen, this class makes it simple to create machine learning demos in a few lines of Python code. However, sometimes you’ll want to customise your demo by changing the layout or chaining multiple prediction functions together. Wouldn’t it be nice if we could somehow split the <code>Interface</code> into customizable “blocks”? Fortunately, there is! That’s the topic of the final section.",ne,S,oe,E,ie;return b=new ve({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new pe({props:{title:"Advanced Interface features",local:"advanced-interface-features",headingTag:"h1"}}),j=new Ae({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"}]}}),T=new pe({props:{title:"Using state to persist data",local:"using-state-to-persist-data",headingTag:"h3"}}),G=new ge({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYXQobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwaGlzdG9yeSUyMCUzRCUyMGhpc3RvcnklMjBvciUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZS5zdGFydHN3aXRoKCUyMkhvdyUyMG1hbnklMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20ucmFuZGludCgxJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJIb3clMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20uY2hvaWNlKCU1QiUyMkdyZWF0JTIyJTJDJTIwJTIyR29vZCUyMiUyQyUyMCUyMk9rYXklMjIlMkMlMjAlMjJCYWQlMjIlNUQpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJXaGVyZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJhbmRvbS5jaG9pY2UoJTVCJTIySGVyZSUyMiUyQyUyMCUyMlRoZXJlJTIyJTJDJTIwJTIyU29tZXdoZXJlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMCUyMkklMjBkb24ndCUyMGtub3clMjIlMEElMjAlMjAlMjAlMjBoaXN0b3J5LmFwcGVuZCgobWVzc2FnZSUyQyUyMHJlc3BvbnNlKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaXN0b3J5JTJDJTIwaGlzdG9yeSUwQSUwQSUwQWlmYWNlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGNoYXQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJ0ZXh0JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJjaGF0Ym90JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19zY3JlZW5zaG90JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19mbGFnZ2luZyUzRCUyMm5ldmVyJTIyJTJDJTBBKSUwQWlmYWNlLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history</span>):
    history = history <span class="hljs-keyword">or</span> []
    <span class="hljs-keyword">if</span> message.startswith(<span class="hljs-string">&quot;How many&quot;</span>):
        response = random.randint(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>)
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;How&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Great&quot;</span>, <span class="hljs-string">&quot;Good&quot;</span>, <span class="hljs-string">&quot;Okay&quot;</span>, <span class="hljs-string">&quot;Bad&quot;</span>])
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;Where&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Here&quot;</span>, <span class="hljs-string">&quot;There&quot;</span>, <span class="hljs-string">&quot;Somewhere&quot;</span>])
    <span class="hljs-keyword">else</span>:
        response = <span class="hljs-string">&quot;I don&#x27;t know&quot;</span>
    history.append((message, response))
    <span class="hljs-keyword">return</span> history, history


iface = gr.Interface(
    chat,
    [<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    [<span class="hljs-string">&quot;chatbot&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    allow_screenshot=<span class="hljs-literal">False</span>,
    allow_flagging=<span class="hljs-string">&quot;never&quot;</span>,
)
iface.launch()`,wrap:!1}}),x=new pe({props:{title:"Using interpretation to understand predictions",local:"using-interpretation-to-understand-predictions",headingTag:"h3"}}),v=new ge({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3IlMEElMEFpbmNlcHRpb25fbmV0JTIwJTNEJTIwdGYua2VyYXMuYXBwbGljYXRpb25zLk1vYmlsZU5ldFYyKCklMjAlMjAlMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGh1bWFuLXJlYWRhYmxlJTIwbGFiZWxzJTIwZm9yJTIwSW1hZ2VOZXQuJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZnaXQuaW8lMkZKSmtZTiUyMiklMEFsYWJlbHMlMjAlM0QlMjByZXNwb25zZS50ZXh0LnNwbGl0KCUyMiU1Q24lMjIpJTBBJTBBJTBBZGVmJTIwY2xhc3NpZnlfaW1hZ2UoaW5wKSUzQSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMGlucC5yZXNoYXBlKCgtMSUyQyUyMDIyNCUyQyUyMDIyNCUyQyUyMDMpKSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMHRmLmtlcmFzLmFwcGxpY2F0aW9ucy5tb2JpbGVuZXRfdjIucHJlcHJvY2Vzc19pbnB1dChpbnApJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbiUyMCUzRCUyMGluY2VwdGlvbl9uZXQucHJlZGljdChpbnApLmZsYXR0ZW4oKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QmxhYmVscyU1QmklNUQlM0ElMjBmbG9hdChwcmVkaWN0aW9uJTVCaSU1RCklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDAwKSU3RCUwQSUwQSUwQWltYWdlJTIwJTNEJTIwZ3IuSW1hZ2Uoc2hhcGUlM0QoMjI0JTJDJTIwMjI0KSklMEFsYWJlbCUyMCUzRCUyMGdyLkxhYmVsKG51bV90b3BfY2xhc3NlcyUzRDMpJTBBJTBBdGl0bGUlMjAlM0QlMjAlMjJHcmFkaW8lMjBJbWFnZSUyMENsYXNzaWZpY3Rpb24lMjAlMkIlMjBJbnRlcnByZXRhdGlvbiUyMEV4YW1wbGUlMjIlMEFnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9pbWFnZSUyQyUyMGlucHV0cyUzRGltYWdlJTJDJTIwb3V0cHV0cyUzRGxhYmVsJTJDJTIwaW50ZXJwcmV0YXRpb24lM0QlMjJkZWZhdWx0JTIyJTJDJTIwdGl0bGUlM0R0aXRsZSUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

inception_net = tf.keras.applications.MobileNetV2()  <span class="hljs-comment"># load the model</span>

<span class="hljs-comment"># Download human-readable labels for ImageNet.</span>
response = requests.get(<span class="hljs-string">&quot;https://git.io/JJkYN&quot;</span>)
labels = response.text.split(<span class="hljs-string">&quot;\\n&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_image</span>(<span class="hljs-params">inp</span>):
    inp = inp.reshape((-<span class="hljs-number">1</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>, <span class="hljs-number">3</span>))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    <span class="hljs-keyword">return</span> {labels[i]: <span class="hljs-built_in">float</span>(prediction[i]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)}


image = gr.Image(shape=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
label = gr.Label(num_top_classes=<span class="hljs-number">3</span>)

title = <span class="hljs-string">&quot;Gradio Image Classifiction + Interpretation Example&quot;</span>
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation=<span class="hljs-string">&quot;default&quot;</span>, title=title
).launch()`,wrap:!1}}),S=new $e({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter9/6.mdx"}}),{c(){m=i("meta"),q=l(),Q=i("p"),N=l(),h(b.$$.fragment),R=l(),h(J.$$.fragment),_=l(),h(j.$$.fragment),Y=l(),U=i("p"),U.textContent=ue,z=l(),h(T.$$.fragment),X=l(),g=i("p"),g.innerHTML=me,V=l(),I=i("p"),I.textContent=he,F=l(),C=i("ol"),C.innerHTML=Me,H=l(),k=i("p"),k.textContent=de,L=l(),h(G.$$.fragment),D=l(),p=i("iframe"),K=l(),Z=i("p"),Z.textContent=we,P=l(),h(x.$$.fragment),O=l(),B=i("p"),B.textContent=fe,ee=l(),h(v.$$.fragment),te=l(),$=i("p"),$.textContent=be,se=l(),c=i("iframe"),ae=l(),A=i("p"),A.innerHTML=je,le=l(),W=i("p"),W.innerHTML=Ue,ne=l(),h(S.$$.fragment),oe=l(),E=i("p"),this.h()},l(e){const t=xe("svelte-u9bgzb",document.head);m=r(t,"META",{name:!0,content:!0}),t.forEach(s),q=n(e),Q=r(e,"P",{}),re(Q).forEach(s),N=n(e),M(b.$$.fragment,e),R=n(e),M(J.$$.fragment,e),_=n(e),M(j.$$.fragment,e),Y=n(e),U=r(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-ot4lbi"&&(U.textContent=ue),z=n(e),M(T.$$.fragment,e),X=n(e),g=r(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-npz0qc"&&(g.innerHTML=me),V=n(e),I=r(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1g0d8ct"&&(I.textContent=he),F=n(e),C=r(e,"OL",{"data-svelte-h":!0}),u(C)!=="svelte-hwpt2s"&&(C.innerHTML=Me),H=n(e),k=r(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1qrri7m"&&(k.textContent=de),L=n(e),M(G.$$.fragment,e),D=n(e),p=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(p).forEach(s),K=n(e),Z=r(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1a0cfxw"&&(Z.textContent=we),P=n(e),M(x.$$.fragment,e),O=n(e),B=r(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-vt0h2q"&&(B.textContent=fe),ee=n(e),M(v.$$.fragment,e),te=n(e),$=r(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1nf2s8k"&&($.textContent=be),se=n(e),c=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(c).forEach(s),ae=n(e),A=r(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1qf8hkk"&&(A.innerHTML=je),le=n(e),W=r(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1bt3ks"&&(W.innerHTML=Ue),ne=n(e),M(S.$$.fragment,e),oe=n(e),E=r(e,"P",{}),re(E).forEach(s),this.h()},h(){o(m,"name","hf:doc:metadata"),o(m,"content",Se),Te(p.src,ye="https://course-demos-Chatbot-Demo.hf.space")||o(p,"src",ye),o(p,"frameborder","0"),o(p,"height","350"),o(p,"title","Gradio app"),o(p,"class","container p-0 flex-grow space-iframe"),o(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),Te(c.src,Je="https://course-demos-gradio-image-interpretation.hf.space")||o(c,"src",Je),o(c,"frameborder","0"),o(c,"height","570"),o(c,"title","Gradio app"),o(c,"class","container p-0 flex-grow space-iframe"),o(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Be(document.head,m),a(e,q,t),a(e,Q,t),a(e,N,t),d(b,e,t),a(e,R,t),d(J,e,t),a(e,_,t),d(j,e,t),a(e,Y,t),a(e,U,t),a(e,z,t),d(T,e,t),a(e,X,t),a(e,g,t),a(e,V,t),a(e,I,t),a(e,F,t),a(e,C,t),a(e,H,t),a(e,k,t),a(e,L,t),d(G,e,t),a(e,D,t),a(e,p,t),a(e,K,t),a(e,Z,t),a(e,P,t),d(x,e,t),a(e,O,t),a(e,B,t),a(e,ee,t),d(v,e,t),a(e,te,t),a(e,$,t),a(e,se,t),a(e,c,t),a(e,ae,t),a(e,A,t),a(e,le,t),a(e,W,t),a(e,ne,t),d(S,e,t),a(e,oe,t),a(e,E,t),ie=!0},p:Ce,i(e){ie||(y(b.$$.fragment,e),y(J.$$.fragment,e),y(j.$$.fragment,e),y(T.$$.fragment,e),y(G.$$.fragment,e),y(x.$$.fragment,e),y(v.$$.fragment,e),y(S.$$.fragment,e),ie=!0)},o(e){w(b.$$.fragment,e),w(J.$$.fragment,e),w(j.$$.fragment,e),w(T.$$.fragment,e),w(G.$$.fragment,e),w(x.$$.fragment,e),w(v.$$.fragment,e),w(S.$$.fragment,e),ie=!1},d(e){e&&(s(q),s(Q),s(N),s(R),s(_),s(Y),s(U),s(z),s(X),s(g),s(V),s(I),s(F),s(C),s(H),s(k),s(L),s(D),s(p),s(K),s(Z),s(P),s(O),s(B),s(ee),s(te),s($),s(se),s(c),s(ae),s(A),s(le),s(W),s(ne),s(oe),s(E)),s(m),f(b,e),f(J,e),f(j,e),f(T,e),f(G,e),f(x,e),f(v,e),f(S,e)}}}const Se='{"title":"Advanced Interface features","local":"advanced-interface-features","sections":[{"title":"Using state to persist data","local":"using-state-to-persist-data","sections":[],"depth":3},{"title":"Using interpretation to understand predictions","local":"using-interpretation-to-understand-predictions","sections":[],"depth":3}],"depth":1}';function Qe(ce){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends Ge{constructor(m){super(),Ze(this,m,Qe,We,Ie,{})}}export{Ye as component};
