# Quiz de final de capítulo

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. ¿Cuál es el orden del pipeline de modelado del lenguaje?

<Question
	choices={[
		{
			text: "Primero, el modelo que maneja el texto y devuelve las peticiones sin procesar. El tokenizador luego da sentido a estas predicciones y las convierte nuevamente en texto cuando es necesario.",
			explain: "¡El modelo no puede entender texto! El tokenizador primero debe tokenizar el texto y convertirlo a IDs para que así sea comprensible por el modelo."
		},
		{
			text: "Primero, el tokenizador, que maneja el texto y regresa IDs. El modelo maneja estos IDs y produce una predicción, la cual puede ser algún texto.",
			explain: "La predicción del modelo no puede ser texto de forma directa. ¡El tokenizador tiene que ser usado de tal forma que convierta la predicción de vuelta a texto!"
		},
		{
			text: "El tokenizador maneja texto y regresa IDs. El modelo maneja estos IDs y produce una predicción. El tokenizador puede luego ser usado de nuevo para convertir estas predicciones de vuelta a texto.",
			explain: "¡Correcto! El tokenizador puede ser usado tanto para tokenizar como des-tokenizar.",
            correct: true
		}
	]}
/>

### 2. ¿Cuántas dimensiones tiene el tensor producido por el modelo base de Transformer y cuáles son?

<Question
	choices={[
		{
			text: "1: La longitud de secuencia y el tamaño del lote",
			explain: "¡Falso! El tensor producido por el modelo tiene una tercer dimensión: tamaño oculto."
		},
		{
			text: "2: La longitud de secuencia y el tamaño oculto",
			explain: "¡Falso! All Todos los modelos Transformer manejan lotes, aún con una sola secuencia; lo cual sería un lote de tamaño 1!"
		},
		{
			text: "3: La longitud de secuencia, el tamaño de lote y el tamaño oculto",
			explain: "¡Correcto!",
            correct: true
		}
	]}
/>

### 3. ¿Cuál de los siguientes es un ejemplo de tokenización de subpalabras?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "¡Sí ese es un ejemplo de tokenización de subpalabras!",
            correct: true
		},
		{
			text: "Tokenización basada en caracteres",
			explain: "La tokenización basada en caracteres no es un tipo de tokenización de subpalabras."
		},
		{
			text: "División por espacios en blanco y puntuación",
			explain: "¡Ese es un esquema de tokenización basado en palabras!"
		},
		{
			text: "BPE",
			explain: "¡Sí ese es un ejemplo de tokenización de subpalabras!",
            correct: true
        },
		{
			text: "Unigrama",
			explain: "¡Sí ese es un ejemplo de tokenización de subpalabras!",
            correct: true
        },
		{
			text: "Ninguno de los anteriores",
			explain: "¡Incorrecto!"
        }
	]}
/>

### 4. ¿Qué es una cabeza del modelo?

<Question
	choices={[
		{
			text: "Un componente de la red de Transformer base que redirecciona los tensores a sus capas correctas",
			explain: "¡Incorrecto! No hay tal componente."
		},
		{
			text: "También conocido como el mecanismo de autoatención, adapta la representación de un token de acuerdo a los otros tokens de la secuencia", 
			explain: "¡Incorrecto! La capa de autoatención contiene \"cabezas\", pero éstas no son cabezas de adaptación."
		},
		{
			text: "Un componente adicional, compuesto usualmente de una o unas pocas capas, para convertir las predicciones del transformador a una salida específica de la tarea",
			explain: "Así es, Las cabezas de adaptación, también conocidas simplemente como cabezas, vienen en diferentes formas: cabezas de modelado de lenguaje, cabezas de respuesta a preguntas, cabezas de clasificación de secuencia... ",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. ¿Qué es un AutoModel?

<Question
	choices={[
		{
			text: "Un modelo que entrena automáticamente en tus datos",
			explain: "Incorrecto. ¿Estás confundiendo esto con nuestro producto <a href='https://huggingface.co/autotrain'>AutoTrain</a>?"
		},
		{
			text: "Un objeto que devuelve la arquitectura correcta basado en el punto de control",
			explain: "Exacto: el <code>AutoModel</code> sólo necesita conocer el punto de control desde el cual inicializar para devolver la arquitectura correcta.",
			correct: true
		},
		{
			text: "Un modelo que detecta automáticamente el lenguaje usado por sus entradas para cargar los pesos correctos",
			explain: "Incorrecto; aunque algunos puntos de control y modelos son capaces de manejar varios lenguajes, no hay herramientas integradas para la selección automática de punto de control de acuerdo al lenguaje. ¡Deberías dirigirte a <a href='https://huggingface.co/models'>Model Hub</a> para encontrar el mejor punto de control para tu tarea!"
		} 
	]}
/>

{:else}
### 5. ¿Qué es un TFAutoModel?

<Question
	choices={[
		{
			text: "Un modelo que entrena automáticamente en tus datos",
			explain: "Incorrecto. ¿Estás confundiendo esto con nuestro producto <a href='https://huggingface.co/autotrain'>AutoTrain</a>?"
		},
		{
			text: "Un objeto que devuelve la arquitectura correcta basado en el punto de control",
			explain: "Exacto: el <code>TFAutoModel</code> sólo necesita conocer el punto de control desde el cual inicializar para devolver la arquitectura correcta.",
			correct: true
		},
		{
			text: "Un modelo que detecta automáticamente el lenguaje usado por sus entradas para cargar los pesos correctos",
			explain: "Incorrecto; aunque algunos puntos de control y modelos son capaces de manejar varios lenguajes, no hay herramientas integradas para la selección automática de punto de control de acuerdo al lenguaje. ¡Deberías dirigirte a <a href='https://huggingface.co/models'>Model Hub</a> para encontrar el mejor punto de control para tu tarea!"
		} 
	]}
/>

{/if}

### 6. ¿Cuáles son las técnicas a tener en cuenta al realizar batching de secuencias de diferentes longitudes juntas?

<Question
	choices={[
		{
			text: "Truncado",
			explain: "Sí, el truncamiento es una forma correcta de emparejar secuencias de modo que se ajusten a una forma rectangular. ¿Aunque, es la única?",
			correct: true
		},
		{
			text: "Returning tensors",
			explain: "Mientras las otras técnicas te permiten devolver tensores rectangulares, returning tensors no es útil cuando se hace batching en secuencias juntas."
		},
		{
			text: "Relleno",
			explain: "Sí, el relleno es una forma correcta de emparejar secuencias de modo que se ajusten a una forma rectangular. ¿Aunque, es la única?",
			correct: true
		}, 
		{
			text: "Enmascarado de atención",
			explain: "¡Absolutamente! Las máscaras de atención son de primera importancia cuando se manejan secuencias de diferentes longitudes. Sin embargo, no es la única técnica a tener en cuenta.",
			correct: true
		} 
	]}
/>

### 7. ¿Cuál es el punto de aplicar una función SoftMax a las salidas logits por un modelo de clasificación de secuencias?

<Question
	choices={[
		{
			text: "Suaviza los logits para que sean más fiables.",
			explain: "No, la función SoftMax no afecta en la fiabilidad de los resultados."
		},
		{
			text: "Aplica un límite inferior y superior de modo que sean comprensibles.",
			explain: "¡Correcto! Los valores resultantes están limitados entre 0 y 1. Aunque, no es la única razón por la cual usamos una función SoftMax.",
            correct: true
		},
		{
			text: "La suma total de la salida es entonces 1, dando como resultado una posible interpretación probabilística.",
			explain: "¡Correcto! Aunque, esa no es la única razón por la que usamos una función SoftMax.",
            correct: true
		}
	]}
/>

### 8. ¿En qué método se centra la mayor parte de la API del tokenizador?

<Question
	choices={[
		{
			text: "<code>encode</code>, ya que puede codificar texto en IDs e IDs en predicciones",
			explain: "¡Incorrecto! Aunque el método <code>encode</code> existe en los tokenizadores, no existe en los modelos." 
		},
		{
			text: "Llamar al objeto tokenizador directamente.",
			explain: "¡Exactamente! El método <code>__call__</code> del tokenizador es un método muy poderoso el cual puede manejar casi cualquier cosa.También es el método usado para recuperar las predicciones de un modelo.",
			correct: true
		},
		{
			text: "<code>pad</code>",
			explain: "¡Incorrecto! El relleno es muy útil, pero es solo una parte de la API tokenizador."
		},
		{
			text: "<code>tokenize</code>",
			explain: "El método <code>tokenize</code> es posiblemente uno de los métodos más útiles, pero no es el núcleo de la API tokenizador."
		}
	]}
/>

### 9. ¿Qué contiene la variable `result` en este código de ejemplo?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "Una lista de strings, cada string es un token",
			explain: "¡Por supuesto! ¡Convierte esto a IDs, y los envía a los modelos!",
            correct: true
		},
		{
			text: "Una lista de IDs",
			explain: "Incorrecto; ¡para eso están los métodos <code>__call__</code> o <code>convert_tokens_to_ids</code>!"
		},
		{
			text: "Una cadena que contiene todos los tokens",
			explain: "Esto sería subóptimo, ya que el objetivo es dividir la cadena en varios tokens."
		}
	]}
/>

{#if fw === 'pt'}
### 10. ¿Hay algo mal con el siguiente código?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "No, parece correcto.",
			explain: "Desafortunadamente, acoplar un modelo con un tokenizador que fue entrenado con un punto de control distinto raramente es una buena idea. El modelo no fue entrenado para dar sentido a la salida de este tokenizador, así la salida del modelo (¡si es que puede correr!) no tendrá ningún sentido."
		},
		{
			text: "El tokenizador y el modelo siempre deben ser del mismo punto de control.",
			explain: "¡Correcto!",
            correct: true
		},
		{
			text: "Es una buena práctica rellenar y truncar con el tokenizador ya que cada entrada es un lote.",
			explain: "Es cierto que cada entrada de modelo necesita ser un lote. Sin embargo, truncar o rellenar esta secuencia no necesariamente hace sentido ya que sólo hay una, y esas son técnicas para juntar una lista de oraciones."
		}
	]}
/>

{:else}
### 10. ¿Hay algo mal con el siguiente código?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "No, parece correcto.",
			explain: "Desafortunadamente, acoplar un modelo con un tokenizador que fue entrenado con un punto de control distinto raramente es una buena idea. El modelo no fue entrenado para dar sentido a la salida de este tokenizador, así la salida del modelo (¡si es que puede correr!) no tendrá ningún sentido."
		},
		{
			text: "El tokenizador y el modelo siempre deben ser del mismo punto de control.",
			explain: "¡Correcto!",
            correct: true
		},
		{
			text: "Es una buena práctica rellenar y truncar con el tokenizador ya que cada entrada es un lote.",
			explain: "Es cierto que cada entrada de modelo necesita ser un lote. Sin embargo, truncar o rellenar esta secuencia no necesariamente hace sentido ya que sólo hay una, y esas son técnicas para juntar una lista de oraciones."
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter2/8.mdx" />