import{s as qn,o as Bn,n as An}from"../chunks/scheduler.cc52f4b9.js";import{S as Zn,i as Xn,e as i,s as l,c as p,h as Nn,a as r,d as n,b as a,f as Vn,g as u,j as J,k as _n,l as En,m as t,n as o,t as c,o as m,p as M}from"../chunks/index.9480bb2b.js";import{T as Gn}from"../chunks/Tip.f7b80743.js";import{C as Wn,H as Fs,E as Hn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as Dn}from"../chunks/Youtube.7b12d9e8.js";import{C as d}from"../chunks/CodeBlock.f4148b32.js";import{C as Rn}from"../chunks/CourseFloatingBanner.cdc38ef1.js";function Yn(qe){let y,T="⚠️ Entraîner un <em>tokenizer</em> n’est pas la même chose qu’entraîner un modèle ! L’entraînement du modèle utilise la descente de gradient stochastique pour réduire un peu plus la perte à chaque batch. Il est par nature aléatoire (ce qui signifie que vous devez définir des graines pour obtenir les mêmes résultats lorsque vous effectuez deux fois le même entraînement). Entraîner un <em>tokenizer</em> est un processus statistique qui identifie les meilleurs sous-mots à choisir pour un corpus donné. Les règles exactes utilisées pour les choisir dépendent de l’algorithme de tokénisation. Le processus est déterministe, ce qui signifie que vous obtenez toujours les mêmes résultats lorsque vous vous entraînez avec le même algorithme sur le même corpus.";return{c(){y=i("p"),y.innerHTML=T},l(j){y=r(j,"P",{"data-svelte-h":!0}),J(y)!=="svelte-1nhpa41"&&(y.innerHTML=T)},m(j,Ve){t(j,y,Ve)},p:An,d(j){j&&n(y)}}}function Sn(qe){let y,T,j,Ve,x,Be,f,Ae,g,Ze,U,Ks='Si un modèle de langue n’est pas disponible dans la langue qui vous intéresse ou si votre corpus est très différent de celui sur lequel votre modèle de langue a été entraîné, vous voudrez très probablement réentraîner le modèle à partir de zéro en utilisant un <em>tokenizer</em> adapté à vos données. Pour ce faire, vous devrez entraîner un nouveau <em>tokenizer</em> sur votre jeu de données. Mais qu’est-ce que cela signifie exactement ? Lorsque nous avons examiné pour la première fois les <em>tokenizers</em> dans le <a href="/course/fr/chapter2">chapitre 2</a>, nous avons vu que la plupart des <em>transformers</em> utilisent un <em>algorithme de tokenisation en sous-mots</em>. Pour identifier les sous-mots qui sont intéressants et qui apparaissent le plus fréquemment dans un corpus donné, le <em>tokenizer</em> doit examiner attentivement tous les textes du corpus. C’est un processus que nous appelons <em>entraînement</em>. Les règles exactes qui régissent cet apprentissage dépendent du type de <em>tokenizer</em> utilisé. Nous passerons en revue les trois principaux algorithmes plus loin dans ce chapitre.',Xe,w,Ne,h,Ee,b,Ge,v,Os="Il y a une API très simple dans 🤗 <em>Transformers</em> que vous pouvez utiliser pour entraîner un nouveau <em>tokenizer</em> avec les mêmes caractéristiques qu’un déjà existant : <code>AutoTokenizer.train_new_from_iterator()</code>. Pour illustrer cela, disons que nous voulons entraîner GPT-2 à partir de zéro mais dans une langue autre que l’anglais. Notre première tâche est de rassembler des batchs de données dans cette langue dans un corpus d’entraînement. Pour avoir des exemples que tout le monde puisse comprendre, nous n’utiliserons pas ici une langue comme le russe ou le chinois mais plutôt une langue anglaise spécialisée : le langage Python.",We,C,en='La bibliothèque <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 <em>Datasets</em></a> peut nous aider à assembler un corpus de code source Python. Nous allons utiliser la fonction habituelle <code>load_dataset()</code> pour télécharger et mettre en cache le jeu de données <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a>. Ce jeu de données a été créé pour le <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> et contient des millions de fonctions provenant de bibliothèques open source sur GitHub dans plusieurs langages de programmation. Ici, nous allons charger la partie Python de ce jeu de données :',He,$,De,Q,sn="Nous pouvons jeter un coup d’œil au jeu d’entraînement pour voir quelles sont les colonnes auxquelles nous avons accès :",Re,k,Ye,I,Se,z,nn="Nous pouvons voir que le jeu de données sépare les chaînes de documents du code et suggère une tokenization des deux. Ici, nous utiliserons simplement la colonne <code>whole_func_string</code> pour entraîner notre <em>tokenizer</em>. Nous pouvons regarder un exemple de la façon suivante :",Le,V,Pe,_,tn="qui nous affiche ce qui suit :",Fe,q,Ke,B,ln="La première chose à faire est de transformer le jeu de données en un <em>itérateur</em> de listes de textes. Par exemple, une liste de listes de textes. L’utilisation de listes de textes permet à notre <em>tokenizer</em> d’aller plus vite (l’entraînement a alors lieu sur des batchs de textes au lieu de traiter des textes un par un). Et le fait que ce soit un itérateur permet d’éviter d’avoir tout en mémoire en même temps. Si votre corpus est énorme, vous voudrez profiter du fait que 🤗 <em>Datasets</em> ne charge pas tout en RAM mais stocke les éléments du jeu de données sur le disque.",Oe,A,an="Faire ce qui suit créerait une liste de listes de 1 000 textes chacune mais chargerait tout en mémoire :",es,Z,ss,X,rn="En utilisant un générateur, nous pouvons éviter que Python ne charge quoi que ce soit en mémoire à moins que cela soit réellement nécessaire. Pour créer un tel générateur, il suffit de remplacer les crochets par des parenthèses :",ns,N,ts,E,pn="Cette ligne de code ne récupère aucun élément du jeu de données. Elle crée simplement un objet que vous pouvez utiliser dans une boucle <code>for</code> Python. Les textes ne seront chargés que lorsque vous en aurez besoin (c’est-à-dire lorsque vous serez à l’étape de la boucle <code>for</code> qui les requiert) et seulement 1 000 textes à la fois. De cette façon, vous n’épuiserez pas toute votre mémoire, même si vous traitez un énorme jeu de données.",ls,G,un="Le problème avec un objet générateur est qu’il ne peut être utilisé qu’une seule fois. Ainsi, au lieu que cet objet nous donne deux fois la liste des 10 premiers chiffres :",as,W,is,H,on="on les reçoit une fois et ensuite une liste vide :",rs,D,ps,R,cn="C’est pourquoi nous définissons une fonction qui renvoie un générateur à la place :",us,Y,os,S,mn="Vous pouvez également définir votre générateur à l’intérieur d’une boucle <code>for</code> en utilisant l’instruction <code>yield</code> :",cs,L,ms,P,Mn="qui produit exactement le même générateur que précédemment mais  permet d’utiliser une logique plus complexe que celle que vous pouvez utiliser dans une compréhension de liste.",Ms,F,Js,K,Jn="Maintenant que nous avons notre corpus sous la forme d’un itérateur de batchs de textes, nous sommes prêts à entraîner un nouveau <em>tokenizer</em>. Pour ce faire, nous devons d’abord charger le <em>tokenizer</em> que nous voulons coupler avec notre modèle (ici, le GPT-2) :",ds,O,ys,ee,dn="Même si nous allons entraîner un nouveau <em>tokenizer</em>, c’est une bonne idée de faire ça pour éviter de partir entièrement de zéro. De cette façon, nous n’aurons pas à spécifier l’algorithme de tokénisation ou les jetons spéciaux que nous voulons utiliser. Notre nouveau <em>tokenizer</em> sera exactement le même que celui du GPT-2. La seule chose qui changera sera le vocabulaire qui sera déterminé lors de l’entraînement sur notre corpus.",js,se,yn="Voyons d’abord comment ce <em>tokenizer</em> traiterait un exemple de fonction :",hs,ne,Ts,te,xs,le,jn="Ce <em>tokenizer</em> possède quelques symboles spéciaux, comme <code>Ġ</code> et <code>Ċ</code>, qui désignent respectivement les espaces et les retours à la ligne. Comme on peut le voir, ce n’est pas très efficace. Le <em>tokenizer</em> renvoie des jetons individuels pour chaque espace alors qu’il pourrait regrouper ceux des indentations (puisqu’avoir des ensembles de quatre ou huit espaces est très courant dans du code). Il divise également le nom de la fonction de façon un peu bizarre car pas habitué à voir des mots avec le caractère <code>_</code>.",fs,ae,hn="Entraînons un nouveau <em>tokenizer</em> et voyons s’il résout ces problèmes. Pour cela, nous allons utiliser la méthode <code>train_new_from_iterator()</code> :",gs,ie,Us,re,Tn="Cette commande peut prendre un peu de temps si votre corpus est très grand. Pour ce jeu de données de 1,6 Go de textes, elle est très rapide (1 minute 16 secondes sur un CPU AMD Ryzen 9 3900X avec 12 cœurs).",ws,pe,xn='Notez que <code>AutoTokenizer.train_new_from_iterator()</code> ne fonctionne que si le <em>tokenizer</em> que vous utilisez est un <em>tokenizer</em> « rapide ». Comme vous le verrez dans la section suivante, la bibliothèque 🤗 <em>Transformers</em> contient deux types de <em>tokenizers</em> : certains sont écrits en pur Python et d’autres (les rapides) sont soutenus par la bibliothèque 🤗 <em>Tokenizers</em> qui est écrite dans le langage <a href="https://www.rust-lang.org" rel="nofollow">Rust</a>. Python est le langage le plus souvent utilisé pour les applications de science des données et d’apprentissage profond, mais lorsque quelque chose doit être parallélisé pour être rapide, il faut que cela soit écrit dans un autre langage. Par exemple, les multiplications matricielles qui sont au cœur du calcul du modèle sont écrites en CUDA, une bibliothèque en C optimisée pour les GPUs.',bs,ue,fn='Entraîner un tout nouveau <em>tokenizer</em> en Python pur est atrocement lent, c’est pourquoi nous avons développé la bibliothèque 🤗 <em>Tokenizers</em>. Notez que, tout comme vous n’avez pas eu à apprendre le langage CUDA pour pouvoir exécuter votre modèle sur un batch d’entrées sur un GPU, vous n’aurez pas besoin d’apprendre Rust pour utiliser un <em>tokenizer</em> rapide. La bibliothèque 🤗 <em>Tokenizers</em> fournit des liaisons Python pour de nombreuses méthodes qui appellent en interne un morceau de code en Rust. Par exemple, pour paralléliser l’entraînement de votre nouveau <em>tokenizer</em> ou, comme nous l’avons vu dans le <a href="/course/fr/chapter3">chapitre 3</a>, la tokenisation d’un lot d’entrées.',vs,oe,gn='La plupart des <em>transformers</em> ont un <em>tokenizer</em> rapide de disponible. Il y a quelques exceptions que vous pouvez vérifier <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">ici</a>. S’il est disponible, l’API <code>AutoTokenizer</code> sélectionne toujours pour vous le <em>tokenizer</em> rapide. Dans la prochaine section, nous allons jeter un coup d’oeil à certaines des autres caractéristiques spéciales des <em>tokenizers</em> rapides, qui seront très utiles pour des tâches comme la classification de <em>tokens</em> et la réponse aux questions. Mais avant cela, essayons notre tout nouveau <em>tokenizer</em> sur l’exemple précédent :',Cs,ce,$s,me,Qs,Me,Un="Ici, nous voyons à nouveau les symboles spéciaux <code>Ġ</code> et <code>Ċ</code> qui indiquent les espaces et les retours à la ligne. Nous pouvons également voir que notre <em>tokenizer</em> a appris certains <em>tokens</em> qui sont très spécifiques à un corpus de fonctions Python. Par exemple, il y a un token <code>ĊĠĠĠ</code> qui représente une indentation et un <em>token</em> <code>Ġ&quot;&quot;&quot;</code> qui représente les trois guillemets qui commencent une <em>docstring</em>. Le <em>tokenizer</em> divise également correctement le nom de la fonction sur <code>_</code>. Il s’agit d’une représentation assez compacte. En comparaison, l’utilisation du <em>tokenizer</em> en anglais « simple » sur le même exemple nous donnera une phrase plus longue :",ks,Je,Is,de,zs,ye,wn="Prenons un autre exemple :",Vs,je,_s,he,qs,Te,bn="En plus du <em>token</em> correspondant à une indentation, on peut également voir ici un <em>token</em> pour une double indentation : <code>ĊĠĠĠĠĠĠĠĠĠ</code>. Les mots spéciaux de Python comme <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, et <code>return</code> sont tous tokenizés comme un seul <em>token</em>. Nous pouvons voir qu’en plus de séparer sur <code>_</code> et <code>.</code> le tokenizer sépare correctement même les noms en minuscules. Par exemple <code>LinearLayer</code> est tokenisé comme <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>.",Bs,xe,As,fe,vn="Pour être sûr de pouvoir l’utiliser plus tard, nous devons sauvegarder notre nouveau <em>tokenizer</em>. Comme pour les modèles, ceci est fait avec la méthode <code>save_pretrained()</code> :",Zs,ge,Xs,Ue,Cn="Cela créera un nouveau dossier nommé <em>code-search-net-tokenizer</em> contenant tous les fichiers dont le <em>tokenizer</em> a besoin pour être rechargé. Si vous souhaitez partager ce <em>tokenizer</em> avec vos collègues et amis, vous pouvez le télécharger sur le <em>Hub</em> en vous connectant à votre compte. Si vous travaillez dans un <em>notebook</em>, il existe une fonction pratique pour vous aider à le faire :",Ns,we,Es,be,$n="Cela affichera un <em>widget</em> où vous pourrez entrer vos identifiants de connexion à Hugging Face. Si vous ne travaillez pas sur un ordinateur portable, tapez simplement la ligne suivante dans votre terminal :",Gs,ve,Ws,Ce,Qn="Une fois connecté, vous pouvez pousser votre <em>tokenizer</em> en exécutant la commande suivante :",Hs,$e,Ds,Qe,kn="Cela créera un nouveau dépôt dans votre espace avec le nom <code>code-search-net-tokenizer</code> contenant le fichier <em>tokenizer</em>. Vous pouvez ensuite charger le <em>tokenizer</em> de n’importe où avec la méthode <code>from_pretrained()</code> :",Rs,ke,Ys,Ie,In='Vous êtes maintenant prêt à entraîner un modèle de langue à partir de zéro et à le <em>finetuner</em> sur votre tâche ! Nous verrons cela dans le <a href="/course/fr/chapter7">chapitre 7</a>, mais d’abord, dans le reste de ce chapitre, nous allons examiner de plus près les <em>tokenizers</em> rapides et explorer en détail ce qui se passe lorsque nous appelons la méthode <code>train_new_from_iterator()</code>.',Ss,ze,Ls,_e,Ps;return x=new Wn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new Fs({props:{title:"Entraîner un nouveau <i> tokenizer </i> à partir d’un ancien",local:"entraîner-un-nouveau-i-tokenizer-i-à-partir-dun-ancien",headingTag:"h1"}}),g=new Rn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section2.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section2.ipynb"}]}}),w=new Dn({props:{id:"DJimQynXZsQ"}}),h=new Gn({props:{warning:!0,$$slots:{default:[Yn]},$$scope:{ctx:qe}}}),b=new Fs({props:{title:"Assemblage d’un corpus",local:"assemblage-dun-corpus",headingTag:"h2"}}),$=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwQ2VsYSUyMHBldXQlMjBwcmVuZHJlJTIwcXVlbHF1ZXMlMjBtaW51dGVzJTIwYWxvcnMlMjBwcmVuZXolMjB1biUyMHRoJUMzJUE5JTIwb3UlMjB1biUyMGNhZiVDMyVBOSUyMHBlbmRhbnQlMjBxdWUlMjB2b3VzJTIwcGF0aWVudGV6JTIwISUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjb2RlX3NlYXJjaF9uZXQlMjIlMkMlMjAlMjJweXRob24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Cela peut prendre quelques minutes alors prenez un thé ou un café pendant que vous patientez !</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),k=new d({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),I=new d({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),V=new d({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),q=new d({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),Z=new d({props:{code:"JTIzJTIwTmUlMjBkJUMzJUE5Y29tbWVudGV6JTIwcGFzJTIwbGElMjBsaWduZSUyMHN1aXZhbnRlJTIwJUMzJUEwJTIwbW9pbnMlMjBxdWUlMjB2b3RyZSUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwc29pdCUyMHBldGl0JTIwISUwQSUyMyUyMHRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMCU1QnJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTVE",highlighted:`<span class="hljs-comment"># Ne décommentez pas la ligne suivante à moins que votre jeu de données soit petit !</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),N=new d({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),W=new d({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),D=new d({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),Y=new d({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),L=new d({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),F=new Fs({props:{title:"Entraînement d’un nouveau <i> tokenizer </i>",local:"entraînement-dun-nouveau-i-tokenizer-i",headingTag:"h2"}}),O=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),ne=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),te=new d({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),ie=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),ce=new d({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),me=new d({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),Je=new d({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),de=new d({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),je=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),he=new d({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),xe=new Fs({props:{title:"Sauvegarde du <i> tokenizer </i>",local:"sauvegarde-du-i-tokenizer-i",headingTag:"h2"}}),ge=new d({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),we=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ve=new d({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$e=new d({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),ke=new d({props:{code:"JTIzJTIwUmVtcGxhY2V6JTIwJTIyaHVnZ2luZ2ZhY2UtY291cnNlJTIyJTIwY2ktZGVzc291cyUyMHBhciUyMHZvdHJlJTIwZXNwYWNlJTIwciVDMyVBOWVsJTIwcG91ciUyMHV0aWxpc2VyJTIwdm90cmUlMjBwcm9wcmUlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdnaW5nZmFjZS1jb3Vyc2UlMkZjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:`<span class="hljs-comment"># Remplacez &quot;huggingface-course&quot; ci-dessous par votre espace réel pour utiliser votre propre tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),ze=new Hn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter6/2.mdx"}}),{c(){y=i("meta"),T=l(),j=i("p"),Ve=l(),p(x.$$.fragment),Be=l(),p(f.$$.fragment),Ae=l(),p(g.$$.fragment),Ze=l(),U=i("p"),U.innerHTML=Ks,Xe=l(),p(w.$$.fragment),Ne=l(),p(h.$$.fragment),Ee=l(),p(b.$$.fragment),Ge=l(),v=i("p"),v.innerHTML=Os,We=l(),C=i("p"),C.innerHTML=en,He=l(),p($.$$.fragment),De=l(),Q=i("p"),Q.textContent=sn,Re=l(),p(k.$$.fragment),Ye=l(),p(I.$$.fragment),Se=l(),z=i("p"),z.innerHTML=nn,Le=l(),p(V.$$.fragment),Pe=l(),_=i("p"),_.textContent=tn,Fe=l(),p(q.$$.fragment),Ke=l(),B=i("p"),B.innerHTML=ln,Oe=l(),A=i("p"),A.textContent=an,es=l(),p(Z.$$.fragment),ss=l(),X=i("p"),X.textContent=rn,ns=l(),p(N.$$.fragment),ts=l(),E=i("p"),E.innerHTML=pn,ls=l(),G=i("p"),G.textContent=un,as=l(),p(W.$$.fragment),is=l(),H=i("p"),H.textContent=on,rs=l(),p(D.$$.fragment),ps=l(),R=i("p"),R.textContent=cn,us=l(),p(Y.$$.fragment),os=l(),S=i("p"),S.innerHTML=mn,cs=l(),p(L.$$.fragment),ms=l(),P=i("p"),P.textContent=Mn,Ms=l(),p(F.$$.fragment),Js=l(),K=i("p"),K.innerHTML=Jn,ds=l(),p(O.$$.fragment),ys=l(),ee=i("p"),ee.innerHTML=dn,js=l(),se=i("p"),se.innerHTML=yn,hs=l(),p(ne.$$.fragment),Ts=l(),p(te.$$.fragment),xs=l(),le=i("p"),le.innerHTML=jn,fs=l(),ae=i("p"),ae.innerHTML=hn,gs=l(),p(ie.$$.fragment),Us=l(),re=i("p"),re.textContent=Tn,ws=l(),pe=i("p"),pe.innerHTML=xn,bs=l(),ue=i("p"),ue.innerHTML=fn,vs=l(),oe=i("p"),oe.innerHTML=gn,Cs=l(),p(ce.$$.fragment),$s=l(),p(me.$$.fragment),Qs=l(),Me=i("p"),Me.innerHTML=Un,ks=l(),p(Je.$$.fragment),Is=l(),p(de.$$.fragment),zs=l(),ye=i("p"),ye.textContent=wn,Vs=l(),p(je.$$.fragment),_s=l(),p(he.$$.fragment),qs=l(),Te=i("p"),Te.innerHTML=bn,Bs=l(),p(xe.$$.fragment),As=l(),fe=i("p"),fe.innerHTML=vn,Zs=l(),p(ge.$$.fragment),Xs=l(),Ue=i("p"),Ue.innerHTML=Cn,Ns=l(),p(we.$$.fragment),Es=l(),be=i("p"),be.innerHTML=$n,Gs=l(),p(ve.$$.fragment),Ws=l(),Ce=i("p"),Ce.innerHTML=Qn,Hs=l(),p($e.$$.fragment),Ds=l(),Qe=i("p"),Qe.innerHTML=kn,Rs=l(),p(ke.$$.fragment),Ys=l(),Ie=i("p"),Ie.innerHTML=In,Ss=l(),p(ze.$$.fragment),Ls=l(),_e=i("p"),this.h()},l(e){const s=Nn("svelte-u9bgzb",document.head);y=r(s,"META",{name:!0,content:!0}),s.forEach(n),T=a(e),j=r(e,"P",{}),Vn(j).forEach(n),Ve=a(e),u(x.$$.fragment,e),Be=a(e),u(f.$$.fragment,e),Ae=a(e),u(g.$$.fragment,e),Ze=a(e),U=r(e,"P",{"data-svelte-h":!0}),J(U)!=="svelte-h6p3z9"&&(U.innerHTML=Ks),Xe=a(e),u(w.$$.fragment,e),Ne=a(e),u(h.$$.fragment,e),Ee=a(e),u(b.$$.fragment,e),Ge=a(e),v=r(e,"P",{"data-svelte-h":!0}),J(v)!=="svelte-3a8ahh"&&(v.innerHTML=Os),We=a(e),C=r(e,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1bb56lo"&&(C.innerHTML=en),He=a(e),u($.$$.fragment,e),De=a(e),Q=r(e,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-1fp73ub"&&(Q.textContent=sn),Re=a(e),u(k.$$.fragment,e),Ye=a(e),u(I.$$.fragment,e),Se=a(e),z=r(e,"P",{"data-svelte-h":!0}),J(z)!=="svelte-qlite4"&&(z.innerHTML=nn),Le=a(e),u(V.$$.fragment,e),Pe=a(e),_=r(e,"P",{"data-svelte-h":!0}),J(_)!=="svelte-5ljnps"&&(_.textContent=tn),Fe=a(e),u(q.$$.fragment,e),Ke=a(e),B=r(e,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1vx3fum"&&(B.innerHTML=ln),Oe=a(e),A=r(e,"P",{"data-svelte-h":!0}),J(A)!=="svelte-zpov33"&&(A.textContent=an),es=a(e),u(Z.$$.fragment,e),ss=a(e),X=r(e,"P",{"data-svelte-h":!0}),J(X)!=="svelte-128wl1g"&&(X.textContent=rn),ns=a(e),u(N.$$.fragment,e),ts=a(e),E=r(e,"P",{"data-svelte-h":!0}),J(E)!=="svelte-akpd54"&&(E.innerHTML=pn),ls=a(e),G=r(e,"P",{"data-svelte-h":!0}),J(G)!=="svelte-128xrzf"&&(G.textContent=un),as=a(e),u(W.$$.fragment,e),is=a(e),H=r(e,"P",{"data-svelte-h":!0}),J(H)!=="svelte-17tsik7"&&(H.textContent=on),rs=a(e),u(D.$$.fragment,e),ps=a(e),R=r(e,"P",{"data-svelte-h":!0}),J(R)!=="svelte-vat3n0"&&(R.textContent=cn),us=a(e),u(Y.$$.fragment,e),os=a(e),S=r(e,"P",{"data-svelte-h":!0}),J(S)!=="svelte-1yy0u8j"&&(S.innerHTML=mn),cs=a(e),u(L.$$.fragment,e),ms=a(e),P=r(e,"P",{"data-svelte-h":!0}),J(P)!=="svelte-k8aiy2"&&(P.textContent=Mn),Ms=a(e),u(F.$$.fragment,e),Js=a(e),K=r(e,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1qktmfg"&&(K.innerHTML=Jn),ds=a(e),u(O.$$.fragment,e),ys=a(e),ee=r(e,"P",{"data-svelte-h":!0}),J(ee)!=="svelte-ck2ga4"&&(ee.innerHTML=dn),js=a(e),se=r(e,"P",{"data-svelte-h":!0}),J(se)!=="svelte-4abjsh"&&(se.innerHTML=yn),hs=a(e),u(ne.$$.fragment,e),Ts=a(e),u(te.$$.fragment,e),xs=a(e),le=r(e,"P",{"data-svelte-h":!0}),J(le)!=="svelte-88e5us"&&(le.innerHTML=jn),fs=a(e),ae=r(e,"P",{"data-svelte-h":!0}),J(ae)!=="svelte-1179w4l"&&(ae.innerHTML=hn),gs=a(e),u(ie.$$.fragment,e),Us=a(e),re=r(e,"P",{"data-svelte-h":!0}),J(re)!=="svelte-kor19t"&&(re.textContent=Tn),ws=a(e),pe=r(e,"P",{"data-svelte-h":!0}),J(pe)!=="svelte-139x0nq"&&(pe.innerHTML=xn),bs=a(e),ue=r(e,"P",{"data-svelte-h":!0}),J(ue)!=="svelte-1hv5grb"&&(ue.innerHTML=fn),vs=a(e),oe=r(e,"P",{"data-svelte-h":!0}),J(oe)!=="svelte-1qq2t5z"&&(oe.innerHTML=gn),Cs=a(e),u(ce.$$.fragment,e),$s=a(e),u(me.$$.fragment,e),Qs=a(e),Me=r(e,"P",{"data-svelte-h":!0}),J(Me)!=="svelte-1stp3zo"&&(Me.innerHTML=Un),ks=a(e),u(Je.$$.fragment,e),Is=a(e),u(de.$$.fragment,e),zs=a(e),ye=r(e,"P",{"data-svelte-h":!0}),J(ye)!=="svelte-wslgg9"&&(ye.textContent=wn),Vs=a(e),u(je.$$.fragment,e),_s=a(e),u(he.$$.fragment,e),qs=a(e),Te=r(e,"P",{"data-svelte-h":!0}),J(Te)!=="svelte-eqlvs6"&&(Te.innerHTML=bn),Bs=a(e),u(xe.$$.fragment,e),As=a(e),fe=r(e,"P",{"data-svelte-h":!0}),J(fe)!=="svelte-1hhex8"&&(fe.innerHTML=vn),Zs=a(e),u(ge.$$.fragment,e),Xs=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),J(Ue)!=="svelte-1pu5z8g"&&(Ue.innerHTML=Cn),Ns=a(e),u(we.$$.fragment,e),Es=a(e),be=r(e,"P",{"data-svelte-h":!0}),J(be)!=="svelte-brnmsg"&&(be.innerHTML=$n),Gs=a(e),u(ve.$$.fragment,e),Ws=a(e),Ce=r(e,"P",{"data-svelte-h":!0}),J(Ce)!=="svelte-vzsbv1"&&(Ce.innerHTML=Qn),Hs=a(e),u($e.$$.fragment,e),Ds=a(e),Qe=r(e,"P",{"data-svelte-h":!0}),J(Qe)!=="svelte-14y6ub0"&&(Qe.innerHTML=kn),Rs=a(e),u(ke.$$.fragment,e),Ys=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),J(Ie)!=="svelte-oen3da"&&(Ie.innerHTML=In),Ss=a(e),u(ze.$$.fragment,e),Ls=a(e),_e=r(e,"P",{}),Vn(_e).forEach(n),this.h()},h(){_n(y,"name","hf:doc:metadata"),_n(y,"content",Ln)},m(e,s){En(document.head,y),t(e,T,s),t(e,j,s),t(e,Ve,s),o(x,e,s),t(e,Be,s),o(f,e,s),t(e,Ae,s),o(g,e,s),t(e,Ze,s),t(e,U,s),t(e,Xe,s),o(w,e,s),t(e,Ne,s),o(h,e,s),t(e,Ee,s),o(b,e,s),t(e,Ge,s),t(e,v,s),t(e,We,s),t(e,C,s),t(e,He,s),o($,e,s),t(e,De,s),t(e,Q,s),t(e,Re,s),o(k,e,s),t(e,Ye,s),o(I,e,s),t(e,Se,s),t(e,z,s),t(e,Le,s),o(V,e,s),t(e,Pe,s),t(e,_,s),t(e,Fe,s),o(q,e,s),t(e,Ke,s),t(e,B,s),t(e,Oe,s),t(e,A,s),t(e,es,s),o(Z,e,s),t(e,ss,s),t(e,X,s),t(e,ns,s),o(N,e,s),t(e,ts,s),t(e,E,s),t(e,ls,s),t(e,G,s),t(e,as,s),o(W,e,s),t(e,is,s),t(e,H,s),t(e,rs,s),o(D,e,s),t(e,ps,s),t(e,R,s),t(e,us,s),o(Y,e,s),t(e,os,s),t(e,S,s),t(e,cs,s),o(L,e,s),t(e,ms,s),t(e,P,s),t(e,Ms,s),o(F,e,s),t(e,Js,s),t(e,K,s),t(e,ds,s),o(O,e,s),t(e,ys,s),t(e,ee,s),t(e,js,s),t(e,se,s),t(e,hs,s),o(ne,e,s),t(e,Ts,s),o(te,e,s),t(e,xs,s),t(e,le,s),t(e,fs,s),t(e,ae,s),t(e,gs,s),o(ie,e,s),t(e,Us,s),t(e,re,s),t(e,ws,s),t(e,pe,s),t(e,bs,s),t(e,ue,s),t(e,vs,s),t(e,oe,s),t(e,Cs,s),o(ce,e,s),t(e,$s,s),o(me,e,s),t(e,Qs,s),t(e,Me,s),t(e,ks,s),o(Je,e,s),t(e,Is,s),o(de,e,s),t(e,zs,s),t(e,ye,s),t(e,Vs,s),o(je,e,s),t(e,_s,s),o(he,e,s),t(e,qs,s),t(e,Te,s),t(e,Bs,s),o(xe,e,s),t(e,As,s),t(e,fe,s),t(e,Zs,s),o(ge,e,s),t(e,Xs,s),t(e,Ue,s),t(e,Ns,s),o(we,e,s),t(e,Es,s),t(e,be,s),t(e,Gs,s),o(ve,e,s),t(e,Ws,s),t(e,Ce,s),t(e,Hs,s),o($e,e,s),t(e,Ds,s),t(e,Qe,s),t(e,Rs,s),o(ke,e,s),t(e,Ys,s),t(e,Ie,s),t(e,Ss,s),o(ze,e,s),t(e,Ls,s),t(e,_e,s),Ps=!0},p(e,[s]){const zn={};s&2&&(zn.$$scope={dirty:s,ctx:e}),h.$set(zn)},i(e){Ps||(c(x.$$.fragment,e),c(f.$$.fragment,e),c(g.$$.fragment,e),c(w.$$.fragment,e),c(h.$$.fragment,e),c(b.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(I.$$.fragment,e),c(V.$$.fragment,e),c(q.$$.fragment,e),c(Z.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(D.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(O.$$.fragment,e),c(ne.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(Je.$$.fragment,e),c(de.$$.fragment,e),c(je.$$.fragment,e),c(he.$$.fragment,e),c(xe.$$.fragment,e),c(ge.$$.fragment,e),c(we.$$.fragment,e),c(ve.$$.fragment,e),c($e.$$.fragment,e),c(ke.$$.fragment,e),c(ze.$$.fragment,e),Ps=!0)},o(e){m(x.$$.fragment,e),m(f.$$.fragment,e),m(g.$$.fragment,e),m(w.$$.fragment,e),m(h.$$.fragment,e),m(b.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),m(q.$$.fragment,e),m(Z.$$.fragment,e),m(N.$$.fragment,e),m(W.$$.fragment,e),m(D.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(Je.$$.fragment,e),m(de.$$.fragment,e),m(je.$$.fragment,e),m(he.$$.fragment,e),m(xe.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),m(ve.$$.fragment,e),m($e.$$.fragment,e),m(ke.$$.fragment,e),m(ze.$$.fragment,e),Ps=!1},d(e){e&&(n(T),n(j),n(Ve),n(Be),n(Ae),n(Ze),n(U),n(Xe),n(Ne),n(Ee),n(Ge),n(v),n(We),n(C),n(He),n(De),n(Q),n(Re),n(Ye),n(Se),n(z),n(Le),n(Pe),n(_),n(Fe),n(Ke),n(B),n(Oe),n(A),n(es),n(ss),n(X),n(ns),n(ts),n(E),n(ls),n(G),n(as),n(is),n(H),n(rs),n(ps),n(R),n(us),n(os),n(S),n(cs),n(ms),n(P),n(Ms),n(Js),n(K),n(ds),n(ys),n(ee),n(js),n(se),n(hs),n(Ts),n(xs),n(le),n(fs),n(ae),n(gs),n(Us),n(re),n(ws),n(pe),n(bs),n(ue),n(vs),n(oe),n(Cs),n($s),n(Qs),n(Me),n(ks),n(Is),n(zs),n(ye),n(Vs),n(_s),n(qs),n(Te),n(Bs),n(As),n(fe),n(Zs),n(Xs),n(Ue),n(Ns),n(Es),n(be),n(Gs),n(Ws),n(Ce),n(Hs),n(Ds),n(Qe),n(Rs),n(Ys),n(Ie),n(Ss),n(Ls),n(_e)),n(y),M(x,e),M(f,e),M(g,e),M(w,e),M(h,e),M(b,e),M($,e),M(k,e),M(I,e),M(V,e),M(q,e),M(Z,e),M(N,e),M(W,e),M(D,e),M(Y,e),M(L,e),M(F,e),M(O,e),M(ne,e),M(te,e),M(ie,e),M(ce,e),M(me,e),M(Je,e),M(de,e),M(je,e),M(he,e),M(xe,e),M(ge,e),M(we,e),M(ve,e),M($e,e),M(ke,e),M(ze,e)}}}const Ln='{"title":"Entraîner un nouveau <i> tokenizer </i> à partir d’un ancien","local":"entraîner-un-nouveau-i-tokenizer-i-à-partir-dun-ancien","sections":[{"title":"Assemblage d’un corpus","local":"assemblage-dun-corpus","sections":[],"depth":2},{"title":"Entraînement d’un nouveau <i> tokenizer </i>","local":"entraînement-dun-nouveau-i-tokenizer-i","sections":[],"depth":2},{"title":"Sauvegarde du <i> tokenizer </i>","local":"sauvegarde-du-i-tokenizer-i","sections":[],"depth":2}],"depth":1}';function Pn(qe){return Bn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends Zn{constructor(y){super(),Xn(this,y,Pn,Sn,qn,{})}}export{lt as component};
