# Introduction

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## Bienvenue au cours 🤗 !

<Youtube id="00GKzGyWFEs" />

Ce cours vous apprendra à utiliser les bibliothèques de NLP de l'écosystème [Hugging Face](https://huggingface.co/) : [🤗 *Transformers*](https://github.com/huggingface/transformers), [🤗 *Datasets*](https://github.com/huggingface/datasets), [🤗 *Tokenizers*](https://github.com/huggingface/tokenizers) et [🤗 *Accelerate*](https://github.com/huggingface/accelerate), ainsi que le [*Hub*](https://huggingface.co/models). C'est totalement gratuit et sans publicité.

## À quoi s'attendre ?

Voici un bref aperçu du cours :

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Bref aperçu du contenu du cours.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Bref aperçu des différents chapitres du cours.">
</div>

- Les chapitres 1 à 4 présentent les principaux concepts de la bibliothèque 🤗 *Transformers*. À la fin de ces chapitres, vous serez familier avec le fonctionnement des *transformers* et vous saurez comment utiliser un modèle présent sur le [*Hub*](https://huggingface.co/models), le *finetuner* sur un jeu de données, et partager vos résultats sur le *Hub* !
- Les chapitres 5 à 8 présentent les bases des librairies 🤗 *Datasets* et 🤗 *Tokenizers* ainsi qu'une découverte des problèmes classiques de NLP. À la fin de ce chapitre, vous serez capable de résoudre les problèmes de NLP les plus communs par vous-même.
- Les chapitres 9 à 12 proposent d'aller plus loin et d'explorer comment les *transformers* peuvent être utilisés pour résoudre des problèmes de traitement de la parole et de vision par ordinateur. En suivant ces chapitres, vous apprendrez à construire et à partager vos modèles via des démonstrateurs, et vous serez capable d'optimiser ces modèles pour des environnements de production. Enfin, vous serez prêt à appliquer 🤗 *Transformers* à (presque) n'importe quel problème d'apprentissage automatique !

Ce cours :

* requiert un bon niveau en Python,
* se comprend mieux si vous avez déjà suivi un cours d'introduction à l'apprentissage profond comme [fast.ai's](https://www.fast.ai/), [*Practical Deep Learning for Coders*](https://course.fast.ai/) ou un des cours développés par [*DeepLearning.AI*](https://www.deeplearning.ai/),
* n'attend pas une connaissance appronfondie de [PyTorch](https://pytorch.org/) ou de [TensorFlow](https://www.tensorflow.org/), bien qu'être familiarisé avec l'un d'entre eux peut aider.

Après avoir terminé ce cours, nous vous recommandons de suivre la [Spécialisation en NLP](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) dispensée par DeepLearning.AI, qui couvre une grande partie des modèles traditionnels de NLP comme le Bayésien naïf et les LSTMs qui sont importants à connaître !

## Qui sommes-nous ?

À propos des auteurs de ce cours :

[**Abubakar Abid**](https://huggingface.co/abidlabs) a obtenu son doctorat en apprentissage automatique appliqué à Stanford. Pendant son doctorat, il a fondé [Gradio](https://github.com/gradio-app/gradio), une bibliothèque Python *open source* qui a été utilisée pour construire plus de 600 000 démos d'apprentissage automatique. Gradio a été rachetée par Hugging Face, où Abubakar occupe désormais le poste de responsable de l'équipe d'apprentissage automatique.

[**Matthew Carrigan**](https://huggingface.co/Rocketknight1) est ingénieur en apprentissage machine chez Hugging Face. Il vit à Dublin en Irlande. Il a travaillé auparavant comme ingénieur en apprentissage machine chez Parse.ly et avant cela comme chercheur postdoctoral au Trinity College Dublin. Il ne croit pas que nous arrivions à l'*AGI* en mettant à l'échelle les architectures existantes mais a tout de même beaucoup d'espoir dans l'immortalité des robots.

[**Lysandre Debut**](https://huggingface.co/lysandre) est ingénieur en apprentissage machine chez Hugging Face et a travaillé sur la bibliothèque 🤗 *Transformers* depuis les premières phases de développement. Son but est de rendre le NLP accessible à tous en développant des outils disposant d'une API très simple.

[**Sylvain Gugger**](https://huggingface.co/sgugger) est ingénieur de recherche chez Hugging Face et un des principaux responsables de la bibliothèque 🤗 *Transformers*. Avant cela, il était chercheur en apprentissage machine chez fast.ai et a écrit le livre [*Deep Learning for Coders with fastai and PyTorch*](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/) avec Jeremy Howard. Son but est de rendre l'apprentissage profond plus accessible en développant et en améliorant des techniques permettant aux modèles d'apprendre rapidement sur des ressources limitées.

[**Dawood Khan**](https://huggingface.co/dawoodkhan82) est un ingénieur en apprentissage automatique chez Hugging Face. Il vient de New York et est diplômé en informatique de l’Université de New York. Après avoir travaillé comme ingénieur iOS pendant quelques années, Dawood a quitté son poste pour créer Gradio avec ses cofondateurs. Gradio a finalement été acquis par Hugging Face.

[**Merve Noyan**](https://huggingface.co/merve) est développeuse *advocate* chez Hugging Face et travaille à la création d'outils et de contenus visant à démocratiser l'apprentissage machine pour tous.

[**Lucile Saulnier**](https://huggingface.co/SaulLu) est ingénieure en apprentissage machine chez Hugging Face et travaille au développement et à l'implémentation de nombreux outils *open source*. Elle est également activement impliquée dans de nombreux projets de recherche dans le domaine du NLP comme l'entraînement collaboratif de modèles et le projet [BigScience](https://bigscience.huggingface.co/).

[**Lewis Tunstall**](https://huggingface.co/lewtun) est ingénieur en apprentissage machine chez Hugging Face et dévoué au développement d'outils *open source* avec la volonté de les rendre accessibles à une communauté plus large. Il est également co-auteur du livre [*Natural Language Processing with Transformers*](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/).

[**Leandro von Werra**](https://huggingface.co/lvwerra) est ingénieur en apprentissage machine dans l'équipe *open source* d'Hugging Face et également co-auteur du livre [*Natural Language Processing with Transformers*](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/). Il a plusieurs années d'expérience dans l'industrie où il a pu déployer des projets de NLP en production et travailler sur toutes les étapes clefs du déploiement.


## FAQ

Voici quelques réponses aux questions fréquemment posées :

- **Suivre ce cours mène-t-il à une certification ?**  
Actuellement, nous n'avons pas de certification pour ce cours. Cependant, nous travaillons sur un programme de certification pour l'écosystème *Hugging Face*. Restez à l'écoute !

- **Combien de temps dois-je consacrer à ce cours ?**  
Chaque chapitre de ce cours est conçu pour être complété en une semaine, avec environ 6 à 8 heures de travail par semaine. Cependant, vous pouvez prendre tout le temps nécessaire pour le suivre.

- **Où puis-je poser une question si j'en ai une ?**  
Si vous avez une question sur l'une des sections du cours, il vous suffit de cliquer sur la bannière « *Ask a question* » en haut de la page pour être automatiquement redirigé vers la bonne section du [forum d’*Hugging Face*](https://discuss.huggingface.co/) :

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/forum-button.png" alt="Link to the Hugging Face forums" width="75%">

Notez qu'une liste d'[idées de projets](https://discuss.huggingface.co/c/course/course-event/25) est également disponible sur le forum si vous souhaitez pratiquer davantage une fois le cours terminé.

- **Où puis-je obtenir le code du cours ?**  
Pour chaque section, vous pouvez cliquer sur la bannière en haut de la page pour exécuter son code dans *Google Colab* ou *Amazon SageMaker Studio Lab* :

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/notebook-buttons.png" alt="Link to the Hugging Face course notebooks" width="75%">

A noter que pour la version en français du cours, deux choix s’offrent à vous lorsque vous cliquez sur la bannière. Le premier est de sélectionner le *notebook* utilisant des modèles en anglais. L’intérêt est qu’il s’agit de celui sur lequel sont basées les explications du cours (interprétation des résultats, etc.). Le second est de sélectionner le *notebook* utilisant des modèles en français. Il s’agit alors d’une proposition d’adaptation (un modèle parmi tous ceux existant en français est utilisé).

Si vous souhaitez accéder à l’ensemble des *notebooks* Jupyter du cours, il existe deux possibilités. La première est de cloner le dépôt [`huggingface/notebooks`](https://github.com/huggingface/notebooks) et de consulter les *notebooks* contenus dans le dossier *course*. La seconde est de générer les *notebooks* localement en suivant les instructions dans le *README* du dépôt [`course`](https://github.com/huggingface/course#-jupyter-notebooks) sur GitHub.

- **Comment puis-je contribuer au cours ?**  
Il existe de nombreuses façons de contribuer au cours ! Si vous trouvez une coquille ou un bug, veuillez ouvrir une « *Issue* » sur le dépôt [`course`](https://github.com/huggingface/course). Si vous souhaitez aider à traduire le cours dans votre langue maternelle, consultez les instructions [ici](https://github.com/huggingface/course#translating-the-course-into-your-language).

- **Quels ont été les choix retenus pour la traduction ?**  
Vous pouvez consulter le [glossaire](https://huggingface.co/course/fr/glossary/1) détaillant les choix retenus pour la traduction vers le français.

- **Peut-on réutiliser ce cours?**  
Bien sûr ! Le cours est publié sous la licence [Apache 2 license](https://www.apache.org/licenses/LICENSE-2.0.html). Cela signifie que vous devez créditer de manière appropriée, fournir un lien vers la licence et indiquer si des modifications ont été apportées. Vous pouvez le faire de toute manière raisonnable, mais pas d'une façon qui suggère que le distributeur de la licence vous approuve ou approuve votre utilisation. Si vous souhaitez citer le cours, veuillez utiliser le BibTeX suivant :

```
@misc{huggingfacecourse,
  author = {Hugging Face},
  title = {The Hugging Face Course, 2022},
  howpublished = "\url{https://huggingface.co/course}",
  year = {2022},
  note = "[Online; accessed <today>]"
}
```


## C'est parti !

Êtes-vous prêt à commencer ? Dans ce chapitre, vous apprendrez :
* à utiliser la fonction `pipeline()` pour résoudre des problèmes de NLP comme la génération de texte et la classification,
* l'architecture d'un *transformer*,
* comment faire la distinction entre les différentes architectures d'encodeur, de décodeur et d'encodeur-décodeur ainsi que leurs différents cas d'usage.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter1/1.mdx" />