# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. Quel est l'ordre du pipeline de modélisation du langage ?


<Question
	choices={[
		{
			text: " Tout d'abord, le modèle, qui traite le texte et renvoie des prédictions brutes. Puis le <i>tokenizer</i> donne un sens à ces prédictions et les reconvertit en texte si nécessaire.",
			explain: " Le modèle ne peut pas comprendre le texte ! Le <i>tokenizer</i> doit d'abord tokeniser le texte et le convertir en identifiants afin qu'il soit compréhensible par le modèle."},
		{
			text: " Tout d'abord, le <i>tokenizer</i>, qui traite le texte et renvoie des identifiants. Puis le modèle traite ces identifiants et produit une prédiction, qui peut être du texte.",
			explain: " La prédiction du modèle ne peut pas être du texte immédiatement. Le <i>tokenizer</i> doit être utilisé afin de reconvertir la prédiction en texte !"},
		{
			text: " Le <i>tokenizer</i> traite le texte et renvoie des identifiants. Le modèle traite ces identifiants et produit une prédiction. Le <i>tokenizer</i> peut alors être utilisé à nouveau pour reconvertir ces prédictions en texte.",
			explain: " Le <i>tokenizer</i> peut être utilisé à la fois pour la tokenisation et la dé-tokénisation.",
            correct: true
		}
	]}
/>

### 2. Combien de dimensions le tenseur produit par le <i>transformer</i> de base possède-t-il et quelles sont-elles ?


<Question
	choices={[
		{
			text: "2: la longueur de la séquence et la taille du batch",
			explain: "Le tenseur produit par le modèle possède une troisième dimension : la taille cachée."
		},
		{
			text: "2: la longueur de la séquence et la taille cachée",
			explain: "Tous les <i>transformers</i>  gèrent les batchs, même avec une seule séquence ce serait une taille de batch de 1 !"
		},
		{
			text: "3: la longueur de la séquence, la taille du batch et la taille cachée.",
			explain: "",
            correct: true
		}
	]}
/>

### 3. Lequel des éléments suivants est un exemple de tokenisation en sous-mots ?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "Oui, c'est un exemple de tokenisation en sous-mots !",
            correct: true
		},
		{
			text: "La tokenization basée sur les caractères",
			explain: "La tokenization basée sur les caractères n’est pas un type de tokenisation en sous-mots."
		},
		{
			text: "Découpage sur les espaces et la ponctuation",
			explain: "C’est une tokenisation basée sur les mots !"
		},
		{
			text: "BPE",
			explain: "Oui, c'est un exemple de tokenisation en sous-mots !",
            correct: true
        },
		{
			text: "Unigram",
			explain: "Oui, c'est un exemple de tokenisation en sous-mots !",
            correct: true
        },
		{
			text: "Aucune des propositions ci-dessus",
			explain: ""
        }
	]}
/>

### 4. Qu'est-ce qu'une tête de modèle ?

<Question
	choices={[
		{
			text: " Un composant du <i>transformer</i>  de base qui redirige les tenseurs vers leurs couches correctes.",
			explain: "Il n'y a pas de tel composant."
		},
		{
			text:  "Également connu sous le nom de mécanisme d'auto-attention, il adapte la représentation d'un <i>token</i>  en fonction des autres <i>tokens</i>  de la séquence.",
			explain: "La couche d'auto-attention contient des têtes d'attention mais ce ne sont pas des têtes d'adaptation."
		},
		{
			text: "Un composant supplémentaire, généralement constitué d'une ou plusieurs couches, pour convertir les prédictions du <i>transformer</i>  en une sortie spécifique à la tâche.",
			explain: "Les têtes d'adaptation, aussi appelées simplement têtes, se présentent sous différentes formes : têtes de modélisation du langage, têtes de réponse aux questions, têtes de classification des séquences, etc.",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. Qu'est-ce qu'un AutoModel?

<Question
	choices={[
		{
			text: "Un modèle qui s'entraîne automatiquement sur vos données",
			explain: "Vous confondez cela avec notre produit <a href='https://huggingface.co/autotrain>AutoTrain</a>"
		},
		{
			text: "Un objet qui renvoie la bonne architecture basée sur le <i>checkpoint</i> .",
			explain: "Exactement : <code>AutoModel</code> a seulement besoin de connaître le <i>checkpoint</i> à partir duquel il doit s'initialiser pour retourner à la bonne architecture.",
			correct: true
		},
		{
			text: "Un modèle qui détecte automatiquement la langue utilisée pour ses entrées afin de charger les bonnes pondérations.",
			explain: "Bien que certains <i>checkpoints</i> et modèles soient capables de gérer plusieurs langues, il n'existe pas d'outils intégrés pour la sélection automatique des <i>checkpoints</i> en fonction de la langue. Vous devez vous rendre sur le <a href='https://huggingface.co/models'>Hub des modèles</a> pour trouver le meilleur <i>checkpoint</i> pour votre tâche !"
		} 
	]}
/>

{:else}
### 5. What is an AutoModel?

<Question
	choices={[
		{
			text: "Un modèle qui s'entraîne automatiquement sur vos données",
			explain: "Vous confondez cela avec notre produit <a href='https://huggingface.co/autotrain>AutoTrain</a>"
		},
		{
			text: "Un objet qui renvoie la bonne architecture basée sur le <i>checkpoint</i> .",
			explain: "Exactement : <code>TFAutoModel</code> a seulement besoin de connaître le <i>checkpoint</i> à partir duquel il doit s'initialiser pour retourner à la bonne architecture.",
			correct: true
		},
		{
			text: "Un modèle qui détecte automatiquement la langue utilisée pour ses entrées afin de charger les bonnes pondérations.",
			explain: "Bien que certains <i>checkpoints</i> et modèles soient capables de gérer plusieurs langues, il n'existe pas d'outils intégrés pour la sélection automatique des <i>checkpoints</i> en fonction de la langue. Vous devez vous rendre sur le <a href='https://huggingface.co/models'>Hub des modèles</a> pour trouver le meilleur <i>checkpoint</i> pour votre tâche !"
		} 
	]}
/>

{/if}

### 6. Quelles sont les techniques à connaître lors de la mise en batch de séquences de longueurs différentes ?


<Question
	choices={[
		{
			text: "La troncature",
			explain: " La troncature est une façon correcte d'égaliser les séquences pour qu'elles s'inscrivent dans une forme rectangulaire. Mais est-ce la seule ?",
			correct: true
		},
		{
			text: "Retourner les tenseurs",
			explain: "Alors que les autres techniques vous permettent de renvoyer des tenseurs rectangulaires, retourner les tenseurs n'est pas utile lorsque vous mettez en batch des séquences."
		},
		{
			text: "Le <i>padding</i>",
			explain: "Le <i>padding</i> est une façon correcte d'égaliser les séquences pour qu'elles tiennent dans une forme rectangulaire. Mais est-ce le seul moyen ?",
			correct: true
		}, 
		{
			text: "Les masques d'attention ",
			explain: "Les masques d'attention sont d'une importance capitale lorsqu'on manipule des séquences de longueurs différentes. Ce n'est cependant pas la seule technique à laquelle il faut faire attention.",
			correct: true
		} 
	]}
/>

### 7. Quel est l'intérêt d'appliquer une fonction SoftMax aux logits produits par un modèle de classification de séquences ?

<Question
	choices={[
		{
			text: "Elle adoucit les logits pour qu'ils soient plus fiables.",
			explain: "La fonction SoftMax n'affecte pas la fiabilité des résultats."
		},
		{
			text: "Elle applique une limite inférieure et supérieure pour qu'ils soient compréhensibles.",
			explain: "Les valeurs résultantes sont comprises entre 0 et 1. Ce n'est cependant pas la seule raison pour laquelle nous utilisons une fonction SoftMax.",
            correct: true
		},
		{
			text: "La somme totale des sorties est alors égale à 1, ce qui permet une interprétation probabiliste.",
			explain: "Mais ce n'est pas la seule raison pour laquelle nous utilisons une fonction SoftMax.",
            correct: true
		}
	]}
/>

### 8. Autour de quelle méthode s'articule la majeure partie de l'API <i>tokenizer</i> ?

<Question
	choices={[
		{
			text: "<code>encode</code>, car elle peut encoder du texte en identifiants et des identifiants en prédictions.",
			explain: "Bien que la méthode <code>encode</code> existe sur les <i>tokenizer</i>, elle n'existe pas sur les modèles."
		},
		{
			text: "Appeler directement l'objet tokenizer",
			explain: "La méthode <code>__call__</code> du <i>tokenizer</i> est une méthode très puissante qui peut traiter à peu près tout. C'est également la méthode utilisée pour récupérer les prédictions d'un modèle.",
			correct: true
		},
		{
			text: "<code>pad</code>",
			explain: "Le <i>padding</i> est très utile mais ce n'est qu'une partie de l'API <i>tokenizer</i>."
		},
		{
			text: "<code>tokenize</code>",
			explain: "La méthode <code>tokenize</code> est est sans doute l'une des méthodes les plus utiles, mais elle ne constitue pas le cœur de l'API <i>tokenizer</i>."
		}
	]}
/>

### 9. Que contient la variable `result` dans cet exemple de code ?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "Une liste de chaînes de caractères, chaque chaîne étant un <i>token</i>.",
			explain: "Convertissez cela en identifiants, et donnez-les à un modèle !",
            correct: true
		},
		{
			text: "Une liste d'identifiants",
			explain: "C'est à cela que la méthode <code>__call__</code> ou la méthode <code>convert_tokens_to_ids</code> sert !"
		},
		{
			text: "Une chaîne contenant tous les <i>tokens</i>",
			explain: "Ce serait sous-optimal car le but est de diviser la chaîne de caractères en plusieurs éléments."
		}
	]}
/>

{#if fw === 'pt'}
### 10. Y a-t-il un problème avec le code suivant ?


```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Non, ça semble correct.",
			explain: "Malheureusement, coupler un modèle avec un <i>tokenizer</i> qui a été entraîné avec un <i>checkpoint</i> différent est rarement une bonne idée. Le modèle n'a pas été entraîné pour donner du sens à la sortie de ce <i>tokenizer</i> donc la sortie du modèle (s'il peut même fonctionner !) n'aura aucun sens."
		},
		{
			text: " Le <i>tokenizer</i> et le modèle doivent toujours provenir du même <i>checkpoint</i>.",
			explain: "",
            correct: true
		},
		{
			text: " C'est une bonne pratique de faire du <i>padding</i> et de troncage avec le <i>tokenizer</i> car chaque entrée est un batch.",
			explain: "Il est vrai que chaque entrée de modèle doit être un batch. Cependant, tronquer ou compléter cette séquence n'aurait pas nécessairement de sens puisqu'il n'y en a qu'une seule. Il s'agit là de techniques permettant de mettre en batch une liste de phrases."
		}
	]}
/>

{:else}
### 10. Y a-t-il un problème avec le code suivant ?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Non, ça semble correct.",
			explain: "Malheureusement, coupler un modèle avec un <i>tokenizer</i> qui a été entraîné avec un <i>checkpoint</i> différent est rarement une bonne idée. Le modèle n'a pas été entraîné pour donner du sens à la sortie de ce <i>tokenizer</i> donc la sortie du modèle (s'il peut même fonctionner !) n'aura aucun sens."
		},
		{
			text: " Le <i>tokenizer</i> et le modèle doivent toujours provenir du même <i>checkpoint</i>.",
			explain: "",
            correct: true
		},
		{
			text: " C'est une bonne pratique de faire du <i>padding</i> et de troncage avec le <i>tokenizer</i> car chaque entrée est un batch.",
			explain: "Il est vrai que chaque entrée de modèle doit être un batch. Cependant, tronquer ou compléter cette séquence n'aurait pas nécessairement de sens puisqu'il n'y en a qu'une seule. Il s'agit là de techniques permettant de mettre en batch une liste de phrases."
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter2/8.mdx" />