# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

Ce chapitre a couvert beaucoup de terrain ! Ne vous inquiétez pas si vous n'avez pas saisi tous les détails, les chapitres suivants vous aideront à comprendre comment les choses fonctionnent sous le capot.

Avant de poursuivre, testons ce que vous avez appris dans ce chapitre.

### 1. La fonction `load_dataset()` dans 🤗 *Datasets* vous permet de charger un jeu de données depuis lequel des emplacements suivants ?

<Question
	choices={[
		{
			text: "Localement, par exemple depuis son ordinateur portable.",
			explain: "Vous pouvez passer les chemins des fichiers locaux à l'argument <code>data_files</code> de <code>load_dataset()</code> pour charger les jeux de données locaux.",
			correct: true
		},
		{
			text: "Le <i>Hub</i> d’Hugging Face.",
			explain: "Vous pouvez charger des jeux de données sur le <i>Hub</i>  en fournissant l'ID du jeu de données. Par exemple : <code>load_dataset('emotion')</code>.",
			correct: true
		},
		{
			text: "Un serveur distant.",
			explain: "Vous pouvez passer des URLs à l'argument <code>data_files</code> de <code>load_dataset()</code> pour charger des fichiers distants.",
			correct: true
		},
	]}
/>

### 2. Supposons que vous chargiez l'une des tâches du jeu de données GLUE comme suit :

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

Laquelle des commandes suivantes produira un échantillon aléatoire de 50 éléments à partir de `dataset` ?

<Question
	choices={[
		{
			text: "<code>dataset.sample(50)</code>",
			explain: "Il n'y a pas de méthode <code>Dataset.sample()</code>."
		},
		{
			text: "<code>dataset.shuffle().select(range(50))</code>",
			explain: "Comme vous l'avez vu dans ce chapitre, vous mélangez d'abord le jeu de données puis sélectionnez les échantillons à partir de celui-ci.",
			correct: true
		},
		{
			text: "<code>dataset.select(range(50)).shuffle()</code>",
			explain: "Bien que le code s'exécute, il ne mélange que les 50 premiers éléments du jeu de données."
		}
	]}
/>

### 3. Supposons que vous disposiez d'un jeu de données sur les animaux domestiques appelé `pets_dataset` qui comporte une colonne `name` indiquant le nom de chaque animal. Parmi les approches suivantes, laquelle vous permettrait de filtrer le jeu de données pour tous les animaux dont le nom commence par la lettre « L » ?

<Question
	choices={[
		{
			text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
			explain: "L'utilisation d'une fonction Python lambda pour ces filtres rapides est une excellente idée. Pouvez-vous penser à une autre solution ?",
			correct: true
		},
		{
			text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
			explain: "Une fonction lambda prend la forme générale <code>lambda *arguments* : *expression*</code>, vous devez donc fournir des arguments dans ce cas."
		},
		{
			text: "Créer une fonction comme <code>def filter_names(x): return x['name'].startswith('L')</code> et exécuter <code>pets_dataset.filter(filter_names)</code>.",
			explain: "Tout comme avec <code>Dataset.map()</code>, vous pouvez passer des fonctions explicites à <code>Dataset.filter()</code>. Ceci est utile lorsque vous avez une logique complexe qui ne convient pas à une fonction lambda courte. Parmi les autres solutions, laquelle fonctionnerait ?",
			correct: true
		}
	]}
/>

### 4. Qu'est-ce que le *memory mapping* ?

<Question
	choices={[
		{
			text: "Un <i>mapping</i> entre la RAM CPU et GPU.",
			explain: "Ce n'est pas ça, réessayez !",
		},
		{
			text: "Un <i>mapping</i> entre la RAM et le stockage du système de fichiers.",
			explain: "🤗 <i>Datasets</i> traite chaque jeu de données comme un fichier mappé en mémoire. Cela permet à la bibliothèque d'accéder et d'opérer sur des éléments du jeu de données sans avoir à le charger complètement en mémoire.",
			correct: true
		},
		{
			text: "Un <i>mapping</i> entre deux fichiers dans le cache 🤗 <i>Datasets</i>.",
			explain: "Ce n'est pas ça, réessayez !"
		}
	]}
/>

### 5. Parmi les éléments suivants, lesquels sont les principaux avantages du *memory mapping* ?

<Question
	choices={[
		{
			text: "L'accès aux fichiers mappés en mémoire est plus rapide que la lecture ou l'écriture sur le disque.",
			explain: "Cela permet à 🤗 <i>Datasets</i> d'être extrêmement rapide. Ce n'est cependant pas le seul avantage.",
			correct: true
		},
		{
			text: "Les applications peuvent accéder à des segments de données dans un fichier extrêmement volumineux sans avoir à lire tout le fichier dans la RAM au préalable.",
			explain: "Cela permet à 🤗 <i>Datasets</i> de charger des jeux de données de plusieurs Go sur votre ordinateur portable sans faire exploser votre CPU. Quel autre avantage cette technique offre-t-elle ?",
			correct: true
		},
		{
			text: "Cela consomme moins d'énergie, donc votre batterie dure plus longtemps.",
			explain: "Ce n'est pas ça, réessayez !"
		}
	]}
/>

### 6. Pourquoi le code suivant échoue-t-il ?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
	choices={[
		{
			text: "Il essaie de streamer un jeu de données trop volumineux pour tenir dans la RAM.",
			explain: "Les jeux de données streamés sont décompressés à la volée et vous pouvez en traiter de données de la taille d'un To avec très peu de RAM !",
		},
		{
			text: "Il essaie d'accéder à un <code>IterableDataset</code>.",
			explain: "Un <code>IterableDataset</code> est un générateur, pas un conteneur. Vous devez donc accéder à ses éléments en utilisant <code>next(iter(dataset))</code>.",
			correct: true
		},
		{
			text: "Le jeu de données <code>allocine</code> n'a pas d’échantillon <code>train</code>.",
			explain: "Consultez le jeu de données <code>allocine</code> sur le <i>Hub</i> (https://huggingface.co/datasets/allocine) pour voir quels échantillons il contient."
		}
	]}
/>

### 7. Parmi les avantages suivants, lesquels sont les principaux pour la création d'une fiche pour les jeux de données ?

<Question
	choices={[
		{
			text: "Elle fournit des informations sur l'utilisation prévue ainsi que les tâches prises en charge de jeu de données. Le but est que d'autres membres de la communauté puissent prendre une décision éclairée quant à son utilisation.",
			explain: "Les jeux de données non documentés peuvent être utilisés pour entraîner des modèles pouvant ne pas refléter les intentions des créateurs du jeu de données ou peuvent produire des modèles dont le statut juridique est trouble s'ils sont entraînés sur des données qui violent la confidentialité ou les restrictions de licence. Cependant ce n'est pas le seul avantage !",
			correct : true
		},
		{
			text: "Elle permet d'attirer l'attention sur les biais présents dans un corpus.",
			explain: "Presque tous les jeux de données présentent une forme de biais, ce qui peut avoir des conséquences négatives en aval. En être conscient aide les constructeurs de modèles à comprendre comment traiter les biais inhérents. À quoi d'autre les fiches sont-elles utiles ?",
			correct : true
		},
		{
			text: "Cela augmente les chances que d'autres membres de la communauté utilisent mon jeu de données.",
			explain: "Une carte de jeu de données bien rédigée aura tendance à conduire à une utilisation accrue de votre jeu de données. Quels autres avantages offre-t-elle ?",
			correct: true
		},
	]}
/>


### 8. Qu'est-ce que la recherche sémantique ?

<Question
	choices={[
		{
			text: "Un moyen de rechercher des correspondances exactes entre les mots d'une requête et les documents d'un corpus.",
			explain: "Ce type de recherche est appelé <i>recherche lexicale</i> et c'est ce que vous voyez généralement avec les moteurs de recherche traditionnels."
		},
		{
			text: "Un moyen de rechercher des documents correspondants en comprenant la signification contextuelle d'une requête.",
			explain: "La recherche sémantique utilise des vecteurs d’enchâssement pour représenter les requêtes et les documents. Elle utilise ensuite une métrique de similarité pour mesurer la quantité de chevauchement entre eux. Comment la décrire autrement ?",
			correct: true
		},
		{
			text: "Un moyen d'améliorer la précision de la recherche.",
			explain: "Les moteurs de recherche sémantique peuvent capturer l'intention d'une requête bien mieux que la correspondance des mots clés et récupèrent généralement les documents avec une plus grande précision. Mais ce n'est pas la seule bonne réponse. Qu'est-ce que la recherche sémantique apporte d'autre ?",
			correct: true
		}
	]}
/>

### 9. Pour la recherche sémantique asymétrique, vous avez généralement :

<Question
	choices={[
		{
			text: "Une requête courte et un paragraphe plus long qui répond à la requête.",
			explain: "C'est ça !",
			correct : true
		},
		{
			text: "Requêtes et paragraphes qui sont à peu près de la même longueur.",
			explain: "Il s'agit en fait d'un exemple de recherche sémantique symétrique. Réessayez !"
		},
		{
			text: "Une longue requête et un paragraphe plus court qui répond à la requête.",
			explain: "Réessayez !"
		}
	]}
/>

### 10. Puis-je utiliser 🤗 *Datasets* pour charger des données à utiliser dans d'autres domaines, comme le traitement de la parole ?

<Question
	choices={[
		{
			text: "Non.",
			explain: "🤗 <i>Datasets</i> prend actuellement en charge les données tabulaires, l'audio et la vision par ordinateur. Consultez le jeu de données <a href='https://huggingface.co/datasets/mnist'>MNIST</a> sur le <i>Hub</i> pour un exemple de vision par ordinateur."
		},
		{
			text: "Oui.",
			explain: "Découvrez les développements passionnants concernant la parole et la vision dans la bibliothèque 🤗 <i>Transformers</i> pour voir comment 🤗 <i>Datasets</i> est utilisé dans ces domaines.",
			correct : true
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter5/8.mdx" />