# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={8}
    classNames="absolute z-10 right-0 top-0"
/>

Testons ce que vous avez appris dans ce chapitre !

### 1. Dans quel ordre devez-vous lire un <i>traceback</i> Python ?

<Question
	choices={[
		{
			text: "De haut en bas",
			explain: "Essayez à nouveau. Bien que la plupart des autres langages de programmation impriment l'exception en haut de la page, Python est spécial à cet égard."
		},
		{
			text: "De bas en haut",
			explain: "L'avantage d'un <i>traceback</i> de Python montrant l'exception en bas est qu'il est plus facile de déboguer lorsque vous travaillez dans le terminal et que c'est la dernière ligne que vous voyez.",
			correct: true
		}
	]}
/>

### 2. Qu'est-ce qu'un exemple minimal reproductible ?

<Question
	choices={[
		{
			text: "Une implémentation simple d'un <i>transformer</i> à partir d'un article de recherche.",
			explain: "Bien qu'il soit très éducatif d'implémenter vos propres modèles de <i>transformers</i> à partir de zéro, ce n'est pas ce dont nous parlons ici."
		},
		{
			text: "Un bloc de code compact et autonome qui peut être exécuté sans aucune dépendance externe sur des fichiers ou des données privées.",
			explain: "Des exemples minimaux reproductibles aident les mainteneurs de la bibliothèque à reproduire le problème que vous rencontrez, afin qu'ils puissent trouver des solutions plus rapidement.",
			correct: true
		},
		{
			text: "Une capture d'écran de la traceback Python",
			explain: "Essayez à nouveau. Bien qu'il soit tentant d'inclure une capture d'écran de l'erreur à laquelle vous êtes confronté lorsque vous soumettez un problème, cela rend très difficile pour les autres de reproduire l'erreur."
		},
		{
			text: "Un <i>notebook</i> qui contient toute votre analyse, y compris les parties sans rapport avec l'erreur.",
			explain: "Pas tout à fait. Bien qu'il puisse être utile de partager un <i>notebook</i> Google Colab qui montre l'erreur, assurez-vous qu'il est court et ne contient que le code pertinent."
		}
	]}
/>

### 3. Supposons que vous essayez d'exécuter le code suivant, qui génère une erreur :

```py
from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
# ---------------------------------------------------------------------------
# ImportError                               Traceback (most recent call last)
# /var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_30848/333858878.py in <module>
# ----> 1 from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
```

Lequel des éléments suivants pourrait être un bon choix pour le titre d'un sujet de forum pour demander de l'aide ?

<Question
	choices={[
		{
			text: "<code>ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)</code>",
			explain: "Inclure la dernière ligne de la <i>traceback</i> peut être descriptif, mais il est préférable de le réserver au corps principal du sujet. Essayez à nouveau !"
		},
		{
			text: "Problème avec <code>from transformers import GPT3ForSequenceClassification</code>",
			explain: "Essayez à nouveau. Bien que cette information soit utile, il est probablement préférable de la réserver au corps du texte.",
		},
		{
			text: "Pourquoi je ne peux pas importer <code>GPT3ForSequenceClassification</code>?",
			explain: "Ce titre est concis et donne au lecteur un indice sur ce qui pourrait être erroné (par exemple, que GPT-3 n'est pas pris en charge dans 🤗 <i>Transformers</i>).",
			correct: true
		},
		{
			text: "Le GPT-3 est-il pris en charge dans 🤗 <i>Transformers</i> ?",
			explain: "Utiliser des questions comme titres de sujets est un excellent moyen de communiquer le problème à la communauté.",
			correct: true
		}
	]}
/>

### 4. Supposons que vous ayez essayé d'exécuter `trainer.train()` et que vous soyez confronté à une erreur énigmatique qui ne vous dit pas exactement d'où vient l'erreur. Quel est le premier endroit où vous devez chercher les erreurs dans votre pipeline d'entraînement ?

<Question
	choices={[
		{
			text: "L'étape d'optimisation où nous calculons les gradients et effectuons la rétropropagation.",
			explain: "Bien qu'il puisse y avoir des <i>bugs</i> dans votre optimiseur, cela se produit généralement à plusieurs étapes du pipeline d'entraînement, il y a donc d'autres choses à vérifier d'abord. Essayez à nouveau !"
		},
		{
			text: "L'étape d'évaluation où nous calculons les métriques",
			explain: "L'évaluation est généralement ce que vous faites après l'entraînement pour une époque complète, donc vous devriez d'abord vérifier quelque part plus tôt dans le pipeline d'entraînement.",
		},
		{
			text: "Les jeux de données",
			explain: "C'est exact ! L'examen de vos données est presque toujours la première chose à faire, pour vous assurer que le texte est codé de manière appropriée, qu'il présente les caractéristiques attendues, etc.",
			correct: true
		},
		{
			text: "Les chargeurs de données",
			explain: "Essayez à nouveau. C'est très proche de la première chose que vous devriez vérifier. Vous souvenez-vous de l'objet que nous passons aux <i>dataloaders</i> ?"
		}
	]}
/>

### 5. Quelle est la meilleure façon de déboguer une erreur CUDA ?

<Question
	choices={[
		{
			text: "Postez le message d'erreur sur les forums ou sur GitHub.",
			explain: "Cela n'aidera personne car les messages d'erreur CUDA sont généralement très peu informatifs."
		},
		{
			text: "Exécutez le même code sur le CPU.",
			explain: "Exactement, cela devrait vous donner un meilleur message d'erreur !",
			correct: true
		},
		{
			text: "Lisez la <i>traceback</i> pour découvrir ce qui a causé l'erreur.",
			explain: "C'est ce que vous feriez pour toute autre erreur, mais les erreurs CUDA ne sont généralement pas signalées là où elles se sont produites, car la plupart des opérations CUDA sont asynchrones."
		},
		{
			text: "Réduisez la taille du <i>batch</i>.",
			explain: "La réduction de la taille du batch est généralement une bonne stratégie pour gérer les erreurs CUDA hors mémoire, mais pas pour ce problème particulier. Essayez à nouveau !"
		},
		{
			text: "Redémarrez le noyau Jupyter.",
			explain: "Essayez à nouveau. Le redémarrage du noyau ne fera pas disparaître l'erreur comme par magie !",
		}
	]}
/>

### 6. Quelle est la meilleure façon de faire corriger un problème sur GitHub ?

<Question
	choices={[
		{
			text: "Postez un exemple complet et reproductible du <i>bug</i>.",
			explain: "C'est la meilleure façon d'aider les mainteneurs à trouver votre bogue. Que devez-vous faire d'autre ?",
			correct: true
		},
		{
			text: "Demandez chaque jour une mise à jour.",
			explain: "Il est peu probable que cela vous apporte de l'aide. Les gens vous ignoreront probablement davantage.",
		},
		{
			text: "Inspectez le code source autour du bogue et essayez de trouver la raison pour laquelle il se produit. Postez les résultats dans le problème.",
			explain: "Cela aidera certainement les mainteneurs ! Et si vous trouvez la source du bogue et un correctif, vous pouvez même ouvrir une demande de modification. Que devez-vous faire d'autre ?",
			correct: true
		}
	]}
/>

### 7. Pourquoi le surapprentissage à un batch est-il généralement une bonne technique de débogage ?

<Question
	choices={[
		{
			text: "Ce n'est pas le cas. Le surapprentissage est toujours mauvais et doit être évité.",
			explain: "Lors de l'entraînement sur le jeu de données, le surapprentissage peut en effet être un signe que votre modèle ne généralisera pas bien aux nouveaux exemples. Pour le débogage, cependant, nous n'avons pas l'habitude de nous entraîner sur l'ensemble des données. Essayez à nouveau !"
		},
		{
			text: "Elle nous permet de vérifier que le modèle est capable de réduire la perte à zéro.",
			explain: "Avec un petit batch d'à peine deux exemples, nous pouvons rapidement vérifier si le modèle est capable d'apprendre.",
			correct: true
		},
		{
			text: "Il nous permet de vérifier que les formes tensorielles de nos entrées et de nos étiquettes sont correctes.",
			explain: "Essayez à nouveau. Si vos formes tensorielles sont mal alignées, vous ne pourrez certainement pas vous entraîner, même sur un seul batch.",
		}
	]}
/>

### 8. Pourquoi est-ce une bonne idée d'inclure des détails sur votre environnement de calcul avec `transformers-cli env` lorsque vous créez une nouvelle question dans le dépôt 🤗 *Transformers* ?

<Question
	choices={[
		{
			text: "Cela permet aux mainteneurs de comprendre quelle version de la bibliothèque vous utilisez.",
			explain: "Comme chaque version majeure de la bibliothèque peut comporter des modifications de l'API, le fait de connaître la version spécifique que vous utilisez peut vous aider à circonscrire le problème. Quels sont les autres avantages ?",
			correct: true
		},
		{
			text: "Il permet aux mainteneurs de savoir si vous exécutez le code sous Windows, macOS ou Linux.",
			explain: "Les erreurs peuvent parfois être causées par le système d'exploitation spécifique que vous utilisez, et le fait de le savoir aide les mainteneurs à les reproduire localement. Mais ce n'est pas la seule raison.",
			correct: true
		},
		{
			text: "Il permet aux mainteneurs de savoir si le code est exécuté sur un GPU ou un CPU.",
			explain: "Comme nous l'avons vu dans ce chapitre, les erreurs sur les GPU et les CPU peuvent avoir une saveur très différente, et savoir quel matériel vous utilisez peut aider à focaliser l'attention des mainteneurs. Mais ce n'est pas le seul avantage...",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter8/7.mdx" />