# परिचय

हगिंग फेस में आपका स्वागत है! यह परिचय कार्य वातावरण स्थापित करने में आपका मार्गदर्शन करेगा। यदि आप अभी पाठ्यक्रम शुरू कर रहे हैं, तो हम अनुशंसा करते हैं कि आप पहले [अध्याय 1](course/chapter1) पर एक नज़र डालें, फिर वापस आएं और अपना वातावरण सेट करें ताकि आप कोड को स्वयं आज़मा सकें।

इस पाठ्यक्रम में हम जिन सभी पुस्तकालयों का उपयोग करेंगे, वे पायथन पैकेज के रूप में उपलब्ध हैं, इसलिए यहां हम आपको दिखाएंगे कि पायथन वातावरण कैसे स्थापित करें और विशिष्ट पुस्तकालयों को स्थापित करें जिनकी आपको आवश्यकता होगी।

हम आपके कार्य परिवेश को स्थापित करने के दो तरीकों को कवर करेंगे, एक Colab नोटबुक या एक पायथन आभासी वातावरण का उपयोग करके। बेझिझक वह चुनें जो आपके साथ सबसे अधिक प्रतिध्वनित हो। शुरुआती लोगों के लिए, हम दृढ़ता से अनुशंसा करते हैं कि आप Colab नोटबुक का उपयोग करके शुरुआत करें।

ध्यान दें कि हम विंडोज सिस्टम को कवर नहीं करेंगे। यदि आप Windows पर चल रहे हैं, तो हम अनुशंसा करते हैं कि Colab नोटबुक का उपयोग करने के साथ-साथ अनुसरण करें। यदि आप Linux वितरण या macOS का उपयोग कर रहे हैं, तो आप यहाँ वर्णित किसी भी दृष्टिकोण का उपयोग कर सकते हैं।

अधिकांश पाठ्यक्रम आपके हगिंग फेस खाते पर निर्भर करता है। हम अभी एक बनाने की सलाह देते हैं: [एक खाता बनाएँ](https://huggingface.co/join)।

## Google Colab नोटबुक का उपयोग करना

Colab नोटबुक का उपयोग करना सबसे आसान संभव सेटअप है; अपने ब्राउज़र में एक नोटबुक बूट करें और सीधे कोडिंग पर जाएं!

यदि आप Colab से परिचित नहीं हैं, तो हम अनुशंसा करते हैं कि आप [परिचय](https://colab.research.google.com/notebooks/intro.ipynb) का पालन करके शुरुआत करें। Colab आपको GPU या TPU जैसे कुछ त्वरित हार्डवेयर का उपयोग करने की अनुमति देता है, और यह छोटे कार्यभार के लिए मुफ़्त है।

एक बार जब आप Colab में घूमने में सहज हो जाएं, तो एक नई नोटबुक बनाएं और स्थापना के साथ आरंभ करें:
<div class="flex justify-center">
    <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="एक खाली Colab नोटबुक" width="80%">
</div>

अगला चरण उन पुस्तकालयों को स्थापित करना है जिनका हम इस पाठ्यक्रम में उपयोग करेंगे। हम स्थापना के लिए `pip` का उपयोग करेंगे, जो कि पायथन के लिए पैकेज मैनेजर है। नोटबुक्स में, आप `!` वर्ण से पहले सिस्टम कमांड चला सकते हैं, इसलिए आप ट्रान्सफ़ॉर्मर लाइब्रेरी को निम्नानुसार स्थापित कर सकते हैं:
अगला चरण उन पुस्तकालयों को स्थापित करना है जिनका हम इस पाठ्यक्रम में उपयोग करेंगे। हम स्थापना के लिए `pip` का उपयोग करेंगे, जो कि पायथन के लिए पैकेज मैनेजर है। नोटबुक्स में, आप `!` वर्ण से पहले सिस्टम कमांड चला सकते हैं, इसलिए आप 🤗 ट्रान्सफ़ॉर्मर लाइब्रेरी को निम्नानुसार स्थापित कर सकते हैं:

```
!pip install transformers
```

आप यह सुनिश्चित कर सकते हैं कि पैकेज आपके पायथन रनटाइम के भीतर आयात करके सही ढंग से स्थापित किया गया है:

```
import transformers
```

<div class="flex justify-center">
    <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="उपरोक्त दो आदेशों का परिणाम दिखाने वाला एक GIF: स्थापना और आयात" width="80%">
</div>

यह 🤗 ट्रांसफॉर्मर का एक बहुत हल्का संस्करण स्थापित करता है। विशेष रूप से, कोई विशिष्ट मशीन लर्निंग फ्रेमवर्क (जैसे PyTorch या TensorFlow) स्थापित नहीं हैं। चूंकि हम पुस्तकालय की कई अलग-अलग विशेषताओं का उपयोग करेंगे, हम विकास संस्करण को स्थापित करने की सलाह देते हैं, जो किसी भी कल्पनाशील उपयोग के मामले के लिए सभी आवश्यक निर्भरताओं के साथ आता है:

```
!pip install transformers[sentencepiece]
```

इसमें थोड़ा समय लगेगा, लेकिन फिर आप बाकी पाठ्यक्रम के लिए तैयार हो जाएंगे।

## पायथन आभासी वातावरण का उपयोग करना

यदि आप एक पायथन आभासी वातावरण का उपयोग करना पसंद करते हैं, तो पहला कदम आपके सिस्टम पर पायथन को स्थापित करना है। हम आरंभ करने के लिए [इस गाइड](https://realpython.com/installing-python/) का पालन करने की सलाह देते हैं। 

एक बार जब आप पायथन स्थापित कर लेते हैं, तो आपको अपने टर्मिनल में पायथन आदेश चलाने में सक्षम होना चाहिए। अगले चरण पर आगे बढ़ने से पहले यह सुनिश्चित करने के लिए कि यह सही ढंग से स्थापित है, आप निम्न आदेश चलाकर प्रारंभ कर सकते हैं: `python --version`. यह आपके सिस्टम पर अब उपलब्ध पायथन संस्करण को प्रिंट करना चाहिए।

अपने टर्मिनल में पायथन आदेश चलाते समय, जैसे `python --version` आदेश को चलाने वाले प्रोग्राम को अपने सिस्टम में "main" पायथन के रूप में सोचना चाहिए। हम अनुशंसा करते हैं कि इस मुख्य स्थापना को किसी भी पैकेज से मुक्त रखें, और इसका उपयोग प्रत्येक एप्लिकेशन के लिए अलग वातावरण बनाने के लिए करें, जिस पर आप काम कर रहे हैं - इस तरह, प्रत्येक एप्लिकेशन की अपनी निर्भरताएं और पैकेज होंगे, और आपको अन्य एप्लिकेशन के साथ संभावित संगतता समस्याओं के बारे में चिंता करने की आवश्यकता नहीं होगी।

पायथन में यह [आभासी वातावरण](https://docs.python.org/3/tutorial/venv.html) के साथ किया जाता है, जो स्व-निहित निर्देशिका ट्री हैं जिनमें से प्रत्येक में एक विशेष पायथन संस्करण के साथ एक पायथन स्थापना होती है, जिसमें सभी पैकेजों के साथ एप्लिकेशन की आवश्यकता होती है। इस तरह के आभासी वातावरण का निर्माण कई अलग-अलग उपकरणों के साथ किया जा सकता है, लेकिन हम उस उद्देश्य के लिए आधिकारिक पायथन पैकेज का उपयोग करेंगे, जिसे कहा जाता है [`venv`](https://docs.python.org/3/library/venv.html#module-venv)।

सबसे पहले, एक निर्देशिका बनाएं जिसमें आप अपने आवेदन में रहना चाहते हैं - उदाहरण के लिए, आप अपनी होम निर्देशिका के मूल में *transformers-course* नामक एक नई निर्देशिका बनाना चाहेंगे:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

इस निर्देशिका के अंदर, पायथन `venv` मॉड्यूल का उपयोग करके एक आभासी वातावरण बनाएं:

```
python3 -m venv .env
```

अब आपके पास आपके अन्यथा खाली फ़ोल्डर में *.env* नामक एक निर्देशिका होनी चाहिए:

```
ls -a
```

```out
.      ..    .env
```

आप 'activate' और 'deactivate' स्क्रिप्ट के साथ अपने आभासी वातावरण में और बाहर कूद सकते हैं:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

आप यह सुनिश्चित कर सकते हैं कि `which python` आदेश चलाकर कौन सा पर्यावरण सक्रिय है: यदि यह आभासी वातावरण की ओर इशारा करता है, तो आपने इसे सफलतापूर्वक सक्रिय कर दिया है!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

## निर्भरता स्थापित करना

Google Colab इंस्टेंस का उपयोग करने पर पिछले अनुभाग की तरह, अब आपको जारी रखने के लिए आवश्यक पैकेजों को स्थापित करने की आवश्यकता होगी। फिर से, आप `pip` पैकेज मैनेजर का उपयोग करके 🤗 ट्रांसफॉर्मर के विकास संस्करण को स्थापित कर सकते हैं:

```
pip install "transformers[sentencepiece]"
```

अब आप पूरी तरह से तैयार हैं!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter0/1.mdx" />