import{s as or,o as pr,n as wl}from"../chunks/scheduler.cc52f4b9.js";import{S as mr,i as cr,e as n,s,c as p,h as dr,a as r,d as l,b as i,f as nr,g as m,j as o,k as rr,l as ur,m as a,n as c,t as d,o as u,p as M}from"../chunks/index.d2856393.js";import{T as jl}from"../chunks/Tip.a5bdccc4.js";import{C as Mr,H as j,E as Jr}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8ffb7edb.js";import{Y as yr}from"../chunks/Youtube.00df107c.js";import{C as y}from"../chunks/CodeBlock.5f8dc025.js";import{C as br}from"../chunks/CourseFloatingBanner.59eb3fdc.js";import{F as Tr}from"../chunks/FrameworkSwitchCourse.22a5e932.js";function hr(f){let J,T="✏️ <strong>Prova tu!</strong> Controlla che tutto sia corretto nel secondo elemento del training set.";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-4bjsze"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function fr(f){let J,T="Nella prossima parte del corso, esamineremo tecniche più avanzate che possono aiutare a ridurre l’impatto sulla memoria e ad affinare i modelli più grandi.";return{c(){J=n("p"),J.textContent=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-q2er6j"&&(J.textContent=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function jr(f){let J,T="💡 Bisogna sempre assicurarsi di poter eseguire <code>trainer.evaluate()</code> prima di lanciare <code>trainer.train()</code>, per evitare di sprecare molte risorse di calcolo prima di incorrere in un errore.";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1wy054r"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function wr(f){let J,T="💡 Se si utilizza un ciclo di addestramento manuale, per il debug della pipeline di addestramento valgono gli stessi passaggi, ma è più facile separarli. Assicurati però di non aver dimenticato il <code>model.eval()</code> o il <code>model.train()</code> nei punti giusti, o lo <code>zero_grad()</code> a ogni passo!";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-17w7sr0"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function Ur(f){let J,T="⚠️ Se effettui un addestramento in modo distribuito, stampa campioni del set di dati in ogni processo e controlla molto attentamente che ottieni la stessa cosa. Un bug comune è la presenza di una qualche fonte di casualità nella creazione dei dati che fa sì che ogni processo abbia una versione diversa del set di dati.";return{c(){J=n("p"),J.textContent=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-yqzwsk"&&(J.textContent=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function gr(f){let J,T="💡 Se i dati di addestramento sono sbilanciati, assicurati di creare un batch di dati di addestramento contenente tutte le label.";return{c(){J=n("p"),J.textContent=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1ueptnc"&&(J.textContent=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function $r(f){let J,T="⚠️ Sarà necessario ricreare il modello e il <code>Trainer</code> dopo questo test, poiché il modello ottenuto probabilmente non sarà in grado di recuperare e imparare qualcosa di utile sul set di dati completo.";return{c(){J=n("p"),J.innerHTML=T},l(b){J=r(b,"P",{"data-svelte-h":!0}),o(J)!=="svelte-wtiz5s"&&(J.innerHTML=T)},m(b,h){a(b,J,h)},p:wl,d(b){b&&l(J)}}}function Cr(f){let J,T,b,h,w,gl,k,$l,B,Cl,W,Zl,X,gi='Hai scritto un bello script per addestrare o affinare un modello su un determinato compito, seguendo scrupolosamente i consigli del <a href="/course/chapter7">Capitolo 7</a>. Ma quando lanci il comando <code>trainer.train()</code>, succede qualcosa di orribile: si ottiene un errore 😱! O peggio, tutto sembra andare bene e il training viene eseguito senza errori, ma il modello che ne risulta fa schifo. In questa sezione mostreremo cosa è possibile fare per eseguire il debug di questo tipo di problemi.',vl,R,Il,z,kl,G,$i="Il problema quando si ha un errore da <code>trainer.train()</code> è che potrebbe provenire da più fonti, poiché il <code>Trainer</code> di solito mette insieme molte cose. Converte i dataset in <em>dataloader</em>, quindi l’errore potrebbe essere dato da qualcosa di sbagliato nel dataset stesso, o da un problema qualche problema nel provare a raggruppare in un batch elementi del dataset. Poi prende un batch di dati e lo invia al modello, quindi il problema potrebbe anche essere nel codice del modello. Successivamente, calcola i gradienti ed esegue la fase di ottimizzazione, quindi il problema potrebbe essere nel tuo <em>optimizer</em>. E anche se tutto va bene per il training, qualcosa potrebbe andare storto durante la valutazione se c’è un problema con la metrica selezionata.",Bl,V,Ci="Il modo migliore per eseguire il debug di un errore che si verifica in <code>trainer.train()</code> è quello di esaminare manualmente l’intera pipeline per vedere dove le cose sono andate storte. L’errore è spesso molto facile da risolvere.",Wl,_,Zi='Per dimostrarlo, useremo il seguente script che ha lo scopo di affinare un modello DistilBERT sul <a href="https://huggingface.co/datasets/glue" rel="nofollow">dataset MNLI</a>:',Xl,Y,Rl,x,vi="Se provi a eseguirlo, otterrai un errore piuttosto criptico:",zl,F,Gl,A,Vl,H,Ii="Non c’è bisogno di dirlo, ma se i dati sono corrotti, il <code>Trainer</code> non sarà in grado di formare i batch e tanto meno di addestrare il modello. Quindi, per prima cosa, è necessario dare un’occhiata a cosa c’è nel training set(<em>insieme di addestramento</em>).",_l,Q,ki="Per evitare di passare infinite ore a cercare di risolvere qualcosa che non è la fonte del bug, consigliamo di usare <code>trainer.train_dataset</code> per controllare l’insieme di dati e nient’altro. Quindi facciamo così:",Yl,N,xl,E,Fl,q,Bi="Hai notato qualcosa di sbagliato? Questo, insieme al messaggio di errore sulla mancanza di <code>input_ids</code>, dovrebbe farci capire che qui abbiamo testo, non numeri che invece il modello può interpretare. In questo caso, l’errore originale è molto fuorviante, perché il <code>Trainer</code> rimuove automaticamente le colonne che non corrispondono alla firma del modello (cioè i parametri che il modello si aspetta). Ciò significa che in questo caso tutto, a parte <em>label</em>, è stato scartato. Non c’è stato quindi nessun problema nel creare i batch di dati e poi inviarli al modello, invece è il modello che a sua volta si è lamentato di non aver ricevuto l’input corretto.",Al,S,Wi="Perché i dati non sono stati processati? Abbiamo usato il metodo <code>Dataset.map()</code> sui set di dati per applicare il tokenizer a ogni campione. Ma se si osserva attentamente il codice, si noterà che abbiamo commesso un errore nel passare i training set e il validation set (<em>insieme di valutazione</em>) al <code>Trainer</code>. Qui invece di usare <code>tokenized_datasets</code>, abbiamo usato <code>raw_datasets</code> 🤦. Quindi correggiamo questo errore!",Hl,L,Ql,D,Xi="Questo nuovo codice ora darà un errore diverso (un miglioramento!):",Nl,P,El,K,Ri="Osservando il traceback, si nota che l’errore si verifica nel punto in cui i dati vengono raccolti:",ql,O,Sl,ee,zi="Quindi, bisogna concentrarsi su questo. Prima di farlo, però, finiamo d’ispezionare i nostri dati, per essere sicuri al 100% che siano corretti.",Ll,te,Gi="Una cosa da fare sempre quando si esegue il debug di una sessione di addestramento è dare un’occhiata agli input del modello decodificati. Non possiamo dare un senso ai numeri che gli diamo direttamente in pasto, quindi dobbiamo guardare cosa rappresentano quei numeri. Nella computer vision, ad esempio, ciò significa guardare le immagini decodificate dei pixel passati, nel campo del riconoscimento vocale significa ascoltare i campioni audio decodificati e per il nostro esempio di NLP significa usare il nostro tokenizer per decodificare gli input:",Dl,le,Pl,ae,Kl,se,Vi="Questo sembra corretto. Si dovrebbe fare così per tutte le chiavi degli input:",Ol,ie,ea,ne,ta,re,_i="Si noti che le chiavi che non corrispondono a input accettati dal modello saranno automaticamente scartate, quindi qui terremo solo <code>input_ids</code>, <code>attention_mask</code> e <code>label</code> (che sarà rinominata <code>labels</code>). Per ricontrollare la firma del modello, si può stampare la classe del modello e poi controllare la sua documentazione:",la,oe,aa,pe,sa,me,Yi='Quindi, nel nostro caso, possiamo controllare i parametri accettati in <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">questa pagina</a>. Il <code>Trainer</code> registrerà anche le colonne che sta scartando.',ia,ce,xi="Abbiamo controllato che gli ID in ingresso siano corretti decodificandoli. Il prossimo passo è la <code>attention_mask</code>:",na,de,ra,ue,oa,Me,Fi="Poiché non abbiamo applicato il padding nel nostro preprocessing, questo sembra perfettamente naturale. Per essere sicuri che non ci siano problemi con la attention mask (<em>maschera di attenzione</em>), controlliamo che sia della stessa lunghezza dei nostri ID di input:",pa,Je,ma,ye,ca,be,Ai="Bene! Infine, controlliamo la nostra label:",da,Te,ua,he,Ma,fe,Hi="Come gli ID degli input, si tratta di un numero che non ha senso di per sé. Come abbiamo visto prima, la mappa tra gli interi e i nomi delle label è memorizzata all’interno dell’attributo <code>names</code> della corrispondente <em>feature</em> del dataset:",Ja,je,ya,we,ba,Ue,Qi="Quindi <code>1</code> significa <code>neutral</code> (<em>neutro</em>), il che significa che le due frasi viste sopra non sono in contraddizione e che la prima non implica la seconda. Sembra corretto!",Ta,ge,Ni="Non abbiamo token type ID (<em>ID del tipo di token</em>) qui, perché DistilBERT non li prevede; se li hai nel tuo modello, devi anche assicurarti che corrispondano correttamente alla posizione della prima e della seconda frase nell’input.",ha,U,fa,$e,Ei="In questo caso, il controllo viene effettuato solo sul training set, ma è necessario ricontrollare allo stesso modo anche il validation set e il test set.",ja,Ce,qi="Ora che sappiamo che i nostri set di dati sono corretti, è il momento di verificare la fase successiva della pipeline di addestramento.",wa,Ze,Ua,ve,Si="La prossima cosa che può andare storta nella pipeline di addestramento è quando il <code>Trainer</code> cerca di formare dei batch dal training o dal validation set. Una volta che si è sicuri che i set di dati del <code>Trainer</code> sono corretti, si può provare a formare manualmente un batch eseguendo quanto segue (sostituire <code>train</code> con <code>eval</code> per il dataloader di validazione):",ga,Ie,$a,ke,Li="Questo codice crea il training dataloader (<em>caricatore di dati di addestramento</em>), quindi lo itera, fermandosi alla prima iterazione. Se il codice viene eseguito senza errori, si ha il primo batch di addestramento che può essere ispezionato; se il codice dà errore, si sa con certezza che il problema è nel dataloader, come in questo caso:",Ca,Be,Za,We,Di="L’ispezione dell’ultimo frame del traceback dovrebbe essere sufficiente a fornire un indizio, ma cerchiamo di scavare un po’ più a fondo. La maggior parte dei problemi durante la creazione dei batch si verifica a causa del raggruppamento degli esempi in un singolo batch, quindi la prima cosa da controllare in caso di dubbio è quale <code>collate_fn</code> il tuo <code>DataLoader</code> sta usando:",va,Xe,Ia,Re,ka,ze,Pi="È il <code>default_data_collator</code>, ma non è quello che vogliamo in questo caso. Vogliamo che i nostri esempi siano espansi fino ad essere come la frase più lunga del batch, cosa che viene fatta dal collettore <code>DataCollatorWithPadding</code>. Questo collatore di dati dovrebbe essere usato di default da <code>Trainer</code>, quindi perché non viene usato qui?",Ba,Ge,Ki="La risposta è che non abbiamo passato il <code>tokenizer</code> al <code>Trainer</code>, quindi non ha potuto creare il <code>DataCollatorWithPadding</code> che volevamo. In pratica, non si dovrebbe mai esitare a passare esplicitamente il collettore di dati che si vuole usare, per essere sicuri di evitare questo tipo di errori. Adattiamo il nostro codice per fare esattamente questo:",Wa,Ve,Xa,_e,Oi="La buona notizia? Non riceviamo più lo stesso errore di prima, il che è sicuramente un miglioramento. La cattiva notizia? Otteniamo invece un famigerato errore CUDA:",Ra,Ye,za,xe,en="Questo è un male perché gli errori di CUDA sono estremamente difficili da debuggare in generale. Vedremo tra poco come risolvere questo problema, ma prima terminiamo l’analisi della creazione di batch.",Ga,Fe,tn="Se siete sicuri che il tuo collettore di dati è quello giusto, dovresti provare ad applicarlo su un paio di campioni del tuo set di dati:",Va,Ae,_a,He,ln="Questo codice fallirà perché il <code>train_dataset</code> contiene colonne di tipo stringa, che il <code>Trainer</code> solitamente rimuove. È possibile rimuoverle manualmente o, se si vuole replicare esattamente ciò che il <code>Trainer</code> fa dietro le quinte, si può chiamare il metodo privato <code>Trainer._remove_unused_columns()</code> che fa questo:",Ya,Qe,xa,Ne,an="Se l’errore persiste, si potrebbe eseguire manualmente il debug di ciò che accade all’interno del collettore di dati.",Fa,Ee,sn="Ora che abbiamo eseguito il debug del processo di creazione del batch, è il momento di passarne uno attraverso il modello!",Aa,qe,Ha,Se,nn="Dovrebbe essere possibile ottenere un batch eseguendo il seguente comando:",Qa,Le,Na,De,rn="Se si esegue questo codice in un notebook, è possibile che si verifichi un errore CUDA simile a quello visto in precedenza, nel qual caso è necessario riavviare il notebook e rieseguire l’ultimo snippet senza la riga <code>trainer.train()</code>. Questa è la seconda cosa più fastidiosa degli errori CUDA: rompono irrimediabilmente il kernel. La cosa più fastidiosa è che sono difficili da debuggare.",Ea,Pe,on="Perché? Questo ha a che fare con il modo in cui funzionano le GPU. Sono estremamente efficienti nell’eseguire molte operazioni in parallelo, ma l’inconveniente è che quando una di queste istruzioni produce un errore, non lo si sa immediatamente. È solo quando il programma chiama una sincronizzazione dei processi multipli sulla GPU che esso si accorge che qualcosa è andato storto, quindi l’errore viene effettivamente sollevato in un punto che non ha niente a che fare con ciò che lo ha creato. Per esempio, se guardiamo il nostro traceback precedente, l’errore è stato sollevato durante il backward pass (<em>percorso discendente</em>), ma vedremo tra un minuto che in realtà deriva da qualcosa nel forward pass (<em>percorso ascendente</em>).",qa,Ke,pn="Come si fa a fare il debug di questi errori? La risposta è semplice: non lo facciamo. A meno che l’errore CUDA non sia un errore out-of-memory (il che significa che la memoria della GPU non è sufficiente), si dovrebbe sempre tornare alla CPU per eseguire il debug.",Sa,Oe,mn="Per fare questo nel nostro caso, dobbiamo semplicemente rimettere il modello sulla CPU e chiamarlo sul nostro batch — il batch restituito dal <code>DataLoader</code> non è ancora stato spostato sulla GPU:",La,et,Da,tt,Pa,lt,cn="Quindi, il quadro si fa più chiaro. Invece di avere un errore CUDA, ora abbiamo un <code>IndexError</code> nel calcolo della loss (<em>funzione di perdita</em>) (quindi niente a che fare con il backward pass, come abbiamo detto prima). Più precisamente, possiamo vedere che è il target 2 a creare l’errore, quindi questo è un ottimo momento per controllare il numero di label del nostro modello:",Ka,at,Oa,st,es,it,dn="Con due label, solo gli 0 e gli 1 sono ammessi come target, ma secondo il messaggio di errore abbiamo ottenuto un 2. Ottenere un 2 è in realtà normale: se ricordiamo i nomi delle etichette che abbiamo estratto in precedenza, ce n’erano tre, quindi abbiamo gli indici 0, 1 e 2 nel nostro dataset. Il problema è che non l’abbiamo detto al nostro modello, il quale si sarebbe dovuto creare con tre label. Quindi, risolviamo il problema!",ts,nt,ls,rt,un="Non abbiamo ancora incluso la riga <code>trainer.train()</code>, per prendere tempo e verificare che tutto sia a posto. Se richiediamo un batch e lo passiamo al nostro modello, ora funziona senza errori!",as,ot,ss,pt,Mn="Il passo successivo consiste nel tornare a usare la GPU e verificare che tutto funzioni ancora:",is,mt,ns,ct,Jn="Se si verifica ancora un errore, assicurarsi di riavviare il notebook ed eseguire solo l’ultima versione dello script.",rs,dt,os,ut,yn="Ora che sappiamo che possiamo costruire batch che passano effettivamente attraverso il modello, siamo pronti per la fase successiva della pipeline di addestramento: calcolare i gradienti ed eseguire una fase di ottimizzazione.",ps,Mt,bn="La prima parte consiste nel richiamare il metodo <code>backward()</code> sulla loss:",ms,Jt,cs,yt,Tn="È abbastanza raro che si verifichi un errore in questa fase, ma se si verifica, assicurati di tornare ad usare la CPU per ottenere un messaggio di errore più utile.",ds,bt,hn="Per eseguire la fase di ottimizzazione, è sufficiente creare l’oggetto <code>optimizer</code> e richiamare il suo metodo <code>step()</code>:",us,Tt,Ms,ht,fn="Anche in questo caso, se si utilizza l’ottimizzatore predefinito nel <code>Trainer</code>, non si dovrebbe ottenere un errore in questa fase, ma se hai un ottimizzatore personalizzato, potrebbero esserci dei problemi da risolvere. Non dimenticare di tornare alla CPU se ottieni uno strano errore CUDA in questa fase. A proposito di errori CUDA, prima abbiamo menzionato un caso speciale. Vediamo ora questo caso.",Js,ft,ys,jt,jn="Ogni volta che si riceve un messaggio di errore che inizia con <code>RuntimeError: CUDA out of memory</code>, indica che la memoria della GPU è esaurita. Questo errore non è direttamente collegato al codice e può verificarsi anche con uno script che funziona perfettamente. Questo errore significa che si è tentato di mettere troppe cose nella memoria interna della GPU e che si è verificato un errore. Come per altri errori di CUDA, è necessario riavviare il kernel per poter eseguire nuovamente l’allenamento.",bs,wt,wn="Per risolvere questo problema, è sufficiente utilizzare meno spazio sulla GPU, cosa che spesso è più facile a dirsi che a farsi. Per prima cosa, assicuratevi di non avere due modelli sulla GPU contemporaneamente (a meno che non sia necessario per il vostro problema, ovviamente). Poi, è probabile che si debba ridurre la dimensione del batch, in quanto influisce direttamente sulle dimensioni di tutti gli output intermedi del modello e dei loro gradienti. Se il problema persiste, si può considerare di utilizzare una versione più piccola del modello.",Ts,g,hs,Ut,fs,gt,Un="Ora che abbiamo risolto tutti i problemi con il nostro codice, tutto è perfetto e l’addestramento dovrebbe girare senza intoppi, giusto? Non così veloce! Se si esegue il comando <code>trainer.train()</code>, all’inizio sembrerà tutto a posto, ma dopo un po’ si otterrà il seguente risultato:",js,$t,ws,Ct,Us,Zt,gn="Ti accorgerai che questo errore compare durante la fase di valutazione, quindi è l’ultima cosa che dobbiamo debuggare.",gs,vt,$n="È possibile eseguire il ciclo di valutazione del <code>Trainer</code> indipendentemente dall’addestramento, in questo modo:",$s,It,Cs,kt,Zs,$,vs,Bt,Cn="Prima di tentare il debug di un problema nel ciclo di valutazione, è necessario assicurarsi di aver dato un’occhiata ai dati, di essere in grado di generare correttamente un batch e di poter eseguire il modello su di esso. Abbiamo completato tutti questi passaggi, quindi il codice seguente può essere eseguito senza errori:",Is,Wt,ks,Xt,Zn="L’errore arriva più tardi, alla fine della fase di valutazione, e se guardiamo il traceback vediamo questo:",Bs,Rt,Ws,zt,vn="Questo ci dice che l’errore ha origine nel modulo <code>datasets/metric.py</code>, quindi si tratta di un problema con la nostra funzione <code>compute_metrics()</code>. La funzione accetta una tupla con i logit e le label come array NumPy, quindi proviamo a dargliela in pasto:",Xs,Gt,Rs,Vt,zs,_t,In="Otteniamo lo stesso errore, quindi il problema risiede sicuramente in quella funzione. Se guardiamo al suo codice, vediamo che sta solo trasferendo le <code>predictions</code> e le <code>labels</code> a <code>metric.compute()</code>. C’è quindi un problema con questo metodo? Non proprio. Diamo una rapida occhiata alle dimensioni:",Gs,Yt,Vs,xt,_s,Ft,kn="Le nostre previsioni sono ancora dei logit, non le vere previsioni, ed è per questo che la metrica restituisce questo errore (un po’ oscuro). La soluzione è abbastanza semplice: basta aggiungere un argmax nella funzione <code>compute_metrics()</code>:",Ys,At,xs,Ht,Fs,Qt,Bn="Ora il nostro errore è stato risolto! Questo era l’ultimo, quindi il nostro script ora addestrerà correttamente un modello.",As,Nt,Wn="Per riferimento, ecco lo script completamente corretto:",Hs,Et,Qs,qt,Xn="In questo caso, non ci sono più problemi e il nostro script affinerà un modello che dovrebbe dare risultati ragionevoli. Ma cosa possiamo fare quando l’addestramento procede senza errori e il modello addestrato non funziona affatto bene? Questa è la parte più difficile di machine learning e ti mostreremo alcune tecniche che possono aiutarti.",Ns,C,Es,St,qs,Lt,Rn="Cosa possiamo fare per eseguire il debug di un addestramento che viene completato senza errori, ma che non produce buoni risultati? Qui ti daremo alcuni suggerimenti, ma sappi che questo tipo di debugging è la parte più difficile di machine learning e non esiste una soluzione magica.",Ss,Dt,Ls,Pt,zn="Il tuo modello imparerà qualcosa solo se è effettivamente possibile imparare qualcosa dai tuoi dati. Se c’è un bug che corrompe i dati o le label sono assegnate in modo casuale, è molto probabile che non si riesca ad addestrare il modello sul dataset. Quindi, inizia sempre con un doppio controllo degli input e delle label decodificate e poniti le seguenti domande:",Ds,Kt,Gn="<li>I dati decodificati sono comprensibili?</li> <li>Sei d’accordo con le label?</li> <li>C’è una label più comune delle altre?</li> <li>Quale dovrebbe essere la funzione di perdita/metrica se il modello predicesse una risposta a caso/sempre la stessa risposta?</li>",Ps,Z,Ks,Ot,Vn="Dopo aver esaminato i dati, esamina alcune previsioni del modello e decodificale. Se il modello prevede sempre la stessa cosa, potrebbe essere perché il tuo set di dati è influenzato verso una categoria (per i problemi di classificazione); tecniche come fare oversampling (<em>sovra-campionamento</em>) delle classi rare potrebbero aiutare.",Os,el,_n="Se la funzione di perdita/metrica ottenuta con il tuo modello iniziale è molto diversa da quella che ci si aspetterebbe per le previsioni casuali, ricontrolla il modo in cui viene calcolata la funzione o la metrica, perché probabilmente c’è un bug. Se si utilizzano diverse funzioni che aggiungi alla fine, assicurati che siano della stessa grandezza.",ei,tl,Yn="Quando sei sicuro/a che i dati sono perfetti, puoi verificare se il modello è in grado di addestrarsi su di essi con un semplice test.",ti,ll,li,al,xn="L’overfitting è di solito qualcosa che cerchiamo di evitare durante l’addestramento, poiché significa che il modello non sta imparando a riconoscere le proprietà generali che vogliamo, ma sta invece memorizzando i campioni di addestramento. Tuttavia, provare ad addestrare il modello su un batch più e più volte è un buon test per verificare se il problema così come è stato inquadrato può essere risolto dal modello che si sta cercando di addestrare. Inoltre, ti aiuterà a capire se il learning rate (<em>tasso di apprendimento</em>) iniziale è troppo alta.",ai,sl,Fn="Una volta definito il <code>Trainer</code>, è molto semplice: basta prendere un batch dal training set, ed eseguire un piccolo ciclo di addestramento manuale utilizzando solo quel batch per qualcosa come 20 step:",si,il,ii,v,ni,nl,An="Il modello risultante dovrebbe avere risultati quasi perfetti sullo stesso <code>batch</code>. Calcoliamo la metrica sulle previsioni risultanti:",ri,rl,oi,ol,pi,pl,Hn="100% di accuratezza, questo è un bell’esempio di overfitting (il che significa che se provi il tuo modello su qualsiasi altra frase, molto probabilmente ti darà una risposta sbagliata)!",mi,ml,Qn="Se non si riesci a far sì che il modello ottenga risultati perfetti come questo, significa che c’è qualcosa di sbagliato nel modo in cui si è impostato il problema o con i dati, e quindi dovresti risolvere questa cosa. Solo quando riesci a superare il test di overfitting puoi essere sicuro/a che il tuo modello possa effettivamente imparare qualcosa.",ci,I,di,cl,ui,dl,Nn="Hyperparameter tuning (<em>calibrazione degli iperparametri</em>) è sempre considerato come la parte più difficile di machine learning, ma è solo l’ultimo passo per aiutarti a migliorare un po’ la metrica. Nella maggior parte dei casi, gli iperparametri predefiniti del <code>Trainer</code> funzionano bene per dare buoni risultati, quindi non ci si deve lanciare in una ricerca di iperparametri dispendiosa in termini di tempo e di costi, finché non si è ottenuto qualcosa che batta la baseline (<em>base di partenza</em>) che si ha sul dataset.",Mi,ul,En="Una volta ottenuto un modello sufficientemente buono, si può iniziare a modificarlo un po’. Non provare a eseguire l’addestramento un migliaio di volte con iperparametri diversi, ma confronta un paio di esecuzioni che hanno valori diversi per un iperparametro così da avere un’idea di quale abbia il maggiore impatto.",Ji,Ml,qn="Se stai modificando il modello stesso, mantieni le cose semplici e non provare nulla che non possa essere ragionevolmente giustificato. Assicurati sempre di rifare il test di overfitting per verificare che la modifica non abbia avuto conseguenze indesiderate.",yi,Jl,bi,yl,Sn='Speriamo che in questa sezione tu abbia trovato qualche consiglio utile a risolvere il tuo problema, ma se così non fosse, ricordati che puoi sempre chiedere aiuto alla community nei <a href="https://discuss.huggingface.co/" rel="nofollow">forum</a>.',Ti,bl,Ln="Qui di seguito sono riportate alcune risorse aggiuntive che potrebbero rivelarsi utili:",hi,Tl,Dn='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">“Reproducibility as a vehicle for engineering best practices”</a> di Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> di Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">“How to unit test machine learning code”</a> di Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">“A Recipe for Training Neural Networks”</a> di Andrej Karpathy</li>',fi,hl,Pn="Naturalmente, non tutti i problemi che incontrerai durante l’addestramento delle reti neurali sono colpa tua! Se si incontra qualcosa nella libreria 🤗 Transformers o 🤗 Datasets che non sembra corretto, è possibile che si sia trovato un bug. Dovresti assolutamente segnalarcelo e nella prossima sezione ti spiegheremo esattamente come fare.",ji,fl,wi,Ul,Ui;return w=new Tr({props:{fw:f[0]}}),k=new Mr({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new j({props:{title:"Fare il debug della training pipeline",local:"fare-il-debug-della-training-pipeline",headingTag:"h1"}}),W=new br({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter8/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter8/section4.ipynb"}]}}),R=new j({props:{title:"Fare il debug della training pipeline",local:"fare-il-debug-della-training-pipeline",headingTag:"h2"}}),z=new yr({props:{id:"L-WSwUWde1U"}}),Y=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),F=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),A=new j({props:{title:"Controlla i dati",local:"controlla-i-dati",headingTag:"h3"}}),N=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),E=new y({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),L=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),P=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),O=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),le=new y({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),ae=new y({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),ie=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),ne=new y({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),oe=new y({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),pe=new y({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),de=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]',wrap:!1}}),ue=new y({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),Je=new y({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),ye=new y({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),Te=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),he=new y({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),je=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),we=new y({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new jl({props:{$$slots:{default:[hr]},$$scope:{ctx:f}}}),Ze=new j({props:{title:"Dai dataset ai dataloader",local:"dai-dataset-ai-dataloader",headingTag:"h3"}}),Ie=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Be=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),Xe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),Re=new y({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Ve=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwbG9hZF9tZXRyaWMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Ub2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwRGF0YUNvbGxhdG9yV2l0aFBhZGRpbmclMkMlMEElMjAlMjAlMjAlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUwQSUyMCUyMCUyMCUyMFRyYWluZXIlMkMlMEEpJTBBJTBBcmF3X2RhdGFzZXRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdsdWUlMjIlMkMlMjAlMjJtbmxpJTIyKSUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJwcmVtaXNlJTIyJTVEJTJDJTIwZXhhbXBsZXMlNUIlMjJoeXBvdGhlc2lzJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBmJTIyZGlzdGlsYmVydC1maW5ldHVuZWQtbW5saSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS01JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDMlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QwLjAxJTJDJTBBKSUwQSUwQW1ldHJpYyUyMCUzRCUyMGxvYWRfbWV0cmljKCUyMmdsdWUlMjIlMkMlMjAlMjJtbmxpJTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyklMEElMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yV2l0aFBhZGRpbmcodG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnZhbGlkYXRpb25fbWF0Y2hlZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),Ye=new y({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Ae=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Qe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),qe=new j({props:{title:"Passaggio attraverso il modello",local:"passaggio-attraverso-il-modello",headingTag:"h3"}}),Le=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),et=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),tt=new y({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),at=new y({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),st=new y({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),nt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),ot=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),mt=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),dt=new j({props:{title:"Esecuzione di un passaggio di ottimizzazione",local:"esecuzione-di-un-passaggio-di-ottimizzazione",headingTag:"h3"}}),Jt=new y({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),Tt=new y({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),ft=new j({props:{title:"Come gestire gli errori out-of-memory di CUDA",local:"come-gestire-gli-errori-out-of-memory-di-cuda",headingTag:"h3"}}),g=new jl({props:{$$slots:{default:[fr]},$$scope:{ctx:f}}}),Ut=new j({props:{title:"Valutazione del modello",local:"valutazione-del-modello",headingTag:"h3"}}),$t=new y({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjB0YWtlJTIwYSUyMGxvbmclMjB0aW1lJTIwYW5kJTIwZXJyb3IlMjBvdXQlMkMlMjBzbyUyMHlvdSUyMHNob3VsZG4ndCUyMHJ1biUyMHRoaXMlMjBjZWxsJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># This will take a long time and error out, so you shouldn&#x27;t run this cell</span>
trainer.train()`,wrap:!1}}),Ct=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),It=new y({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),kt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),$=new jl({props:{$$slots:{default:[jr]},$$scope:{ctx:f}}}),Wt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Rt=new y({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),Gt=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Vt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),Yt=new y({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),xt=new y({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),At=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),Ht=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Et=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, load_metric
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),C=new jl({props:{$$slots:{default:[wr]},$$scope:{ctx:f}}}),St=new j({props:{title:"Debug degli errori silenziosi durante l’addestramento",local:"debug-degli-errori-silenziosi-durante-laddestramento",headingTag:"h2"}}),Dt=new j({props:{title:"Controllare i dati (di nuovo!)",local:"controllare-i-dati-di-nuovo",headingTag:"h3"}}),Z=new jl({props:{warning:!0,$$slots:{default:[Ur]},$$scope:{ctx:f}}}),ll=new j({props:{title:"Fare overfitting del modello su un batch",local:"fare-overfitting-del-modello-su-un-batch",headingTag:"h3"}}),il=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),v=new jl({props:{$$slots:{default:[gr]},$$scope:{ctx:f}}}),rl=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),ol=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),I=new jl({props:{warning:!0,$$slots:{default:[$r]},$$scope:{ctx:f}}}),cl=new j({props:{title:"Non calibrare niente prima di avere una prima baseline",local:"non-calibrare-niente-prima-di-avere-una-prima-baseline",headingTag:"h3"}}),Jl=new j({props:{title:"Chiedere aiuto",local:"chiedere-aiuto",headingTag:"h3"}}),fl=new Jr({props:{source:"https://github.com/huggingface/course/blob/main/chapters/it/chapter8/4.mdx"}}),{c(){J=n("meta"),T=s(),b=n("p"),h=s(),p(w.$$.fragment),gl=s(),p(k.$$.fragment),$l=s(),p(B.$$.fragment),Cl=s(),p(W.$$.fragment),Zl=s(),X=n("p"),X.innerHTML=gi,vl=s(),p(R.$$.fragment),Il=s(),p(z.$$.fragment),kl=s(),G=n("p"),G.innerHTML=$i,Bl=s(),V=n("p"),V.innerHTML=Ci,Wl=s(),_=n("p"),_.innerHTML=Zi,Xl=s(),p(Y.$$.fragment),Rl=s(),x=n("p"),x.textContent=vi,zl=s(),p(F.$$.fragment),Gl=s(),p(A.$$.fragment),Vl=s(),H=n("p"),H.innerHTML=Ii,_l=s(),Q=n("p"),Q.innerHTML=ki,Yl=s(),p(N.$$.fragment),xl=s(),p(E.$$.fragment),Fl=s(),q=n("p"),q.innerHTML=Bi,Al=s(),S=n("p"),S.innerHTML=Wi,Hl=s(),p(L.$$.fragment),Ql=s(),D=n("p"),D.textContent=Xi,Nl=s(),p(P.$$.fragment),El=s(),K=n("p"),K.textContent=Ri,ql=s(),p(O.$$.fragment),Sl=s(),ee=n("p"),ee.textContent=zi,Ll=s(),te=n("p"),te.textContent=Gi,Dl=s(),p(le.$$.fragment),Pl=s(),p(ae.$$.fragment),Kl=s(),se=n("p"),se.textContent=Vi,Ol=s(),p(ie.$$.fragment),ea=s(),p(ne.$$.fragment),ta=s(),re=n("p"),re.innerHTML=_i,la=s(),p(oe.$$.fragment),aa=s(),p(pe.$$.fragment),sa=s(),me=n("p"),me.innerHTML=Yi,ia=s(),ce=n("p"),ce.innerHTML=xi,na=s(),p(de.$$.fragment),ra=s(),p(ue.$$.fragment),oa=s(),Me=n("p"),Me.innerHTML=Fi,pa=s(),p(Je.$$.fragment),ma=s(),p(ye.$$.fragment),ca=s(),be=n("p"),be.textContent=Ai,da=s(),p(Te.$$.fragment),ua=s(),p(he.$$.fragment),Ma=s(),fe=n("p"),fe.innerHTML=Hi,Ja=s(),p(je.$$.fragment),ya=s(),p(we.$$.fragment),ba=s(),Ue=n("p"),Ue.innerHTML=Qi,Ta=s(),ge=n("p"),ge.innerHTML=Ni,ha=s(),p(U.$$.fragment),fa=s(),$e=n("p"),$e.textContent=Ei,ja=s(),Ce=n("p"),Ce.textContent=qi,wa=s(),p(Ze.$$.fragment),Ua=s(),ve=n("p"),ve.innerHTML=Si,ga=s(),p(Ie.$$.fragment),$a=s(),ke=n("p"),ke.innerHTML=Li,Ca=s(),p(Be.$$.fragment),Za=s(),We=n("p"),We.innerHTML=Di,va=s(),p(Xe.$$.fragment),Ia=s(),p(Re.$$.fragment),ka=s(),ze=n("p"),ze.innerHTML=Pi,Ba=s(),Ge=n("p"),Ge.innerHTML=Ki,Wa=s(),p(Ve.$$.fragment),Xa=s(),_e=n("p"),_e.textContent=Oi,Ra=s(),p(Ye.$$.fragment),za=s(),xe=n("p"),xe.textContent=en,Ga=s(),Fe=n("p"),Fe.textContent=tn,Va=s(),p(Ae.$$.fragment),_a=s(),He=n("p"),He.innerHTML=ln,Ya=s(),p(Qe.$$.fragment),xa=s(),Ne=n("p"),Ne.textContent=an,Fa=s(),Ee=n("p"),Ee.textContent=sn,Aa=s(),p(qe.$$.fragment),Ha=s(),Se=n("p"),Se.textContent=nn,Qa=s(),p(Le.$$.fragment),Na=s(),De=n("p"),De.innerHTML=rn,Ea=s(),Pe=n("p"),Pe.innerHTML=on,qa=s(),Ke=n("p"),Ke.textContent=pn,Sa=s(),Oe=n("p"),Oe.innerHTML=mn,La=s(),p(et.$$.fragment),Da=s(),p(tt.$$.fragment),Pa=s(),lt=n("p"),lt.innerHTML=cn,Ka=s(),p(at.$$.fragment),Oa=s(),p(st.$$.fragment),es=s(),it=n("p"),it.textContent=dn,ts=s(),p(nt.$$.fragment),ls=s(),rt=n("p"),rt.innerHTML=un,as=s(),p(ot.$$.fragment),ss=s(),pt=n("p"),pt.textContent=Mn,is=s(),p(mt.$$.fragment),ns=s(),ct=n("p"),ct.textContent=Jn,rs=s(),p(dt.$$.fragment),os=s(),ut=n("p"),ut.textContent=yn,ps=s(),Mt=n("p"),Mt.innerHTML=bn,ms=s(),p(Jt.$$.fragment),cs=s(),yt=n("p"),yt.textContent=Tn,ds=s(),bt=n("p"),bt.innerHTML=hn,us=s(),p(Tt.$$.fragment),Ms=s(),ht=n("p"),ht.innerHTML=fn,Js=s(),p(ft.$$.fragment),ys=s(),jt=n("p"),jt.innerHTML=jn,bs=s(),wt=n("p"),wt.textContent=wn,Ts=s(),p(g.$$.fragment),hs=s(),p(Ut.$$.fragment),fs=s(),gt=n("p"),gt.innerHTML=Un,js=s(),p($t.$$.fragment),ws=s(),p(Ct.$$.fragment),Us=s(),Zt=n("p"),Zt.textContent=gn,gs=s(),vt=n("p"),vt.innerHTML=$n,$s=s(),p(It.$$.fragment),Cs=s(),p(kt.$$.fragment),Zs=s(),p($.$$.fragment),vs=s(),Bt=n("p"),Bt.textContent=Cn,Is=s(),p(Wt.$$.fragment),ks=s(),Xt=n("p"),Xt.textContent=Zn,Bs=s(),p(Rt.$$.fragment),Ws=s(),zt=n("p"),zt.innerHTML=vn,Xs=s(),p(Gt.$$.fragment),Rs=s(),p(Vt.$$.fragment),zs=s(),_t=n("p"),_t.innerHTML=In,Gs=s(),p(Yt.$$.fragment),Vs=s(),p(xt.$$.fragment),_s=s(),Ft=n("p"),Ft.innerHTML=kn,Ys=s(),p(At.$$.fragment),xs=s(),p(Ht.$$.fragment),Fs=s(),Qt=n("p"),Qt.textContent=Bn,As=s(),Nt=n("p"),Nt.textContent=Wn,Hs=s(),p(Et.$$.fragment),Qs=s(),qt=n("p"),qt.textContent=Xn,Ns=s(),p(C.$$.fragment),Es=s(),p(St.$$.fragment),qs=s(),Lt=n("p"),Lt.textContent=Rn,Ss=s(),p(Dt.$$.fragment),Ls=s(),Pt=n("p"),Pt.textContent=zn,Ds=s(),Kt=n("ul"),Kt.innerHTML=Gn,Ps=s(),p(Z.$$.fragment),Ks=s(),Ot=n("p"),Ot.innerHTML=Vn,Os=s(),el=n("p"),el.textContent=_n,ei=s(),tl=n("p"),tl.textContent=Yn,ti=s(),p(ll.$$.fragment),li=s(),al=n("p"),al.innerHTML=xn,ai=s(),sl=n("p"),sl.innerHTML=Fn,si=s(),p(il.$$.fragment),ii=s(),p(v.$$.fragment),ni=s(),nl=n("p"),nl.innerHTML=An,ri=s(),p(rl.$$.fragment),oi=s(),p(ol.$$.fragment),pi=s(),pl=n("p"),pl.textContent=Hn,mi=s(),ml=n("p"),ml.textContent=Qn,ci=s(),p(I.$$.fragment),di=s(),p(cl.$$.fragment),ui=s(),dl=n("p"),dl.innerHTML=Nn,Mi=s(),ul=n("p"),ul.textContent=En,Ji=s(),Ml=n("p"),Ml.textContent=qn,yi=s(),p(Jl.$$.fragment),bi=s(),yl=n("p"),yl.innerHTML=Sn,Ti=s(),bl=n("p"),bl.textContent=Ln,hi=s(),Tl=n("ul"),Tl.innerHTML=Dn,fi=s(),hl=n("p"),hl.textContent=Pn,ji=s(),p(fl.$$.fragment),wi=s(),Ul=n("p"),this.h()},l(e){const t=dr("svelte-u9bgzb",document.head);J=r(t,"META",{name:!0,content:!0}),t.forEach(l),T=i(e),b=r(e,"P",{}),nr(b).forEach(l),h=i(e),m(w.$$.fragment,e),gl=i(e),m(k.$$.fragment,e),$l=i(e),m(B.$$.fragment,e),Cl=i(e),m(W.$$.fragment,e),Zl=i(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-oons04"&&(X.innerHTML=gi),vl=i(e),m(R.$$.fragment,e),Il=i(e),m(z.$$.fragment,e),kl=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-yuehgd"&&(G.innerHTML=$i),Bl=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1vfby3"&&(V.innerHTML=Ci),Wl=i(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-n2uzsr"&&(_.innerHTML=Zi),Xl=i(e),m(Y.$$.fragment,e),Rl=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1142yq6"&&(x.textContent=vi),zl=i(e),m(F.$$.fragment,e),Gl=i(e),m(A.$$.fragment,e),Vl=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-d33wq2"&&(H.innerHTML=Ii),_l=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-135ov84"&&(Q.innerHTML=ki),Yl=i(e),m(N.$$.fragment,e),xl=i(e),m(E.$$.fragment,e),Fl=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-cqtrap"&&(q.innerHTML=Bi),Al=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1u5e5w1"&&(S.innerHTML=Wi),Hl=i(e),m(L.$$.fragment,e),Ql=i(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1f2dpvs"&&(D.textContent=Xi),Nl=i(e),m(P.$$.fragment,e),El=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-10dlgl9"&&(K.textContent=Ri),ql=i(e),m(O.$$.fragment,e),Sl=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1smbcnr"&&(ee.textContent=zi),Ll=i(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1qi5643"&&(te.textContent=Gi),Dl=i(e),m(le.$$.fragment,e),Pl=i(e),m(ae.$$.fragment,e),Kl=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-2lxf0o"&&(se.textContent=Vi),Ol=i(e),m(ie.$$.fragment,e),ea=i(e),m(ne.$$.fragment,e),ta=i(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-p2ursw"&&(re.innerHTML=_i),la=i(e),m(oe.$$.fragment,e),aa=i(e),m(pe.$$.fragment,e),sa=i(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-v4xkk"&&(me.innerHTML=Yi),ia=i(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1104rpz"&&(ce.innerHTML=xi),na=i(e),m(de.$$.fragment,e),ra=i(e),m(ue.$$.fragment,e),oa=i(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-16pihx1"&&(Me.innerHTML=Fi),pa=i(e),m(Je.$$.fragment,e),ma=i(e),m(ye.$$.fragment,e),ca=i(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1cfu9nl"&&(be.textContent=Ai),da=i(e),m(Te.$$.fragment,e),ua=i(e),m(he.$$.fragment,e),Ma=i(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-12oyv9w"&&(fe.innerHTML=Hi),Ja=i(e),m(je.$$.fragment,e),ya=i(e),m(we.$$.fragment,e),ba=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1ph2bbc"&&(Ue.innerHTML=Qi),Ta=i(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-io8wo7"&&(ge.innerHTML=Ni),ha=i(e),m(U.$$.fragment,e),fa=i(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1f8l9un"&&($e.textContent=Ei),ja=i(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1wcpo2k"&&(Ce.textContent=qi),wa=i(e),m(Ze.$$.fragment,e),Ua=i(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1qbf1v6"&&(ve.innerHTML=Si),ga=i(e),m(Ie.$$.fragment,e),$a=i(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-cm85vj"&&(ke.innerHTML=Li),Ca=i(e),m(Be.$$.fragment,e),Za=i(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1wuui5u"&&(We.innerHTML=Di),va=i(e),m(Xe.$$.fragment,e),Ia=i(e),m(Re.$$.fragment,e),ka=i(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-dg70m6"&&(ze.innerHTML=Pi),Ba=i(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1azvl87"&&(Ge.innerHTML=Ki),Wa=i(e),m(Ve.$$.fragment,e),Xa=i(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-o804dd"&&(_e.textContent=Oi),Ra=i(e),m(Ye.$$.fragment,e),za=i(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-11eb86j"&&(xe.textContent=en),Ga=i(e),Fe=r(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-c3yr03"&&(Fe.textContent=tn),Va=i(e),m(Ae.$$.fragment,e),_a=i(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-10f6kik"&&(He.innerHTML=ln),Ya=i(e),m(Qe.$$.fragment,e),xa=i(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1qy836m"&&(Ne.textContent=an),Fa=i(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1jxb9re"&&(Ee.textContent=sn),Aa=i(e),m(qe.$$.fragment,e),Ha=i(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1jo2f0k"&&(Se.textContent=nn),Qa=i(e),m(Le.$$.fragment,e),Na=i(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1nf53su"&&(De.innerHTML=rn),Ea=i(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1m58vxq"&&(Pe.innerHTML=on),qa=i(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1l13w1c"&&(Ke.textContent=pn),Sa=i(e),Oe=r(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1o77zbp"&&(Oe.innerHTML=mn),La=i(e),m(et.$$.fragment,e),Da=i(e),m(tt.$$.fragment,e),Pa=i(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-7af71d"&&(lt.innerHTML=cn),Ka=i(e),m(at.$$.fragment,e),Oa=i(e),m(st.$$.fragment,e),es=i(e),it=r(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-r6vhnq"&&(it.textContent=dn),ts=i(e),m(nt.$$.fragment,e),ls=i(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-utmeky"&&(rt.innerHTML=un),as=i(e),m(ot.$$.fragment,e),ss=i(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-dq73ex"&&(pt.textContent=Mn),is=i(e),m(mt.$$.fragment,e),ns=i(e),ct=r(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-gwlw2w"&&(ct.textContent=Jn),rs=i(e),m(dt.$$.fragment,e),os=i(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-16nyvye"&&(ut.textContent=yn),ps=i(e),Mt=r(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-12vqrqe"&&(Mt.innerHTML=bn),ms=i(e),m(Jt.$$.fragment,e),cs=i(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-yiimkc"&&(yt.textContent=Tn),ds=i(e),bt=r(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-xg78hk"&&(bt.innerHTML=hn),us=i(e),m(Tt.$$.fragment,e),Ms=i(e),ht=r(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-7wvbov"&&(ht.innerHTML=fn),Js=i(e),m(ft.$$.fragment,e),ys=i(e),jt=r(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1xjgmfh"&&(jt.innerHTML=jn),bs=i(e),wt=r(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-z9hjuk"&&(wt.textContent=wn),Ts=i(e),m(g.$$.fragment,e),hs=i(e),m(Ut.$$.fragment,e),fs=i(e),gt=r(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-7dspo7"&&(gt.innerHTML=Un),js=i(e),m($t.$$.fragment,e),ws=i(e),m(Ct.$$.fragment,e),Us=i(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-103takw"&&(Zt.textContent=gn),gs=i(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-cpi9zs"&&(vt.innerHTML=$n),$s=i(e),m(It.$$.fragment,e),Cs=i(e),m(kt.$$.fragment,e),Zs=i(e),m($.$$.fragment,e),vs=i(e),Bt=r(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-18r78mm"&&(Bt.textContent=Cn),Is=i(e),m(Wt.$$.fragment,e),ks=i(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-12a6eh4"&&(Xt.textContent=Zn),Bs=i(e),m(Rt.$$.fragment,e),Ws=i(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1fz7k57"&&(zt.innerHTML=vn),Xs=i(e),m(Gt.$$.fragment,e),Rs=i(e),m(Vt.$$.fragment,e),zs=i(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-noq9wi"&&(_t.innerHTML=In),Gs=i(e),m(Yt.$$.fragment,e),Vs=i(e),m(xt.$$.fragment,e),_s=i(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1lqh3e1"&&(Ft.innerHTML=kn),Ys=i(e),m(At.$$.fragment,e),xs=i(e),m(Ht.$$.fragment,e),Fs=i(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-lt88y"&&(Qt.textContent=Bn),As=i(e),Nt=r(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1rw0eah"&&(Nt.textContent=Wn),Hs=i(e),m(Et.$$.fragment,e),Qs=i(e),qt=r(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1yq201f"&&(qt.textContent=Xn),Ns=i(e),m(C.$$.fragment,e),Es=i(e),m(St.$$.fragment,e),qs=i(e),Lt=r(e,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-r6p8wy"&&(Lt.textContent=Rn),Ss=i(e),m(Dt.$$.fragment,e),Ls=i(e),Pt=r(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-juxokd"&&(Pt.textContent=zn),Ds=i(e),Kt=r(e,"UL",{"data-svelte-h":!0}),o(Kt)!=="svelte-1ygrnog"&&(Kt.innerHTML=Gn),Ps=i(e),m(Z.$$.fragment,e),Ks=i(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-n5w149"&&(Ot.innerHTML=Vn),Os=i(e),el=r(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1dmtka"&&(el.textContent=_n),ei=i(e),tl=r(e,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-wddm9m"&&(tl.textContent=Yn),ti=i(e),m(ll.$$.fragment,e),li=i(e),al=r(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-x29dj2"&&(al.innerHTML=xn),ai=i(e),sl=r(e,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-d51vi8"&&(sl.innerHTML=Fn),si=i(e),m(il.$$.fragment,e),ii=i(e),m(v.$$.fragment,e),ni=i(e),nl=r(e,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-13qqe72"&&(nl.innerHTML=An),ri=i(e),m(rl.$$.fragment,e),oi=i(e),m(ol.$$.fragment,e),pi=i(e),pl=r(e,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-ugnqo2"&&(pl.textContent=Hn),mi=i(e),ml=r(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1luvbcs"&&(ml.textContent=Qn),ci=i(e),m(I.$$.fragment,e),di=i(e),m(cl.$$.fragment,e),ui=i(e),dl=r(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-gth42h"&&(dl.innerHTML=Nn),Mi=i(e),ul=r(e,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1ytlvoo"&&(ul.textContent=En),Ji=i(e),Ml=r(e,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-1q3oxbc"&&(Ml.textContent=qn),yi=i(e),m(Jl.$$.fragment,e),bi=i(e),yl=r(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-1824t5s"&&(yl.innerHTML=Sn),Ti=i(e),bl=r(e,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1guizfr"&&(bl.textContent=Ln),hi=i(e),Tl=r(e,"UL",{"data-svelte-h":!0}),o(Tl)!=="svelte-rloazi"&&(Tl.innerHTML=Dn),fi=i(e),hl=r(e,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-14oh3jw"&&(hl.textContent=Pn),ji=i(e),m(fl.$$.fragment,e),wi=i(e),Ul=r(e,"P",{}),nr(Ul).forEach(l),this.h()},h(){rr(J,"name","hf:doc:metadata"),rr(J,"content",Zr)},m(e,t){ur(document.head,J),a(e,T,t),a(e,b,t),a(e,h,t),c(w,e,t),a(e,gl,t),c(k,e,t),a(e,$l,t),c(B,e,t),a(e,Cl,t),c(W,e,t),a(e,Zl,t),a(e,X,t),a(e,vl,t),c(R,e,t),a(e,Il,t),c(z,e,t),a(e,kl,t),a(e,G,t),a(e,Bl,t),a(e,V,t),a(e,Wl,t),a(e,_,t),a(e,Xl,t),c(Y,e,t),a(e,Rl,t),a(e,x,t),a(e,zl,t),c(F,e,t),a(e,Gl,t),c(A,e,t),a(e,Vl,t),a(e,H,t),a(e,_l,t),a(e,Q,t),a(e,Yl,t),c(N,e,t),a(e,xl,t),c(E,e,t),a(e,Fl,t),a(e,q,t),a(e,Al,t),a(e,S,t),a(e,Hl,t),c(L,e,t),a(e,Ql,t),a(e,D,t),a(e,Nl,t),c(P,e,t),a(e,El,t),a(e,K,t),a(e,ql,t),c(O,e,t),a(e,Sl,t),a(e,ee,t),a(e,Ll,t),a(e,te,t),a(e,Dl,t),c(le,e,t),a(e,Pl,t),c(ae,e,t),a(e,Kl,t),a(e,se,t),a(e,Ol,t),c(ie,e,t),a(e,ea,t),c(ne,e,t),a(e,ta,t),a(e,re,t),a(e,la,t),c(oe,e,t),a(e,aa,t),c(pe,e,t),a(e,sa,t),a(e,me,t),a(e,ia,t),a(e,ce,t),a(e,na,t),c(de,e,t),a(e,ra,t),c(ue,e,t),a(e,oa,t),a(e,Me,t),a(e,pa,t),c(Je,e,t),a(e,ma,t),c(ye,e,t),a(e,ca,t),a(e,be,t),a(e,da,t),c(Te,e,t),a(e,ua,t),c(he,e,t),a(e,Ma,t),a(e,fe,t),a(e,Ja,t),c(je,e,t),a(e,ya,t),c(we,e,t),a(e,ba,t),a(e,Ue,t),a(e,Ta,t),a(e,ge,t),a(e,ha,t),c(U,e,t),a(e,fa,t),a(e,$e,t),a(e,ja,t),a(e,Ce,t),a(e,wa,t),c(Ze,e,t),a(e,Ua,t),a(e,ve,t),a(e,ga,t),c(Ie,e,t),a(e,$a,t),a(e,ke,t),a(e,Ca,t),c(Be,e,t),a(e,Za,t),a(e,We,t),a(e,va,t),c(Xe,e,t),a(e,Ia,t),c(Re,e,t),a(e,ka,t),a(e,ze,t),a(e,Ba,t),a(e,Ge,t),a(e,Wa,t),c(Ve,e,t),a(e,Xa,t),a(e,_e,t),a(e,Ra,t),c(Ye,e,t),a(e,za,t),a(e,xe,t),a(e,Ga,t),a(e,Fe,t),a(e,Va,t),c(Ae,e,t),a(e,_a,t),a(e,He,t),a(e,Ya,t),c(Qe,e,t),a(e,xa,t),a(e,Ne,t),a(e,Fa,t),a(e,Ee,t),a(e,Aa,t),c(qe,e,t),a(e,Ha,t),a(e,Se,t),a(e,Qa,t),c(Le,e,t),a(e,Na,t),a(e,De,t),a(e,Ea,t),a(e,Pe,t),a(e,qa,t),a(e,Ke,t),a(e,Sa,t),a(e,Oe,t),a(e,La,t),c(et,e,t),a(e,Da,t),c(tt,e,t),a(e,Pa,t),a(e,lt,t),a(e,Ka,t),c(at,e,t),a(e,Oa,t),c(st,e,t),a(e,es,t),a(e,it,t),a(e,ts,t),c(nt,e,t),a(e,ls,t),a(e,rt,t),a(e,as,t),c(ot,e,t),a(e,ss,t),a(e,pt,t),a(e,is,t),c(mt,e,t),a(e,ns,t),a(e,ct,t),a(e,rs,t),c(dt,e,t),a(e,os,t),a(e,ut,t),a(e,ps,t),a(e,Mt,t),a(e,ms,t),c(Jt,e,t),a(e,cs,t),a(e,yt,t),a(e,ds,t),a(e,bt,t),a(e,us,t),c(Tt,e,t),a(e,Ms,t),a(e,ht,t),a(e,Js,t),c(ft,e,t),a(e,ys,t),a(e,jt,t),a(e,bs,t),a(e,wt,t),a(e,Ts,t),c(g,e,t),a(e,hs,t),c(Ut,e,t),a(e,fs,t),a(e,gt,t),a(e,js,t),c($t,e,t),a(e,ws,t),c(Ct,e,t),a(e,Us,t),a(e,Zt,t),a(e,gs,t),a(e,vt,t),a(e,$s,t),c(It,e,t),a(e,Cs,t),c(kt,e,t),a(e,Zs,t),c($,e,t),a(e,vs,t),a(e,Bt,t),a(e,Is,t),c(Wt,e,t),a(e,ks,t),a(e,Xt,t),a(e,Bs,t),c(Rt,e,t),a(e,Ws,t),a(e,zt,t),a(e,Xs,t),c(Gt,e,t),a(e,Rs,t),c(Vt,e,t),a(e,zs,t),a(e,_t,t),a(e,Gs,t),c(Yt,e,t),a(e,Vs,t),c(xt,e,t),a(e,_s,t),a(e,Ft,t),a(e,Ys,t),c(At,e,t),a(e,xs,t),c(Ht,e,t),a(e,Fs,t),a(e,Qt,t),a(e,As,t),a(e,Nt,t),a(e,Hs,t),c(Et,e,t),a(e,Qs,t),a(e,qt,t),a(e,Ns,t),c(C,e,t),a(e,Es,t),c(St,e,t),a(e,qs,t),a(e,Lt,t),a(e,Ss,t),c(Dt,e,t),a(e,Ls,t),a(e,Pt,t),a(e,Ds,t),a(e,Kt,t),a(e,Ps,t),c(Z,e,t),a(e,Ks,t),a(e,Ot,t),a(e,Os,t),a(e,el,t),a(e,ei,t),a(e,tl,t),a(e,ti,t),c(ll,e,t),a(e,li,t),a(e,al,t),a(e,ai,t),a(e,sl,t),a(e,si,t),c(il,e,t),a(e,ii,t),c(v,e,t),a(e,ni,t),a(e,nl,t),a(e,ri,t),c(rl,e,t),a(e,oi,t),c(ol,e,t),a(e,pi,t),a(e,pl,t),a(e,mi,t),a(e,ml,t),a(e,ci,t),c(I,e,t),a(e,di,t),c(cl,e,t),a(e,ui,t),a(e,dl,t),a(e,Mi,t),a(e,ul,t),a(e,Ji,t),a(e,Ml,t),a(e,yi,t),c(Jl,e,t),a(e,bi,t),a(e,yl,t),a(e,Ti,t),a(e,bl,t),a(e,hi,t),a(e,Tl,t),a(e,fi,t),a(e,hl,t),a(e,ji,t),c(fl,e,t),a(e,wi,t),a(e,Ul,t),Ui=!0},p(e,[t]){const Kn={};t&1&&(Kn.fw=e[0]),w.$set(Kn);const On={};t&2&&(On.$$scope={dirty:t,ctx:e}),U.$set(On);const er={};t&2&&(er.$$scope={dirty:t,ctx:e}),g.$set(er);const tr={};t&2&&(tr.$$scope={dirty:t,ctx:e}),$.$set(tr);const lr={};t&2&&(lr.$$scope={dirty:t,ctx:e}),C.$set(lr);const ar={};t&2&&(ar.$$scope={dirty:t,ctx:e}),Z.$set(ar);const sr={};t&2&&(sr.$$scope={dirty:t,ctx:e}),v.$set(sr);const ir={};t&2&&(ir.$$scope={dirty:t,ctx:e}),I.$set(ir)},i(e){Ui||(d(w.$$.fragment,e),d(k.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(he.$$.fragment,e),d(je.$$.fragment,e),d(we.$$.fragment,e),d(U.$$.fragment,e),d(Ze.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(Re.$$.fragment,e),d(Ve.$$.fragment,e),d(Ye.$$.fragment,e),d(Ae.$$.fragment,e),d(Qe.$$.fragment,e),d(qe.$$.fragment,e),d(Le.$$.fragment,e),d(et.$$.fragment,e),d(tt.$$.fragment,e),d(at.$$.fragment,e),d(st.$$.fragment,e),d(nt.$$.fragment,e),d(ot.$$.fragment,e),d(mt.$$.fragment,e),d(dt.$$.fragment,e),d(Jt.$$.fragment,e),d(Tt.$$.fragment,e),d(ft.$$.fragment,e),d(g.$$.fragment,e),d(Ut.$$.fragment,e),d($t.$$.fragment,e),d(Ct.$$.fragment,e),d(It.$$.fragment,e),d(kt.$$.fragment,e),d($.$$.fragment,e),d(Wt.$$.fragment,e),d(Rt.$$.fragment,e),d(Gt.$$.fragment,e),d(Vt.$$.fragment,e),d(Yt.$$.fragment,e),d(xt.$$.fragment,e),d(At.$$.fragment,e),d(Ht.$$.fragment,e),d(Et.$$.fragment,e),d(C.$$.fragment,e),d(St.$$.fragment,e),d(Dt.$$.fragment,e),d(Z.$$.fragment,e),d(ll.$$.fragment,e),d(il.$$.fragment,e),d(v.$$.fragment,e),d(rl.$$.fragment,e),d(ol.$$.fragment,e),d(I.$$.fragment,e),d(cl.$$.fragment,e),d(Jl.$$.fragment,e),d(fl.$$.fragment,e),Ui=!0)},o(e){u(w.$$.fragment,e),u(k.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(he.$$.fragment,e),u(je.$$.fragment,e),u(we.$$.fragment,e),u(U.$$.fragment,e),u(Ze.$$.fragment,e),u(Ie.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ye.$$.fragment,e),u(Ae.$$.fragment,e),u(Qe.$$.fragment,e),u(qe.$$.fragment,e),u(Le.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(nt.$$.fragment,e),u(ot.$$.fragment,e),u(mt.$$.fragment,e),u(dt.$$.fragment,e),u(Jt.$$.fragment,e),u(Tt.$$.fragment,e),u(ft.$$.fragment,e),u(g.$$.fragment,e),u(Ut.$$.fragment,e),u($t.$$.fragment,e),u(Ct.$$.fragment,e),u(It.$$.fragment,e),u(kt.$$.fragment,e),u($.$$.fragment,e),u(Wt.$$.fragment,e),u(Rt.$$.fragment,e),u(Gt.$$.fragment,e),u(Vt.$$.fragment,e),u(Yt.$$.fragment,e),u(xt.$$.fragment,e),u(At.$$.fragment,e),u(Ht.$$.fragment,e),u(Et.$$.fragment,e),u(C.$$.fragment,e),u(St.$$.fragment,e),u(Dt.$$.fragment,e),u(Z.$$.fragment,e),u(ll.$$.fragment,e),u(il.$$.fragment,e),u(v.$$.fragment,e),u(rl.$$.fragment,e),u(ol.$$.fragment,e),u(I.$$.fragment,e),u(cl.$$.fragment,e),u(Jl.$$.fragment,e),u(fl.$$.fragment,e),Ui=!1},d(e){e&&(l(T),l(b),l(h),l(gl),l($l),l(Cl),l(Zl),l(X),l(vl),l(Il),l(kl),l(G),l(Bl),l(V),l(Wl),l(_),l(Xl),l(Rl),l(x),l(zl),l(Gl),l(Vl),l(H),l(_l),l(Q),l(Yl),l(xl),l(Fl),l(q),l(Al),l(S),l(Hl),l(Ql),l(D),l(Nl),l(El),l(K),l(ql),l(Sl),l(ee),l(Ll),l(te),l(Dl),l(Pl),l(Kl),l(se),l(Ol),l(ea),l(ta),l(re),l(la),l(aa),l(sa),l(me),l(ia),l(ce),l(na),l(ra),l(oa),l(Me),l(pa),l(ma),l(ca),l(be),l(da),l(ua),l(Ma),l(fe),l(Ja),l(ya),l(ba),l(Ue),l(Ta),l(ge),l(ha),l(fa),l($e),l(ja),l(Ce),l(wa),l(Ua),l(ve),l(ga),l($a),l(ke),l(Ca),l(Za),l(We),l(va),l(Ia),l(ka),l(ze),l(Ba),l(Ge),l(Wa),l(Xa),l(_e),l(Ra),l(za),l(xe),l(Ga),l(Fe),l(Va),l(_a),l(He),l(Ya),l(xa),l(Ne),l(Fa),l(Ee),l(Aa),l(Ha),l(Se),l(Qa),l(Na),l(De),l(Ea),l(Pe),l(qa),l(Ke),l(Sa),l(Oe),l(La),l(Da),l(Pa),l(lt),l(Ka),l(Oa),l(es),l(it),l(ts),l(ls),l(rt),l(as),l(ss),l(pt),l(is),l(ns),l(ct),l(rs),l(os),l(ut),l(ps),l(Mt),l(ms),l(cs),l(yt),l(ds),l(bt),l(us),l(Ms),l(ht),l(Js),l(ys),l(jt),l(bs),l(wt),l(Ts),l(hs),l(fs),l(gt),l(js),l(ws),l(Us),l(Zt),l(gs),l(vt),l($s),l(Cs),l(Zs),l(vs),l(Bt),l(Is),l(ks),l(Xt),l(Bs),l(Ws),l(zt),l(Xs),l(Rs),l(zs),l(_t),l(Gs),l(Vs),l(_s),l(Ft),l(Ys),l(xs),l(Fs),l(Qt),l(As),l(Nt),l(Hs),l(Qs),l(qt),l(Ns),l(Es),l(qs),l(Lt),l(Ss),l(Ls),l(Pt),l(Ds),l(Kt),l(Ps),l(Ks),l(Ot),l(Os),l(el),l(ei),l(tl),l(ti),l(li),l(al),l(ai),l(sl),l(si),l(ii),l(ni),l(nl),l(ri),l(oi),l(pi),l(pl),l(mi),l(ml),l(ci),l(di),l(ui),l(dl),l(Mi),l(ul),l(Ji),l(Ml),l(yi),l(bi),l(yl),l(Ti),l(bl),l(hi),l(Tl),l(fi),l(hl),l(ji),l(wi),l(Ul)),l(J),M(w,e),M(k,e),M(B,e),M(W,e),M(R,e),M(z,e),M(Y,e),M(F,e),M(A,e),M(N,e),M(E,e),M(L,e),M(P,e),M(O,e),M(le,e),M(ae,e),M(ie,e),M(ne,e),M(oe,e),M(pe,e),M(de,e),M(ue,e),M(Je,e),M(ye,e),M(Te,e),M(he,e),M(je,e),M(we,e),M(U,e),M(Ze,e),M(Ie,e),M(Be,e),M(Xe,e),M(Re,e),M(Ve,e),M(Ye,e),M(Ae,e),M(Qe,e),M(qe,e),M(Le,e),M(et,e),M(tt,e),M(at,e),M(st,e),M(nt,e),M(ot,e),M(mt,e),M(dt,e),M(Jt,e),M(Tt,e),M(ft,e),M(g,e),M(Ut,e),M($t,e),M(Ct,e),M(It,e),M(kt,e),M($,e),M(Wt,e),M(Rt,e),M(Gt,e),M(Vt,e),M(Yt,e),M(xt,e),M(At,e),M(Ht,e),M(Et,e),M(C,e),M(St,e),M(Dt,e),M(Z,e),M(ll,e),M(il,e),M(v,e),M(rl,e),M(ol,e),M(I,e),M(cl,e),M(Jl,e),M(fl,e)}}}const Zr='{"title":"Fare il debug della training pipeline","local":"fare-il-debug-della-training-pipeline","sections":[{"title":"Fare il debug della training pipeline","local":"fare-il-debug-della-training-pipeline","sections":[{"title":"Controlla i dati","local":"controlla-i-dati","sections":[],"depth":3},{"title":"Dai dataset ai dataloader","local":"dai-dataset-ai-dataloader","sections":[],"depth":3},{"title":"Passaggio attraverso il modello","local":"passaggio-attraverso-il-modello","sections":[],"depth":3},{"title":"Esecuzione di un passaggio di ottimizzazione","local":"esecuzione-di-un-passaggio-di-ottimizzazione","sections":[],"depth":3},{"title":"Come gestire gli errori out-of-memory di CUDA","local":"come-gestire-gli-errori-out-of-memory-di-cuda","sections":[],"depth":3},{"title":"Valutazione del modello","local":"valutazione-del-modello","sections":[],"depth":3}],"depth":2},{"title":"Debug degli errori silenziosi durante l’addestramento","local":"debug-degli-errori-silenziosi-durante-laddestramento","sections":[{"title":"Controllare i dati (di nuovo!)","local":"controllare-i-dati-di-nuovo","sections":[],"depth":3},{"title":"Fare overfitting del modello su un batch","local":"fare-overfitting-del-modello-su-un-batch","sections":[],"depth":3},{"title":"Non calibrare niente prima di avere una prima baseline","local":"non-calibrare-niente-prima-di-avere-una-prima-baseline","sections":[],"depth":3},{"title":"Chiedere aiuto","local":"chiedere-aiuto","sections":[],"depth":3}],"depth":2}],"depth":1}';function vr(f,J,T){let b="pt";return pr(()=>{const h=new URLSearchParams(window.location.search);T(0,b=h.get("fw")||"pt")}),[b]}class Vr extends mr{constructor(J){super(),cr(this,J,vr,Cr,or,{})}}export{Vr as component};
