# Quiz di fine capitolo

Testiamo cosa avete imparato in questo capitolo!

### 1. Il dataset `emotion` contiene messaggi Twitter etichettati con emozioni. Cercalo nel [Hub](https://huggingface.co/datasets) e leggi la carta del dataset. Quale di queste non fa parte delle sue emozioni di base?

<Question
	choices={[
		{
			text: "Joy (Gioia)",
			explain: "Prova ancora — questa emozione è contenuta nel dataset!"
		},
		{
			text: "Love (Amore)",
			explain: "Prova ancora — questa emozione è contenuta nel dataset!"
		},
		{
			text: "Confusion (Confusione)",
			explain: "Corretto! Confusion non è una della sei emozioni di base.",
            correct: true
		},
        {
			text: "Surprise (Sorpresa)",
			explain: "Sorpresa! Prova ancora!"
		}
	]}
/>

### 2. Cerca il dataset `ar_sarcasm` nel [Hub](https://huggingface.co/datasets). Quali compiti supporta?

<Question
	choices={[
		{
			text: "Sentiment classification (Classificazione dei sentimenti)",
			explain: "Corretto! Si capisce dai tag.",
            correct: true
		},
		{
			text: "Machine translation (Traduzione automatica)",
			explain: "Sbagliato — dai un'altra occhiata alla <a href='https://huggingface.co/datasets/ar_sarcasm'>dataset card</a>!"
		},
		{
			text: "Named entity recognition (Riconoscimento di entità con un nome)",
			explain: "Sbagliato — dai un'altra occhiata alla <a href='https://huggingface.co/datasets/ar_sarcasm'>dataset card</a>!"
		},
        {
			text: "Question answering (Risposte a domande)",
			explain: "Purtroppo non hai risposto correttamente. Prova ancora!"
		}
	]}
/>

### 3. Come deve essere preparata una coppia di frasi per essere processata dal modello BERT?

<Question
	choices={[
		{
			text: "Tokens_della_frase_1 [SEP] Tokens_della_frase_2",
			explain: "Un token speciale <code>[SEP]</code> è necessario per separare le due frasi, ma non è l'unica cosa!"
		},
		{
			text: "[CLS] Tokens_della_frase_1 Tokens_della_frase_2",
			explain: "Un token speciale <code>[CLS]</code> è necessario all'inizio, ma non è l'unica cosa!"
		},
		{
			text: "[CLS] Tokens_della_frase_1 [SEP] Tokens_della_frase_2 [SEP]",
			explain: "Corretto!",
            correct: true
		},
        {
			text: "[CLS] Tokens_della_frase_1 [SEP] Tokens_della_frase_2",
			explain: "Un token speciale <code>[CLS]</code> è necessario all'inizio e un token speciale <code>[SEP]</code> è necessario per separare le due frasi, ma non è l'unica cosa!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. Quali sono i benefici del metodo `Dataset.map()`?

<Question
	choices={[
		{
			text: "I risultati della funzione vengono conservati, così la ri-esecuzione del codice sarà rapidissima",
			explain: "Questo è sicuramente uno dei benefici di questo metodo! Ma non è l'unico...",
            correct: true
		},
		{
			text: "È possibile applicare multiprocessing per un'esecuzione più rapida rispetto all'applicazione seriale ad ogni elemento del dataset",
			explain: "Questo è sicuramente uno dei benefici di questo metodo! Ma non è l'unico...",
            correct: true
		},
		{
			text: "Non carica l'intero dataset in memoria, salvando i risultati appena ogni elemento è stato processato.",
			explain: "Questo è sicuramente uno dei benefici di questo metodo! Ma non è l'unico...",
            correct: true
		},
	]}
/>

### 5. Qual è il significato di padding dinamico (dynamic padding)?

<Question
	choices={[
		{
			text: "È quando si applica in ogni batch il padding fino alla lunghezza massima dell'intero dataset",
			explain: "Riguarda il padding per ogni batch, ma non fino alla lunghezza massima dell'intero dataset."
		},
		{
			text: "È quando si applica in ogni batch il padding fino alla lunghezza massima delle frasi in quella batch",
			explain: "Corretto! la parte \"dinamica\" viene dal fatto che la dimensione per ogni batch viene determinata al momento della creazione, e quindi le batch potrebbero avere dimensioni differenti.",
            correct: true
		},
		{
			text: "È quando si applica il padding agli input in modo che ogni frase abbia lo stesso numero di token della frase precedente nel dataset.",
			explain: "Sbagliato. In più non avrebbe senso considerare l'ordine del dataset dato che lo rimischiamo durante l'apprendimento."
		},
	]}
/>

### 6. Qual è lo scopo di una funzione di raccolta (collate function)?

<Question
	choices={[
		{
			text: "Di assicurarsi che tutte le sequenze nel dataset abbiano la stessa lunghezza.",
			explain: "Una funzione di raccolta gestisce solo batch individuali, non l'intero dataset. In più, si sta parlando di funzioni di raccolta in generale, e non specificatamente di <code>DataCollatorWithPadding</code>."
		},
		{
			text: "Di raccogliere tutti i campioni in una batch.",
			explain: "Corretto! Puoi passare la funzione di raccolta come argomento di un <code>DataLoader</code>. Noi abbiamo usato la funzione <code>DataCollatorWithPadding</code>, che applica padding a tutti gli elementi di una batch affinché abbiano la stessa lunghezza.",
            correct: true
		},
		{
			text: "Di preprocessare l'intero dataset",
			explain: "Quella sarebbe una funzione di preprocessing, non di raccolta."
		},
        {
			text: "Di troncare le sequenze nel dataset.",
			explain: "Una funzione di raccolta gestisce solo batch individuali, non l'intero dataset. Se siete interessati al troncamento, potete usare l'argomento <code>truncate</code> del <code>tokenizer</code>."
		}
	]}
/>

### 7. Cosa succede quando una classe di tipo `AutoModelForXxx` viene istanziata con un modello di linguaggio pre-addestrato (come `bert-base-uncased`) che corrisponde ad un compito differente rispetto a quello per cui era stato addestrato?

<Question
	choices={[
		{
			text: "Nulla, ma viene mostrato un avvertimento",
			explain: "L'avvertimento non è 'l'unica cosa!"
		},
		{
			text: "La testa del modello pre-addestrato viene scartata e una nuova testa, appropriata per il compito, viene inserita al suo posto",
			explain: "Corretto. Ad esempio, quando abbiamo usato <code>AutoModelForSequenceClassification</code> con <code>bert-base-uncased</code>, abbiamo ottenuto un avvertimento mentre il modello veniva istanziato. La testa pre-addestrata non viene usata per il compito di classificazione delle sequenze, ma viene scartata e una nuova testa viene istanziata con pesi casuali.",
            correct: true
		},
		{
			text: "La testa del modello pre-addestrato viene scartata",
			explain: "Deve succedere anche qualcos'altro. Prova ancora!"
		},
         	{
			text: "Nulla, dato che il modello può comunque essere affinato per un compito differente.",
			explain: "La testa del modello pre-addestrato non era stata addestrata per risolvere questo compito, quindi dovremmo scartarla!"
		}
	]}
/>

### 8. Qual è lo scopo di `TrainingArguments`?

<Question
	choices={[
		{
			text: "Contiene tutti gli iperparametri usati per l'addestramento e la valutazione con il <code>Trainer</code>.",
			explain: "Corretto!",
            correct: true
		},
		{
			text: "Specifica le dimensioni del modello.",
			explain: "Le dimensioni del modello sono definite dalla configurazione del modello, non dalla classe <code>TrainingArguments</code>."
		},
		{
			text: "Contiene soltanto gli iperparametri usati per la valutazione.",
			explain: "Nell'esempio, abbiamo specificato anche dove salvare il modello e i suoi checkpoint. Prova ancora!"
		},
        {
			text: "Contiene soltanto gli iperparametri usati per l'addestramento.",
			explain: "Nell'esempio, abbiamo usato anche una <code>evaluation_strategy</code> (stragia di valutazione). Prova ancora!"
		}
	]}
/>

### 9. Perché si dovrebbe usare la libreria 🤗 Accelerate?

<Question
	choices={[
		{
			text: "Fornisce l'accesso a modelli più veloci.",
			explain: "No, la libreria 🤗 Accelerate non fornisce l'accesso ad alcun modello"
		},
		{
			text: "Fornisce una API di alto livello, così non devo implementare il mio ciclo di addestramento.",
			explain: "Questa è la funzionalità del <code>Trainer</code>, non della libreria 🤗 Accelerate. Prova ancora!"
		},
		{
			text: "Permette ai nostri cicli di addestramento di venire eseguiti con strategie distribuite.",
			explain: "Corretto! Con 🤗 Accelerate, i tuoi cicli di addestramento funzioneranno con svariate GPU e TPU.",
            correct: true
		},
        {
			text: "Fornisce altre funzioni di ottimizzazione.",
			explain: "No, la libreria 🤗 Accelerate library non fornisce alcuna funzione di ottimizzazione."
		}
	]}
/>

{:else}
### 4. Cosa succede quando una classe di tipo `TFAutoModelForXxx` viene istanziata con un modello di linguaggio pre-addestrato (come `bert-base-uncased`) che corrisponde ad un compito differente rispetto a quello per cui era stato addestrato?

<Question
	choices={[
		{
			text: "Nulla, ma viene mostrato un avvertimento",
			explain: "L'avvertimento non è l'unica cosa!"
		},
		{
			text: "La testa del modello pre-addestrato viene scartata e una nuova testa, appropriata per il compito, viene inserita al suo posto",
			explain: "Corretto. Ad esempio, quando abbiamo usato <code>TFAutoModelForSequenceClassification</code> con <code>bert-base-uncased</code>, abbiamo ottenuto un avvertimento mentre il modello veniva istanziato. La testa pre-addestrata non viene usata per il compito di classificazione delle sequenze, ma viene scartata e una nuova testa viene istanziata con pesi casuali.",
            correct: true
		},
		{
			text: "La testa del modello pre-addestrato viene scartata",
			explain: "Deve succedere anche qualcos'altro. Prova ancora!"
		},
        {
			text: "Nulla, dato che il modello può comunque essere affinato per un compito differente.",
			explain: "La testa del modello pre-addestrato non era stata addestrata per risolvere questo compito, quindi dovremmo scartarla!"
		}
	]}
/>

### 5. I modelli Tensorflow da `transformers` sono già dei modelli Keras. Quali benefici offre ciò?

<Question
	choices={[
		{
			text: "I modelli funzionano automaticamente su una TPU.",
			explain: "Quasi! Sono richiesti alcuni cambiamenti. Ad esempio, bisogna eseguire tutto all'interno di uno scope <code>TPUStrategy</code>, incluso l'inizializzazione del modello"
		},
		{
			text: "Si possono sfruttare metodi già esistenti quali <code>compile()</code>, <code>fit()</code>, e <code>predict()</code>.",
			explain: "Correto! Una volta ottenuti i dati, l'addestramento richiede molto poco sforzo.",
            correct: true
		},
		{
			text: "Puoi imparare Keras in aggiunta ai transformers.",
			explain: "Corretto, anche se cercavamo qualcosa in pù :)",
			correct: true
		},
        {
			text: "Si possono calcolare facilmente delle metriche relative al dataset",
			explain: "Keras è d'aiuto nell'addestramento e valutazione del modello, non nel calcolare metriche relative al dataset."
		}
	]}
/>

### 6. Come si definisce una metrica personalizzata (custom metric)?

<Question
	choices={[
		{
			text: "Creando una sottoclasse di <code>tf.keras.metrics.Metric</code>.",
			explain: "Ottimo!",
			correct: true
		},
		{
			text: "Usando l'API funzionale di Keras",
			explain: "Prova ancora!"
		},
		{
			text: "Utilizzando una funzione con segnatura <code>metric_fn(y_true, y_pred)</code>.",
			explain: "Corretto!",
			correct: true
		},
        {
			text: "Chiedendo a Google",
			explain: "Non è la risposta che cercavamo, ma dovrebbe comunque aiutarvi a risolvere il problema.",
			correct: true
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter3/6.mdx" />