# L'Hub di Hugging Face

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

L'Hub di Hugging Face -- il nostro sito web principale -- è la piattaforma che permette a chiunque di scoprire, utilizzare, e proporre nuovi modelli e dataset. Contiene una vasta varietà di modelli, con più di 10.000 modelli pubblicamente disponibili. In questo capitolo ci concentreremo sui modelli, mentre approfondiremo i dataset nel capitolo 5.

I modelli disponibili nell'Hub non sono limitati ai 🤗 Transformers, o ai modelli di analisi del linguaggio naturale (Natural Language Processing - NLP). Ci sono infatti modelli sviluppati da [Flair](https://github.com/flairNLP/flair) e [AllenNLP](https://github.com/allenai/allennlp) per l'NLP, ma anche modelli di [Asteroid](https://github.com/asteroid-team/asteroid) e [pyannote](https://github.com/pyannote/pyannote-audio) per la fonologia, e [timm](https://github.com/rwightman/pytorch-image-models) per l'analisi di immagini.

Ognuno di questi modelli è disponibile come un repository Git, che permette di tracciarne le versioni e rendere reproducibili i risultati. Condividere un modello nell'Hub significa renderlo accessibile a tutta la comunità e consentire a chiunque di usarlo facilmente. Questo evita la necessità di addestrare un modello da soli e ne semplifica la diffusione e l'uso.

In aggiunta, condividere un modello nell'Hub automaticamente pubblica una interfaccia programmatica (Application Programming Interface - API) di inferenza per quel modello. Qualsiasi utente della comunità può quindi provare il modello direttamente dalla sua pagina web con input personalizzati attraverso una interfaccia dedicata.

La parte migliore è che condividere e usare qualsiasi modello pubblico nell'Hub è completamente gratuito! Esistono anche dei [piani a pagamento](https://huggingface.co/pricing) se si desidera condividere i modelli in maniera privata.

Il video sottostante mostra come navigare l'Hub.

<Youtube id="XvSGPZFEjDY"/>

Avere un account huggingface.co è necessario per seguire questo capitolo, poiché creeremo e gestiremo dei repository sull'Hub di Hugging Face: [crea un account](https://huggingface.co/join)

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter4/1.mdx" />