# Generare un cartellino del modello

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Il cartellino del modello (model card) è un file di importanza pari ai file del modello e del tokenizer in un repository. Contiene la definizione del modello, assicurando la possibilità di riutilizzarlo e riprodurre i risultati da parte dei membri della comunità, e facendo si che il modello sia una piattaforma su cui gli altri membri possono costruire i loro artefatti.

Documentare il processo di addestramento e valutazione aiuta gli altri a capire cosa aspettarsi dal modello — inoltre, fornire informazioni accurate sui dati utilizzati e sulle operazioni di pre e post elaborazione (preprocessing e postprocessing), assicura che si possano identificare e comprenere le limitazioni, i bias, e i contesti in cui il modello è utile, e quelli in cui non lo è.

Per questo creare un cartellino del modello che descriva chiaramente il modello, è un passo estremamente importante. Qui, forniamo alcuni suggerimenti per farlo. Il cartellino del modello viene creato tramite il file *README.md*, visto in precedenza, che è un file Markdown.

Il concetto del cartellino trae origine dalla ricerca svolta a Google, e pubblicata per la prima volta nell'articolo ["Model Cards for Model Reporting"](https://arxiv.org/abs/1810.03993) di Margaret Mitchell et al. Molte informazioni contenute qui sono basate su quell'artictolo, e raccomandiamo a tutti di leggerlo per capire l'importanza del cartellino del modello in un mondo che valorizza la reproduzione, la riutilizzabilità e l'equità.

Il cartellino solitamente inizia con una breve introduzione, che descrive ad alto livello per quale scopo il modello è stato creato, ed è seguita da informazioni aggiuntive nelle sezioni seguenti:

- Descrizione del modello
- Usi previsti e limitazioni
- Istruzioni d'uso
- Limitazioni e bias
- Dati di addestramento
- Procedura di addestramento
- Risultati della valutazione

Approfondiamo ora i contenuti di ciascuna sezione.

### Descrizione del modello

La descrizione del modello fornisce i dettagli di base. Questi includono l'architettura, la versione, informazioni sull'articolo scientifico in cui il modello è stato presentato (se disponibile), se sia disponibile una implementazione originale, l'autore, ed altre informazioni di carattere generale. Qualsiasi copyright deve essere attribuito qui. Informazioni generali sulle procedure di addestramento, i parametri, ed anche dichiarazioni di non responsabilità possono essere inserite in questa sezione.

### Usi previsti e limitazioni

In questa sezione vengono descritti gli utilizzi per cui il modello è inteso, inclusi i linguaggi e i domini di applicazione del modello. Questa sezione del cartellino puó anche descrivere situazioni che sono fuori dall'ambito previsto del modello, o dove é probabile che il modello non funzioni in maniera ottimale.

### Istruzioni d'uso

Questa sezione dovrebbe includere alcuni esempi che mostrino come usare il modello. Questi esempi possono includere l'utilizzo attraverso la funzione `pipeline()`, l'utilizzo delle classi modello e tokenizer, e qualsiasi altro esempio di codice che possa essere utile. 

### Dati di addestramento

Questa parte dovrebbe indicare su quali dataset il modello è stato addestrato. È anche consigliabile aggiungere una breve descrizione dei dataset.

### Procedura di addestramento

In questa sezione dovreste descrivere tutti i dettagli del processo di addestramento rilevanti dal punto di vista della riproducibilitá. 

### Variabili e metriche di valutazione

In questa sezione é opportuno descrivere le metriche utilizzate per la valutazione e differenti fattori che vengono misurati. Riportare quali metriche ssono state usate, e su quali dataset e relative partizioni (dataset split), rende facile comparare le performance del proprio modello con gli altri. Le informazioni in questa sezione dovrebbero coprire i casi d'uso riportati nelle sezioni precedenti.

### Risultati della valutazione

Per finire, si dovrebbero riportare i risultati della valutazione di come si comporta il modello sul dataset di valutazione. Se il modello utilizza una soglia di decisione (decision threshold), è opportuno riportare o la soglia di decisione utilizzata nella fase di valutazione, o riportare i risultati per differenti soglie di decisione per gli usi previsti. 

## Esempio

Consigliamo di guardare i seguenti esempi di cartellini ben curati:

- [`bert-base-cased`](https://huggingface.co/bert-base-cased)
- [`gpt2`](https://huggingface.co/gpt2)
- [`distilbert`](https://huggingface.co/distilbert-base-uncased)

Esempi aggiuntivi, da parte di altre organizzazioni e compagnie, sono disponibili [qui](https://github.com/huggingface/model_card/blob/master/examples.md).

## Nota

Includere il cartellino del modello non è un requisito obbligatorio durante la pubblicazione di un modello, e inoltre non è necessario includere tutte le sezioni elencate in precedenza quando si crea un cartellino. Tuttavia, una documentazione esplicita del modello può solo portare benefici agli utilizzatori futuri, e per questo raccomandiamo di compilare quante più sezioni possibili, al meglio delle proprie conoscenze e capacità.

## Metadati del cartellino del modello

Se avete esplorato l'Hugging Face Hub, potreste aver notato che alcuni modelli appartengono a determinate categorie: è possibile filtrarli per task, lingue, librerie, ecc. Le categorie a cui appartiene un modello sono identificate in base ai metadati aggiunti nell'intestazione (header) del cartellino.

Prendendo ad esempio [il cartellino di `camembert-base`](https://huggingface.co/camembert-base/blob/main/README.md), dovreste vedere le seguenti righe nell'intestazione del cartellino:

```
---
language: fr
license: mit
datasets:
- oscar
---
```

This metadata is parsed by the Hugging Face Hub, which then identifies this model as being a French model, with an MIT license, trained on the Oscar dataset. 
Questi metadati vengono elaborati dall'Hub di Hugging Face, che identifica questo modello come un modello Francese, con una licenza MIT, addestrato sul dataset Oscar.

La [specifica completa dei cartellini](https://github.com/huggingface/hub-docs/blame/main/modelcard.md) permette di riportare lingue, license, tags, datasets, metriche di valutazione, e anche i risultati della valutazione del modello ottenuti durante l'addestramento.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter4/4.mdx" />