# Asking for help on the forums

<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

Il [forum di Hugging Face](https://discuss.huggingface.co) è un posto ideale per ricevere aiuto dal team open source e dalla più ampia community di Hugging Face. Ecco come appare la pagina principale in un dato giorno:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="The Hugging Face forums." width="100%"/>
</div>

Sul lato sinistro si possono vedere tutte le categorie in cui sono raggruppati i vari _topic_, mentre il lato destro mostra i _topic_ più recenti. Un _topic_ è un post che contiene un titolo, una categoria e una descrizione; è abbastanza simile al formato degli _issues_ di GitHub che abbiamo visto quando abbiamo creato il nostro dataset nel [Capitolo 5](/course/chapter5). Come suggerisce il nome, la categoria [Beginners](https://discuss.huggingface.co/c/beginners/5) è diretta principalmente alle persone che iniziano a lavorare con le librerie e l'ecosistema di Hugging Face. Tutte le domande sulle librerie sono benvenute qui, sia che siano per fare debug di codice sia che siano per chiedere aiuto su come fare qualcosa. (Detto questo, se la domanda riguarda una libreria in particolare, è meglio rivolgersi alla categoria corrispondente del forum).

Allo stesso modo, le categorie [Intermediate](https://discuss.huggingface.co/c/intermediate/6) e [Research](https://discuss.huggingface.co/c/research/7) sono per domande più avanzate, ad esempio sulle librerie o su novità nel campo della ricerca del NLP, di cui si vuole discutere.

E naturalmente va menzionata anche la categoria [Course](https://discuss.huggingface.co/c/course/20), dove potrai porre tutte le tue domande relative al corso Hugging Face!

Una volta selezionata la categoria, sarai pronto/a a scrivere il tuo primo _topic_. Nel forum troverai alcune [linee guida](https://discuss.huggingface.co/t/how-to-request-support/3128) su come farlo, e in questa sezione daremo un'occhiata ad alcune delle caratteristiche che contraddistinguono un buon _topic_.

## Scrivere un post nel forum correttamente

Come esempio, supponiamo di voler generare embeddings da articoli di Wikipedia per creare un motore di ricerca personalizzato. Come al solito, carichiamo il tokenizer e il modello come segue:

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

Ora supponiamo di provare a creare embeddings per un'intera sezione dell'[articolo di Wikipedia](https://en.wikipedia.org/wiki/Transformers) sui Transformers (il franchise, non la libreria!):

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

Oh-oh, abbiamo un problema -- e il messaggio di errore è molto più criptico di quelli visti nella [sezione 2](/course/chapter8/section2)! Non riusciamo a capire il traceback completo, quindi decidiamo di rivolgerci ai forum di Hugging Face per chiedere aiuto. Come potremmo creare il _topic_?

Per iniziare, dobbiamo cliccare sul pulsante "New Topic" nell'angolo in alto a destra (nota che per creare un _topic_ è necessario aver effettuato il login):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Creating a new forum topic." width="100%"/>
</div>

Si apre un'interfaccia di scrittura in cui è possibile inserire il titolo dell'argomento, selezionare una categoria e abbozzare il contenuto:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="The interface for creating a forum topic." width="100%"/>
</div>

Poiché l'errore sembra riguardare esclusivamente 🤗 Transformers, selezioneremo questa categoria. Il nostro primo tentativo di spiegare il problema potrebbe essere simile a questo:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Drafting the content for a new forum topic." width="100%"/>
</div>

Sebbene questo _topic_ contenga il messaggio di errore per il quale abbiamo bisogno di aiuto, ci sono alcuni problemi nel modo in cui è scritto:

1. Il titolo non è molto descrittivo, quindi chiunque navighi nel forum non sarà in grado di capire di cosa si tratta senza leggere anche il testo completo del _topic_.
2. Il corpo del testo non fornisce abbastanza informazioni su _da dove_ proviene l'errore e _come_ riprodurlo.
3. Nel _topic_ alcune persone sono taggate direttamente con un tono un po' esigente.

_Topic_ come questo non riceveranno probabilmente una risposta rapida (se la otterranno), quindi cerchiamo di capire come possiamo migliorarli. Cominciamo con il primo problema: la scelta di un buon titolo.

### Scegliere un titolo descrittivo

Se si sta cercando di ottenere aiuto per un bug nel codice, una buona regola è quella di includere abbastanza informazioni nel titolo, in modo che gli altri possano determinare rapidamente se pensano di poter rispondere alla domanda o meno. Nel nostro esempio, conosciamo il nome dell'eccezione che viene sollevata e abbiamo qualche indizio sul fatto che viene attivata nel _forward pass_ del modello, dove chiamiamo `model(**inputs)`. Per comunicare tutto ciò, un possibile titolo potrebbe essere:

> Source of IndexError in the AutoModel forward pass?

Questo titolo dice al lettore _da dove_ si pensa che provenga il bug e, se ha già incontrato un `IndexError`, è molto probabile che sappia come risolverlo. Naturalmente, il titolo può essere qualsiasi cosa si voglia, e altre varianti come:

> Why does my model produce an IndexError?

potrebbe anche andare bene. Ora che abbiamo un titolo descrittivo, vediamo di migliorare il corpo del testo.

### Formattare gli snippet di codice

Leggere il codice sorgente è già abbastanza difficile in un IDE, ma lo è ancora di più quando il codice viene copiato e incollato come testo normale! Fortunatamente, i forum di Hugging Face supportano l'uso di Markdown, quindi dovresti sempre racchiudere i vostri blocchi di codice con tre backtick (```) in modo da renderli più facilmente leggibili. Facciamo così per abbellire il messaggio di errore e, già che ci siamo, rendiamo il testo un po' più educato della nostra versione originale:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Our revised forum topic, with proper code formatting." width="100%"/>
</div>

Come si può vedere nello screeshot, racchiudendo i blocchi di codice tra i backtick si converte il testo grezzo in codice formattato, completo di colore! Si noti anche che i singoli backtick possono essere usati per formattare le variabili inline, come abbiamo fatto per `distilbert-base-uncased`. Questo _topic_ sembra molto migliorato e con un po' di fortuna potremmo trovare qualcuno nella community in grado di indovinare la causa dell'errore. Tuttavia, invece di affidarci alla fortuna, rendiamo la vita più facile includendo il traceback in tutti i suoi dettagli!

### Includere il traceback completo

Poiché l'ultima riga del traceback è spesso sufficiente per il debug del proprio codice, si può essere tentati di fornire solo quella nel proprio _topic_ per "risparmiare spazio". Anche se fatto con buone intenzioni, in realtà questo rende per gli altri il debug del problema _più difficile_, poiché anche le informazioni che si trovano più in alto nel traceback possono essere molto utili. Quindi, è buona pratica copiare e incollare l'_intero_ traceback, assicurandosi che sia ben formattato. Poiché questi traceback possono diventare piuttosto lunghi, alcuni preferiscono mostrarli dopo aver spiegato il codice sorgente. Facciamo così. Ora, il nostro _topic_ del forum ha questo aspetto:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Our example forum topic, with the complete traceback." width="100%"/>
</div>

Questo è molto più esplicativo e un lettore attento potrebbe notare che il problema sembra essere dovuto al passaggio di un input lungo, grazie a questa riga nel traceback:

> Token indices sequence length is longer than the specified maximum sequence length for this model (583 > 512).

Tuttavia, possiamo rendere le cose ancora più semplici fornendo il codice effettivo che ha generato l'errore. Facciamolo ora.

### Fornire un esempio riproducibile

Se hai mai provato a fare il debug del codice di qualcun altro, probabilmente hai prima cercato di ricreare il problema segnalato, in modo da poter iniziare a lavorare dal traceback per individuare l'errore. Non è diverso quando si tratta di ricevere (o dare) supporto sui forum, quindi è davvero utile poter fornire un piccolo esempio che riproduca l'errore. La metà delle volte, semplicemente facendo questo ti aiuterà a capire cosa non funziona. In ogni caso, il pezzo mancante del nostro esempio è mostrare gli _input_ che abbiamo fornito al modello. In questo modo si ottiene un esempio completo come il seguente:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="The final version of our forum topic." width="100%"/>
</div>

Questo _topic_ contiene ora molte informazioni ed è scritto in modo da attirare l'attenzione della community e ottenere una risposta utile. Con queste linee guida basilari, puoi ora creare ottimi _topic_ per trovare le risposte alle tue domande su 🤗 Transformers!



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter8/3.mdx" />