# Come scrivere un issue correttamente

<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter8/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter8/section5.ipynb"},
]} />

Quando si riscontra una cosa che non va in una delle librerie di Hugging Face, dovresti assolutamente farcelo sapere così possiamo correggerla (lo stesso vale per qualsiasi libreria open source, se è per questo). Se non si è del tutto sicuri se il bug risieda nel proprio codice o in una delle nostre librerie, il primo posto da controllare è il [forum](https://discuss.huggingface.co/). La community ti aiuterà a capirlo e anche il team di Hugging Face segue da vicino le discussioni.

<Youtube id="_PAli-V4wj0"/>

Quando si è sicuri di avere un bug tra le mani, il primo passo è creare un minimo esempio riproducibile.

## Creare un minimo esempio riproducibile

È molto importante isolare il pezzo di codice che produce il bug, poiché nessuno del team di Hugging Face è un mago (ancora) e non possono risolvere ciò che non vedono. Un minimo esempio riproducibile dovrebbe, come indica il nome, essere riproducibile. Ciò significa che non deve fare affidamento su file o dati esterni. Prova a sostituire i dati che stai usando con alcuni valori fittizi che assomigliano a quelli reali e producono lo stesso errore.

<Tip>

🚨 Molti issue presenti nel repository di 🤗 Transformers sono irrisolti perché i dati utilizzati per riprodurli non sono accessibili.

</Tip>

Una volta che si ha qualcosa di autocontenuto, si può cercare di ridurlo in un numero ancora minore di righe di codice, costruendo quello che chiamiamo un _minimo esempio riproducibile_. Sebbene questo richieda un po' più di lavoro da parte tua, se fornisci un breve e chiaro esempio di bug, avrai quasi la garanzia di ricevere aiuto e una correzione.

Se ti senti abbastanza a tuo agio, vai a ispezionare il codice sorgente in cui si verifica il tuo bug. Potresti trovare una soluzione al tuo problema (nel qual caso puoi anche fare una pull request per risolverlo), ma più in generale, questo può aiutare i maintainer a capire meglio il codice quando leggono la tua segnalazione.

## Compilare il template di un issue

Quando si segnala un problema, si noterà che c'è un template da compilare. Qui seguiremo quello per [🤗 Transformers issues](https://github.com/huggingface/transformers/issues/new/choose), ma lo stesso tipo di informazioni sarà richiesto se segnali un problema in un altro repository. Non lasciate il template in bianco: prendersi il tempo di compilarlo massimizzerà le possibilità di ottenere una risposta e di risolvere il problema.

In generale, quando si segnala un problema, bisogna sempre essere cortesi. Questo è un progetto open source, quindi state usando software libero e nessuno ha l'obbligo di aiutarvi. Si possono inserire nel problema critiche giustificate, ma i maintainer potrebbero prenderle male e non avere fretta di aiutarvi. Assicuratevi di leggere il [code of conduct](https://github.com/huggingface/transformers/blob/master/CODE_OF_CONDUCT.md) del progetto.

### Includere le informazioni sul tuo ambiente di sviluppo

🤗 Transformers fornisce un'utilità per ottenere tutte le informazioni necessarie sul tuo ambiente di sviluppo. Basta digitare quanto segue nel terminale:

```
transformers-cli env
```

e si dovrebbe ottenere qualcosa di simile:

```out
Copy-and-paste the text below in your GitHub issue and FILL OUT the two last points.

- `transformers` version: 4.12.0.dev0
- Platform: Linux-5.10.61-1-MANJARO-x86_64-with-arch-Manjaro-Linux
- Python version: 3.7.9
- PyTorch version (GPU?): 1.8.1+cu111 (True)
- Tensorflow version (GPU?): 2.5.0 (True)
- Flax version (CPU?/GPU?/TPU?): 0.3.4 (cpu)
- Jax version: 0.2.13
- JaxLib version: 0.1.65
- Using GPU in script?: <fill in>
- Using distributed or parallel set-up in script?: <fill in>
```

Si può anche aggiungere un `!` all'inizio del comando `transformers-cli env` per eseguirlo da una cella del notebook e poi copiare e incollare il risultato all'inizio dell'issue.

### Taggare persone 

Taggare le persone digitando una `@` seguita dal loro handle GitHub invierà loro una notifica, in modo che vedano il problema e possano rispondere più rapidamente. Usa questo metodo con moderazione, perché le persone che tagghi potrebbero non apprezzare di ricevere una notifica per qualcosa a cui non hanno un collegamento diretto. Se hai esaminato il codice sorgente relativo al tuo bug, dovresti taggare l'ultima persona che ha apportato modifiche alla riga che ritieni responsabile del tuo problema (puoi trovare questa informazione guardando la riga in questione su GitHub, selezionandola e facendo clic su "View git blame").

Altrimenti, il template offre suggerimenti sulle persone da taggare. In generale, non taggare mai più di tre persone!

### Includere un esempio riproducibile

Se sei riuscito a creare un esempio autocontenuto che produce il bug, è il momento di includerlo! Scrivi una riga con tre backtick seguiti da `python`, come questa:

```
```python
```

quindi incolla il tuo minimo esempio riproducibile e digita una nuova riga con tre backtick. In questo modo il codice sarà formattato correttamente.

Se non sei riuscito/a a creare un esempio riproducibile, spiega in modo chiaro come sei arrivato/a al tuo problema. Se possibile, includi un link al notebook di Google Colab in cui hai riscontrato l'errore. Più informazioni si condividono, più i maintainer saranno in grado di rispondere.

In ogni caso, è necessario copiare e incollare l'intero messaggio di errore ricevuto. Se lavori in Colab, ricorda che alcuni frame potrebbero essere automaticamente compressi nella stack trace, quindi assicurati di espanderli prima di copiarli. Come nel caso dell'esempio di codice, inserisci il messaggio di errore tra due righe con tre backtick, in modo che sia formattato correttamente.

###  Descrivere il funzionamento atteso

Spiega in poche righe cosa ti aspettavi di ottenere, in modo che i maintainer abbiano una visione completa del problema. Questa parte è generalmente abbastanza ovvia, quindi dovrebbe essere contenuta in una frase, ma in alcuni casi si può avere molto da dire.

## E poi?

Una volta inviato l'issue, assicurati di controllare rapidamente che tutto sia a posto. Puoi modificare l'issue se hai commesso un errore, o anche cambiare il titolo se ti rendi conto che il problema è diverso da quello che pensavi all'inizio.

È inutile sollecitare le persone se non si ottiene una risposta. Se nessuno ti aiuta in pochi giorni, è probabile che nessuno sia in grado di risolvere il tuo problema. Non esitare a rivedere l'esempio riproducibile. Puoi renderlo più breve e più dritto al punto? Se non ricevi una risposta entro una settimana, puoi aggiungere un messaggio in cui chiedi gentilmente aiuto, soprattutto se hai modificato il tuo problema per includere ulteriori informazioni sul problema.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter8/5.mdx" />