# Quiz di fine capitolo

<CourseFloatingBanner
    chapter={8}
    classNames="absolute z-10 right-0 top-0"
/>

Mettiamo alla prova quello che hai imparato in questo capitolo!

### 1. In quale ordine si deve leggere un traceback di Python?

<Question
	choices={[
		{
			text: "Dall'alto verso il basso",
			explain: "Riprova -- sebbene la maggior parte degli altri linguaggi di programmazione stampi gli errori in alto, Python è unico in questo senso."
		},
		{
			text: "Dal basso verso l'alto",
			explain: "Corretto! Un vantaggio dei traceback di Python, che mostrano l'errore in fondo, è che è più facile fare il debug quando si lavora nel terminale e questa è l'ultima riga che si vede.",
			correct: true
		}
	]}
/>

### 2. Che cos'è un minimo esempio riproducibile?

<Question
	choices={[
		{
			text: "Una semplice implementazione di un'architettura Transformer tratta da un articolo di ricerca",
			explain: "Anche se è molto formativo implementare i propri modelli Transformer da zero, non è di questo che stiamo parlando."
		},
		{
			text: "Un blocco di codice compatto e autocontenuto che può essere eseguito senza alcuna dipendenza esterna da file o dati privati",
			explain: "Corretto! Minimi esempi riproducibili aiutano i maintainers della libreria a riprodurre il problema che si sta verificando, in modo da trovare soluzioni più velocemente",
			correct: true
		},
		{
			text: "Uno screenshot della traceback di Python",
			explain: "Riprova -- anche se è allettante includere una schermata dell'errore che si sta riscontrando quando si invia un issue, questo rende molto difficile per gli altri riprodurre l'errore"
		},
		{
			text: "Un notebook che contiene la tua analisi intera, comprese le parti non correlate all'errore",
			explain: "Non proprio -- anche se può essere utile condividere un notebook di Google Colab che mostri l'errore, assicurati che sia breve e che contenga solo il codice rilevante"
		}
	]}
/>

### 3. Supponiamo di provare a eseguire il codice seguente, il quale produce un errore:

```py
from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
# ---------------------------------------------------------------------------
# ImportError                               Traceback (most recent call last)
# /var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_30848/333858878.py in <module>
# ----> 1 from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
```

Quale dei seguenti potrebbe essere una buona scelta per il titolo di un topic del forum per chiedere aiuto?

<Question
	choices={[
		{
			text: "<code>ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)</code>",
			explain: "Includere l'ultima riga del traceback può essere esplicativo, ma è meglio riservarlo al corpo principale del topic. Riprov!"
		},
		{
			text: "Problema con <code>from transformers import GPT3ForSequenceClassification</code>",
			explain: "Riprova -- sebbene questo fornisca informazioni utili, è probabilmente meglio riservarle al corpo principale del testo.",
		},
		{
			text: "Perché non posso importare  <code>GPT3ForSequenceClassification</code>?",
			explain: "Ottima scelta! Questo titolo è conciso e dà al lettore un indizio su ciò che potrebbe essere sbagliato (ad esempio, che il GPT-3 non è supportato nei 🤗 Transformers).",
			correct: true
		},
		{
			text: "GPT-3 è supportato in 🤗 Transformers?",
			explain: "Buona questa! Usare domande come titoli dei topic è un ottimo modo per comunicare il problema alla community.",
			correct: true
		}
	]}
/>

### 4. Supponiamo di aver provato a eseguire `trainer.train()` e di trovarci di fronte a un errore criptico che non ci dice esattamente da dove proviene. Quale dei seguenti è il primo posto in cui cercare gli errori nella training pipeline?

<Question
	choices={[
		{
			text: "La fase di ottimizzazione in cui si calcolano i gradienti e si esegue la backpropagation",
			explain: "Anche se potrebbero esserci dei bug nell'ottimizzatore, di solito si tratta di diverse fasi della training pipeline, quindi ci sono altre cose da controllare prima. Riprova!"
		},
		{
			text: "La fase di valutazione in cui si calcolano le metriche",
			explain: "La valutazione è di solito fatta dopo aver fatto training per un'intera epoch, quindi dovresti controllare in qualche punto della training pipeline precedente.",
		},
		{
			text: "I dataset",
			explain: "Corretto! Dare un'occhiata ai dati è quasi sempre la prima cosa da fare, per assicurarsi che il testo sia codificato correttamente, che abbia le dimensioni previste e così via.",
			correct: true
		},
		{
			text: "I dataloader",
			explain: "Prova ancora -- è molto vicino alla prima cosa che si dovrebbe controllare. Ti ricordi quale oggetto forniamo ai dataloader?"
		}
	]}
/>

### 5. Qual è il modo migliore per fare il debug di un errore CUDA?

<Question
	choices={[
		{
			text: "Pubblicare il messaggio di errore sul forum o su GitHub.",
			explain: "Questo non aiuterà nessuno, poiché i messaggi di errore di CUDA sono solitamente poco esplicativi."
		},
		{
			text: "Eseguire lo stesso codice sulla CPU.",
			explain: "Esattamente, questo dovrebbe darti un messaggio di errore migliore!",
			correct: true
		},
		{
			text: "Leggere il traceback per scoprire cosa ha causato l'errore.",
			explain: "È quello che si farebbe per qualsiasi altro errore, ma gli errori di CUDA di solito non vengono segnalati nel punto in cui si sono verificati, perché la maggior parte delle operazioni di CUDA sono asincrone."
		},
		{
			text: "Ridurre la dimensione del batch.",
			explain: "Ridurre la dimensione del batch è di solito una buona strategia per gestire gli errori out-of-memory di CUDA, ma non per questo particolare problema. Riprova!"
		},
		{
			text: "Riavviare il Jupyter kernel.",
			explain: "Riprova -- riavviare il kernel non farà scomparire magicamente l'errore!",
		}
	]}
/>

### 6. Qual è il modo migliore per far risolvere un problema su GitHub?

<Question
	choices={[
		{
			text: "Pubblicare un esempio completo e riproducibile del bug.",
			explain: "Sì, questo è il modo migliore per aiutare i maintainer a trovare il tuo bug. Cos'altro si dovrebbe fare?",
			correct: true
		},
		{
			text: "Chiedere un aggiornamento ogni giorno.",
			explain: "È improbabile che questo ti aiuti; probabilmente la gente ti ignorerà di più.",
		},
		{
			text: "Ispezionare il codice sorgente intorno al bug e cercare di trovare il motivo per cui si verifica. Pubblicare i risultati nel problema.",
			explain: "Questo aiuterà sicuramente i maintainer! E se si trova la fonte del bug e una soluzione, si può anche aprire una pull request. Cos'altro dovreste fare?",
			correct: true
		}
	]}
/>

### 7. Perché l'overfitting di un batch è di solito una buona tecnica di debugging?

<Question
	choices={[
		{
			text: "Non lo è; l'overfitting è sempre un male e va evitato.",
			explain: "Quando si fa l'addestramento sull'intero dataset, l'overfitting può essere un segno che il modello non generalizzerà bene a nuovi esempi. Per il debug, tuttavia, di solito non si addestra sull'intero dataset. Riprova!"
		},
		{
			text: "Ci permette di verificare che il modello sia in grado di ridurre la loss a zero.",
			explain: "Corretto! Con un piccolo batch di soli due esempi, possiamo verificare rapidamente se il modello è in grado di apprendere.",
			correct: true
		},
		{
			text: "Ci permette di verificare che le dimensioni dei tensori dei nostri input e delle nostre label siano corrette.",
			explain: "Prova ancora -- se le dimensioni dei tensori sono scorrette, non sarai certamente in grado di fare l'addestramento, nemmeno su un singolo batch.",
		}
	]}
/>

### 8. Perché è una buona idea includere dettagli sul proprio ambiente di sviluppo con `transformers-cli env` quando si crea un nuovo issue nel repo di 🤗 Transformers?

<Question
	choices={[
		{
			text: "Permette ai maintainer di capire quale versione della libreria si sta utilizzando.",
			explain: "Corretto! Poiché ogni versione principale della libreria può presentare modifiche all'API, sapere quale versione specifica si sta utilizzando può aiutare a circoscrivere il problema. Quali sono gli altri vantaggi?",
			correct: true
		},
		{
			text: "Permette ai maintainer di sapere se il codice viene eseguito su Windows, macOS o Linux.",
			explain: "Corretto! A volte gli errori possono essere causati dallo specifico sistema operativo in uso e saperlo aiuta i maintainer a riprodurli localmente. Ma non è il solo motivo.",
			correct: true
		},
		{
			text: "Permette ai maintainer di sapere se il codice viene eseguito su una GPU o su una CPU.",
			explain: "Corretto! Come abbiamo visto in questo capitolo, il codice eseguito su GPU o CPU può produrre risultati o errori diversi e sapere quale hardware si sta usando può aiutare a concentrare l'attenzione dei maintainer. Ma questo non è l'unico vantaggio...",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter8/7.mdx" />