# パート2公開記念イベント

パート2のコース公開後、Fine-tuningのスプリントの前に、2日間のトークライブイベントが開催されました。
詳細については以下のページから見ることが出来ます。


## 1日目: Transformersライブラリとその学習方法を俯瞰する

**Thomas Wolf:** *転移学習とTransformersライブラリの誕生*

<div class="flex justify-center">
<Youtube id="wCYVeahJES0"/>
</div>

<p align="center">
<img src="https://i.imgur.com/9eq8oUi.png" alt="Thomasによるトークの概要図" width="80%"/>
</p>

Thomas Wolfは、Hugging Faceの共同設立者であり、主任研究員です。
彼とHugging Faceチームが作成したツールは、Facebook人工知能研究所、Googleリサーチ、DeepMind、Amazonリサーチ、Apple、アレン人工知能研究所、および多くの大学を含む5,000以上の研究機関に使用されています。
Thomas Wolfは人工知能の分野における最大の研究機関の創始者であり、[BigScience](https://bigscience.huggingface.co)をはじめとする、世界で広く利用されている[ライブラリやツール](https://github.com/huggingface/)の開発者です。
加えて、人工知能と自然言語処理の分野におけるリーダーであり、世界中のカンファレンスに定期的に招待されるスピーカーです。[https://thomwolf.io](https://thomwolf.io).


**Jay Alammar:** *Transformersモデルの学習方法の可視化*

<div class="flex justify-center">
<Youtube id="VzvG23gmcYU"/>
</div>

<p align="center">
<img src="https://i.imgur.com/rOZAuE9.png" alt="Jayによるトークの概要図" width="80%"/>
</p>

Jay Alammarは機械学習ツールやコンセプトを基本的なもの（NumPyやPandasのドキュメント）から最先端のもの（Transformers、BERT、GPT-3）まで視覚的に理解できるようなブログを書いています。

**Margaret Mitchell:** *機械学習開発における価値観*

<div class="flex justify-center">
<Youtube id="8j9HRMjh_s8"/>
</div>

<p align="center">
<img src="https://i.imgur.com/NuIsnY3.png" alt="Margaretによるトークの概要図" width="80%"/>
</p>

Margaret Mitchellは、Ethical AIの研究者であり、現在、企業におけるAI開発の倫理的な観点に焦点をあてて研究しています。
彼女は自然言語生成、支援技術、コンピュータビジョン、およびAI倫理に関する50以上の論文を発表し、会話生成と感情分類の分野で複数の特許を保有しています。
以前はGoogle AIにリサーチサイエンティストとして勤務しており、Google&#39;s Ethical AIグループを設立、リーダーとしてAI倫理の基礎研究およびGoogle内部でのAI倫理の運用に注力していました。
Google入社以前は、Microsoft Researchで画像からの言語生成に焦点を当てた研究員、ジョンズ・ホプキンズ大学でベイズモデリングと情報抽出に焦点を当てたポスドクを務めていました。
アバディーン大学でコンピュータサイエンスの博士号を、ワシントン大学で計算言語学の修士号を取得しています。
学位を取得する傍ら、2005年から2012年まで、オレゴン健康科学大学で機械学習、神経障害、支援技術に関する研究に従事していました。
彼女は多様性やコンピュータサイエンス、倫理などの多くの分野でワークショップや活動を率先して行ってきました。
彼女の研究は、アッシュ・カーター国防長官や米国盲人財団から表彰され、複数のテクノロジー企業で導入されています。
ちなみに彼女はガーデニングと犬、猫が好きです。

**Matthew Watson and Chen Qian:** *Kerasによる自然言語処理のワークフロー*

<div class="flex justify-center">
<Youtube id="gZIP-_2XYMM"/>
</div>

<p align="center">
<img src="https://i.imgur.com/1vD2az8.png" alt="MatthewとChenによるトークの概要図" width="80%"/>
</p>

Matthew Watsonは、Kerasチームの機械学習エンジニアで、ハイレベルのモデリングAPIの開発を行っています。
スタンフォード大学でコンピュータグラフィックスを専攻し、修士号を取得しました。
彼はもともと英語を専攻していましたが、コンピュータサイエンスに転向ました。
分野を超えて仕事をし、より多くの人が自然言語処理にアクセスできるようにすることに情熱を傾けています。

Chen QianはKerasチームのソフトウェアエンジニアで、彼もハイレベルのモデリングAPIの開発を行っています。
スタンフォード大学で電気工学の修士号を取得しました。
機械学習タスクのコード実装の簡素化と大規模機械学習に特に興味を持っています。

**Mark Saroufim:** *Pytorchでモデルを学習させる方法*

<div class="flex justify-center">
<Youtube id="KmvPlW2cbIo"/>
</div>

<p align="center">
<img src="https://i.imgur.com/TPmlkm8.png" alt="Markによるトークの概要図" width="80%"/>
</p>

Mark SaroufimはPytorchのパートナーエンジニアで、TorchServeやPytorch Enterpriseを含むOSSの開発に携わっています。
以前はGraphcore、[yuri.ai](http://yuri.ai/)、Microsoft、NASAのジェット推進研究所で応用科学者、プロダクトマネージャーを務めていました。
プログラミングをもっと楽しくすることに情熱を注いでいます。


**Jakob Uszkoreit:** *壊れてないものは<del>直すな</del>壊そう*

<div class="flex justify-center">
<Youtube id="C6jweXYFHSA"/>
</div>

<p align="center">
<img src="https://i.imgur.com/5dWQeNB.png" alt="Jakobによるトークの概要図" width="80%"/>
</p>

Jakob Uszkoreitは、ディープラーニングを用いてワクチンや治療薬のためのRNA分子を設計している機関であるInceptiveの共同創設者です。
InceptiveはRNAベースの医薬品をより入手しやすく、より効果的で、より広く適用できるようにすることを目標にしています。
以前はGoogleに10年以上勤務し、Google Brain、 Research and Searchの研究開発チームを率いて、ディープラーニングの基礎、コンピュータビジョン、言語理解、機械翻訳に取り組んでいました。


## 2日目: 使用するツールの紹介

**Lewis Tunstall:** *🤗 TransformersのTrainerを使ったシンプルな学習*

<div class="flex justify-center">
<Youtube id="u--UVvH-LIQ"/>
</div>

Lewis TunstallはHugging Faceの機械学習エンジニアで、オープンソースのツールを開発し、より広いコミュニティで利用できるようにすることに注力しています。
また、オライリーの書籍[Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)の共著者でもあります。
Twitter (@_lewtun) では、自然言語処理に関するtipsを紹介しています.


**Matthew Carrigan:** *TensorFlowの新機能として追加された🤗 Transformersと🤗 Datasets*

<div class="flex justify-center">
<Youtube id="gQUlXp1691w"/>
</div>

Matthew CarriganはTransformersでTensorFlowのメンテナンスを担当しています。
彼はいずれTwitterアカウント@carrigmatを通じて、PyTorch派に対するTensorflow派のリーダーとなるでしょう。

**Lysandre Debut:** *機械学習プロジェクトのコラボレーションと共有の手段としてのHugging Face Hub*

<div class="flex justify-center">
<Youtube id="RBw1TmdEZp0"/>
</div>

<p align="center">
<img src="https://i.imgur.com/TarIPCz.png" alt="Lysandreによるトークの概要図" width="80%"/>
</p>

Lysandre DebutはHugging Faceの機械学習エンジニアで、多くのオープンソースプロジェクトに携わっています。
彼の目的は、非常にシンプルなAPIを持つ強力なツールを開発することで、機械学習を誰にでもアクセスできるようにすることです。

**Lucile Saulnier:** *🤗 Transformersと🤗 Tokenizersで自分だけのトークナイザーを手に入れる*

<div class="flex justify-center">
<Youtube id="UkNmyTFKriI"/>
</div>

Lucile SaulnierはHugging Faceの機械学習エンジニアで、オープンソースツールの開発および使用支援を行っています。
彼女は協調学習やBigScienceなど、自然言語処理分野の多くの研究プロジェクトにも積極的に参加しています。

**Sylvain Gugger:** *PyTorchの学習効率を高める🤗 Accelerate*

<div class="flex justify-center">
<Youtube id="t8Krzu-nSeY"/>
</div>

Sylvain GuggerはHugging Faceのリサーチエンジニアで、🤗 Transformersのコアメンテナーの一人であり、🤗 Accelerateの開発者でもあります。
彼はモデルの学習をより身近なものにすることが好きです。

**Merve Noyan:** *モデルのデモを展示する🤗 Spaces*

<div class="flex justify-center">
<Youtube id="vbaKOa4UXoM"/>
</div>

Merve NoyanはHugging FaceのDeveloper Advocateで、誰もが機械学習を使うことが出来るように、ツールの開発とその周辺のコンテンツ構築に取り組んでいます。


**Abubakar Abid:** *機械学習アプリケーションを素早く構築する*

<div class="flex justify-center">
<Youtube id="c7mle2yYpwQ"/>
</div>

<p align="center">
<img src="https://i.imgur.com/qWIFeiF.png" alt="Abubakarによるトークの概要図" width="80%"/>
</p>

Abubakar Abidは[Gradio](www.gradio.app)のCEOです。
2015年にMITで電気工学とコンピュータサイエンスの理学士号を取得し、2021年にスタンフォードで応用機械学習の博士号を取得しました。
Gradioでは機械学習モデルのデモ、デバッグ、デプロイを容易にすることに取り組んでいます。

**Mathieu Desvé:** *AWSの機械学習のビジョン: すべての顧客が機械学習にアクセスできるようにする*

<div class="flex justify-center">
<Youtube id="O2e3pXO4aRE"/>
</div>

<p align="center">
<img src="https://i.imgur.com/oLdZTKy.png" alt="Mathieuによるトークの概要図" width="80%"/>
</p>

Mathieu Desvéはテクノロジー好きで、暇さえあればものづくりをしています。
クライアントとユーザーの問題解決に取り組むことが好きで、日々学び続けています。
2004年以来、フロントエンド、バックエンド、インフラストラクチャー、オペレーション、マネジメントなど、さまざまなポジションを経験してきました。
技術的、経営的に共通する問題を機敏に解決することを心がけています。

**Philipp Schmid:** *Amazon SageMakerと🤗 Transformersを使った学習管理*

<div class="flex justify-center">
<Youtube id="yG6J2Zfo8iw"/>
</div>

Philipp Schmidは、Hugging Faceの機械学習エンジニア兼テックリードで、Amazon SageMakerチームとの協業をリードしています。
最先端の自然言語処理モデルを誰もが使えるように製品化し、ディープラーニングの使いやすさを向上することに情熱を注いでいます。


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/events/2.mdx" />