# 강의 소개

Hugging Face 강의에 오신 여러분들 환영합니다! 이번 강의 소개에서는 작업 환경 설정에 대해 안내드리겠습니다. 방금 막 이번 과정을 시작하셨다면 먼저 [Chapter 1](/course/chapter1) 내용을 살펴보고 돌아오신 뒤, 환경을 설정하여 코드를 직접 실행해보시길 추천드립니다.

이번 과정에서 사용할 모든 라이브러리는 파이썬 패키지를 통해 사용할 수 있으므로 여기서는 파이썬 환경 설정 방법 및 필요한 라이브러리 설치 방법을 보여드리겠습니다.

작업 환경 설정 방법으로 Colab 노트북을 이용한 방법과 파이썬 가상 환경을 이용한 방법, 두 가지를 다룰 것이고 둘 중 더 마음이 가는 방식을 자유롭게 선택하셔도 됩니다. 입문자의 경우 Colab 노트북을 이용하시길 강력하게 추천합니다.

여기서 Windows 환경에 대해서는 다루지 않기 때문에 Windows에서 실행 중이시면 Colab 노트북을 이용해 아래 과정을 따라가 주시길 권장드립니다. Linux 혹은 macOS를 실행 중이시라면 어떤 방식을 택해도 무방합니다.

대부분의 강의는 여러분이 Hugging Face 계정이 있다는 것을 전제로 하기 때문에 지금 바로 계정을 생성하시길 추천드립니다: [계정 생성하기](https://huggingface.co/join)

## Google Colab 노트북 사용하기

Colab 노트북은 가장 쉬운 설정 방식입니다. 브라우저에 Colab 노트북을 켜고 바로 코딩을 시작하시면 됩니다!

Colab에 익숙하지 않으시다면 [introduction](https://colab.research.google.com/notebooks/intro.ipynb) 링크를 따라 시작하시길 권장드립니다. Colab에서는 GPU, TPU와 같은 가속 하드웨어를 사용할 수 있으며 적은 양의 워크로드에 대해서는 무료입니다.

Colab과 친숙해 지셨다면 새로운 노트북을 생성하여 아래와 같이 시작합니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

다음으로, 이번 강의에서 사용할 라이브러리를 설치합니다. 설치에는 파이썬 패키지 관리자인 `pip` 를 사용하도록 하겠습니다. 노트북 파일에서는 시스템 명령어 앞에 `!` 를 붙여 실행시킬 수 있으므로, 아래와 같이 🤗 Transformers 라이브러리를 설치할 수 있습니다:

```
!pip install transformers
```

이제 파이썬 런타임에 패키지를 가져와 패키지가 제대로 설치되었는지 확인해보겠습니다:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

위의 방식으로는 아주 가벼운 버전의 🤗 Transformers가 설치되고, 이는 PyTorch나 TensorFlow와 같은 특정 기계학습 프레임워크를 포함하지 않습니다. 하지만 본 강의에서는 이 라이브러리의 아주 다양한 기능들을 사용할 예정이므로, 아래의 명령어를 통해 대부분의 예제에 필요한 종속성(dependency)을 제공하는 개발 버전을 설치하시길 바랍니다:

```
!pip install transformers[sentencepiece]
```

설치에 시간이 조금 걸리지만 곧 강의를 위한 준비가 모두 끝납니다!

## 파이썬 가상 환경 사용하기

파이썬 가상 환경 사용을 원하신다면 먼저 파이썬을 설치해야 합니다. 이 [가이드](https://realpython.com/installing-python/)를 따라 설치를 진행하실 수 있습니다.

파이썬 설치가 완료되면 터미널에서 파이썬 명령어를 실행할 수 있습니다. 다음 단계로 넘어가기 전에, 다음과 같은 명령어를 실행하여 설치가 잘 되었는지 확인하세요: `python --version`. 이 때 시스템에 사용할 수 있는 파이썬 버전을 출력되어야 합니다.

터미널에서 `python --version` 과 같은 파이썬 명령어를 실행하면, 명령어를 실행하는 프로그램을 시스템의 “메인(main)” 파이썬으로 생각해야 합니다. 이 메인 파이썬은 어떤 패키지도 설치하지 않은 상태로 유지하면서, 작업 중인 각 어플리케이션마다 별도의 환경을 생성하여 이용하는 것을 권장합니다. 이렇게 하면, 각 어플리케이션은 각각의 의존성 및 패키지를 갖게 되어 다른 어플리케이션과의 잠재적 호환성 문제를 피할 수 있습니다.

파이썬에서 이는 [*가상 환경*](https://docs.python.org/3/tutorial/venv.html)을 통해 완수됩니다. 가상 환경은 자체 포함 디렉토리 트리로, 각 트리는 어플리케이션에게 필요한 모든 패키지와 함께 특정 파이썬 버전에 대한 파이썬 설치를 포함합니다. 이러한 가상 환경을 생성하는 방법은 여러 툴을 통해 할 수 있지만, 여기서는 공식 파이썬 패키지인 `[venv](https://docs.python.org/3/library/venv.html#module-venv)` 를 통해 생성해 보겠습니다.

먼저, 어플리케이션을 넣어줄 디렉토리를 생성합니다. 예를 들어, 홈 디렉토리의 *transformers-course*와 같은 이름의 디렉토리를 만들어 봅시다:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

디렉토리 내부에서, 파이썬 `venv` 모듈을 사용하여 가상 환경을 생성합니다:

```
python -m venv .env
```

원래 아무것도 없던 빈 폴더에 *.env*라는 디렉토리가 생기게 됩니다:

```
ls -a
```

```out
.      ..    .env
```

`activate` 스크립트를 통해 가상 환경으로 접속할 수 있고, `deactivate` 를 통해 가상 환경 밖으로 나올 수 있습니다:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

환경이 제대로 활성화 되었는지 `which python` 명령어를 실행하여 확인해 봅시다. 아래와 같이 가상 환경을 보여준다면 제대로 활성화가 것입니다!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### 의존성(dependencies) 설치하기

Google Colab 사용법에서와 마찬가지로 다음 단계로 넘어가기 위해 패키지를 설치해야 합니다. 여기서도, `pip` 패키지 관리자를 통해  🤗 Transformers 개발 버전을 설치할 수 있습니다:

```
pip install "transformers[sentencepiece]"
```

이제 모든 환경 설정을 마치고 시작할 준비가 되었습니다!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter0/1.mdx" />