# 자연어 처리(Natural Language Processing)

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

트랜스포머 모델을 공부하기에 앞서 자연어 처리(NLP)가 무엇인지, 그리고 왜 NLP가 중요한지 빠르고 간단하게 살펴보겠습니다.

## NLP가 무엇인가요?

NLP(Natural Language Processing)란 사람의 언어와 관련된 모든 것을 이해하는 데에 중점을 둔 언어학 및 기계 학습(머신 러닝) 분야를 말합니다. NLP의 목적은 단순히 하나의 개별 단어를 이해하는 것을 넘어, 해당 단어들의 문맥을 이해하는 것입니다.

아래는 가장 일반적인 NLP 작업과 그 예시입니다:

- **전체 문장 분류**: 리뷰에 드러난 감정 파악하기, 스팸 메일 분류하기, 문장이 문법적으로 올바른지 혹은 문장 쌍이 논리적으로 관련이 있는지 없는지 결정하기
- **문장 내 단어 분류**: 문장 구성 성분(명사, 동사, 형용사 등) 혹은 개체명(사람, 장소, 기관) 식별하기
- **텍스트 컨텐츠 생성**: 자동 생성 텍스트로 프롬프트 작성하기, 텍스트 내 마스킹 된 단어의 빈칸 채우기
- **텍스트 안에서 정답 추출하기**: 지문과 질의가 주어질 때 지문에 주어진 정보를 이용해 질의에 대한 정답 추출하기
- **입력 텍스트로부터 새로운 문장 생성하기**: 입력 텍스트를 다른 언어로 번역하거나, 요약하기

하지만 NLP는 위와 같은 텍스트 처리에만 제한되지 않습니다. NLP에서는 오디오 샘플의 스크립트 생성 및 이미지의 설명문 생성과 같이 음성 인식과 컴퓨터 비전 분야에서의 까다로운 문제 또한 다룹니다.

## 왜 NLP가 어렵나요?

컴퓨터와 사람은 서로 정보를 처리하는 방식이 다릅니다. 이를테면, “나는 배고파”라는 문장을 읽을 때 우리는 바로 그 의미를 이해할 수 있습니다. 마찬가지로 사람은 “나는 배고파”, “나 슬퍼”와 같은 문장 쌍이 주어질 때, 두 문장이 얼마나 유사한지 쉽게 판단할 수 있습니다. 그러나, 기계 학습 모델은 사람만큼 이를 쉽게 할 수 없습니다. 우선 모델이 텍스트를 학습할 수 있도록 텍스트가 처리 과정을 거쳐야 하는데, 사람의 언어 체계는 매우 복잡하기 때문에 이러한 처리가 어떻게 이루어져야 하는지 면밀히 고민해야 합니다. 따라서 텍스트 표현 방법과 관련한 수많은 연구가 진행되어 왔고, 다음 챕터에서 그 중 몇 가지 방법들을 소개해드리겠습니다.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter1/2.mdx" />