# Construindo um cartão para o modelo

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

O cartão para o modelo (model card) é um arquivo que é discutivelmente tão importante quanto os arquivos modelo e tokenizer em um repositório modelo. É a definição central do modelo, garantindo a reutilização pelos membros da comunidade e a reprodutibilidade dos resultados, e fornecendo uma plataforma sobre a qual outros membros podem construir seus artefatos. 

Documentar o processo de treinamento e avaliação ajuda outros a entender o que esperar de um modelo - e fornecer informações suficientes sobre os dados que foram utilizados e o pré e pós-processamento que foram feitos garante que as limitações, enviesamentos e contextos nos quais o modelo é e não é útil possam ser identificados e compreendidos.

Portanto, criar um model card que defina claramente seu modelo é um passo muito importante. Aqui, fornecemos algumas dicas que o ajudarão com isto. A criação do model card é feita através do arquivo *README.md* que você viu anteriormente, que é um arquivo Markdown.

O conceito de "model card" tem origem em uma direção de pesquisa do Google, primeiro compartilhada no artigo ["Model Cards for Model Reporting"](https://arxiv.org/abs/1810.03993) de Margaret Mitchell et al. Muitas das informações contidas aqui são baseadas nesse artigo, e recomendamos que você dê uma olhada nele para entender por que os cartões modelo são tão importantes em um mundo que valoriza a reprodutibilidade, a reusabilidade e a justiça.

O model card geralmente começa com uma visão geral muito breve e de alto nível do que o modelo serve, seguida por detalhes adicionais nas seções seguintes:

- Descrição do modelo
- Usos e limitações
- Como usar
- Dados de treinamento 
- Procedimento de treinamento
- Resultados da avaliação 

Vamos dar uma olhada no que cada uma dessas seções deve conter.

### Descrição do modelo

A descrição do modelo fornece detalhes básicos sobre o modelo. Isto inclui a arquitetura, versão, se foi introduzida em um artigo, se uma implementação original está disponível, o autor, e informações gerais sobre o modelo. Qualquer direito autoral deve ser atribuído aqui. Informações gerais sobre procedimentos de treinamento, parâmetros e renúncias importantes também podem ser mencionadas nesta seção.

### Usos e limitações

Aqui você descreve os casos de uso a que o modelo se destina, incluindo os idiomas, campos e domínios onde ele pode ser aplicado. Esta seção do cartão modelo também pode documentar áreas que são conhecidas por estarem fora do escopo do modelo, ou onde é provável que ele tenha um desempenho subótimo.

### Como usar

Esta seção deve incluir alguns exemplos de como utilizar o modelo. Isto pode mostrar a utilização da função `pipeline()`, utilização do modelo e classes de tokenizer, e qualquer outro código que você acha que possa ser útil.

### Dados de treinamento 

Esta parte deve indicar em que conjunto(s) de dados o modelo foi treinado. Uma breve descrição do(s) conjunto(s) de dados também é bem-vinda.

### Procedimento de treinamento

Nesta seção você deve descrever todos os aspectos relevantes do treinamento que são úteis a partir de uma perspectiva de reprodutibilidade. Isto inclui qualquer pré-processamento e pós-processamento que foram feitos nos dados, assim como detalhes como o número de épocas para as quais o modelo foi treinado, o tamanho do lote, a taxa de aprendizado, etc.

### Variáveis e métricas

Aqui você deve descrever as métricas que você usa para avaliação e os diferentes fatores que você está mensurando. A menção de qual(is) métrica(s) foi utilizada(s), em qual conjunto de dados e qual divisão de conjunto de dados facilita a comparação do desempenho do seu modelo em comparação com o de outros modelos. Estes devem ser informados pelas seções anteriores, tais como os usuários pretendidos e os casos de uso.

### Resultados da avaliação 

Finalmente, fornecer uma indicação de quão bem o modelo funciona no conjunto de dados de avaliação. Se o modelo utiliza um limiar de decisão, ou fornecer o limiar de decisão utilizado na avaliação, ou fornecer detalhes sobre a avaliação em diferentes limiares para os usos pretendidos.

## Exemplo

Confira a seguir alguns exemplos de model card bem elaborados:

- [`bert-base-cased`](https://huggingface.co/bert-base-cased)
- [`gpt2`](https://huggingface.co/gpt2)
- [`distilbert`](https://huggingface.co/distilbert-base-uncased)

Mais exemplos de diferentes organizações e empresas estão disponíveis [aqui](https://github.com/huggingface/model_card/blob/master/examples.md).

## Nota

Model cards are not a requirement when publishing models, and you don't need to include all of the sections described above when you make one. However, explicit documentation of the model can only benefit future users, so we recommend that you fill in as many of the sections as possible to the best of your knowledge and ability. 

## Model card metadata

Os model card não são uma exigência quando se publica modelos, e não é necessário incluir todas as seções descritas acima quando se faz um. Entretanto, a documentação explícita do modelo só pode beneficiar futuros usuários, por isso recomendamos que você preencha o maior número possível de seções com o melhor de seu conhecimento e capacidade. 


Por exemplo, se você der uma olhada no model card [`camembert-base`(https://huggingface.co/camembert-base/blob/main/README.md), você deve ver as seguintes linhas no cabeçalho do model card:

```
---
language: fr
license: mit
datasets:
- oscar
---

```
Estes metadados são analisados pelo Hugging Face Hub, que então identifica este modelo como sendo um modelo francês, com uma licença MIT, treinado no conjunto de dados Oscar. 

A [especificação completa do model card](https://github.com/huggingface/hub-docs/blame/main/modelcard.md) permite especificar idiomas, licenças, tags, conjuntos de dados, métricas, assim como os resultados da avaliação do modelo obtido no treinamento. 


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter4/4.mdx" />