# Questionário de fim de capítulo

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>
Este capítulo cobriu muita coisa! Não se preocupe se você não entendeu todos os detalhes; os próximos capítulos o ajudarão a entender como as coisas funcionam.

Antes de prosseguir, vamos testar o que você aprendeu neste capítulo.

### 1. A função `load_dataset()` em 🤗 Datasets permite carregar um dataset de qual dos seguintes locais?

<Question
	choices={[
		{
			text: "Localmente, por exemplo no seu laptop",
			explain: "Correto! Você pode passar os caminhos dos arquivos locais para o argumento <code>data_files</code> de <code>load_dataset()</code> para carregar conjuntos de dados localmente.",
			correct: true
		},
		{
			text: "Do Hugging Face Hub",
			explain: "Correto! Você pode carregar conjuntos de dados no Hub fornecendo o ID do conjunto de dados, por exemplo, <code>load_dataset('emotion')</code>.",
			correct: true
		},
		{
			text: "De um servidor remoto",
			explain: "Correto! Você pode passar URLs para o argumento <code>data_files</code> de <code>load_dataset()</code> para carregar arquivos remotos.",
			correct: true
		},
	]}
/>
### 2. Suponha que você carregue uma das tarefas GLUE da seguinte forma:

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

Qual dos seguintes comandos produzirá uma amostra aleatória de 50 elementos do `conjunto de dados`?

<Question
	choices={[
		{
			text: "<code>dataset.sample(50)</code>",
			explain: "Isso está incorreto -- não há método <code>Dataset.sample()</code>."
		},
		{
			text: "<code>dataset.shuffle().select(range(50))</code>",
			explain: "Correto! Como você viu neste capítulo, você primeiro embaralha o conjunto de dados e depois seleciona as amostras dele.",
			correct: true
		},
		{
			text: "<code>dataset.select(range(50)).shuffle()</code>",
			explain: "Isso está incorreto - embora o código seja executado, ele embaralha apenas os primeiros 50 elementos do conjunto de dados."
		}
	]}
/>

### 3. Suponha que você tenha um conjunto de dados sobre animais domésticos chamado `pets_dataset`, que tem uma coluna `name` que denota o nome de cada animal. Qual das seguintes abordagens permitiria filtrar o conjunto de dados para todos os animais de estimação cujos nomes começam com a letra "L"?

<Question
	choices={[
		{
			text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
			explain: "Correto! Usar uma função lambda do Python para esses filtros rápidos é uma ótima ideia. Você consegue pensar em outra solução?",
			correct: true
		},
		{
			text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
			explain: "Isso está incorreto -- uma função lambda assume a forma geral <code>lambda *arguments* : *expression*</code>, então você precisa fornecer argumentos neste caso."
		},
		{
			text: "Criar uma função assim <code>def filter_names(x): return x['name'].startswith('L')</code> e executa-la <code>pets_dataset.filter(filter_names)</code>.",
			explain: "Correto! Assim como com <code>Dataset.map()</code>, você pode passar funções explícitas para <code>Dataset.filter()</code>. Isso é útil quando você tem alguma lógica complexa que não é adequado para uma função lambda curta. Qual das outras soluções funcionaria?",
			correct: true
		}
	]}
/>

### 4. O que é mapeamento de memória?

<Question
	choices={[
		{
			text: "Um mapeamento entre CPU e GPU RAM",
			explain: "Não é isso - tente novamente!",
		},
		{
			text: "Um mapeamento entre RAM e armazenamento do sistema de arquivos",
			explain: "Correto! Os 🤗 Datasets tratam cada conjunto de dados como um arquivo mapeado na memória. Isso permite que a biblioteca acesse e opere em elementos do conjunto de dados sem precisar carregá-lo totalmente na memória.",
			correct: true
		},
		{
			text: "Um mapeamento entre dois arquivos no cache 🤗 Datasets",
			explain: "Isto não está correto - tente novamente!"
		}
	]}
/>

### 5. Quais dos seguintes são os principais benefícios do mapeamento de memória?

<Question
	choices={[
		{
			text: "Acessar arquivos mapeados na memória é mais rápido do que ler ou gravar no disco.",
			explain: "Correto! Isso permite que 🤗 Datasets sejam extremamente rápidos. Mas esse não é o único benefício.",
			correct: true
		},
		{
			text: "As aplicações podem acessar segmentos de dados em um arquivo extremamente grande sem precisar ler o arquivo inteiro na RAM primeiro.",
			explain: "Correto! Isso permite que 🤗 Datasets carregue conjuntos de dados de vários gigabytes em seu laptop sem explodir sua CPU. Que outra vantagem o mapeamento de memória oferece?",
			correct: true
		},
		{
			text: "Consome menos energia, então sua bateria dura mais.",
			explain: "Isto não está correto - tente novamente!"
		}
	]}
/>

### 6. Por que o código a seguir falha?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
	choices={[
		{
			text: "Ele tenta fazer stream de um conjunto de dados grande demais para caber na RAM.",
			explain: "Isso não está correto - conjuntos de dados de streaming são descompactados em tempo real e você pode processar conjuntos de dados de terabytes com muito pouca RAM!",
		},
		{
			text: "Ele tenta acessar um <code>IterableDataset</code>.",
			explain: "Correto! Um <code>IterableDataset</code> é um gerador, não um contêiner, então você deve acessar seus elementos usando <code>next(iter(dataset))</code>.",
			correct: true
		},
		{
			text: "O conjunto de dados <code>allocine</code> não tem uma divisão <code>train</code>.",
			explain: "Isso está incorreto - confira o cartão de conjunto de dados [<code>allocine</code>](https://huggingface.co/datasets/allocine) no Hub para ver quais divisões ele contém."
		}
	]}
/>

### 7. Quais dos seguintes são os principais benefícios de criar um cartão de conjunto de dados?

<Question
	choices={[
		{
			text: "Ele fornece informações sobre o uso pretendido e as tarefas suportadas do conjunto de dados para que outras pessoas na comunidade possam tomar uma decisão informada sobre o uso.",
			explain: "Correto! Conjuntos de dados não documentados podem ser usados para treinar modelos que podem não refletir as intenções dos criadores do conjunto de dados ou podem produzir modelos cujo status legal é obscuro se forem treinados em dados que violam restrições de privacidade ou licenciamento. Este não é o único benefício, no entanto!",
			correct : true
		},
		{
			text: "Ajuda a chamar a atenção para os preconceitos que estão presentes em um corpus.",
			explain: "Correto! Quase todos os conjuntos de dados têm algum tipo de viés, o que pode produzir consequências negativas em contrapartida. Estar ciente disso ajuda os criadores de modelos a entender como lidar com os vieses. Em que mais os cartões de conjunto de dados ajudam?",
			correct : true
		},
		{
			text: "Melhora as chances de que outras pessoas da comunidade usem meu conjunto de dados.",
			explain: "Correto! Um cartão de conjunto de dados bem escrito tenderá a aumentar o uso de seu precioso conjunto de dados. Que outros benefícios ele oferece?",
			correct: true
		},
	]}
/>

### 8. O que é pesquisa semântica?

<Question
	choices={[
		{
			text: "Uma maneira de pesquisar correspondências exatas entre as palavras em uma consulta e os documentos em um corpus",
			explain: "Isso está incorreto - esse tipo de pesquisa é chamado de *pesquisa léxica* e é o que você normalmente vê nos mecanismos de pesquisa tradicionais."
		},
		{
			text: "Uma maneira de pesquisar documentos correspondentes entendendo o significado contextual de uma consulta",
			explain: "Correto! A pesquisa semântica usa vetores incorporados para representar consultas e documentos e usa uma métrica de similaridade para medir a quantidade de sobreposição entre eles. De que outra forma você poderia descrevê-la?",
			correct: true
		},
		{
			text: "Uma maneira de melhorar a precisão da pesquisa",
			explain: "Correto! Os mecanismos de pesquisa semântica podem capturar a intenção de uma consulta muito melhor do que a correspondência de palavras-chave e normalmente recuperam documentos com maior precisão. Mas essa não é a única resposta certa - o que mais a pesquisa semântica oferece?",
			correct: true
		}
	]}
/>

### 9. Para pesquisa semântica assimétrica, você geralmente tem:

<Question
	choices={[
		{
			text: "Uma consulta curta e um parágrafo mais longo que responde à consulta",
			explain: "Correto!",
			correct : true
		},
		{
			text: "Consultas e parágrafos com aproximadamente o mesmo tamanho",
			explain: "Este é realmente um exemplo de pesquisa semântica simétrica - tente novamente!"
		},
		{
			text: "Uma consulta longa e um parágrafo mais curto que responde à consulta",
			explain: "Isso está incorreto - tente novamente!"
		}
	]}
/>

### 10. Posso usar 🤗 Datasets para carregar dados para uso em outros domínios, como processamento de fala (audios)?

<Question
	choices={[
		{
			text: "Não",
			explain: "Isso está incorreto -- 🤗 Datasets atualmente suporta dados tabulares, áudio e de visão computacional. Confira o <a href='https://huggingface.co/datasets/mnist'>conjunto de dados MNIST</a> no Hub para um exemplo de visão computacional."
		},
		{
			text: "Sim",
			explain: "Correto! Confira os desenvolvimentos interessantes com fala e visão na biblioteca 🤗 Transformers para ver como 🤗 Datasets é usado nesses domínios.",
			correct : true
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter5/8.mdx" />