import{s as Wt,a as st,n as Rt,o as Vt}from"../chunks/scheduler.893fe8c9.js";import{S as Qt,i as Xt,e as s,s as i,c as d,h as Pt,a as r,d as a,b as n,f as ce,g as M,j as o,k as u,l as Yt,m as l,n as f,t as y,o as w,p as T}from"../chunks/index.6ee278c6.js";import{C as Nt,H as oe,E as Dt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea3ad860.js";import{C as rt}from"../chunks/CodeBlock.8bdd5f33.js";import{C as Ft}from"../chunks/CourseFloatingBanner.c25cfa5e.js";function Kt(ot){let J,me,ue,de,h,Me,j,fe,b,ye,v,ut=`În această secțiune, vom examina mai îndeaproape clasa <code>Interface</code> și vom înțelege
parametrii principali folosiți pentru a crea una.`,we,U,Te,C,pt="Veți observa că clasa <code>Interface</code> are 3 parametri necesari:",Je,I,ct="<code>Interface(fn, inputs, outputs, ...)</code>",he,g,mt="Acești parametri sunt:",je,x,dt="<li><code>fn</code>: funcția de predicție care este încapsulată de interfața Gradio. Această funcție poate lua unul sau mai mulți parametri și poate returna una sau mai multe valori</li> <li><code>inputs</code>: tipul(tipurile) componentei de intrare. Gradio oferă multe componente pre-construite precum <code>&quot;image&quot;</code> sau <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: tipul(tipurile) componentei de ieșire. Din nou, Gradio oferă multe componente pre-construite de ex. <code>&quot;image&quot;</code> sau <code>&quot;label&quot;</code>.</li>",be,$,Mt='Pentru o listă completă a componentelor, <a href="https://gradio.app/docs" rel="nofollow">consultați documentația Gradio</a>. Fiecare componentă pre-construită poate fi personalizată prin instanțierea clasei corespunzătoare componentei.',ve,k,ft=`De exemplu, așa cum am văzut în <a href="/course/chapter9/2">secțiunea anterioară</a>,
în loc să transmiteți <code>&quot;textbox&quot;</code> la parametrul <code>inputs</code>, puteți transmite o componentă <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> pentru a crea o cutie de text cu 7 linii și o etichetă.`,Ue,q,yt="Să aruncăm o privire la un alt exemplu, de data aceasta cu o componentă <code>Audio</code>.",Ce,_,Ie,A,wt=`Așa cum am menționat mai devreme, Gradio oferă multe intrări și ieșiri diferite.
Deci să construim o <code>Interface</code> care funcționează cu audio.`,ge,B,Tt=`În acest exemplu, vom construi o funcție audio-la-audio care primește un
fișier audio și pur și simplu îl inversează.`,xe,H,Jt=`Vom folosi pentru intrare componenta <code>Audio</code>. Când folosiți componenta <code>Audio</code>,
puteți specifica dacă doriți ca <code>source</code>-ul audio să fie un fișier pe care utilizatorul
îl încarcă sau un microfon cu care utilizatorul își înregistrează vocea. În acest caz, să
o setăm la <code>&quot;microphone&quot;</code>. Doar pentru distracție, vom adăuga o etichetă la <code>Audio</code>-ul nostru care spune
“Vorbiți aici…“.`,$e,G,ht=`În plus, am dori să primim audio-ul ca un array numpy pentru a putea cu ușurință
să îl “inversăm”. Deci vom seta <code>&quot;type&quot;</code>-ul să fie <code>&quot;numpy&quot;</code>, care transmite datele de intrare
ca un tuplu de (<code>sample_rate</code>, <code>data</code>) în funcția noastră.`,ke,Z,jt=`Vom folosi și componenta de ieșire <code>Audio</code> care poate reda automat
un tuplu cu o rată de eșantionare și un array numpy de date ca fișier audio redabil.
În acest caz, nu avem nevoie să facem nicio personalizare, deci vom folosi scurtătura string
<code>&quot;audio&quot;</code>.`,qe,L,_e,E,bt=`Codul de mai sus va produce o interfață ca cea de mai jos (dacă browserul dvs. nu
vă cere permisiuni pentru microfon, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">deschideți demo-ul într-o filă separată</a>.)`,Ae,p,vt,Be,z,Ut="Acum ar trebui să puteți să vă înregistrați vocea și să vă auziți vorbind în sens invers - înfricoșător 👻!",He,S,Ge,W,Ct=`Să spunem că avem o funcție mai complicată, cu intrări și ieșiri multiple.
În exemplul de mai jos, avem o funcție care primește un index dropdown, o valoare slider și un număr,
și returnează un eșantion audio al unui ton muzical.`,Ze,R,It=`Priviți cum transmitem o listă de componente de intrare și ieșire,
și vedeți dacă puteți urmări ce se întâmplă.`,Le,V,gt="Cheia aici este că atunci când transmiteți:",Ee,Q,xt="<li>o listă de componente de intrare, fiecare componentă corespunde unui parametru în ordine.</li> <li>o listă de componente de ieșire, fiecare componentă corespunde unei valori returnate.</li>",ze,X,$t="Fragmentul de cod de mai jos arată cum trei componente de intrare se aliniază cu cei trei argumente ai funcției <code>generate_tone()</code>:",Se,P,We,c,kt,Re,Y,Ve,N,qt=`Până acum, am folosit metoda <code>launch()</code> pentru a lansa interfața, dar nu
am discutat cu adevărat ce face.`,Qe,D,_t=`În mod implicit, metoda <code>launch()</code> va lansa demo-ul într-un server web care
rulează local. Dacă rulați codul într-un notebook Jupyter sau Colab, atunci
Gradio va incorpora interfața GUI demo în notebook pentru a o putea folosi cu ușurință.`,Xe,F,At="Puteți personaliza comportamentul <code>launch()</code> prin parametri diferiți:",Pe,K,Bt="<li><code>inline</code> - dacă să afișeze interfața inline în notebook-urile Python.</li> <li><code>inbrowser</code> - dacă să lanseze automat interfața într-o filă nouă în browserul implicit.</li> <li><code>share</code> - dacă să creeze un link partajabil public de pe calculatorul dvs. pentru interfață. Cam ca un link Google Drive!</li>",Ye,O,Ht="Vom acoperi parametrul <code>share</code> în mult mai multe detalii în următoarea secțiune!",Ne,ee,De,te,Gt=`Să construim o interfață care vă permite să demonstrați un model de <strong>recunoaștere vocală</strong>.
Pentru a o face interesantă, vom accepta <em>fie</em> o intrare de microfon, fie un fișier încărcat.`,Fe,ae,Zt=`Ca de obicei, vom încărca modelul nostru de recunoaștere vocală folosind funcția <code>pipeline()</code> din 🤗 Transformers.
Dacă aveți nevoie de o reîmprospătare rapidă, puteți să vă întoarceți la <a href="/course/chapter1/3">acea secțiune din Capitolul 1</a>. Următorul, vom implementa o funcție <code>transcribe_audio()</code> care procesează audio-ul și returnează transcrierea. În final, vom încapsula această funcție într-o <code>Interface</code> cu componentele <code>Audio</code> pentru intrări și doar text pentru ieșire. În ansamblu, codul pentru această aplicație este următorul:`,Ke,le,Oe,ie,Lt='Dacă browserul dvs. nu vă cere permisiuni pentru microfon, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">deschideți demo-ul într-o filă separată</a>.',et,m,Et,tt,ne,zt=`Asta e! Acum puteți folosi această interfață pentru a transcrie audio. Observați aici că
prin transmiterea parametrului <code>optional</code> ca <code>True</code>, permitem utilizatorului să ofere fie
un microfon, fie un fișier audio (sau niciunul, dar asta va returna un mesaj de eroare).`,at,se,St="Continuați să vedeți cum să vă partajați interfața cu alții!",lt,re,it,pe,nt;return h=new Nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new oe({props:{title:"Înțelegerea clasei Interface",local:"understanding-the-interface-class",headingTag:"h1"}}),b=new Ft({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),U=new oe({props:{title:"Cum să creați o Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),_=new oe({props:{title:"Un exemplu simplu cu audio",local:"a-simple-example-with-audio",headingTag:"h2"}}),L=new rt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlZvcmJpJUM4JTlCaSUyMGFpY2kuLi4lMjIpJTBBZ3IuSW50ZXJmYWNlKHJldmVyc2VfYXVkaW8lMkMlMjBtaWMlMkMlMjAlMjJhdWRpbyUyMikubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Vorbiți aici...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),S=new oe({props:{title:"Gestionarea intrărilor și ieșirilor multiple",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),P=new rt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLk51bWJlcih2YWx1ZSUzRDElMkMlMjBsYWJlbCUzRCUyMkR1cmF0YSUyMCVDMyVBRW4lMjBzZWN1bmRlJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTJDJTBBKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Number(value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Durata în secunde&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new oe({props:{title:"Metoda launch()",local:"the-launch-method",headingTag:"h3"}}),ee=new oe({props:{title:"✏️ Să aplicăm!",local:"lets-apply-it",headingTag:"h2"}}),le=new rt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCUyMnRleHQlMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio</span>):
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),re=new Dt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/3.mdx"}}),{c(){J=s("meta"),me=i(),ue=s("p"),de=i(),d(h.$$.fragment),Me=i(),d(j.$$.fragment),fe=i(),d(b.$$.fragment),ye=i(),v=s("p"),v.innerHTML=ut,we=i(),d(U.$$.fragment),Te=i(),C=s("p"),C.innerHTML=pt,Je=i(),I=s("p"),I.innerHTML=ct,he=i(),g=s("p"),g.textContent=mt,je=i(),x=s("ul"),x.innerHTML=dt,be=i(),$=s("p"),$.innerHTML=Mt,ve=i(),k=s("p"),k.innerHTML=ft,Ue=i(),q=s("p"),q.innerHTML=yt,Ce=i(),d(_.$$.fragment),Ie=i(),A=s("p"),A.innerHTML=wt,ge=i(),B=s("p"),B.textContent=Tt,xe=i(),H=s("p"),H.innerHTML=Jt,$e=i(),G=s("p"),G.innerHTML=ht,ke=i(),Z=s("p"),Z.innerHTML=jt,qe=i(),d(L.$$.fragment),_e=i(),E=s("p"),E.innerHTML=bt,Ae=i(),p=s("iframe"),Be=i(),z=s("p"),z.textContent=Ut,He=i(),d(S.$$.fragment),Ge=i(),W=s("p"),W.textContent=Ct,Ze=i(),R=s("p"),R.textContent=It,Le=i(),V=s("p"),V.textContent=gt,Ee=i(),Q=s("ul"),Q.innerHTML=xt,ze=i(),X=s("p"),X.innerHTML=$t,Se=i(),d(P.$$.fragment),We=i(),c=s("iframe"),Re=i(),d(Y.$$.fragment),Ve=i(),N=s("p"),N.innerHTML=qt,Qe=i(),D=s("p"),D.innerHTML=_t,Xe=i(),F=s("p"),F.innerHTML=At,Pe=i(),K=s("ul"),K.innerHTML=Bt,Ye=i(),O=s("p"),O.innerHTML=Ht,Ne=i(),d(ee.$$.fragment),De=i(),te=s("p"),te.innerHTML=Gt,Fe=i(),ae=s("p"),ae.innerHTML=Zt,Ke=i(),d(le.$$.fragment),Oe=i(),ie=s("p"),ie.innerHTML=Lt,et=i(),m=s("iframe"),tt=i(),ne=s("p"),ne.innerHTML=zt,at=i(),se=s("p"),se.textContent=St,lt=i(),d(re.$$.fragment),it=i(),pe=s("p"),this.h()},l(e){const t=Pt("svelte-u9bgzb",document.head);J=r(t,"META",{name:!0,content:!0}),t.forEach(a),me=n(e),ue=r(e,"P",{}),ce(ue).forEach(a),de=n(e),M(h.$$.fragment,e),Me=n(e),M(j.$$.fragment,e),fe=n(e),M(b.$$.fragment,e),ye=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-r1wiui"&&(v.innerHTML=ut),we=n(e),M(U.$$.fragment,e),Te=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ezgnph"&&(C.innerHTML=pt),Je=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-5xxju6"&&(I.innerHTML=ct),he=n(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-157p8ns"&&(g.textContent=mt),je=n(e),x=r(e,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-1xvsqts"&&(x.innerHTML=dt),be=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-qb39kw"&&($.innerHTML=Mt),ve=n(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1h06mwz"&&(k.innerHTML=ft),Ue=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1ef0tzf"&&(q.innerHTML=yt),Ce=n(e),M(_.$$.fragment,e),Ie=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1ust65o"&&(A.innerHTML=wt),ge=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-z9d0lu"&&(B.textContent=Tt),xe=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-12uaqlg"&&(H.innerHTML=Jt),$e=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-wf2al6"&&(G.innerHTML=ht),ke=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1n6q2hn"&&(Z.innerHTML=jt),qe=n(e),M(L.$$.fragment,e),_e=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-yej8wy"&&(E.innerHTML=bt),Ae=n(e),p=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(p).forEach(a),Be=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-14hovvy"&&(z.textContent=Ut),He=n(e),M(S.$$.fragment,e),Ge=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1twskrf"&&(W.textContent=Ct),Ze=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-64mj0s"&&(R.textContent=It),Le=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-telr1b"&&(V.textContent=gt),Ee=n(e),Q=r(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1t2glab"&&(Q.innerHTML=xt),ze=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-4ygbqe"&&(X.innerHTML=$t),Se=n(e),M(P.$$.fragment,e),We=n(e),c=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(c).forEach(a),Re=n(e),M(Y.$$.fragment,e),Ve=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1ige77d"&&(N.innerHTML=qt),Qe=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-q3eb2l"&&(D.innerHTML=_t),Xe=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-8ffzly"&&(F.innerHTML=At),Pe=n(e),K=r(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-1fu5yup"&&(K.innerHTML=Bt),Ye=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-exgvul"&&(O.innerHTML=Ht),Ne=n(e),M(ee.$$.fragment,e),De=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-9whxpr"&&(te.innerHTML=Gt),Fe=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1p1xjzp"&&(ae.innerHTML=Zt),Ke=n(e),M(le.$$.fragment,e),Oe=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-10rt9lb"&&(ie.innerHTML=Lt),et=n(e),m=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(m).forEach(a),tt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1wka5dp"&&(ne.innerHTML=zt),at=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-7ctsba"&&(se.textContent=St),lt=n(e),M(re.$$.fragment,e),it=n(e),pe=r(e,"P",{}),ce(pe).forEach(a),this.h()},h(){u(J,"name","hf:doc:metadata"),u(J,"content",Ot),st(p.src,vt="https://course-demos-audio-reverse.hf.space")||u(p,"src",vt),u(p,"frameborder","0"),u(p,"height","250"),u(p,"title","Gradio app"),u(p,"class","container p-0 flex-grow space-iframe"),u(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),st(c.src,kt="https://course-demos-generate-tone.hf.space")||u(c,"src",kt),u(c,"frameborder","0"),u(c,"height","450"),u(c,"title","Gradio app"),u(c,"class","container p-0 flex-grow space-iframe"),u(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),st(m.src,Et="https://course-demos-asr.hf.space")||u(m,"src",Et),u(m,"frameborder","0"),u(m,"height","550"),u(m,"title","Gradio app"),u(m,"class","container p-0 flex-grow space-iframe"),u(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Yt(document.head,J),l(e,me,t),l(e,ue,t),l(e,de,t),f(h,e,t),l(e,Me,t),f(j,e,t),l(e,fe,t),f(b,e,t),l(e,ye,t),l(e,v,t),l(e,we,t),f(U,e,t),l(e,Te,t),l(e,C,t),l(e,Je,t),l(e,I,t),l(e,he,t),l(e,g,t),l(e,je,t),l(e,x,t),l(e,be,t),l(e,$,t),l(e,ve,t),l(e,k,t),l(e,Ue,t),l(e,q,t),l(e,Ce,t),f(_,e,t),l(e,Ie,t),l(e,A,t),l(e,ge,t),l(e,B,t),l(e,xe,t),l(e,H,t),l(e,$e,t),l(e,G,t),l(e,ke,t),l(e,Z,t),l(e,qe,t),f(L,e,t),l(e,_e,t),l(e,E,t),l(e,Ae,t),l(e,p,t),l(e,Be,t),l(e,z,t),l(e,He,t),f(S,e,t),l(e,Ge,t),l(e,W,t),l(e,Ze,t),l(e,R,t),l(e,Le,t),l(e,V,t),l(e,Ee,t),l(e,Q,t),l(e,ze,t),l(e,X,t),l(e,Se,t),f(P,e,t),l(e,We,t),l(e,c,t),l(e,Re,t),f(Y,e,t),l(e,Ve,t),l(e,N,t),l(e,Qe,t),l(e,D,t),l(e,Xe,t),l(e,F,t),l(e,Pe,t),l(e,K,t),l(e,Ye,t),l(e,O,t),l(e,Ne,t),f(ee,e,t),l(e,De,t),l(e,te,t),l(e,Fe,t),l(e,ae,t),l(e,Ke,t),f(le,e,t),l(e,Oe,t),l(e,ie,t),l(e,et,t),l(e,m,t),l(e,tt,t),l(e,ne,t),l(e,at,t),l(e,se,t),l(e,lt,t),f(re,e,t),l(e,it,t),l(e,pe,t),nt=!0},p:Rt,i(e){nt||(y(h.$$.fragment,e),y(j.$$.fragment,e),y(b.$$.fragment,e),y(U.$$.fragment,e),y(_.$$.fragment,e),y(L.$$.fragment,e),y(S.$$.fragment,e),y(P.$$.fragment,e),y(Y.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(re.$$.fragment,e),nt=!0)},o(e){w(h.$$.fragment,e),w(j.$$.fragment,e),w(b.$$.fragment,e),w(U.$$.fragment,e),w(_.$$.fragment,e),w(L.$$.fragment,e),w(S.$$.fragment,e),w(P.$$.fragment,e),w(Y.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(re.$$.fragment,e),nt=!1},d(e){e&&(a(me),a(ue),a(de),a(Me),a(fe),a(ye),a(v),a(we),a(Te),a(C),a(Je),a(I),a(he),a(g),a(je),a(x),a(be),a($),a(ve),a(k),a(Ue),a(q),a(Ce),a(Ie),a(A),a(ge),a(B),a(xe),a(H),a($e),a(G),a(ke),a(Z),a(qe),a(_e),a(E),a(Ae),a(p),a(Be),a(z),a(He),a(Ge),a(W),a(Ze),a(R),a(Le),a(V),a(Ee),a(Q),a(ze),a(X),a(Se),a(We),a(c),a(Re),a(Ve),a(N),a(Qe),a(D),a(Xe),a(F),a(Pe),a(K),a(Ye),a(O),a(Ne),a(De),a(te),a(Fe),a(ae),a(Ke),a(Oe),a(ie),a(et),a(m),a(tt),a(ne),a(at),a(se),a(lt),a(it),a(pe)),a(J),T(h,e),T(j,e),T(b,e),T(U,e),T(_,e),T(L,e),T(S,e),T(P,e),T(Y,e),T(ee,e),T(le,e),T(re,e)}}}const Ot='{"title":"Înțelegerea clasei Interface","local":"understanding-the-interface-class","sections":[{"title":"Cum să creați o Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"Un exemplu simplu cu audio","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Gestionarea intrărilor și ieșirilor multiple","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"Metoda launch()","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Să aplicăm!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function ea(ot){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Qt{constructor(J){super(),Xt(this,J,ea,Kt,Wt,{})}}export{sa as component};
