# Fine-tuning supervizat

În [Capitolul 2 Secțiunea 2](/course/chapter2/2), am văzut că modelele de limbaj generativ pot fi ajustate pentru sarcini specifice, cum ar fi rezumarea și răspunsul la întrebări. Cu toate acestea, în zilele noastre este mult mai frecvent să ajustăm modelele de limbaj pe o gamă largă de sarcini simultan; o metodă cunoscută sub numele de fine-tuning supervizat (SFT). Acest proces ajută modelele să devină mai versatile și capabile să gestioneze diverse cazuri de utilizare. Majoritatea LLM-urilor cu care oamenii interacționează pe platforme precum ChatGPT au trecut prin SFT pentru a fi mai utile și aliniate cu preferințele umane. Vom împărți acest capitol în patru secțiuni:

## 1️⃣ Template-uri de chat

Template-urile de chat structurează interacțiunile dintre utilizatori și modelele AI, asigurând răspunsuri consecvente și adecvate contextual. Acestea includ componente precum prompturi de sistem și mesaje bazate pe roluri.

## 2️⃣ Fine-tuning supervizat

Fine-tuningul supervizat (SFT) este un proces critic pentru adaptarea modelelor de limbaj pre-antrenate la sarcini specifice. Aceasta implică antrenarea modelului pe un set de date specific sarcinii cu exemple etichetate. Pentru un ghid detaliat despre SFT, inclusiv pașii cheie și cele mai bune practici, consultați [secțiunea de fine-tuning supervizat din documentația TRL](https://huggingface.co/docs/trl/en/sft_trainer).

## 3️⃣ Adaptarea de rang scăzut (LoRA)

Adaptarea de rang scăzut (LoRA) este o tehnică pentru fine-tuningul modelelor de limbaj prin adăugarea de matrice de rang scăzut la straturile modelului. Aceasta permite un fine-tuning eficient păstrând în același timp cunoștințele pre-antrenate ale modelului. Unul dintre beneficiile cheie ale LoRA este economia semnificativă de memorie pe care o oferă, făcând posibilă ajustarea modelelor mari pe hardware cu resurse limitate.

## 4️⃣ Evaluarea

Evaluarea este un pas crucial în procesul de fine-tuning. Ne permite să măsurăm performanța modelului pe un set de date specific sarcinii.

<Tip>
⚠️ Pentru a beneficia de toate funcționalitățile disponibile cu Model Hub și 🤗 Transformers, recomandăm <a href="https://huggingface.co/join">crearea unui cont</a>.
</Tip>

## Referințe

- [Documentația Transformers despre template-urile de chat](https://huggingface.co/docs/transformers/main/en/chat_templating)
- [Script pentru fine-tuning supervizat în TRL](https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py)
- [`SFTTrainer` în TRL](https://huggingface.co/docs/trl/main/en/sft_trainer)
- [Lucrarea despre optimizarea directă a preferințelor](https://arxiv.org/abs/2305.18290)
- [Fine-tuning supervizat cu TRL](https://huggingface.co/docs/trl/sft_trainer)
- [Cum să faceți fine-tuning la Google Gemma cu ChatML și Hugging Face TRL](https://github.com/huggingface/alignment-handbook)  
- [Fine-tuning LLM pentru a genera cataloage de produse persane în format JSON](https://huggingface.co/learn/cookbook/en/fine_tuning_llm_to_generate_persian_product_catalogs_in_json_format) 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter11/1.mdx" />